/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSOESTextureFloat.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

class JSOESTextureFloatPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSOESTextureFloatPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSOESTextureFloatPrototype* ptr = new (NotNull, JSC::allocateCell<JSOESTextureFloatPrototype>(vm)) JSOESTextureFloatPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOESTextureFloatPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSOESTextureFloatPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOESTextureFloatPrototype, JSOESTextureFloatPrototype::Base);

/* Hash table for prototype */
const ClassInfo JSOESTextureFloatPrototype::s_info = { "OESTextureFloat"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESTextureFloatPrototype) };

void JSOESTextureFloatPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSOESTextureFloat::s_info = { "OESTextureFloat"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESTextureFloat) };

JSOESTextureFloat::JSOESTextureFloat(Structure* structure, JSDOMGlobalObject& globalObject, Ref<OESTextureFloat>&& impl)
    : JSDOMWrapper<OESTextureFloat>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, OESTextureFloat>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSOESTextureFloat::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSOESTextureFloatPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSOESTextureFloatPrototype::create(vm, &globalObject, structure);
}

JSObject* JSOESTextureFloat::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSOESTextureFloat>(vm, globalObject);
}

void JSOESTextureFloat::destroy(JSC::JSCell* cell)
{
    JSOESTextureFloat* thisObject = static_cast<JSOESTextureFloat*>(cell);
    thisObject->JSOESTextureFloat::~JSOESTextureFloat();
}

JSC::GCClient::IsoSubspace* JSOESTextureFloat::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSOESTextureFloat, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForOESTextureFloat.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForOESTextureFloat = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForOESTextureFloat.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForOESTextureFloat = std::forward<decltype(space)>(space); }
    );
}

void JSOESTextureFloat::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSOESTextureFloat*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSOESTextureFloatOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsOESTextureFloat = jsCast<JSOESTextureFloat*>(handle.slot()->asCell());
    auto& owner = jsOESTextureFloat->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from jsOESTextureFloat";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSOESTextureFloatOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsOESTextureFloat = static_cast<JSOESTextureFloat*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsOESTextureFloat->wrapped(), jsOESTextureFloat);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7OESTextureFloat@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore15OESTextureFloatE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<OESTextureFloat>&& impl)
{

    if constexpr (std::is_polymorphic_v<OESTextureFloat>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7OESTextureFloat@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore15OESTextureFloatE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // OESTextureFloat has subclasses. If OESTextureFloat has subclasses that get passed
        // to toJS() we currently require OESTextureFloat you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<OESTextureFloat>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, OESTextureFloat& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

OESTextureFloat* JSOESTextureFloat::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSOESTextureFloat*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
