/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSOESFBORenderMipmap.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

class JSOESFBORenderMipmapPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSOESFBORenderMipmapPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSOESFBORenderMipmapPrototype* ptr = new (NotNull, JSC::allocateCell<JSOESFBORenderMipmapPrototype>(vm)) JSOESFBORenderMipmapPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOESFBORenderMipmapPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSOESFBORenderMipmapPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOESFBORenderMipmapPrototype, JSOESFBORenderMipmapPrototype::Base);

/* Hash table for prototype */
const ClassInfo JSOESFBORenderMipmapPrototype::s_info = { "OESFBORenderMipmap"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESFBORenderMipmapPrototype) };

void JSOESFBORenderMipmapPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSOESFBORenderMipmap::s_info = { "OESFBORenderMipmap"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESFBORenderMipmap) };

JSOESFBORenderMipmap::JSOESFBORenderMipmap(Structure* structure, JSDOMGlobalObject& globalObject, Ref<OESFBORenderMipmap>&& impl)
    : JSDOMWrapper<OESFBORenderMipmap>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, OESFBORenderMipmap>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSOESFBORenderMipmap::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSOESFBORenderMipmapPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSOESFBORenderMipmapPrototype::create(vm, &globalObject, structure);
}

JSObject* JSOESFBORenderMipmap::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSOESFBORenderMipmap>(vm, globalObject);
}

void JSOESFBORenderMipmap::destroy(JSC::JSCell* cell)
{
    JSOESFBORenderMipmap* thisObject = static_cast<JSOESFBORenderMipmap*>(cell);
    thisObject->JSOESFBORenderMipmap::~JSOESFBORenderMipmap();
}

JSC::GCClient::IsoSubspace* JSOESFBORenderMipmap::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSOESFBORenderMipmap, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForOESFBORenderMipmap.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForOESFBORenderMipmap = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForOESFBORenderMipmap.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForOESFBORenderMipmap = std::forward<decltype(space)>(space); }
    );
}

void JSOESFBORenderMipmap::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSOESFBORenderMipmap*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSOESFBORenderMipmapOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsOESFBORenderMipmap = jsCast<JSOESFBORenderMipmap*>(handle.slot()->asCell());
    auto& owner = jsOESFBORenderMipmap->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from jsOESFBORenderMipmap";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSOESFBORenderMipmapOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsOESFBORenderMipmap = static_cast<JSOESFBORenderMipmap*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsOESFBORenderMipmap->wrapped(), jsOESFBORenderMipmap);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7OESFBORenderMipmap@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore18OESFBORenderMipmapE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<OESFBORenderMipmap>&& impl)
{

    if constexpr (std::is_polymorphic_v<OESFBORenderMipmap>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7OESFBORenderMipmap@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore18OESFBORenderMipmapE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // OESFBORenderMipmap has subclasses. If OESFBORenderMipmap has subclasses that get passed
        // to toJS() we currently require OESFBORenderMipmap you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<OESFBORenderMipmap>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, OESFBORenderMipmap& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

OESFBORenderMipmap* JSOESFBORenderMipmap::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSOESFBORenderMipmap*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
