/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMWrapper.h"
#include "JSEventTarget.h"
#include "Navigation.h"
#include <wtf/NeverDestroyed.h>

namespace WebCore {

class JSNavigation : public JSEventTarget {
public:
    using Base = JSEventTarget;
    using DOMWrapped = Navigation;
    static JSNavigation* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<Navigation>&& impl)
    {
        JSNavigation* ptr = new (NotNull, JSC::allocateCell<JSNavigation>(globalObject->vm())) JSNavigation(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);
    static Navigation* toWrapped(JSC::VM&, JSC::JSValue);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info(), JSC::NonArray);
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    template<typename, JSC::SubspaceAccess mode> static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        if constexpr (mode == JSC::SubspaceAccess::Concurrently)
            return nullptr;
        return subspaceForImpl(vm);
    }
    static JSC::GCClient::IsoSubspace* subspaceForImpl(JSC::VM& vm);
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
    Navigation& wrapped() const
    {
        return static_cast<Navigation&>(Base::wrapped());
    }

    Ref<Navigation> protectedWrapped() const;

protected:
    JSNavigation(JSC::Structure*, JSDOMGlobalObject&, Ref<Navigation>&&);

    DECLARE_DEFAULT_FINISH_CREATION;
};

class JSNavigationOwner final : public JSC::WeakHandleOwner {
public:
    bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::AbstractSlotVisitor&, const char**) final;
    void finalize(JSC::Handle<JSC::Unknown>, void* context) final;
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld&, Navigation*)
{
    static NeverDestroyed<JSNavigationOwner> owner;
    return &owner.get();
}

inline void* wrapperKey(Navigation* wrappableObject)
{
    return wrappableObject;
}

JSC::JSValue toJS(JSC::JSGlobalObject*, JSDOMGlobalObject*, Navigation&);
inline JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, Navigation* impl) { return impl ? toJS(lexicalGlobalObject, globalObject, *impl) : JSC::jsNull(); }
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject*, Ref<Navigation>&&);
inline JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RefPtr<Navigation>&& impl) { return impl ? toJSNewlyCreated(lexicalGlobalObject, globalObject, impl.releaseNonNull()) : JSC::jsNull(); }

template<> struct JSDOMWrapperConverterTraits<Navigation> {
    using WrapperClass = JSNavigation;
    using ToWrappedReturnType = Navigation*;
};
String convertEnumerationToString(Navigation::HistoryBehavior);
template<> JSC::JSString* convertEnumerationToJS(JSC::VM&, Navigation::HistoryBehavior);

template<> std::optional<Navigation::HistoryBehavior> parseEnumerationFromString<Navigation::HistoryBehavior>(const String&);
template<> std::optional<Navigation::HistoryBehavior> parseEnumeration<Navigation::HistoryBehavior>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<Navigation::HistoryBehavior>();

template<> Navigation::UpdateCurrentEntryOptions convertDictionary<Navigation::UpdateCurrentEntryOptions>(JSC::JSGlobalObject&, JSC::JSValue);

template<> Navigation::Options convertDictionary<Navigation::Options>(JSC::JSGlobalObject&, JSC::JSValue);

template<> Navigation::NavigateOptions convertDictionary<Navigation::NavigateOptions>(JSC::JSGlobalObject&, JSC::JSValue);

template<> Navigation::ReloadOptions convertDictionary<Navigation::ReloadOptions>(JSC::JSGlobalObject&, JSC::JSValue);

template<> Navigation::Result convertDictionary<Navigation::Result>(JSC::JSGlobalObject&, JSC::JSValue);

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject&, JSDOMGlobalObject&, const Navigation::Result&);


} // namespace WebCore
