/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSNavigateEvent.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSAbortSignal.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMFormData.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSNavigationDestination.h"
#include "JSNavigationInterceptHandler.h"
#include "JSNavigationNavigationType.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/PointerPreparations.h>
#include <wtf/SortedArrayMap.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(NavigateEvent::NavigationFocusReset enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("after-transition"),
        MAKE_STATIC_STRING_IMPL("manual"),
    };
    static_assert(static_cast<size_t>(NavigateEvent::NavigationFocusReset::AfterTransition) == 0, "NavigateEvent::NavigationFocusReset::AfterTransition is not 0 as expected");
    static_assert(static_cast<size_t>(NavigateEvent::NavigationFocusReset::Manual) == 1, "NavigateEvent::NavigationFocusReset::Manual is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, NavigateEvent::NavigationFocusReset enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<NavigateEvent::NavigationFocusReset> parseEnumerationFromString<NavigateEvent::NavigationFocusReset>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, NavigateEvent::NavigationFocusReset> mappings[] = {
        { "after-transition", NavigateEvent::NavigationFocusReset::AfterTransition },
        { "manual", NavigateEvent::NavigationFocusReset::Manual },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<NavigateEvent::NavigationFocusReset> parseEnumeration<NavigateEvent::NavigationFocusReset>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<NavigateEvent::NavigationFocusReset>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<NavigateEvent::NavigationFocusReset>()
{
    return "\"after-transition\", \"manual\"";
}

String convertEnumerationToString(NavigateEvent::NavigationScrollBehavior enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("after-transition"),
        MAKE_STATIC_STRING_IMPL("manual"),
    };
    static_assert(static_cast<size_t>(NavigateEvent::NavigationScrollBehavior::AfterTransition) == 0, "NavigateEvent::NavigationScrollBehavior::AfterTransition is not 0 as expected");
    static_assert(static_cast<size_t>(NavigateEvent::NavigationScrollBehavior::Manual) == 1, "NavigateEvent::NavigationScrollBehavior::Manual is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, NavigateEvent::NavigationScrollBehavior enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<NavigateEvent::NavigationScrollBehavior> parseEnumerationFromString<NavigateEvent::NavigationScrollBehavior>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, NavigateEvent::NavigationScrollBehavior> mappings[] = {
        { "after-transition", NavigateEvent::NavigationScrollBehavior::AfterTransition },
        { "manual", NavigateEvent::NavigationScrollBehavior::Manual },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<NavigateEvent::NavigationScrollBehavior> parseEnumeration<NavigateEvent::NavigationScrollBehavior>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<NavigateEvent::NavigationScrollBehavior>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<NavigateEvent::NavigationScrollBehavior>()
{
    return "\"after-transition\", \"manual\"";
}

template<> NavigateEvent::Init convertDictionary<NavigateEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    NavigateEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bubblesValue.isUndefined()) {
        result.bubbles = convert<IDLBoolean>(lexicalGlobalObject, bubblesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.bubbles = false;
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!cancelableValue.isUndefined()) {
        result.cancelable = convert<IDLBoolean>(lexicalGlobalObject, cancelableValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.cancelable = false;
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!composedValue.isUndefined()) {
        result.composed = convert<IDLBoolean>(lexicalGlobalObject, composedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.composed = false;
    JSValue canInterceptValue;
    if (isNullOrUndefined)
        canInterceptValue = jsUndefined();
    else {
        canInterceptValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "canIntercept"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!canInterceptValue.isUndefined()) {
        result.canIntercept = convert<IDLBoolean>(lexicalGlobalObject, canInterceptValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.canIntercept = false;
    JSValue destinationValue;
    if (isNullOrUndefined)
        destinationValue = jsUndefined();
    else {
        destinationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "destination"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!destinationValue.isUndefined()) {
        result.destination = convert<IDLInterface<NavigationDestination>>(lexicalGlobalObject, destinationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "destination", "NavigateEventInit", "NavigationDestination");
        return { };
    }
    JSValue downloadRequestValue;
    if (isNullOrUndefined)
        downloadRequestValue = jsUndefined();
    else {
        downloadRequestValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "downloadRequest"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!downloadRequestValue.isUndefined()) {
        result.downloadRequest = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, downloadRequestValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.downloadRequest = String();
    JSValue formDataValue;
    if (isNullOrUndefined)
        formDataValue = jsUndefined();
    else {
        formDataValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "formData"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!formDataValue.isUndefined()) {
        result.formData = convert<IDLNullable<IDLInterface<DOMFormData>>>(lexicalGlobalObject, formDataValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.formData = nullptr;
    JSValue hasUAVisualTransitionValue;
    if (isNullOrUndefined)
        hasUAVisualTransitionValue = jsUndefined();
    else {
        hasUAVisualTransitionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "hasUAVisualTransition"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!hasUAVisualTransitionValue.isUndefined()) {
        result.hasUAVisualTransition = convert<IDLBoolean>(lexicalGlobalObject, hasUAVisualTransitionValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.hasUAVisualTransition = false;
    JSValue hashChangeValue;
    if (isNullOrUndefined)
        hashChangeValue = jsUndefined();
    else {
        hashChangeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "hashChange"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!hashChangeValue.isUndefined()) {
        result.hashChange = convert<IDLBoolean>(lexicalGlobalObject, hashChangeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.hashChange = false;
    JSValue infoValue;
    if (isNullOrUndefined)
        infoValue = jsUndefined();
    else {
        infoValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "info"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!infoValue.isUndefined()) {
        result.info = convert<IDLAny>(lexicalGlobalObject, infoValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.info = jsUndefined();
    JSValue navigationTypeValue;
    if (isNullOrUndefined)
        navigationTypeValue = jsUndefined();
    else {
        navigationTypeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "navigationType"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!navigationTypeValue.isUndefined()) {
        result.navigationType = convert<IDLEnumeration<NavigationNavigationType>>(lexicalGlobalObject, navigationTypeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.navigationType = NavigationNavigationType::Push;
    JSValue signalValue;
    if (isNullOrUndefined)
        signalValue = jsUndefined();
    else {
        signalValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "signal"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!signalValue.isUndefined()) {
        result.signal = convert<IDLInterface<AbortSignal>>(lexicalGlobalObject, signalValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "signal", "NavigateEventInit", "AbortSignal");
        return { };
    }
    JSValue userInitiatedValue;
    if (isNullOrUndefined)
        userInitiatedValue = jsUndefined();
    else {
        userInitiatedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "userInitiated"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!userInitiatedValue.isUndefined()) {
        result.userInitiated = convert<IDLBoolean>(lexicalGlobalObject, userInitiatedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.userInitiated = false;
    return result;
}

template<> NavigateEvent::NavigationInterceptOptions convertDictionary<NavigateEvent::NavigationInterceptOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    NavigateEvent::NavigationInterceptOptions result;
    JSValue focusResetValue;
    if (isNullOrUndefined)
        focusResetValue = jsUndefined();
    else {
        focusResetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "focusReset"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!focusResetValue.isUndefined()) {
        result.focusReset = convert<IDLEnumeration<NavigateEvent::NavigationFocusReset>>(lexicalGlobalObject, focusResetValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue handlerValue;
    if (isNullOrUndefined)
        handlerValue = jsUndefined();
    else {
        handlerValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "handler"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!handlerValue.isUndefined()) {
        result.handler = convert<IDLCallbackFunction<JSNavigationInterceptHandler>>(lexicalGlobalObject, handlerValue, *jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue scrollValue;
    if (isNullOrUndefined)
        scrollValue = jsUndefined();
    else {
        scrollValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "scroll"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!scrollValue.isUndefined()) {
        result.scroll = convert<IDLEnumeration<NavigateEvent::NavigationScrollBehavior>>(lexicalGlobalObject, scrollValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsNavigateEventPrototypeFunction_intercept);
static JSC_DECLARE_HOST_FUNCTION(jsNavigateEventPrototypeFunction_scroll);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsNavigateEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigateEvent_navigationType);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigateEvent_destination);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigateEvent_canIntercept);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigateEvent_userInitiated);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigateEvent_hashChange);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigateEvent_signal);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigateEvent_formData);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigateEvent_downloadRequest);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigateEvent_info);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigateEvent_hasUAVisualTransition);

class JSNavigateEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSNavigateEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSNavigateEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSNavigateEventPrototype>(vm)) JSNavigateEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSNavigateEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSNavigateEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSNavigateEventPrototype, JSNavigateEventPrototype::Base);

using JSNavigateEventDOMConstructor = JSDOMConstructor<JSNavigateEvent>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSNavigateEventDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSNavigateEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto type = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto eventInitDict = convert<IDLDictionary<NavigateEvent::Init>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = NavigateEvent::create(WTFMove(type), WTFMove(eventInitDict));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<NavigateEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<NavigateEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSNavigateEventDOMConstructorConstruct, JSNavigateEventDOMConstructor::construct);

template<> const ClassInfo JSNavigateEventDOMConstructor::s_info = { "NavigateEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNavigateEventDOMConstructor) };

template<> JSValue JSNavigateEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSNavigateEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(2), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "NavigateEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSNavigateEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSNavigateEventPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigateEventConstructor, 0 } },
    { "navigationType"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigateEvent_navigationType, 0 } },
    { "destination"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigateEvent_destination, 0 } },
    { "canIntercept"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigateEvent_canIntercept, 0 } },
    { "userInitiated"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigateEvent_userInitiated, 0 } },
    { "hashChange"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigateEvent_hashChange, 0 } },
    { "signal"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigateEvent_signal, 0 } },
    { "formData"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigateEvent_formData, 0 } },
    { "downloadRequest"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigateEvent_downloadRequest, 0 } },
    { "info"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigateEvent_info, 0 } },
    { "hasUAVisualTransition"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigateEvent_hasUAVisualTransition, 0 } },
    { "intercept"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNavigateEventPrototypeFunction_intercept, 0 } },
    { "scroll"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNavigateEventPrototypeFunction_scroll, 0 } },
};

const ClassInfo JSNavigateEventPrototype::s_info = { "NavigateEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNavigateEventPrototype) };

void JSNavigateEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSNavigateEvent::info(), JSNavigateEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSNavigateEvent::s_info = { "NavigateEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNavigateEvent) };

JSNavigateEvent::JSNavigateEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<NavigateEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

Ref<NavigateEvent> JSNavigateEvent::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, NavigateEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSNavigateEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSNavigateEventPrototype::createStructure(vm, &globalObject, JSEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSNavigateEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSNavigateEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSNavigateEvent>(vm, globalObject);
}

JSValue JSNavigateEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSNavigateEventDOMConstructor, DOMConstructorID::NavigateEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigateEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSNavigateEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSNavigateEvent::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsNavigateEvent_navigationTypeGetter(JSGlobalObject& lexicalGlobalObject, JSNavigateEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<NavigationNavigationType>>(lexicalGlobalObject, throwScope, impl.navigationType())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigateEvent_navigationType, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigateEvent>::get<jsNavigateEvent_navigationTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigateEvent_destinationGetter(JSGlobalObject& lexicalGlobalObject, JSNavigateEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<NavigationDestination>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.destination())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigateEvent_destination, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigateEvent>::get<jsNavigateEvent_destinationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigateEvent_canInterceptGetter(JSGlobalObject& lexicalGlobalObject, JSNavigateEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.canIntercept())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigateEvent_canIntercept, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigateEvent>::get<jsNavigateEvent_canInterceptGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigateEvent_userInitiatedGetter(JSGlobalObject& lexicalGlobalObject, JSNavigateEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.userInitiated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigateEvent_userInitiated, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigateEvent>::get<jsNavigateEvent_userInitiatedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigateEvent_hashChangeGetter(JSGlobalObject& lexicalGlobalObject, JSNavigateEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hashChange())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigateEvent_hashChange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigateEvent>::get<jsNavigateEvent_hashChangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigateEvent_signalGetter(JSGlobalObject& lexicalGlobalObject, JSNavigateEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<AbortSignal>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.signal())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigateEvent_signal, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigateEvent>::get<jsNavigateEvent_signalGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigateEvent_formDataGetter(JSGlobalObject& lexicalGlobalObject, JSNavigateEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<DOMFormData>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.formData())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigateEvent_formData, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigateEvent>::get<jsNavigateEvent_formDataGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigateEvent_downloadRequestGetter(JSGlobalObject& lexicalGlobalObject, JSNavigateEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.downloadRequest())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigateEvent_downloadRequest, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigateEvent>::get<jsNavigateEvent_downloadRequestGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigateEvent_infoGetter(JSGlobalObject& lexicalGlobalObject, JSNavigateEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAny>(lexicalGlobalObject, throwScope, impl.info())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigateEvent_info, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigateEvent>::get<jsNavigateEvent_infoGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigateEvent_hasUAVisualTransitionGetter(JSGlobalObject& lexicalGlobalObject, JSNavigateEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasUAVisualTransition())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigateEvent_hasUAVisualTransition, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigateEvent>::get<jsNavigateEvent_hasUAVisualTransitionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsNavigateEventPrototypeFunction_interceptBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNavigateEvent>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto options = convert<IDLDictionary<NavigateEvent::NavigationInterceptOptions>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.intercept(WTFMove(options)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsNavigateEventPrototypeFunction_intercept, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNavigateEvent>::call<jsNavigateEventPrototypeFunction_interceptBody>(*lexicalGlobalObject, *callFrame, "intercept");
}

static inline JSC::EncodedJSValue jsNavigateEventPrototypeFunction_scrollBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNavigateEvent>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.scroll(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsNavigateEventPrototypeFunction_scroll, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNavigateEvent>::call<jsNavigateEventPrototypeFunction_scrollBody>(*lexicalGlobalObject, *callFrame, "scroll");
}

JSC::GCClient::IsoSubspace* JSNavigateEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSNavigateEvent, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForNavigateEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForNavigateEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForNavigateEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForNavigateEvent = std::forward<decltype(space)>(space); }
    );
}

void JSNavigateEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSNavigateEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7NavigateEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore13NavigateEventE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<NavigateEvent>&& impl)
{

    if constexpr (std::is_polymorphic_v<NavigateEvent>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7NavigateEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore13NavigateEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // NavigateEvent has subclasses. If NavigateEvent has subclasses that get passed
        // to toJS() we currently require NavigateEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<NavigateEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, NavigateEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
