/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM)

#include "JSMediaTrackCapabilities.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMGlobalObject.h"
#include "JSDoubleRange.h"
#include "JSLongRange.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(MEDIA_STREAM)

template<> MediaTrackCapabilities convertDictionary<MediaTrackCapabilities>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    MediaTrackCapabilities result;
    JSValue aspectRatioValue;
    if (isNullOrUndefined)
        aspectRatioValue = jsUndefined();
    else {
        aspectRatioValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "aspectRatio"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!aspectRatioValue.isUndefined()) {
        result.aspectRatio = convert<IDLDictionary<DoubleRange>>(lexicalGlobalObject, aspectRatioValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue deviceIdValue;
    if (isNullOrUndefined)
        deviceIdValue = jsUndefined();
    else {
        deviceIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "deviceId"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!deviceIdValue.isUndefined()) {
        result.deviceId = convert<IDLDOMString>(lexicalGlobalObject, deviceIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue displaySurfaceValue;
    if (isNullOrUndefined)
        displaySurfaceValue = jsUndefined();
    else {
        displaySurfaceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "displaySurface"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!displaySurfaceValue.isUndefined()) {
        result.displaySurface = convert<IDLDOMString>(lexicalGlobalObject, displaySurfaceValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue echoCancellationValue;
    if (isNullOrUndefined)
        echoCancellationValue = jsUndefined();
    else {
        echoCancellationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "echoCancellation"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!echoCancellationValue.isUndefined()) {
        result.echoCancellation = convert<IDLSequence<IDLBoolean>>(lexicalGlobalObject, echoCancellationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue facingModeValue;
    if (isNullOrUndefined)
        facingModeValue = jsUndefined();
    else {
        facingModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "facingMode"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!facingModeValue.isUndefined()) {
        result.facingMode = convert<IDLSequence<IDLDOMString>>(lexicalGlobalObject, facingModeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue focusDistanceValue;
    if (isNullOrUndefined)
        focusDistanceValue = jsUndefined();
    else {
        focusDistanceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "focusDistance"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!focusDistanceValue.isUndefined()) {
        result.focusDistance = convert<IDLDictionary<DoubleRange>>(lexicalGlobalObject, focusDistanceValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue frameRateValue;
    if (isNullOrUndefined)
        frameRateValue = jsUndefined();
    else {
        frameRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "frameRate"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!frameRateValue.isUndefined()) {
        result.frameRate = convert<IDLDictionary<DoubleRange>>(lexicalGlobalObject, frameRateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue groupIdValue;
    if (isNullOrUndefined)
        groupIdValue = jsUndefined();
    else {
        groupIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "groupId"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!groupIdValue.isUndefined()) {
        result.groupId = convert<IDLDOMString>(lexicalGlobalObject, groupIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue heightValue;
    if (isNullOrUndefined)
        heightValue = jsUndefined();
    else {
        heightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "height"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!heightValue.isUndefined()) {
        result.height = convert<IDLDictionary<LongRange>>(lexicalGlobalObject, heightValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue sampleRateValue;
    if (isNullOrUndefined)
        sampleRateValue = jsUndefined();
    else {
        sampleRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sampleRate"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sampleRateValue.isUndefined()) {
        result.sampleRate = convert<IDLDictionary<LongRange>>(lexicalGlobalObject, sampleRateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue sampleSizeValue;
    if (isNullOrUndefined)
        sampleSizeValue = jsUndefined();
    else {
        sampleSizeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sampleSize"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sampleSizeValue.isUndefined()) {
        result.sampleSize = convert<IDLDictionary<LongRange>>(lexicalGlobalObject, sampleSizeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue torchValue;
    if (isNullOrUndefined)
        torchValue = jsUndefined();
    else {
        torchValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "torch"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!torchValue.isUndefined()) {
        result.torch = convert<IDLBoolean>(lexicalGlobalObject, torchValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue volumeValue;
    if (isNullOrUndefined)
        volumeValue = jsUndefined();
    else {
        volumeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "volume"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!volumeValue.isUndefined()) {
        result.volume = convert<IDLDictionary<DoubleRange>>(lexicalGlobalObject, volumeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue whiteBalanceModeValue;
    if (isNullOrUndefined)
        whiteBalanceModeValue = jsUndefined();
    else {
        whiteBalanceModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "whiteBalanceMode"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!whiteBalanceModeValue.isUndefined()) {
        result.whiteBalanceMode = convert<IDLSequence<IDLDOMString>>(lexicalGlobalObject, whiteBalanceModeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue widthValue;
    if (isNullOrUndefined)
        widthValue = jsUndefined();
    else {
        widthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "width"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!widthValue.isUndefined()) {
        result.width = convert<IDLDictionary<LongRange>>(lexicalGlobalObject, widthValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue zoomValue;
    if (isNullOrUndefined)
        zoomValue = jsUndefined();
    else {
        zoomValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "zoom"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!zoomValue.isUndefined()) {
        result.zoom = convert<IDLDictionary<DoubleRange>>(lexicalGlobalObject, zoomValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const MediaTrackCapabilities& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDictionary<DoubleRange>::isNullValue(dictionary.aspectRatio)) {
        auto aspectRatioValue = toJS<IDLDictionary<DoubleRange>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<DoubleRange>::extractValueFromNullable(dictionary.aspectRatio));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "aspectRatio"_s), aspectRatioValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.deviceId)) {
        auto deviceIdValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.deviceId));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "deviceId"_s), deviceIdValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.displaySurface)) {
        auto displaySurfaceValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.displaySurface));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "displaySurface"_s), displaySurfaceValue);
    }
    if (!IDLSequence<IDLBoolean>::isNullValue(dictionary.echoCancellation)) {
        auto echoCancellationValue = toJS<IDLSequence<IDLBoolean>>(lexicalGlobalObject, globalObject, throwScope, IDLSequence<IDLBoolean>::extractValueFromNullable(dictionary.echoCancellation));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "echoCancellation"_s), echoCancellationValue);
    }
    if (!IDLSequence<IDLDOMString>::isNullValue(dictionary.facingMode)) {
        auto facingModeValue = toJS<IDLSequence<IDLDOMString>>(lexicalGlobalObject, globalObject, throwScope, IDLSequence<IDLDOMString>::extractValueFromNullable(dictionary.facingMode));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "facingMode"_s), facingModeValue);
    }
    if (!IDLDictionary<DoubleRange>::isNullValue(dictionary.focusDistance)) {
        auto focusDistanceValue = toJS<IDLDictionary<DoubleRange>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<DoubleRange>::extractValueFromNullable(dictionary.focusDistance));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "focusDistance"_s), focusDistanceValue);
    }
    if (!IDLDictionary<DoubleRange>::isNullValue(dictionary.frameRate)) {
        auto frameRateValue = toJS<IDLDictionary<DoubleRange>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<DoubleRange>::extractValueFromNullable(dictionary.frameRate));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "frameRate"_s), frameRateValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.groupId)) {
        auto groupIdValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.groupId));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "groupId"_s), groupIdValue);
    }
    if (!IDLDictionary<LongRange>::isNullValue(dictionary.height)) {
        auto heightValue = toJS<IDLDictionary<LongRange>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<LongRange>::extractValueFromNullable(dictionary.height));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "height"_s), heightValue);
    }
    if (!IDLDictionary<LongRange>::isNullValue(dictionary.sampleRate)) {
        auto sampleRateValue = toJS<IDLDictionary<LongRange>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<LongRange>::extractValueFromNullable(dictionary.sampleRate));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "sampleRate"_s), sampleRateValue);
    }
    if (!IDLDictionary<LongRange>::isNullValue(dictionary.sampleSize)) {
        auto sampleSizeValue = toJS<IDLDictionary<LongRange>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<LongRange>::extractValueFromNullable(dictionary.sampleSize));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "sampleSize"_s), sampleSizeValue);
    }
    if (!IDLBoolean::isNullValue(dictionary.torch)) {
        auto torchValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, IDLBoolean::extractValueFromNullable(dictionary.torch));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "torch"_s), torchValue);
    }
    if (!IDLDictionary<DoubleRange>::isNullValue(dictionary.volume)) {
        auto volumeValue = toJS<IDLDictionary<DoubleRange>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<DoubleRange>::extractValueFromNullable(dictionary.volume));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "volume"_s), volumeValue);
    }
    if (!IDLSequence<IDLDOMString>::isNullValue(dictionary.whiteBalanceMode)) {
        auto whiteBalanceModeValue = toJS<IDLSequence<IDLDOMString>>(lexicalGlobalObject, globalObject, throwScope, IDLSequence<IDLDOMString>::extractValueFromNullable(dictionary.whiteBalanceMode));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "whiteBalanceMode"_s), whiteBalanceModeValue);
    }
    if (!IDLDictionary<LongRange>::isNullValue(dictionary.width)) {
        auto widthValue = toJS<IDLDictionary<LongRange>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<LongRange>::extractValueFromNullable(dictionary.width));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "width"_s), widthValue);
    }
    if (!IDLDictionary<DoubleRange>::isNullValue(dictionary.zoom)) {
        auto zoomValue = toJS<IDLDictionary<DoubleRange>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<DoubleRange>::extractValueFromNullable(dictionary.zoom));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "zoom"_s), zoomValue);
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(MEDIA_STREAM)
