/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM) && ENABLE(WEB_CODECS)

#include "JSMediaStreamTrackProcessor.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSMediaStreamTrack.h"
#include "JSReadableStream.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(MEDIA_STREAM) && ENABLE(WEB_CODECS)

template<> MediaStreamTrackProcessor::Init convertDictionary<MediaStreamTrackProcessor::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    MediaStreamTrackProcessor::Init result;
    JSValue maxBufferSizeValue;
    if (isNullOrUndefined)
        maxBufferSizeValue = jsUndefined();
    else {
        maxBufferSizeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "maxBufferSize"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!maxBufferSizeValue.isUndefined()) {
        result.maxBufferSize = convert<IDLEnforceRangeAdaptor<IDLUnsignedShort>>(lexicalGlobalObject, maxBufferSizeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue trackValue;
    if (isNullOrUndefined)
        trackValue = jsUndefined();
    else {
        trackValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "track"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!trackValue.isUndefined()) {
        result.track = convert<IDLInterface<MediaStreamTrack>>(lexicalGlobalObject, trackValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "track", "MediaStreamTrackProcessorInit", "MediaStreamTrack");
        return { };
    }
    return result;
}

#endif

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsMediaStreamTrackProcessorConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaStreamTrackProcessor_readable);

class JSMediaStreamTrackProcessorPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMediaStreamTrackProcessorPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaStreamTrackProcessorPrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaStreamTrackProcessorPrototype>(vm)) JSMediaStreamTrackProcessorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaStreamTrackProcessorPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMediaStreamTrackProcessorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaStreamTrackProcessorPrototype, JSMediaStreamTrackProcessorPrototype::Base);

using JSMediaStreamTrackProcessorDOMConstructor = JSDOMConstructor<JSMediaStreamTrackProcessor>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSMediaStreamTrackProcessorDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSMediaStreamTrackProcessorDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "MediaStreamTrackProcessor");
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto init = convert<IDLDictionary<MediaStreamTrackProcessor::Init>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = MediaStreamTrackProcessor::create(*context, WTFMove(init));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<MediaStreamTrackProcessor>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<MediaStreamTrackProcessor>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSMediaStreamTrackProcessorDOMConstructorConstruct, JSMediaStreamTrackProcessorDOMConstructor::construct);

template<> const ClassInfo JSMediaStreamTrackProcessorDOMConstructor::s_info = { "MediaStreamTrackProcessor"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaStreamTrackProcessorDOMConstructor) };

template<> JSValue JSMediaStreamTrackProcessorDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSMediaStreamTrackProcessorDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "MediaStreamTrackProcessor"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSMediaStreamTrackProcessor::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSMediaStreamTrackProcessorPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaStreamTrackProcessorConstructor, 0 } },
    { "readable"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaStreamTrackProcessor_readable, 0 } },
};

const ClassInfo JSMediaStreamTrackProcessorPrototype::s_info = { "MediaStreamTrackProcessor"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaStreamTrackProcessorPrototype) };

void JSMediaStreamTrackProcessorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMediaStreamTrackProcessor::info(), JSMediaStreamTrackProcessorPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSMediaStreamTrackProcessor::s_info = { "MediaStreamTrackProcessor"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaStreamTrackProcessor) };

JSMediaStreamTrackProcessor::JSMediaStreamTrackProcessor(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MediaStreamTrackProcessor>&& impl)
    : JSDOMWrapper<MediaStreamTrackProcessor>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, MediaStreamTrackProcessor>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSMediaStreamTrackProcessor::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSMediaStreamTrackProcessorPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSMediaStreamTrackProcessorPrototype::create(vm, &globalObject, structure);
}

JSObject* JSMediaStreamTrackProcessor::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMediaStreamTrackProcessor>(vm, globalObject);
}

JSValue JSMediaStreamTrackProcessor::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaStreamTrackProcessorDOMConstructor, DOMConstructorID::MediaStreamTrackProcessor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSMediaStreamTrackProcessor::destroy(JSC::JSCell* cell)
{
    JSMediaStreamTrackProcessor* thisObject = static_cast<JSMediaStreamTrackProcessor*>(cell);
    thisObject->JSMediaStreamTrackProcessor::~JSMediaStreamTrackProcessor();
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaStreamTrackProcessorConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaStreamTrackProcessorPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSMediaStreamTrackProcessor::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsMediaStreamTrackProcessor_readableGetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrackProcessor& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<ReadableStream>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.readable(*jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)))));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaStreamTrackProcessor_readable, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaStreamTrackProcessor>::get<jsMediaStreamTrackProcessor_readableGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSMediaStreamTrackProcessor::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSMediaStreamTrackProcessor, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForMediaStreamTrackProcessor.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForMediaStreamTrackProcessor = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForMediaStreamTrackProcessor.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForMediaStreamTrackProcessor = std::forward<decltype(space)>(space); }
    );
}

void JSMediaStreamTrackProcessor::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMediaStreamTrackProcessor*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSMediaStreamTrackProcessorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSMediaStreamTrackProcessorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMediaStreamTrackProcessor = static_cast<JSMediaStreamTrackProcessor*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsMediaStreamTrackProcessor->wrapped(), jsMediaStreamTrackProcessor);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7MediaStreamTrackProcessor@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore25MediaStreamTrackProcessorE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<MediaStreamTrackProcessor>&& impl)
{

    if constexpr (std::is_polymorphic_v<MediaStreamTrackProcessor>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7MediaStreamTrackProcessor@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore25MediaStreamTrackProcessorE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // MediaStreamTrackProcessor has subclasses. If MediaStreamTrackProcessor has subclasses that get passed
        // to toJS() we currently require MediaStreamTrackProcessor you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<MediaStreamTrackProcessor>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MediaStreamTrackProcessor& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

MediaStreamTrackProcessor* JSMediaStreamTrackProcessor::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMediaStreamTrackProcessor*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(MEDIA_STREAM) && ENABLE(WEB_CODECS)
