/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_SOURCE)

#include "JSMediaSource.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSSourceBuffer.h"
#include "JSSourceBufferList.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/SortedArrayMap.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(MediaSource::EndOfStreamError enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("network"),
        MAKE_STATIC_STRING_IMPL("decode"),
    };
    static_assert(static_cast<size_t>(MediaSource::EndOfStreamError::Network) == 0, "MediaSource::EndOfStreamError::Network is not 0 as expected");
    static_assert(static_cast<size_t>(MediaSource::EndOfStreamError::Decode) == 1, "MediaSource::EndOfStreamError::Decode is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, MediaSource::EndOfStreamError enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<MediaSource::EndOfStreamError> parseEnumerationFromString<MediaSource::EndOfStreamError>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, MediaSource::EndOfStreamError> mappings[] = {
        { "decode", MediaSource::EndOfStreamError::Decode },
        { "network", MediaSource::EndOfStreamError::Network },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<MediaSource::EndOfStreamError> parseEnumeration<MediaSource::EndOfStreamError>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<MediaSource::EndOfStreamError>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<MediaSource::EndOfStreamError>()
{
    return "\"network\", \"decode\"";
}

String convertEnumerationToString(MediaSource::ReadyState enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("closed"),
        MAKE_STATIC_STRING_IMPL("open"),
        MAKE_STATIC_STRING_IMPL("ended"),
    };
    static_assert(static_cast<size_t>(MediaSource::ReadyState::Closed) == 0, "MediaSource::ReadyState::Closed is not 0 as expected");
    static_assert(static_cast<size_t>(MediaSource::ReadyState::Open) == 1, "MediaSource::ReadyState::Open is not 1 as expected");
    static_assert(static_cast<size_t>(MediaSource::ReadyState::Ended) == 2, "MediaSource::ReadyState::Ended is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, MediaSource::ReadyState enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<MediaSource::ReadyState> parseEnumerationFromString<MediaSource::ReadyState>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, MediaSource::ReadyState> mappings[] = {
        { "closed", MediaSource::ReadyState::Closed },
        { "ended", MediaSource::ReadyState::Ended },
        { "open", MediaSource::ReadyState::Open },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<MediaSource::ReadyState> parseEnumeration<MediaSource::ReadyState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<MediaSource::ReadyState>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<MediaSource::ReadyState>()
{
    return "\"closed\", \"open\", \"ended\"";
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsMediaSourcePrototypeFunction_addSourceBuffer);
static JSC_DECLARE_HOST_FUNCTION(jsMediaSourcePrototypeFunction_removeSourceBuffer);
static JSC_DECLARE_HOST_FUNCTION(jsMediaSourcePrototypeFunction_endOfStream);
static JSC_DECLARE_HOST_FUNCTION(jsMediaSourceConstructorFunction_isTypeSupported);
static JSC_DECLARE_HOST_FUNCTION(jsMediaSourcePrototypeFunction_setLiveSeekableRange);
static JSC_DECLARE_HOST_FUNCTION(jsMediaSourcePrototypeFunction_clearLiveSeekableRange);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsMediaSourceConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaSource_sourceBuffers);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaSource_activeSourceBuffers);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaSource_duration);
static JSC_DECLARE_CUSTOM_SETTER(setJSMediaSource_duration);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaSource_readyState);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaSource_onsourceopen);
static JSC_DECLARE_CUSTOM_SETTER(setJSMediaSource_onsourceopen);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaSource_onsourceended);
static JSC_DECLARE_CUSTOM_SETTER(setJSMediaSource_onsourceended);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaSource_onsourceclose);
static JSC_DECLARE_CUSTOM_SETTER(setJSMediaSource_onsourceclose);

class JSMediaSourcePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMediaSourcePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaSourcePrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaSourcePrototype>(vm)) JSMediaSourcePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaSourcePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMediaSourcePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaSourcePrototype, JSMediaSourcePrototype::Base);

using JSMediaSourceDOMConstructor = JSDOMConstructor<JSMediaSource>;

/* Hash table for constructor */

static const HashTableValue JSMediaSourceConstructorTableValues[] =
{
    { "isTypeSupported"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaSourceConstructorFunction_isTypeSupported, 1 } },
};

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSMediaSourceDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSMediaSourceDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "MediaSource");
    auto object = MediaSource::create(*context);
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<MediaSource>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<MediaSource>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSMediaSourceDOMConstructorConstruct, JSMediaSourceDOMConstructor::construct);

template<> const ClassInfo JSMediaSourceDOMConstructor::s_info = { "MediaSource"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaSourceDOMConstructor) };

template<> JSValue JSMediaSourceDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSMediaSourceDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "MediaSource"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSMediaSource::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSMediaSource::info(), JSMediaSourceConstructorTableValues, *this);
}

/* Hash table for prototype */

static const HashTableValue JSMediaSourcePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaSourceConstructor, 0 } },
    { "sourceBuffers"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaSource_sourceBuffers, 0 } },
    { "activeSourceBuffers"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaSource_activeSourceBuffers, 0 } },
    { "duration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaSource_duration, setJSMediaSource_duration } },
    { "readyState"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaSource_readyState, 0 } },
    { "onsourceopen"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaSource_onsourceopen, setJSMediaSource_onsourceopen } },
    { "onsourceended"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaSource_onsourceended, setJSMediaSource_onsourceended } },
    { "onsourceclose"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaSource_onsourceclose, setJSMediaSource_onsourceclose } },
    { "addSourceBuffer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaSourcePrototypeFunction_addSourceBuffer, 1 } },
    { "removeSourceBuffer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaSourcePrototypeFunction_removeSourceBuffer, 1 } },
    { "endOfStream"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaSourcePrototypeFunction_endOfStream, 0 } },
    { "setLiveSeekableRange"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaSourcePrototypeFunction_setLiveSeekableRange, 2 } },
    { "clearLiveSeekableRange"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaSourcePrototypeFunction_clearLiveSeekableRange, 0 } },
};

const ClassInfo JSMediaSourcePrototype::s_info = { "MediaSource"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaSourcePrototype) };

void JSMediaSourcePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMediaSource::info(), JSMediaSourcePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSMediaSource::s_info = { "MediaSource"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaSource) };

JSMediaSource::JSMediaSource(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MediaSource>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

Ref<MediaSource> JSMediaSource::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, MediaSource>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSMediaSource::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSMediaSourcePrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSMediaSourcePrototype::create(vm, &globalObject, structure);
}

JSObject* JSMediaSource::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMediaSource>(vm, globalObject);
}

JSValue JSMediaSource::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaSourceDOMConstructor, DOMConstructorID::MediaSource>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaSourceConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaSourcePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSMediaSource::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsMediaSource_sourceBuffersGetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SourceBufferList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.sourceBuffers())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaSource_sourceBuffers, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSource>::get<jsMediaSource_sourceBuffersGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaSource_activeSourceBuffersGetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SourceBufferList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.activeSourceBuffers())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaSource_activeSourceBuffers, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSource>::get<jsMediaSource_activeSourceBuffersGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaSource_durationGetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.duration())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaSource_duration, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSource>::get<jsMediaSource_durationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMediaSource_durationSetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setDuration(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMediaSource_duration, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSource>::set<setJSMediaSource_durationSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMediaSource_readyStateGetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<MediaSource::ReadyState>>(lexicalGlobalObject, throwScope, impl.readyState())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaSource_readyState, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSource>::get<jsMediaSource_readyStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaSource_onsourceopenGetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().sourceopenEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaSource_onsourceopen, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSource>::get<jsMediaSource_onsourceopenGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMediaSource_onsourceopenSetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().sourceopenEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMediaSource_onsourceopen, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSource>::set<setJSMediaSource_onsourceopenSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMediaSource_onsourceendedGetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().sourceendedEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaSource_onsourceended, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSource>::get<jsMediaSource_onsourceendedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMediaSource_onsourceendedSetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().sourceendedEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMediaSource_onsourceended, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSource>::set<setJSMediaSource_onsourceendedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMediaSource_onsourcecloseGetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().sourcecloseEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaSource_onsourceclose, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSource>::get<jsMediaSource_onsourcecloseGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMediaSource_onsourcecloseSetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().sourcecloseEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMediaSource_onsourceclose, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSource>::set<setJSMediaSource_onsourcecloseSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsMediaSourcePrototypeFunction_addSourceBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaSource>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto type = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<SourceBuffer>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.addSourceBuffer(WTFMove(type)))));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaSourcePrototypeFunction_addSourceBuffer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaSource>::call<jsMediaSourcePrototypeFunction_addSourceBufferBody>(*lexicalGlobalObject, *callFrame, "addSourceBuffer");
}

static inline JSC::EncodedJSValue jsMediaSourcePrototypeFunction_removeSourceBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaSource>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto buffer = convert<IDLInterface<SourceBuffer>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "buffer", "MediaSource", "removeSourceBuffer", "SourceBuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.removeSourceBuffer(*buffer); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaSourcePrototypeFunction_removeSourceBuffer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaSource>::call<jsMediaSourcePrototypeFunction_removeSourceBufferBody>(*lexicalGlobalObject, *callFrame, "removeSourceBuffer");
}

static inline JSC::EncodedJSValue jsMediaSourcePrototypeFunction_endOfStreamBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaSource>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto error = argument0.value().isUndefined() ? std::optional<Converter<IDLEnumeration<MediaSource::EndOfStreamError>>::ReturnType>() : std::optional<Converter<IDLEnumeration<MediaSource::EndOfStreamError>>::ReturnType>(convert<IDLEnumeration<MediaSource::EndOfStreamError>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "error", "MediaSource", "endOfStream", expectedEnumerationValues<MediaSource::EndOfStreamError>()); }));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.endOfStream(WTFMove(error)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaSourcePrototypeFunction_endOfStream, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaSource>::call<jsMediaSourcePrototypeFunction_endOfStreamBody>(*lexicalGlobalObject, *callFrame, "endOfStream");
}

static inline JSC::EncodedJSValue jsMediaSourceConstructorFunction_isTypeSupportedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto type = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, MediaSource::isTypeSupported(*context, WTFMove(type)))));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaSourceConstructorFunction_isTypeSupported, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaSource>::callStatic<jsMediaSourceConstructorFunction_isTypeSupportedBody>(*lexicalGlobalObject, *callFrame, "isTypeSupported");
}

static inline JSC::EncodedJSValue jsMediaSourcePrototypeFunction_setLiveSeekableRangeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaSource>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto start = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto end = convert<IDLDouble>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setLiveSeekableRange(WTFMove(start), WTFMove(end)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaSourcePrototypeFunction_setLiveSeekableRange, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaSource>::call<jsMediaSourcePrototypeFunction_setLiveSeekableRangeBody>(*lexicalGlobalObject, *callFrame, "setLiveSeekableRange");
}

static inline JSC::EncodedJSValue jsMediaSourcePrototypeFunction_clearLiveSeekableRangeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaSource>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.clearLiveSeekableRange(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaSourcePrototypeFunction_clearLiveSeekableRange, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaSource>::call<jsMediaSourcePrototypeFunction_clearLiveSeekableRangeBody>(*lexicalGlobalObject, *callFrame, "clearLiveSeekableRange");
}

JSC::GCClient::IsoSubspace* JSMediaSource::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSMediaSource, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForMediaSource.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForMediaSource = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForMediaSource.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForMediaSource = std::forward<decltype(space)>(space); }
    );
}

void JSMediaSource::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMediaSource*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSMediaSourceOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsMediaSource = jsCast<JSMediaSource*>(handle.slot()->asCell());
    auto& wrapped = jsMediaSource->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSMediaSourceOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMediaSource = static_cast<JSMediaSource*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsMediaSource->wrapped(), jsMediaSource);
}

MediaSource* JSMediaSource::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMediaSource*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(MEDIA_SOURCE)
