/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_SOURCE)

#include "JSManagedSourceBuffer.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsManagedSourceBufferConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsManagedSourceBuffer_onbufferedchange);
static JSC_DECLARE_CUSTOM_SETTER(setJSManagedSourceBuffer_onbufferedchange);

class JSManagedSourceBufferPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSManagedSourceBufferPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSManagedSourceBufferPrototype* ptr = new (NotNull, JSC::allocateCell<JSManagedSourceBufferPrototype>(vm)) JSManagedSourceBufferPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSManagedSourceBufferPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSManagedSourceBufferPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSManagedSourceBufferPrototype, JSManagedSourceBufferPrototype::Base);

using JSManagedSourceBufferDOMConstructor = JSDOMConstructorNotConstructable<JSManagedSourceBuffer>;

template<> const ClassInfo JSManagedSourceBufferDOMConstructor::s_info = { "ManagedSourceBuffer"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSManagedSourceBufferDOMConstructor) };

template<> JSValue JSManagedSourceBufferDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSourceBuffer::getConstructor(vm, &globalObject);
}

template<> void JSManagedSourceBufferDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "ManagedSourceBuffer"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSManagedSourceBuffer::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSManagedSourceBufferPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsManagedSourceBufferConstructor, 0 } },
    { "onbufferedchange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsManagedSourceBuffer_onbufferedchange, setJSManagedSourceBuffer_onbufferedchange } },
};

const ClassInfo JSManagedSourceBufferPrototype::s_info = { "ManagedSourceBuffer"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSManagedSourceBufferPrototype) };

void JSManagedSourceBufferPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSManagedSourceBuffer::info(), JSManagedSourceBufferPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSManagedSourceBuffer::s_info = { "ManagedSourceBuffer"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSManagedSourceBuffer) };

JSManagedSourceBuffer::JSManagedSourceBuffer(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ManagedSourceBuffer>&& impl)
    : JSSourceBuffer(structure, globalObject, WTFMove(impl))
{
}

Ref<ManagedSourceBuffer> JSManagedSourceBuffer::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, ManagedSourceBuffer>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

void JSManagedSourceBuffer::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(info()));

    vm.heap.reportExtraMemoryAllocated(this, wrapped().memoryCost());
}

JSObject* JSManagedSourceBuffer::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSManagedSourceBufferPrototype::createStructure(vm, &globalObject, JSSourceBuffer::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSManagedSourceBufferPrototype::create(vm, &globalObject, structure);
}

JSObject* JSManagedSourceBuffer::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSManagedSourceBuffer>(vm, globalObject);
}

JSValue JSManagedSourceBuffer::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSManagedSourceBufferDOMConstructor, DOMConstructorID::ManagedSourceBuffer>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsManagedSourceBufferConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSManagedSourceBufferPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSManagedSourceBuffer::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsManagedSourceBuffer_onbufferedchangeGetter(JSGlobalObject& lexicalGlobalObject, JSManagedSourceBuffer& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().bufferedchangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsManagedSourceBuffer_onbufferedchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSManagedSourceBuffer>::get<jsManagedSourceBuffer_onbufferedchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSManagedSourceBuffer_onbufferedchangeSetter(JSGlobalObject& lexicalGlobalObject, JSManagedSourceBuffer& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().bufferedchangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSManagedSourceBuffer_onbufferedchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSManagedSourceBuffer>::set<setJSManagedSourceBuffer_onbufferedchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSManagedSourceBuffer::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSManagedSourceBuffer, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForManagedSourceBuffer.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForManagedSourceBuffer = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForManagedSourceBuffer.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForManagedSourceBuffer = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSManagedSourceBuffer::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSManagedSourceBuffer*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    addWebCoreOpaqueRoot(visitor, thisObject->wrapped().opaqueRoot());
    visitor.reportExtraMemoryVisited(thisObject->wrapped().memoryCost());
}

DEFINE_VISIT_CHILDREN(JSManagedSourceBuffer);

size_t JSManagedSourceBuffer::estimatedSize(JSCell* cell, VM& vm)
{
    auto* thisObject = jsCast<JSManagedSourceBuffer*>(cell);
    return Base::estimatedSize(thisObject, vm) + thisObject->wrapped().memoryCost();
}

void JSManagedSourceBuffer::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSManagedSourceBuffer*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSManagedSourceBufferOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsManagedSourceBuffer = jsCast<JSManagedSourceBuffer*>(handle.slot()->asCell());
    auto& wrapped = jsManagedSourceBuffer->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSManagedSourceBufferOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsManagedSourceBuffer = static_cast<JSManagedSourceBuffer*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsManagedSourceBuffer->wrapped(), jsManagedSourceBuffer);
}


}

#endif // ENABLE(MEDIA_SOURCE)
