/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_SOURCE)

#include "JSManagedMediaSource.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/SortedArrayMap.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(ManagedMediaSource::PreferredQuality enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("low"),
        MAKE_STATIC_STRING_IMPL("medium"),
        MAKE_STATIC_STRING_IMPL("high"),
    };
    static_assert(static_cast<size_t>(ManagedMediaSource::PreferredQuality::Low) == 0, "ManagedMediaSource::PreferredQuality::Low is not 0 as expected");
    static_assert(static_cast<size_t>(ManagedMediaSource::PreferredQuality::Medium) == 1, "ManagedMediaSource::PreferredQuality::Medium is not 1 as expected");
    static_assert(static_cast<size_t>(ManagedMediaSource::PreferredQuality::High) == 2, "ManagedMediaSource::PreferredQuality::High is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, ManagedMediaSource::PreferredQuality enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<ManagedMediaSource::PreferredQuality> parseEnumerationFromString<ManagedMediaSource::PreferredQuality>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, ManagedMediaSource::PreferredQuality> mappings[] = {
        { "high", ManagedMediaSource::PreferredQuality::High },
        { "low", ManagedMediaSource::PreferredQuality::Low },
        { "medium", ManagedMediaSource::PreferredQuality::Medium },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<ManagedMediaSource::PreferredQuality> parseEnumeration<ManagedMediaSource::PreferredQuality>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<ManagedMediaSource::PreferredQuality>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<ManagedMediaSource::PreferredQuality>()
{
    return "\"low\", \"medium\", \"high\"";
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsManagedMediaSourceConstructorFunction_isTypeSupported);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsManagedMediaSourceConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsManagedMediaSource_quality);
static JSC_DECLARE_CUSTOM_GETTER(jsManagedMediaSource_onqualitychange);
static JSC_DECLARE_CUSTOM_SETTER(setJSManagedMediaSource_onqualitychange);
static JSC_DECLARE_CUSTOM_GETTER(jsManagedMediaSource_streaming);
static JSC_DECLARE_CUSTOM_GETTER(jsManagedMediaSource_onstartstreaming);
static JSC_DECLARE_CUSTOM_SETTER(setJSManagedMediaSource_onstartstreaming);
static JSC_DECLARE_CUSTOM_GETTER(jsManagedMediaSource_onendstreaming);
static JSC_DECLARE_CUSTOM_SETTER(setJSManagedMediaSource_onendstreaming);

class JSManagedMediaSourcePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSManagedMediaSourcePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSManagedMediaSourcePrototype* ptr = new (NotNull, JSC::allocateCell<JSManagedMediaSourcePrototype>(vm)) JSManagedMediaSourcePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSManagedMediaSourcePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSManagedMediaSourcePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSManagedMediaSourcePrototype, JSManagedMediaSourcePrototype::Base);

using JSManagedMediaSourceDOMConstructor = JSDOMConstructor<JSManagedMediaSource>;

/* Hash table for constructor */

static const HashTableValue JSManagedMediaSourceConstructorTableValues[] =
{
    { "isTypeSupported"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsManagedMediaSourceConstructorFunction_isTypeSupported, 1 } },
};

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSManagedMediaSourceDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSManagedMediaSourceDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "ManagedMediaSource");
    auto object = ManagedMediaSource::create(*context);
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<ManagedMediaSource>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<ManagedMediaSource>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSManagedMediaSourceDOMConstructorConstruct, JSManagedMediaSourceDOMConstructor::construct);

template<> const ClassInfo JSManagedMediaSourceDOMConstructor::s_info = { "ManagedMediaSource"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSManagedMediaSourceDOMConstructor) };

template<> JSValue JSManagedMediaSourceDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSMediaSource::getConstructor(vm, &globalObject);
}

template<> void JSManagedMediaSourceDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "ManagedMediaSource"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSManagedMediaSource::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSManagedMediaSource::info(), JSManagedMediaSourceConstructorTableValues, *this);
}

/* Hash table for prototype */

static const HashTableValue JSManagedMediaSourcePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsManagedMediaSourceConstructor, 0 } },
    { "quality"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsManagedMediaSource_quality, 0 } },
    { "onqualitychange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsManagedMediaSource_onqualitychange, setJSManagedMediaSource_onqualitychange } },
    { "streaming"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsManagedMediaSource_streaming, 0 } },
    { "onstartstreaming"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsManagedMediaSource_onstartstreaming, setJSManagedMediaSource_onstartstreaming } },
    { "onendstreaming"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsManagedMediaSource_onendstreaming, setJSManagedMediaSource_onendstreaming } },
};

const ClassInfo JSManagedMediaSourcePrototype::s_info = { "ManagedMediaSource"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSManagedMediaSourcePrototype) };

void JSManagedMediaSourcePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSManagedMediaSource::info(), JSManagedMediaSourcePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSManagedMediaSource::s_info = { "ManagedMediaSource"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSManagedMediaSource) };

JSManagedMediaSource::JSManagedMediaSource(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ManagedMediaSource>&& impl)
    : JSMediaSource(structure, globalObject, WTFMove(impl))
{
}

Ref<ManagedMediaSource> JSManagedMediaSource::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, ManagedMediaSource>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSManagedMediaSource::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSManagedMediaSourcePrototype::createStructure(vm, &globalObject, JSMediaSource::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSManagedMediaSourcePrototype::create(vm, &globalObject, structure);
}

JSObject* JSManagedMediaSource::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSManagedMediaSource>(vm, globalObject);
}

JSValue JSManagedMediaSource::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSManagedMediaSourceDOMConstructor, DOMConstructorID::ManagedMediaSource>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsManagedMediaSourceConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSManagedMediaSourcePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSManagedMediaSource::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsManagedMediaSource_qualityGetter(JSGlobalObject& lexicalGlobalObject, JSManagedMediaSource& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<ManagedMediaSource::PreferredQuality>>(lexicalGlobalObject, throwScope, impl.quality())));
}

JSC_DEFINE_CUSTOM_GETTER(jsManagedMediaSource_quality, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSManagedMediaSource>::get<jsManagedMediaSource_qualityGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsManagedMediaSource_onqualitychangeGetter(JSGlobalObject& lexicalGlobalObject, JSManagedMediaSource& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().qualitychangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsManagedMediaSource_onqualitychange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSManagedMediaSource>::get<jsManagedMediaSource_onqualitychangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSManagedMediaSource_onqualitychangeSetter(JSGlobalObject& lexicalGlobalObject, JSManagedMediaSource& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().qualitychangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSManagedMediaSource_onqualitychange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSManagedMediaSource>::set<setJSManagedMediaSource_onqualitychangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsManagedMediaSource_streamingGetter(JSGlobalObject& lexicalGlobalObject, JSManagedMediaSource& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.streaming())));
}

JSC_DEFINE_CUSTOM_GETTER(jsManagedMediaSource_streaming, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSManagedMediaSource>::get<jsManagedMediaSource_streamingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsManagedMediaSource_onstartstreamingGetter(JSGlobalObject& lexicalGlobalObject, JSManagedMediaSource& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().startstreamingEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsManagedMediaSource_onstartstreaming, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSManagedMediaSource>::get<jsManagedMediaSource_onstartstreamingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSManagedMediaSource_onstartstreamingSetter(JSGlobalObject& lexicalGlobalObject, JSManagedMediaSource& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().startstreamingEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSManagedMediaSource_onstartstreaming, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSManagedMediaSource>::set<setJSManagedMediaSource_onstartstreamingSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsManagedMediaSource_onendstreamingGetter(JSGlobalObject& lexicalGlobalObject, JSManagedMediaSource& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().endstreamingEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsManagedMediaSource_onendstreaming, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSManagedMediaSource>::get<jsManagedMediaSource_onendstreamingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSManagedMediaSource_onendstreamingSetter(JSGlobalObject& lexicalGlobalObject, JSManagedMediaSource& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().endstreamingEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSManagedMediaSource_onendstreaming, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSManagedMediaSource>::set<setJSManagedMediaSource_onendstreamingSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsManagedMediaSourceConstructorFunction_isTypeSupportedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto type = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, ManagedMediaSource::isTypeSupported(*context, WTFMove(type)))));
}

JSC_DEFINE_HOST_FUNCTION(jsManagedMediaSourceConstructorFunction_isTypeSupported, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSManagedMediaSource>::callStatic<jsManagedMediaSourceConstructorFunction_isTypeSupportedBody>(*lexicalGlobalObject, *callFrame, "isTypeSupported");
}

JSC::GCClient::IsoSubspace* JSManagedMediaSource::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSManagedMediaSource, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForManagedMediaSource.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForManagedMediaSource = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForManagedMediaSource.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForManagedMediaSource = std::forward<decltype(space)>(space); }
    );
}

void JSManagedMediaSource::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSManagedMediaSource*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSManagedMediaSourceOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsManagedMediaSource = jsCast<JSManagedMediaSource*>(handle.slot()->asCell());
    auto& wrapped = jsManagedMediaSource->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSManagedMediaSourceOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsManagedMediaSource = static_cast<JSManagedMediaSource*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsManagedMediaSource->wrapped(), jsManagedMediaSource);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ManagedMediaSource@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore18ManagedMediaSourceE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ManagedMediaSource>&& impl)
{

    if constexpr (std::is_polymorphic_v<ManagedMediaSource>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7ManagedMediaSource@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore18ManagedMediaSourceE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // ManagedMediaSource has subclasses. If ManagedMediaSource has subclasses that get passed
        // to toJS() we currently require ManagedMediaSource you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<ManagedMediaSource>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ManagedMediaSource& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(MEDIA_SOURCE)
