/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSIntersectionObserver.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSDocument.h"
#include "JSElement.h"
#include "JSIntersectionObserverCallback.h"
#include "JSIntersectionObserverEntry.h"
#include "JSNode.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> IntersectionObserver::Init convertDictionary<IntersectionObserver::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    IntersectionObserver::Init result;
    JSValue rootValue;
    if (isNullOrUndefined)
        rootValue = jsUndefined();
    else {
        rootValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "root"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!rootValue.isUndefined()) {
        result.root = convert<IDLNullable<IDLUnion<IDLInterface<Element>, IDLInterface<Document>>>>(lexicalGlobalObject, rootValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.root = std::nullopt;
    JSValue rootMarginValue;
    if (isNullOrUndefined)
        rootMarginValue = jsUndefined();
    else {
        rootMarginValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "rootMargin"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!rootMarginValue.isUndefined()) {
        result.rootMargin = convert<IDLDOMString>(lexicalGlobalObject, rootMarginValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.rootMargin = "0px"_s;
    JSValue thresholdValue;
    if (isNullOrUndefined)
        thresholdValue = jsUndefined();
    else {
        thresholdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "threshold"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!thresholdValue.isUndefined()) {
        result.threshold = convert<IDLUnion<IDLDouble, IDLSequence<IDLDouble>>>(lexicalGlobalObject, thresholdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.threshold = 0.0;
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsIntersectionObserverPrototypeFunction_observe);
static JSC_DECLARE_HOST_FUNCTION(jsIntersectionObserverPrototypeFunction_unobserve);
static JSC_DECLARE_HOST_FUNCTION(jsIntersectionObserverPrototypeFunction_disconnect);
static JSC_DECLARE_HOST_FUNCTION(jsIntersectionObserverPrototypeFunction_takeRecords);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsIntersectionObserverConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsIntersectionObserver_root);
static JSC_DECLARE_CUSTOM_GETTER(jsIntersectionObserver_rootMargin);
static JSC_DECLARE_CUSTOM_GETTER(jsIntersectionObserver_thresholds);

class JSIntersectionObserverPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSIntersectionObserverPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSIntersectionObserverPrototype* ptr = new (NotNull, JSC::allocateCell<JSIntersectionObserverPrototype>(vm)) JSIntersectionObserverPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIntersectionObserverPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSIntersectionObserverPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIntersectionObserverPrototype, JSIntersectionObserverPrototype::Base);

using JSIntersectionObserverDOMConstructor = JSDOMConstructor<JSIntersectionObserver>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSIntersectionObserverDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSIntersectionObserverDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "IntersectionObserver");
    auto& document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto callback = convert<IDLCallbackFunction<JSIntersectionObserverCallback>>(*lexicalGlobalObject, argument0.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "callback", "IntersectionObserver", nullptr); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto options = convert<IDLDictionary<IntersectionObserver::Init>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = IntersectionObserver::create(document, callback.releaseNonNull(), WTFMove(options));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<IntersectionObserver>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<IntersectionObserver>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSIntersectionObserverDOMConstructorConstruct, JSIntersectionObserverDOMConstructor::construct);

template<> const ClassInfo JSIntersectionObserverDOMConstructor::s_info = { "IntersectionObserver"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIntersectionObserverDOMConstructor) };

template<> JSValue JSIntersectionObserverDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSIntersectionObserverDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "IntersectionObserver"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSIntersectionObserver::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSIntersectionObserverPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsIntersectionObserverConstructor, 0 } },
    { "root"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIntersectionObserver_root, 0 } },
    { "rootMargin"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIntersectionObserver_rootMargin, 0 } },
    { "thresholds"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIntersectionObserver_thresholds, 0 } },
    { "observe"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIntersectionObserverPrototypeFunction_observe, 1 } },
    { "unobserve"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIntersectionObserverPrototypeFunction_unobserve, 1 } },
    { "disconnect"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIntersectionObserverPrototypeFunction_disconnect, 0 } },
    { "takeRecords"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIntersectionObserverPrototypeFunction_takeRecords, 0 } },
};

const ClassInfo JSIntersectionObserverPrototype::s_info = { "IntersectionObserver"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIntersectionObserverPrototype) };

void JSIntersectionObserverPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSIntersectionObserver::info(), JSIntersectionObserverPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSIntersectionObserver::s_info = { "IntersectionObserver"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIntersectionObserver) };

JSIntersectionObserver::JSIntersectionObserver(Structure* structure, JSDOMGlobalObject& globalObject, Ref<IntersectionObserver>&& impl)
    : JSDOMWrapper<IntersectionObserver>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSIntersectionObserver::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSIntersectionObserverPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSIntersectionObserverPrototype::create(vm, &globalObject, structure);
}

JSObject* JSIntersectionObserver::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSIntersectionObserver>(vm, globalObject);
}

JSValue JSIntersectionObserver::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIntersectionObserverDOMConstructor, DOMConstructorID::IntersectionObserver>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSIntersectionObserver::destroy(JSC::JSCell* cell)
{
    JSIntersectionObserver* thisObject = static_cast<JSIntersectionObserver*>(cell);
    thisObject->JSIntersectionObserver::~JSIntersectionObserver();
}

JSC_DEFINE_CUSTOM_GETTER(jsIntersectionObserverConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSIntersectionObserverPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSIntersectionObserver::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsIntersectionObserver_rootGetter(JSGlobalObject& lexicalGlobalObject, JSIntersectionObserver& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Node>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.root())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIntersectionObserver_root, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIntersectionObserver>::get<jsIntersectionObserver_rootGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsIntersectionObserver_rootMarginGetter(JSGlobalObject& lexicalGlobalObject, JSIntersectionObserver& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.rootMargin())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIntersectionObserver_rootMargin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIntersectionObserver>::get<jsIntersectionObserver_rootMarginGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsIntersectionObserver_thresholdsGetter(JSGlobalObject& lexicalGlobalObject, JSIntersectionObserver& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFrozenArray<IDLDouble>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.thresholds())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIntersectionObserver_thresholds, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIntersectionObserver>::get<jsIntersectionObserver_thresholdsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsIntersectionObserverPrototypeFunction_observeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIntersectionObserver>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLInterface<Element>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "target", "IntersectionObserver", "observe", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.observe(*target); })));
}

JSC_DEFINE_HOST_FUNCTION(jsIntersectionObserverPrototypeFunction_observe, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIntersectionObserver>::call<jsIntersectionObserverPrototypeFunction_observeBody>(*lexicalGlobalObject, *callFrame, "observe");
}

static inline JSC::EncodedJSValue jsIntersectionObserverPrototypeFunction_unobserveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIntersectionObserver>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLInterface<Element>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "target", "IntersectionObserver", "unobserve", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.unobserve(*target); })));
}

JSC_DEFINE_HOST_FUNCTION(jsIntersectionObserverPrototypeFunction_unobserve, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIntersectionObserver>::call<jsIntersectionObserverPrototypeFunction_unobserveBody>(*lexicalGlobalObject, *callFrame, "unobserve");
}

static inline JSC::EncodedJSValue jsIntersectionObserverPrototypeFunction_disconnectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIntersectionObserver>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.disconnect(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsIntersectionObserverPrototypeFunction_disconnect, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIntersectionObserver>::call<jsIntersectionObserverPrototypeFunction_disconnectBody>(*lexicalGlobalObject, *callFrame, "disconnect");
}

static inline JSC::EncodedJSValue jsIntersectionObserverPrototypeFunction_takeRecordsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIntersectionObserver>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    auto implResult = impl.takeRecords();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLSequence<IDLInterface<IntersectionObserverEntry>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(implResult.records))));
}

JSC_DEFINE_HOST_FUNCTION(jsIntersectionObserverPrototypeFunction_takeRecords, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIntersectionObserver>::call<jsIntersectionObserverPrototypeFunction_takeRecordsBody>(*lexicalGlobalObject, *callFrame, "takeRecords");
}

JSC::GCClient::IsoSubspace* JSIntersectionObserver::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSIntersectionObserver, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForIntersectionObserver.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForIntersectionObserver = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForIntersectionObserver.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForIntersectionObserver = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSIntersectionObserver::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSIntersectionObserver*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSIntersectionObserver);

template<typename Visitor>
void JSIntersectionObserver::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSIntersectionObserver*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSIntersectionObserver::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSIntersectionObserver::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSIntersectionObserver::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSIntersectionObserver*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

void JSIntersectionObserverOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsIntersectionObserver = static_cast<JSIntersectionObserver*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsIntersectionObserver->wrapped(), jsIntersectionObserver);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7IntersectionObserver@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore20IntersectionObserverE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<IntersectionObserver>&& impl)
{

    if constexpr (std::is_polymorphic_v<IntersectionObserver>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7IntersectionObserver@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore20IntersectionObserverE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // IntersectionObserver has subclasses. If IntersectionObserver has subclasses that get passed
        // to toJS() we currently require IntersectionObserver you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<IntersectionObserver>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, IntersectionObserver& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

IntersectionObserver* JSIntersectionObserver::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSIntersectionObserver*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
