/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM)

#include "JSImageCapture.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "Document.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSBlob.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSMediaStreamTrack.h"
#include "JSPhotoCapabilities.h"
#include "JSPhotoSettings.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsImageCapturePrototypeFunction_getPhotoCapabilities);
static JSC_DECLARE_HOST_FUNCTION(jsImageCapturePrototypeFunction_takePhoto);
static JSC_DECLARE_HOST_FUNCTION(jsImageCapturePrototypeFunction_getPhotoSettings);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsImageCaptureConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsImageCapture_track);

class JSImageCapturePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSImageCapturePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSImageCapturePrototype* ptr = new (NotNull, JSC::allocateCell<JSImageCapturePrototype>(vm)) JSImageCapturePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSImageCapturePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSImageCapturePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSImageCapturePrototype, JSImageCapturePrototype::Base);

using JSImageCaptureDOMConstructor = JSDOMConstructor<JSImageCapture>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSImageCaptureDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSImageCaptureDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "ImageCapture");
    auto& document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto videoTrack = convert<IDLInterface<MediaStreamTrack>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "videoTrack", "ImageCapture", nullptr, "MediaStreamTrack"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = ImageCapture::create(document, *videoTrack);
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<ImageCapture>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<ImageCapture>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSImageCaptureDOMConstructorConstruct, JSImageCaptureDOMConstructor::construct);

template<> const ClassInfo JSImageCaptureDOMConstructor::s_info = { "ImageCapture"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSImageCaptureDOMConstructor) };

template<> JSValue JSImageCaptureDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSImageCaptureDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "ImageCapture"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSImageCapture::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSImageCapturePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsImageCaptureConstructor, 0 } },
    { "track"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsImageCapture_track, 0 } },
    { "getPhotoCapabilities"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsImageCapturePrototypeFunction_getPhotoCapabilities, 0 } },
    { "takePhoto"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsImageCapturePrototypeFunction_takePhoto, 0 } },
    { "getPhotoSettings"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsImageCapturePrototypeFunction_getPhotoSettings, 0 } },
};

const ClassInfo JSImageCapturePrototype::s_info = { "ImageCapture"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSImageCapturePrototype) };

void JSImageCapturePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSImageCapture::info(), JSImageCapturePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSImageCapture::s_info = { "ImageCapture"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSImageCapture) };

JSImageCapture::JSImageCapture(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ImageCapture>&& impl)
    : JSDOMWrapper<ImageCapture>(structure, globalObject, WTFMove(impl))
{
}

static_assert(std::is_base_of<ActiveDOMObject, ImageCapture>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSImageCapture::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSImageCapturePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSImageCapturePrototype::create(vm, &globalObject, structure);
}

JSObject* JSImageCapture::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSImageCapture>(vm, globalObject);
}

JSValue JSImageCapture::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSImageCaptureDOMConstructor, DOMConstructorID::ImageCapture>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSImageCapture::destroy(JSC::JSCell* cell)
{
    JSImageCapture* thisObject = static_cast<JSImageCapture*>(cell);
    thisObject->JSImageCapture::~JSImageCapture();
}

JSC_DEFINE_CUSTOM_GETTER(jsImageCaptureConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSImageCapturePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSImageCapture::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsImageCapture_trackGetter(JSGlobalObject& lexicalGlobalObject, JSImageCapture& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<MediaStreamTrack>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.track())));
}

JSC_DEFINE_CUSTOM_GETTER(jsImageCapture_track, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSImageCapture>::get<jsImageCapture_trackGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsImageCapturePrototypeFunction_getPhotoCapabilitiesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSImageCapture>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLDictionary<PhotoCapabilities>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.getPhotoCapabilities(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsImageCapturePrototypeFunction_getPhotoCapabilities, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSImageCapture>::call<jsImageCapturePrototypeFunction_getPhotoCapabilitiesBody>(*lexicalGlobalObject, *callFrame, "getPhotoCapabilities");
}

static inline JSC::EncodedJSValue jsImageCapturePrototypeFunction_takePhotoBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSImageCapture>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto photoSettings = convert<IDLDictionary<PhotoSettings>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLInterface<Blob>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.takePhoto(WTFMove(photoSettings), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsImageCapturePrototypeFunction_takePhoto, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSImageCapture>::call<jsImageCapturePrototypeFunction_takePhotoBody>(*lexicalGlobalObject, *callFrame, "takePhoto");
}

static inline JSC::EncodedJSValue jsImageCapturePrototypeFunction_getPhotoSettingsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSImageCapture>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLDictionary<PhotoSettings>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.getPhotoSettings(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsImageCapturePrototypeFunction_getPhotoSettings, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSImageCapture>::call<jsImageCapturePrototypeFunction_getPhotoSettingsBody>(*lexicalGlobalObject, *callFrame, "getPhotoSettings");
}

JSC::GCClient::IsoSubspace* JSImageCapture::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSImageCapture, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForImageCapture.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForImageCapture = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForImageCapture.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForImageCapture = std::forward<decltype(space)>(space); }
    );
}

void JSImageCapture::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSImageCapture*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSImageCaptureOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsImageCapture = jsCast<JSImageCapture*>(handle.slot()->asCell());
    auto& wrapped = jsImageCapture->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSImageCaptureOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsImageCapture = static_cast<JSImageCapture*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsImageCapture->wrapped(), jsImageCapture);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ImageCapture@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12ImageCaptureE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ImageCapture>&& impl)
{

    if constexpr (std::is_polymorphic_v<ImageCapture>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7ImageCapture@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore12ImageCaptureE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // ImageCapture has subclasses. If ImageCapture has subclasses that get passed
        // to toJS() we currently require ImageCapture you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<ImageCapture>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ImageCapture& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

ImageCapture* JSImageCapture::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSImageCapture*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(MEDIA_STREAM)
