/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSIDBOpenDBRequest.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsIDBOpenDBRequestConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsIDBOpenDBRequest_onblocked);
static JSC_DECLARE_CUSTOM_SETTER(setJSIDBOpenDBRequest_onblocked);
static JSC_DECLARE_CUSTOM_GETTER(jsIDBOpenDBRequest_onupgradeneeded);
static JSC_DECLARE_CUSTOM_SETTER(setJSIDBOpenDBRequest_onupgradeneeded);

class JSIDBOpenDBRequestPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSIDBOpenDBRequestPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSIDBOpenDBRequestPrototype* ptr = new (NotNull, JSC::allocateCell<JSIDBOpenDBRequestPrototype>(vm)) JSIDBOpenDBRequestPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIDBOpenDBRequestPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSIDBOpenDBRequestPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIDBOpenDBRequestPrototype, JSIDBOpenDBRequestPrototype::Base);

using JSIDBOpenDBRequestDOMConstructor = JSDOMConstructorNotConstructable<JSIDBOpenDBRequest>;

template<> const ClassInfo JSIDBOpenDBRequestDOMConstructor::s_info = { "IDBOpenDBRequest"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBOpenDBRequestDOMConstructor) };

template<> JSValue JSIDBOpenDBRequestDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSIDBRequest::getConstructor(vm, &globalObject);
}

template<> void JSIDBOpenDBRequestDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "IDBOpenDBRequest"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSIDBOpenDBRequest::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSIDBOpenDBRequestPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBOpenDBRequestConstructor, 0 } },
    { "onblocked"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBOpenDBRequest_onblocked, setJSIDBOpenDBRequest_onblocked } },
    { "onupgradeneeded"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBOpenDBRequest_onupgradeneeded, setJSIDBOpenDBRequest_onupgradeneeded } },
};

const ClassInfo JSIDBOpenDBRequestPrototype::s_info = { "IDBOpenDBRequest"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBOpenDBRequestPrototype) };

void JSIDBOpenDBRequestPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSIDBOpenDBRequest::info(), JSIDBOpenDBRequestPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSIDBOpenDBRequest::s_info = { "IDBOpenDBRequest"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBOpenDBRequest) };

JSIDBOpenDBRequest::JSIDBOpenDBRequest(Structure* structure, JSDOMGlobalObject& globalObject, Ref<IDBOpenDBRequest>&& impl)
    : JSIDBRequest(structure, globalObject, WTFMove(impl))
{
}

Ref<IDBOpenDBRequest> JSIDBOpenDBRequest::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, IDBOpenDBRequest>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSIDBOpenDBRequest::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSIDBOpenDBRequestPrototype::createStructure(vm, &globalObject, JSIDBRequest::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSIDBOpenDBRequestPrototype::create(vm, &globalObject, structure);
}

JSObject* JSIDBOpenDBRequest::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSIDBOpenDBRequest>(vm, globalObject);
}

JSValue JSIDBOpenDBRequest::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBOpenDBRequestDOMConstructor, DOMConstructorID::IDBOpenDBRequest>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBOpenDBRequestConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSIDBOpenDBRequestPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSIDBOpenDBRequest::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsIDBOpenDBRequest_onblockedGetter(JSGlobalObject& lexicalGlobalObject, JSIDBOpenDBRequest& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().blockedEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBOpenDBRequest_onblocked, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBOpenDBRequest>::get<jsIDBOpenDBRequest_onblockedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSIDBOpenDBRequest_onblockedSetter(JSGlobalObject& lexicalGlobalObject, JSIDBOpenDBRequest& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().blockedEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSIDBOpenDBRequest_onblocked, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBOpenDBRequest>::set<setJSIDBOpenDBRequest_onblockedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsIDBOpenDBRequest_onupgradeneededGetter(JSGlobalObject& lexicalGlobalObject, JSIDBOpenDBRequest& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().upgradeneededEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBOpenDBRequest_onupgradeneeded, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBOpenDBRequest>::get<jsIDBOpenDBRequest_onupgradeneededGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSIDBOpenDBRequest_onupgradeneededSetter(JSGlobalObject& lexicalGlobalObject, JSIDBOpenDBRequest& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().upgradeneededEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSIDBOpenDBRequest_onupgradeneeded, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBOpenDBRequest>::set<setJSIDBOpenDBRequest_onupgradeneededSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSIDBOpenDBRequest::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSIDBOpenDBRequest, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForIDBOpenDBRequest.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForIDBOpenDBRequest = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForIDBOpenDBRequest.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForIDBOpenDBRequest = std::forward<decltype(space)>(space); }
    );
}

void JSIDBOpenDBRequest::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSIDBOpenDBRequest*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSIDBOpenDBRequestOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsIDBOpenDBRequest = jsCast<JSIDBOpenDBRequest*>(handle.slot()->asCell());
    auto& wrapped = jsIDBOpenDBRequest->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSIDBOpenDBRequestOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsIDBOpenDBRequest = static_cast<JSIDBOpenDBRequest*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsIDBOpenDBRequest->wrapped(), jsIDBOpenDBRequest);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<IDBOpenDBRequest>&& impl)
{
    return createWrapper<IDBOpenDBRequest>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, IDBOpenDBRequest& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

IDBOpenDBRequest* JSIDBOpenDBRequest::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSIDBOpenDBRequest*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
