/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLElement.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "Document.h"
#include "DocumentInlines.h"
#include "ElementInlines.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "HTMLNames.h"
#include "IDLTypes.h"
#include "JSCSSStyleDeclaration.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMStringMap.h"
#include "JSDOMWrapperCache.h"
#include "JSElementInternals.h"
#include "JSEventListener.h"
#include "JSFocusOptions.h"
#include "JSStylePropertyMap.h"
#include "Quirks.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsHTMLElementPrototypeFunction_click);
static JSC_DECLARE_HOST_FUNCTION(jsHTMLElementPrototypeFunction_attachInternals);
static JSC_DECLARE_HOST_FUNCTION(jsHTMLElementPrototypeFunction_showPopover);
static JSC_DECLARE_HOST_FUNCTION(jsHTMLElementPrototypeFunction_hidePopover);
static JSC_DECLARE_HOST_FUNCTION(jsHTMLElementPrototypeFunction_togglePopover);
static JSC_DECLARE_HOST_FUNCTION(jsHTMLElementPrototypeFunction_focus);
static JSC_DECLARE_HOST_FUNCTION(jsHTMLElementPrototypeFunction_blur);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElementConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_title);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_title);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_lang);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_lang);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_translate);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_translate);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_dir);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_dir);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_cue);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_cue);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_cuebackground);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_cuebackground);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_hidden);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_hidden);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_accessKey);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_accessKey);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_accessKeyLabel);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_draggable);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_draggable);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_spellcheck);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_spellcheck);
#if ENABLE(AUTOCAPITALIZE)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_autocapitalize);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_autocapitalize);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_innerText);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_innerText);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_inert);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_inert);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_popover);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_popover);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_outerText);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_outerText);
#if ENABLE(AUTOCORRECT)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_autocorrect);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_autocorrect);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_webkitdropzone);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_webkitdropzone);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_style);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_style);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_attributeStyleMap);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onbeforecopy);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onbeforecopy);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onbeforecut);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onbeforecut);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onbeforeinput);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onbeforeinput);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onbeforepaste);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onbeforepaste);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_contentEditable);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_contentEditable);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_enterKeyHint);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_enterKeyHint);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_isContentEditable);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_inputMode);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_inputMode);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onabort);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onabort);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onbeforetoggle);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onbeforetoggle);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onblur);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onblur);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_oncancel);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_oncancel);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_oncanplay);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_oncanplay);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_oncanplaythrough);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_oncanplaythrough);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onchange);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onchange);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onclick);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onclick);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onclose);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onclose);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_oncontentvisibilityautostatechange);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_oncontentvisibilityautostatechange);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_oncontextmenu);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_oncontextmenu);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_oncopy);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_oncopy);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_oncuechange);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_oncuechange);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_oncut);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_oncut);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_ondblclick);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_ondblclick);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_ondrag);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_ondrag);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_ondragend);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_ondragend);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_ondragenter);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_ondragenter);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_ondragleave);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_ondragleave);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_ondragover);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_ondragover);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_ondragstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_ondragstart);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_ondrop);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_ondrop);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_ondurationchange);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_ondurationchange);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onemptied);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onemptied);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onended);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onended);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onerror);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onerror);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onfocus);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onfocus);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onformdata);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onformdata);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_oninput);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_oninput);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_oninvalid);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_oninvalid);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onkeydown);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onkeydown);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onkeypress);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onkeypress);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onkeyup);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onkeyup);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onload);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onload);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onloadeddata);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onloadeddata);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onloadedmetadata);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onloadedmetadata);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onloadstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onloadstart);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onmousedown);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onmousedown);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onmouseenter);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onmouseenter);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onmouseleave);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onmouseleave);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onmousemove);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onmousemove);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onmouseout);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onmouseout);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onmouseover);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onmouseover);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onmouseup);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onmouseup);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onpaste);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onpaste);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onpause);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onpause);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onplay);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onplay);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onplaying);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onplaying);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onprogress);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onprogress);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onratechange);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onratechange);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onreset);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onreset);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onresize);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onresize);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onscroll);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onscroll);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onsecuritypolicyviolation);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onsecuritypolicyviolation);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onseeked);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onseeked);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onseeking);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onseeking);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onselect);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onselect);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onslotchange);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onslotchange);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onstalled);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onstalled);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onsubmit);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onsubmit);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onsuspend);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onsuspend);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_ontimeupdate);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_ontimeupdate);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_ontoggle);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_ontoggle);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onvolumechange);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onvolumechange);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onwaiting);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onwaiting);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onwebkitanimationend);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onwebkitanimationend);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onwebkitanimationiteration);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onwebkitanimationiteration);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onwebkitanimationstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onwebkitanimationstart);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onwebkittransitionend);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onwebkittransitionend);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onwheel);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onwheel);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onmousewheel);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onmousewheel);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onsearch);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onsearch);
#if ENABLE(TOUCH_EVENTS)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_ontouchcancel);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_ontouchcancel);
#endif
#if ENABLE(TOUCH_EVENTS)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_ontouchend);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_ontouchend);
#endif
#if ENABLE(TOUCH_EVENTS)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_ontouchmove);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_ontouchmove);
#endif
#if ENABLE(TOUCH_EVENTS)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_ontouchstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_ontouchstart);
#endif
#if ENABLE(TOUCH_EVENTS)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_ontouchforcechange);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_ontouchforcechange);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onwebkitmouseforcechanged);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onwebkitmouseforcechanged);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onwebkitmouseforcedown);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onwebkitmouseforcedown);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onwebkitmouseforcewillbegin);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onwebkitmouseforcewillbegin);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onwebkitmouseforceup);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onwebkitmouseforceup);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onanimationstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onanimationstart);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onanimationiteration);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onanimationiteration);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onanimationend);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onanimationend);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onanimationcancel);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onanimationcancel);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_ontransitionrun);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_ontransitionrun);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_ontransitionstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_ontransitionstart);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_ontransitionend);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_ontransitionend);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_ontransitioncancel);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_ontransitioncancel);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_ongotpointercapture);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_ongotpointercapture);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onlostpointercapture);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onlostpointercapture);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onpointerdown);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onpointerdown);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onpointermove);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onpointermove);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onpointerup);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onpointerup);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onpointercancel);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onpointercancel);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onpointerover);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onpointerover);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onpointerout);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onpointerout);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onpointerenter);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onpointerenter);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onpointerleave);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onpointerleave);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onselectstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onselectstart);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_onselectionchange);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_onselectionchange);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_offsetParent);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_offsetTop);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_offsetLeft);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_offsetWidth);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_offsetHeight);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_dataset);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_nonce);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_nonce);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_autofocus);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_autofocus);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLElement_tabIndex);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLElement_tabIndex);

class JSHTMLElementPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSHTMLElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLElementPrototype>(vm)) JSHTMLElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLElementPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLElementPrototype, JSHTMLElementPrototype::Base);

using JSHTMLElementDOMConstructor = JSDOMConstructor<JSHTMLElement>;

template<> JSC::EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSHTMLElementDOMConstructor::construct(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    ASSERT(callFrame);
    return constructJSHTMLElement(lexicalGlobalObject, *callFrame);
}
JSC_ANNOTATE_HOST_FUNCTION(JSHTMLElementDOMConstructorConstruct, JSHTMLElementDOMConstructor::construct);

template<> const ClassInfo JSHTMLElementDOMConstructor::s_info = { "HTMLElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLElementDOMConstructor) };

template<> JSValue JSHTMLElementDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLElementDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "HTMLElement"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSHTMLElement::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLElementPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElementConstructor, 0 } },
    { "title"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_title, setJSHTMLElement_title } },
    { "lang"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_lang, setJSHTMLElement_lang } },
    { "translate"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_translate, setJSHTMLElement_translate } },
    { "dir"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_dir, setJSHTMLElement_dir } },
    { "cue"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_cue, setJSHTMLElement_cue } },
    { "cuebackground"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_cuebackground, setJSHTMLElement_cuebackground } },
    { "hidden"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_hidden, setJSHTMLElement_hidden } },
    { "accessKey"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_accessKey, setJSHTMLElement_accessKey } },
    { "accessKeyLabel"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_accessKeyLabel, 0 } },
    { "draggable"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_draggable, setJSHTMLElement_draggable } },
    { "spellcheck"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_spellcheck, setJSHTMLElement_spellcheck } },
#if ENABLE(AUTOCAPITALIZE)
    { "autocapitalize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_autocapitalize, setJSHTMLElement_autocapitalize } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    { "innerText"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_innerText, setJSHTMLElement_innerText } },
    { "inert"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_inert, setJSHTMLElement_inert } },
    { "popover"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_popover, setJSHTMLElement_popover } },
    { "outerText"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_outerText, setJSHTMLElement_outerText } },
#if ENABLE(AUTOCORRECT)
    { "autocorrect"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_autocorrect, setJSHTMLElement_autocorrect } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    { "webkitdropzone"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_webkitdropzone, setJSHTMLElement_webkitdropzone } },
    { "style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_style, setJSHTMLElement_style } },
    { "attributeStyleMap"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_attributeStyleMap, 0 } },
    { "onbeforecopy"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onbeforecopy, setJSHTMLElement_onbeforecopy } },
    { "onbeforecut"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onbeforecut, setJSHTMLElement_onbeforecut } },
    { "onbeforeinput"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onbeforeinput, setJSHTMLElement_onbeforeinput } },
    { "onbeforepaste"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onbeforepaste, setJSHTMLElement_onbeforepaste } },
    { "contentEditable"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_contentEditable, setJSHTMLElement_contentEditable } },
    { "enterKeyHint"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_enterKeyHint, setJSHTMLElement_enterKeyHint } },
    { "isContentEditable"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_isContentEditable, 0 } },
    { "inputMode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_inputMode, setJSHTMLElement_inputMode } },
    { "onabort"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onabort, setJSHTMLElement_onabort } },
    { "onbeforetoggle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onbeforetoggle, setJSHTMLElement_onbeforetoggle } },
    { "onblur"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onblur, setJSHTMLElement_onblur } },
    { "oncancel"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_oncancel, setJSHTMLElement_oncancel } },
    { "oncanplay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_oncanplay, setJSHTMLElement_oncanplay } },
    { "oncanplaythrough"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_oncanplaythrough, setJSHTMLElement_oncanplaythrough } },
    { "onchange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onchange, setJSHTMLElement_onchange } },
    { "onclick"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onclick, setJSHTMLElement_onclick } },
    { "onclose"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onclose, setJSHTMLElement_onclose } },
    { "oncontentvisibilityautostatechange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_oncontentvisibilityautostatechange, setJSHTMLElement_oncontentvisibilityautostatechange } },
    { "oncontextmenu"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_oncontextmenu, setJSHTMLElement_oncontextmenu } },
    { "oncopy"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_oncopy, setJSHTMLElement_oncopy } },
    { "oncuechange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_oncuechange, setJSHTMLElement_oncuechange } },
    { "oncut"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_oncut, setJSHTMLElement_oncut } },
    { "ondblclick"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_ondblclick, setJSHTMLElement_ondblclick } },
    { "ondrag"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_ondrag, setJSHTMLElement_ondrag } },
    { "ondragend"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_ondragend, setJSHTMLElement_ondragend } },
    { "ondragenter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_ondragenter, setJSHTMLElement_ondragenter } },
    { "ondragleave"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_ondragleave, setJSHTMLElement_ondragleave } },
    { "ondragover"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_ondragover, setJSHTMLElement_ondragover } },
    { "ondragstart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_ondragstart, setJSHTMLElement_ondragstart } },
    { "ondrop"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_ondrop, setJSHTMLElement_ondrop } },
    { "ondurationchange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_ondurationchange, setJSHTMLElement_ondurationchange } },
    { "onemptied"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onemptied, setJSHTMLElement_onemptied } },
    { "onended"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onended, setJSHTMLElement_onended } },
    { "onerror"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onerror, setJSHTMLElement_onerror } },
    { "onfocus"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onfocus, setJSHTMLElement_onfocus } },
    { "onformdata"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onformdata, setJSHTMLElement_onformdata } },
    { "oninput"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_oninput, setJSHTMLElement_oninput } },
    { "oninvalid"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_oninvalid, setJSHTMLElement_oninvalid } },
    { "onkeydown"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onkeydown, setJSHTMLElement_onkeydown } },
    { "onkeypress"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onkeypress, setJSHTMLElement_onkeypress } },
    { "onkeyup"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onkeyup, setJSHTMLElement_onkeyup } },
    { "onload"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onload, setJSHTMLElement_onload } },
    { "onloadeddata"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onloadeddata, setJSHTMLElement_onloadeddata } },
    { "onloadedmetadata"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onloadedmetadata, setJSHTMLElement_onloadedmetadata } },
    { "onloadstart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onloadstart, setJSHTMLElement_onloadstart } },
    { "onmousedown"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onmousedown, setJSHTMLElement_onmousedown } },
    { "onmouseenter"_s, static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onmouseenter, setJSHTMLElement_onmouseenter } },
    { "onmouseleave"_s, static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onmouseleave, setJSHTMLElement_onmouseleave } },
    { "onmousemove"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onmousemove, setJSHTMLElement_onmousemove } },
    { "onmouseout"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onmouseout, setJSHTMLElement_onmouseout } },
    { "onmouseover"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onmouseover, setJSHTMLElement_onmouseover } },
    { "onmouseup"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onmouseup, setJSHTMLElement_onmouseup } },
    { "onpaste"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onpaste, setJSHTMLElement_onpaste } },
    { "onpause"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onpause, setJSHTMLElement_onpause } },
    { "onplay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onplay, setJSHTMLElement_onplay } },
    { "onplaying"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onplaying, setJSHTMLElement_onplaying } },
    { "onprogress"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onprogress, setJSHTMLElement_onprogress } },
    { "onratechange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onratechange, setJSHTMLElement_onratechange } },
    { "onreset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onreset, setJSHTMLElement_onreset } },
    { "onresize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onresize, setJSHTMLElement_onresize } },
    { "onscroll"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onscroll, setJSHTMLElement_onscroll } },
    { "onsecuritypolicyviolation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onsecuritypolicyviolation, setJSHTMLElement_onsecuritypolicyviolation } },
    { "onseeked"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onseeked, setJSHTMLElement_onseeked } },
    { "onseeking"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onseeking, setJSHTMLElement_onseeking } },
    { "onselect"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onselect, setJSHTMLElement_onselect } },
    { "onslotchange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onslotchange, setJSHTMLElement_onslotchange } },
    { "onstalled"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onstalled, setJSHTMLElement_onstalled } },
    { "onsubmit"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onsubmit, setJSHTMLElement_onsubmit } },
    { "onsuspend"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onsuspend, setJSHTMLElement_onsuspend } },
    { "ontimeupdate"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_ontimeupdate, setJSHTMLElement_ontimeupdate } },
    { "ontoggle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_ontoggle, setJSHTMLElement_ontoggle } },
    { "onvolumechange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onvolumechange, setJSHTMLElement_onvolumechange } },
    { "onwaiting"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onwaiting, setJSHTMLElement_onwaiting } },
    { "onwebkitanimationend"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onwebkitanimationend, setJSHTMLElement_onwebkitanimationend } },
    { "onwebkitanimationiteration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onwebkitanimationiteration, setJSHTMLElement_onwebkitanimationiteration } },
    { "onwebkitanimationstart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onwebkitanimationstart, setJSHTMLElement_onwebkitanimationstart } },
    { "onwebkittransitionend"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onwebkittransitionend, setJSHTMLElement_onwebkittransitionend } },
    { "onwheel"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onwheel, setJSHTMLElement_onwheel } },
    { "onmousewheel"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onmousewheel, setJSHTMLElement_onmousewheel } },
    { "onsearch"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onsearch, setJSHTMLElement_onsearch } },
#if ENABLE(TOUCH_EVENTS)
    { "ontouchcancel"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_ontouchcancel, setJSHTMLElement_ontouchcancel } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchend"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_ontouchend, setJSHTMLElement_ontouchend } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchmove"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_ontouchmove, setJSHTMLElement_ontouchmove } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchstart"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_ontouchstart, setJSHTMLElement_ontouchstart } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchforcechange"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_ontouchforcechange, setJSHTMLElement_ontouchforcechange } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    { "onwebkitmouseforcechanged"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onwebkitmouseforcechanged, setJSHTMLElement_onwebkitmouseforcechanged } },
    { "onwebkitmouseforcedown"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onwebkitmouseforcedown, setJSHTMLElement_onwebkitmouseforcedown } },
    { "onwebkitmouseforcewillbegin"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onwebkitmouseforcewillbegin, setJSHTMLElement_onwebkitmouseforcewillbegin } },
    { "onwebkitmouseforceup"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onwebkitmouseforceup, setJSHTMLElement_onwebkitmouseforceup } },
    { "onanimationstart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onanimationstart, setJSHTMLElement_onanimationstart } },
    { "onanimationiteration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onanimationiteration, setJSHTMLElement_onanimationiteration } },
    { "onanimationend"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onanimationend, setJSHTMLElement_onanimationend } },
    { "onanimationcancel"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onanimationcancel, setJSHTMLElement_onanimationcancel } },
    { "ontransitionrun"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_ontransitionrun, setJSHTMLElement_ontransitionrun } },
    { "ontransitionstart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_ontransitionstart, setJSHTMLElement_ontransitionstart } },
    { "ontransitionend"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_ontransitionend, setJSHTMLElement_ontransitionend } },
    { "ontransitioncancel"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_ontransitioncancel, setJSHTMLElement_ontransitioncancel } },
    { "ongotpointercapture"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_ongotpointercapture, setJSHTMLElement_ongotpointercapture } },
    { "onlostpointercapture"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onlostpointercapture, setJSHTMLElement_onlostpointercapture } },
    { "onpointerdown"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onpointerdown, setJSHTMLElement_onpointerdown } },
    { "onpointermove"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onpointermove, setJSHTMLElement_onpointermove } },
    { "onpointerup"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onpointerup, setJSHTMLElement_onpointerup } },
    { "onpointercancel"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onpointercancel, setJSHTMLElement_onpointercancel } },
    { "onpointerover"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onpointerover, setJSHTMLElement_onpointerover } },
    { "onpointerout"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onpointerout, setJSHTMLElement_onpointerout } },
    { "onpointerenter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onpointerenter, setJSHTMLElement_onpointerenter } },
    { "onpointerleave"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onpointerleave, setJSHTMLElement_onpointerleave } },
    { "onselectstart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onselectstart, setJSHTMLElement_onselectstart } },
    { "onselectionchange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_onselectionchange, setJSHTMLElement_onselectionchange } },
    { "offsetParent"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_offsetParent, 0 } },
    { "offsetTop"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_offsetTop, 0 } },
    { "offsetLeft"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_offsetLeft, 0 } },
    { "offsetWidth"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_offsetWidth, 0 } },
    { "offsetHeight"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_offsetHeight, 0 } },
    { "dataset"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_dataset, 0 } },
    { "nonce"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_nonce, setJSHTMLElement_nonce } },
    { "autofocus"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_autofocus, setJSHTMLElement_autofocus } },
    { "tabIndex"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLElement_tabIndex, setJSHTMLElement_tabIndex } },
    { "click"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLElementPrototypeFunction_click, 0 } },
    { "attachInternals"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLElementPrototypeFunction_attachInternals, 0 } },
    { "showPopover"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLElementPrototypeFunction_showPopover, 0 } },
    { "hidePopover"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLElementPrototypeFunction_hidePopover, 0 } },
    { "togglePopover"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLElementPrototypeFunction_togglePopover, 0 } },
    { "focus"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLElementPrototypeFunction_focus, 0 } },
    { "blur"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLElementPrototypeFunction_blur, 0 } },
};

const ClassInfo JSHTMLElementPrototype::s_info = { "HTMLElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLElementPrototype) };

void JSHTMLElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLElement::info(), JSHTMLElementPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().formAssociatedCustomElementsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "attachInternals"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().popoverAttributeEnabled && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisablePopoverAttributeQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "showPopover"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().popoverAttributeEnabled && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisablePopoverAttributeQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "hidePopover"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().popoverAttributeEnabled && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisablePopoverAttributeQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "togglePopover"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().popoverAttributeEnabled && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisablePopoverAttributeQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "popover"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssTypedOMEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "attributeStyleMap"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().enterKeyHintEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "enterKeyHint"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().searchInputIncrementalAttributeAndSearchEventEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "onsearch"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#if ENABLE(TOUCH_EVENTS)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().touchEventsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "ontouchcancel"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(TOUCH_EVENTS)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().touchEventsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "ontouchend"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(TOUCH_EVENTS)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().touchEventsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "ontouchmove"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(TOUCH_EVENTS)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().touchEventsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "ontouchstart"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(TOUCH_EVENTS)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().touchEventsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "ontouchforcechange"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSHTMLElement::s_info = { "HTMLElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLElement) };

JSHTMLElement::JSHTMLElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLElement>&& impl)
    : JSElement(structure, globalObject, WTFMove(impl))
{
}

Ref<HTMLElement> JSHTMLElement::protectedWrapped() const
{
    return wrapped();
}

JSObject* JSHTMLElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSHTMLElementPrototype::createStructure(vm, &globalObject, JSElement::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSHTMLElementPrototype::create(vm, &globalObject, structure);
}

JSObject* JSHTMLElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSHTMLElement>(vm, globalObject);
}

JSValue JSHTMLElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLElementDOMConstructor, DOMConstructorID::HTMLElement>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElementConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSHTMLElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsHTMLElement_titleGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::titleAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_title, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_titleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_titleSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::titleAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_title, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_titleSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_langGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::langAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_lang, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_langGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_langSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::langAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_lang, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_langSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_translateGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.translate())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_translate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_translateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_translateSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setTranslate(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_translate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_translateSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_dirGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.dir())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_dir, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_dirGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_dirSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setDir(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_dir, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_dirSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_cueGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::cueAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_cue, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_cueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_cueSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::cueAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_cue, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_cueSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_cuebackgroundGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::cuebackgroundAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_cuebackground, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_cuebackgroundGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_cuebackgroundSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::cuebackgroundAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_cuebackground, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_cuebackgroundSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_hiddenGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::hiddenAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_hidden, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_hiddenGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_hiddenSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::hiddenAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_hidden, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_hiddenSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_accessKeyGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::accesskeyAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_accessKey, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_accessKeyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_accessKeySetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::accesskeyAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_accessKey, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_accessKeySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_accessKeyLabelGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.accessKeyLabel())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_accessKeyLabel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_accessKeyLabelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLElement_draggableGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.draggable())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_draggable, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_draggableGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_draggableSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setDraggable(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_draggable, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_draggableSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_spellcheckGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.spellcheck())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_spellcheck, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_spellcheckGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_spellcheckSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setSpellcheck(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_spellcheck, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_spellcheckSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#if ENABLE(AUTOCAPITALIZE)
static inline JSValue jsHTMLElement_autocapitalizeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.autocapitalize())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_autocapitalize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_autocapitalizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(AUTOCAPITALIZE)
static inline bool setJSHTMLElement_autocapitalizeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAutocapitalize(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_autocapitalize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_autocapitalizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

static inline JSValue jsHTMLElement_innerTextGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.innerText())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_innerText, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_innerTextGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_innerTextSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLLegacyNullToEmptyStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setInnerText(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_innerText, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_innerTextSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_inertGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::inertAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_inert, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_inertGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_inertSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::inertAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_inert, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_inertSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_popoverGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLAtomStringAdaptor<IDLDOMString>>>(lexicalGlobalObject, throwScope, impl.popover())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_popover, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_popoverGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_popoverSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLAtomStringAdaptor<IDLDOMString>>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setPopover(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_popover, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_popoverSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_outerTextGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.outerText())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_outerText, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_outerTextGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_outerTextSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLLegacyNullToEmptyStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setOuterText(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_outerText, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_outerTextSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#if ENABLE(AUTOCORRECT)
static inline JSValue jsHTMLElement_autocorrectGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.autocorrect())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_autocorrect, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_autocorrectGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(AUTOCORRECT)
static inline bool setJSHTMLElement_autocorrectSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAutocorrect(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_autocorrect, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_autocorrectSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

static inline JSValue jsHTMLElement_webkitdropzoneGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::webkitdropzoneAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_webkitdropzone, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_webkitdropzoneGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_webkitdropzoneSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::webkitdropzoneAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_webkitdropzone, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_webkitdropzoneSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_styleGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<CSSStyleDeclaration>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.cssomStyle())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_style, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_styleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_styleSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto id = Identifier::fromString(vm, "style"_s);
    auto valueToForwardTo = thisObject.get(&lexicalGlobalObject, id);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!valueToForwardTo.isObject())) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return false;
    }
    auto forwardId = Identifier::fromString(vm, "cssText"_s);
    PutPropertySlot slot(valueToForwardTo, false);
    asObject(valueToForwardTo)->methodTable()->put(asObject(valueToForwardTo), &lexicalGlobalObject, forwardId, value, slot);
    RETURN_IF_EXCEPTION(throwScope, false);
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_style, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_styleSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_attributeStyleMapGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    if (JSValue cachedValue = thisObject.m_attributeStyleMap.get())
        return cachedValue;
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<StylePropertyMap>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.ensureAttributeStyleMap());
    RETURN_IF_EXCEPTION(throwScope, { });
    thisObject.m_attributeStyleMap.set(JSC::getVM(&lexicalGlobalObject), &thisObject, result);
    return result;
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_attributeStyleMap, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_attributeStyleMapGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLElement_onbeforecopyGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().beforecopyEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onbeforecopy, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onbeforecopyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onbeforecopySetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().beforecopyEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onbeforecopy, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onbeforecopySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onbeforecutGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().beforecutEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onbeforecut, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onbeforecutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onbeforecutSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().beforecutEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onbeforecut, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onbeforecutSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onbeforeinputGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().beforeinputEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onbeforeinput, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onbeforeinputGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onbeforeinputSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().beforeinputEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onbeforeinput, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onbeforeinputSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onbeforepasteGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().beforepasteEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onbeforepaste, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onbeforepasteGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onbeforepasteSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().beforepasteEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onbeforepaste, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onbeforepasteSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_contentEditableGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.contentEditable())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_contentEditable, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_contentEditableGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_contentEditableSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setContentEditable(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_contentEditable, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_contentEditableSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_enterKeyHintGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.enterKeyHint())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_enterKeyHint, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_enterKeyHintGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_enterKeyHintSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setEnterKeyHint(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_enterKeyHint, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_enterKeyHintSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_isContentEditableGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isContentEditable())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_isContentEditable, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_isContentEditableGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLElement_inputModeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.inputMode())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_inputMode, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_inputModeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_inputModeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setInputMode(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_inputMode, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_inputModeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onabortGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().abortEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onabort, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onabortGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onabortSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().abortEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onabort, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onabortSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onbeforetoggleGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().beforetoggleEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onbeforetoggle, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onbeforetoggleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onbeforetoggleSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().beforetoggleEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onbeforetoggle, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onbeforetoggleSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onblurGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().blurEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onblur, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onblurGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onblurSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().blurEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onblur, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onblurSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_oncancelGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().cancelEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_oncancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_oncancelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_oncancelSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().cancelEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_oncancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_oncancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_oncanplayGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().canplayEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_oncanplay, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_oncanplayGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_oncanplaySetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().canplayEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_oncanplay, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_oncanplaySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_oncanplaythroughGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().canplaythroughEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_oncanplaythrough, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_oncanplaythroughGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_oncanplaythroughSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().canplaythroughEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_oncanplaythrough, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_oncanplaythroughSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onchangeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().changeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onchangeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().changeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onclickGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().clickEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onclick, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onclickGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onclickSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().clickEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onclick, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onclickSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_oncloseGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().closeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onclose, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_oncloseGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_oncloseSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().closeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onclose, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_oncloseSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_oncontentvisibilityautostatechangeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().contentvisibilityautostatechangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_oncontentvisibilityautostatechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_oncontentvisibilityautostatechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_oncontentvisibilityautostatechangeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().contentvisibilityautostatechangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_oncontentvisibilityautostatechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_oncontentvisibilityautostatechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_oncontextmenuGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().contextmenuEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_oncontextmenu, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_oncontextmenuGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_oncontextmenuSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().contextmenuEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_oncontextmenu, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_oncontextmenuSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_oncopyGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().copyEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_oncopy, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_oncopyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_oncopySetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().copyEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_oncopy, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_oncopySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_oncuechangeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().cuechangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_oncuechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_oncuechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_oncuechangeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().cuechangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_oncuechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_oncuechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_oncutGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().cutEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_oncut, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_oncutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_oncutSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().cutEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_oncut, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_oncutSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_ondblclickGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dblclickEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_ondblclick, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_ondblclickGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_ondblclickSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().dblclickEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_ondblclick, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_ondblclickSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_ondragGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dragEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_ondrag, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_ondragGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_ondragSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().dragEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_ondrag, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_ondragSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_ondragendGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dragendEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_ondragend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_ondragendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_ondragendSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().dragendEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_ondragend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_ondragendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_ondragenterGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dragenterEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_ondragenter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_ondragenterGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_ondragenterSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().dragenterEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_ondragenter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_ondragenterSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_ondragleaveGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dragleaveEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_ondragleave, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_ondragleaveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_ondragleaveSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().dragleaveEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_ondragleave, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_ondragleaveSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_ondragoverGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dragoverEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_ondragover, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_ondragoverGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_ondragoverSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().dragoverEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_ondragover, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_ondragoverSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_ondragstartGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dragstartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_ondragstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_ondragstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_ondragstartSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().dragstartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_ondragstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_ondragstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_ondropGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dropEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_ondrop, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_ondropGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_ondropSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().dropEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_ondrop, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_ondropSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_ondurationchangeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().durationchangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_ondurationchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_ondurationchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_ondurationchangeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().durationchangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_ondurationchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_ondurationchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onemptiedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().emptiedEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onemptied, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onemptiedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onemptiedSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().emptiedEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onemptied, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onemptiedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onendedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().endedEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onended, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onendedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onendedSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().endedEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onended, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onendedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onerrorGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().errorEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onerrorSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().errorEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onfocusGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().focusEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onfocus, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onfocusGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onfocusSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().focusEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onfocus, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onfocusSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onformdataGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().formdataEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onformdata, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onformdataGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onformdataSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().formdataEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onformdata, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onformdataSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_oninputGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().inputEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_oninput, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_oninputGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_oninputSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().inputEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_oninput, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_oninputSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_oninvalidGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().invalidEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_oninvalid, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_oninvalidGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_oninvalidSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().invalidEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_oninvalid, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_oninvalidSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onkeydownGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().keydownEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onkeydown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onkeydownGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onkeydownSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().keydownEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onkeydown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onkeydownSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onkeypressGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().keypressEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onkeypress, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onkeypressGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onkeypressSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().keypressEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onkeypress, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onkeypressSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onkeyupGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().keyupEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onkeyup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onkeyupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onkeyupSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().keyupEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onkeyup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onkeyupSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onloadGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().loadEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onload, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onloadGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onloadSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().loadEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onload, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onloadSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onloadeddataGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().loadeddataEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onloadeddata, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onloadeddataGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onloadeddataSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().loadeddataEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onloadeddata, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onloadeddataSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onloadedmetadataGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().loadedmetadataEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onloadedmetadata, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onloadedmetadataGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onloadedmetadataSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().loadedmetadataEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onloadedmetadata, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onloadedmetadataSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onloadstartGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().loadstartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onloadstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onloadstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onloadstartSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().loadstartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onloadstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onloadstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onmousedownGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mousedownEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onmousedown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onmousedownGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onmousedownSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().mousedownEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onmousedown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onmousedownSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onmouseenterGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mouseenterEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onmouseenter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onmouseenterGetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onmouseenterSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().mouseenterEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onmouseenter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onmouseenterSetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onmouseleaveGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mouseleaveEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onmouseleave, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onmouseleaveGetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onmouseleaveSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().mouseleaveEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onmouseleave, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onmouseleaveSetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onmousemoveGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mousemoveEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onmousemove, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onmousemoveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onmousemoveSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().mousemoveEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onmousemove, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onmousemoveSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onmouseoutGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mouseoutEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onmouseout, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onmouseoutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onmouseoutSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().mouseoutEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onmouseout, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onmouseoutSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onmouseoverGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mouseoverEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onmouseover, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onmouseoverGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onmouseoverSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().mouseoverEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onmouseover, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onmouseoverSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onmouseupGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mouseupEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onmouseup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onmouseupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onmouseupSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().mouseupEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onmouseup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onmouseupSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onpasteGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pasteEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onpaste, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onpasteGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onpasteSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().pasteEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onpaste, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onpasteSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onpauseGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pauseEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onpause, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onpauseGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onpauseSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().pauseEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onpause, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onpauseSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onplayGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().playEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onplay, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onplayGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onplaySetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().playEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onplay, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onplaySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onplayingGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().playingEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onplaying, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onplayingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onplayingSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().playingEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onplaying, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onplayingSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onprogressGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().progressEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onprogress, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onprogressGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onprogressSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().progressEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onprogress, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onprogressSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onratechangeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().ratechangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onratechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onratechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onratechangeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().ratechangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onratechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onratechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onresetGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().resetEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onreset, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onresetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onresetSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().resetEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onreset, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onresetSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onresizeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().resizeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onresize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onresizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onresizeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().resizeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onresize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onresizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onscrollGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().scrollEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onscroll, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onscrollGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onscrollSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().scrollEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onscroll, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onscrollSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onsecuritypolicyviolationGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().securitypolicyviolationEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onsecuritypolicyviolation, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onsecuritypolicyviolationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onsecuritypolicyviolationSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().securitypolicyviolationEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onsecuritypolicyviolation, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onsecuritypolicyviolationSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onseekedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().seekedEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onseeked, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onseekedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onseekedSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().seekedEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onseeked, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onseekedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onseekingGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().seekingEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onseeking, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onseekingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onseekingSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().seekingEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onseeking, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onseekingSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onselectGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().selectEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onselect, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onselectGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onselectSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().selectEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onselect, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onselectSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onslotchangeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().slotchangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onslotchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onslotchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onslotchangeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().slotchangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onslotchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onslotchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onstalledGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().stalledEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onstalled, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onstalledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onstalledSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().stalledEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onstalled, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onstalledSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onsubmitGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().submitEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onsubmit, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onsubmitGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onsubmitSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().submitEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onsubmit, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onsubmitSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onsuspendGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().suspendEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onsuspend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onsuspendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onsuspendSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().suspendEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onsuspend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onsuspendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_ontimeupdateGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().timeupdateEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_ontimeupdate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_ontimeupdateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_ontimeupdateSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().timeupdateEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_ontimeupdate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_ontimeupdateSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_ontoggleGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().toggleEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_ontoggle, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_ontoggleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_ontoggleSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().toggleEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_ontoggle, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_ontoggleSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onvolumechangeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().volumechangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onvolumechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onvolumechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onvolumechangeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().volumechangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onvolumechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onvolumechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onwaitingGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().waitingEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onwaiting, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onwaitingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onwaitingSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().waitingEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onwaiting, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onwaitingSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onwebkitanimationendGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitAnimationEndEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onwebkitanimationend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onwebkitanimationendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onwebkitanimationendSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().webkitAnimationEndEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onwebkitanimationend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onwebkitanimationendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onwebkitanimationiterationGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitAnimationIterationEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onwebkitanimationiteration, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onwebkitanimationiterationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onwebkitanimationiterationSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().webkitAnimationIterationEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onwebkitanimationiteration, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onwebkitanimationiterationSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onwebkitanimationstartGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitAnimationStartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onwebkitanimationstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onwebkitanimationstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onwebkitanimationstartSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().webkitAnimationStartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onwebkitanimationstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onwebkitanimationstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onwebkittransitionendGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitTransitionEndEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onwebkittransitionend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onwebkittransitionendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onwebkittransitionendSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().webkitTransitionEndEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onwebkittransitionend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onwebkittransitionendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onwheelGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().wheelEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onwheel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onwheelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onwheelSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().wheelEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onwheel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onwheelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onmousewheelGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mousewheelEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onmousewheel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onmousewheelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onmousewheelSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().mousewheelEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onmousewheel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onmousewheelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onsearchGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().searchEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onsearch, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onsearchGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onsearchSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().searchEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onsearch, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onsearchSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsHTMLElement_ontouchcancelGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().touchcancelEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_ontouchcancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_ontouchcancelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSHTMLElement_ontouchcancelSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().touchcancelEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_ontouchcancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_ontouchcancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsHTMLElement_ontouchendGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().touchendEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_ontouchend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_ontouchendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSHTMLElement_ontouchendSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().touchendEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_ontouchend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_ontouchendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsHTMLElement_ontouchmoveGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().touchmoveEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_ontouchmove, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_ontouchmoveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSHTMLElement_ontouchmoveSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().touchmoveEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_ontouchmove, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_ontouchmoveSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsHTMLElement_ontouchstartGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().touchstartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_ontouchstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_ontouchstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSHTMLElement_ontouchstartSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().touchstartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_ontouchstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_ontouchstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsHTMLElement_ontouchforcechangeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().touchforcechangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_ontouchforcechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_ontouchforcechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSHTMLElement_ontouchforcechangeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().touchforcechangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_ontouchforcechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_ontouchforcechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

static inline JSValue jsHTMLElement_onwebkitmouseforcechangedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitmouseforcechangedEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onwebkitmouseforcechanged, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onwebkitmouseforcechangedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onwebkitmouseforcechangedSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().webkitmouseforcechangedEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onwebkitmouseforcechanged, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onwebkitmouseforcechangedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onwebkitmouseforcedownGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitmouseforcedownEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onwebkitmouseforcedown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onwebkitmouseforcedownGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onwebkitmouseforcedownSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().webkitmouseforcedownEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onwebkitmouseforcedown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onwebkitmouseforcedownSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onwebkitmouseforcewillbeginGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitmouseforcewillbeginEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onwebkitmouseforcewillbegin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onwebkitmouseforcewillbeginGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onwebkitmouseforcewillbeginSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().webkitmouseforcewillbeginEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onwebkitmouseforcewillbegin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onwebkitmouseforcewillbeginSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onwebkitmouseforceupGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitmouseforceupEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onwebkitmouseforceup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onwebkitmouseforceupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onwebkitmouseforceupSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().webkitmouseforceupEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onwebkitmouseforceup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onwebkitmouseforceupSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onanimationstartGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().animationstartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onanimationstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onanimationstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onanimationstartSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().animationstartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onanimationstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onanimationstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onanimationiterationGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().animationiterationEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onanimationiteration, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onanimationiterationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onanimationiterationSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().animationiterationEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onanimationiteration, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onanimationiterationSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onanimationendGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().animationendEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onanimationend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onanimationendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onanimationendSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().animationendEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onanimationend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onanimationendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onanimationcancelGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().animationcancelEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onanimationcancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onanimationcancelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onanimationcancelSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().animationcancelEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onanimationcancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onanimationcancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_ontransitionrunGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().transitionrunEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_ontransitionrun, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_ontransitionrunGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_ontransitionrunSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().transitionrunEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_ontransitionrun, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_ontransitionrunSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_ontransitionstartGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().transitionstartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_ontransitionstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_ontransitionstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_ontransitionstartSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().transitionstartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_ontransitionstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_ontransitionstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_ontransitionendGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().transitionendEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_ontransitionend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_ontransitionendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_ontransitionendSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().transitionendEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_ontransitionend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_ontransitionendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_ontransitioncancelGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().transitioncancelEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_ontransitioncancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_ontransitioncancelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_ontransitioncancelSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().transitioncancelEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_ontransitioncancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_ontransitioncancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_ongotpointercaptureGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().gotpointercaptureEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_ongotpointercapture, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_ongotpointercaptureGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_ongotpointercaptureSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().gotpointercaptureEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_ongotpointercapture, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_ongotpointercaptureSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onlostpointercaptureGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().lostpointercaptureEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onlostpointercapture, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onlostpointercaptureGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onlostpointercaptureSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().lostpointercaptureEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onlostpointercapture, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onlostpointercaptureSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onpointerdownGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointerdownEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onpointerdown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onpointerdownGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onpointerdownSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().pointerdownEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onpointerdown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onpointerdownSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onpointermoveGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointermoveEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onpointermove, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onpointermoveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onpointermoveSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().pointermoveEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onpointermove, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onpointermoveSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onpointerupGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointerupEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onpointerup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onpointerupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onpointerupSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().pointerupEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onpointerup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onpointerupSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onpointercancelGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointercancelEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onpointercancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onpointercancelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onpointercancelSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().pointercancelEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onpointercancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onpointercancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onpointeroverGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointeroverEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onpointerover, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onpointeroverGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onpointeroverSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().pointeroverEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onpointerover, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onpointeroverSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onpointeroutGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointeroutEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onpointerout, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onpointeroutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onpointeroutSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().pointeroutEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onpointerout, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onpointeroutSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onpointerenterGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointerenterEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onpointerenter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onpointerenterGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onpointerenterSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().pointerenterEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onpointerenter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onpointerenterSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onpointerleaveGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointerleaveEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onpointerleave, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onpointerleaveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onpointerleaveSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().pointerleaveEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onpointerleave, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onpointerleaveSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onselectstartGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().selectstartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onselectstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onselectstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onselectstartSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().selectstartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onselectstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onselectstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_onselectionchangeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().selectionchangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_onselectionchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_onselectionchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_onselectionchangeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().selectionchangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_onselectionchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_onselectionchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_offsetParentGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.offsetParentForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_offsetParent, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_offsetParentGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLElement_offsetTopGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.offsetTopForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_offsetTop, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_offsetTopGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLElement_offsetLeftGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.offsetLeftForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_offsetLeft, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_offsetLeftGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLElement_offsetWidthGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.offsetWidth())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_offsetWidth, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_offsetWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLElement_offsetHeightGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.offsetHeight())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_offsetHeight, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_offsetHeightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLElement_datasetGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<DOMStringMap>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.dataset())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_dataset, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_datasetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLElement_nonceGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.nonce())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_nonce, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_nonceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_nonceSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setNonce(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_nonce, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_nonceSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_autofocusGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::autofocusAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_autofocus, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_autofocusGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_autofocusSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::autofocusAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_autofocus, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_autofocusSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLElement_tabIndexGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.tabIndexForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLElement_tabIndex, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElement_tabIndexGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLElement_tabIndexSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setTabIndexForBindings(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLElement_tabIndex, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElement_tabIndexSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsHTMLElementPrototypeFunction_clickBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.click(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLElementPrototypeFunction_click, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLElement>::call<jsHTMLElementPrototypeFunction_clickBody>(*lexicalGlobalObject, *callFrame, "click");
}

static inline JSC::EncodedJSValue jsHTMLElementPrototypeFunction_attachInternalsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<ElementInternals>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.attachInternals())));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLElementPrototypeFunction_attachInternals, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLElement>::call<jsHTMLElementPrototypeFunction_attachInternalsBody>(*lexicalGlobalObject, *callFrame, "attachInternals");
}

static inline JSC::EncodedJSValue jsHTMLElementPrototypeFunction_showPopoverBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.showPopover(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLElementPrototypeFunction_showPopover, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLElement>::call<jsHTMLElementPrototypeFunction_showPopoverBody>(*lexicalGlobalObject, *callFrame, "showPopover");
}

static inline JSC::EncodedJSValue jsHTMLElementPrototypeFunction_hidePopoverBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.hidePopover(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLElementPrototypeFunction_hidePopover, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLElement>::call<jsHTMLElementPrototypeFunction_hidePopoverBody>(*lexicalGlobalObject, *callFrame, "hidePopover");
}

static inline JSC::EncodedJSValue jsHTMLElementPrototypeFunction_togglePopoverBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto force = argument0.value().isUndefined() ? std::optional<Converter<IDLBoolean>::ReturnType>() : std::optional<Converter<IDLBoolean>::ReturnType>(convert<IDLBoolean>(*lexicalGlobalObject, argument0.value()));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.togglePopover(WTFMove(force)))));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLElementPrototypeFunction_togglePopover, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLElement>::call<jsHTMLElementPrototypeFunction_togglePopoverBody>(*lexicalGlobalObject, *callFrame, "togglePopover");
}

static inline JSC::EncodedJSValue jsHTMLElementPrototypeFunction_focusBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto options = convert<IDLDictionary<FocusOptions>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.focusForBindings(WTFMove(options)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLElementPrototypeFunction_focus, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLElement>::call<jsHTMLElementPrototypeFunction_focusBody>(*lexicalGlobalObject, *callFrame, "focus");
}

static inline JSC::EncodedJSValue jsHTMLElementPrototypeFunction_blurBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.blur(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLElementPrototypeFunction_blur, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLElement>::call<jsHTMLElementPrototypeFunction_blurBody>(*lexicalGlobalObject, *callFrame, "blur");
}

JSC::GCClient::IsoSubspace* JSHTMLElement::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSHTMLElement, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForHTMLElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForHTMLElement = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForHTMLElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForHTMLElement = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSHTMLElement::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSHTMLElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    visitor.append(thisObject->m_attributeStyleMap);
}

DEFINE_VISIT_CHILDREN(JSHTMLElement);

void JSHTMLElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSHTMLElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

void JSHTMLElement::forEachEventHandlerContentAttribute(const Function<void(const AtomString& attributeName, const AtomString& eventName)>& function)
{
    static constexpr std::pair<decltype(HTMLNames::altAttr)&, const AtomString EventNames::*> table[] = {
        { HTMLNames::onbeforecopyAttr, &EventNames::beforecopyEvent },
        { HTMLNames::onbeforecutAttr, &EventNames::beforecutEvent },
        { HTMLNames::onbeforeinputAttr, &EventNames::beforeinputEvent },
        { HTMLNames::onbeforepasteAttr, &EventNames::beforepasteEvent },
        { HTMLNames::onabortAttr, &EventNames::abortEvent },
        { HTMLNames::onbeforetoggleAttr, &EventNames::beforetoggleEvent },
        { HTMLNames::onblurAttr, &EventNames::blurEvent },
        { HTMLNames::oncancelAttr, &EventNames::cancelEvent },
        { HTMLNames::oncanplayAttr, &EventNames::canplayEvent },
        { HTMLNames::oncanplaythroughAttr, &EventNames::canplaythroughEvent },
        { HTMLNames::onchangeAttr, &EventNames::changeEvent },
        { HTMLNames::onclickAttr, &EventNames::clickEvent },
        { HTMLNames::oncloseAttr, &EventNames::closeEvent },
        { HTMLNames::oncontentvisibilityautostatechangeAttr, &EventNames::contentvisibilityautostatechangeEvent },
        { HTMLNames::oncontextmenuAttr, &EventNames::contextmenuEvent },
        { HTMLNames::oncopyAttr, &EventNames::copyEvent },
        { HTMLNames::oncuechangeAttr, &EventNames::cuechangeEvent },
        { HTMLNames::oncutAttr, &EventNames::cutEvent },
        { HTMLNames::ondblclickAttr, &EventNames::dblclickEvent },
        { HTMLNames::ondragAttr, &EventNames::dragEvent },
        { HTMLNames::ondragendAttr, &EventNames::dragendEvent },
        { HTMLNames::ondragenterAttr, &EventNames::dragenterEvent },
        { HTMLNames::ondragleaveAttr, &EventNames::dragleaveEvent },
        { HTMLNames::ondragoverAttr, &EventNames::dragoverEvent },
        { HTMLNames::ondragstartAttr, &EventNames::dragstartEvent },
        { HTMLNames::ondropAttr, &EventNames::dropEvent },
        { HTMLNames::ondurationchangeAttr, &EventNames::durationchangeEvent },
        { HTMLNames::onemptiedAttr, &EventNames::emptiedEvent },
        { HTMLNames::onendedAttr, &EventNames::endedEvent },
        { HTMLNames::onerrorAttr, &EventNames::errorEvent },
        { HTMLNames::onfocusAttr, &EventNames::focusEvent },
        { HTMLNames::onformdataAttr, &EventNames::formdataEvent },
        { HTMLNames::oninputAttr, &EventNames::inputEvent },
        { HTMLNames::oninvalidAttr, &EventNames::invalidEvent },
        { HTMLNames::onkeydownAttr, &EventNames::keydownEvent },
        { HTMLNames::onkeypressAttr, &EventNames::keypressEvent },
        { HTMLNames::onkeyupAttr, &EventNames::keyupEvent },
        { HTMLNames::onloadAttr, &EventNames::loadEvent },
        { HTMLNames::onloadeddataAttr, &EventNames::loadeddataEvent },
        { HTMLNames::onloadedmetadataAttr, &EventNames::loadedmetadataEvent },
        { HTMLNames::onloadstartAttr, &EventNames::loadstartEvent },
        { HTMLNames::onmousedownAttr, &EventNames::mousedownEvent },
        { HTMLNames::onmouseenterAttr, &EventNames::mouseenterEvent },
        { HTMLNames::onmouseleaveAttr, &EventNames::mouseleaveEvent },
        { HTMLNames::onmousemoveAttr, &EventNames::mousemoveEvent },
        { HTMLNames::onmouseoutAttr, &EventNames::mouseoutEvent },
        { HTMLNames::onmouseoverAttr, &EventNames::mouseoverEvent },
        { HTMLNames::onmouseupAttr, &EventNames::mouseupEvent },
        { HTMLNames::onpasteAttr, &EventNames::pasteEvent },
        { HTMLNames::onpauseAttr, &EventNames::pauseEvent },
        { HTMLNames::onplayAttr, &EventNames::playEvent },
        { HTMLNames::onplayingAttr, &EventNames::playingEvent },
        { HTMLNames::onprogressAttr, &EventNames::progressEvent },
        { HTMLNames::onratechangeAttr, &EventNames::ratechangeEvent },
        { HTMLNames::onresetAttr, &EventNames::resetEvent },
        { HTMLNames::onresizeAttr, &EventNames::resizeEvent },
        { HTMLNames::onscrollAttr, &EventNames::scrollEvent },
        { HTMLNames::onsecuritypolicyviolationAttr, &EventNames::securitypolicyviolationEvent },
        { HTMLNames::onseekedAttr, &EventNames::seekedEvent },
        { HTMLNames::onseekingAttr, &EventNames::seekingEvent },
        { HTMLNames::onselectAttr, &EventNames::selectEvent },
        { HTMLNames::onslotchangeAttr, &EventNames::slotchangeEvent },
        { HTMLNames::onstalledAttr, &EventNames::stalledEvent },
        { HTMLNames::onsubmitAttr, &EventNames::submitEvent },
        { HTMLNames::onsuspendAttr, &EventNames::suspendEvent },
        { HTMLNames::ontimeupdateAttr, &EventNames::timeupdateEvent },
        { HTMLNames::ontoggleAttr, &EventNames::toggleEvent },
        { HTMLNames::onvolumechangeAttr, &EventNames::volumechangeEvent },
        { HTMLNames::onwaitingAttr, &EventNames::waitingEvent },
        { HTMLNames::onwebkitanimationendAttr, &EventNames::webkitAnimationEndEvent },
        { HTMLNames::onwebkitanimationiterationAttr, &EventNames::webkitAnimationIterationEvent },
        { HTMLNames::onwebkitanimationstartAttr, &EventNames::webkitAnimationStartEvent },
        { HTMLNames::onwebkittransitionendAttr, &EventNames::webkitTransitionEndEvent },
        { HTMLNames::onwheelAttr, &EventNames::wheelEvent },
        { HTMLNames::onmousewheelAttr, &EventNames::mousewheelEvent },
        { HTMLNames::onsearchAttr, &EventNames::searchEvent },
        { HTMLNames::ontouchcancelAttr, &EventNames::touchcancelEvent },
        { HTMLNames::ontouchendAttr, &EventNames::touchendEvent },
        { HTMLNames::ontouchmoveAttr, &EventNames::touchmoveEvent },
        { HTMLNames::ontouchstartAttr, &EventNames::touchstartEvent },
        { HTMLNames::ontouchforcechangeAttr, &EventNames::touchforcechangeEvent },
        { HTMLNames::onwebkitmouseforcechangedAttr, &EventNames::webkitmouseforcechangedEvent },
        { HTMLNames::onwebkitmouseforcedownAttr, &EventNames::webkitmouseforcedownEvent },
        { HTMLNames::onwebkitmouseforcewillbeginAttr, &EventNames::webkitmouseforcewillbeginEvent },
        { HTMLNames::onwebkitmouseforceupAttr, &EventNames::webkitmouseforceupEvent },
        { HTMLNames::onanimationstartAttr, &EventNames::animationstartEvent },
        { HTMLNames::onanimationiterationAttr, &EventNames::animationiterationEvent },
        { HTMLNames::onanimationendAttr, &EventNames::animationendEvent },
        { HTMLNames::onanimationcancelAttr, &EventNames::animationcancelEvent },
        { HTMLNames::ontransitionrunAttr, &EventNames::transitionrunEvent },
        { HTMLNames::ontransitionstartAttr, &EventNames::transitionstartEvent },
        { HTMLNames::ontransitionendAttr, &EventNames::transitionendEvent },
        { HTMLNames::ontransitioncancelAttr, &EventNames::transitioncancelEvent },
        { HTMLNames::ongotpointercaptureAttr, &EventNames::gotpointercaptureEvent },
        { HTMLNames::onlostpointercaptureAttr, &EventNames::lostpointercaptureEvent },
        { HTMLNames::onpointerdownAttr, &EventNames::pointerdownEvent },
        { HTMLNames::onpointermoveAttr, &EventNames::pointermoveEvent },
        { HTMLNames::onpointerupAttr, &EventNames::pointerupEvent },
        { HTMLNames::onpointercancelAttr, &EventNames::pointercancelEvent },
        { HTMLNames::onpointeroverAttr, &EventNames::pointeroverEvent },
        { HTMLNames::onpointeroutAttr, &EventNames::pointeroutEvent },
        { HTMLNames::onpointerenterAttr, &EventNames::pointerenterEvent },
        { HTMLNames::onpointerleaveAttr, &EventNames::pointerleaveEvent },
        { HTMLNames::onselectstartAttr, &EventNames::selectstartEvent },
        { HTMLNames::onselectionchangeAttr, &EventNames::selectionchangeEvent },
    };
    auto& eventNames = WebCore::eventNames();
    for (auto& names : table)
        function(names.first.get().localName(), eventNames.*names.second);
}

HTMLElement* JSHTMLElement::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSHTMLElement*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
