/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(GEOLOCATION)

#include "JSGeolocationPositionError.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGeolocationPositionErrorConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsGeolocationPositionError_code);
static JSC_DECLARE_CUSTOM_GETTER(jsGeolocationPositionError_message);

class JSGeolocationPositionErrorPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGeolocationPositionErrorPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGeolocationPositionErrorPrototype* ptr = new (NotNull, JSC::allocateCell<JSGeolocationPositionErrorPrototype>(vm)) JSGeolocationPositionErrorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGeolocationPositionErrorPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGeolocationPositionErrorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGeolocationPositionErrorPrototype, JSGeolocationPositionErrorPrototype::Base);

using JSGeolocationPositionErrorDOMConstructor = JSDOMConstructorNotConstructable<JSGeolocationPositionError>;

/* Hash table for constructor */

static const HashTableValue JSGeolocationPositionErrorConstructorTableValues[] =
{
    { "PERMISSION_DENIED"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    { "POSITION_UNAVAILABLE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    { "TIMEOUT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
};

static_assert(GeolocationPositionError::PERMISSION_DENIED == 1, "PERMISSION_DENIED in GeolocationPositionError does not match value from IDL");
static_assert(GeolocationPositionError::POSITION_UNAVAILABLE == 2, "POSITION_UNAVAILABLE in GeolocationPositionError does not match value from IDL");
static_assert(GeolocationPositionError::TIMEOUT == 3, "TIMEOUT in GeolocationPositionError does not match value from IDL");

template<> const ClassInfo JSGeolocationPositionErrorDOMConstructor::s_info = { "GeolocationPositionError"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGeolocationPositionErrorDOMConstructor) };

template<> JSValue JSGeolocationPositionErrorDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGeolocationPositionErrorDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "GeolocationPositionError"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGeolocationPositionError::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSGeolocationPositionError::info(), JSGeolocationPositionErrorConstructorTableValues, *this);
}

/* Hash table for prototype */

static const HashTableValue JSGeolocationPositionErrorPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGeolocationPositionErrorConstructor, 0 } },
    { "code"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGeolocationPositionError_code, 0 } },
    { "message"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGeolocationPositionError_message, 0 } },
    { "PERMISSION_DENIED"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    { "POSITION_UNAVAILABLE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    { "TIMEOUT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
};

const ClassInfo JSGeolocationPositionErrorPrototype::s_info = { "GeolocationPositionError"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGeolocationPositionErrorPrototype) };

void JSGeolocationPositionErrorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGeolocationPositionError::info(), JSGeolocationPositionErrorPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGeolocationPositionError::s_info = { "GeolocationPositionError"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGeolocationPositionError) };

JSGeolocationPositionError::JSGeolocationPositionError(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GeolocationPositionError>&& impl)
    : JSDOMWrapper<GeolocationPositionError>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, GeolocationPositionError>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSGeolocationPositionError::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGeolocationPositionErrorPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSGeolocationPositionErrorPrototype::create(vm, &globalObject, structure);
}

JSObject* JSGeolocationPositionError::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGeolocationPositionError>(vm, globalObject);
}

JSValue JSGeolocationPositionError::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGeolocationPositionErrorDOMConstructor, DOMConstructorID::GeolocationPositionError>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGeolocationPositionError::destroy(JSC::JSCell* cell)
{
    JSGeolocationPositionError* thisObject = static_cast<JSGeolocationPositionError*>(cell);
    thisObject->JSGeolocationPositionError::~JSGeolocationPositionError();
}

JSC_DEFINE_CUSTOM_GETTER(jsGeolocationPositionErrorConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGeolocationPositionErrorPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGeolocationPositionError::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsGeolocationPositionError_codeGetter(JSGlobalObject& lexicalGlobalObject, JSGeolocationPositionError& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.code())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGeolocationPositionError_code, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGeolocationPositionError>::get<jsGeolocationPositionError_codeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGeolocationPositionError_messageGetter(JSGlobalObject& lexicalGlobalObject, JSGeolocationPositionError& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.message())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGeolocationPositionError_message, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGeolocationPositionError>::get<jsGeolocationPositionError_messageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSGeolocationPositionError::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGeolocationPositionError, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGeolocationPositionError.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGeolocationPositionError = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGeolocationPositionError.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGeolocationPositionError = std::forward<decltype(space)>(space); }
    );
}

void JSGeolocationPositionError::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGeolocationPositionError*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSGeolocationPositionErrorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGeolocationPositionErrorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGeolocationPositionError = static_cast<JSGeolocationPositionError*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsGeolocationPositionError->wrapped(), jsGeolocationPositionError);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7GeolocationPositionError@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore24GeolocationPositionErrorE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GeolocationPositionError>&& impl)
{

    if constexpr (std::is_polymorphic_v<GeolocationPositionError>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7GeolocationPositionError@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore24GeolocationPositionErrorE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // GeolocationPositionError has subclasses. If GeolocationPositionError has subclasses that get passed
        // to toJS() we currently require GeolocationPositionError you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<GeolocationPositionError>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GeolocationPositionError& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GeolocationPositionError* JSGeolocationPositionError::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGeolocationPositionError*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(GEOLOCATION)
