/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUSupportedLimits.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimitsConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_maxTextureDimension1D);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_maxTextureDimension2D);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_maxTextureDimension3D);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_maxTextureArrayLayers);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_maxBindGroups);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_maxBindGroupsPlusVertexBuffers);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_maxBindingsPerBindGroup);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_maxDynamicUniformBuffersPerPipelineLayout);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_maxDynamicStorageBuffersPerPipelineLayout);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_maxSampledTexturesPerShaderStage);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_maxSamplersPerShaderStage);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_maxStorageBuffersPerShaderStage);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_maxStorageTexturesPerShaderStage);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_maxUniformBuffersPerShaderStage);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_maxUniformBufferBindingSize);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_maxStorageBufferBindingSize);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_minUniformBufferOffsetAlignment);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_minStorageBufferOffsetAlignment);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_maxVertexBuffers);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_maxBufferSize);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_maxVertexAttributes);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_maxVertexBufferArrayStride);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_maxInterStageShaderComponents);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_maxInterStageShaderVariables);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_maxColorAttachments);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_maxColorAttachmentBytesPerSample);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_maxComputeWorkgroupStorageSize);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_maxComputeInvocationsPerWorkgroup);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_maxComputeWorkgroupSizeX);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_maxComputeWorkgroupSizeY);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_maxComputeWorkgroupSizeZ);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUSupportedLimits_maxComputeWorkgroupsPerDimension);

class JSGPUSupportedLimitsPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGPUSupportedLimitsPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGPUSupportedLimitsPrototype* ptr = new (NotNull, JSC::allocateCell<JSGPUSupportedLimitsPrototype>(vm)) JSGPUSupportedLimitsPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUSupportedLimitsPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGPUSupportedLimitsPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUSupportedLimitsPrototype, JSGPUSupportedLimitsPrototype::Base);

using JSGPUSupportedLimitsDOMConstructor = JSDOMConstructorNotConstructable<JSGPUSupportedLimits>;

template<> const ClassInfo JSGPUSupportedLimitsDOMConstructor::s_info = { "GPUSupportedLimits"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUSupportedLimitsDOMConstructor) };

template<> JSValue JSGPUSupportedLimitsDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGPUSupportedLimitsDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "GPUSupportedLimits"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGPUSupportedLimits::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSGPUSupportedLimitsPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimitsConstructor, 0 } },
    { "maxTextureDimension1D"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_maxTextureDimension1D, 0 } },
    { "maxTextureDimension2D"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_maxTextureDimension2D, 0 } },
    { "maxTextureDimension3D"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_maxTextureDimension3D, 0 } },
    { "maxTextureArrayLayers"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_maxTextureArrayLayers, 0 } },
    { "maxBindGroups"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_maxBindGroups, 0 } },
    { "maxBindGroupsPlusVertexBuffers"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_maxBindGroupsPlusVertexBuffers, 0 } },
    { "maxBindingsPerBindGroup"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_maxBindingsPerBindGroup, 0 } },
    { "maxDynamicUniformBuffersPerPipelineLayout"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_maxDynamicUniformBuffersPerPipelineLayout, 0 } },
    { "maxDynamicStorageBuffersPerPipelineLayout"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_maxDynamicStorageBuffersPerPipelineLayout, 0 } },
    { "maxSampledTexturesPerShaderStage"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_maxSampledTexturesPerShaderStage, 0 } },
    { "maxSamplersPerShaderStage"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_maxSamplersPerShaderStage, 0 } },
    { "maxStorageBuffersPerShaderStage"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_maxStorageBuffersPerShaderStage, 0 } },
    { "maxStorageTexturesPerShaderStage"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_maxStorageTexturesPerShaderStage, 0 } },
    { "maxUniformBuffersPerShaderStage"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_maxUniformBuffersPerShaderStage, 0 } },
    { "maxUniformBufferBindingSize"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_maxUniformBufferBindingSize, 0 } },
    { "maxStorageBufferBindingSize"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_maxStorageBufferBindingSize, 0 } },
    { "minUniformBufferOffsetAlignment"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_minUniformBufferOffsetAlignment, 0 } },
    { "minStorageBufferOffsetAlignment"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_minStorageBufferOffsetAlignment, 0 } },
    { "maxVertexBuffers"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_maxVertexBuffers, 0 } },
    { "maxBufferSize"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_maxBufferSize, 0 } },
    { "maxVertexAttributes"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_maxVertexAttributes, 0 } },
    { "maxVertexBufferArrayStride"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_maxVertexBufferArrayStride, 0 } },
    { "maxInterStageShaderComponents"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_maxInterStageShaderComponents, 0 } },
    { "maxInterStageShaderVariables"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_maxInterStageShaderVariables, 0 } },
    { "maxColorAttachments"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_maxColorAttachments, 0 } },
    { "maxColorAttachmentBytesPerSample"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_maxColorAttachmentBytesPerSample, 0 } },
    { "maxComputeWorkgroupStorageSize"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_maxComputeWorkgroupStorageSize, 0 } },
    { "maxComputeInvocationsPerWorkgroup"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_maxComputeInvocationsPerWorkgroup, 0 } },
    { "maxComputeWorkgroupSizeX"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_maxComputeWorkgroupSizeX, 0 } },
    { "maxComputeWorkgroupSizeY"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_maxComputeWorkgroupSizeY, 0 } },
    { "maxComputeWorkgroupSizeZ"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_maxComputeWorkgroupSizeZ, 0 } },
    { "maxComputeWorkgroupsPerDimension"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUSupportedLimits_maxComputeWorkgroupsPerDimension, 0 } },
};

const ClassInfo JSGPUSupportedLimitsPrototype::s_info = { "GPUSupportedLimits"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUSupportedLimitsPrototype) };

void JSGPUSupportedLimitsPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGPUSupportedLimits::info(), JSGPUSupportedLimitsPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGPUSupportedLimits::s_info = { "GPUSupportedLimits"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUSupportedLimits) };

JSGPUSupportedLimits::JSGPUSupportedLimits(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GPUSupportedLimits>&& impl)
    : JSDOMWrapper<GPUSupportedLimits>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, GPUSupportedLimits>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSGPUSupportedLimits::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGPUSupportedLimitsPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSGPUSupportedLimitsPrototype::create(vm, &globalObject, structure);
}

JSObject* JSGPUSupportedLimits::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGPUSupportedLimits>(vm, globalObject);
}

JSValue JSGPUSupportedLimits::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGPUSupportedLimitsDOMConstructor, DOMConstructorID::GPUSupportedLimits>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGPUSupportedLimits::destroy(JSC::JSCell* cell)
{
    JSGPUSupportedLimits* thisObject = static_cast<JSGPUSupportedLimits*>(cell);
    thisObject->JSGPUSupportedLimits::~JSGPUSupportedLimits();
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimitsConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGPUSupportedLimitsPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGPUSupportedLimits::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsGPUSupportedLimits_maxTextureDimension1DGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.maxTextureDimension1D())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_maxTextureDimension1D, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_maxTextureDimension1DGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUSupportedLimits_maxTextureDimension2DGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.maxTextureDimension2D())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_maxTextureDimension2D, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_maxTextureDimension2DGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUSupportedLimits_maxTextureDimension3DGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.maxTextureDimension3D())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_maxTextureDimension3D, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_maxTextureDimension3DGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUSupportedLimits_maxTextureArrayLayersGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.maxTextureArrayLayers())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_maxTextureArrayLayers, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_maxTextureArrayLayersGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUSupportedLimits_maxBindGroupsGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.maxBindGroups())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_maxBindGroups, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_maxBindGroupsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUSupportedLimits_maxBindGroupsPlusVertexBuffersGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.maxBindGroupsPlusVertexBuffers())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_maxBindGroupsPlusVertexBuffers, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_maxBindGroupsPlusVertexBuffersGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUSupportedLimits_maxBindingsPerBindGroupGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.maxBindingsPerBindGroup())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_maxBindingsPerBindGroup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_maxBindingsPerBindGroupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUSupportedLimits_maxDynamicUniformBuffersPerPipelineLayoutGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.maxDynamicUniformBuffersPerPipelineLayout())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_maxDynamicUniformBuffersPerPipelineLayout, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_maxDynamicUniformBuffersPerPipelineLayoutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUSupportedLimits_maxDynamicStorageBuffersPerPipelineLayoutGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.maxDynamicStorageBuffersPerPipelineLayout())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_maxDynamicStorageBuffersPerPipelineLayout, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_maxDynamicStorageBuffersPerPipelineLayoutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUSupportedLimits_maxSampledTexturesPerShaderStageGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.maxSampledTexturesPerShaderStage())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_maxSampledTexturesPerShaderStage, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_maxSampledTexturesPerShaderStageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUSupportedLimits_maxSamplersPerShaderStageGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.maxSamplersPerShaderStage())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_maxSamplersPerShaderStage, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_maxSamplersPerShaderStageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUSupportedLimits_maxStorageBuffersPerShaderStageGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.maxStorageBuffersPerShaderStage())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_maxStorageBuffersPerShaderStage, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_maxStorageBuffersPerShaderStageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUSupportedLimits_maxStorageTexturesPerShaderStageGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.maxStorageTexturesPerShaderStage())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_maxStorageTexturesPerShaderStage, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_maxStorageTexturesPerShaderStageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUSupportedLimits_maxUniformBuffersPerShaderStageGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.maxUniformBuffersPerShaderStage())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_maxUniformBuffersPerShaderStage, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_maxUniformBuffersPerShaderStageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUSupportedLimits_maxUniformBufferBindingSizeGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.maxUniformBufferBindingSize())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_maxUniformBufferBindingSize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_maxUniformBufferBindingSizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUSupportedLimits_maxStorageBufferBindingSizeGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.maxStorageBufferBindingSize())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_maxStorageBufferBindingSize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_maxStorageBufferBindingSizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUSupportedLimits_minUniformBufferOffsetAlignmentGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.minUniformBufferOffsetAlignment())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_minUniformBufferOffsetAlignment, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_minUniformBufferOffsetAlignmentGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUSupportedLimits_minStorageBufferOffsetAlignmentGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.minStorageBufferOffsetAlignment())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_minStorageBufferOffsetAlignment, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_minStorageBufferOffsetAlignmentGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUSupportedLimits_maxVertexBuffersGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.maxVertexBuffers())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_maxVertexBuffers, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_maxVertexBuffersGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUSupportedLimits_maxBufferSizeGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.maxBufferSize())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_maxBufferSize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_maxBufferSizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUSupportedLimits_maxVertexAttributesGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.maxVertexAttributes())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_maxVertexAttributes, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_maxVertexAttributesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUSupportedLimits_maxVertexBufferArrayStrideGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.maxVertexBufferArrayStride())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_maxVertexBufferArrayStride, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_maxVertexBufferArrayStrideGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUSupportedLimits_maxInterStageShaderComponentsGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.maxInterStageShaderComponents())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_maxInterStageShaderComponents, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_maxInterStageShaderComponentsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUSupportedLimits_maxInterStageShaderVariablesGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.maxInterStageShaderVariables())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_maxInterStageShaderVariables, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_maxInterStageShaderVariablesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUSupportedLimits_maxColorAttachmentsGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.maxColorAttachments())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_maxColorAttachments, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_maxColorAttachmentsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUSupportedLimits_maxColorAttachmentBytesPerSampleGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.maxColorAttachmentBytesPerSample())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_maxColorAttachmentBytesPerSample, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_maxColorAttachmentBytesPerSampleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUSupportedLimits_maxComputeWorkgroupStorageSizeGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.maxComputeWorkgroupStorageSize())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_maxComputeWorkgroupStorageSize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_maxComputeWorkgroupStorageSizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUSupportedLimits_maxComputeInvocationsPerWorkgroupGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.maxComputeInvocationsPerWorkgroup())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_maxComputeInvocationsPerWorkgroup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_maxComputeInvocationsPerWorkgroupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUSupportedLimits_maxComputeWorkgroupSizeXGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.maxComputeWorkgroupSizeX())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_maxComputeWorkgroupSizeX, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_maxComputeWorkgroupSizeXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUSupportedLimits_maxComputeWorkgroupSizeYGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.maxComputeWorkgroupSizeY())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_maxComputeWorkgroupSizeY, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_maxComputeWorkgroupSizeYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUSupportedLimits_maxComputeWorkgroupSizeZGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.maxComputeWorkgroupSizeZ())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_maxComputeWorkgroupSizeZ, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_maxComputeWorkgroupSizeZGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUSupportedLimits_maxComputeWorkgroupsPerDimensionGetter(JSGlobalObject& lexicalGlobalObject, JSGPUSupportedLimits& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.maxComputeWorkgroupsPerDimension())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUSupportedLimits_maxComputeWorkgroupsPerDimension, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUSupportedLimits>::get<jsGPUSupportedLimits_maxComputeWorkgroupsPerDimensionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSGPUSupportedLimits::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGPUSupportedLimits, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGPUSupportedLimits.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGPUSupportedLimits = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGPUSupportedLimits.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGPUSupportedLimits = std::forward<decltype(space)>(space); }
    );
}

void JSGPUSupportedLimits::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGPUSupportedLimits*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSGPUSupportedLimitsOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGPUSupportedLimitsOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGPUSupportedLimits = static_cast<JSGPUSupportedLimits*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsGPUSupportedLimits->wrapped(), jsGPUSupportedLimits);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7GPUSupportedLimits@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore18GPUSupportedLimitsE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GPUSupportedLimits>&& impl)
{

    if constexpr (std::is_polymorphic_v<GPUSupportedLimits>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7GPUSupportedLimits@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore18GPUSupportedLimitsE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // GPUSupportedLimits has subclasses. If GPUSupportedLimits has subclasses that get passed
        // to toJS() we currently require GPUSupportedLimits you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<GPUSupportedLimits>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GPUSupportedLimits& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GPUSupportedLimits* JSGPUSupportedLimits::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGPUSupportedLimits*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
