/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPURenderPassDescriptor.h"

#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSGPUQuerySet.h"
#include "JSGPURenderPassColorAttachment.h"
#include "JSGPURenderPassDepthStencilAttachment.h"
#include "JSGPURenderPassTimestampWrites.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> GPURenderPassDescriptor convertDictionary<GPURenderPassDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPURenderPassDescriptor result;
    JSValue labelValue;
    if (isNullOrUndefined)
        labelValue = jsUndefined();
    else {
        labelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "label"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!labelValue.isUndefined()) {
        result.label = convert<IDLUSVString>(lexicalGlobalObject, labelValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue colorAttachmentsValue;
    if (isNullOrUndefined)
        colorAttachmentsValue = jsUndefined();
    else {
        colorAttachmentsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "colorAttachments"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!colorAttachmentsValue.isUndefined()) {
        result.colorAttachments = convert<IDLSequence<IDLNullable<IDLDictionary<GPURenderPassColorAttachment>>>>(lexicalGlobalObject, colorAttachmentsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "colorAttachments", "GPURenderPassDescriptor", "sequence");
        return { };
    }
    JSValue depthStencilAttachmentValue;
    if (isNullOrUndefined)
        depthStencilAttachmentValue = jsUndefined();
    else {
        depthStencilAttachmentValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthStencilAttachment"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!depthStencilAttachmentValue.isUndefined()) {
        result.depthStencilAttachment = convert<IDLDictionary<GPURenderPassDepthStencilAttachment>>(lexicalGlobalObject, depthStencilAttachmentValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue maxDrawCountValue;
    if (isNullOrUndefined)
        maxDrawCountValue = jsUndefined();
    else {
        maxDrawCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "maxDrawCount"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!maxDrawCountValue.isUndefined()) {
        result.maxDrawCount = convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, maxDrawCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.maxDrawCount = 50000000;
    JSValue occlusionQuerySetValue;
    if (isNullOrUndefined)
        occlusionQuerySetValue = jsUndefined();
    else {
        occlusionQuerySetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "occlusionQuerySet"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!occlusionQuerySetValue.isUndefined()) {
        result.occlusionQuerySet = convert<IDLInterface<GPUQuerySet>>(lexicalGlobalObject, occlusionQuerySetValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue timestampWritesValue;
    if (isNullOrUndefined)
        timestampWritesValue = jsUndefined();
    else {
        timestampWritesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "timestampWrites"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!timestampWritesValue.isUndefined()) {
        result.timestampWrites = convert<IDLDictionary<GPURenderPassTimestampWrites>>(lexicalGlobalObject, timestampWritesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

} // namespace WebCore
