/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPURenderPassDepthStencilAttachment.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSGPULoadOp.h"
#include "JSGPUStoreOp.h"
#include "JSGPUTextureView.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> GPURenderPassDepthStencilAttachment convertDictionary<GPURenderPassDepthStencilAttachment>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPURenderPassDepthStencilAttachment result;
    JSValue depthClearValueValue;
    if (isNullOrUndefined)
        depthClearValueValue = jsUndefined();
    else {
        depthClearValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthClearValue"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!depthClearValueValue.isUndefined()) {
        result.depthClearValue = convert<IDLFloat>(lexicalGlobalObject, depthClearValueValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue depthLoadOpValue;
    if (isNullOrUndefined)
        depthLoadOpValue = jsUndefined();
    else {
        depthLoadOpValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthLoadOp"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!depthLoadOpValue.isUndefined()) {
        result.depthLoadOp = convert<IDLEnumeration<GPULoadOp>>(lexicalGlobalObject, depthLoadOpValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue depthReadOnlyValue;
    if (isNullOrUndefined)
        depthReadOnlyValue = jsUndefined();
    else {
        depthReadOnlyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthReadOnly"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!depthReadOnlyValue.isUndefined()) {
        result.depthReadOnly = convert<IDLBoolean>(lexicalGlobalObject, depthReadOnlyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.depthReadOnly = false;
    JSValue depthStoreOpValue;
    if (isNullOrUndefined)
        depthStoreOpValue = jsUndefined();
    else {
        depthStoreOpValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthStoreOp"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!depthStoreOpValue.isUndefined()) {
        result.depthStoreOp = convert<IDLEnumeration<GPUStoreOp>>(lexicalGlobalObject, depthStoreOpValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue stencilClearValueValue;
    if (isNullOrUndefined)
        stencilClearValueValue = jsUndefined();
    else {
        stencilClearValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stencilClearValue"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!stencilClearValueValue.isUndefined()) {
        result.stencilClearValue = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, stencilClearValueValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.stencilClearValue = 0;
    JSValue stencilLoadOpValue;
    if (isNullOrUndefined)
        stencilLoadOpValue = jsUndefined();
    else {
        stencilLoadOpValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stencilLoadOp"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!stencilLoadOpValue.isUndefined()) {
        result.stencilLoadOp = convert<IDLEnumeration<GPULoadOp>>(lexicalGlobalObject, stencilLoadOpValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue stencilReadOnlyValue;
    if (isNullOrUndefined)
        stencilReadOnlyValue = jsUndefined();
    else {
        stencilReadOnlyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stencilReadOnly"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!stencilReadOnlyValue.isUndefined()) {
        result.stencilReadOnly = convert<IDLBoolean>(lexicalGlobalObject, stencilReadOnlyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.stencilReadOnly = false;
    JSValue stencilStoreOpValue;
    if (isNullOrUndefined)
        stencilStoreOpValue = jsUndefined();
    else {
        stencilStoreOpValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stencilStoreOp"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!stencilStoreOpValue.isUndefined()) {
        result.stencilStoreOp = convert<IDLEnumeration<GPUStoreOp>>(lexicalGlobalObject, stencilStoreOpValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue viewValue;
    if (isNullOrUndefined)
        viewValue = jsUndefined();
    else {
        viewValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "view"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!viewValue.isUndefined()) {
        result.view = convert<IDLInterface<GPUTextureView>>(lexicalGlobalObject, viewValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "view", "GPURenderPassDepthStencilAttachment", "GPUTextureView");
        return { };
    }
    return result;
}

} // namespace WebCore
