/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPURenderBundleEncoder.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSGPUBindGroup.h"
#include "JSGPUBuffer.h"
#include "JSGPUIndexFormat.h"
#include "JSGPURenderBundle.h"
#include "JSGPURenderBundleDescriptor.h"
#include "JSGPURenderPipeline.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsGPURenderBundleEncoderPrototypeFunction_finish);
static JSC_DECLARE_HOST_FUNCTION(jsGPURenderBundleEncoderPrototypeFunction_pushDebugGroup);
static JSC_DECLARE_HOST_FUNCTION(jsGPURenderBundleEncoderPrototypeFunction_popDebugGroup);
static JSC_DECLARE_HOST_FUNCTION(jsGPURenderBundleEncoderPrototypeFunction_insertDebugMarker);
static JSC_DECLARE_HOST_FUNCTION(jsGPURenderBundleEncoderPrototypeFunction_setBindGroup);
static JSC_DECLARE_HOST_FUNCTION(jsGPURenderBundleEncoderPrototypeFunction_setPipeline);
static JSC_DECLARE_HOST_FUNCTION(jsGPURenderBundleEncoderPrototypeFunction_setIndexBuffer);
static JSC_DECLARE_HOST_FUNCTION(jsGPURenderBundleEncoderPrototypeFunction_setVertexBuffer);
static JSC_DECLARE_HOST_FUNCTION(jsGPURenderBundleEncoderPrototypeFunction_draw);
static JSC_DECLARE_HOST_FUNCTION(jsGPURenderBundleEncoderPrototypeFunction_drawIndexed);
static JSC_DECLARE_HOST_FUNCTION(jsGPURenderBundleEncoderPrototypeFunction_drawIndirect);
static JSC_DECLARE_HOST_FUNCTION(jsGPURenderBundleEncoderPrototypeFunction_drawIndexedIndirect);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGPURenderBundleEncoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsGPURenderBundleEncoder_label);
static JSC_DECLARE_CUSTOM_SETTER(setJSGPURenderBundleEncoder_label);

class JSGPURenderBundleEncoderPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGPURenderBundleEncoderPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGPURenderBundleEncoderPrototype* ptr = new (NotNull, JSC::allocateCell<JSGPURenderBundleEncoderPrototype>(vm)) JSGPURenderBundleEncoderPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPURenderBundleEncoderPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGPURenderBundleEncoderPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPURenderBundleEncoderPrototype, JSGPURenderBundleEncoderPrototype::Base);

using JSGPURenderBundleEncoderDOMConstructor = JSDOMConstructorNotConstructable<JSGPURenderBundleEncoder>;

template<> const ClassInfo JSGPURenderBundleEncoderDOMConstructor::s_info = { "GPURenderBundleEncoder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPURenderBundleEncoderDOMConstructor) };

template<> JSValue JSGPURenderBundleEncoderDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGPURenderBundleEncoderDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "GPURenderBundleEncoder"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGPURenderBundleEncoder::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSGPURenderBundleEncoderPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGPURenderBundleEncoderConstructor, 0 } },
    { "label"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPURenderBundleEncoder_label, setJSGPURenderBundleEncoder_label } },
    { "finish"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderBundleEncoderPrototypeFunction_finish, 0 } },
    { "pushDebugGroup"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderBundleEncoderPrototypeFunction_pushDebugGroup, 1 } },
    { "popDebugGroup"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderBundleEncoderPrototypeFunction_popDebugGroup, 0 } },
    { "insertDebugMarker"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderBundleEncoderPrototypeFunction_insertDebugMarker, 1 } },
    { "setBindGroup"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderBundleEncoderPrototypeFunction_setBindGroup, 2 } },
    { "setPipeline"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderBundleEncoderPrototypeFunction_setPipeline, 1 } },
    { "setIndexBuffer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderBundleEncoderPrototypeFunction_setIndexBuffer, 2 } },
    { "setVertexBuffer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderBundleEncoderPrototypeFunction_setVertexBuffer, 2 } },
    { "draw"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderBundleEncoderPrototypeFunction_draw, 1 } },
    { "drawIndexed"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderBundleEncoderPrototypeFunction_drawIndexed, 1 } },
    { "drawIndirect"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderBundleEncoderPrototypeFunction_drawIndirect, 2 } },
    { "drawIndexedIndirect"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderBundleEncoderPrototypeFunction_drawIndexedIndirect, 2 } },
};

const ClassInfo JSGPURenderBundleEncoderPrototype::s_info = { "GPURenderBundleEncoder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPURenderBundleEncoderPrototype) };

void JSGPURenderBundleEncoderPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGPURenderBundleEncoder::info(), JSGPURenderBundleEncoderPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "pushDebugGroup"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "popDebugGroup"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "insertDebugMarker"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "setBindGroup"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "setPipeline"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "setIndexBuffer"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "setVertexBuffer"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "draw"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "drawIndexed"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "drawIndirect"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "drawIndexedIndirect"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "label"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGPURenderBundleEncoder::s_info = { "GPURenderBundleEncoder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPURenderBundleEncoder) };

JSGPURenderBundleEncoder::JSGPURenderBundleEncoder(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GPURenderBundleEncoder>&& impl)
    : JSDOMWrapper<GPURenderBundleEncoder>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, GPURenderBundleEncoder>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSGPURenderBundleEncoder::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGPURenderBundleEncoderPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSGPURenderBundleEncoderPrototype::create(vm, &globalObject, structure);
}

JSObject* JSGPURenderBundleEncoder::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGPURenderBundleEncoder>(vm, globalObject);
}

JSValue JSGPURenderBundleEncoder::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGPURenderBundleEncoderDOMConstructor, DOMConstructorID::GPURenderBundleEncoder>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGPURenderBundleEncoder::destroy(JSC::JSCell* cell)
{
    JSGPURenderBundleEncoder* thisObject = static_cast<JSGPURenderBundleEncoder*>(cell);
    thisObject->JSGPURenderBundleEncoder::~JSGPURenderBundleEncoder();
}

JSC_DEFINE_CUSTOM_GETTER(jsGPURenderBundleEncoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGPURenderBundleEncoderPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGPURenderBundleEncoder::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsGPURenderBundleEncoder_labelGetter(JSGlobalObject& lexicalGlobalObject, JSGPURenderBundleEncoder& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.label())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPURenderBundleEncoder_label, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPURenderBundleEncoder>::get<jsGPURenderBundleEncoder_labelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSGPURenderBundleEncoder_labelSetter(JSGlobalObject& lexicalGlobalObject, JSGPURenderBundleEncoder& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLUSVString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setLabel(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSGPURenderBundleEncoder_label, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPURenderBundleEncoder>::set<setJSGPURenderBundleEncoder_labelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsGPURenderBundleEncoderPrototypeFunction_finishBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderBundleEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto descriptor = convert<IDLDictionary<GPURenderBundleDescriptor>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<GPURenderBundle>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.finish(WTFMove(descriptor)))));
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderBundleEncoderPrototypeFunction_finish, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderBundleEncoder>::call<jsGPURenderBundleEncoderPrototypeFunction_finishBody>(*lexicalGlobalObject, *callFrame, "finish");
}

static inline JSC::EncodedJSValue jsGPURenderBundleEncoderPrototypeFunction_pushDebugGroupBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderBundleEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto groupLabel = convert<IDLUSVString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.pushDebugGroup(WTFMove(groupLabel)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderBundleEncoderPrototypeFunction_pushDebugGroup, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderBundleEncoder>::call<jsGPURenderBundleEncoderPrototypeFunction_pushDebugGroupBody>(*lexicalGlobalObject, *callFrame, "pushDebugGroup");
}

static inline JSC::EncodedJSValue jsGPURenderBundleEncoderPrototypeFunction_popDebugGroupBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderBundleEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.popDebugGroup(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderBundleEncoderPrototypeFunction_popDebugGroup, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderBundleEncoder>::call<jsGPURenderBundleEncoderPrototypeFunction_popDebugGroupBody>(*lexicalGlobalObject, *callFrame, "popDebugGroup");
}

static inline JSC::EncodedJSValue jsGPURenderBundleEncoderPrototypeFunction_insertDebugMarkerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderBundleEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto markerLabel = convert<IDLUSVString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.insertDebugMarker(WTFMove(markerLabel)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderBundleEncoderPrototypeFunction_insertDebugMarker, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderBundleEncoder>::call<jsGPURenderBundleEncoderPrototypeFunction_insertDebugMarkerBody>(*lexicalGlobalObject, *callFrame, "insertDebugMarker");
}

static inline JSC::EncodedJSValue jsGPURenderBundleEncoderPrototypeFunction_setBindGroup1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderBundleEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto index = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto bindGroup = convert<IDLInterface<GPUBindGroup>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "bindGroup", "GPURenderBundleEncoder", "setBindGroup", "GPUBindGroup"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto dynamicOffsets = argument2.value().isUndefined() ? Converter<IDLSequence<IDLEnforceRangeAdaptor<IDLUnsignedLong>>>::ReturnType{ } : convert<IDLSequence<IDLEnforceRangeAdaptor<IDLUnsignedLong>>>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setBindGroup(WTFMove(index), *bindGroup, WTFMove(dynamicOffsets)); })));
}

static inline JSC::EncodedJSValue jsGPURenderBundleEncoderPrototypeFunction_setBindGroup2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderBundleEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto index = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto bindGroup = convert<IDLInterface<GPUBindGroup>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "bindGroup", "GPURenderBundleEncoder", "setBindGroup", "GPUBindGroup"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto dynamicOffsetsData = convert<IDLUint32Array>(*lexicalGlobalObject, argument2.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 2, "dynamicOffsetsData", "GPURenderBundleEncoder", "setBindGroup", "Uint32Array"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto dynamicOffsetsDataStart = convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto dynamicOffsetsDataLength = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument4.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setBindGroup(WTFMove(index), *bindGroup, dynamicOffsetsData.releaseNonNull(), WTFMove(dynamicOffsetsDataStart), WTFMove(dynamicOffsetsDataLength)); })));
}

static inline JSC::EncodedJSValue jsGPURenderBundleEncoderPrototypeFunction_setBindGroupOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderBundleEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(5, callFrame->argumentCount());
    if (argsCount == 2) {
        RELEASE_AND_RETURN(throwScope, (jsGPURenderBundleEncoderPrototypeFunction_setBindGroup1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 3) {
        RELEASE_AND_RETURN(throwScope, (jsGPURenderBundleEncoderPrototypeFunction_setBindGroup1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 5) {
        RELEASE_AND_RETURN(throwScope, (jsGPURenderBundleEncoderPrototypeFunction_setBindGroup2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return argsCount < 2 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderBundleEncoderPrototypeFunction_setBindGroup, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderBundleEncoder>::call<jsGPURenderBundleEncoderPrototypeFunction_setBindGroupOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "setBindGroup");
}

static inline JSC::EncodedJSValue jsGPURenderBundleEncoderPrototypeFunction_setPipelineBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderBundleEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto pipeline = convert<IDLInterface<GPURenderPipeline>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "pipeline", "GPURenderBundleEncoder", "setPipeline", "GPURenderPipeline"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setPipeline(*pipeline); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderBundleEncoderPrototypeFunction_setPipeline, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderBundleEncoder>::call<jsGPURenderBundleEncoderPrototypeFunction_setPipelineBody>(*lexicalGlobalObject, *callFrame, "setPipeline");
}

static inline JSC::EncodedJSValue jsGPURenderBundleEncoderPrototypeFunction_setIndexBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderBundleEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto buffer = convert<IDLInterface<GPUBuffer>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "buffer", "GPURenderBundleEncoder", "setIndexBuffer", "GPUBuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto indexFormat = convert<IDLEnumeration<GPUIndexFormat>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 1, "indexFormat", "GPURenderBundleEncoder", "setIndexBuffer", expectedEnumerationValues<GPUIndexFormat>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto offset = argument2.value().isUndefined() ? std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>::ReturnType>() : std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>::ReturnType>(convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(*lexicalGlobalObject, argument2.value()));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto size = argument3.value().isUndefined() ? std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>::ReturnType>() : std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>::ReturnType>(convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(*lexicalGlobalObject, argument3.value()));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setIndexBuffer(*buffer, WTFMove(indexFormat), WTFMove(offset), WTFMove(size)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderBundleEncoderPrototypeFunction_setIndexBuffer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderBundleEncoder>::call<jsGPURenderBundleEncoderPrototypeFunction_setIndexBufferBody>(*lexicalGlobalObject, *callFrame, "setIndexBuffer");
}

static inline JSC::EncodedJSValue jsGPURenderBundleEncoderPrototypeFunction_setVertexBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderBundleEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto slot = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto buffer = convert<IDLNullable<IDLInterface<GPUBuffer>>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "buffer", "GPURenderBundleEncoder", "setVertexBuffer", "GPUBuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto offset = argument2.value().isUndefined() ? std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>::ReturnType>() : std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>::ReturnType>(convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(*lexicalGlobalObject, argument2.value()));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto size = argument3.value().isUndefined() ? std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>::ReturnType>() : std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>::ReturnType>(convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(*lexicalGlobalObject, argument3.value()));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setVertexBuffer(WTFMove(slot), WTFMove(buffer), WTFMove(offset), WTFMove(size)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderBundleEncoderPrototypeFunction_setVertexBuffer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderBundleEncoder>::call<jsGPURenderBundleEncoderPrototypeFunction_setVertexBufferBody>(*lexicalGlobalObject, *callFrame, "setVertexBuffer");
}

static inline JSC::EncodedJSValue jsGPURenderBundleEncoderPrototypeFunction_drawBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderBundleEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto vertexCount = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto instanceCount = argument1.value().isUndefined() ? std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>() : std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>(convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument1.value()));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto firstVertex = argument2.value().isUndefined() ? std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>() : std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>(convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument2.value()));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto firstInstance = argument3.value().isUndefined() ? std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>() : std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>(convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument3.value()));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.draw(WTFMove(vertexCount), WTFMove(instanceCount), WTFMove(firstVertex), WTFMove(firstInstance)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderBundleEncoderPrototypeFunction_draw, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderBundleEncoder>::call<jsGPURenderBundleEncoderPrototypeFunction_drawBody>(*lexicalGlobalObject, *callFrame, "draw");
}

static inline JSC::EncodedJSValue jsGPURenderBundleEncoderPrototypeFunction_drawIndexedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderBundleEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto indexCount = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto instanceCount = argument1.value().isUndefined() ? std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>() : std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>(convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument1.value()));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto firstIndex = argument2.value().isUndefined() ? std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>() : std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>(convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument2.value()));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto baseVertex = argument3.value().isUndefined() ? std::optional<Converter<IDLEnforceRangeAdaptor<IDLLong>>::ReturnType>() : std::optional<Converter<IDLEnforceRangeAdaptor<IDLLong>>::ReturnType>(convert<IDLEnforceRangeAdaptor<IDLLong>>(*lexicalGlobalObject, argument3.value()));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument4 = callFrame->argument(4);
    auto firstInstance = argument4.value().isUndefined() ? std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>() : std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>(convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument4.value()));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.drawIndexed(WTFMove(indexCount), WTFMove(instanceCount), WTFMove(firstIndex), WTFMove(baseVertex), WTFMove(firstInstance)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderBundleEncoderPrototypeFunction_drawIndexed, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderBundleEncoder>::call<jsGPURenderBundleEncoderPrototypeFunction_drawIndexedBody>(*lexicalGlobalObject, *callFrame, "drawIndexed");
}

static inline JSC::EncodedJSValue jsGPURenderBundleEncoderPrototypeFunction_drawIndirectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderBundleEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto indirectBuffer = convert<IDLInterface<GPUBuffer>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "indirectBuffer", "GPURenderBundleEncoder", "drawIndirect", "GPUBuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto indirectOffset = convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.drawIndirect(*indirectBuffer, WTFMove(indirectOffset)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderBundleEncoderPrototypeFunction_drawIndirect, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderBundleEncoder>::call<jsGPURenderBundleEncoderPrototypeFunction_drawIndirectBody>(*lexicalGlobalObject, *callFrame, "drawIndirect");
}

static inline JSC::EncodedJSValue jsGPURenderBundleEncoderPrototypeFunction_drawIndexedIndirectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderBundleEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto indirectBuffer = convert<IDLInterface<GPUBuffer>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "indirectBuffer", "GPURenderBundleEncoder", "drawIndexedIndirect", "GPUBuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto indirectOffset = convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.drawIndexedIndirect(*indirectBuffer, WTFMove(indirectOffset)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderBundleEncoderPrototypeFunction_drawIndexedIndirect, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderBundleEncoder>::call<jsGPURenderBundleEncoderPrototypeFunction_drawIndexedIndirectBody>(*lexicalGlobalObject, *callFrame, "drawIndexedIndirect");
}

JSC::GCClient::IsoSubspace* JSGPURenderBundleEncoder::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGPURenderBundleEncoder, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGPURenderBundleEncoder.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGPURenderBundleEncoder = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGPURenderBundleEncoder.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGPURenderBundleEncoder = std::forward<decltype(space)>(space); }
    );
}

void JSGPURenderBundleEncoder::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGPURenderBundleEncoder*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSGPURenderBundleEncoderOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGPURenderBundleEncoderOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGPURenderBundleEncoder = static_cast<JSGPURenderBundleEncoder*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsGPURenderBundleEncoder->wrapped(), jsGPURenderBundleEncoder);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7GPURenderBundleEncoder@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore22GPURenderBundleEncoderE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GPURenderBundleEncoder>&& impl)
{

    if constexpr (std::is_polymorphic_v<GPURenderBundleEncoder>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7GPURenderBundleEncoder@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore22GPURenderBundleEncoderE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // GPURenderBundleEncoder has subclasses. If GPURenderBundleEncoder has subclasses that get passed
        // to toJS() we currently require GPURenderBundleEncoder you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<GPURenderBundleEncoder>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GPURenderBundleEncoder& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GPURenderBundleEncoder* JSGPURenderBundleEncoder::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGPURenderBundleEncoder*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
