/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUProgrammableStage.h"

#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertRecord.h"
#include "JSDOMConvertStrings.h"
#include "JSGPUShaderModule.h"
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/Vector.h>


namespace WebCore {
using namespace JSC;

template<> GPUProgrammableStage convertDictionary<GPUProgrammableStage>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUProgrammableStage result;
    JSValue constantsValue;
    if (isNullOrUndefined)
        constantsValue = jsUndefined();
    else {
        constantsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "constants"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!constantsValue.isUndefined()) {
        result.constants = convert<IDLRecord<IDLUSVString, IDLDouble>>(lexicalGlobalObject, constantsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue entryPointValue;
    if (isNullOrUndefined)
        entryPointValue = jsUndefined();
    else {
        entryPointValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "entryPoint"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!entryPointValue.isUndefined()) {
        result.entryPoint = convert<IDLUSVString>(lexicalGlobalObject, entryPointValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue moduleValue;
    if (isNullOrUndefined)
        moduleValue = jsUndefined();
    else {
        moduleValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "module"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!moduleValue.isUndefined()) {
        result.module = convert<IDLInterface<GPUShaderModule>>(lexicalGlobalObject, moduleValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "module", "GPUProgrammableStage", "GPUShaderModule");
        return { };
    }
    return result;
}

} // namespace WebCore
