/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUCanvasConfiguration.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSGPUCanvasAlphaMode.h"
#include "JSGPUDevice.h"
#include "JSGPUPredefinedColorSpace.h"
#include "JSGPUTextureFormat.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> GPUCanvasConfiguration convertDictionary<GPUCanvasConfiguration>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUCanvasConfiguration result;
    JSValue alphaModeValue;
    if (isNullOrUndefined)
        alphaModeValue = jsUndefined();
    else {
        alphaModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "alphaMode"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!alphaModeValue.isUndefined()) {
        result.alphaMode = convert<IDLEnumeration<GPUCanvasAlphaMode>>(lexicalGlobalObject, alphaModeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.alphaMode = GPUCanvasAlphaMode::Opaque;
    JSValue colorSpaceValue;
    if (isNullOrUndefined)
        colorSpaceValue = jsUndefined();
    else {
        colorSpaceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "colorSpace"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!colorSpaceValue.isUndefined()) {
        result.colorSpace = convert<IDLEnumeration<GPUPredefinedColorSpace>>(lexicalGlobalObject, colorSpaceValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.colorSpace = GPUPredefinedColorSpace::SRGB;
    JSValue deviceValue;
    if (isNullOrUndefined)
        deviceValue = jsUndefined();
    else {
        deviceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "device"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!deviceValue.isUndefined()) {
        result.device = convert<IDLInterface<GPUDevice>>(lexicalGlobalObject, deviceValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "device", "GPUCanvasConfiguration", "GPUDevice");
        return { };
    }
    JSValue formatValue;
    if (isNullOrUndefined)
        formatValue = jsUndefined();
    else {
        formatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "format"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!formatValue.isUndefined()) {
        result.format = convert<IDLEnumeration<GPUTextureFormat>>(lexicalGlobalObject, formatValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "format", "GPUCanvasConfiguration", "GPUTextureFormat");
        return { };
    }
    JSValue usageValue;
    if (isNullOrUndefined)
        usageValue = jsUndefined();
    else {
        usageValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "usage"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!usageValue.isUndefined()) {
        result.usage = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, usageValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.usage = 0x10;
    JSValue viewFormatsValue;
    if (isNullOrUndefined)
        viewFormatsValue = jsUndefined();
    else {
        viewFormatsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "viewFormats"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!viewFormatsValue.isUndefined()) {
        result.viewFormats = convert<IDLSequence<IDLEnumeration<GPUTextureFormat>>>(lexicalGlobalObject, viewFormatsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.viewFormats = Converter<IDLSequence<IDLEnumeration<GPUTextureFormat>>>::ReturnType{ };
    return result;
}

} // namespace WebCore
