/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFileSystemDirectoryHandle.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAsyncIterator.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSFileSystemDirectoryHandle.h"
#include "JSFileSystemFileHandle.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/BuiltinNames.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> FileSystemDirectoryHandle::GetFileOptions convertDictionary<FileSystemDirectoryHandle::GetFileOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    FileSystemDirectoryHandle::GetFileOptions result;
    JSValue createValue;
    if (isNullOrUndefined)
        createValue = jsUndefined();
    else {
        createValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "create"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!createValue.isUndefined()) {
        result.create = convert<IDLBoolean>(lexicalGlobalObject, createValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.create = false;
    return result;
}

template<> FileSystemDirectoryHandle::GetDirectoryOptions convertDictionary<FileSystemDirectoryHandle::GetDirectoryOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    FileSystemDirectoryHandle::GetDirectoryOptions result;
    JSValue createValue;
    if (isNullOrUndefined)
        createValue = jsUndefined();
    else {
        createValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "create"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!createValue.isUndefined()) {
        result.create = convert<IDLBoolean>(lexicalGlobalObject, createValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.create = false;
    return result;
}

template<> FileSystemDirectoryHandle::RemoveOptions convertDictionary<FileSystemDirectoryHandle::RemoveOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    FileSystemDirectoryHandle::RemoveOptions result;
    JSValue recursiveValue;
    if (isNullOrUndefined)
        recursiveValue = jsUndefined();
    else {
        recursiveValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "recursive"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!recursiveValue.isUndefined()) {
        result.recursive = convert<IDLBoolean>(lexicalGlobalObject, recursiveValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.recursive = false;
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsFileSystemDirectoryHandlePrototypeFunction_getFileHandle);
static JSC_DECLARE_HOST_FUNCTION(jsFileSystemDirectoryHandlePrototypeFunction_getDirectoryHandle);
static JSC_DECLARE_HOST_FUNCTION(jsFileSystemDirectoryHandlePrototypeFunction_removeEntry);
static JSC_DECLARE_HOST_FUNCTION(jsFileSystemDirectoryHandlePrototypeFunction_resolve);
static JSC_DECLARE_HOST_FUNCTION(jsFileSystemDirectoryHandlePrototypeFunction_entries);
static JSC_DECLARE_HOST_FUNCTION(jsFileSystemDirectoryHandlePrototypeFunction_keys);
static JSC_DECLARE_HOST_FUNCTION(jsFileSystemDirectoryHandlePrototypeFunction_values);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsFileSystemDirectoryHandleConstructor);

class JSFileSystemDirectoryHandlePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSFileSystemDirectoryHandlePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFileSystemDirectoryHandlePrototype* ptr = new (NotNull, JSC::allocateCell<JSFileSystemDirectoryHandlePrototype>(vm)) JSFileSystemDirectoryHandlePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFileSystemDirectoryHandlePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFileSystemDirectoryHandlePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFileSystemDirectoryHandlePrototype, JSFileSystemDirectoryHandlePrototype::Base);

using JSFileSystemDirectoryHandleDOMConstructor = JSDOMConstructorNotConstructable<JSFileSystemDirectoryHandle>;

template<> const ClassInfo JSFileSystemDirectoryHandleDOMConstructor::s_info = { "FileSystemDirectoryHandle"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemDirectoryHandleDOMConstructor) };

template<> JSValue JSFileSystemDirectoryHandleDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSFileSystemHandle::getConstructor(vm, &globalObject);
}

template<> void JSFileSystemDirectoryHandleDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "FileSystemDirectoryHandle"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSFileSystemDirectoryHandle::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSFileSystemDirectoryHandlePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsFileSystemDirectoryHandleConstructor, 0 } },
    { "getFileHandle"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFileSystemDirectoryHandlePrototypeFunction_getFileHandle, 1 } },
    { "getDirectoryHandle"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFileSystemDirectoryHandlePrototypeFunction_getDirectoryHandle, 1 } },
    { "removeEntry"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFileSystemDirectoryHandlePrototypeFunction_removeEntry, 1 } },
    { "resolve"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFileSystemDirectoryHandlePrototypeFunction_resolve, 1 } },
    { "entries"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFileSystemDirectoryHandlePrototypeFunction_entries, 0 } },
    { "keys"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFileSystemDirectoryHandlePrototypeFunction_keys, 0 } },
    { "values"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFileSystemDirectoryHandlePrototypeFunction_values, 0 } },
};

const ClassInfo JSFileSystemDirectoryHandlePrototype::s_info = { "FileSystemDirectoryHandle"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemDirectoryHandlePrototype) };

void JSFileSystemDirectoryHandlePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFileSystemDirectoryHandle::info(), JSFileSystemDirectoryHandlePrototypeTableValues, *this);
    putDirect(vm, vm.propertyNames->asyncIteratorSymbol, getDirect(vm, vm.propertyNames->builtinNames().entriesPublicName()), static_cast<unsigned>(JSC::PropertyAttribute::DontEnum));
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSFileSystemDirectoryHandle::s_info = { "FileSystemDirectoryHandle"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemDirectoryHandle) };

JSFileSystemDirectoryHandle::JSFileSystemDirectoryHandle(Structure* structure, JSDOMGlobalObject& globalObject, Ref<FileSystemDirectoryHandle>&& impl)
    : JSFileSystemHandle(structure, globalObject, WTFMove(impl))
{
}

Ref<FileSystemDirectoryHandle> JSFileSystemDirectoryHandle::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, FileSystemDirectoryHandle>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSFileSystemDirectoryHandle::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSFileSystemDirectoryHandlePrototype::createStructure(vm, &globalObject, JSFileSystemHandle::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSFileSystemDirectoryHandlePrototype::create(vm, &globalObject, structure);
}

JSObject* JSFileSystemDirectoryHandle::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSFileSystemDirectoryHandle>(vm, globalObject);
}

JSValue JSFileSystemDirectoryHandle::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFileSystemDirectoryHandleDOMConstructor, DOMConstructorID::FileSystemDirectoryHandle>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsFileSystemDirectoryHandleConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFileSystemDirectoryHandlePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSFileSystemDirectoryHandle::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsFileSystemDirectoryHandlePrototypeFunction_getFileHandleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFileSystemDirectoryHandle>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto name = convert<IDLUSVString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto options = convert<IDLDictionary<FileSystemDirectoryHandle::GetFileOptions>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLInterface<FileSystemFileHandle>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.getFileHandle(WTFMove(name), WTFMove(options), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFileSystemDirectoryHandlePrototypeFunction_getFileHandle, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSFileSystemDirectoryHandle>::call<jsFileSystemDirectoryHandlePrototypeFunction_getFileHandleBody>(*lexicalGlobalObject, *callFrame, "getFileHandle");
}

static inline JSC::EncodedJSValue jsFileSystemDirectoryHandlePrototypeFunction_getDirectoryHandleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFileSystemDirectoryHandle>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto name = convert<IDLUSVString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto options = convert<IDLDictionary<FileSystemDirectoryHandle::GetDirectoryOptions>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLInterface<FileSystemDirectoryHandle>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.getDirectoryHandle(WTFMove(name), WTFMove(options), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFileSystemDirectoryHandlePrototypeFunction_getDirectoryHandle, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSFileSystemDirectoryHandle>::call<jsFileSystemDirectoryHandlePrototypeFunction_getDirectoryHandleBody>(*lexicalGlobalObject, *callFrame, "getDirectoryHandle");
}

static inline JSC::EncodedJSValue jsFileSystemDirectoryHandlePrototypeFunction_removeEntryBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFileSystemDirectoryHandle>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto name = convert<IDLUSVString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto options = convert<IDLDictionary<FileSystemDirectoryHandle::RemoveOptions>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.removeEntry(WTFMove(name), WTFMove(options), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFileSystemDirectoryHandlePrototypeFunction_removeEntry, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSFileSystemDirectoryHandle>::call<jsFileSystemDirectoryHandlePrototypeFunction_removeEntryBody>(*lexicalGlobalObject, *callFrame, "removeEntry");
}

static inline JSC::EncodedJSValue jsFileSystemDirectoryHandlePrototypeFunction_resolveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFileSystemDirectoryHandle>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto possibleDescendant = convert<IDLInterface<FileSystemHandle>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "possibleDescendant", "FileSystemDirectoryHandle", "resolve", "FileSystemHandle"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLNullable<IDLSequence<IDLUSVString>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.resolve(*possibleDescendant, WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFileSystemDirectoryHandlePrototypeFunction_resolve, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSFileSystemDirectoryHandle>::call<jsFileSystemDirectoryHandlePrototypeFunction_resolveBody>(*lexicalGlobalObject, *callFrame, "resolve");
}

struct FileSystemDirectoryHandleIteratorTraits {
    static constexpr JSDOMIteratorType type = JSDOMIteratorType::Map;
    using KeyType = IDLUSVString;
    using ValueType = IDLInterface<FileSystemHandle>;
};

using FileSystemDirectoryHandleIteratorBase = JSDOMAsyncIteratorBase<JSFileSystemDirectoryHandle, FileSystemDirectoryHandleIteratorTraits>;
class FileSystemDirectoryHandleIterator final : public FileSystemDirectoryHandleIteratorBase {
public:
    using Base = FileSystemDirectoryHandleIteratorBase;
    DECLARE_INFO;

    template<typename, SubspaceAccess mode> static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        if constexpr (mode == JSC::SubspaceAccess::Concurrently)
            return nullptr;
        return WebCore::subspaceForImpl<FileSystemDirectoryHandleIterator, UseCustomHeapCellType::No>(vm,
            [] (auto& spaces) { return spaces.m_clientSubspaceForFileSystemDirectoryHandleIterator.get(); },
            [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForFileSystemDirectoryHandleIterator = std::forward<decltype(space)>(space); },
            [] (auto& spaces) { return spaces.m_subspaceForFileSystemDirectoryHandleIterator.get(); },
            [] (auto& spaces, auto&& space) { spaces.m_subspaceForFileSystemDirectoryHandleIterator = std::forward<decltype(space)>(space); }
        );
    }

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

    static FileSystemDirectoryHandleIterator* create(JSC::VM& vm, JSC::Structure* structure, JSFileSystemDirectoryHandle& iteratedObject, IterationKind kind)
    {
        auto* instance = new (NotNull, JSC::allocateCell<FileSystemDirectoryHandleIterator>(vm)) FileSystemDirectoryHandleIterator(structure, iteratedObject, kind);
        instance->finishCreation(vm);
        return instance;
    }

    JSC::JSBoundFunction* createOnSettledFunction(JSC::JSGlobalObject*);
    JSC::JSBoundFunction* createOnFulfilledFunction(JSC::JSGlobalObject*);
    JSC::JSBoundFunction* createOnRejectedFunction(JSC::JSGlobalObject*);
private:
    FileSystemDirectoryHandleIterator(JSC::Structure* structure, JSFileSystemDirectoryHandle& iteratedObject, IterationKind kind)
        : Base(structure, iteratedObject, kind)
    {
    }
};

using FileSystemDirectoryHandleIteratorPrototype = JSDOMAsyncIteratorPrototype<JSFileSystemDirectoryHandle, FileSystemDirectoryHandleIteratorTraits>;
JSC_ANNOTATE_HOST_FUNCTION(FileSystemDirectoryHandleIteratorPrototypeNext, FileSystemDirectoryHandleIteratorPrototype::next);

template<>
const JSC::ClassInfo FileSystemDirectoryHandleIteratorBase::s_info = { "FileSystemDirectoryHandleBase Iterator"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(FileSystemDirectoryHandleIteratorBase) };
const JSC::ClassInfo FileSystemDirectoryHandleIterator::s_info = { "FileSystemDirectoryHandle Iterator"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(FileSystemDirectoryHandleIterator) };

template<>
const JSC::ClassInfo FileSystemDirectoryHandleIteratorPrototype::s_info = { "FileSystemDirectoryHandle Iterator"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(FileSystemDirectoryHandleIteratorPrototype) };

static inline EncodedJSValue jsFileSystemDirectoryHandlePrototypeFunction_entriesCaller(JSGlobalObject*, CallFrame*, JSFileSystemDirectoryHandle* thisObject)
{
    return JSValue::encode(iteratorCreate<FileSystemDirectoryHandleIterator>(*thisObject, IterationKind::Entries));
}

JSC_DEFINE_HOST_FUNCTION(jsFileSystemDirectoryHandlePrototypeFunction_entries, (JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame))
{
    return IDLOperation<JSFileSystemDirectoryHandle>::call<jsFileSystemDirectoryHandlePrototypeFunction_entriesCaller>(*lexicalGlobalObject, *callFrame, "entries");
}

static inline EncodedJSValue jsFileSystemDirectoryHandlePrototypeFunction_keysCaller(JSGlobalObject*, CallFrame*, JSFileSystemDirectoryHandle* thisObject)
{
    return JSValue::encode(iteratorCreate<FileSystemDirectoryHandleIterator>(*thisObject, IterationKind::Keys));
}

JSC_DEFINE_HOST_FUNCTION(jsFileSystemDirectoryHandlePrototypeFunction_keys, (JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame))
{
    return IDLOperation<JSFileSystemDirectoryHandle>::call<jsFileSystemDirectoryHandlePrototypeFunction_keysCaller>(*lexicalGlobalObject, *callFrame, "keys");
}

static inline EncodedJSValue jsFileSystemDirectoryHandlePrototypeFunction_valuesCaller(JSGlobalObject*, CallFrame*, JSFileSystemDirectoryHandle* thisObject)
{
    return JSValue::encode(iteratorCreate<FileSystemDirectoryHandleIterator>(*thisObject, IterationKind::Values));
}

JSC_DEFINE_HOST_FUNCTION(jsFileSystemDirectoryHandlePrototypeFunction_values, (JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame))
{
    return IDLOperation<JSFileSystemDirectoryHandle>::call<jsFileSystemDirectoryHandlePrototypeFunction_valuesCaller>(*lexicalGlobalObject, *callFrame, "values");
}

JSC_ANNOTATE_HOST_FUNCTION(FileSystemDirectoryHandleIteratorBaseOnPromiseSettled, FileSystemDirectoryHandleIteratorBase::onPromiseSettled);
JSC_ANNOTATE_HOST_FUNCTION(FileSystemDirectoryHandleIteratorBaseOnPromiseFulfilled, FileSystemDirectoryHandleIteratorBase::onPromiseFulFilled);
JSC_ANNOTATE_HOST_FUNCTION(FileSystemDirectoryHandleIteratorBaseOnPromiseRejected, FileSystemDirectoryHandleIteratorBase::onPromiseRejected);
JSC::GCClient::IsoSubspace* JSFileSystemDirectoryHandle::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSFileSystemDirectoryHandle, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForFileSystemDirectoryHandle.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForFileSystemDirectoryHandle = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForFileSystemDirectoryHandle.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForFileSystemDirectoryHandle = std::forward<decltype(space)>(space); }
    );
}

void JSFileSystemDirectoryHandle::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSFileSystemDirectoryHandle*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSFileSystemDirectoryHandleOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsFileSystemDirectoryHandle = jsCast<JSFileSystemDirectoryHandle*>(handle.slot()->asCell());
    auto& wrapped = jsFileSystemDirectoryHandle->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSFileSystemDirectoryHandleOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsFileSystemDirectoryHandle = static_cast<JSFileSystemDirectoryHandle*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsFileSystemDirectoryHandle->wrapped(), jsFileSystemDirectoryHandle);
}


}
