/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSDynamicsCompressorOptions.h"

#include "JSChannelCountMode.h"
#include "JSChannelInterpretation.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_AUDIO)

template<> DynamicsCompressorOptions convertDictionary<DynamicsCompressorOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    DynamicsCompressorOptions result;
    JSValue channelCountValue;
    if (isNullOrUndefined)
        channelCountValue = jsUndefined();
    else {
        channelCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelCount"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!channelCountValue.isUndefined()) {
        result.channelCount = convert<IDLUnsignedLong>(lexicalGlobalObject, channelCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue channelCountModeValue;
    if (isNullOrUndefined)
        channelCountModeValue = jsUndefined();
    else {
        channelCountModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelCountMode"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!channelCountModeValue.isUndefined()) {
        result.channelCountMode = convert<IDLEnumeration<ChannelCountMode>>(lexicalGlobalObject, channelCountModeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue channelInterpretationValue;
    if (isNullOrUndefined)
        channelInterpretationValue = jsUndefined();
    else {
        channelInterpretationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelInterpretation"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!channelInterpretationValue.isUndefined()) {
        result.channelInterpretation = convert<IDLEnumeration<ChannelInterpretation>>(lexicalGlobalObject, channelInterpretationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue attackValue;
    if (isNullOrUndefined)
        attackValue = jsUndefined();
    else {
        attackValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "attack"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!attackValue.isUndefined()) {
        result.attack = convert<IDLFloat>(lexicalGlobalObject, attackValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.attack = 0.003;
    JSValue kneeValue;
    if (isNullOrUndefined)
        kneeValue = jsUndefined();
    else {
        kneeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "knee"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!kneeValue.isUndefined()) {
        result.knee = convert<IDLFloat>(lexicalGlobalObject, kneeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.knee = 30;
    JSValue ratioValue;
    if (isNullOrUndefined)
        ratioValue = jsUndefined();
    else {
        ratioValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ratio"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!ratioValue.isUndefined()) {
        result.ratio = convert<IDLFloat>(lexicalGlobalObject, ratioValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.ratio = 12;
    JSValue releaseValue;
    if (isNullOrUndefined)
        releaseValue = jsUndefined();
    else {
        releaseValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "release"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!releaseValue.isUndefined()) {
        result.release = convert<IDLFloat>(lexicalGlobalObject, releaseValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.release = 0.25;
    JSValue thresholdValue;
    if (isNullOrUndefined)
        thresholdValue = jsUndefined();
    else {
        thresholdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "threshold"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!thresholdValue.isUndefined()) {
        result.threshold = convert<IDLFloat>(lexicalGlobalObject, thresholdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.threshold = -24;
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_AUDIO)
