/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDeprecatedCSSOMPrimitiveValue.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSDeprecatedCSSOMCounter.h"
#include "JSDeprecatedCSSOMRGBColor.h"
#include "JSDeprecatedCSSOMRect.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_setFloatValue);
static JSC_DECLARE_HOST_FUNCTION(jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getFloatValue);
static JSC_DECLARE_HOST_FUNCTION(jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_setStringValue);
static JSC_DECLARE_HOST_FUNCTION(jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getStringValue);
static JSC_DECLARE_HOST_FUNCTION(jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getCounterValue);
static JSC_DECLARE_HOST_FUNCTION(jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getRectValue);
static JSC_DECLARE_HOST_FUNCTION(jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getRGBColorValue);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsDeprecatedCSSOMPrimitiveValueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDeprecatedCSSOMPrimitiveValue_primitiveType);

class JSDeprecatedCSSOMPrimitiveValuePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDeprecatedCSSOMPrimitiveValuePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDeprecatedCSSOMPrimitiveValuePrototype* ptr = new (NotNull, JSC::allocateCell<JSDeprecatedCSSOMPrimitiveValuePrototype>(vm)) JSDeprecatedCSSOMPrimitiveValuePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDeprecatedCSSOMPrimitiveValuePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDeprecatedCSSOMPrimitiveValuePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDeprecatedCSSOMPrimitiveValuePrototype, JSDeprecatedCSSOMPrimitiveValuePrototype::Base);

using JSDeprecatedCSSOMPrimitiveValueDOMConstructor = JSDOMConstructorNotConstructable<JSDeprecatedCSSOMPrimitiveValue>;

/* Hash table for constructor */

static const HashTableValue JSDeprecatedCSSOMPrimitiveValueConstructorTableValues[] =
{
    { "CSS_UNKNOWN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    { "CSS_NUMBER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    { "CSS_PERCENTAGE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    { "CSS_EMS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
    { "CSS_EXS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 4 } },
    { "CSS_PX"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 5 } },
    { "CSS_CM"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 6 } },
    { "CSS_MM"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 7 } },
    { "CSS_IN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 8 } },
    { "CSS_PT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 9 } },
    { "CSS_PC"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 10 } },
    { "CSS_DEG"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 11 } },
    { "CSS_RAD"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 12 } },
    { "CSS_GRAD"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 13 } },
    { "CSS_MS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 14 } },
    { "CSS_S"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 15 } },
    { "CSS_HZ"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 16 } },
    { "CSS_KHZ"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 17 } },
    { "CSS_DIMENSION"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 18 } },
    { "CSS_STRING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 19 } },
    { "CSS_URI"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 20 } },
    { "CSS_IDENT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 21 } },
    { "CSS_ATTR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 22 } },
    { "CSS_COUNTER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 23 } },
    { "CSS_RECT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 24 } },
    { "CSS_RGBCOLOR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 25 } },
};

static_assert(DeprecatedCSSOMPrimitiveValue::CSS_UNKNOWN == 0, "CSS_UNKNOWN in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_NUMBER == 1, "CSS_NUMBER in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_PERCENTAGE == 2, "CSS_PERCENTAGE in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_EMS == 3, "CSS_EMS in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_EXS == 4, "CSS_EXS in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_PX == 5, "CSS_PX in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_CM == 6, "CSS_CM in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_MM == 7, "CSS_MM in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_IN == 8, "CSS_IN in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_PT == 9, "CSS_PT in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_PC == 10, "CSS_PC in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_DEG == 11, "CSS_DEG in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_RAD == 12, "CSS_RAD in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_GRAD == 13, "CSS_GRAD in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_MS == 14, "CSS_MS in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_S == 15, "CSS_S in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_HZ == 16, "CSS_HZ in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_KHZ == 17, "CSS_KHZ in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_DIMENSION == 18, "CSS_DIMENSION in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_STRING == 19, "CSS_STRING in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_URI == 20, "CSS_URI in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_IDENT == 21, "CSS_IDENT in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_ATTR == 22, "CSS_ATTR in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_COUNTER == 23, "CSS_COUNTER in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_RECT == 24, "CSS_RECT in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_RGBCOLOR == 25, "CSS_RGBCOLOR in DeprecatedCSSOMPrimitiveValue does not match value from IDL");

template<> const ClassInfo JSDeprecatedCSSOMPrimitiveValueDOMConstructor::s_info = { "CSSPrimitiveValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMPrimitiveValueDOMConstructor) };

template<> JSValue JSDeprecatedCSSOMPrimitiveValueDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSDeprecatedCSSOMValue::getConstructor(vm, &globalObject);
}

template<> void JSDeprecatedCSSOMPrimitiveValueDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CSSPrimitiveValue"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSDeprecatedCSSOMPrimitiveValue::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSDeprecatedCSSOMPrimitiveValue::info(), JSDeprecatedCSSOMPrimitiveValueConstructorTableValues, *this);
}

/* Hash table for prototype */

static const HashTableValue JSDeprecatedCSSOMPrimitiveValuePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDeprecatedCSSOMPrimitiveValueConstructor, 0 } },
    { "primitiveType"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDeprecatedCSSOMPrimitiveValue_primitiveType, 0 } },
    { "setFloatValue"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_setFloatValue, 0 } },
    { "getFloatValue"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getFloatValue, 0 } },
    { "setStringValue"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_setStringValue, 0 } },
    { "getStringValue"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getStringValue, 0 } },
    { "getCounterValue"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getCounterValue, 0 } },
    { "getRectValue"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getRectValue, 0 } },
    { "getRGBColorValue"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getRGBColorValue, 0 } },
    { "CSS_UNKNOWN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    { "CSS_NUMBER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    { "CSS_PERCENTAGE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    { "CSS_EMS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
    { "CSS_EXS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 4 } },
    { "CSS_PX"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 5 } },
    { "CSS_CM"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 6 } },
    { "CSS_MM"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 7 } },
    { "CSS_IN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 8 } },
    { "CSS_PT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 9 } },
    { "CSS_PC"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 10 } },
    { "CSS_DEG"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 11 } },
    { "CSS_RAD"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 12 } },
    { "CSS_GRAD"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 13 } },
    { "CSS_MS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 14 } },
    { "CSS_S"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 15 } },
    { "CSS_HZ"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 16 } },
    { "CSS_KHZ"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 17 } },
    { "CSS_DIMENSION"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 18 } },
    { "CSS_STRING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 19 } },
    { "CSS_URI"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 20 } },
    { "CSS_IDENT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 21 } },
    { "CSS_ATTR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 22 } },
    { "CSS_COUNTER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 23 } },
    { "CSS_RECT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 24 } },
    { "CSS_RGBCOLOR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 25 } },
};

const ClassInfo JSDeprecatedCSSOMPrimitiveValuePrototype::s_info = { "CSSPrimitiveValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMPrimitiveValuePrototype) };

void JSDeprecatedCSSOMPrimitiveValuePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDeprecatedCSSOMPrimitiveValue::info(), JSDeprecatedCSSOMPrimitiveValuePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSDeprecatedCSSOMPrimitiveValue::s_info = { "CSSPrimitiveValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMPrimitiveValue) };

JSDeprecatedCSSOMPrimitiveValue::JSDeprecatedCSSOMPrimitiveValue(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DeprecatedCSSOMPrimitiveValue>&& impl)
    : JSDeprecatedCSSOMValue(structure, globalObject, WTFMove(impl))
{
}

Ref<DeprecatedCSSOMPrimitiveValue> JSDeprecatedCSSOMPrimitiveValue::protectedWrapped() const
{
    return wrapped();
}

JSObject* JSDeprecatedCSSOMPrimitiveValue::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSDeprecatedCSSOMPrimitiveValuePrototype::createStructure(vm, &globalObject, JSDeprecatedCSSOMValue::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSDeprecatedCSSOMPrimitiveValuePrototype::create(vm, &globalObject, structure);
}

JSObject* JSDeprecatedCSSOMPrimitiveValue::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDeprecatedCSSOMPrimitiveValue>(vm, globalObject);
}

JSValue JSDeprecatedCSSOMPrimitiveValue::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDeprecatedCSSOMPrimitiveValueDOMConstructor, DOMConstructorID::DeprecatedCSSOMPrimitiveValue>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDeprecatedCSSOMPrimitiveValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDeprecatedCSSOMPrimitiveValuePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDeprecatedCSSOMPrimitiveValue::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsDeprecatedCSSOMPrimitiveValue_primitiveTypeGetter(JSGlobalObject& lexicalGlobalObject, JSDeprecatedCSSOMPrimitiveValue& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.primitiveType())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDeprecatedCSSOMPrimitiveValue_primitiveType, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDeprecatedCSSOMPrimitiveValue>::get<jsDeprecatedCSSOMPrimitiveValue_primitiveTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_setFloatValueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto unitType = convert<IDLUnsignedShort>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto floatValue = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setFloatValue(WTFMove(unitType), WTFMove(floatValue)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_setFloatValue, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::call<jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_setFloatValueBody>(*lexicalGlobalObject, *callFrame, "setFloatValue");
}

static inline JSC::EncodedJSValue jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getFloatValueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto unitType = convert<IDLUnsignedShort>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUnrestrictedFloat>(*lexicalGlobalObject, throwScope, impl.getFloatValue(WTFMove(unitType)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getFloatValue, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::call<jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getFloatValueBody>(*lexicalGlobalObject, *callFrame, "getFloatValue");
}

static inline JSC::EncodedJSValue jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_setStringValueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto stringType = convert<IDLUnsignedShort>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto stringValue = argument1.value().isUndefined() ? String() : convert<IDLDOMString>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setStringValue(WTFMove(stringType), WTFMove(stringValue)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_setStringValue, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::call<jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_setStringValueBody>(*lexicalGlobalObject, *callFrame, "setStringValue");
}

static inline JSC::EncodedJSValue jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getStringValueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.getStringValue())));
}

JSC_DEFINE_HOST_FUNCTION(jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getStringValue, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::call<jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getStringValueBody>(*lexicalGlobalObject, *callFrame, "getStringValue");
}

static inline JSC::EncodedJSValue jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getCounterValueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<DeprecatedCSSOMCounter>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getCounterValue())));
}

JSC_DEFINE_HOST_FUNCTION(jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getCounterValue, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::call<jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getCounterValueBody>(*lexicalGlobalObject, *callFrame, "getCounterValue");
}

static inline JSC::EncodedJSValue jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getRectValueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<DeprecatedCSSOMRect>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getRectValue())));
}

JSC_DEFINE_HOST_FUNCTION(jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getRectValue, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::call<jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getRectValueBody>(*lexicalGlobalObject, *callFrame, "getRectValue");
}

static inline JSC::EncodedJSValue jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getRGBColorValueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<DeprecatedCSSOMRGBColor>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getRGBColorValue())));
}

JSC_DEFINE_HOST_FUNCTION(jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getRGBColorValue, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::call<jsDeprecatedCSSOMPrimitiveValuePrototypeFunction_getRGBColorValueBody>(*lexicalGlobalObject, *callFrame, "getRGBColorValue");
}

JSC::GCClient::IsoSubspace* JSDeprecatedCSSOMPrimitiveValue::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSDeprecatedCSSOMPrimitiveValue, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForDeprecatedCSSOMPrimitiveValue.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForDeprecatedCSSOMPrimitiveValue = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForDeprecatedCSSOMPrimitiveValue.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForDeprecatedCSSOMPrimitiveValue = std::forward<decltype(space)>(space); }
    );
}

void JSDeprecatedCSSOMPrimitiveValue::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDeprecatedCSSOMPrimitiveValue*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
