/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDedicatedWorkerGlobalScope.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSAbortController.h"
#include "JSAbortSignal.h"
#include "JSByteLengthQueuingStrategy.h"
#include "JSCompressionStream.h"
#include "JSCompressionStreamEncoder.h"
#include "JSCountQueuingStrategy.h"
#include "JSCustomEvent.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertObject.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMURL.h"
#include "JSDOMWrapperCache.h"
#include "JSDecompressionStream.h"
#include "JSDecompressionStreamDecoder.h"
#include "JSDedicatedWorkerGlobalScope.h"
#include "JSErrorEvent.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSEventTarget.h"
#include "JSFileReaderSync.h"
#include "JSFileSystemSyncAccessHandle.h"
#include "JSGPU.h"
#include "JSGPUAdapter.h"
#include "JSGPUAdapterInfo.h"
#include "JSGPUBindGroup.h"
#include "JSGPUBindGroupLayout.h"
#include "JSGPUBuffer.h"
#include "JSGPUBufferUsage.h"
#include "JSGPUCanvasContext.h"
#include "JSGPUColorWrite.h"
#include "JSGPUCommandBuffer.h"
#include "JSGPUCommandEncoder.h"
#include "JSGPUCompilationInfo.h"
#include "JSGPUCompilationMessage.h"
#include "JSGPUComputePassEncoder.h"
#include "JSGPUComputePipeline.h"
#include "JSGPUDevice.h"
#include "JSGPUDeviceLostInfo.h"
#include "JSGPUExternalTexture.h"
#include "JSGPUInternalError.h"
#include "JSGPUMapMode.h"
#include "JSGPUOutOfMemoryError.h"
#include "JSGPUPipelineLayout.h"
#include "JSGPUQuerySet.h"
#include "JSGPUQueue.h"
#include "JSGPURenderBundle.h"
#include "JSGPURenderBundleEncoder.h"
#include "JSGPURenderPassEncoder.h"
#include "JSGPURenderPipeline.h"
#include "JSGPUSampler.h"
#include "JSGPUShaderModule.h"
#include "JSGPUShaderStage.h"
#include "JSGPUSupportedFeatures.h"
#include "JSGPUSupportedLimits.h"
#include "JSGPUTexture.h"
#include "JSGPUTextureUsage.h"
#include "JSGPUTextureView.h"
#include "JSGPUUncapturedErrorEvent.h"
#include "JSGPUValidationError.h"
#include "JSMediaCapabilities.h"
#include "JSPerformance.h"
#include "JSPerformanceEntry.h"
#include "JSPerformanceMark.h"
#include "JSPerformanceMeasure.h"
#include "JSPerformanceObserver.h"
#include "JSPerformanceObserverEntryList.h"
#include "JSPerformanceResourceTiming.h"
#include "JSPerformanceServerTiming.h"
#include "JSPermissionStatus.h"
#include "JSPromiseRejectionEvent.h"
#include "JSReadableByteStreamController.h"
#include "JSReadableStream.h"
#include "JSReadableStreamBYOBReader.h"
#include "JSReadableStreamBYOBRequest.h"
#include "JSReadableStreamDefaultController.h"
#include "JSReadableStreamDefaultReader.h"
#include "JSStructuredSerializeOptions.h"
#include "JSTextDecoder.h"
#include "JSTextDecoderStream.h"
#include "JSTextEncoder.h"
#include "JSTextEncoderStream.h"
#include "JSTransformStream.h"
#include "JSTransformStreamDefaultController.h"
#include "JSURLSearchParams.h"
#include "JSWorker.h"
#include "JSWritableStream.h"
#include "JSWritableStreamDefaultController.h"
#include "JSWritableStreamDefaultWriter.h"
#include "JSXMLHttpRequest.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/IteratorOperations.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>

#if ENABLE(MEDIA_STREAM)
#include "JSMediaStreamTrack.h"
#endif

#if ENABLE(MEDIA_STREAM) && ENABLE(WEB_CODECS)
#include "JSMediaStreamTrackProcessor.h"
#include "JSVideoTrackGenerator.h"
#endif

#if ENABLE(NOTIFICATIONS)
#include "JSNotification.h"
#endif

#if ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMGlobalObject.h"
#include "JSRequestAnimationFrameCallback.h"
#endif

#if ENABLE(WEB_CODECS)
#include "JSWebCodecsAudioData.h"
#include "JSWebCodecsAudioDecoder.h"
#include "JSWebCodecsAudioEncoder.h"
#include "JSWebCodecsEncodedAudioChunk.h"
#include "JSWebCodecsEncodedVideoChunk.h"
#include "JSWebCodecsVideoDecoder.h"
#include "JSWebCodecsVideoEncoder.h"
#include "JSWebCodecsVideoFrame.h"
#endif

#if ENABLE(WEB_RTC)
#include "JSRTCEncodedAudioFrame.h"
#include "JSRTCEncodedVideoFrame.h"
#include "JSRTCRtpSFrameTransform.h"
#include "JSRTCRtpSFrameTransformErrorEvent.h"
#include "JSRTCRtpScriptTransformer.h"
#endif


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsDedicatedWorkerGlobalScopeInstanceFunction_postMessage);
static JSC_DECLARE_HOST_FUNCTION(jsDedicatedWorkerGlobalScopeInstanceFunction_close);
#if ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
static JSC_DECLARE_HOST_FUNCTION(jsDedicatedWorkerGlobalScopeInstanceFunction_requestAnimationFrame);
#endif
#if ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
static JSC_DECLARE_HOST_FUNCTION(jsDedicatedWorkerGlobalScopeInstanceFunction_cancelAnimationFrame);
#endif

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScopeConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_name);
static JSC_DECLARE_CUSTOM_SETTER(setJSDedicatedWorkerGlobalScope_name);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_onmessage);
static JSC_DECLARE_CUSTOM_SETTER(setJSDedicatedWorkerGlobalScope_onmessage);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_onmessageerror);
static JSC_DECLARE_CUSTOM_SETTER(setJSDedicatedWorkerGlobalScope_onmessageerror);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUAdapterConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUAdapterInfoConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUBindGroupConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUBindGroupLayoutConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUBufferConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUBufferUsageConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUColorWriteConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUCommandBufferConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUCommandEncoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUCompilationInfoConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUCompilationMessageConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUComputePassEncoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUComputePipelineConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUDeviceConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUDeviceLostInfoConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUExternalTextureConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUInternalErrorConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUMapModeConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUOutOfMemoryErrorConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUPipelineLayoutConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUQuerySetConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUQueueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPURenderBundleConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPURenderBundleEncoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPURenderPassEncoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPURenderPipelineConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUSamplerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUShaderModuleConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUShaderStageConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUSupportedFeaturesConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUSupportedLimitsConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUTextureConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUTextureUsageConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUTextureViewConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUUncapturedErrorEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUValidationErrorConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_CompressionStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_CompressionStreamEncoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_DecompressionStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_DecompressionStreamDecoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_FileSystemSyncAccessHandleConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_MediaCapabilitiesConstructor);
#if ENABLE(MEDIA_STREAM)
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_MediaStreamTrackConstructor);
#endif
#if ENABLE(MEDIA_STREAM) && ENABLE(WEB_CODECS)
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_MediaStreamTrackProcessorConstructor);
#endif
#if ENABLE(WEB_RTC)
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_RTCEncodedAudioFrameConstructor);
#endif
#if ENABLE(WEB_RTC)
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_RTCEncodedVideoFrameConstructor);
#endif
#if ENABLE(WEB_RTC)
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_SFrameTransformConstructor);
#endif
#if ENABLE(WEB_RTC)
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_SFrameTransformErrorEventConstructor);
#endif
#if ENABLE(WEB_RTC)
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_RTCRtpScriptTransformerConstructor);
#endif
#if ENABLE(MEDIA_STREAM) && ENABLE(WEB_CODECS)
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_VideoTrackGeneratorConstructor);
#endif
#if ENABLE(NOTIFICATIONS)
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_NotificationConstructor);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PermissionStatusConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ByteLengthQueuingStrategyConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_CountQueuingStrategyConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ReadableByteStreamControllerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ReadableStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ReadableStreamBYOBReaderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ReadableStreamBYOBRequestConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ReadableStreamDefaultControllerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ReadableStreamDefaultReaderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_TransformStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_TransformStreamDefaultControllerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_WritableStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_WritableStreamDefaultControllerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_WritableStreamDefaultWriterConstructor);
#if ENABLE(WEB_CODECS)
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_AudioDataConstructor);
#endif
#if ENABLE(WEB_CODECS)
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_AudioDecoderConstructor);
#endif
#if ENABLE(WEB_CODECS)
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_AudioEncoderConstructor);
#endif
#if ENABLE(WEB_CODECS)
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_EncodedAudioChunkConstructor);
#endif
#if ENABLE(WEB_CODECS)
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_EncodedVideoChunkConstructor);
#endif
#if ENABLE(WEB_CODECS)
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_VideoDecoderConstructor);
#endif
#if ENABLE(WEB_CODECS)
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_VideoEncoderConstructor);
#endif
#if ENABLE(WEB_CODECS)
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_VideoFrameConstructor);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_AbortControllerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_AbortSignalConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_CustomEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ErrorEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_EventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_EventTargetConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PromiseRejectionEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_TextDecoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_TextDecoderStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_TextEncoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_TextEncoderStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_FileReaderSyncConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_URLConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_URLSearchParamsConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUCanvasContextConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceEntryConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceMarkConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceMeasureConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceObserverConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceObserverEntryListConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceResourceTimingConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceServerTimingConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_DedicatedWorkerGlobalScopeConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_WorkerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_XMLHttpRequestConstructor);
#if ENABLE(WEB_RTC)
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_onrtctransform);
static JSC_DECLARE_CUSTOM_SETTER(setJSDedicatedWorkerGlobalScope_onrtctransform);
#endif

using JSDedicatedWorkerGlobalScopeDOMConstructor = JSDOMConstructorNotConstructable<JSDedicatedWorkerGlobalScope>;

/* Hash table */

static const struct CompactHashIndex JSDedicatedWorkerGlobalScopeTableIndex[132] = {
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 27, -1 },
    { 3, -1 },
    { -1, -1 },
    { 30, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 23, -1 },
    { 20, -1 },
    { -1, -1 },
    { 7, -1 },
    { 0, -1 },
    { 10, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 37, -1 },
    { 24, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 6, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 22, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 4, -1 },
    { 17, 129 },
    { 8, -1 },
    { -1, -1 },
    { 31, -1 },
    { -1, -1 },
    { 12, 128 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 15, -1 },
    { -1, -1 },
    { -1, -1 },
    { 14, -1 },
    { 9, -1 },
    { -1, -1 },
    { 32, -1 },
    { 36, -1 },
    { -1, -1 },
    { -1, -1 },
    { 11, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 19, -1 },
    { 1, 130 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 34, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 21, -1 },
    { -1, -1 },
    { 28, -1 },
    { 2, -1 },
    { -1, -1 },
    { 13, -1 },
    { -1, -1 },
    { 16, -1 },
    { -1, -1 },
    { 18, -1 },
    { -1, -1 },
    { 35, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 26, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 38, -1 },
    { -1, -1 },
    { 5, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 25, -1 },
    { 29, 131 },
    { 33, -1 },
    { 39, -1 },
};


static const HashTableValue JSDedicatedWorkerGlobalScopeTableValues[] =
{
    { "name"_s, static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_name, setJSDedicatedWorkerGlobalScope_name } },
    { "onmessage"_s, static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_onmessage, setJSDedicatedWorkerGlobalScope_onmessage } },
    { "onmessageerror"_s, static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_onmessageerror, setJSDedicatedWorkerGlobalScope_onmessageerror } },
#if ENABLE(MEDIA_STREAM)
    { "MediaStreamTrack"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_MediaStreamTrackConstructor, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    { "ByteLengthQueuingStrategy"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_ByteLengthQueuingStrategyConstructor, 0 } },
    { "CountQueuingStrategy"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_CountQueuingStrategyConstructor, 0 } },
    { "ReadableStream"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_ReadableStreamConstructor, 0 } },
    { "ReadableStreamDefaultController"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_ReadableStreamDefaultControllerConstructor, 0 } },
    { "ReadableStreamDefaultReader"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_ReadableStreamDefaultReaderConstructor, 0 } },
    { "TransformStream"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_TransformStreamConstructor, 0 } },
    { "TransformStreamDefaultController"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_TransformStreamDefaultControllerConstructor, 0 } },
    { "WritableStream"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_WritableStreamConstructor, 0 } },
    { "WritableStreamDefaultController"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_WritableStreamDefaultControllerConstructor, 0 } },
    { "WritableStreamDefaultWriter"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_WritableStreamDefaultWriterConstructor, 0 } },
    { "AbortController"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_AbortControllerConstructor, 0 } },
    { "AbortSignal"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_AbortSignalConstructor, 0 } },
    { "CustomEvent"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_CustomEventConstructor, 0 } },
    { "ErrorEvent"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_ErrorEventConstructor, 0 } },
    { "Event"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_EventConstructor, 0 } },
    { "EventTarget"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_EventTargetConstructor, 0 } },
    { "PromiseRejectionEvent"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_PromiseRejectionEventConstructor, 0 } },
    { "TextDecoder"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_TextDecoderConstructor, 0 } },
    { "TextDecoderStream"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_TextDecoderStreamConstructor, 0 } },
    { "TextEncoder"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_TextEncoderConstructor, 0 } },
    { "TextEncoderStream"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_TextEncoderStreamConstructor, 0 } },
    { "URL"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_URLConstructor, 0 } },
    { "URLSearchParams"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_URLSearchParamsConstructor, 0 } },
    { "Performance"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_PerformanceConstructor, 0 } },
    { "PerformanceEntry"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_PerformanceEntryConstructor, 0 } },
    { "PerformanceMark"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_PerformanceMarkConstructor, 0 } },
    { "PerformanceMeasure"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_PerformanceMeasureConstructor, 0 } },
    { "PerformanceObserver"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_PerformanceObserverConstructor, 0 } },
    { "PerformanceObserverEntryList"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_PerformanceObserverEntryListConstructor, 0 } },
    { "PerformanceResourceTiming"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_PerformanceResourceTimingConstructor, 0 } },
    { "PerformanceServerTiming"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_PerformanceServerTimingConstructor, 0 } },
    { "DedicatedWorkerGlobalScope"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_DedicatedWorkerGlobalScopeConstructor, 0 } },
    { "Worker"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_WorkerConstructor, 0 } },
    { "XMLHttpRequest"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_XMLHttpRequestConstructor, 0 } },
    { "postMessage"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDedicatedWorkerGlobalScopeInstanceFunction_postMessage, 1 } },
    { "close"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDedicatedWorkerGlobalScopeInstanceFunction_close, 0 } },
};

static const HashTable JSDedicatedWorkerGlobalScopeTable = { 40, 127, static_cast<uint8_t>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::Function), JSDedicatedWorkerGlobalScope::info(), JSDedicatedWorkerGlobalScopeTableValues, JSDedicatedWorkerGlobalScopeTableIndex };
template<> const ClassInfo JSDedicatedWorkerGlobalScopeDOMConstructor::s_info = { "DedicatedWorkerGlobalScope"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDedicatedWorkerGlobalScopeDOMConstructor) };

template<> JSValue JSDedicatedWorkerGlobalScopeDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSWorkerGlobalScope::getConstructor(vm, &globalObject);
}

template<> void JSDedicatedWorkerGlobalScopeDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "DedicatedWorkerGlobalScope"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, globalObject.getPrototypeDirect(), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const struct CompactHashIndex JSDedicatedWorkerGlobalScopePrototypeTableIndex[2] = {
    { -1, -1 },
    { 0, -1 },
};


static const HashTableValue JSDedicatedWorkerGlobalScopePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScopeConstructor, 0 } },
};

static const HashTable JSDedicatedWorkerGlobalScopePrototypeTable = { 1, 1, static_cast<uint8_t>(static_cast<unsigned>(PropertyAttribute::DontEnum)), JSDedicatedWorkerGlobalScope::info(), JSDedicatedWorkerGlobalScopePrototypeTableValues, JSDedicatedWorkerGlobalScopePrototypeTableIndex };
const ClassInfo JSDedicatedWorkerGlobalScopePrototype::s_info = { "DedicatedWorkerGlobalScope"_s, &Base::s_info, &JSDedicatedWorkerGlobalScopePrototypeTable, nullptr, CREATE_METHOD_TABLE(JSDedicatedWorkerGlobalScopePrototype) };

void JSDedicatedWorkerGlobalScopePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSDedicatedWorkerGlobalScope::s_info = { "DedicatedWorkerGlobalScope"_s, &Base::s_info, &JSDedicatedWorkerGlobalScopeTable, nullptr, CREATE_METHOD_TABLE(JSDedicatedWorkerGlobalScope) };

JSDedicatedWorkerGlobalScope::JSDedicatedWorkerGlobalScope(VM& vm, Structure* structure, Ref<DedicatedWorkerGlobalScope>&& impl)
    : JSWorkerGlobalScope(vm, structure, WTFMove(impl))
{
}

Ref<DedicatedWorkerGlobalScope> JSDedicatedWorkerGlobalScope::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, DedicatedWorkerGlobalScope>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

void JSDedicatedWorkerGlobalScope::finishCreation(VM& vm, JSGlobalProxy* proxy)
{
    Base::finishCreation(vm, proxy);

    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).GPUPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).GPUAdapterPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUAdapterConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).GPUAdapterInfoPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUAdapterInfoConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).GPUBindGroupPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUBindGroupConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).GPUBindGroupLayoutPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUBindGroupLayoutConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext())
        putDirectCustomAccessor(vm, builtinNames(vm).GPUBufferPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUBufferConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext())
        putDirectCustomAccessor(vm, builtinNames(vm).GPUBufferUsagePublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUBufferUsageConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext())
        putDirectCustomAccessor(vm, builtinNames(vm).GPUColorWritePublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUColorWriteConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).GPUCommandBufferPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUCommandBufferConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext())
        putDirectCustomAccessor(vm, builtinNames(vm).GPUCommandEncoderPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUCommandEncoderConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).GPUCompilationInfoPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUCompilationInfoConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).GPUCompilationMessagePublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUCompilationMessageConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext())
        putDirectCustomAccessor(vm, builtinNames(vm).GPUComputePassEncoderPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUComputePassEncoderConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).GPUComputePipelinePublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUComputePipelineConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).GPUDevicePublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUDeviceConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).GPUDeviceLostInfoPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUDeviceLostInfoConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).GPUExternalTexturePublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUExternalTextureConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).GPUInternalErrorPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUInternalErrorConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext())
        putDirectCustomAccessor(vm, builtinNames(vm).GPUMapModePublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUMapModeConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).GPUOutOfMemoryErrorPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUOutOfMemoryErrorConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).GPUPipelineLayoutPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUPipelineLayoutConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).GPUQuerySetPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUQuerySetConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext())
        putDirectCustomAccessor(vm, builtinNames(vm).GPUQueuePublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUQueueConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).GPURenderBundlePublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPURenderBundleConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).GPURenderBundleEncoderPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPURenderBundleEncoderConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext())
        putDirectCustomAccessor(vm, builtinNames(vm).GPURenderPassEncoderPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPURenderPassEncoderConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).GPURenderPipelinePublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPURenderPipelineConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).GPUSamplerPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUSamplerConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).GPUShaderModulePublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUShaderModuleConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext())
        putDirectCustomAccessor(vm, builtinNames(vm).GPUShaderStagePublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUShaderStageConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).GPUSupportedFeaturesPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUSupportedFeaturesConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).GPUSupportedLimitsPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUSupportedLimitsConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).GPUTexturePublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUTextureConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext())
        putDirectCustomAccessor(vm, builtinNames(vm).GPUTextureUsagePublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUTextureUsageConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).GPUTextureViewPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUTextureViewConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).GPUUncapturedErrorEventPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUUncapturedErrorEventConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).GPUValidationErrorPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUValidationErrorConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().compressionStreamEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CompressionStreamPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_CompressionStreamConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().compressionStreamEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CompressionStreamEncoderPrivateName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_CompressionStreamEncoderConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().compressionStreamEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).DecompressionStreamPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_DecompressionStreamConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().compressionStreamEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).DecompressionStreamDecoderPrivateName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_DecompressionStreamDecoderConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().accessHandleEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).FileSystemSyncAccessHandlePublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_FileSystemSyncAccessHandleConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().mediaCapabilitiesEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).MediaCapabilitiesPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_MediaCapabilitiesConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#if ENABLE(MEDIA_STREAM) && ENABLE(WEB_CODECS)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().mediaStreamTrackProcessingEnabled) {
        putDirectCustomAccessor(vm, builtinNames(vm).MediaStreamTrackProcessorPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_MediaStreamTrackProcessorConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
        putDirectCustomAccessor(vm, builtinNames(vm).MediaStreamTrackProcessorPrivateName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_MediaStreamTrackProcessorConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    }
#endif
#if ENABLE(WEB_RTC)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webRTCEncodedTransformEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).RTCEncodedAudioFramePublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_RTCEncodedAudioFrameConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_RTC)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webRTCEncodedTransformEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).RTCEncodedVideoFramePublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_RTCEncodedVideoFrameConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_RTC)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webRTCSFrameTransformEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).SFrameTransformPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_SFrameTransformConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_RTC)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webRTCSFrameTransformEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).SFrameTransformErrorEventPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_SFrameTransformErrorEventConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_RTC)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webRTCEncodedTransformEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).RTCRtpScriptTransformerPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_RTCRtpScriptTransformerConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(MEDIA_STREAM) && ENABLE(WEB_CODECS)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().mediaStreamTrackProcessingEnabled) {
        putDirectCustomAccessor(vm, builtinNames(vm).VideoTrackGeneratorPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_VideoTrackGeneratorConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
        putDirectCustomAccessor(vm, builtinNames(vm).VideoTrackGeneratorPrivateName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_VideoTrackGeneratorConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    }
#endif
#if ENABLE(NOTIFICATIONS)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().notificationsEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).NotificationPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_NotificationConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().permissionsAPIEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).PermissionStatusPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_PermissionStatusConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#if ENABLE(WEB_CODECS)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webCodecsAudioEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).AudioDataPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_AudioDataConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_CODECS)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webCodecsAudioEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).AudioDecoderPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_AudioDecoderConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_CODECS)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webCodecsAudioEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).AudioEncoderPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_AudioEncoderConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_CODECS)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webCodecsAudioEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).EncodedAudioChunkPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_EncodedAudioChunkConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_CODECS)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webCodecsVideoEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).EncodedVideoChunkPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_EncodedVideoChunkConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_CODECS)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webCodecsVideoEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).VideoDecoderPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_VideoDecoderConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_CODECS)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webCodecsVideoEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).VideoEncoderPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_VideoEncoderConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_CODECS)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webCodecsVideoEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).VideoFramePublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_VideoFrameConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().fileReaderAPIEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).FileReaderSyncPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_FileReaderSyncConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).GPUCanvasContextPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_GPUCanvasContextConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#if ENABLE(WEB_RTC)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webRTCEncodedTransformEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).onrtctransformPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_onrtctransform, setJSDedicatedWorkerGlobalScope_onrtctransform), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor)));
#endif
#if ENABLE(MEDIA_STREAM)
    putDirectCustomAccessor(vm, builtinNames(vm).MediaStreamTrackPrivateName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_MediaStreamTrackConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
#endif
    putDirectCustomAccessor(vm, builtinNames(vm).ReadableByteStreamControllerPrivateName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_ReadableByteStreamControllerConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).ReadableStreamPrivateName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_ReadableStreamConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).ReadableStreamBYOBReaderPrivateName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_ReadableStreamBYOBReaderConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).ReadableStreamBYOBRequestPrivateName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_ReadableStreamBYOBRequestConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).ReadableStreamDefaultControllerPrivateName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_ReadableStreamDefaultControllerConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).ReadableStreamDefaultReaderPrivateName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_ReadableStreamDefaultReaderConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).TransformStreamPrivateName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_TransformStreamConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).TransformStreamDefaultControllerPrivateName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_TransformStreamDefaultControllerConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).WritableStreamPrivateName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_WritableStreamConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).WritableStreamDefaultControllerPrivateName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_WritableStreamDefaultControllerConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).WritableStreamDefaultWriterPrivateName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_WritableStreamDefaultWriterConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).AbortSignalPrivateName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_AbortSignalConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
#if ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().offscreenCanvasInWorkersEnabled)
        putDirectNativeFunction(vm, this, builtinNames(vm).requestAnimationFramePublicName(), 1, jsDedicatedWorkerGlobalScopeInstanceFunction_requestAnimationFrame, ImplementationVisibility::Public, NoIntrinsic, attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::Function)));
#endif
#if ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().offscreenCanvasInWorkersEnabled)
        putDirectNativeFunction(vm, this, builtinNames(vm).cancelAnimationFramePublicName(), 1, jsDedicatedWorkerGlobalScopeInstanceFunction_cancelAnimationFrame, ImplementationVisibility::Public, NoIntrinsic, attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::Function)));
#endif
}

JSValue JSDedicatedWorkerGlobalScope::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDedicatedWorkerGlobalScopeDOMConstructor, DOMConstructorID::DedicatedWorkerGlobalScope>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScopeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDedicatedWorkerGlobalScopePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDedicatedWorkerGlobalScope::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsDedicatedWorkerGlobalScope_nameGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.name())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_name, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_nameGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDedicatedWorkerGlobalScope_nameSetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject, JSValue value, PropertyName propertyName)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    bool shouldThrow = true;
    thisObject.createDataProperty(&lexicalGlobalObject, propertyName, value, shouldThrow);
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDedicatedWorkerGlobalScope_name, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::setPassingPropertyName<setJSDedicatedWorkerGlobalScope_nameSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_onmessageGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().messageEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_onmessage, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_onmessageGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDedicatedWorkerGlobalScope_onmessageSetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().messageEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDedicatedWorkerGlobalScope_onmessage, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::set<setJSDedicatedWorkerGlobalScope_onmessageSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_onmessageerrorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().messageerrorEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_onmessageerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_onmessageerrorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDedicatedWorkerGlobalScope_onmessageerrorSetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().messageerrorEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDedicatedWorkerGlobalScope_onmessageerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::set<setJSDedicatedWorkerGlobalScope_onmessageerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPU::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUAdapterConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUAdapter::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUAdapterConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUAdapterConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUAdapterInfoConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUAdapterInfo::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUAdapterInfoConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUAdapterInfoConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUBindGroupConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUBindGroup::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUBindGroupConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUBindGroupConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUBindGroupLayoutConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUBindGroupLayout::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUBindGroupLayoutConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUBindGroupLayoutConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUBufferConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUBuffer::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUBufferConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUBufferConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUBufferUsageConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUBufferUsage::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUBufferUsageConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUBufferUsageConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUColorWriteConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUColorWrite::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUColorWriteConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUColorWriteConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUCommandBufferConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUCommandBuffer::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUCommandBufferConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUCommandBufferConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUCommandEncoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUCommandEncoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUCommandEncoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUCommandEncoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUCompilationInfoConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUCompilationInfo::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUCompilationInfoConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUCompilationInfoConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUCompilationMessageConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUCompilationMessage::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUCompilationMessageConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUCompilationMessageConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUComputePassEncoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUComputePassEncoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUComputePassEncoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUComputePassEncoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUComputePipelineConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUComputePipeline::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUComputePipelineConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUComputePipelineConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUDeviceConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUDevice::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUDeviceConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUDeviceConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUDeviceLostInfoConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUDeviceLostInfo::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUDeviceLostInfoConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUDeviceLostInfoConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUExternalTextureConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUExternalTexture::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUExternalTextureConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUExternalTextureConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUInternalErrorConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUInternalError::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUInternalErrorConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUInternalErrorConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUMapModeConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUMapMode::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUMapModeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUMapModeConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUOutOfMemoryErrorConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUOutOfMemoryError::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUOutOfMemoryErrorConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUOutOfMemoryErrorConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUPipelineLayoutConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUPipelineLayout::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUPipelineLayoutConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUPipelineLayoutConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUQuerySetConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUQuerySet::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUQuerySetConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUQuerySetConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUQueueConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUQueue::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUQueueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUQueueConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPURenderBundleConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPURenderBundle::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPURenderBundleConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPURenderBundleConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPURenderBundleEncoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPURenderBundleEncoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPURenderBundleEncoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPURenderBundleEncoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPURenderPassEncoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPURenderPassEncoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPURenderPassEncoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPURenderPassEncoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPURenderPipelineConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPURenderPipeline::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPURenderPipelineConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPURenderPipelineConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUSamplerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUSampler::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUSamplerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUSamplerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUShaderModuleConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUShaderModule::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUShaderModuleConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUShaderModuleConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUShaderStageConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUShaderStage::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUShaderStageConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUShaderStageConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUSupportedFeaturesConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUSupportedFeatures::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUSupportedFeaturesConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUSupportedFeaturesConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUSupportedLimitsConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUSupportedLimits::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUSupportedLimitsConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUSupportedLimitsConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUTextureConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUTexture::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUTextureConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUTextureConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUTextureUsageConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUTextureUsage::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUTextureUsageConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUTextureUsageConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUTextureViewConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUTextureView::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUTextureViewConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUTextureViewConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUUncapturedErrorEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUUncapturedErrorEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUUncapturedErrorEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUUncapturedErrorEventConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUValidationErrorConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUValidationError::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUValidationErrorConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUValidationErrorConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_CompressionStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCompressionStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_CompressionStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_CompressionStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_CompressionStreamEncoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCompressionStreamEncoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_CompressionStreamEncoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_CompressionStreamEncoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_DecompressionStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSDecompressionStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_DecompressionStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_DecompressionStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_DecompressionStreamDecoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSDecompressionStreamDecoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_DecompressionStreamDecoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_DecompressionStreamDecoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_FileSystemSyncAccessHandleConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSFileSystemSyncAccessHandle::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_FileSystemSyncAccessHandleConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_FileSystemSyncAccessHandleConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_MediaCapabilitiesConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSMediaCapabilities::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_MediaCapabilitiesConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_MediaCapabilitiesConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#if ENABLE(MEDIA_STREAM)
static inline JSValue jsDedicatedWorkerGlobalScope_MediaStreamTrackConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSMediaStreamTrack::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_MediaStreamTrackConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_MediaStreamTrackConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(MEDIA_STREAM) && ENABLE(WEB_CODECS)
static inline JSValue jsDedicatedWorkerGlobalScope_MediaStreamTrackProcessorConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSMediaStreamTrackProcessor::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_MediaStreamTrackProcessorConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_MediaStreamTrackProcessorConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEB_RTC)
static inline JSValue jsDedicatedWorkerGlobalScope_RTCEncodedAudioFrameConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSRTCEncodedAudioFrame::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_RTCEncodedAudioFrameConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_RTCEncodedAudioFrameConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEB_RTC)
static inline JSValue jsDedicatedWorkerGlobalScope_RTCEncodedVideoFrameConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSRTCEncodedVideoFrame::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_RTCEncodedVideoFrameConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_RTCEncodedVideoFrameConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEB_RTC)
static inline JSValue jsDedicatedWorkerGlobalScope_SFrameTransformConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSRTCRtpSFrameTransform::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_SFrameTransformConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_SFrameTransformConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEB_RTC)
static inline JSValue jsDedicatedWorkerGlobalScope_SFrameTransformErrorEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSRTCRtpSFrameTransformErrorEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_SFrameTransformErrorEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_SFrameTransformErrorEventConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEB_RTC)
static inline JSValue jsDedicatedWorkerGlobalScope_RTCRtpScriptTransformerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSRTCRtpScriptTransformer::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_RTCRtpScriptTransformerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_RTCRtpScriptTransformerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(MEDIA_STREAM) && ENABLE(WEB_CODECS)
static inline JSValue jsDedicatedWorkerGlobalScope_VideoTrackGeneratorConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSVideoTrackGenerator::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_VideoTrackGeneratorConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_VideoTrackGeneratorConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(NOTIFICATIONS)
static inline JSValue jsDedicatedWorkerGlobalScope_NotificationConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSNotification::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_NotificationConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_NotificationConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

static inline JSValue jsDedicatedWorkerGlobalScope_PermissionStatusConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPermissionStatus::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PermissionStatusConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_PermissionStatusConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_ByteLengthQueuingStrategyConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSByteLengthQueuingStrategy::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ByteLengthQueuingStrategyConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_ByteLengthQueuingStrategyConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_CountQueuingStrategyConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCountQueuingStrategy::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_CountQueuingStrategyConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_CountQueuingStrategyConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_ReadableByteStreamControllerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReadableByteStreamController::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ReadableByteStreamControllerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_ReadableByteStreamControllerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_ReadableStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReadableStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ReadableStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_ReadableStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_ReadableStreamBYOBReaderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReadableStreamBYOBReader::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ReadableStreamBYOBReaderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_ReadableStreamBYOBReaderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_ReadableStreamBYOBRequestConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReadableStreamBYOBRequest::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ReadableStreamBYOBRequestConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_ReadableStreamBYOBRequestConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_ReadableStreamDefaultControllerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReadableStreamDefaultController::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ReadableStreamDefaultControllerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_ReadableStreamDefaultControllerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_ReadableStreamDefaultReaderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReadableStreamDefaultReader::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ReadableStreamDefaultReaderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_ReadableStreamDefaultReaderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_TransformStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTransformStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_TransformStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_TransformStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_TransformStreamDefaultControllerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTransformStreamDefaultController::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_TransformStreamDefaultControllerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_TransformStreamDefaultControllerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_WritableStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWritableStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_WritableStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_WritableStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_WritableStreamDefaultControllerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWritableStreamDefaultController::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_WritableStreamDefaultControllerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_WritableStreamDefaultControllerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_WritableStreamDefaultWriterConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWritableStreamDefaultWriter::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_WritableStreamDefaultWriterConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_WritableStreamDefaultWriterConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#if ENABLE(WEB_CODECS)
static inline JSValue jsDedicatedWorkerGlobalScope_AudioDataConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebCodecsAudioData::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_AudioDataConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_AudioDataConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEB_CODECS)
static inline JSValue jsDedicatedWorkerGlobalScope_AudioDecoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebCodecsAudioDecoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_AudioDecoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_AudioDecoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEB_CODECS)
static inline JSValue jsDedicatedWorkerGlobalScope_AudioEncoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebCodecsAudioEncoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_AudioEncoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_AudioEncoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEB_CODECS)
static inline JSValue jsDedicatedWorkerGlobalScope_EncodedAudioChunkConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebCodecsEncodedAudioChunk::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_EncodedAudioChunkConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_EncodedAudioChunkConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEB_CODECS)
static inline JSValue jsDedicatedWorkerGlobalScope_EncodedVideoChunkConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebCodecsEncodedVideoChunk::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_EncodedVideoChunkConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_EncodedVideoChunkConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEB_CODECS)
static inline JSValue jsDedicatedWorkerGlobalScope_VideoDecoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebCodecsVideoDecoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_VideoDecoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_VideoDecoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEB_CODECS)
static inline JSValue jsDedicatedWorkerGlobalScope_VideoEncoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebCodecsVideoEncoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_VideoEncoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_VideoEncoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEB_CODECS)
static inline JSValue jsDedicatedWorkerGlobalScope_VideoFrameConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebCodecsVideoFrame::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_VideoFrameConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_VideoFrameConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

static inline JSValue jsDedicatedWorkerGlobalScope_AbortControllerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSAbortController::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_AbortControllerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_AbortControllerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_AbortSignalConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSAbortSignal::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_AbortSignalConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_AbortSignalConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_CustomEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCustomEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_CustomEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_CustomEventConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_ErrorEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSErrorEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ErrorEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_ErrorEventConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_EventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_EventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_EventConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_EventTargetConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSEventTarget::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_EventTargetConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_EventTargetConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_PromiseRejectionEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPromiseRejectionEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PromiseRejectionEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_PromiseRejectionEventConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_TextDecoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTextDecoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_TextDecoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_TextDecoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_TextDecoderStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTextDecoderStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_TextDecoderStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_TextDecoderStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_TextEncoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTextEncoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_TextEncoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_TextEncoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_TextEncoderStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTextEncoderStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_TextEncoderStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_TextEncoderStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_FileReaderSyncConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSFileReaderSync::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_FileReaderSyncConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_FileReaderSyncConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_URLConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSDOMURL::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_URLConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_URLConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_URLSearchParamsConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSURLSearchParams::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_URLSearchParamsConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_URLSearchParamsConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_GPUCanvasContextConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSGPUCanvasContext::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_GPUCanvasContextConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_GPUCanvasContextConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_PerformanceConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformance::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_PerformanceConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_PerformanceEntryConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceEntry::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceEntryConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_PerformanceEntryConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_PerformanceMarkConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceMark::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceMarkConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_PerformanceMarkConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_PerformanceMeasureConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceMeasure::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceMeasureConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_PerformanceMeasureConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_PerformanceObserverConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceObserver::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceObserverConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_PerformanceObserverConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_PerformanceObserverEntryListConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceObserverEntryList::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceObserverEntryListConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_PerformanceObserverEntryListConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_PerformanceResourceTimingConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceResourceTiming::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceResourceTimingConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_PerformanceResourceTimingConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_PerformanceServerTimingConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceServerTiming::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceServerTimingConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_PerformanceServerTimingConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_DedicatedWorkerGlobalScopeConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSDedicatedWorkerGlobalScope::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_DedicatedWorkerGlobalScopeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_DedicatedWorkerGlobalScopeConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_WorkerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWorker::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_WorkerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_WorkerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_XMLHttpRequestConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSXMLHttpRequest::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_XMLHttpRequestConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_XMLHttpRequestConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#if ENABLE(WEB_RTC)
static inline JSValue jsDedicatedWorkerGlobalScope_onrtctransformGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().rtctransformEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_onrtctransform, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_onrtctransformGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEB_RTC)
static inline bool setJSDedicatedWorkerGlobalScope_onrtctransformSetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().rtctransformEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDedicatedWorkerGlobalScope_onrtctransform, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::set<setJSDedicatedWorkerGlobalScope_onrtctransformSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

static inline JSC::EncodedJSValue jsDedicatedWorkerGlobalScopeInstanceFunction_postMessage1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDedicatedWorkerGlobalScope>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto message = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto transfer = convert<IDLSequence<IDLObject>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.postMessage(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(message), WTFMove(transfer)); })));
}

static inline JSC::EncodedJSValue jsDedicatedWorkerGlobalScopeInstanceFunction_postMessage2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDedicatedWorkerGlobalScope>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto message = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto options = convert<IDLDictionary<StructuredSerializeOptions>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.postMessage(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(message), WTFMove(options)); })));
}

static inline JSC::EncodedJSValue jsDedicatedWorkerGlobalScopeInstanceFunction_postMessageOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDedicatedWorkerGlobalScope>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 1) {
        RELEASE_AND_RETURN(throwScope, (jsDedicatedWorkerGlobalScopeInstanceFunction_postMessage2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 2) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(1);
        if (distinguishingArg.isUndefined())
            RELEASE_AND_RETURN(throwScope, (jsDedicatedWorkerGlobalScopeInstanceFunction_postMessage2Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isUndefinedOrNull())
            RELEASE_AND_RETURN(throwScope, (jsDedicatedWorkerGlobalScopeInstanceFunction_postMessage2Body(lexicalGlobalObject, callFrame, castedThis)));
        {
            bool success = hasIteratorMethod(lexicalGlobalObject, distinguishingArg);
            RETURN_IF_EXCEPTION(throwScope, { });
            if (success)
                RELEASE_AND_RETURN(throwScope, (jsDedicatedWorkerGlobalScopeInstanceFunction_postMessage1Body(lexicalGlobalObject, callFrame, castedThis)));
        }
        if (distinguishingArg.isObject())
            RELEASE_AND_RETURN(throwScope, (jsDedicatedWorkerGlobalScopeInstanceFunction_postMessage2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsDedicatedWorkerGlobalScopeInstanceFunction_postMessage, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDedicatedWorkerGlobalScope>::call<jsDedicatedWorkerGlobalScopeInstanceFunction_postMessageOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "postMessage");
}

static inline JSC::EncodedJSValue jsDedicatedWorkerGlobalScopeInstanceFunction_closeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDedicatedWorkerGlobalScope>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.close(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDedicatedWorkerGlobalScopeInstanceFunction_close, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDedicatedWorkerGlobalScope>::call<jsDedicatedWorkerGlobalScopeInstanceFunction_closeBody>(*lexicalGlobalObject, *callFrame, "close");
}

#if ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
static inline JSC::EncodedJSValue jsDedicatedWorkerGlobalScopeInstanceFunction_requestAnimationFrameBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDedicatedWorkerGlobalScope>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto callback = convert<IDLCallbackFunction<JSRequestAnimationFrameCallback>>(*lexicalGlobalObject, argument0.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "callback", "DedicatedWorkerGlobalScope", "requestAnimationFrame"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUnsignedLong>(*lexicalGlobalObject, throwScope, impl.requestAnimationFrame(callback.releaseNonNull()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDedicatedWorkerGlobalScopeInstanceFunction_requestAnimationFrame, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDedicatedWorkerGlobalScope>::call<jsDedicatedWorkerGlobalScopeInstanceFunction_requestAnimationFrameBody>(*lexicalGlobalObject, *callFrame, "requestAnimationFrame");
}

#endif

#if ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
static inline JSC::EncodedJSValue jsDedicatedWorkerGlobalScopeInstanceFunction_cancelAnimationFrameBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDedicatedWorkerGlobalScope>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto handle = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.cancelAnimationFrame(WTFMove(handle)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDedicatedWorkerGlobalScopeInstanceFunction_cancelAnimationFrame, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDedicatedWorkerGlobalScope>::call<jsDedicatedWorkerGlobalScopeInstanceFunction_cancelAnimationFrameBody>(*lexicalGlobalObject, *callFrame, "cancelAnimationFrame");
}

#endif

JSC::GCClient::IsoSubspace* JSDedicatedWorkerGlobalScope::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSDedicatedWorkerGlobalScope, UseCustomHeapCellType::Yes>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForDedicatedWorkerGlobalScope.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForDedicatedWorkerGlobalScope = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForDedicatedWorkerGlobalScope.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForDedicatedWorkerGlobalScope = std::forward<decltype(space)>(space); },
        [] (auto& server) -> JSC::HeapCellType& { return server.m_heapCellTypeForJSDedicatedWorkerGlobalScope; }
    );
}

void JSDedicatedWorkerGlobalScope::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDedicatedWorkerGlobalScope*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

DedicatedWorkerGlobalScope* JSDedicatedWorkerGlobalScope::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDedicatedWorkerGlobalScope*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
