/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCookieStoreManager.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSCookieStoreGetOptions.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsCookieStoreManagerPrototypeFunction_subscribe);
static JSC_DECLARE_HOST_FUNCTION(jsCookieStoreManagerPrototypeFunction_getSubscriptions);
static JSC_DECLARE_HOST_FUNCTION(jsCookieStoreManagerPrototypeFunction_unsubscribe);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCookieStoreManagerConstructor);

class JSCookieStoreManagerPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCookieStoreManagerPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCookieStoreManagerPrototype* ptr = new (NotNull, JSC::allocateCell<JSCookieStoreManagerPrototype>(vm)) JSCookieStoreManagerPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCookieStoreManagerPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCookieStoreManagerPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCookieStoreManagerPrototype, JSCookieStoreManagerPrototype::Base);

using JSCookieStoreManagerDOMConstructor = JSDOMConstructorNotConstructable<JSCookieStoreManager>;

template<> const ClassInfo JSCookieStoreManagerDOMConstructor::s_info = { "CookieStoreManager"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCookieStoreManagerDOMConstructor) };

template<> JSValue JSCookieStoreManagerDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSCookieStoreManagerDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CookieStoreManager"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCookieStoreManager::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSCookieStoreManagerPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCookieStoreManagerConstructor, 0 } },
    { "subscribe"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCookieStoreManagerPrototypeFunction_subscribe, 1 } },
    { "getSubscriptions"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCookieStoreManagerPrototypeFunction_getSubscriptions, 0 } },
    { "unsubscribe"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCookieStoreManagerPrototypeFunction_unsubscribe, 1 } },
};

const ClassInfo JSCookieStoreManagerPrototype::s_info = { "CookieStoreManager"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCookieStoreManagerPrototype) };

void JSCookieStoreManagerPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCookieStoreManager::info(), JSCookieStoreManagerPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCookieStoreManager::s_info = { "CookieStoreManager"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCookieStoreManager) };

JSCookieStoreManager::JSCookieStoreManager(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CookieStoreManager>&& impl)
    : JSDOMWrapper<CookieStoreManager>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, CookieStoreManager>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCookieStoreManager::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCookieStoreManagerPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSCookieStoreManagerPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCookieStoreManager::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCookieStoreManager>(vm, globalObject);
}

JSValue JSCookieStoreManager::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCookieStoreManagerDOMConstructor, DOMConstructorID::CookieStoreManager>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSCookieStoreManager::destroy(JSC::JSCell* cell)
{
    JSCookieStoreManager* thisObject = static_cast<JSCookieStoreManager*>(cell);
    thisObject->JSCookieStoreManager::~JSCookieStoreManager();
}

JSC_DEFINE_CUSTOM_GETTER(jsCookieStoreManagerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCookieStoreManagerPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCookieStoreManager::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsCookieStoreManagerPrototypeFunction_subscribeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSCookieStoreManager>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto subscriptions = convert<IDLSequence<IDLDictionary<CookieStoreGetOptions>>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.subscribe(WTFMove(subscriptions), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCookieStoreManagerPrototypeFunction_subscribe, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSCookieStoreManager>::call<jsCookieStoreManagerPrototypeFunction_subscribeBody>(*lexicalGlobalObject, *callFrame, "subscribe");
}

static inline JSC::EncodedJSValue jsCookieStoreManagerPrototypeFunction_getSubscriptionsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSCookieStoreManager>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLSequence<IDLDictionary<CookieStoreGetOptions>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.getSubscriptions(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCookieStoreManagerPrototypeFunction_getSubscriptions, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSCookieStoreManager>::call<jsCookieStoreManagerPrototypeFunction_getSubscriptionsBody>(*lexicalGlobalObject, *callFrame, "getSubscriptions");
}

static inline JSC::EncodedJSValue jsCookieStoreManagerPrototypeFunction_unsubscribeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSCookieStoreManager>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto subscriptions = convert<IDLSequence<IDLDictionary<CookieStoreGetOptions>>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.unsubscribe(WTFMove(subscriptions), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCookieStoreManagerPrototypeFunction_unsubscribe, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSCookieStoreManager>::call<jsCookieStoreManagerPrototypeFunction_unsubscribeBody>(*lexicalGlobalObject, *callFrame, "unsubscribe");
}

JSC::GCClient::IsoSubspace* JSCookieStoreManager::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCookieStoreManager, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCookieStoreManager.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCookieStoreManager = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCookieStoreManager.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCookieStoreManager = std::forward<decltype(space)>(space); }
    );
}

void JSCookieStoreManager::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCookieStoreManager*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSCookieStoreManagerOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSCookieStoreManagerOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsCookieStoreManager = static_cast<JSCookieStoreManager*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsCookieStoreManager->wrapped(), jsCookieStoreManager);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CookieStoreManager@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore18CookieStoreManagerE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CookieStoreManager>&& impl)
{

    if constexpr (std::is_polymorphic_v<CookieStoreManager>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7CookieStoreManager@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore18CookieStoreManagerE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // CookieStoreManager has subclasses. If CookieStoreManager has subclasses that get passed
        // to toJS() we currently require CookieStoreManager you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<CookieStoreManager>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CookieStoreManager& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

CookieStoreManager* JSCookieStoreManager::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCookieStoreManager*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
