/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCheckVisibilityOptions.h"

#include "JSDOMConvertBoolean.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> CheckVisibilityOptions convertDictionary<CheckVisibilityOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    CheckVisibilityOptions result;
    JSValue checkOpacityValue;
    if (isNullOrUndefined)
        checkOpacityValue = jsUndefined();
    else {
        checkOpacityValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "checkOpacity"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!checkOpacityValue.isUndefined()) {
        result.checkOpacity = convert<IDLBoolean>(lexicalGlobalObject, checkOpacityValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.checkOpacity = false;
    JSValue checkVisibilityCSSValue;
    if (isNullOrUndefined)
        checkVisibilityCSSValue = jsUndefined();
    else {
        checkVisibilityCSSValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "checkVisibilityCSS"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!checkVisibilityCSSValue.isUndefined()) {
        result.checkVisibilityCSS = convert<IDLBoolean>(lexicalGlobalObject, checkVisibilityCSSValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.checkVisibilityCSS = false;
    JSValue contentVisibilityAutoValue;
    if (isNullOrUndefined)
        contentVisibilityAutoValue = jsUndefined();
    else {
        contentVisibilityAutoValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "contentVisibilityAuto"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!contentVisibilityAutoValue.isUndefined()) {
        result.contentVisibilityAuto = convert<IDLBoolean>(lexicalGlobalObject, contentVisibilityAutoValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.contentVisibilityAuto = false;
    JSValue opacityPropertyValue;
    if (isNullOrUndefined)
        opacityPropertyValue = jsUndefined();
    else {
        opacityPropertyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "opacityProperty"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!opacityPropertyValue.isUndefined()) {
        result.opacityProperty = convert<IDLBoolean>(lexicalGlobalObject, opacityPropertyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.opacityProperty = false;
    JSValue visibilityPropertyValue;
    if (isNullOrUndefined)
        visibilityPropertyValue = jsUndefined();
    else {
        visibilityPropertyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "visibilityProperty"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!visibilityPropertyValue.isUndefined()) {
        result.visibilityProperty = convert<IDLBoolean>(lexicalGlobalObject, visibilityPropertyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.visibilityProperty = false;
    return result;
}

} // namespace WebCore
