/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSNumericValue.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSCSSMathSum.h"
#include "JSCSSNumericType.h"
#include "JSCSSNumericValue.h"
#include "JSCSSUnitValue.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMConvertVariadic.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWindowBase.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsCSSNumericValuePrototypeFunction_add);
static JSC_DECLARE_HOST_FUNCTION(jsCSSNumericValuePrototypeFunction_sub);
static JSC_DECLARE_HOST_FUNCTION(jsCSSNumericValuePrototypeFunction_mul);
static JSC_DECLARE_HOST_FUNCTION(jsCSSNumericValuePrototypeFunction_div);
static JSC_DECLARE_HOST_FUNCTION(jsCSSNumericValuePrototypeFunction_min);
static JSC_DECLARE_HOST_FUNCTION(jsCSSNumericValuePrototypeFunction_max);
static JSC_DECLARE_HOST_FUNCTION(jsCSSNumericValuePrototypeFunction_equals);
static JSC_DECLARE_HOST_FUNCTION(jsCSSNumericValuePrototypeFunction_to);
static JSC_DECLARE_HOST_FUNCTION(jsCSSNumericValuePrototypeFunction_toSum);
static JSC_DECLARE_HOST_FUNCTION(jsCSSNumericValuePrototypeFunction_type);
static JSC_DECLARE_HOST_FUNCTION(jsCSSNumericValueConstructorFunction_parse);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCSSNumericValueConstructor);

class JSCSSNumericValuePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSNumericValuePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSNumericValuePrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSNumericValuePrototype>(vm)) JSCSSNumericValuePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSNumericValuePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSNumericValuePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSNumericValuePrototype, JSCSSNumericValuePrototype::Base);

using JSCSSNumericValueDOMConstructor = JSDOMConstructorNotConstructable<JSCSSNumericValue>;

/* Hash table for constructor */

static const HashTableValue JSCSSNumericValueConstructorTableValues[] =
{
    { "parse"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSNumericValueConstructorFunction_parse, 1 } },
};

template<> const ClassInfo JSCSSNumericValueDOMConstructor::s_info = { "CSSNumericValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSNumericValueDOMConstructor) };

template<> JSValue JSCSSNumericValueDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCSSStyleValue::getConstructor(vm, &globalObject);
}

template<> void JSCSSNumericValueDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CSSNumericValue"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCSSNumericValue::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSCSSNumericValue::info(), JSCSSNumericValueConstructorTableValues, *this);
    if (!(&globalObject)->inherits<JSDOMWindowBase>()) {
        auto propertyName = Identifier::fromString(vm, "parse"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
}

/* Hash table for prototype */

static const HashTableValue JSCSSNumericValuePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSNumericValueConstructor, 0 } },
    { "add"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSNumericValuePrototypeFunction_add, 0 } },
    { "sub"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSNumericValuePrototypeFunction_sub, 0 } },
    { "mul"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSNumericValuePrototypeFunction_mul, 0 } },
    { "div"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSNumericValuePrototypeFunction_div, 0 } },
    { "min"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSNumericValuePrototypeFunction_min, 0 } },
    { "max"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSNumericValuePrototypeFunction_max, 0 } },
    { "equals"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSNumericValuePrototypeFunction_equals, 0 } },
    { "to"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSNumericValuePrototypeFunction_to, 1 } },
    { "toSum"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSNumericValuePrototypeFunction_toSum, 0 } },
    { "type"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSNumericValuePrototypeFunction_type, 0 } },
};

const ClassInfo JSCSSNumericValuePrototype::s_info = { "CSSNumericValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSNumericValuePrototype) };

void JSCSSNumericValuePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSNumericValue::info(), JSCSSNumericValuePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCSSNumericValue::s_info = { "CSSNumericValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSNumericValue) };

JSCSSNumericValue::JSCSSNumericValue(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSNumericValue>&& impl)
    : JSCSSStyleValue(structure, globalObject, WTFMove(impl))
{
}

Ref<CSSNumericValue> JSCSSNumericValue::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, CSSNumericValue>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCSSNumericValue::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCSSNumericValuePrototype::createStructure(vm, &globalObject, JSCSSStyleValue::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCSSNumericValuePrototype::create(vm, &globalObject, structure);
}

JSObject* JSCSSNumericValue::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSNumericValue>(vm, globalObject);
}

JSValue JSCSSNumericValue::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSNumericValueDOMConstructor, DOMConstructorID::CSSNumericValue>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSNumericValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSNumericValuePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSSNumericValue::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsCSSNumericValuePrototypeFunction_addBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCSSNumericValue>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    auto values = convertVariadicArguments<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>>>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSNumericValue>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.add(WTFMove(values)))));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSNumericValuePrototypeFunction_add, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSSNumericValue>::call<jsCSSNumericValuePrototypeFunction_addBody>(*lexicalGlobalObject, *callFrame, "add");
}

static inline JSC::EncodedJSValue jsCSSNumericValuePrototypeFunction_subBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCSSNumericValue>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    auto values = convertVariadicArguments<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>>>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSNumericValue>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.sub(WTFMove(values)))));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSNumericValuePrototypeFunction_sub, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSSNumericValue>::call<jsCSSNumericValuePrototypeFunction_subBody>(*lexicalGlobalObject, *callFrame, "sub");
}

static inline JSC::EncodedJSValue jsCSSNumericValuePrototypeFunction_mulBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCSSNumericValue>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    auto values = convertVariadicArguments<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>>>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSNumericValue>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.mul(WTFMove(values)))));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSNumericValuePrototypeFunction_mul, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSSNumericValue>::call<jsCSSNumericValuePrototypeFunction_mulBody>(*lexicalGlobalObject, *callFrame, "mul");
}

static inline JSC::EncodedJSValue jsCSSNumericValuePrototypeFunction_divBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCSSNumericValue>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    auto values = convertVariadicArguments<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>>>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSNumericValue>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.div(WTFMove(values)))));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSNumericValuePrototypeFunction_div, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSSNumericValue>::call<jsCSSNumericValuePrototypeFunction_divBody>(*lexicalGlobalObject, *callFrame, "div");
}

static inline JSC::EncodedJSValue jsCSSNumericValuePrototypeFunction_minBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCSSNumericValue>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    auto values = convertVariadicArguments<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>>>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSNumericValue>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.min(WTFMove(values)))));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSNumericValuePrototypeFunction_min, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSSNumericValue>::call<jsCSSNumericValuePrototypeFunction_minBody>(*lexicalGlobalObject, *callFrame, "min");
}

static inline JSC::EncodedJSValue jsCSSNumericValuePrototypeFunction_maxBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCSSNumericValue>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    auto values = convertVariadicArguments<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>>>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSNumericValue>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.max(WTFMove(values)))));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSNumericValuePrototypeFunction_max, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSSNumericValue>::call<jsCSSNumericValuePrototypeFunction_maxBody>(*lexicalGlobalObject, *callFrame, "max");
}

static inline JSC::EncodedJSValue jsCSSNumericValuePrototypeFunction_equalsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCSSNumericValue>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    auto value = convertVariadicArguments<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>>>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.equals(WTFMove(value)))));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSNumericValuePrototypeFunction_equals, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSSNumericValue>::call<jsCSSNumericValuePrototypeFunction_equalsBody>(*lexicalGlobalObject, *callFrame, "equals");
}

static inline JSC::EncodedJSValue jsCSSNumericValuePrototypeFunction_toBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCSSNumericValue>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto unit = convert<IDLUSVString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSUnitValue>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.to(WTFMove(unit)))));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSNumericValuePrototypeFunction_to, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSSNumericValue>::call<jsCSSNumericValuePrototypeFunction_toBody>(*lexicalGlobalObject, *callFrame, "to");
}

static inline JSC::EncodedJSValue jsCSSNumericValuePrototypeFunction_toSumBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCSSNumericValue>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    auto units = convertVariadicArguments<IDLUSVString>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSMathSum>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.toSum(WTFMove(units)))));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSNumericValuePrototypeFunction_toSum, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSSNumericValue>::call<jsCSSNumericValuePrototypeFunction_toSumBody>(*lexicalGlobalObject, *callFrame, "toSum");
}

static inline JSC::EncodedJSValue jsCSSNumericValuePrototypeFunction_typeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCSSNumericValue>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDictionary<CSSNumericType>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.type())));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSNumericValuePrototypeFunction_type, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSSNumericValue>::call<jsCSSNumericValuePrototypeFunction_typeBody>(*lexicalGlobalObject, *callFrame, "type");
}

static inline JSC::EncodedJSValue jsCSSNumericValueConstructorFunction_parseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto cssText = convert<IDLUSVString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSNumericValue>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, CSSNumericValue::parse(WTFMove(cssText)))));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSNumericValueConstructorFunction_parse, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSSNumericValue>::callStatic<jsCSSNumericValueConstructorFunction_parseBody>(*lexicalGlobalObject, *callFrame, "parse");
}

JSC::GCClient::IsoSubspace* JSCSSNumericValue::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCSSNumericValue, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCSSNumericValue.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCSSNumericValue = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCSSNumericValue.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCSSNumericValue = std::forward<decltype(space)>(space); }
    );
}

void JSCSSNumericValue::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSNumericValue*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

CSSNumericValue* JSCSSNumericValue::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCSSNumericValue*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
