/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSLab.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSCSSKeywordValue.h"
#include "JSCSSNumericValue.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCSSLabConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSLab_l);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSLab_l);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSLab_a);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSLab_a);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSLab_b);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSLab_b);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSLab_alpha);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSLab_alpha);

class JSCSSLabPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSLabPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSLabPrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSLabPrototype>(vm)) JSCSSLabPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSLabPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSLabPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSLabPrototype, JSCSSLabPrototype::Base);

using JSCSSLabDOMConstructor = JSDOMConstructor<JSCSSLab>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSCSSLabDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSCSSLabDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto l = convert<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto a = convert<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto b = convert<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto alpha = argument3.value().isUndefined() ? 1.0 : convert<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = CSSLab::create(WTFMove(l), WTFMove(a), WTFMove(b), WTFMove(alpha));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<CSSLab>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<CSSLab>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSCSSLabDOMConstructorConstruct, JSCSSLabDOMConstructor::construct);

template<> const ClassInfo JSCSSLabDOMConstructor::s_info = { "CSSLab"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSLabDOMConstructor) };

template<> JSValue JSCSSLabDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCSSColorValue::getConstructor(vm, &globalObject);
}

template<> void JSCSSLabDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(3), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CSSLab"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCSSLab::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSCSSLabPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSLabConstructor, 0 } },
    { "l"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSLab_l, setJSCSSLab_l } },
    { "a"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSLab_a, setJSCSSLab_a } },
    { "b"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSLab_b, setJSCSSLab_b } },
    { "alpha"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSLab_alpha, setJSCSSLab_alpha } },
};

const ClassInfo JSCSSLabPrototype::s_info = { "CSSLab"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSLabPrototype) };

void JSCSSLabPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSLab::info(), JSCSSLabPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCSSLab::s_info = { "CSSLab"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSLab) };

JSCSSLab::JSCSSLab(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSLab>&& impl)
    : JSCSSColorValue(structure, globalObject, WTFMove(impl))
{
}

Ref<CSSLab> JSCSSLab::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, CSSLab>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCSSLab::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCSSLabPrototype::createStructure(vm, &globalObject, JSCSSColorValue::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCSSLabPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCSSLab::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSLab>(vm, globalObject);
}

JSValue JSCSSLab::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSLabDOMConstructor, DOMConstructorID::CSSLab>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSLabConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSLabPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSSLab::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsCSSLab_lGetter(JSGlobalObject& lexicalGlobalObject, JSCSSLab& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.l())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSLab_l, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSLab>::get<jsCSSLab_lGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSLab_lSetter(JSGlobalObject& lexicalGlobalObject, JSCSSLab& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setL(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSLab_l, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSLab>::set<setJSCSSLab_lSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSLab_aGetter(JSGlobalObject& lexicalGlobalObject, JSCSSLab& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.a())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSLab_a, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSLab>::get<jsCSSLab_aGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSLab_aSetter(JSGlobalObject& lexicalGlobalObject, JSCSSLab& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setA(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSLab_a, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSLab>::set<setJSCSSLab_aSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSLab_bGetter(JSGlobalObject& lexicalGlobalObject, JSCSSLab& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.b())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSLab_b, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSLab>::get<jsCSSLab_bGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSLab_bSetter(JSGlobalObject& lexicalGlobalObject, JSCSSLab& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setB(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSLab_b, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSLab>::set<setJSCSSLab_bSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSLab_alphaGetter(JSGlobalObject& lexicalGlobalObject, JSCSSLab& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.alpha())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSLab_alpha, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSLab>::get<jsCSSLab_alphaGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSLab_alphaSetter(JSGlobalObject& lexicalGlobalObject, JSCSSLab& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAlpha(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSLab_alpha, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSLab>::set<setJSCSSLab_alphaSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSCSSLab::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCSSLab, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCSSLab.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCSSLab = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCSSLab.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCSSLab = std::forward<decltype(space)>(space); }
    );
}

void JSCSSLab::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSLab*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CSSLab@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore6CSSLabE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CSSLab>&& impl)
{

    if constexpr (std::is_polymorphic_v<CSSLab>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7CSSLab@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore6CSSLabE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // CSSLab has subclasses. If CSSLab has subclasses that get passed
        // to toJS() we currently require CSSLab you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<CSSLab>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CSSLab& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

CSSLab* JSCSSLab::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCSSLab*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
