/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSPViolationReportBody.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSSecurityPolicyViolationEventDisposition.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsCSPViolationReportBodyPrototypeFunction_toJSON);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCSPViolationReportBodyConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCSPViolationReportBody_documentURL);
static JSC_DECLARE_CUSTOM_GETTER(jsCSPViolationReportBody_referrer);
static JSC_DECLARE_CUSTOM_GETTER(jsCSPViolationReportBody_blockedURL);
static JSC_DECLARE_CUSTOM_GETTER(jsCSPViolationReportBody_effectiveDirective);
static JSC_DECLARE_CUSTOM_GETTER(jsCSPViolationReportBody_originalPolicy);
static JSC_DECLARE_CUSTOM_GETTER(jsCSPViolationReportBody_sourceFile);
static JSC_DECLARE_CUSTOM_GETTER(jsCSPViolationReportBody_sample);
static JSC_DECLARE_CUSTOM_GETTER(jsCSPViolationReportBody_disposition);
static JSC_DECLARE_CUSTOM_GETTER(jsCSPViolationReportBody_statusCode);
static JSC_DECLARE_CUSTOM_GETTER(jsCSPViolationReportBody_lineNumber);
static JSC_DECLARE_CUSTOM_GETTER(jsCSPViolationReportBody_columnNumber);

class JSCSPViolationReportBodyPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSPViolationReportBodyPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSPViolationReportBodyPrototype* ptr = new (NotNull, JSC::allocateCell<JSCSPViolationReportBodyPrototype>(vm)) JSCSPViolationReportBodyPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSPViolationReportBodyPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSPViolationReportBodyPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSPViolationReportBodyPrototype, JSCSPViolationReportBodyPrototype::Base);

using JSCSPViolationReportBodyDOMConstructor = JSDOMConstructorNotConstructable<JSCSPViolationReportBody>;

template<> const ClassInfo JSCSPViolationReportBodyDOMConstructor::s_info = { "CSPViolationReportBody"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSPViolationReportBodyDOMConstructor) };

template<> JSValue JSCSPViolationReportBodyDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSReportBody::getConstructor(vm, &globalObject);
}

template<> void JSCSPViolationReportBodyDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CSPViolationReportBody"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCSPViolationReportBody::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSCSPViolationReportBodyPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCSPViolationReportBodyConstructor, 0 } },
    { "documentURL"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSPViolationReportBody_documentURL, 0 } },
    { "referrer"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSPViolationReportBody_referrer, 0 } },
    { "blockedURL"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSPViolationReportBody_blockedURL, 0 } },
    { "effectiveDirective"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSPViolationReportBody_effectiveDirective, 0 } },
    { "originalPolicy"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSPViolationReportBody_originalPolicy, 0 } },
    { "sourceFile"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSPViolationReportBody_sourceFile, 0 } },
    { "sample"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSPViolationReportBody_sample, 0 } },
    { "disposition"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSPViolationReportBody_disposition, 0 } },
    { "statusCode"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSPViolationReportBody_statusCode, 0 } },
    { "lineNumber"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSPViolationReportBody_lineNumber, 0 } },
    { "columnNumber"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSPViolationReportBody_columnNumber, 0 } },
    { "toJSON"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSPViolationReportBodyPrototypeFunction_toJSON, 0 } },
};

const ClassInfo JSCSPViolationReportBodyPrototype::s_info = { "CSPViolationReportBody"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSPViolationReportBodyPrototype) };

void JSCSPViolationReportBodyPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSPViolationReportBody::info(), JSCSPViolationReportBodyPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCSPViolationReportBody::s_info = { "CSPViolationReportBody"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSPViolationReportBody) };

JSCSPViolationReportBody::JSCSPViolationReportBody(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSPViolationReportBody>&& impl)
    : JSReportBody(structure, globalObject, WTFMove(impl))
{
}

Ref<CSPViolationReportBody> JSCSPViolationReportBody::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, CSPViolationReportBody>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCSPViolationReportBody::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCSPViolationReportBodyPrototype::createStructure(vm, &globalObject, JSReportBody::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCSPViolationReportBodyPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCSPViolationReportBody::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSPViolationReportBody>(vm, globalObject);
}

JSValue JSCSPViolationReportBody::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSPViolationReportBodyDOMConstructor, DOMConstructorID::CSPViolationReportBody>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSPViolationReportBodyConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSPViolationReportBodyPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSPViolationReportBody::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsCSPViolationReportBody_documentURLGetter(JSGlobalObject& lexicalGlobalObject, JSCSPViolationReportBody& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.documentURL())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSPViolationReportBody_documentURL, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSPViolationReportBody>::get<jsCSPViolationReportBody_documentURLGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCSPViolationReportBody_referrerGetter(JSGlobalObject& lexicalGlobalObject, JSCSPViolationReportBody& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.referrer())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSPViolationReportBody_referrer, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSPViolationReportBody>::get<jsCSPViolationReportBody_referrerGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCSPViolationReportBody_blockedURLGetter(JSGlobalObject& lexicalGlobalObject, JSCSPViolationReportBody& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.blockedURL())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSPViolationReportBody_blockedURL, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSPViolationReportBody>::get<jsCSPViolationReportBody_blockedURLGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCSPViolationReportBody_effectiveDirectiveGetter(JSGlobalObject& lexicalGlobalObject, JSCSPViolationReportBody& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.effectiveDirective())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSPViolationReportBody_effectiveDirective, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSPViolationReportBody>::get<jsCSPViolationReportBody_effectiveDirectiveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCSPViolationReportBody_originalPolicyGetter(JSGlobalObject& lexicalGlobalObject, JSCSPViolationReportBody& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.originalPolicy())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSPViolationReportBody_originalPolicy, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSPViolationReportBody>::get<jsCSPViolationReportBody_originalPolicyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCSPViolationReportBody_sourceFileGetter(JSGlobalObject& lexicalGlobalObject, JSCSPViolationReportBody& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.sourceFile())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSPViolationReportBody_sourceFile, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSPViolationReportBody>::get<jsCSPViolationReportBody_sourceFileGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCSPViolationReportBody_sampleGetter(JSGlobalObject& lexicalGlobalObject, JSCSPViolationReportBody& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.sample())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSPViolationReportBody_sample, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSPViolationReportBody>::get<jsCSPViolationReportBody_sampleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCSPViolationReportBody_dispositionGetter(JSGlobalObject& lexicalGlobalObject, JSCSPViolationReportBody& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<SecurityPolicyViolationEventDisposition>>(lexicalGlobalObject, throwScope, impl.disposition())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSPViolationReportBody_disposition, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSPViolationReportBody>::get<jsCSPViolationReportBody_dispositionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCSPViolationReportBody_statusCodeGetter(JSGlobalObject& lexicalGlobalObject, JSCSPViolationReportBody& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.statusCode())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSPViolationReportBody_statusCode, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSPViolationReportBody>::get<jsCSPViolationReportBody_statusCodeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCSPViolationReportBody_lineNumberGetter(JSGlobalObject& lexicalGlobalObject, JSCSPViolationReportBody& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUnsignedLong>>(lexicalGlobalObject, throwScope, impl.lineNumber())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSPViolationReportBody_lineNumber, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSPViolationReportBody>::get<jsCSPViolationReportBody_lineNumberGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCSPViolationReportBody_columnNumberGetter(JSGlobalObject& lexicalGlobalObject, JSCSPViolationReportBody& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUnsignedLong>>(lexicalGlobalObject, throwScope, impl.columnNumber())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSPViolationReportBody_columnNumber, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSPViolationReportBody>::get<jsCSPViolationReportBody_columnNumberGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline EncodedJSValue jsCSPViolationReportBodyPrototypeFunction_toJSONBody(JSGlobalObject* lexicalGlobalObject, CallFrame*, JSCSPViolationReportBody* castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto* result = constructEmptyObject(lexicalGlobalObject);
    auto documentURLValue = toJS<IDLUSVString>(*lexicalGlobalObject, throwScope, impl.documentURL());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "documentURL"_s), documentURLValue);
    auto referrerValue = toJS<IDLNullable<IDLUSVString>>(*lexicalGlobalObject, throwScope, impl.referrer());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "referrer"_s), referrerValue);
    auto blockedURLValue = toJS<IDLNullable<IDLUSVString>>(*lexicalGlobalObject, throwScope, impl.blockedURL());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "blockedURL"_s), blockedURLValue);
    auto effectiveDirectiveValue = toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.effectiveDirective());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "effectiveDirective"_s), effectiveDirectiveValue);
    auto originalPolicyValue = toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.originalPolicy());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "originalPolicy"_s), originalPolicyValue);
    auto sourceFileValue = toJS<IDLNullable<IDLUSVString>>(*lexicalGlobalObject, throwScope, impl.sourceFile());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "sourceFile"_s), sourceFileValue);
    auto sampleValue = toJS<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, throwScope, impl.sample());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "sample"_s), sampleValue);
    auto dispositionValue = toJS<IDLEnumeration<SecurityPolicyViolationEventDisposition>>(*lexicalGlobalObject, throwScope, impl.disposition());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "disposition"_s), dispositionValue);
    auto statusCodeValue = toJS<IDLUnsignedShort>(*lexicalGlobalObject, throwScope, impl.statusCode());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "statusCode"_s), statusCodeValue);
    auto lineNumberValue = toJS<IDLNullable<IDLUnsignedLong>>(*lexicalGlobalObject, throwScope, impl.lineNumber());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "lineNumber"_s), lineNumberValue);
    auto columnNumberValue = toJS<IDLNullable<IDLUnsignedLong>>(*lexicalGlobalObject, throwScope, impl.columnNumber());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "columnNumber"_s), columnNumberValue);
    return JSValue::encode(result);
}

JSC_DEFINE_HOST_FUNCTION(jsCSPViolationReportBodyPrototypeFunction_toJSON, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSPViolationReportBody>::call<jsCSPViolationReportBodyPrototypeFunction_toJSONBody>(*lexicalGlobalObject, *callFrame, "toJSON");
}

JSC::GCClient::IsoSubspace* JSCSPViolationReportBody::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCSPViolationReportBody, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCSPViolationReportBody.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCSPViolationReportBody = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCSPViolationReportBody.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCSPViolationReportBody = std::forward<decltype(space)>(space); }
    );
}

void JSCSPViolationReportBody::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSPViolationReportBody*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
