/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSBaseAudioContext.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSAnalyserNode.h"
#include "JSAudioBuffer.h"
#include "JSAudioBufferCallback.h"
#include "JSAudioBufferSourceNode.h"
#include "JSAudioContextState.h"
#include "JSAudioDestinationNode.h"
#include "JSAudioListener.h"
#include "JSAudioWorklet.h"
#include "JSBiquadFilterNode.h"
#include "JSChannelMergerNode.h"
#include "JSChannelSplitterNode.h"
#include "JSConstantSourceNode.h"
#include "JSConvolverNode.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSDelayNode.h"
#include "JSDynamicsCompressorNode.h"
#include "JSEventListener.h"
#include "JSGainNode.h"
#include "JSIIRFilterNode.h"
#include "JSOscillatorNode.h"
#include "JSPannerNode.h"
#include "JSPeriodicWave.h"
#include "JSPeriodicWaveOptions.h"
#include "JSScriptProcessorNode.h"
#include "JSStereoPannerNode.h"
#include "JSWaveShaperNode.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createBuffer);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_decodeAudioData);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createBufferSource);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createGain);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createDelay);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createBiquadFilter);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createWaveShaper);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createPanner);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createConvolver);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createDynamicsCompressor);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createAnalyser);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createScriptProcessor);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createOscillator);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createPeriodicWave);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createConstantSource);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createStereoPanner);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createIIRFilter);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createChannelSplitter);
static JSC_DECLARE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createChannelMerger);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsBaseAudioContextConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsBaseAudioContext_destination);
static JSC_DECLARE_CUSTOM_GETTER(jsBaseAudioContext_currentTime);
static JSC_DECLARE_CUSTOM_GETTER(jsBaseAudioContext_sampleRate);
static JSC_DECLARE_CUSTOM_GETTER(jsBaseAudioContext_listener);
static JSC_DECLARE_CUSTOM_GETTER(jsBaseAudioContext_audioWorklet);
static JSC_DECLARE_CUSTOM_GETTER(jsBaseAudioContext_state);
static JSC_DECLARE_CUSTOM_GETTER(jsBaseAudioContext_onstatechange);
static JSC_DECLARE_CUSTOM_SETTER(setJSBaseAudioContext_onstatechange);

class JSBaseAudioContextPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSBaseAudioContextPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSBaseAudioContextPrototype* ptr = new (NotNull, JSC::allocateCell<JSBaseAudioContextPrototype>(vm)) JSBaseAudioContextPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSBaseAudioContextPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSBaseAudioContextPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSBaseAudioContextPrototype, JSBaseAudioContextPrototype::Base);

using JSBaseAudioContextDOMConstructor = JSDOMConstructorNotConstructable<JSBaseAudioContext>;

template<> const ClassInfo JSBaseAudioContextDOMConstructor::s_info = { "BaseAudioContext"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBaseAudioContextDOMConstructor) };

template<> JSValue JSBaseAudioContextDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSBaseAudioContextDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "BaseAudioContext"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSBaseAudioContext::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSBaseAudioContextPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsBaseAudioContextConstructor, 0 } },
    { "destination"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsBaseAudioContext_destination, 0 } },
    { "currentTime"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsBaseAudioContext_currentTime, 0 } },
    { "sampleRate"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsBaseAudioContext_sampleRate, 0 } },
    { "listener"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsBaseAudioContext_listener, 0 } },
    { "audioWorklet"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsBaseAudioContext_audioWorklet, 0 } },
    { "state"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsBaseAudioContext_state, 0 } },
    { "onstatechange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsBaseAudioContext_onstatechange, setJSBaseAudioContext_onstatechange } },
    { "createBuffer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createBuffer, 3 } },
    { "decodeAudioData"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_decodeAudioData, 1 } },
    { "createBufferSource"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createBufferSource, 0 } },
    { "createGain"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createGain, 0 } },
    { "createDelay"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createDelay, 0 } },
    { "createBiquadFilter"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createBiquadFilter, 0 } },
    { "createWaveShaper"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createWaveShaper, 0 } },
    { "createPanner"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createPanner, 0 } },
    { "createConvolver"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createConvolver, 0 } },
    { "createDynamicsCompressor"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createDynamicsCompressor, 0 } },
    { "createAnalyser"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createAnalyser, 0 } },
    { "createScriptProcessor"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createScriptProcessor, 0 } },
    { "createOscillator"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createOscillator, 0 } },
    { "createPeriodicWave"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createPeriodicWave, 2 } },
    { "createConstantSource"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createConstantSource, 0 } },
    { "createStereoPanner"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createStereoPanner, 0 } },
    { "createIIRFilter"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createIIRFilter, 2 } },
    { "createChannelSplitter"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createChannelSplitter, 0 } },
    { "createChannelMerger"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBaseAudioContextPrototypeFunction_createChannelMerger, 0 } },
};

const ClassInfo JSBaseAudioContextPrototype::s_info = { "BaseAudioContext"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBaseAudioContextPrototype) };

void JSBaseAudioContextPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSBaseAudioContext::info(), JSBaseAudioContextPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "audioWorklet"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSBaseAudioContext::s_info = { "BaseAudioContext"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBaseAudioContext) };

JSBaseAudioContext::JSBaseAudioContext(Structure* structure, JSDOMGlobalObject& globalObject, Ref<BaseAudioContext>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

Ref<BaseAudioContext> JSBaseAudioContext::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, BaseAudioContext>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSBaseAudioContext::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSBaseAudioContextPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSBaseAudioContextPrototype::create(vm, &globalObject, structure);
}

JSObject* JSBaseAudioContext::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSBaseAudioContext>(vm, globalObject);
}

JSValue JSBaseAudioContext::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSBaseAudioContextDOMConstructor, DOMConstructorID::BaseAudioContext>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsBaseAudioContextConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSBaseAudioContextPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSBaseAudioContext::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsBaseAudioContext_destinationGetter(JSGlobalObject& lexicalGlobalObject, JSBaseAudioContext& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<AudioDestinationNode>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.destination())));
}

JSC_DEFINE_CUSTOM_GETTER(jsBaseAudioContext_destination, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSBaseAudioContext>::get<jsBaseAudioContext_destinationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsBaseAudioContext_currentTimeGetter(JSGlobalObject& lexicalGlobalObject, JSBaseAudioContext& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.currentTime())));
}

JSC_DEFINE_CUSTOM_GETTER(jsBaseAudioContext_currentTime, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSBaseAudioContext>::get<jsBaseAudioContext_currentTimeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsBaseAudioContext_sampleRateGetter(JSGlobalObject& lexicalGlobalObject, JSBaseAudioContext& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFloat>(lexicalGlobalObject, throwScope, impl.sampleRate())));
}

JSC_DEFINE_CUSTOM_GETTER(jsBaseAudioContext_sampleRate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSBaseAudioContext>::get<jsBaseAudioContext_sampleRateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsBaseAudioContext_listenerGetter(JSGlobalObject& lexicalGlobalObject, JSBaseAudioContext& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<AudioListener>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.listener())));
}

JSC_DEFINE_CUSTOM_GETTER(jsBaseAudioContext_listener, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSBaseAudioContext>::get<jsBaseAudioContext_listenerGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsBaseAudioContext_audioWorkletGetter(JSGlobalObject& lexicalGlobalObject, JSBaseAudioContext& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<AudioWorklet>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.audioWorklet())));
}

JSC_DEFINE_CUSTOM_GETTER(jsBaseAudioContext_audioWorklet, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSBaseAudioContext>::get<jsBaseAudioContext_audioWorkletGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsBaseAudioContext_stateGetter(JSGlobalObject& lexicalGlobalObject, JSBaseAudioContext& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<AudioContextState>>(lexicalGlobalObject, throwScope, impl.state())));
}

JSC_DEFINE_CUSTOM_GETTER(jsBaseAudioContext_state, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSBaseAudioContext>::get<jsBaseAudioContext_stateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsBaseAudioContext_onstatechangeGetter(JSGlobalObject& lexicalGlobalObject, JSBaseAudioContext& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().statechangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsBaseAudioContext_onstatechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSBaseAudioContext>::get<jsBaseAudioContext_onstatechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSBaseAudioContext_onstatechangeSetter(JSGlobalObject& lexicalGlobalObject, JSBaseAudioContext& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().statechangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSBaseAudioContext_onstatechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSBaseAudioContext>::set<setJSBaseAudioContext_onstatechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto numberOfChannels = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto numberOfFrames = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto sampleRate = convert<IDLFloat>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<AudioBuffer>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createBuffer(WTFMove(numberOfChannels), WTFMove(numberOfFrames), WTFMove(sampleRate)))));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createBuffer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createBufferBody>(*lexicalGlobalObject, *callFrame, "createBuffer");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_decodeAudioDataBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSBaseAudioContext>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto audioData = convert<IDLArrayBuffer>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "audioData", "BaseAudioContext", "decodeAudioData", "ArrayBuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto successCallback = convert<IDLNullable<IDLCallbackFunction<JSAudioBufferCallback>>>(*lexicalGlobalObject, argument1.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 1, "successCallback", "BaseAudioContext", "decodeAudioData"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto errorCallback = convert<IDLNullable<IDLCallbackFunction<JSAudioBufferCallback>>>(*lexicalGlobalObject, argument2.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 2, "errorCallback", "BaseAudioContext", "decodeAudioData"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLInterface<AudioBuffer>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.decodeAudioData(*audioData, WTFMove(successCallback), WTFMove(errorCallback), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_decodeAudioData, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_decodeAudioDataBody>(*lexicalGlobalObject, *callFrame, "decodeAudioData");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createBufferSourceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<AudioBufferSourceNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createBufferSource())));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createBufferSource, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createBufferSourceBody>(*lexicalGlobalObject, *callFrame, "createBufferSource");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createGainBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<GainNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createGain())));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createGain, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createGainBody>(*lexicalGlobalObject, *callFrame, "createGain");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createDelayBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto maxDelayTime = argument0.value().isUndefined() ? 1 : convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<DelayNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createDelay(WTFMove(maxDelayTime)))));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createDelay, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createDelayBody>(*lexicalGlobalObject, *callFrame, "createDelay");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createBiquadFilterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<BiquadFilterNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createBiquadFilter())));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createBiquadFilter, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createBiquadFilterBody>(*lexicalGlobalObject, *callFrame, "createBiquadFilter");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createWaveShaperBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<WaveShaperNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createWaveShaper())));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createWaveShaper, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createWaveShaperBody>(*lexicalGlobalObject, *callFrame, "createWaveShaper");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createPannerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<PannerNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createPanner())));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createPanner, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createPannerBody>(*lexicalGlobalObject, *callFrame, "createPanner");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createConvolverBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<ConvolverNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createConvolver())));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createConvolver, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createConvolverBody>(*lexicalGlobalObject, *callFrame, "createConvolver");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createDynamicsCompressorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<DynamicsCompressorNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createDynamicsCompressor())));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createDynamicsCompressor, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createDynamicsCompressorBody>(*lexicalGlobalObject, *callFrame, "createDynamicsCompressor");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createAnalyserBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<AnalyserNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createAnalyser())));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createAnalyser, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createAnalyserBody>(*lexicalGlobalObject, *callFrame, "createAnalyser");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createScriptProcessorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto bufferSize = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto numberOfInputChannels = argument1.value().isUndefined() ? 2 : convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto numberOfOutputChannels = argument2.value().isUndefined() ? 2 : convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<ScriptProcessorNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createScriptProcessor(WTFMove(bufferSize), WTFMove(numberOfInputChannels), WTFMove(numberOfOutputChannels)))));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createScriptProcessor, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createScriptProcessorBody>(*lexicalGlobalObject, *callFrame, "createScriptProcessor");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createOscillatorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<OscillatorNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createOscillator())));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createOscillator, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createOscillatorBody>(*lexicalGlobalObject, *callFrame, "createOscillator");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createPeriodicWaveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto real = convert<IDLSequence<IDLFloat>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto imag = convert<IDLSequence<IDLFloat>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto options = convert<IDLDictionary<PeriodicWaveOptions>>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<PeriodicWave>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createPeriodicWave(WTFMove(real), WTFMove(imag), WTFMove(options)))));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createPeriodicWave, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createPeriodicWaveBody>(*lexicalGlobalObject, *callFrame, "createPeriodicWave");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createConstantSourceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<ConstantSourceNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createConstantSource())));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createConstantSource, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createConstantSourceBody>(*lexicalGlobalObject, *callFrame, "createConstantSource");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createStereoPannerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<StereoPannerNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createStereoPanner())));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createStereoPanner, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createStereoPannerBody>(*lexicalGlobalObject, *callFrame, "createStereoPanner");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createIIRFilterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto feedforward = convert<IDLSequence<IDLDouble>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto feedback = convert<IDLSequence<IDLDouble>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<IIRFilterNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createIIRFilter(*context, WTFMove(feedforward), WTFMove(feedback)))));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createIIRFilter, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createIIRFilterBody>(*lexicalGlobalObject, *callFrame, "createIIRFilter");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createChannelSplitterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto numberOfOutputs = argument0.value().isUndefined() ? 6 : convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<ChannelSplitterNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createChannelSplitter(WTFMove(numberOfOutputs)))));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createChannelSplitter, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createChannelSplitterBody>(*lexicalGlobalObject, *callFrame, "createChannelSplitter");
}

static inline JSC::EncodedJSValue jsBaseAudioContextPrototypeFunction_createChannelMergerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBaseAudioContext>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto numberOfInputs = argument0.value().isUndefined() ? 6 : convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<ChannelMergerNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createChannelMerger(WTFMove(numberOfInputs)))));
}

JSC_DEFINE_HOST_FUNCTION(jsBaseAudioContextPrototypeFunction_createChannelMerger, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSBaseAudioContext>::call<jsBaseAudioContextPrototypeFunction_createChannelMergerBody>(*lexicalGlobalObject, *callFrame, "createChannelMerger");
}

JSC::GCClient::IsoSubspace* JSBaseAudioContext::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSBaseAudioContext, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForBaseAudioContext.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForBaseAudioContext = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForBaseAudioContext.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForBaseAudioContext = std::forward<decltype(space)>(space); }
    );
}

void JSBaseAudioContext::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSBaseAudioContext*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSBaseAudioContextOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsBaseAudioContext = jsCast<JSBaseAudioContext*>(handle.slot()->asCell());
    auto& wrapped = jsBaseAudioContext->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSBaseAudioContextOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsBaseAudioContext = static_cast<JSBaseAudioContext*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsBaseAudioContext->wrapped(), jsBaseAudioContext);
}

BaseAudioContext* JSBaseAudioContext::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSBaseAudioContext*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_AUDIO)
