/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioBufferSourceNode.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSAudioBuffer.h"
#include "JSAudioBufferSourceOptions.h"
#include "JSAudioParam.h"
#include "JSBaseAudioContext.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsAudioBufferSourceNodePrototypeFunction_start);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsAudioBufferSourceNodeConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioBufferSourceNode_buffer);
static JSC_DECLARE_CUSTOM_SETTER(setJSAudioBufferSourceNode_buffer);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioBufferSourceNode_playbackRate);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioBufferSourceNode_detune);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioBufferSourceNode_loop);
static JSC_DECLARE_CUSTOM_SETTER(setJSAudioBufferSourceNode_loop);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioBufferSourceNode_loopStart);
static JSC_DECLARE_CUSTOM_SETTER(setJSAudioBufferSourceNode_loopStart);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioBufferSourceNode_loopEnd);
static JSC_DECLARE_CUSTOM_SETTER(setJSAudioBufferSourceNode_loopEnd);

class JSAudioBufferSourceNodePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSAudioBufferSourceNodePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAudioBufferSourceNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSAudioBufferSourceNodePrototype>(vm)) JSAudioBufferSourceNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAudioBufferSourceNodePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAudioBufferSourceNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAudioBufferSourceNodePrototype, JSAudioBufferSourceNodePrototype::Base);

using JSAudioBufferSourceNodeDOMConstructor = JSDOMConstructor<JSAudioBufferSourceNode>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSAudioBufferSourceNodeDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSAudioBufferSourceNodeDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext())->settingsValues().webAudioEnabled) {
        throwTypeError(lexicalGlobalObject, throwScope, "Illegal constructor"_s);
        return JSValue::encode(jsNull());
    }
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto context = convert<IDLInterface<BaseAudioContext>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "context", "AudioBufferSourceNode", nullptr, "BaseAudioContext"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto options = convert<IDLDictionary<AudioBufferSourceOptions>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = AudioBufferSourceNode::create(*context, WTFMove(options));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<AudioBufferSourceNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<AudioBufferSourceNode>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSAudioBufferSourceNodeDOMConstructorConstruct, JSAudioBufferSourceNodeDOMConstructor::construct);

template<> const ClassInfo JSAudioBufferSourceNodeDOMConstructor::s_info = { "AudioBufferSourceNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioBufferSourceNodeDOMConstructor) };

template<> JSValue JSAudioBufferSourceNodeDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAudioScheduledSourceNode::getConstructor(vm, &globalObject);
}

template<> void JSAudioBufferSourceNodeDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "AudioBufferSourceNode"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSAudioBufferSourceNode::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSAudioBufferSourceNodePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioBufferSourceNodeConstructor, 0 } },
    { "buffer"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioBufferSourceNode_buffer, setJSAudioBufferSourceNode_buffer } },
    { "playbackRate"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioBufferSourceNode_playbackRate, 0 } },
    { "detune"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioBufferSourceNode_detune, 0 } },
    { "loop"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioBufferSourceNode_loop, setJSAudioBufferSourceNode_loop } },
    { "loopStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioBufferSourceNode_loopStart, setJSAudioBufferSourceNode_loopStart } },
    { "loopEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioBufferSourceNode_loopEnd, setJSAudioBufferSourceNode_loopEnd } },
    { "start"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsAudioBufferSourceNodePrototypeFunction_start, 0 } },
};

const ClassInfo JSAudioBufferSourceNodePrototype::s_info = { "AudioBufferSourceNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioBufferSourceNodePrototype) };

void JSAudioBufferSourceNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAudioBufferSourceNode::info(), JSAudioBufferSourceNodePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSAudioBufferSourceNode::s_info = { "AudioBufferSourceNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioBufferSourceNode) };

JSAudioBufferSourceNode::JSAudioBufferSourceNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AudioBufferSourceNode>&& impl)
    : JSAudioScheduledSourceNode(structure, globalObject, WTFMove(impl))
{
}

Ref<AudioBufferSourceNode> JSAudioBufferSourceNode::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, AudioBufferSourceNode>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSAudioBufferSourceNode::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSAudioBufferSourceNodePrototype::createStructure(vm, &globalObject, JSAudioScheduledSourceNode::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSAudioBufferSourceNodePrototype::create(vm, &globalObject, structure);
}

JSObject* JSAudioBufferSourceNode::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSAudioBufferSourceNode>(vm, globalObject);
}

JSValue JSAudioBufferSourceNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAudioBufferSourceNodeDOMConstructor, DOMConstructorID::AudioBufferSourceNode>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioBufferSourceNodeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAudioBufferSourceNodePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSAudioBufferSourceNode::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsAudioBufferSourceNode_bufferGetter(JSGlobalObject& lexicalGlobalObject, JSAudioBufferSourceNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<AudioBuffer>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.bufferForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioBufferSourceNode_buffer, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioBufferSourceNode>::get<jsAudioBufferSourceNode_bufferGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSAudioBufferSourceNode_bufferSetter(JSGlobalObject& lexicalGlobalObject, JSAudioBufferSourceNode& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLInterface<AudioBuffer>>>(lexicalGlobalObject, value, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwAttributeTypeError(lexicalGlobalObject, scope, "AudioBufferSourceNode", "buffer", "AudioBuffer"); });
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBufferForBindings(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSAudioBufferSourceNode_buffer, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioBufferSourceNode>::set<setJSAudioBufferSourceNode_bufferSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsAudioBufferSourceNode_playbackRateGetter(JSGlobalObject& lexicalGlobalObject, JSAudioBufferSourceNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<AudioParam>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.playbackRate())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioBufferSourceNode_playbackRate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioBufferSourceNode>::get<jsAudioBufferSourceNode_playbackRateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsAudioBufferSourceNode_detuneGetter(JSGlobalObject& lexicalGlobalObject, JSAudioBufferSourceNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<AudioParam>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.detune())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioBufferSourceNode_detune, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioBufferSourceNode>::get<jsAudioBufferSourceNode_detuneGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsAudioBufferSourceNode_loopGetter(JSGlobalObject& lexicalGlobalObject, JSAudioBufferSourceNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.loopForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioBufferSourceNode_loop, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioBufferSourceNode>::get<jsAudioBufferSourceNode_loopGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSAudioBufferSourceNode_loopSetter(JSGlobalObject& lexicalGlobalObject, JSAudioBufferSourceNode& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setLoopForBindings(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSAudioBufferSourceNode_loop, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioBufferSourceNode>::set<setJSAudioBufferSourceNode_loopSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsAudioBufferSourceNode_loopStartGetter(JSGlobalObject& lexicalGlobalObject, JSAudioBufferSourceNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.loopStartForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioBufferSourceNode_loopStart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioBufferSourceNode>::get<jsAudioBufferSourceNode_loopStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSAudioBufferSourceNode_loopStartSetter(JSGlobalObject& lexicalGlobalObject, JSAudioBufferSourceNode& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setLoopStartForBindings(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSAudioBufferSourceNode_loopStart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioBufferSourceNode>::set<setJSAudioBufferSourceNode_loopStartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsAudioBufferSourceNode_loopEndGetter(JSGlobalObject& lexicalGlobalObject, JSAudioBufferSourceNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.loopEndForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioBufferSourceNode_loopEnd, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioBufferSourceNode>::get<jsAudioBufferSourceNode_loopEndGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSAudioBufferSourceNode_loopEndSetter(JSGlobalObject& lexicalGlobalObject, JSAudioBufferSourceNode& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setLoopEndForBindings(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSAudioBufferSourceNode_loopEnd, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioBufferSourceNode>::set<setJSAudioBufferSourceNode_loopEndSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsAudioBufferSourceNodePrototypeFunction_startBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioBufferSourceNode>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto when = argument0.value().isUndefined() ? 0 : convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto grainOffset = argument1.value().isUndefined() ? 0 : convert<IDLDouble>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto grainDuration = argument2.value().isUndefined() ? std::optional<Converter<IDLDouble>::ReturnType>() : std::optional<Converter<IDLDouble>::ReturnType>(convert<IDLDouble>(*lexicalGlobalObject, argument2.value()));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.startLater(WTFMove(when), WTFMove(grainOffset), WTFMove(grainDuration)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsAudioBufferSourceNodePrototypeFunction_start, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSAudioBufferSourceNode>::call<jsAudioBufferSourceNodePrototypeFunction_startBody>(*lexicalGlobalObject, *callFrame, "start");
}

JSC::GCClient::IsoSubspace* JSAudioBufferSourceNode::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSAudioBufferSourceNode, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForAudioBufferSourceNode.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForAudioBufferSourceNode = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForAudioBufferSourceNode.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForAudioBufferSourceNode = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSAudioBufferSourceNode::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSAudioBufferSourceNode*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSAudioBufferSourceNode);

template<typename Visitor>
void JSAudioBufferSourceNode::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSAudioBufferSourceNode*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSAudioBufferSourceNode::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSAudioBufferSourceNode::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSAudioBufferSourceNode::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSAudioBufferSourceNode*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSAudioBufferSourceNodeOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsAudioBufferSourceNode = jsCast<JSAudioBufferSourceNode*>(handle.slot()->asCell());
    auto& wrapped = jsAudioBufferSourceNode->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSAudioBufferSourceNodeOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsAudioBufferSourceNode = static_cast<JSAudioBufferSourceNode*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsAudioBufferSourceNode->wrapped(), jsAudioBufferSourceNode);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7AudioBufferSourceNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21AudioBufferSourceNodeE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<AudioBufferSourceNode>&& impl)
{

    if constexpr (std::is_polymorphic_v<AudioBufferSourceNode>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7AudioBufferSourceNode@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore21AudioBufferSourceNodeE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // AudioBufferSourceNode has subclasses. If AudioBufferSourceNode has subclasses that get passed
        // to toJS() we currently require AudioBufferSourceNode you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<AudioBufferSourceNode>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, AudioBufferSourceNode& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
