/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSAesGcmParams.h"

#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include <JavaScriptCore/JSCInlines.h>
#include <variant>


namespace WebCore {
using namespace JSC;

template<> CryptoAlgorithmAesGcmParams convertDictionary<CryptoAlgorithmAesGcmParams>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    CryptoAlgorithmAesGcmParams result;
    JSValue nameValue;
    if (isNullOrUndefined)
        nameValue = jsUndefined();
    else {
        nameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "name"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!nameValue.isUndefined()) {
        result.name = convert<IDLDOMString>(lexicalGlobalObject, nameValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "name", "AesGcmParams", "DOMString");
        return { };
    }
    JSValue additionalDataValue;
    if (isNullOrUndefined)
        additionalDataValue = jsUndefined();
    else {
        additionalDataValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "additionalData"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!additionalDataValue.isUndefined()) {
        result.additionalData = convert<IDLUnion<IDLArrayBufferView, IDLArrayBuffer>>(lexicalGlobalObject, additionalDataValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue ivValue;
    if (isNullOrUndefined)
        ivValue = jsUndefined();
    else {
        ivValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "iv"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!ivValue.isUndefined()) {
        result.iv = convert<IDLUnion<IDLArrayBufferView, IDLArrayBuffer>>(lexicalGlobalObject, ivValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "iv", "AesGcmParams", "(ArrayBufferView or ArrayBuffer)");
        return { };
    }
    JSValue tagLengthValue;
    if (isNullOrUndefined)
        tagLengthValue = jsUndefined();
    else {
        tagLengthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "tagLength"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!tagLengthValue.isUndefined()) {
        result.tagLength = convert<IDLEnforceRangeAdaptor<IDLOctet>>(lexicalGlobalObject, tagLengthValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

} // namespace WebCore
