/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_CODECS)

#include "JSAacEncoderConfig.h"

#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_CODECS)

template<> AacEncoderConfig convertDictionary<AacEncoderConfig>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    AacEncoderConfig result;
    JSValue formatValue;
    if (isNullOrUndefined)
        formatValue = jsUndefined();
    else {
        formatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "format"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!formatValue.isUndefined()) {
        result.format = convert<IDLEnumeration<AacEncoderConfig::BitstreamFormat>>(lexicalGlobalObject, formatValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.format = AacEncoderConfig::BitstreamFormat::Aac;
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const AacEncoderConfig& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto formatValue = toJS<IDLEnumeration<AacEncoderConfig::BitstreamFormat>>(lexicalGlobalObject, throwScope, dictionary.format);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "format"_s), formatValue);
    return result;
}

#endif

#if ENABLE(WEB_CODECS)

String convertEnumerationToString(AacEncoderConfig::BitstreamFormat enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("aac"),
        MAKE_STATIC_STRING_IMPL("adts"),
    };
    static_assert(static_cast<size_t>(AacEncoderConfig::BitstreamFormat::Aac) == 0, "AacEncoderConfig::BitstreamFormat::Aac is not 0 as expected");
    static_assert(static_cast<size_t>(AacEncoderConfig::BitstreamFormat::Adts) == 1, "AacEncoderConfig::BitstreamFormat::Adts is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, AacEncoderConfig::BitstreamFormat enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<AacEncoderConfig::BitstreamFormat> parseEnumerationFromString<AacEncoderConfig::BitstreamFormat>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, AacEncoderConfig::BitstreamFormat> mappings[] = {
        { "aac", AacEncoderConfig::BitstreamFormat::Aac },
        { "adts", AacEncoderConfig::BitstreamFormat::Adts },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<AacEncoderConfig::BitstreamFormat> parseEnumeration<AacEncoderConfig::BitstreamFormat>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<AacEncoderConfig::BitstreamFormat>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<AacEncoderConfig::BitstreamFormat>()
{
    return "\"aac\", \"adts\"";
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_CODECS)
