#include <wtf/FastMalloc.h>
#include <wtf/Noncopyable.h>

#pragma once

namespace WebCore {
using namespace JSC;

class DOMIsoSubspaces {
    WTF_MAKE_NONCOPYABLE(DOMIsoSubspaces);
    WTF_MAKE_FAST_ALLOCATED(DOMIsoSubspaces);
public:
    DOMIsoSubspaces() = default;
    std::unique_ptr<IsoSubspace> m_subspaceForInternalSettingsGenerated;
    std::unique_ptr<IsoSubspace> m_subspaceForBarcodeDetector;
    std::unique_ptr<IsoSubspace> m_subspaceForFaceDetector;
    std::unique_ptr<IsoSubspace> m_subspaceForTextDetector;
    std::unique_ptr<IsoSubspace> m_subspaceForGPU;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUAdapter;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUAdapterInfo;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUBindGroup;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUBindGroupLayout;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUBuffer;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUBufferUsage;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUColorWrite;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUCommandBuffer;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUCommandEncoder;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUCompilationInfo;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUCompilationMessage;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUComputePassEncoder;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUComputePipeline;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUDevice;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUDeviceLostInfo;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUExternalTexture;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUInternalError;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUMapMode;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUOutOfMemoryError;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUPipelineError;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUPipelineLayout;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUQuerySet;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUQueue;
    std::unique_ptr<IsoSubspace> m_subspaceForGPURenderBundle;
    std::unique_ptr<IsoSubspace> m_subspaceForGPURenderBundleEncoder;
    std::unique_ptr<IsoSubspace> m_subspaceForGPURenderPassEncoder;
    std::unique_ptr<IsoSubspace> m_subspaceForGPURenderPipeline;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUSampler;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUShaderModule;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUShaderStage;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUSupportedFeatures;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUSupportedLimits;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUTexture;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUTextureUsage;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUTextureView;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUUncapturedErrorEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUValidationError;
    std::unique_ptr<IsoSubspace> m_subspaceForWebKitPlaybackTargetAvailabilityEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForClipboard;
    std::unique_ptr<IsoSubspace> m_subspaceForClipboardItem;
    std::unique_ptr<IsoSubspace> m_subspaceForDOMAudioSession;
    std::unique_ptr<IsoSubspace> m_subspaceForDOMCache;
    std::unique_ptr<IsoSubspace> m_subspaceForDOMCacheStorage;
    std::unique_ptr<IsoSubspace> m_subspaceForCompressionStream;
    std::unique_ptr<IsoSubspace> m_subspaceForCompressionStreamEncoder;
    std::unique_ptr<IsoSubspace> m_subspaceForDecompressionStream;
    std::unique_ptr<IsoSubspace> m_subspaceForDecompressionStreamDecoder;
    std::unique_ptr<IsoSubspace> m_subspaceForContactsManager;
    std::unique_ptr<IsoSubspace> m_subspaceForCookieChangeEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForCookieStore;
    std::unique_ptr<IsoSubspace> m_subspaceForCookieStoreManager;
    std::unique_ptr<IsoSubspace> m_subspaceForExtendableCookieChangeEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForBasicCredential;
    std::unique_ptr<IsoSubspace> m_subspaceForCredentialsContainer;
    std::unique_ptr<IsoSubspace> m_subspaceForDigitalIdentity;
    std::unique_ptr<IsoSubspace> m_subspaceForMediaKeyMessageEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForMediaKeySession;
    std::unique_ptr<IsoSubspace> m_subspaceForMediaKeyStatusMap;
    std::unique_ptr<IsoSubspace> m_subspaceForMediaKeyStatusMapIterator;
    std::unique_ptr<IsoSubspace> m_subspaceForMediaKeySystemAccess;
    std::unique_ptr<IsoSubspace> m_subspaceForMediaKeys;
    std::unique_ptr<IsoSubspace> m_subspaceForWebKitMediaKeyMessageEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForWebKitMediaKeyNeededEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForWebKitMediaKeySession;
    std::unique_ptr<IsoSubspace> m_subspaceForWebKitMediaKeys;
    std::unique_ptr<IsoSubspace> m_subspaceForDOMFileSystem;
    std::unique_ptr<IsoSubspace> m_subspaceForFileSystemDirectoryEntry;
    std::unique_ptr<IsoSubspace> m_subspaceForFileSystemDirectoryReader;
    std::unique_ptr<IsoSubspace> m_subspaceForFileSystemEntry;
    std::unique_ptr<IsoSubspace> m_subspaceForFileSystemFileEntry;
    std::unique_ptr<IsoSubspace> m_subspaceForFetchHeaders;
    std::unique_ptr<IsoSubspace> m_subspaceForFetchHeadersIterator;
    std::unique_ptr<IsoSubspace> m_subspaceForFetchRequest;
    std::unique_ptr<IsoSubspace> m_subspaceForFetchResponse;
    std::unique_ptr<IsoSubspace> m_subspaceForFileSystemDirectoryHandle;
    std::unique_ptr<IsoSubspace> m_subspaceForFileSystemDirectoryHandleIterator;
    std::unique_ptr<IsoSubspace> m_subspaceForFileSystemFileHandle;
    std::unique_ptr<IsoSubspace> m_subspaceForFileSystemHandle;
    std::unique_ptr<IsoSubspace> m_subspaceForFileSystemSyncAccessHandle;
    std::unique_ptr<IsoSubspace> m_subspaceForGamepad;
    std::unique_ptr<IsoSubspace> m_subspaceForGamepadButton;
    std::unique_ptr<IsoSubspace> m_subspaceForGamepadEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForGamepadHapticActuator;
    std::unique_ptr<IsoSubspace> m_subspaceForGeolocation;
    std::unique_ptr<IsoSubspace> m_subspaceForGeolocationCoordinates;
    std::unique_ptr<IsoSubspace> m_subspaceForGeolocationPosition;
    std::unique_ptr<IsoSubspace> m_subspaceForGeolocationPositionError;
    std::unique_ptr<IsoSubspace> m_subspaceForHighlight;
    std::unique_ptr<IsoSubspace> m_subspaceForHighlightRegistry;
    std::unique_ptr<IsoSubspace> m_subspaceForIDBCursor;
    std::unique_ptr<IsoSubspace> m_subspaceForIDBCursorWithValue;
    std::unique_ptr<IsoSubspace> m_subspaceForIDBDatabase;
    std::unique_ptr<IsoSubspace> m_subspaceForIDBFactory;
    std::unique_ptr<IsoSubspace> m_subspaceForIDBIndex;
    std::unique_ptr<IsoSubspace> m_subspaceForIDBKeyRange;
    std::unique_ptr<IsoSubspace> m_subspaceForIDBObjectStore;
    std::unique_ptr<IsoSubspace> m_subspaceForIDBOpenDBRequest;
    std::unique_ptr<IsoSubspace> m_subspaceForIDBRequest;
    std::unique_ptr<IsoSubspace> m_subspaceForIDBTransaction;
    std::unique_ptr<IsoSubspace> m_subspaceForIDBVersionChangeEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForMediaCapabilities;
    std::unique_ptr<IsoSubspace> m_subspaceForMediaControlsHost;
    std::unique_ptr<IsoSubspace> m_subspaceForBlobEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForMediaRecorder;
    std::unique_ptr<IsoSubspace> m_subspaceForMediaRecorderErrorEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForMediaMetadata;
    std::unique_ptr<IsoSubspace> m_subspaceForMediaSession;
    std::unique_ptr<IsoSubspace> m_subspaceForMediaSessionCoordinator;
    std::unique_ptr<IsoSubspace> m_subspaceForBufferedChangeEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForManagedMediaSource;
    std::unique_ptr<IsoSubspace> m_subspaceForManagedSourceBuffer;
    std::unique_ptr<IsoSubspace> m_subspaceForMediaSource;
    std::unique_ptr<IsoSubspace> m_subspaceForSourceBuffer;
    std::unique_ptr<IsoSubspace> m_subspaceForSourceBufferList;
    std::unique_ptr<IsoSubspace> m_subspaceForVideoPlaybackQuality;
    std::unique_ptr<IsoSubspace> m_subspaceForCanvasCaptureMediaStreamTrack;
    std::unique_ptr<IsoSubspace> m_subspaceForImageCapture;
    std::unique_ptr<IsoSubspace> m_subspaceForInputDeviceInfo;
    std::unique_ptr<IsoSubspace> m_subspaceForMediaDeviceInfo;
    std::unique_ptr<IsoSubspace> m_subspaceForMediaDevices;
    std::unique_ptr<IsoSubspace> m_subspaceForMediaStream;
    std::unique_ptr<IsoSubspace> m_subspaceForMediaStreamTrack;
    std::unique_ptr<IsoSubspace> m_subspaceForMediaStreamTrackEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForMediaStreamTrackProcessor;
    std::unique_ptr<IsoSubspace> m_subspaceForOverconstrainedError;
    std::unique_ptr<IsoSubspace> m_subspaceForOverconstrainedErrorEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForRTCCertificate;
    std::unique_ptr<IsoSubspace> m_subspaceForRTCDTMFSender;
    std::unique_ptr<IsoSubspace> m_subspaceForRTCDTMFToneChangeEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForRTCDataChannel;
    std::unique_ptr<IsoSubspace> m_subspaceForRTCDataChannelEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForRTCDtlsTransport;
    std::unique_ptr<IsoSubspace> m_subspaceForRTCEncodedAudioFrame;
    std::unique_ptr<IsoSubspace> m_subspaceForRTCEncodedVideoFrame;
    std::unique_ptr<IsoSubspace> m_subspaceForRTCError;
    std::unique_ptr<IsoSubspace> m_subspaceForRTCErrorEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForRTCIceCandidate;
    std::unique_ptr<IsoSubspace> m_subspaceForRTCIceTransport;
    std::unique_ptr<IsoSubspace> m_subspaceForRTCPeerConnection;
    std::unique_ptr<IsoSubspace> m_subspaceForRTCPeerConnectionIceErrorEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForRTCPeerConnectionIceEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForRTCRtpReceiver;
    std::unique_ptr<IsoSubspace> m_subspaceForRTCRtpSFrameTransform;
    std::unique_ptr<IsoSubspace> m_subspaceForRTCRtpSFrameTransformErrorEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForRTCRtpScriptTransform;
    std::unique_ptr<IsoSubspace> m_subspaceForRTCRtpScriptTransformer;
    std::unique_ptr<IsoSubspace> m_subspaceForRTCRtpSender;
    std::unique_ptr<IsoSubspace> m_subspaceForRTCRtpTransceiver;
    std::unique_ptr<IsoSubspace> m_subspaceForRTCSctpTransport;
    std::unique_ptr<IsoSubspace> m_subspaceForRTCSessionDescription;
    std::unique_ptr<IsoSubspace> m_subspaceForRTCStatsReport;
    std::unique_ptr<IsoSubspace> m_subspaceForRTCTrackEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForRTCTransformEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForVideoTrackGenerator;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLModelElement;
    std::unique_ptr<IsoSubspace> m_subspaceForNotification;
    std::unique_ptr<IsoSubspace> m_subspaceForNotificationEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForMerchantValidationEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForPaymentAddress;
    std::unique_ptr<IsoSubspace> m_subspaceForPaymentMethodChangeEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForPaymentRequest;
    std::unique_ptr<IsoSubspace> m_subspaceForPaymentRequestUpdateEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForPaymentResponse;
    std::unique_ptr<IsoSubspace> m_subspaceForPermissionStatus;
    std::unique_ptr<IsoSubspace> m_subspaceForPermissions;
    std::unique_ptr<IsoSubspace> m_subspaceForPictureInPictureEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForPictureInPictureWindow;
    std::unique_ptr<IsoSubspace> m_subspaceForPushEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForPushManager;
    std::unique_ptr<IsoSubspace> m_subspaceForPushMessageData;
    std::unique_ptr<IsoSubspace> m_subspaceForPushNotificationEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForPushSubscription;
    std::unique_ptr<IsoSubspace> m_subspaceForPushSubscriptionChangeEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForPushSubscriptionOptions;
    std::unique_ptr<IsoSubspace> m_subspaceForRemotePlayback;
    std::unique_ptr<IsoSubspace> m_subspaceForDeprecationReportBody;
    std::unique_ptr<IsoSubspace> m_subspaceForReport;
    std::unique_ptr<IsoSubspace> m_subspaceForReportBody;
    std::unique_ptr<IsoSubspace> m_subspaceForReportingObserver;
    std::unique_ptr<IsoSubspace> m_subspaceForTestReportBody;
    std::unique_ptr<IsoSubspace> m_subspaceForWakeLock;
    std::unique_ptr<IsoSubspace> m_subspaceForWakeLockSentinel;
    std::unique_ptr<IsoSubspace> m_subspaceForSpeechRecognition;
    std::unique_ptr<IsoSubspace> m_subspaceForSpeechRecognitionAlternative;
    std::unique_ptr<IsoSubspace> m_subspaceForSpeechRecognitionErrorEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForSpeechRecognitionEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForSpeechRecognitionResult;
    std::unique_ptr<IsoSubspace> m_subspaceForSpeechRecognitionResultList;
    std::unique_ptr<IsoSubspace> m_subspaceForSpeechSynthesis;
    std::unique_ptr<IsoSubspace> m_subspaceForSpeechSynthesisErrorEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForSpeechSynthesisEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForSpeechSynthesisUtterance;
    std::unique_ptr<IsoSubspace> m_subspaceForSpeechSynthesisVoice;
    std::unique_ptr<IsoSubspace> m_subspaceForStorageManager;
    std::unique_ptr<IsoSubspace> m_subspaceForByteLengthQueuingStrategy;
    std::unique_ptr<IsoSubspace> m_subspaceForCountQueuingStrategy;
    std::unique_ptr<IsoSubspace> m_subspaceForReadableByteStreamController;
    std::unique_ptr<IsoSubspace> m_subspaceForReadableStream;
    std::unique_ptr<IsoSubspace> m_subspaceForReadableStreamBYOBReader;
    std::unique_ptr<IsoSubspace> m_subspaceForReadableStreamBYOBRequest;
    std::unique_ptr<IsoSubspace> m_subspaceForReadableStreamDefaultController;
    std::unique_ptr<IsoSubspace> m_subspaceForReadableStreamDefaultReader;
    std::unique_ptr<IsoSubspace> m_subspaceForReadableStreamSink;
    std::unique_ptr<IsoSubspace> m_subspaceForReadableStreamSource;
    std::unique_ptr<IsoSubspace> m_subspaceForTransformStream;
    std::unique_ptr<IsoSubspace> m_subspaceForTransformStreamDefaultController;
    std::unique_ptr<IsoSubspace> m_subspaceForWritableStream;
    std::unique_ptr<IsoSubspace> m_subspaceForWritableStreamDefaultController;
    std::unique_ptr<IsoSubspace> m_subspaceForWritableStreamDefaultWriter;
    std::unique_ptr<IsoSubspace> m_subspaceForWritableStreamSink;
    std::unique_ptr<IsoSubspace> m_subspaceForWebLock;
    std::unique_ptr<IsoSubspace> m_subspaceForWebLockManager;
    std::unique_ptr<IsoSubspace> m_subspaceForAnalyserNode;
    std::unique_ptr<IsoSubspace> m_subspaceForAudioBuffer;
    std::unique_ptr<IsoSubspace> m_subspaceForAudioBufferSourceNode;
    std::unique_ptr<IsoSubspace> m_subspaceForAudioContext;
    std::unique_ptr<IsoSubspace> m_subspaceForAudioDestinationNode;
    std::unique_ptr<IsoSubspace> m_subspaceForAudioListener;
    std::unique_ptr<IsoSubspace> m_subspaceForAudioNode;
    std::unique_ptr<IsoSubspace> m_subspaceForAudioParam;
    std::unique_ptr<IsoSubspace> m_subspaceForAudioParamMap;
    std::unique_ptr<IsoSubspace> m_subspaceForAudioProcessingEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForAudioScheduledSourceNode;
    std::unique_ptr<IsoSubspace> m_subspaceForAudioWorklet;
    std::unique_ptr<IsoSubspace> m_subspaceForAudioWorkletGlobalScope;
    std::unique_ptr<IsoSubspace> m_subspaceForAudioWorkletNode;
    std::unique_ptr<IsoSubspace> m_subspaceForAudioWorkletProcessor;
    std::unique_ptr<IsoSubspace> m_subspaceForBaseAudioContext;
    std::unique_ptr<IsoSubspace> m_subspaceForBiquadFilterNode;
    std::unique_ptr<IsoSubspace> m_subspaceForChannelMergerNode;
    std::unique_ptr<IsoSubspace> m_subspaceForChannelSplitterNode;
    std::unique_ptr<IsoSubspace> m_subspaceForConstantSourceNode;
    std::unique_ptr<IsoSubspace> m_subspaceForConvolverNode;
    std::unique_ptr<IsoSubspace> m_subspaceForDelayNode;
    std::unique_ptr<IsoSubspace> m_subspaceForDynamicsCompressorNode;
    std::unique_ptr<IsoSubspace> m_subspaceForGainNode;
    std::unique_ptr<IsoSubspace> m_subspaceForIIRFilterNode;
    std::unique_ptr<IsoSubspace> m_subspaceForMediaElementAudioSourceNode;
    std::unique_ptr<IsoSubspace> m_subspaceForMediaStreamAudioDestinationNode;
    std::unique_ptr<IsoSubspace> m_subspaceForMediaStreamAudioSourceNode;
    std::unique_ptr<IsoSubspace> m_subspaceForOfflineAudioCompletionEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForOfflineAudioContext;
    std::unique_ptr<IsoSubspace> m_subspaceForOscillatorNode;
    std::unique_ptr<IsoSubspace> m_subspaceForPannerNode;
    std::unique_ptr<IsoSubspace> m_subspaceForPeriodicWave;
    std::unique_ptr<IsoSubspace> m_subspaceForScriptProcessorNode;
    std::unique_ptr<IsoSubspace> m_subspaceForStereoPannerNode;
    std::unique_ptr<IsoSubspace> m_subspaceForWaveShaperNode;
    std::unique_ptr<IsoSubspace> m_subspaceForAuthenticatorAssertionResponse;
    std::unique_ptr<IsoSubspace> m_subspaceForAuthenticatorAttestationResponse;
    std::unique_ptr<IsoSubspace> m_subspaceForAuthenticatorResponse;
    std::unique_ptr<IsoSubspace> m_subspaceForPublicKeyCredential;
    std::unique_ptr<IsoSubspace> m_subspaceForVideoColorSpace;
    std::unique_ptr<IsoSubspace> m_subspaceForWebCodecsAudioData;
    std::unique_ptr<IsoSubspace> m_subspaceForWebCodecsAudioDecoder;
    std::unique_ptr<IsoSubspace> m_subspaceForWebCodecsAudioEncoder;
    std::unique_ptr<IsoSubspace> m_subspaceForWebCodecsEncodedAudioChunk;
    std::unique_ptr<IsoSubspace> m_subspaceForWebCodecsEncodedVideoChunk;
    std::unique_ptr<IsoSubspace> m_subspaceForWebCodecsVideoDecoder;
    std::unique_ptr<IsoSubspace> m_subspaceForWebCodecsVideoEncoder;
    std::unique_ptr<IsoSubspace> m_subspaceForWebCodecsVideoFrame;
    std::unique_ptr<IsoSubspace> m_subspaceForDatabase;
    std::unique_ptr<IsoSubspace> m_subspaceForSQLError;
    std::unique_ptr<IsoSubspace> m_subspaceForSQLResultSet;
    std::unique_ptr<IsoSubspace> m_subspaceForSQLResultSetRowList;
    std::unique_ptr<IsoSubspace> m_subspaceForSQLTransaction;
    std::unique_ptr<IsoSubspace> m_subspaceForCloseEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForWebSocket;
    std::unique_ptr<IsoSubspace> m_subspaceForWebTransport;
    std::unique_ptr<IsoSubspace> m_subspaceForWebTransportBidirectionalStream;
    std::unique_ptr<IsoSubspace> m_subspaceForWebTransportDatagramDuplexStream;
    std::unique_ptr<IsoSubspace> m_subspaceForWebTransportError;
    std::unique_ptr<IsoSubspace> m_subspaceForWebTransportReceiveStream;
    std::unique_ptr<IsoSubspace> m_subspaceForWebTransportSendStream;
    std::unique_ptr<IsoSubspace> m_subspaceForWebXRBoundedReferenceSpace;
    std::unique_ptr<IsoSubspace> m_subspaceForWebXRFrame;
    std::unique_ptr<IsoSubspace> m_subspaceForWebXRHand;
    std::unique_ptr<IsoSubspace> m_subspaceForWebXRHandIterator;
    std::unique_ptr<IsoSubspace> m_subspaceForWebXRInputSource;
    std::unique_ptr<IsoSubspace> m_subspaceForWebXRInputSourceArray;
    std::unique_ptr<IsoSubspace> m_subspaceForWebXRInputSourceArrayIterator;
    std::unique_ptr<IsoSubspace> m_subspaceForWebXRJointPose;
    std::unique_ptr<IsoSubspace> m_subspaceForWebXRJointSpace;
    std::unique_ptr<IsoSubspace> m_subspaceForWebXRLayer;
    std::unique_ptr<IsoSubspace> m_subspaceForWebXRPose;
    std::unique_ptr<IsoSubspace> m_subspaceForWebXRReferenceSpace;
    std::unique_ptr<IsoSubspace> m_subspaceForWebXRRenderState;
    std::unique_ptr<IsoSubspace> m_subspaceForWebXRRigidTransform;
    std::unique_ptr<IsoSubspace> m_subspaceForWebXRSession;
    std::unique_ptr<IsoSubspace> m_subspaceForWebXRSpace;
    std::unique_ptr<IsoSubspace> m_subspaceForWebXRSystem;
    std::unique_ptr<IsoSubspace> m_subspaceForWebXRView;
    std::unique_ptr<IsoSubspace> m_subspaceForWebXRViewerPose;
    std::unique_ptr<IsoSubspace> m_subspaceForWebXRViewport;
    std::unique_ptr<IsoSubspace> m_subspaceForWebXRWebGLLayer;
    std::unique_ptr<IsoSubspace> m_subspaceForXRInputSourceEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForXRInputSourcesChangeEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForXRReferenceSpaceEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForXRSessionEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForAnimationEffect;
    std::unique_ptr<IsoSubspace> m_subspaceForAnimationPlaybackEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForAnimationTimeline;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSAnimation;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSAnimationEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSTransition;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSTransitionEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForCustomEffect;
    std::unique_ptr<IsoSubspace> m_subspaceForDocumentTimeline;
    std::unique_ptr<IsoSubspace> m_subspaceForKeyframeEffect;
    std::unique_ptr<IsoSubspace> m_subspaceForScrollTimeline;
    std::unique_ptr<IsoSubspace> m_subspaceForViewTimeline;
    std::unique_ptr<IsoSubspace> m_subspaceForWebAnimation;
    std::unique_ptr<IsoSubspace> m_subspaceForCryptoKey;
    std::unique_ptr<IsoSubspace> m_subspaceForSubtleCrypto;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSConditionRule;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSContainerRule;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSCounterStyleRule;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSFontFaceRule;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSFontFeatureValuesRule;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSFontPaletteValuesRule;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSGroupingRule;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSImportRule;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSKeyframeRule;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSKeyframesRule;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSLayerBlockRule;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSLayerStatementRule;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSMediaRule;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSNamespaceRule;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSPageRule;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSPaintSize;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSPropertyRule;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSRule;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSRuleList;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSScopeRule;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSStartingStyleRule;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSStyleDeclaration;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSStyleRule;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSStyleSheet;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSSupportsRule;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSUnknownRule;
    std::unique_ptr<IsoSubspace> m_subspaceForDOMCSSNamespace;
    std::unique_ptr<IsoSubspace> m_subspaceForDOMMatrix;
    std::unique_ptr<IsoSubspace> m_subspaceForDOMMatrixReadOnly;
    std::unique_ptr<IsoSubspace> m_subspaceForDeprecatedCSSOMCounter;
    std::unique_ptr<IsoSubspace> m_subspaceForDeprecatedCSSOMPrimitiveValue;
    std::unique_ptr<IsoSubspace> m_subspaceForDeprecatedCSSOMRGBColor;
    std::unique_ptr<IsoSubspace> m_subspaceForDeprecatedCSSOMRect;
    std::unique_ptr<IsoSubspace> m_subspaceForDeprecatedCSSOMValue;
    std::unique_ptr<IsoSubspace> m_subspaceForDeprecatedCSSOMValueList;
    std::unique_ptr<IsoSubspace> m_subspaceForFontFace;
    std::unique_ptr<IsoSubspace> m_subspaceForFontFaceSet;
    std::unique_ptr<IsoSubspace> m_subspaceForFontFaceSetIterator;
    std::unique_ptr<IsoSubspace> m_subspaceForMediaList;
    std::unique_ptr<IsoSubspace> m_subspaceForMediaQueryList;
    std::unique_ptr<IsoSubspace> m_subspaceForMediaQueryListEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForStyleMedia;
    std::unique_ptr<IsoSubspace> m_subspaceForStyleSheet;
    std::unique_ptr<IsoSubspace> m_subspaceForStyleSheetList;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSKeywordValue;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSNumericValue;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSOMVariableReferenceValue;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSStyleImageValue;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSStyleValue;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSUnitValue;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSUnparsedValue;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSUnparsedValueIterator;
    std::unique_ptr<IsoSubspace> m_subspaceForStylePropertyMap;
    std::unique_ptr<IsoSubspace> m_subspaceForStylePropertyMapReadOnly;
    std::unique_ptr<IsoSubspace> m_subspaceForStylePropertyMapReadOnlyIterator;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSColor;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSColorValue;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSHSL;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSHWB;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSLCH;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSLab;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSOKLCH;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSOKLab;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSRGB;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSMathClamp;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSMathInvert;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSMathMax;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSMathMin;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSMathNegate;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSMathProduct;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSMathSum;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSMathValue;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSNumericArray;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSNumericArrayIterator;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSMatrixComponent;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSPerspective;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSRotate;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSScale;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSSkew;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSSkewX;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSSkewY;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSTransformComponent;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSTransformValue;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSTransformValueIterator;
    std::unique_ptr<IsoSubspace> m_subspaceForCSSTranslate;
    std::unique_ptr<IsoSubspace> m_subspaceForAbortController;
    std::unique_ptr<IsoSubspace> m_subspaceForAbortSignal;
    std::unique_ptr<IsoSubspace> m_subspaceForAbstractRange;
    std::unique_ptr<IsoSubspace> m_subspaceForAttr;
    std::unique_ptr<IsoSubspace> m_subspaceForBeforeUnloadEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForBroadcastChannel;
    std::unique_ptr<IsoSubspace> m_subspaceForCDATASection;
    std::unique_ptr<IsoSubspace> m_subspaceForCharacterData;
    std::unique_ptr<IsoSubspace> m_subspaceForClipboardEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForComment;
    std::unique_ptr<IsoSubspace> m_subspaceForCompositionEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForContentVisibilityAutoStateChangeEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForCustomElementRegistry;
    std::unique_ptr<IsoSubspace> m_subspaceForCustomEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForCustomStateSet;
    std::unique_ptr<IsoSubspace> m_subspaceForDOMException;
    std::unique_ptr<IsoSubspace> m_subspaceForDOMImplementation;
    std::unique_ptr<IsoSubspace> m_subspaceForDOMPoint;
    std::unique_ptr<IsoSubspace> m_subspaceForDOMPointReadOnly;
    std::unique_ptr<IsoSubspace> m_subspaceForDOMQuad;
    std::unique_ptr<IsoSubspace> m_subspaceForDOMRect;
    std::unique_ptr<IsoSubspace> m_subspaceForDOMRectList;
    std::unique_ptr<IsoSubspace> m_subspaceForDOMRectReadOnly;
    std::unique_ptr<IsoSubspace> m_subspaceForDOMStringList;
    std::unique_ptr<IsoSubspace> m_subspaceForDOMStringMap;
    std::unique_ptr<IsoSubspace> m_subspaceForDataTransfer;
    std::unique_ptr<IsoSubspace> m_subspaceForDataTransferItem;
    std::unique_ptr<IsoSubspace> m_subspaceForDataTransferItemList;
    std::unique_ptr<IsoSubspace> m_subspaceForDeviceMotionEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForDeviceOrientationEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForDocument;
    std::unique_ptr<IsoSubspace> m_subspaceForDocumentFragment;
    std::unique_ptr<IsoSubspace> m_subspaceForDocumentType;
    std::unique_ptr<IsoSubspace> m_subspaceForDragEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForElement;
    std::unique_ptr<IsoSubspace> m_subspaceForElementInternals;
    std::unique_ptr<IsoSubspace> m_subspaceForErrorEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForEventTarget;
    std::unique_ptr<IsoSubspace> m_subspaceForFocusEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForFormDataEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForHashChangeEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForIdleDeadline;
    std::unique_ptr<IsoSubspace> m_subspaceForInputEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForInvokeEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForKeyboardEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForMessageChannel;
    std::unique_ptr<IsoSubspace> m_subspaceForMessageEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForMessagePort;
    std::unique_ptr<IsoSubspace> m_subspaceForMouseEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForMutationEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForMutationObserver;
    std::unique_ptr<IsoSubspace> m_subspaceForMutationRecord;
    std::unique_ptr<IsoSubspace> m_subspaceForNamedNodeMap;
    std::unique_ptr<IsoSubspace> m_subspaceForNode;
    std::unique_ptr<IsoSubspace> m_subspaceForNodeIterator;
    std::unique_ptr<IsoSubspace> m_subspaceForNodeList;
    std::unique_ptr<IsoSubspace> m_subspaceForNodeListIterator;
    std::unique_ptr<IsoSubspace> m_subspaceForOverflowEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForPageTransitionEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForPointerEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForPopStateEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForProcessingInstruction;
    std::unique_ptr<IsoSubspace> m_subspaceForProgressEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForPromiseRejectionEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForRange;
    std::unique_ptr<IsoSubspace> m_subspaceForSecurityPolicyViolationEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForShadowRoot;
    std::unique_ptr<IsoSubspace> m_subspaceForStaticRange;
    std::unique_ptr<IsoSubspace> m_subspaceForText;
    std::unique_ptr<IsoSubspace> m_subspaceForTextDecoder;
    std::unique_ptr<IsoSubspace> m_subspaceForTextDecoderStream;
    std::unique_ptr<IsoSubspace> m_subspaceForTextDecoderStreamDecoder;
    std::unique_ptr<IsoSubspace> m_subspaceForTextEncoder;
    std::unique_ptr<IsoSubspace> m_subspaceForTextEncoderStream;
    std::unique_ptr<IsoSubspace> m_subspaceForTextEncoderStreamEncoder;
    std::unique_ptr<IsoSubspace> m_subspaceForTextEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForToggleEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForTouch;
    std::unique_ptr<IsoSubspace> m_subspaceForTouchEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForTouchList;
    std::unique_ptr<IsoSubspace> m_subspaceForTreeWalker;
    std::unique_ptr<IsoSubspace> m_subspaceForTrustedHTML;
    std::unique_ptr<IsoSubspace> m_subspaceForTrustedScript;
    std::unique_ptr<IsoSubspace> m_subspaceForTrustedScriptURL;
    std::unique_ptr<IsoSubspace> m_subspaceForTrustedTypePolicy;
    std::unique_ptr<IsoSubspace> m_subspaceForTrustedTypePolicyFactory;
    std::unique_ptr<IsoSubspace> m_subspaceForUIEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForViewTransition;
    std::unique_ptr<IsoSubspace> m_subspaceForWheelEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForXMLDocument;
    std::unique_ptr<IsoSubspace> m_subspaceForBlob;
    std::unique_ptr<IsoSubspace> m_subspaceForFile;
    std::unique_ptr<IsoSubspace> m_subspaceForFileList;
    std::unique_ptr<IsoSubspace> m_subspaceForFileReader;
    std::unique_ptr<IsoSubspace> m_subspaceForFileReaderSync;
    std::unique_ptr<IsoSubspace> m_subspaceForDOMFormData;
    std::unique_ptr<IsoSubspace> m_subspaceForDOMFormDataIterator;
    std::unique_ptr<IsoSubspace> m_subspaceForDOMTokenList;
    std::unique_ptr<IsoSubspace> m_subspaceForDOMTokenListIterator;
    std::unique_ptr<IsoSubspace> m_subspaceForDOMURL;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLAllCollection;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLAnchorElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLAreaElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLAttachmentElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLAudioElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLBRElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLBaseElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLBodyElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLButtonElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLCanvasElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLCollection;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLDListElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLDataElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLDataListElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLDetailsElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLDialogElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLDirectoryElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLDivElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLDocument;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLEmbedElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLFieldSetElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLFontElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLFormControlsCollection;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLFormElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLFrameElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLFrameSetElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLHRElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLHeadElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLHeadingElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLHtmlElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLIFrameElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLImageElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLInputElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLLIElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLLabelElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLLegendElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLLinkElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLMapElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLMarqueeElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLMediaElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLMenuElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLMetaElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLMeterElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLModElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLOListElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLObjectElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLOptGroupElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLOptionElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLOptionsCollection;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLOutputElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLParagraphElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLParamElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLPictureElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLPreElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLProgressElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLQuoteElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLScriptElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLSelectElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLSlotElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLSourceElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLSpanElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLStyleElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLTableCaptionElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLTableCellElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLTableColElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLTableElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLTableRowElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLTableSectionElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLTemplateElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLTextAreaElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLTimeElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLTitleElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLTrackElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLUListElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLUnknownElement;
    std::unique_ptr<IsoSubspace> m_subspaceForHTMLVideoElement;
    std::unique_ptr<IsoSubspace> m_subspaceForImageBitmap;
    std::unique_ptr<IsoSubspace> m_subspaceForImageData;
    std::unique_ptr<IsoSubspace> m_subspaceForMediaController;
    std::unique_ptr<IsoSubspace> m_subspaceForMediaEncryptedEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForMediaError;
    std::unique_ptr<IsoSubspace> m_subspaceForOffscreenCanvas;
    std::unique_ptr<IsoSubspace> m_subspaceForRadioNodeList;
    std::unique_ptr<IsoSubspace> m_subspaceForSubmitEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForTextMetrics;
    std::unique_ptr<IsoSubspace> m_subspaceForTimeRanges;
    std::unique_ptr<IsoSubspace> m_subspaceForURLSearchParams;
    std::unique_ptr<IsoSubspace> m_subspaceForURLSearchParamsIterator;
    std::unique_ptr<IsoSubspace> m_subspaceForUserActivation;
    std::unique_ptr<IsoSubspace> m_subspaceForValidityState;
    std::unique_ptr<IsoSubspace> m_subspaceForWebKitMediaKeyError;
    std::unique_ptr<IsoSubspace> m_subspaceForANGLEInstancedArrays;
    std::unique_ptr<IsoSubspace> m_subspaceForCanvasGradient;
    std::unique_ptr<IsoSubspace> m_subspaceForCanvasPattern;
    std::unique_ptr<IsoSubspace> m_subspaceForCanvasRenderingContext2D;
    std::unique_ptr<IsoSubspace> m_subspaceForEXTBlendMinMax;
    std::unique_ptr<IsoSubspace> m_subspaceForEXTClipControl;
    std::unique_ptr<IsoSubspace> m_subspaceForEXTColorBufferFloat;
    std::unique_ptr<IsoSubspace> m_subspaceForEXTColorBufferHalfFloat;
    std::unique_ptr<IsoSubspace> m_subspaceForEXTConservativeDepth;
    std::unique_ptr<IsoSubspace> m_subspaceForEXTDepthClamp;
    std::unique_ptr<IsoSubspace> m_subspaceForEXTDisjointTimerQuery;
    std::unique_ptr<IsoSubspace> m_subspaceForEXTDisjointTimerQueryWebGL2;
    std::unique_ptr<IsoSubspace> m_subspaceForEXTFloatBlend;
    std::unique_ptr<IsoSubspace> m_subspaceForEXTFragDepth;
    std::unique_ptr<IsoSubspace> m_subspaceForEXTPolygonOffsetClamp;
    std::unique_ptr<IsoSubspace> m_subspaceForEXTRenderSnorm;
    std::unique_ptr<IsoSubspace> m_subspaceForEXTShaderTextureLOD;
    std::unique_ptr<IsoSubspace> m_subspaceForEXTTextureCompressionBPTC;
    std::unique_ptr<IsoSubspace> m_subspaceForEXTTextureCompressionRGTC;
    std::unique_ptr<IsoSubspace> m_subspaceForEXTTextureFilterAnisotropic;
    std::unique_ptr<IsoSubspace> m_subspaceForEXTTextureMirrorClampToEdge;
    std::unique_ptr<IsoSubspace> m_subspaceForEXTTextureNorm16;
    std::unique_ptr<IsoSubspace> m_subspaceForEXTsRGB;
    std::unique_ptr<IsoSubspace> m_subspaceForGPUCanvasContext;
    std::unique_ptr<IsoSubspace> m_subspaceForImageBitmapRenderingContext;
    std::unique_ptr<IsoSubspace> m_subspaceForKHRParallelShaderCompile;
    std::unique_ptr<IsoSubspace> m_subspaceForNVShaderNoperspectiveInterpolation;
    std::unique_ptr<IsoSubspace> m_subspaceForOESDrawBuffersIndexed;
    std::unique_ptr<IsoSubspace> m_subspaceForOESElementIndexUint;
    std::unique_ptr<IsoSubspace> m_subspaceForOESFBORenderMipmap;
    std::unique_ptr<IsoSubspace> m_subspaceForOESSampleVariables;
    std::unique_ptr<IsoSubspace> m_subspaceForOESShaderMultisampleInterpolation;
    std::unique_ptr<IsoSubspace> m_subspaceForOESStandardDerivatives;
    std::unique_ptr<IsoSubspace> m_subspaceForOESTextureFloat;
    std::unique_ptr<IsoSubspace> m_subspaceForOESTextureFloatLinear;
    std::unique_ptr<IsoSubspace> m_subspaceForOESTextureHalfFloat;
    std::unique_ptr<IsoSubspace> m_subspaceForOESTextureHalfFloatLinear;
    std::unique_ptr<IsoSubspace> m_subspaceForOESVertexArrayObject;
    std::unique_ptr<IsoSubspace> m_subspaceForOffscreenCanvasRenderingContext2D;
    std::unique_ptr<IsoSubspace> m_subspaceForPaintRenderingContext2D;
    std::unique_ptr<IsoSubspace> m_subspaceForPath2D;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGL2RenderingContext;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLActiveInfo;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLBlendFuncExtended;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLBuffer;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLClipCullDistance;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLColorBufferFloat;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLCompressedTextureASTC;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLCompressedTextureETC;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLCompressedTextureETC1;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLCompressedTexturePVRTC;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLCompressedTextureS3TC;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLCompressedTextureS3TCsRGB;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLContextEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLDebugRendererInfo;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLDebugShaders;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLDepthTexture;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLDrawBuffers;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLDrawInstancedBaseVertexBaseInstance;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLFramebuffer;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLLoseContext;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLMultiDraw;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLMultiDrawInstancedBaseVertexBaseInstance;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLPolygonMode;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLProgram;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLProvokingVertex;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLQuery;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLRenderSharedExponent;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLRenderbuffer;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLRenderingContext;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLSampler;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLShader;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLShaderPrecisionFormat;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLStencilTexturing;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLSync;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLTexture;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLTimerQueryEXT;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLTransformFeedback;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLUniformLocation;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLVertexArrayObject;
    std::unique_ptr<IsoSubspace> m_subspaceForWebGLVertexArrayObjectOES;
    std::unique_ptr<IsoSubspace> m_subspaceForAudioTrack;
    std::unique_ptr<IsoSubspace> m_subspaceForAudioTrackConfiguration;
    std::unique_ptr<IsoSubspace> m_subspaceForAudioTrackList;
    std::unique_ptr<IsoSubspace> m_subspaceForDataCue;
    std::unique_ptr<IsoSubspace> m_subspaceForTextTrack;
    std::unique_ptr<IsoSubspace> m_subspaceForTextTrackCue;
    std::unique_ptr<IsoSubspace> m_subspaceForTextTrackCueGeneric;
    std::unique_ptr<IsoSubspace> m_subspaceForTextTrackCueList;
    std::unique_ptr<IsoSubspace> m_subspaceForTextTrackList;
    std::unique_ptr<IsoSubspace> m_subspaceForTrackEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForVTTCue;
    std::unique_ptr<IsoSubspace> m_subspaceForVTTRegion;
    std::unique_ptr<IsoSubspace> m_subspaceForVTTRegionList;
    std::unique_ptr<IsoSubspace> m_subspaceForVideoTrack;
    std::unique_ptr<IsoSubspace> m_subspaceForVideoTrackConfiguration;
    std::unique_ptr<IsoSubspace> m_subspaceForVideoTrackList;
    std::unique_ptr<IsoSubspace> m_subspaceForCommandLineAPIHost;
    std::unique_ptr<IsoSubspace> m_subspaceForInspectorAuditAccessibilityObject;
    std::unique_ptr<IsoSubspace> m_subspaceForInspectorAuditDOMObject;
    std::unique_ptr<IsoSubspace> m_subspaceForInspectorAuditResourcesObject;
    std::unique_ptr<IsoSubspace> m_subspaceForInspectorFrontendHost;
    std::unique_ptr<IsoSubspace> m_subspaceForCOEPInheritenceViolationReportBody;
    std::unique_ptr<IsoSubspace> m_subspaceForCORPViolationReportBody;
    std::unique_ptr<IsoSubspace> m_subspaceForDOMApplicationCache;
    std::unique_ptr<IsoSubspace> m_subspaceForMathMLElement;
    std::unique_ptr<IsoSubspace> m_subspaceForMathMLMathElement;
    std::unique_ptr<IsoSubspace> m_subspaceForBarProp;
    std::unique_ptr<IsoSubspace> m_subspaceForCrypto;
    std::unique_ptr<IsoSubspace> m_subspaceForDOMSelection;
    std::unique_ptr<IsoSubspace> m_subspaceForEventSource;
    std::unique_ptr<IsoSubspace> m_subspaceForHistory;
    std::unique_ptr<IsoSubspace> m_subspaceForIntersectionObserver;
    std::unique_ptr<IsoSubspace> m_subspaceForIntersectionObserverEntry;
    std::unique_ptr<IsoSubspace> m_subspaceForLocalDOMWindow;
    std::unique_ptr<IsoSubspace> m_subspaceForLocation;
    std::unique_ptr<IsoSubspace> m_subspaceForNavigateEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForNavigation;
    std::unique_ptr<IsoSubspace> m_subspaceForNavigationCurrentEntryChangeEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForNavigationDestination;
    std::unique_ptr<IsoSubspace> m_subspaceForNavigationHistoryEntry;
    std::unique_ptr<IsoSubspace> m_subspaceForNavigationTransition;
    std::unique_ptr<IsoSubspace> m_subspaceForNavigator;
    std::unique_ptr<IsoSubspace> m_subspaceForPerformance;
    std::unique_ptr<IsoSubspace> m_subspaceForPerformanceEntry;
    std::unique_ptr<IsoSubspace> m_subspaceForPerformanceMark;
    std::unique_ptr<IsoSubspace> m_subspaceForPerformanceMeasure;
    std::unique_ptr<IsoSubspace> m_subspaceForPerformanceNavigation;
    std::unique_ptr<IsoSubspace> m_subspaceForPerformanceNavigationTiming;
    std::unique_ptr<IsoSubspace> m_subspaceForPerformanceObserver;
    std::unique_ptr<IsoSubspace> m_subspaceForPerformanceObserverEntryList;
    std::unique_ptr<IsoSubspace> m_subspaceForPerformancePaintTiming;
    std::unique_ptr<IsoSubspace> m_subspaceForPerformanceResourceTiming;
    std::unique_ptr<IsoSubspace> m_subspaceForPerformanceServerTiming;
    std::unique_ptr<IsoSubspace> m_subspaceForPerformanceTiming;
    std::unique_ptr<IsoSubspace> m_subspaceForRemoteDOMWindow;
    std::unique_ptr<IsoSubspace> m_subspaceForResizeObserver;
    std::unique_ptr<IsoSubspace> m_subspaceForResizeObserverEntry;
    std::unique_ptr<IsoSubspace> m_subspaceForResizeObserverSize;
    std::unique_ptr<IsoSubspace> m_subspaceForScreen;
    std::unique_ptr<IsoSubspace> m_subspaceForScreenOrientation;
    std::unique_ptr<IsoSubspace> m_subspaceForShadowRealmGlobalScope;
    std::unique_ptr<IsoSubspace> m_subspaceForUndoItem;
    std::unique_ptr<IsoSubspace> m_subspaceForUndoManager;
    std::unique_ptr<IsoSubspace> m_subspaceForUserMessageHandler;
    std::unique_ptr<IsoSubspace> m_subspaceForUserMessageHandlersNamespace;
    std::unique_ptr<IsoSubspace> m_subspaceForVisualViewport;
    std::unique_ptr<IsoSubspace> m_subspaceForWebKitNamespace;
    std::unique_ptr<IsoSubspace> m_subspaceForWebKitPoint;
    std::unique_ptr<IsoSubspace> m_subspaceForWorkerNavigator;
    std::unique_ptr<IsoSubspace> m_subspaceForCSPViolationReportBody;
    std::unique_ptr<IsoSubspace> m_subspaceForDOMMimeType;
    std::unique_ptr<IsoSubspace> m_subspaceForDOMMimeTypeArray;
    std::unique_ptr<IsoSubspace> m_subspaceForDOMPlugin;
    std::unique_ptr<IsoSubspace> m_subspaceForDOMPluginArray;
    std::unique_ptr<IsoSubspace> m_subspaceForStorage;
    std::unique_ptr<IsoSubspace> m_subspaceForStorageEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGAElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGAngle;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGAnimateColorElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGAnimateElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGAnimateMotionElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGAnimateTransformElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGAnimatedAngle;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGAnimatedBoolean;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGAnimatedEnumeration;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGAnimatedInteger;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGAnimatedLength;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGAnimatedLengthList;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGAnimatedNumber;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGAnimatedNumberList;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGAnimatedPreserveAspectRatio;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGAnimatedRect;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGAnimatedString;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGAnimatedTransformList;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGAnimationElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGCircleElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGClipPathElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGComponentTransferFunctionElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGDefsElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGDescElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGEllipseElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGFEBlendElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGFEColorMatrixElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGFEComponentTransferElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGFECompositeElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGFEConvolveMatrixElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGFEDiffuseLightingElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGFEDisplacementMapElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGFEDistantLightElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGFEDropShadowElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGFEFloodElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGFEFuncAElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGFEFuncBElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGFEFuncGElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGFEFuncRElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGFEGaussianBlurElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGFEImageElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGFEMergeElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGFEMergeNodeElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGFEMorphologyElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGFEOffsetElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGFEPointLightElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGFESpecularLightingElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGFESpotLightElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGFETileElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGFETurbulenceElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGFilterElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGForeignObjectElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGGElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGGeometryElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGGradientElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGGraphicsElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGImageElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGLength;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGLengthList;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGLineElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGLinearGradientElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGMPathElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGMarkerElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGMaskElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGMatrix;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGMetadataElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGNumber;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGNumberList;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGPathElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGPathSeg;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGPathSegArcAbs;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGPathSegArcRel;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGPathSegClosePath;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGPathSegCurvetoCubicAbs;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGPathSegCurvetoCubicRel;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGPathSegCurvetoCubicSmoothAbs;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGPathSegCurvetoCubicSmoothRel;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGPathSegCurvetoQuadraticAbs;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGPathSegCurvetoQuadraticRel;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGPathSegCurvetoQuadraticSmoothAbs;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGPathSegCurvetoQuadraticSmoothRel;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGPathSegLinetoAbs;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGPathSegLinetoHorizontalAbs;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGPathSegLinetoHorizontalRel;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGPathSegLinetoRel;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGPathSegLinetoVerticalAbs;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGPathSegLinetoVerticalRel;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGPathSegList;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGPathSegMovetoAbs;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGPathSegMovetoRel;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGPatternElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGPoint;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGPointList;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGPolygonElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGPolylineElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGPreserveAspectRatio;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGRadialGradientElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGRect;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGRectElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGSVGElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGScriptElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGSetElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGStopElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGStringList;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGStyleElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGSwitchElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGSymbolElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGTSpanElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGTextContentElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGTextElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGTextPathElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGTextPositioningElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGTitleElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGTransform;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGTransformList;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGUnitTypes;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGUseElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGViewElement;
    std::unique_ptr<IsoSubspace> m_subspaceForSVGViewSpec;
    std::unique_ptr<IsoSubspace> m_subspaceForGCObservation;
    std::unique_ptr<IsoSubspace> m_subspaceForInternalSettings;
    std::unique_ptr<IsoSubspace> m_subspaceForInternals;
    std::unique_ptr<IsoSubspace> m_subspaceForInternalsMapLike;
    std::unique_ptr<IsoSubspace> m_subspaceForInternalsSetLike;
    std::unique_ptr<IsoSubspace> m_subspaceForMallocStatistics;
    std::unique_ptr<IsoSubspace> m_subspaceForMemoryInfo;
    std::unique_ptr<IsoSubspace> m_subspaceForMockCDMFactory;
    std::unique_ptr<IsoSubspace> m_subspaceForMockContentFilterSettings;
    std::unique_ptr<IsoSubspace> m_subspaceForMockPageOverlay;
    std::unique_ptr<IsoSubspace> m_subspaceForServiceWorkerInternals;
    std::unique_ptr<IsoSubspace> m_subspaceForTypeConversions;
    std::unique_ptr<IsoSubspace> m_subspaceForDedicatedWorkerGlobalScope;
    std::unique_ptr<IsoSubspace> m_subspaceForWorker;
    std::unique_ptr<IsoSubspace> m_subspaceForWorkerGlobalScope;
    std::unique_ptr<IsoSubspace> m_subspaceForWorkerLocation;
    std::unique_ptr<IsoSubspace> m_subspaceForExtendableEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForExtendableMessageEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForFetchEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForNavigationPreloadManager;
    std::unique_ptr<IsoSubspace> m_subspaceForServiceWorker;
    std::unique_ptr<IsoSubspace> m_subspaceForServiceWorkerClient;
    std::unique_ptr<IsoSubspace> m_subspaceForServiceWorkerClients;
    std::unique_ptr<IsoSubspace> m_subspaceForServiceWorkerContainer;
    std::unique_ptr<IsoSubspace> m_subspaceForServiceWorkerGlobalScope;
    std::unique_ptr<IsoSubspace> m_subspaceForServiceWorkerRegistration;
    std::unique_ptr<IsoSubspace> m_subspaceForServiceWorkerWindowClient;
    std::unique_ptr<IsoSubspace> m_subspaceForBackgroundFetchEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForBackgroundFetchManager;
    std::unique_ptr<IsoSubspace> m_subspaceForBackgroundFetchRecord;
    std::unique_ptr<IsoSubspace> m_subspaceForBackgroundFetchRegistration;
    std::unique_ptr<IsoSubspace> m_subspaceForBackgroundFetchUpdateUIEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForSharedWorker;
    std::unique_ptr<IsoSubspace> m_subspaceForSharedWorkerGlobalScope;
    std::unique_ptr<IsoSubspace> m_subspaceForPaintWorkletGlobalScope;
    std::unique_ptr<IsoSubspace> m_subspaceForWorklet;
    std::unique_ptr<IsoSubspace> m_subspaceForWorkletGlobalScope;
    std::unique_ptr<IsoSubspace> m_subspaceForDOMParser;
    std::unique_ptr<IsoSubspace> m_subspaceForXMLHttpRequest;
    std::unique_ptr<IsoSubspace> m_subspaceForXMLHttpRequestEventTarget;
    std::unique_ptr<IsoSubspace> m_subspaceForXMLHttpRequestProgressEvent;
    std::unique_ptr<IsoSubspace> m_subspaceForXMLHttpRequestUpload;
    std::unique_ptr<IsoSubspace> m_subspaceForXMLSerializer;
    std::unique_ptr<IsoSubspace> m_subspaceForXPathEvaluator;
    std::unique_ptr<IsoSubspace> m_subspaceForXPathExpression;
    std::unique_ptr<IsoSubspace> m_subspaceForXPathNSResolver;
    std::unique_ptr<IsoSubspace> m_subspaceForXPathResult;
    std::unique_ptr<IsoSubspace> m_subspaceForXSLTProcessor;
};
} // namespace WebCore
