// This file is automatically generated from CSSProperties.json by the process-css-properties.py script. Do not edit it.

#include "config.h"
#include "CSSPropertyParsing.h"

#include "CSSParserContext.h"
#include "CSSParserIdioms.h"
#include "CSSPropertyParser.h"
#include "CSSPropertyParserWorkerSafe.h"
#include "CSSValuePool.h"
#include "DeprecatedGlobalSettings.h"

namespace WebCore {

using namespace CSSPropertyParserHelpers;
using namespace CSSPropertyParserHelpersWorkerSafe;

static bool isKeywordValidForWritingMode(CSSValueID keyword, const CSSParserContext& context)
{
    switch (keyword) {
    case CSSValueID::CSSValueHorizontalBt:
    case CSSValueID::CSSValueHorizontalTb:
    case CSSValueID::CSSValueLr:
    case CSSValueID::CSSValueLrTb:
    case CSSValueID::CSSValueRl:
    case CSSValueID::CSSValueRlTb:
    case CSSValueID::CSSValueTb:
    case CSSValueID::CSSValueTbRl:
    case CSSValueID::CSSValueVerticalLr:
    case CSSValueID::CSSValueVerticalRl:
        return true;
    case CSSValueID::CSSValueSidewaysLr:
    case CSSValueID::CSSValueSidewaysRl:
        return context.sidewaysWritingModesEnabled;
    default:
        return false;
    }
}

static bool isKeywordValidForWebkitRubyPosition(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAfter:
    case CSSValueID::CSSValueBefore:
    case CSSValueID::CSSValueInterCharacter:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForDirection(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueLtr:
    case CSSValueID::CSSValueRtl:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForFontFeatureSettings(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueNormal:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForFontKerning(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueNone:
    case CSSValueID::CSSValueNormal:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForFontOpticalSizing(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForFontPalette(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueDark:
    case CSSValueID::CSSValueLight:
    case CSSValueID::CSSValueNormal:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForFontSize(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueLarge:
    case CSSValueID::CSSValueLarger:
    case CSSValueID::CSSValueMedium:
    case CSSValueID::CSSValueSmall:
    case CSSValueID::CSSValueSmaller:
    case CSSValueID::CSSValueXLarge:
    case CSSValueID::CSSValueXSmall:
    case CSSValueID::CSSValueXxLarge:
    case CSSValueID::CSSValueXxSmall:
    case CSSValueID::CSSValueXxxLarge:
    case CSSValueID::CSSValueWebkitRubyText:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForFontStretch(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueCondensed:
    case CSSValueID::CSSValueExpanded:
    case CSSValueID::CSSValueExtraCondensed:
    case CSSValueID::CSSValueExtraExpanded:
    case CSSValueID::CSSValueNormal:
    case CSSValueID::CSSValueSemiCondensed:
    case CSSValueID::CSSValueSemiExpanded:
    case CSSValueID::CSSValueUltraCondensed:
    case CSSValueID::CSSValueUltraExpanded:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForFontSynthesisSmallCaps(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForFontSynthesisStyle(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForFontSynthesisWeight(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForFontVariantCaps(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAllPetiteCaps:
    case CSSValueID::CSSValueAllSmallCaps:
    case CSSValueID::CSSValueNormal:
    case CSSValueID::CSSValuePetiteCaps:
    case CSSValueID::CSSValueSmallCaps:
    case CSSValueID::CSSValueTitlingCaps:
    case CSSValueID::CSSValueUnicase:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForFontVariantEmoji(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueEmoji:
    case CSSValueID::CSSValueNormal:
    case CSSValueID::CSSValueText:
    case CSSValueID::CSSValueUnicode:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForFontVariantPosition(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueNormal:
    case CSSValueID::CSSValueSub:
    case CSSValueID::CSSValueSuper:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForFontVariationSettings(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueNormal:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForTextOrientation(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueMixed:
    case CSSValueID::CSSValueSideways:
    case CSSValueID::CSSValueUpright:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForTextRendering(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueGeometricPrecision:
    case CSSValueID::CSSValueOptimizeLegibility:
    case CSSValueID::CSSValueOptimizeSpeed:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForZoom(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueDocument:
    case CSSValueID::CSSValueNormal:
    case CSSValueID::CSSValueReset:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWebkitFontSmoothing(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAntialiased:
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueNone:
    case CSSValueID::CSSValueSubpixelAntialiased:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWebkitLocale(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWebkitTextZoom(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueNormal:
    case CSSValueID::CSSValueReset:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForLetterSpacing(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueNormal:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForAccentColor(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForAlignmentBaseline(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAfterEdge:
    case CSSValueID::CSSValueAlphabetic:
    case CSSValueID::CSSValueBaseline:
    case CSSValueID::CSSValueBeforeEdge:
    case CSSValueID::CSSValueCentral:
    case CSSValueID::CSSValueHanging:
    case CSSValueID::CSSValueIdeographic:
    case CSSValueID::CSSValueMathematical:
    case CSSValueID::CSSValueMiddle:
    case CSSValueID::CSSValueTextAfterEdge:
    case CSSValueID::CSSValueTextBeforeEdge:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForAppearance(CSSValueID keyword, const CSSParserContext& context)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueButton:
    case CSSValueID::CSSValueCheckbox:
    case CSSValueID::CSSValueListbox:
    case CSSValueID::CSSValueMenulist:
    case CSSValueID::CSSValueMenulistButton:
    case CSSValueID::CSSValueMeter:
    case CSSValueID::CSSValueNone:
    case CSSValueID::CSSValueProgressBar:
    case CSSValueID::CSSValuePushButton:
    case CSSValueID::CSSValueRadio:
    case CSSValueID::CSSValueSearchfield:
    case CSSValueID::CSSValueSliderHorizontal:
    case CSSValueID::CSSValueSliderVertical:
    case CSSValueID::CSSValueSquareButton:
    case CSSValueID::CSSValueTextarea:
    case CSSValueID::CSSValueTextfield:
        return true;
    case CSSValueID::CSSValueDefaultButton:
        return context.useSystemAppearance;
    default:
        return false;
    }
}

static bool isKeywordValidForBackfaceVisibility(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueHidden:
    case CSSValueID::CSSValueVisible:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForBaselineShift(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueBaseline:
    case CSSValueID::CSSValueSub:
    case CSSValueID::CSSValueSuper:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForBlockStepInsert(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueMargin:
    case CSSValueID::CSSValuePadding:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForBlockStepSize(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForBorderCollapse(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueCollapse:
    case CSSValueID::CSSValueSeparate:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForBorderImageSource(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForBoxSizing(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueBorderBox:
    case CSSValueID::CSSValueContentBox:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForBreakAfter(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueAvoid:
    case CSSValueID::CSSValueAvoidColumn:
    case CSSValueID::CSSValueAvoidPage:
    case CSSValueID::CSSValueColumn:
    case CSSValueID::CSSValueLeft:
    case CSSValueID::CSSValuePage:
    case CSSValueID::CSSValueRecto:
    case CSSValueID::CSSValueRight:
    case CSSValueID::CSSValueVerso:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForBreakBefore(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueAvoid:
    case CSSValueID::CSSValueAvoidColumn:
    case CSSValueID::CSSValueAvoidPage:
    case CSSValueID::CSSValueColumn:
    case CSSValueID::CSSValueLeft:
    case CSSValueID::CSSValuePage:
    case CSSValueID::CSSValueRecto:
    case CSSValueID::CSSValueRight:
    case CSSValueID::CSSValueVerso:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForBreakInside(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueAvoid:
    case CSSValueID::CSSValueAvoidColumn:
    case CSSValueID::CSSValueAvoidPage:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForBufferedRendering(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueDynamic:
    case CSSValueID::CSSValueStatic:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForCaptionSide(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueBottom:
    case CSSValueID::CSSValueTop:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForCaretColor(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForClear(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueBoth:
    case CSSValueID::CSSValueInlineEnd:
    case CSSValueID::CSSValueInlineStart:
    case CSSValueID::CSSValueLeft:
    case CSSValueID::CSSValueNone:
    case CSSValueID::CSSValueRight:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForClipRule(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueEvenodd:
    case CSSValueID::CSSValueNonzero:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForColorInterpolation(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueLinearRGB:
    case CSSValueID::CSSValueSRGB:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForColorInterpolationFilters(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueLinearRGB:
    case CSSValueID::CSSValueSRGB:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForColumnCount(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForColumnFill(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueBalance:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForColumnGap(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueNormal:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForColumnRuleStyle(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueDashed:
    case CSSValueID::CSSValueDotted:
    case CSSValueID::CSSValueDouble:
    case CSSValueID::CSSValueGroove:
    case CSSValueID::CSSValueHidden:
    case CSSValueID::CSSValueInset:
    case CSSValueID::CSSValueNone:
    case CSSValueID::CSSValueOutset:
    case CSSValueID::CSSValueRidge:
    case CSSValueID::CSSValueSolid:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForColumnRuleWidth(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueMedium:
    case CSSValueID::CSSValueThick:
    case CSSValueID::CSSValueThin:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForColumnSpan(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAll:
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForColumnWidth(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForContainerType(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueInlineSize:
    case CSSValueID::CSSValueNormal:
    case CSSValueID::CSSValueSize:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForContentVisibility(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueHidden:
    case CSSValueID::CSSValueVisible:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForDominantBaseline(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAlphabetic:
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueCentral:
    case CSSValueID::CSSValueHanging:
    case CSSValueID::CSSValueIdeographic:
    case CSSValueID::CSSValueMathematical:
    case CSSValueID::CSSValueMiddle:
    case CSSValueID::CSSValueNoChange:
    case CSSValueID::CSSValueResetSize:
    case CSSValueID::CSSValueTextAfterEdge:
    case CSSValueID::CSSValueTextBeforeEdge:
    case CSSValueID::CSSValueUseScript:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForEmptyCells(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueHide:
    case CSSValueID::CSSValueShow:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForFillRule(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueEvenodd:
    case CSSValueID::CSSValueNonzero:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForFlexBasis(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueContent:
    case CSSValueID::CSSValueFitContent:
    case CSSValueID::CSSValueIntrinsic:
    case CSSValueID::CSSValueMaxContent:
    case CSSValueID::CSSValueMinContent:
    case CSSValueID::CSSValueMinIntrinsic:
    case CSSValueID::CSSValueWebkitFillAvailable:
    case CSSValueID::CSSValueWebkitFitContent:
    case CSSValueID::CSSValueWebkitMaxContent:
    case CSSValueID::CSSValueWebkitMinContent:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForFlexDirection(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueColumn:
    case CSSValueID::CSSValueColumnReverse:
    case CSSValueID::CSSValueRow:
    case CSSValueID::CSSValueRowReverse:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForFlexWrap(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueNowrap:
    case CSSValueID::CSSValueWrap:
    case CSSValueID::CSSValueWrapReverse:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForFloat(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueInlineEnd:
    case CSSValueID::CSSValueInlineStart:
    case CSSValueID::CSSValueLeft:
    case CSSValueID::CSSValueNone:
    case CSSValueID::CSSValueRight:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForGlyphOrientationVertical(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForHyphenateCharacter(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForHyphens(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueManual:
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForImageOrientation(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueFromImage:
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForImageRendering(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueCrispEdges:
    case CSSValueID::CSSValueOptimizeQuality:
    case CSSValueID::CSSValueOptimizeSpeed:
    case CSSValueID::CSSValuePixelated:
    case CSSValueID::CSSValueWebkitCrispEdges:
    case CSSValueID::CSSValueWebkitOptimizeContrast:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForInputSecurity(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForIsolation(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueIsolate:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForKerning(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueNormal:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForLineBreak(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAfterWhiteSpace:
    case CSSValueID::CSSValueAnywhere:
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueLoose:
    case CSSValueID::CSSValueNormal:
    case CSSValueID::CSSValueStrict:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForLineHeight(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueNormal:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForListStyleImage(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForListStylePosition(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueInside:
    case CSSValueID::CSSValueOutside:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForMarkerEnd(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForMarkerMid(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForMarkerStart(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForMaskBorderSource(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForMaskType(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAlpha:
    case CSSValueID::CSSValueLuminance:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForMathStyle(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueCompact:
    case CSSValueID::CSSValueNormal:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForMixBlendMode(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueColor:
    case CSSValueID::CSSValueColorBurn:
    case CSSValueID::CSSValueColorDodge:
    case CSSValueID::CSSValueDarken:
    case CSSValueID::CSSValueDifference:
    case CSSValueID::CSSValueExclusion:
    case CSSValueID::CSSValueHardLight:
    case CSSValueID::CSSValueHue:
    case CSSValueID::CSSValueLighten:
    case CSSValueID::CSSValueLuminosity:
    case CSSValueID::CSSValueMultiply:
    case CSSValueID::CSSValueNormal:
    case CSSValueID::CSSValueOverlay:
    case CSSValueID::CSSValuePlusDarker:
    case CSSValueID::CSSValuePlusLighter:
    case CSSValueID::CSSValueSaturation:
    case CSSValueID::CSSValueScreen:
    case CSSValueID::CSSValueSoftLight:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForObjectFit(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueContain:
    case CSSValueID::CSSValueCover:
    case CSSValueID::CSSValueFill:
    case CSSValueID::CSSValueNone:
    case CSSValueID::CSSValueScaleDown:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForOffsetAnchor(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForOffsetPosition(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueNormal:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForOutlineColor(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueWebkitFocusRingColor:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForOutlineStyle(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueDashed:
    case CSSValueID::CSSValueDotted:
    case CSSValueID::CSSValueDouble:
    case CSSValueID::CSSValueGroove:
    case CSSValueID::CSSValueInset:
    case CSSValueID::CSSValueNone:
    case CSSValueID::CSSValueOutset:
    case CSSValueID::CSSValueRidge:
    case CSSValueID::CSSValueSolid:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForOutlineWidth(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueMedium:
    case CSSValueID::CSSValueThick:
    case CSSValueID::CSSValueThin:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForOverflowAnchor(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForOverflowWrap(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAnywhere:
    case CSSValueID::CSSValueBreakWord:
    case CSSValueID::CSSValueNormal:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForOverflowX(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueClip:
    case CSSValueID::CSSValueHidden:
    case CSSValueID::CSSValueOverlay:
    case CSSValueID::CSSValueScroll:
    case CSSValueID::CSSValueVisible:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForOverflowY(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueClip:
    case CSSValueID::CSSValueHidden:
    case CSSValueID::CSSValueOverlay:
    case CSSValueID::CSSValueScroll:
    case CSSValueID::CSSValueVisible:
    case CSSValueID::CSSValueWebkitPagedX:
    case CSSValueID::CSSValueWebkitPagedY:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForPage(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForPerspective(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForPointerEvents(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAll:
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueBoundingBox:
    case CSSValueID::CSSValueFill:
    case CSSValueID::CSSValueNone:
    case CSSValueID::CSSValuePainted:
    case CSSValueID::CSSValueStroke:
    case CSSValueID::CSSValueVisible:
    case CSSValueID::CSSValueVisibleFill:
    case CSSValueID::CSSValueVisiblePainted:
    case CSSValueID::CSSValueVisibleStroke:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForPosition(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAbsolute:
    case CSSValueID::CSSValueFixed:
    case CSSValueID::CSSValueRelative:
    case CSSValueID::CSSValueStatic:
    case CSSValueID::CSSValueSticky:
    case CSSValueID::CSSValueWebkitSticky:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForPrintColorAdjust(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueEconomy:
    case CSSValueID::CSSValueExact:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForResize(CSSValueID keyword, const CSSParserContext& context)
{
    switch (keyword) {
    case CSSValueID::CSSValueBlock:
    case CSSValueID::CSSValueBoth:
    case CSSValueID::CSSValueHorizontal:
    case CSSValueID::CSSValueInline:
    case CSSValueID::CSSValueNone:
    case CSSValueID::CSSValueVertical:
        return true;
    case CSSValueID::CSSValueInternalTextareaAuto:
        return isUASheetBehavior(context.mode);
    default:
        return false;
    }
}

static bool isKeywordValidForRowGap(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueNormal:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForRx(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForRy(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForScrollBehavior(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueSmooth:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForScrollSnapStop(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAlways:
    case CSSValueID::CSSValueNormal:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForScrollbarWidth(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueNone:
    case CSSValueID::CSSValueThin:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForShapeRendering(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueCrispedges:
    case CSSValueID::CSSValueGeometricPrecision:
    case CSSValueID::CSSValueOptimizeSpeed:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForStrokeLinecap(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueButt:
    case CSSValueID::CSSValueRound:
    case CSSValueID::CSSValueSquare:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForStrokeLinejoin(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueBevel:
    case CSSValueID::CSSValueMiter:
    case CSSValueID::CSSValueRound:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForTableLayout(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueFixed:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForTextAlign(CSSValueID keyword, const CSSParserContext& context)
{
    switch (keyword) {
    case CSSValueID::CSSValueCenter:
    case CSSValueID::CSSValueEnd:
    case CSSValueID::CSSValueJustify:
    case CSSValueID::CSSValueLeft:
    case CSSValueID::CSSValueMatchParent:
    case CSSValueID::CSSValueRight:
    case CSSValueID::CSSValueStart:
    case CSSValueID::CSSValueWebkitAuto:
    case CSSValueID::CSSValueWebkitCenter:
    case CSSValueID::CSSValueWebkitLeft:
    case CSSValueID::CSSValueWebkitMatchParent:
    case CSSValueID::CSSValueWebkitRight:
        return true;
    case CSSValueID::CSSValueInternalThCenter:
        return isUASheetBehavior(context.mode);
    default:
        return false;
    }
}

static bool isKeywordValidForTextAlignLast(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueCenter:
    case CSSValueID::CSSValueEnd:
    case CSSValueID::CSSValueJustify:
    case CSSValueID::CSSValueLeft:
    case CSSValueID::CSSValueMatchParent:
    case CSSValueID::CSSValueRight:
    case CSSValueID::CSSValueStart:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForTextAnchor(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueEnd:
    case CSSValueID::CSSValueMiddle:
    case CSSValueID::CSSValueStart:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForTextBoxTrim(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueBoth:
    case CSSValueID::CSSValueEnd:
    case CSSValueID::CSSValueNone:
    case CSSValueID::CSSValueStart:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForTextDecorationSkipInk(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAll:
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForTextDecorationStyle(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueDashed:
    case CSSValueID::CSSValueDotted:
    case CSSValueID::CSSValueDouble:
    case CSSValueID::CSSValueSolid:
    case CSSValueID::CSSValueWavy:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForTextDecorationThickness(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueFromFont:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForTextGroupAlign(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueCenter:
    case CSSValueID::CSSValueEnd:
    case CSSValueID::CSSValueLeft:
    case CSSValueID::CSSValueNone:
    case CSSValueID::CSSValueRight:
    case CSSValueID::CSSValueStart:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForTextJustify(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueDistribute:
    case CSSValueID::CSSValueInterCharacter:
    case CSSValueID::CSSValueInterWord:
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForTextOverflow(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueClip:
    case CSSValueID::CSSValueEllipsis:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForTextUnderlineOffset(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForTextUnderlinePosition(CSSValueID keyword, const CSSParserContext& context)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueFromFont:
    case CSSValueID::CSSValueUnder:
        return true;
    case CSSValueID::CSSValueLeft:
    case CSSValueID::CSSValueRight:
        return context.cssTextUnderlinePositionLeftRightEnabled;
    default:
        return false;
    }
}

static bool isKeywordValidForTextWrapMode(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueNowrap:
    case CSSValueID::CSSValueWrap:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForTextWrapStyle(CSSValueID keyword, const CSSParserContext& context)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueBalance:
    case CSSValueID::CSSValueStable:
        return true;
    case CSSValueID::CSSValuePretty:
        return context.cssTextWrapPrettyEnabled;
    default:
        return false;
    }
}

static bool isKeywordValidForTransformBox(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueBorderBox:
    case CSSValueID::CSSValueContentBox:
    case CSSValueID::CSSValueFillBox:
    case CSSValueID::CSSValueStrokeBox:
    case CSSValueID::CSSValueViewBox:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForTransformStyle(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueFlat:
    case CSSValueID::CSSValuePreserve3d:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForTransitionProperty(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForUnicodeBidi(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueBidiOverride:
    case CSSValueID::CSSValueEmbed:
    case CSSValueID::CSSValueIsolate:
    case CSSValueID::CSSValueIsolateOverride:
    case CSSValueID::CSSValueNormal:
    case CSSValueID::CSSValuePlaintext:
    case CSSValueID::CSSValueWebkitIsolate:
    case CSSValueID::CSSValueWebkitIsolateOverride:
    case CSSValueID::CSSValueWebkitPlaintext:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForVectorEffect(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueNonScalingStroke:
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForVerticalAlign(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueBaseline:
    case CSSValueID::CSSValueBottom:
    case CSSValueID::CSSValueMiddle:
    case CSSValueID::CSSValueSub:
    case CSSValueID::CSSValueSuper:
    case CSSValueID::CSSValueTextBottom:
    case CSSValueID::CSSValueTextTop:
    case CSSValueID::CSSValueTop:
    case CSSValueID::CSSValueWebkitBaselineMiddle:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForVisibility(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueCollapse:
    case CSSValueID::CSSValueHidden:
    case CSSValueID::CSSValueVisible:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWhiteSpaceCollapse(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueBreakSpaces:
    case CSSValueID::CSSValueCollapse:
    case CSSValueID::CSSValuePreserve:
    case CSSValueID::CSSValuePreserveBreaks:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWordBreak(CSSValueID keyword, const CSSParserContext& context)
{
    switch (keyword) {
    case CSSValueID::CSSValueBreakAll:
    case CSSValueID::CSSValueBreakWord:
    case CSSValueID::CSSValueKeepAll:
    case CSSValueID::CSSValueNormal:
        return true;
    case CSSValueID::CSSValueAutoPhrase:
        return context.cssWordBreakAutoPhraseEnabled;
    default:
        return false;
    }
}

static bool isKeywordValidForZIndex(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWebkitBoxAlign(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueBaseline:
    case CSSValueID::CSSValueCenter:
    case CSSValueID::CSSValueEnd:
    case CSSValueID::CSSValueStart:
    case CSSValueID::CSSValueStretch:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWebkitBoxDecorationBreak(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueClone:
    case CSSValueID::CSSValueSlice:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWebkitBoxDirection(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueNormal:
    case CSSValueID::CSSValueReverse:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWebkitBoxLines(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueMultiple:
    case CSSValueID::CSSValueSingle:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWebkitBoxOrient(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueBlockAxis:
    case CSSValueID::CSSValueHorizontal:
    case CSSValueID::CSSValueInlineAxis:
    case CSSValueID::CSSValueVertical:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWebkitBoxPack(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueCenter:
    case CSSValueID::CSSValueEnd:
    case CSSValueID::CSSValueJustify:
    case CSSValueID::CSSValueStart:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWebkitColumnAxis(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueHorizontal:
    case CSSValueID::CSSValueVertical:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWebkitColumnProgression(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueNormal:
    case CSSValueID::CSSValueReverse:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWebkitCursorVisibility(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueAutoHide:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWebkitHyphenateLimitAfter(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWebkitHyphenateLimitBefore(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWebkitHyphenateLimitLines(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueNoLimit:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWebkitLineAlign(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueEdges:
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWebkitLineGrid(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWebkitLineSnap(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueBaseline:
    case CSSValueID::CSSValueContain:
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWebkitMarqueeDirection(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAhead:
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueBackwards:
    case CSSValueID::CSSValueDown:
    case CSSValueID::CSSValueForwards:
    case CSSValueID::CSSValueLeft:
    case CSSValueID::CSSValueReverse:
    case CSSValueID::CSSValueRight:
    case CSSValueID::CSSValueUp:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWebkitMarqueeStyle(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAlternate:
    case CSSValueID::CSSValueNone:
    case CSSValueID::CSSValueScroll:
    case CSSValueID::CSSValueSlide:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWebkitNbspMode(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueNormal:
    case CSSValueID::CSSValueSpace:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWebkitRtlOrdering(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueLogical:
    case CSSValueID::CSSValueVisual:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWebkitTextSecurity(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueCircle:
    case CSSValueID::CSSValueDisc:
    case CSSValueID::CSSValueNone:
    case CSSValueID::CSSValueSquare:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWebkitTextStrokeWidth(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueMedium:
    case CSSValueID::CSSValueThick:
    case CSSValueID::CSSValueThin:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWebkitUserDrag(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueElement:
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWebkitUserModify(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueReadOnly:
    case CSSValueID::CSSValueReadWrite:
    case CSSValueID::CSSValueReadWritePlaintextOnly:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWebkitUserSelect(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAll:
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueNone:
    case CSSValueID::CSSValueText:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWordSpacing(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueNormal:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForBlockSize(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueFitContent:
    case CSSValueID::CSSValueIntrinsic:
    case CSSValueID::CSSValueMaxContent:
    case CSSValueID::CSSValueMinContent:
    case CSSValueID::CSSValueMinIntrinsic:
    case CSSValueID::CSSValueWebkitFillAvailable:
    case CSSValueID::CSSValueWebkitFitContent:
    case CSSValueID::CSSValueWebkitMaxContent:
    case CSSValueID::CSSValueWebkitMinContent:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForBorderBlockEndStyle(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueDashed:
    case CSSValueID::CSSValueDotted:
    case CSSValueID::CSSValueDouble:
    case CSSValueID::CSSValueGroove:
    case CSSValueID::CSSValueHidden:
    case CSSValueID::CSSValueInset:
    case CSSValueID::CSSValueNone:
    case CSSValueID::CSSValueOutset:
    case CSSValueID::CSSValueRidge:
    case CSSValueID::CSSValueSolid:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForBorderBlockEndWidth(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueMedium:
    case CSSValueID::CSSValueThick:
    case CSSValueID::CSSValueThin:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForBorderBlockStartStyle(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueDashed:
    case CSSValueID::CSSValueDotted:
    case CSSValueID::CSSValueDouble:
    case CSSValueID::CSSValueGroove:
    case CSSValueID::CSSValueHidden:
    case CSSValueID::CSSValueInset:
    case CSSValueID::CSSValueNone:
    case CSSValueID::CSSValueOutset:
    case CSSValueID::CSSValueRidge:
    case CSSValueID::CSSValueSolid:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForBorderBlockStartWidth(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueMedium:
    case CSSValueID::CSSValueThick:
    case CSSValueID::CSSValueThin:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForBorderBottomStyle(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueDashed:
    case CSSValueID::CSSValueDotted:
    case CSSValueID::CSSValueDouble:
    case CSSValueID::CSSValueGroove:
    case CSSValueID::CSSValueHidden:
    case CSSValueID::CSSValueInset:
    case CSSValueID::CSSValueNone:
    case CSSValueID::CSSValueOutset:
    case CSSValueID::CSSValueRidge:
    case CSSValueID::CSSValueSolid:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForBorderInlineEndStyle(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueDashed:
    case CSSValueID::CSSValueDotted:
    case CSSValueID::CSSValueDouble:
    case CSSValueID::CSSValueGroove:
    case CSSValueID::CSSValueHidden:
    case CSSValueID::CSSValueInset:
    case CSSValueID::CSSValueNone:
    case CSSValueID::CSSValueOutset:
    case CSSValueID::CSSValueRidge:
    case CSSValueID::CSSValueSolid:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForBorderInlineEndWidth(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueMedium:
    case CSSValueID::CSSValueThick:
    case CSSValueID::CSSValueThin:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForBorderInlineStartStyle(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueDashed:
    case CSSValueID::CSSValueDotted:
    case CSSValueID::CSSValueDouble:
    case CSSValueID::CSSValueGroove:
    case CSSValueID::CSSValueHidden:
    case CSSValueID::CSSValueInset:
    case CSSValueID::CSSValueNone:
    case CSSValueID::CSSValueOutset:
    case CSSValueID::CSSValueRidge:
    case CSSValueID::CSSValueSolid:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForBorderInlineStartWidth(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueMedium:
    case CSSValueID::CSSValueThick:
    case CSSValueID::CSSValueThin:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForBorderLeftStyle(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueDashed:
    case CSSValueID::CSSValueDotted:
    case CSSValueID::CSSValueDouble:
    case CSSValueID::CSSValueGroove:
    case CSSValueID::CSSValueHidden:
    case CSSValueID::CSSValueInset:
    case CSSValueID::CSSValueNone:
    case CSSValueID::CSSValueOutset:
    case CSSValueID::CSSValueRidge:
    case CSSValueID::CSSValueSolid:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForBorderRightStyle(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueDashed:
    case CSSValueID::CSSValueDotted:
    case CSSValueID::CSSValueDouble:
    case CSSValueID::CSSValueGroove:
    case CSSValueID::CSSValueHidden:
    case CSSValueID::CSSValueInset:
    case CSSValueID::CSSValueNone:
    case CSSValueID::CSSValueOutset:
    case CSSValueID::CSSValueRidge:
    case CSSValueID::CSSValueSolid:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForBorderTopStyle(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueDashed:
    case CSSValueID::CSSValueDotted:
    case CSSValueID::CSSValueDouble:
    case CSSValueID::CSSValueGroove:
    case CSSValueID::CSSValueHidden:
    case CSSValueID::CSSValueInset:
    case CSSValueID::CSSValueNone:
    case CSSValueID::CSSValueOutset:
    case CSSValueID::CSSValueRidge:
    case CSSValueID::CSSValueSolid:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForHeight(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueFitContent:
    case CSSValueID::CSSValueIntrinsic:
    case CSSValueID::CSSValueMaxContent:
    case CSSValueID::CSSValueMinContent:
    case CSSValueID::CSSValueMinIntrinsic:
    case CSSValueID::CSSValueWebkitFillAvailable:
    case CSSValueID::CSSValueWebkitFitContent:
    case CSSValueID::CSSValueWebkitMaxContent:
    case CSSValueID::CSSValueWebkitMinContent:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForInlineSize(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueFitContent:
    case CSSValueID::CSSValueIntrinsic:
    case CSSValueID::CSSValueMaxContent:
    case CSSValueID::CSSValueMinContent:
    case CSSValueID::CSSValueMinIntrinsic:
    case CSSValueID::CSSValueWebkitFillAvailable:
    case CSSValueID::CSSValueWebkitFitContent:
    case CSSValueID::CSSValueWebkitMaxContent:
    case CSSValueID::CSSValueWebkitMinContent:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForInsetBlockEnd(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForInsetBlockStart(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForInsetInlineEnd(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForInsetInlineStart(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForMarginBlockEnd(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForMarginBlockStart(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForMarginInlineEnd(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForMarginInlineStart(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForMaxBlockSize(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueFitContent:
    case CSSValueID::CSSValueIntrinsic:
    case CSSValueID::CSSValueMaxContent:
    case CSSValueID::CSSValueMinContent:
    case CSSValueID::CSSValueMinIntrinsic:
    case CSSValueID::CSSValueNone:
    case CSSValueID::CSSValueWebkitFillAvailable:
    case CSSValueID::CSSValueWebkitFitContent:
    case CSSValueID::CSSValueWebkitMaxContent:
    case CSSValueID::CSSValueWebkitMinContent:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForMaxHeight(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueFitContent:
    case CSSValueID::CSSValueIntrinsic:
    case CSSValueID::CSSValueMaxContent:
    case CSSValueID::CSSValueMinContent:
    case CSSValueID::CSSValueMinIntrinsic:
    case CSSValueID::CSSValueNone:
    case CSSValueID::CSSValueWebkitFillAvailable:
    case CSSValueID::CSSValueWebkitFitContent:
    case CSSValueID::CSSValueWebkitMaxContent:
    case CSSValueID::CSSValueWebkitMinContent:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForMaxInlineSize(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueFitContent:
    case CSSValueID::CSSValueIntrinsic:
    case CSSValueID::CSSValueMaxContent:
    case CSSValueID::CSSValueMinContent:
    case CSSValueID::CSSValueMinIntrinsic:
    case CSSValueID::CSSValueNone:
    case CSSValueID::CSSValueWebkitFillAvailable:
    case CSSValueID::CSSValueWebkitFitContent:
    case CSSValueID::CSSValueWebkitMaxContent:
    case CSSValueID::CSSValueWebkitMinContent:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForMaxWidth(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueFitContent:
    case CSSValueID::CSSValueIntrinsic:
    case CSSValueID::CSSValueMaxContent:
    case CSSValueID::CSSValueMinContent:
    case CSSValueID::CSSValueMinIntrinsic:
    case CSSValueID::CSSValueNone:
    case CSSValueID::CSSValueWebkitFillAvailable:
    case CSSValueID::CSSValueWebkitFitContent:
    case CSSValueID::CSSValueWebkitMaxContent:
    case CSSValueID::CSSValueWebkitMinContent:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForMinBlockSize(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueFitContent:
    case CSSValueID::CSSValueIntrinsic:
    case CSSValueID::CSSValueMaxContent:
    case CSSValueID::CSSValueMinContent:
    case CSSValueID::CSSValueMinIntrinsic:
    case CSSValueID::CSSValueWebkitFillAvailable:
    case CSSValueID::CSSValueWebkitFitContent:
    case CSSValueID::CSSValueWebkitMaxContent:
    case CSSValueID::CSSValueWebkitMinContent:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForMinHeight(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueFitContent:
    case CSSValueID::CSSValueIntrinsic:
    case CSSValueID::CSSValueMaxContent:
    case CSSValueID::CSSValueMinContent:
    case CSSValueID::CSSValueMinIntrinsic:
    case CSSValueID::CSSValueWebkitFillAvailable:
    case CSSValueID::CSSValueWebkitFitContent:
    case CSSValueID::CSSValueWebkitMaxContent:
    case CSSValueID::CSSValueWebkitMinContent:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForMinInlineSize(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueFitContent:
    case CSSValueID::CSSValueIntrinsic:
    case CSSValueID::CSSValueMaxContent:
    case CSSValueID::CSSValueMinContent:
    case CSSValueID::CSSValueMinIntrinsic:
    case CSSValueID::CSSValueWebkitFillAvailable:
    case CSSValueID::CSSValueWebkitFitContent:
    case CSSValueID::CSSValueWebkitMaxContent:
    case CSSValueID::CSSValueWebkitMinContent:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForMinWidth(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueFitContent:
    case CSSValueID::CSSValueIntrinsic:
    case CSSValueID::CSSValueMaxContent:
    case CSSValueID::CSSValueMinContent:
    case CSSValueID::CSSValueMinIntrinsic:
    case CSSValueID::CSSValueWebkitFillAvailable:
    case CSSValueID::CSSValueWebkitFitContent:
    case CSSValueID::CSSValueWebkitMaxContent:
    case CSSValueID::CSSValueWebkitMinContent:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForOverscrollBehaviorBlock(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueContain:
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForOverscrollBehaviorInline(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueContain:
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForOverscrollBehaviorX(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueContain:
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForOverscrollBehaviorY(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueContain:
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForScrollPaddingBlockEnd(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForScrollPaddingBlockStart(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForScrollPaddingBottom(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForScrollPaddingInlineEnd(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForScrollPaddingInlineStart(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForScrollPaddingLeft(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForScrollPaddingRight(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForScrollPaddingTop(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForTextCombineUpright(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAll:
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWidth(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueFitContent:
    case CSSValueID::CSSValueIntrinsic:
    case CSSValueID::CSSValueMaxContent:
    case CSSValueID::CSSValueMinContent:
    case CSSValueID::CSSValueMinIntrinsic:
    case CSSValueID::CSSValueWebkitFillAvailable:
    case CSSValueID::CSSValueWebkitFitContent:
    case CSSValueID::CSSValueWebkitMaxContent:
    case CSSValueID::CSSValueWebkitMinContent:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForWebkitTextCombine(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueHorizontal:
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForFontFaceFontDisplay(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueBlock:
    case CSSValueID::CSSValueFallback:
    case CSSValueID::CSSValueOptional:
    case CSSValueID::CSSValueSwap:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForFontFaceFontFeatureSettings(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueNormal:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForFontFaceFontVariantCaps(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAllPetiteCaps:
    case CSSValueID::CSSValueAllSmallCaps:
    case CSSValueID::CSSValueNormal:
    case CSSValueID::CSSValuePetiteCaps:
    case CSSValueID::CSSValueSmallCaps:
    case CSSValueID::CSSValueTitlingCaps:
    case CSSValueID::CSSValueUnicase:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForFontFaceFontVariantPosition(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueNormal:
    case CSSValueID::CSSValueSub:
    case CSSValueID::CSSValueSuper:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForFontPaletteValuesBasePalette(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueDark:
    case CSSValueID::CSSValueLight:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForPropertyInherits(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueFalse:
    case CSSValueID::CSSValueTrue:
        return true;
    default:
        return false;
    }
}

static RefPtr<CSSValue> consumeFontFeatureSettings(CSSParserTokenRange& range)
{
    if (auto result = consumeIdent(range, isKeywordValidForFontFeatureSettings))
        return result;
    auto lambda = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
        return consumeFeatureTagValue(range);
    };
    return consumeCommaSeparatedListWithoutSingleValueOptimization(range, lambda);
}

static RefPtr<CSSValue> consumeFontPalette(CSSParserTokenRange& range)
{
    if (auto result = consumeIdent(range, isKeywordValidForFontPalette))
        return result;
    return consumeDashedIdent(range);
}

static RefPtr<CSSValue> consumeFontStretch(CSSParserTokenRange& range)
{
    if (auto result = consumeIdent(range, isKeywordValidForFontStretch))
        return result;
    return consumePercent(range, ValueRange::NonNegative);
}

static RefPtr<CSSValue> consumeFontVariationSettings(CSSParserTokenRange& range)
{
    if (auto result = consumeIdent(range, isKeywordValidForFontVariationSettings))
        return result;
    auto lambda = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
        return consumeVariationTagValue(range);
    };
    return consumeCommaSeparatedListWithoutSingleValueOptimization(range, lambda);
}

static RefPtr<CSSValue> consumeZoom(CSSParserTokenRange& range)
{
    if (auto result = consumeIdent(range, isKeywordValidForZoom))
        return result;
    if (auto result = consumePercent(range, ValueRange::NonNegative))
        return result;
    return consumeNumber(range, ValueRange::NonNegative);
}

static RefPtr<CSSValue> consumeWebkitLocale(CSSParserTokenRange& range)
{
    if (auto result = consumeIdent(range, isKeywordValidForWebkitLocale))
        return result;
    return consumeString(range);
}

static RefPtr<CSSValue> consumeLetterSpacing(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForLetterSpacing))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::All, UnitlessQuirk::Allow);
}

static RefPtr<CSSValue> consumeAccentColor(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForAccentColor))
        return result;
    return consumeColor(range, context);
}

static RefPtr<CSSValue> consumeAnimationComposition(CSSParserTokenRange& range)
{
    auto lambda = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
        switch (auto keyword = range.peek().id(); keyword) {
        case CSSValueID::CSSValueReplace:
        case CSSValueID::CSSValueAdd:
        case CSSValueID::CSSValueAccumulate:
            range.consumeIncludingWhitespace();
            return CSSPrimitiveValue::create(keyword);
        default:
            return nullptr;
        }
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda);
}

static RefPtr<CSSValue> consumeAnimationDelay(CSSParserTokenRange& range, const CSSParserContext& context)
{
    auto lambda = [](CSSParserTokenRange& range, const CSSParserContext& context) -> RefPtr<CSSValue> {
        return consumeTime(range, context.mode, ValueRange::All, UnitlessQuirk::Forbid);
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda, context);
}

static RefPtr<CSSValue> consumeAnimationDirection(CSSParserTokenRange& range)
{
    auto lambda = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
        switch (auto keyword = range.peek().id(); keyword) {
        case CSSValueID::CSSValueNormal:
        case CSSValueID::CSSValueReverse:
        case CSSValueID::CSSValueAlternate:
        case CSSValueID::CSSValueAlternateReverse:
            range.consumeIncludingWhitespace();
            return CSSPrimitiveValue::create(keyword);
        default:
            return nullptr;
        }
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda);
}

static RefPtr<CSSValue> consumeAnimationDuration(CSSParserTokenRange& range, const CSSParserContext& context)
{
    auto lambda = [](CSSParserTokenRange& range, const CSSParserContext& context) -> RefPtr<CSSValue> {
        return consumeTime(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda, context);
}

static RefPtr<CSSValue> consumeAnimationFillMode(CSSParserTokenRange& range)
{
    auto lambda = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
        switch (auto keyword = range.peek().id(); keyword) {
        case CSSValueID::CSSValueNone:
        case CSSValueID::CSSValueForwards:
        case CSSValueID::CSSValueBackwards:
        case CSSValueID::CSSValueBoth:
            range.consumeIncludingWhitespace();
            return CSSPrimitiveValue::create(keyword);
        default:
            return nullptr;
        }
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda);
}

static RefPtr<CSSValue> consumeAnimationIterationCount(CSSParserTokenRange& range)
{
    auto lambda = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
        switch (auto keyword = range.peek().id(); keyword) {
        case CSSValueID::CSSValueInfinite:
            range.consumeIncludingWhitespace();
            return CSSPrimitiveValue::create(keyword);
        default:
            break;
        }
        return consumeNumber(range, ValueRange::NonNegative);
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda);
}

static RefPtr<CSSValue> consumeAnimationName(CSSParserTokenRange& range, const CSSParserContext& context)
{
    auto lambda = [](CSSParserTokenRange& range, const CSSParserContext& context) -> RefPtr<CSSValue> {
        switch (auto keyword = range.peek().id(); keyword) {
        case CSSValueID::CSSValueNone:
            range.consumeIncludingWhitespace();
            return CSSPrimitiveValue::create(keyword);
        default:
            break;
        }
        return consumeKeyframesName(range, context);
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda, context);
}

static RefPtr<CSSValue> consumeAnimationPlayState(CSSParserTokenRange& range)
{
    auto lambda = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
        switch (auto keyword = range.peek().id(); keyword) {
        case CSSValueID::CSSValueRunning:
        case CSSValueID::CSSValuePaused:
            range.consumeIncludingWhitespace();
            return CSSPrimitiveValue::create(keyword);
        default:
            return nullptr;
        }
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda);
}

static RefPtr<CSSValue> consumeAnimationTimingFunction(CSSParserTokenRange& range, const CSSParserContext& context)
{
    auto lambda = [](CSSParserTokenRange& range, const CSSParserContext& context) -> RefPtr<CSSValue> {
        return consumeTimingFunction(range, context);
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda, context);
}

static RefPtr<CSSValue> consumeBackgroundAttachment(CSSParserTokenRange& range)
{
    auto lambda = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
        switch (auto keyword = range.peek().id(); keyword) {
        case CSSValueID::CSSValueScroll:
        case CSSValueID::CSSValueFixed:
        case CSSValueID::CSSValueLocal:
            range.consumeIncludingWhitespace();
            return CSSPrimitiveValue::create(keyword);
        default:
            return nullptr;
        }
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda);
}

static RefPtr<CSSValue> consumeBackgroundBlendMode(CSSParserTokenRange& range)
{
    auto lambda = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
        switch (auto keyword = range.peek().id(); keyword) {
        case CSSValueID::CSSValueNormal:
        case CSSValueID::CSSValueMultiply:
        case CSSValueID::CSSValueScreen:
        case CSSValueID::CSSValueOverlay:
        case CSSValueID::CSSValueDarken:
        case CSSValueID::CSSValueLighten:
        case CSSValueID::CSSValueColorDodge:
        case CSSValueID::CSSValueColorBurn:
        case CSSValueID::CSSValueHardLight:
        case CSSValueID::CSSValueSoftLight:
        case CSSValueID::CSSValueDifference:
        case CSSValueID::CSSValueExclusion:
        case CSSValueID::CSSValueHue:
        case CSSValueID::CSSValueSaturation:
        case CSSValueID::CSSValueColor:
        case CSSValueID::CSSValueLuminosity:
            range.consumeIncludingWhitespace();
            return CSSPrimitiveValue::create(keyword);
        default:
            return nullptr;
        }
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda);
}

static RefPtr<CSSValue> consumeBackgroundImage(CSSParserTokenRange& range, const CSSParserContext& context)
{
    auto lambda = [](CSSParserTokenRange& range, const CSSParserContext& context) -> RefPtr<CSSValue> {
        switch (auto keyword = range.peek().id(); keyword) {
        case CSSValueID::CSSValueNone:
            range.consumeIncludingWhitespace();
            return CSSPrimitiveValue::create(keyword);
        default:
            break;
        }
        return consumeImage(range, context);
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda, context);
}

static RefPtr<CSSValue> consumeBackgroundPositionX(CSSParserTokenRange& range, const CSSParserContext& context)
{
    auto lambda = [](CSSParserTokenRange& range, const CSSParserContext& context) -> RefPtr<CSSValue> {
        return consumePositionX(range, context);
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda, context);
}

static RefPtr<CSSValue> consumeBackgroundPositionY(CSSParserTokenRange& range, const CSSParserContext& context)
{
    auto lambda = [](CSSParserTokenRange& range, const CSSParserContext& context) -> RefPtr<CSSValue> {
        return consumePositionY(range, context);
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda, context);
}

static RefPtr<CSSValue> consumeBackgroundRepeat(CSSParserTokenRange& range, const CSSParserContext& context)
{
    auto lambda = [](CSSParserTokenRange& range, const CSSParserContext& context) -> RefPtr<CSSValue> {
        return consumeRepeatStyle(range, context);
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda, context);
}

static RefPtr<CSSValue> consumeBackgroundSize(CSSParserTokenRange& range, const CSSParserContext& context)
{
    auto lambda = [](CSSParserTokenRange& range, const CSSParserContext& context) -> RefPtr<CSSValue> {
        return consumeSingleBackgroundSize(range, context);
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda, context);
}

static RefPtr<CSSValue> consumeBaselineShift(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForBaselineShift))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::All, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeBlockStepSize(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForBlockStepSize))
        return result;
    return consumeLength(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeBorderImageSource(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForBorderImageSource))
        return result;
    return consumeImage(range, context);
}

static RefPtr<CSSValue> consumeCaretColor(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForCaretColor))
        return result;
    return consumeColor(range, context);
}

static RefPtr<CSSValue> consumeColumnRuleWidth(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForColumnRuleWidth))
        return result;
    return consumeLength(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeFillOpacity(CSSParserTokenRange& range)
{
    if (auto result = consumeNumber(range, ValueRange::All))
        return result;
    return consumePercent(range, ValueRange::All);
}

static RefPtr<CSSValue> consumeFlexBasis(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForFlexBasis))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeFloodOpacity(CSSParserTokenRange& range)
{
    if (auto result = consumeNumber(range, ValueRange::All))
        return result;
    return consumePercent(range, ValueRange::All);
}

static RefPtr<CSSValue> consumeGlyphOrientationVertical(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForGlyphOrientationVertical))
        return result;
    return consumeAngle(range, context.mode, UnitlessQuirk::Allow, UnitlessZeroQuirk::Allow);
}

static RefPtr<CSSValue> consumeHyphenateCharacter(CSSParserTokenRange& range)
{
    if (auto result = consumeIdent(range, isKeywordValidForHyphenateCharacter))
        return result;
    return consumeString(range);
}

static RefPtr<CSSValue> consumeKerning(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForKerning))
        return result;
    return consumeLength(range, context.mode, ValueRange::All, UnitlessQuirk::Allow);
}

static RefPtr<CSSValue> consumeListStyleImage(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForListStyleImage))
        return result;
    return consumeImage(range, context);
}

static RefPtr<CSSValue> consumeMarkerEnd(CSSParserTokenRange& range)
{
    if (auto result = consumeIdent(range, isKeywordValidForMarkerEnd))
        return result;
    return consumeURL(range);
}

static RefPtr<CSSValue> consumeMarkerMid(CSSParserTokenRange& range)
{
    if (auto result = consumeIdent(range, isKeywordValidForMarkerMid))
        return result;
    return consumeURL(range);
}

static RefPtr<CSSValue> consumeMarkerStart(CSSParserTokenRange& range)
{
    if (auto result = consumeIdent(range, isKeywordValidForMarkerStart))
        return result;
    return consumeURL(range);
}

static RefPtr<CSSValue> consumeMaskBorderSource(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForMaskBorderSource))
        return result;
    return consumeImage(range, context);
}

static RefPtr<CSSValue> consumeMaskImage(CSSParserTokenRange& range, const CSSParserContext& context)
{
    auto lambda = [](CSSParserTokenRange& range, const CSSParserContext& context) -> RefPtr<CSSValue> {
        switch (auto keyword = range.peek().id(); keyword) {
        case CSSValueID::CSSValueNone:
            range.consumeIncludingWhitespace();
            return CSSPrimitiveValue::create(keyword);
        default:
            break;
        }
        return consumeImage(range, context);
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda, context);
}

static RefPtr<CSSValue> consumeMaskOrigin(CSSParserTokenRange& range)
{
    auto lambda = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
        switch (auto keyword = range.peek().id(); keyword) {
        case CSSValueID::CSSValueBorderBox:
        case CSSValueID::CSSValuePaddingBox:
        case CSSValueID::CSSValueContentBox:
        case CSSValueID::CSSValueBorder:
        case CSSValueID::CSSValueContent:
        case CSSValueID::CSSValuePadding:
        case CSSValueID::CSSValueWebkitText:
            range.consumeIncludingWhitespace();
            return CSSPrimitiveValue::create(keyword);
        default:
            return nullptr;
        }
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda);
}

static RefPtr<CSSValue> consumeMaskRepeat(CSSParserTokenRange& range, const CSSParserContext& context)
{
    auto lambda = [](CSSParserTokenRange& range, const CSSParserContext& context) -> RefPtr<CSSValue> {
        return consumeRepeatStyle(range, context);
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda, context);
}

static RefPtr<CSSValue> consumeMaskSize(CSSParserTokenRange& range, const CSSParserContext& context)
{
    auto lambda = [](CSSParserTokenRange& range, const CSSParserContext& context) -> RefPtr<CSSValue> {
        return consumeSingleMaskSize(range, context);
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda, context);
}

static RefPtr<CSSValue> consumeOffsetAnchor(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForOffsetAnchor))
        return result;
    return consumePosition(range, context.mode, UnitlessQuirk::Forbid, PositionSyntax::Position);
}

static RefPtr<CSSValue> consumeOffsetPosition(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForOffsetPosition))
        return result;
    return consumePosition(range, context.mode, UnitlessQuirk::Forbid, PositionSyntax::Position);
}

static RefPtr<CSSValue> consumeOpacity(CSSParserTokenRange& range)
{
    if (auto result = consumeNumber(range, ValueRange::All))
        return result;
    return consumePercent(range, ValueRange::All);
}

static RefPtr<CSSValue> consumeOutlineColor(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForOutlineColor))
        return result;
    return consumeColor(range, context);
}

static RefPtr<CSSValue> consumeOutlineWidth(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForOutlineWidth))
        return result;
    return consumeLength(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumePage(CSSParserTokenRange& range)
{
    if (auto result = consumeIdent(range, isKeywordValidForPage))
        return result;
    return consumeCustomIdent(range);
}

static RefPtr<CSSValue> consumeRx(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForRx))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeRy(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForRy))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeStopOpacity(CSSParserTokenRange& range)
{
    if (auto result = consumeNumber(range, ValueRange::All))
        return result;
    return consumePercent(range, ValueRange::All);
}

static RefPtr<CSSValue> consumeStrokeDashoffset(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeLengthOrPercent(range, context.mode, ValueRange::All, UnitlessQuirk::Forbid))
        return result;
    return consumeNumber(range, ValueRange::All);
}

static RefPtr<CSSValue> consumeStrokeOpacity(CSSParserTokenRange& range)
{
    if (auto result = consumeNumber(range, ValueRange::All))
        return result;
    return consumePercent(range, ValueRange::All);
}

static RefPtr<CSSValue> consumeStrokeWidth(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeLengthOrPercent(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid))
        return result;
    return consumeNumber(range, ValueRange::NonNegative);
}

static RefPtr<CSSValue> consumeTabSize(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeNumber(range, ValueRange::NonNegative))
        return result;
    return consumeLength(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeTextDecorationThickness(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForTextDecorationThickness))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::All, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeTextUnderlineOffset(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForTextUnderlineOffset))
        return result;
    return consumeLength(range, context.mode, ValueRange::All, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeTransitionBehavior(CSSParserTokenRange& range)
{
    auto lambda = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
        switch (auto keyword = range.peek().id(); keyword) {
        case CSSValueID::CSSValueNormal:
        case CSSValueID::CSSValueAllowDiscrete:
            range.consumeIncludingWhitespace();
            return CSSPrimitiveValue::create(keyword);
        default:
            return nullptr;
        }
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda);
}

static RefPtr<CSSValue> consumeTransitionDelay(CSSParserTokenRange& range, const CSSParserContext& context)
{
    auto lambda = [](CSSParserTokenRange& range, const CSSParserContext& context) -> RefPtr<CSSValue> {
        return consumeTime(range, context.mode, ValueRange::All, UnitlessQuirk::Forbid);
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda, context);
}

static RefPtr<CSSValue> consumeTransitionDuration(CSSParserTokenRange& range, const CSSParserContext& context)
{
    auto lambda = [](CSSParserTokenRange& range, const CSSParserContext& context) -> RefPtr<CSSValue> {
        return consumeTime(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda, context);
}

static RefPtr<CSSValue> consumeTransitionProperty(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForTransitionProperty))
        return result;
    auto lambda = [](CSSParserTokenRange& range, const CSSParserContext& context) -> RefPtr<CSSValue> {
        return consumeSingleTransitionProperty(range, context);
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda, context);
}

static RefPtr<CSSValue> consumeTransitionTimingFunction(CSSParserTokenRange& range, const CSSParserContext& context)
{
    auto lambda = [](CSSParserTokenRange& range, const CSSParserContext& context) -> RefPtr<CSSValue> {
        return consumeTimingFunction(range, context);
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda, context);
}

static RefPtr<CSSValue> consumeVerticalAlign(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForVerticalAlign))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::All, UnitlessQuirk::Allow);
}

static RefPtr<CSSValue> consumeZIndex(CSSParserTokenRange& range)
{
    if (auto result = consumeIdent(range, isKeywordValidForZIndex))
        return result;
    return consumeInteger(range, IntegerValueRange::All);
}

static RefPtr<CSSValue> consumeWebkitHyphenateLimitAfter(CSSParserTokenRange& range)
{
    if (auto result = consumeIdent(range, isKeywordValidForWebkitHyphenateLimitAfter))
        return result;
    return consumeNumber(range, ValueRange::NonNegative);
}

static RefPtr<CSSValue> consumeWebkitHyphenateLimitBefore(CSSParserTokenRange& range)
{
    if (auto result = consumeIdent(range, isKeywordValidForWebkitHyphenateLimitBefore))
        return result;
    return consumeNumber(range, ValueRange::NonNegative);
}

static RefPtr<CSSValue> consumeWebkitHyphenateLimitLines(CSSParserTokenRange& range)
{
    if (auto result = consumeIdent(range, isKeywordValidForWebkitHyphenateLimitLines))
        return result;
    return consumeNumber(range, ValueRange::NonNegative);
}

static RefPtr<CSSValue> consumeWebkitLineClamp(CSSParserTokenRange& range)
{
    if (auto result = consumePercent(range, ValueRange::NonNegative))
        return result;
    return consumeInteger(range, IntegerValueRange::Positive);
}

static RefPtr<CSSValue> consumeWebkitLineGrid(CSSParserTokenRange& range)
{
    if (auto result = consumeIdent(range, isKeywordValidForWebkitLineGrid))
        return result;
    return consumeCustomIdent(range);
}

static RefPtr<CSSValue> consumeWebkitMaskPositionX(CSSParserTokenRange& range, const CSSParserContext& context)
{
    auto lambda = [](CSSParserTokenRange& range, const CSSParserContext& context) -> RefPtr<CSSValue> {
        return consumePositionX(range, context);
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda, context);
}

static RefPtr<CSSValue> consumeWebkitMaskPositionY(CSSParserTokenRange& range, const CSSParserContext& context)
{
    auto lambda = [](CSSParserTokenRange& range, const CSSParserContext& context) -> RefPtr<CSSValue> {
        return consumePositionY(range, context);
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda, context);
}

static RefPtr<CSSValue> consumeWebkitTextStrokeWidth(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForWebkitTextStrokeWidth))
        return result;
    return consumeLength(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeWordSpacing(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForWordSpacing))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::All, UnitlessQuirk::Allow);
}

static RefPtr<CSSValue> consumeBackgroundClip(CSSParserTokenRange& range)
{
    auto lambda = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
        switch (auto keyword = range.peek().id(); keyword) {
        case CSSValueID::CSSValueBorderBox:
        case CSSValueID::CSSValuePaddingBox:
        case CSSValueID::CSSValueContentBox:
        case CSSValueID::CSSValueText:
        case CSSValueID::CSSValueWebkitText:
            range.consumeIncludingWhitespace();
            return CSSPrimitiveValue::create(keyword);
        default:
            return nullptr;
        }
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda);
}

static RefPtr<CSSValue> consumeBackgroundOrigin(CSSParserTokenRange& range)
{
    auto lambda = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
        switch (auto keyword = range.peek().id(); keyword) {
        case CSSValueID::CSSValueBorderBox:
        case CSSValueID::CSSValuePaddingBox:
        case CSSValueID::CSSValueContentBox:
            range.consumeIncludingWhitespace();
            return CSSPrimitiveValue::create(keyword);
        default:
            return nullptr;
        }
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda);
}

static RefPtr<CSSValue> consumeBlockSize(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForBlockSize))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeBorderBlockEndWidth(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForBorderBlockEndWidth))
        return result;
    return consumeLength(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeBorderBlockStartWidth(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForBorderBlockStartWidth))
        return result;
    return consumeLength(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeBorderInlineEndWidth(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForBorderInlineEndWidth))
        return result;
    return consumeLength(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeBorderInlineStartWidth(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForBorderInlineStartWidth))
        return result;
    return consumeLength(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeHeight(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForHeight))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Allow);
}

static RefPtr<CSSValue> consumeInlineSize(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForInlineSize))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeInsetBlockEnd(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForInsetBlockEnd))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::All, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeInsetBlockStart(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForInsetBlockStart))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::All, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeInsetInlineEnd(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForInsetInlineEnd))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::All, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeInsetInlineStart(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForInsetInlineStart))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::All, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeMarginBlockEnd(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForMarginBlockEnd))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::All, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeMarginBlockStart(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForMarginBlockStart))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::All, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeMarginInlineEnd(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForMarginInlineEnd))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::All, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeMarginInlineStart(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForMarginInlineStart))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::All, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeMaskClip(CSSParserTokenRange& range)
{
    auto lambda = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
        switch (auto keyword = range.peek().id(); keyword) {
        case CSSValueID::CSSValueBorderBox:
        case CSSValueID::CSSValuePaddingBox:
        case CSSValueID::CSSValueContentBox:
        case CSSValueID::CSSValueNoClip:
            range.consumeIncludingWhitespace();
            return CSSPrimitiveValue::create(keyword);
        default:
            return nullptr;
        }
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda);
}

static RefPtr<CSSValue> consumeMaskComposite(CSSParserTokenRange& range)
{
    auto lambda = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
        switch (auto keyword = range.peek().id(); keyword) {
        case CSSValueID::CSSValueAdd:
        case CSSValueID::CSSValueSubtract:
        case CSSValueID::CSSValueIntersect:
        case CSSValueID::CSSValueExclude:
            range.consumeIncludingWhitespace();
            return CSSPrimitiveValue::create(keyword);
        default:
            return nullptr;
        }
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda);
}

static RefPtr<CSSValue> consumeMaskMode(CSSParserTokenRange& range)
{
    auto lambda = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
        switch (auto keyword = range.peek().id(); keyword) {
        case CSSValueID::CSSValueAlpha:
        case CSSValueID::CSSValueLuminance:
        case CSSValueID::CSSValueMatchSource:
            range.consumeIncludingWhitespace();
            return CSSPrimitiveValue::create(keyword);
        default:
            return nullptr;
        }
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda);
}

static RefPtr<CSSValue> consumeMaxBlockSize(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForMaxBlockSize))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeMaxHeight(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForMaxHeight))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Allow);
}

static RefPtr<CSSValue> consumeMaxInlineSize(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForMaxInlineSize))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeMaxWidth(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForMaxWidth))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Allow);
}

static RefPtr<CSSValue> consumeMinBlockSize(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForMinBlockSize))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeMinHeight(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForMinHeight))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Allow);
}

static RefPtr<CSSValue> consumeMinInlineSize(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForMinInlineSize))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeMinWidth(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForMinWidth))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Allow);
}

static RefPtr<CSSValue> consumeScrollPaddingBlockEnd(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForScrollPaddingBlockEnd))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeScrollPaddingBlockStart(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForScrollPaddingBlockStart))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeScrollPaddingBottom(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForScrollPaddingBottom))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeScrollPaddingInlineEnd(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForScrollPaddingInlineEnd))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeScrollPaddingInlineStart(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForScrollPaddingInlineStart))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeScrollPaddingLeft(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForScrollPaddingLeft))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeScrollPaddingRight(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForScrollPaddingRight))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeScrollPaddingTop(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForScrollPaddingTop))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

static RefPtr<CSSValue> consumeWidth(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForWidth))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Allow);
}

static RefPtr<CSSValue> consumeWebkitBackgroundClip(CSSParserTokenRange& range)
{
    auto lambda = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
        switch (auto keyword = range.peek().id(); keyword) {
        case CSSValueID::CSSValueBorderBox:
        case CSSValueID::CSSValuePaddingBox:
        case CSSValueID::CSSValueContentBox:
        case CSSValueID::CSSValueBorder:
        case CSSValueID::CSSValueContent:
        case CSSValueID::CSSValuePadding:
        case CSSValueID::CSSValueWebkitText:
        case CSSValueID::CSSValueText:
            range.consumeIncludingWhitespace();
            return CSSPrimitiveValue::create(keyword);
        default:
            return nullptr;
        }
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda);
}

static RefPtr<CSSValue> consumeWebkitBackgroundOrigin(CSSParserTokenRange& range)
{
    auto lambda = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
        switch (auto keyword = range.peek().id(); keyword) {
        case CSSValueID::CSSValueBorderBox:
        case CSSValueID::CSSValuePaddingBox:
        case CSSValueID::CSSValueContentBox:
        case CSSValueID::CSSValueBorder:
        case CSSValueID::CSSValueContent:
        case CSSValueID::CSSValuePadding:
        case CSSValueID::CSSValueWebkitText:
            range.consumeIncludingWhitespace();
            return CSSPrimitiveValue::create(keyword);
        default:
            return nullptr;
        }
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda);
}

static RefPtr<CSSValue> consumeWebkitMaskClip(CSSParserTokenRange& range)
{
    auto lambda = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
        switch (auto keyword = range.peek().id(); keyword) {
        case CSSValueID::CSSValueBorderBox:
        case CSSValueID::CSSValuePaddingBox:
        case CSSValueID::CSSValueContentBox:
        case CSSValueID::CSSValueBorder:
        case CSSValueID::CSSValueContent:
        case CSSValueID::CSSValuePadding:
        case CSSValueID::CSSValueWebkitText:
        case CSSValueID::CSSValueText:
            range.consumeIncludingWhitespace();
            return CSSPrimitiveValue::create(keyword);
        default:
            return nullptr;
        }
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda);
}

static RefPtr<CSSValue> consumeWebkitMaskComposite(CSSParserTokenRange& range)
{
    auto lambda = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
        switch (auto keyword = range.peek().id(); keyword) {
        case CSSValueID::CSSValueClear:
        case CSSValueID::CSSValueCopy:
        case CSSValueID::CSSValueSourceOver:
        case CSSValueID::CSSValueSourceIn:
        case CSSValueID::CSSValueSourceOut:
        case CSSValueID::CSSValueSourceAtop:
        case CSSValueID::CSSValueDestinationOver:
        case CSSValueID::CSSValueDestinationIn:
        case CSSValueID::CSSValueDestinationOut:
        case CSSValueID::CSSValueDestinationAtop:
        case CSSValueID::CSSValueXor:
        case CSSValueID::CSSValuePlusDarker:
        case CSSValueID::CSSValuePlusLighter:
            range.consumeIncludingWhitespace();
            return CSSPrimitiveValue::create(keyword);
        default:
            return nullptr;
        }
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda);
}

static RefPtr<CSSValue> consumeWebkitMaskSourceType(CSSParserTokenRange& range)
{
    auto lambda = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
        switch (auto keyword = range.peek().id(); keyword) {
        case CSSValueID::CSSValueAuto:
        case CSSValueID::CSSValueAlpha:
        case CSSValueID::CSSValueLuminance:
            range.consumeIncludingWhitespace();
            return CSSPrimitiveValue::create(keyword);
        default:
            return nullptr;
        }
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda);
}

static RefPtr<CSSValue> consumeFontFaceFontFeatureSettings(CSSParserTokenRange& range)
{
    if (auto result = consumeIdent(range, isKeywordValidForFontFaceFontFeatureSettings))
        return result;
    auto lambda = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
        return consumeFeatureTagValue(range);
    };
    return consumeCommaSeparatedListWithoutSingleValueOptimization(range, lambda);
}

static RefPtr<CSSValue> consumeFontPaletteValuesBasePalette(CSSParserTokenRange& range)
{
    if (auto result = consumeIdent(range, isKeywordValidForFontPaletteValuesBasePalette))
        return result;
    return consumeInteger(range, IntegerValueRange::NonNegative);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeFontSize(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForFontSize))
        return result;
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueWebkitXxxLarge:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(CSSValueID::CSSValueXxxLarge);
    default:
        break;
    }
    return consumeLengthOrPercent(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Allow);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeFontVariantCaps(CSSParserTokenRange& range)
{
    return consumeIdent(range, isKeywordValidForFontVariantCaps);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeFontVariantEmoji(CSSParserTokenRange& range)
{
    return consumeIdent(range, isKeywordValidForFontVariantEmoji);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeFontVariantPosition(CSSParserTokenRange& range)
{
    return consumeIdent(range, isKeywordValidForFontVariantPosition);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeColumnCount(CSSParserTokenRange& range)
{
    if (auto result = consumeIdent(range, isKeywordValidForColumnCount))
        return result;
    return consumeInteger(range, IntegerValueRange::Positive);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeColumnGap(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForColumnGap))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeColumnWidth(CSSParserTokenRange& range)
{
    if (auto result = consumeIdent(range, isKeywordValidForColumnWidth))
        return result;
    return consumeLength(range, HTMLStandardMode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeLineHeight(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForLineHeight))
        return result;
    if (auto result = consumeNumber(range, ValueRange::NonNegative))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

RefPtr<CSSValue> CSSPropertyParsing::consumePerspective(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForPerspective))
        return result;
    return consumeLength(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeRowGap(CSSParserTokenRange& range, const CSSParserContext& context)
{
    if (auto result = consumeIdent(range, isKeywordValidForRowGap))
        return result;
    return consumeLengthOrPercent(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeScrollTimelineAxis(CSSParserTokenRange& range)
{
    auto lambda = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
        switch (auto keyword = range.peek().id(); keyword) {
        case CSSValueID::CSSValueBlock:
        case CSSValueID::CSSValueInline:
        case CSSValueID::CSSValueX:
        case CSSValueID::CSSValueY:
            range.consumeIncludingWhitespace();
            return CSSPrimitiveValue::create(keyword);
        default:
            return nullptr;
        }
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeScrollTimelineName(CSSParserTokenRange& range)
{
    auto lambda = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
        switch (auto keyword = range.peek().id(); keyword) {
        case CSSValueID::CSSValueNone:
            range.consumeIncludingWhitespace();
            return CSSPrimitiveValue::create(keyword);
        default:
            break;
        }
        return consumeDashedIdent(range);
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeTextWrapMode(CSSParserTokenRange& range)
{
    return consumeIdent(range, isKeywordValidForTextWrapMode);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeTextWrapStyle(CSSParserTokenRange& range, const CSSParserContext& context)
{
    return consumeIdent(range, isKeywordValidForTextWrapStyle, context);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeViewTimelineAxis(CSSParserTokenRange& range)
{
    auto lambda = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
        switch (auto keyword = range.peek().id(); keyword) {
        case CSSValueID::CSSValueBlock:
        case CSSValueID::CSSValueInline:
        case CSSValueID::CSSValueX:
        case CSSValueID::CSSValueY:
            range.consumeIncludingWhitespace();
            return CSSPrimitiveValue::create(keyword);
        default:
            return nullptr;
        }
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeViewTimelineName(CSSParserTokenRange& range)
{
    auto lambda = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
        switch (auto keyword = range.peek().id(); keyword) {
        case CSSValueID::CSSValueNone:
            range.consumeIncludingWhitespace();
            return CSSPrimitiveValue::create(keyword);
        default:
            break;
        }
        return consumeDashedIdent(range);
    };
    return consumeCommaSeparatedListWithSingleValueOptimization(range, lambda);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeWhiteSpaceCollapse(CSSParserTokenRange& range)
{
    return consumeIdent(range, isKeywordValidForWhiteSpaceCollapse);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeOverscrollBehaviorX(CSSParserTokenRange& range)
{
    return consumeIdent(range, isKeywordValidForOverscrollBehaviorX);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeOverscrollBehaviorY(CSSParserTokenRange& range)
{
    return consumeIdent(range, isKeywordValidForOverscrollBehaviorY);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeFontFaceFontDisplay(CSSParserTokenRange& range)
{
    return consumeIdent(range, isKeywordValidForFontFaceFontDisplay);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeAxis(CSSParserTokenRange& range)
{
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueBlock:
    case CSSValueID::CSSValueInline:
    case CSSValueID::CSSValueX:
    case CSSValueID::CSSValueY:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(keyword);
    default:
        return nullptr;
    }
}

RefPtr<CSSValue> CSSPropertyParsing::consumeGeometryBox(CSSParserTokenRange& range)
{
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueBorderBox:
    case CSSValueID::CSSValuePaddingBox:
    case CSSValueID::CSSValueContentBox:
    case CSSValueID::CSSValueMarginBox:
    case CSSValueID::CSSValueFillBox:
    case CSSValueID::CSSValueStrokeBox:
    case CSSValueID::CSSValueViewBox:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(keyword);
    default:
        return nullptr;
    }
}

RefPtr<CSSValue> CSSPropertyParsing::consumeLineWidth(CSSParserTokenRange& range, const CSSParserContext& context)
{
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueThin:
    case CSSValueID::CSSValueMedium:
    case CSSValueID::CSSValueThick:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(keyword);
    default:
        break;
    }
    return consumeLength(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

RefPtr<CSSValue> CSSPropertyParsing::consumePageSize(CSSParserTokenRange& range)
{
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueA5:
    case CSSValueID::CSSValueA4:
    case CSSValueID::CSSValueA3:
    case CSSValueID::CSSValueB5:
    case CSSValueID::CSSValueB4:
    case CSSValueID::CSSValueLetter:
    case CSSValueID::CSSValueLegal:
    case CSSValueID::CSSValueLedger:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(keyword);
    default:
        return nullptr;
    }
}

RefPtr<CSSValue> CSSPropertyParsing::consumeScroller(CSSParserTokenRange& range)
{
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueRoot:
    case CSSValueID::CSSValueNearest:
    case CSSValueID::CSSValueSelf:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(keyword);
    default:
        return nullptr;
    }
}

RefPtr<CSSValue> CSSPropertyParsing::consumeShapeBox(CSSParserTokenRange& range)
{
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueBorderBox:
    case CSSValueID::CSSValuePaddingBox:
    case CSSValueID::CSSValueContentBox:
    case CSSValueID::CSSValueMarginBox:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(keyword);
    default:
        return nullptr;
    }
}

RefPtr<CSSValue> CSSPropertyParsing::consumeSingleAnimationComposition(CSSParserTokenRange& range)
{
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueReplace:
    case CSSValueID::CSSValueAdd:
    case CSSValueID::CSSValueAccumulate:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(keyword);
    default:
        return nullptr;
    }
}

RefPtr<CSSValue> CSSPropertyParsing::consumeSingleAnimationDirection(CSSParserTokenRange& range)
{
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueNormal:
    case CSSValueID::CSSValueReverse:
    case CSSValueID::CSSValueAlternate:
    case CSSValueID::CSSValueAlternateReverse:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(keyword);
    default:
        return nullptr;
    }
}

RefPtr<CSSValue> CSSPropertyParsing::consumeSingleAnimationFillMode(CSSParserTokenRange& range)
{
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueNone:
    case CSSValueID::CSSValueForwards:
    case CSSValueID::CSSValueBackwards:
    case CSSValueID::CSSValueBoth:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(keyword);
    default:
        return nullptr;
    }
}

RefPtr<CSSValue> CSSPropertyParsing::consumeSingleAnimationIterationCount(CSSParserTokenRange& range)
{
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueInfinite:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(keyword);
    default:
        break;
    }
    return consumeNumber(range, ValueRange::NonNegative);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeSingleAnimationName(CSSParserTokenRange& range, const CSSParserContext& context)
{
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueNone:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(keyword);
    default:
        break;
    }
    return consumeKeyframesName(range, context);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeSingleAnimationPlayState(CSSParserTokenRange& range)
{
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueRunning:
    case CSSValueID::CSSValuePaused:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(keyword);
    default:
        return nullptr;
    }
}

RefPtr<CSSValue> CSSPropertyParsing::consumeSingleBackgroundAttachment(CSSParserTokenRange& range)
{
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueScroll:
    case CSSValueID::CSSValueFixed:
    case CSSValueID::CSSValueLocal:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(keyword);
    default:
        return nullptr;
    }
}

RefPtr<CSSValue> CSSPropertyParsing::consumeSingleBackgroundBlendMode(CSSParserTokenRange& range)
{
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueNormal:
    case CSSValueID::CSSValueMultiply:
    case CSSValueID::CSSValueScreen:
    case CSSValueID::CSSValueOverlay:
    case CSSValueID::CSSValueDarken:
    case CSSValueID::CSSValueLighten:
    case CSSValueID::CSSValueColorDodge:
    case CSSValueID::CSSValueColorBurn:
    case CSSValueID::CSSValueHardLight:
    case CSSValueID::CSSValueSoftLight:
    case CSSValueID::CSSValueDifference:
    case CSSValueID::CSSValueExclusion:
    case CSSValueID::CSSValueHue:
    case CSSValueID::CSSValueSaturation:
    case CSSValueID::CSSValueColor:
    case CSSValueID::CSSValueLuminosity:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(keyword);
    default:
        return nullptr;
    }
}

RefPtr<CSSValue> CSSPropertyParsing::consumeSingleBackgroundClip(CSSParserTokenRange& range)
{
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueBorderBox:
    case CSSValueID::CSSValuePaddingBox:
    case CSSValueID::CSSValueContentBox:
    case CSSValueID::CSSValueText:
    case CSSValueID::CSSValueWebkitText:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(keyword);
    default:
        return nullptr;
    }
}

RefPtr<CSSValue> CSSPropertyParsing::consumeSingleBackgroundImage(CSSParserTokenRange& range, const CSSParserContext& context)
{
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueNone:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(keyword);
    default:
        break;
    }
    return consumeImage(range, context);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeSingleBackgroundOrigin(CSSParserTokenRange& range)
{
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueBorderBox:
    case CSSValueID::CSSValuePaddingBox:
    case CSSValueID::CSSValueContentBox:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(keyword);
    default:
        return nullptr;
    }
}

RefPtr<CSSValue> CSSPropertyParsing::consumeSingleBackgroundPositionX(CSSParserTokenRange& range, const CSSParserContext& context)
{
    return consumePositionX(range, context);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeSingleBackgroundPositionY(CSSParserTokenRange& range, const CSSParserContext& context)
{
    return consumePositionY(range, context);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeSingleBackgroundRepeat(CSSParserTokenRange& range, const CSSParserContext& context)
{
    return consumeRepeatStyle(range, context);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeSingleMaskClip(CSSParserTokenRange& range)
{
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueBorderBox:
    case CSSValueID::CSSValuePaddingBox:
    case CSSValueID::CSSValueContentBox:
    case CSSValueID::CSSValueNoClip:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(keyword);
    default:
        return nullptr;
    }
}

RefPtr<CSSValue> CSSPropertyParsing::consumeSingleMaskComposite(CSSParserTokenRange& range)
{
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueAdd:
    case CSSValueID::CSSValueSubtract:
    case CSSValueID::CSSValueIntersect:
    case CSSValueID::CSSValueExclude:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(keyword);
    default:
        return nullptr;
    }
}

RefPtr<CSSValue> CSSPropertyParsing::consumeSingleMaskImage(CSSParserTokenRange& range, const CSSParserContext& context)
{
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueNone:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(keyword);
    default:
        break;
    }
    return consumeImage(range, context);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeSingleMaskMode(CSSParserTokenRange& range)
{
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueAlpha:
    case CSSValueID::CSSValueLuminance:
    case CSSValueID::CSSValueMatchSource:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(keyword);
    default:
        return nullptr;
    }
}

RefPtr<CSSValue> CSSPropertyParsing::consumeSingleMaskOrigin(CSSParserTokenRange& range)
{
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueBorderBox:
    case CSSValueID::CSSValuePaddingBox:
    case CSSValueID::CSSValueContentBox:
    case CSSValueID::CSSValueBorder:
    case CSSValueID::CSSValueContent:
    case CSSValueID::CSSValuePadding:
    case CSSValueID::CSSValueWebkitText:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(keyword);
    default:
        return nullptr;
    }
}

RefPtr<CSSValue> CSSPropertyParsing::consumeSingleMaskRepeat(CSSParserTokenRange& range, const CSSParserContext& context)
{
    return consumeRepeatStyle(range, context);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeSingleScrollTimelineName(CSSParserTokenRange& range)
{
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueNone:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(keyword);
    default:
        break;
    }
    return consumeDashedIdent(range);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeSingleViewTimelineInset(CSSParserTokenRange& range, const CSSParserContext& context)
{
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueAuto:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(keyword);
    default:
        break;
    }
    return consumeLengthOrPercent(range, context.mode, ValueRange::All, UnitlessQuirk::Forbid);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeSingleWebkitBackgroundClip(CSSParserTokenRange& range)
{
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueBorderBox:
    case CSSValueID::CSSValuePaddingBox:
    case CSSValueID::CSSValueContentBox:
    case CSSValueID::CSSValueBorder:
    case CSSValueID::CSSValueContent:
    case CSSValueID::CSSValuePadding:
    case CSSValueID::CSSValueWebkitText:
    case CSSValueID::CSSValueText:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(keyword);
    default:
        return nullptr;
    }
}

RefPtr<CSSValue> CSSPropertyParsing::consumeSingleWebkitBackgroundOrigin(CSSParserTokenRange& range)
{
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueBorderBox:
    case CSSValueID::CSSValuePaddingBox:
    case CSSValueID::CSSValueContentBox:
    case CSSValueID::CSSValueBorder:
    case CSSValueID::CSSValueContent:
    case CSSValueID::CSSValuePadding:
    case CSSValueID::CSSValueWebkitText:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(keyword);
    default:
        return nullptr;
    }
}

RefPtr<CSSValue> CSSPropertyParsing::consumeSingleWebkitMaskClip(CSSParserTokenRange& range)
{
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueBorderBox:
    case CSSValueID::CSSValuePaddingBox:
    case CSSValueID::CSSValueContentBox:
    case CSSValueID::CSSValueBorder:
    case CSSValueID::CSSValueContent:
    case CSSValueID::CSSValuePadding:
    case CSSValueID::CSSValueWebkitText:
    case CSSValueID::CSSValueText:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(keyword);
    default:
        return nullptr;
    }
}

RefPtr<CSSValue> CSSPropertyParsing::consumeSingleWebkitMaskComposite(CSSParserTokenRange& range)
{
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueClear:
    case CSSValueID::CSSValueCopy:
    case CSSValueID::CSSValueSourceOver:
    case CSSValueID::CSSValueSourceIn:
    case CSSValueID::CSSValueSourceOut:
    case CSSValueID::CSSValueSourceAtop:
    case CSSValueID::CSSValueDestinationOver:
    case CSSValueID::CSSValueDestinationIn:
    case CSSValueID::CSSValueDestinationOut:
    case CSSValueID::CSSValueDestinationAtop:
    case CSSValueID::CSSValueXor:
    case CSSValueID::CSSValuePlusDarker:
    case CSSValueID::CSSValuePlusLighter:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(keyword);
    default:
        return nullptr;
    }
}

RefPtr<CSSValue> CSSPropertyParsing::consumeSingleWebkitMaskPositionX(CSSParserTokenRange& range, const CSSParserContext& context)
{
    return consumePositionX(range, context);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeSingleWebkitMaskPositionY(CSSParserTokenRange& range, const CSSParserContext& context)
{
    return consumePositionY(range, context);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeSingleWebkitMaskSourceType(CSSParserTokenRange& range)
{
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueAlpha:
    case CSSValueID::CSSValueLuminance:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(keyword);
    default:
        return nullptr;
    }
}

RefPtr<CSSValue> CSSPropertyParsing::consumeTransitionBehaviorValue(CSSParserTokenRange& range)
{
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueNormal:
    case CSSValueID::CSSValueAllowDiscrete:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(keyword);
    default:
        return nullptr;
    }
}

RefPtr<CSSValue> CSSPropertyParsing::consumeWidthOrHeight(CSSParserTokenRange& range, const CSSParserContext& context)
{
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueAuto:
    case CSSValueID::CSSValueIntrinsic:
    case CSSValueID::CSSValueMinIntrinsic:
    case CSSValueID::CSSValueMinContent:
    case CSSValueID::CSSValueWebkitMinContent:
    case CSSValueID::CSSValueMaxContent:
    case CSSValueID::CSSValueWebkitMaxContent:
    case CSSValueID::CSSValueWebkitFillAvailable:
    case CSSValueID::CSSValueFitContent:
    case CSSValueID::CSSValueWebkitFitContent:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(keyword);
    default:
        break;
    }
    return consumeLengthOrPercent(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
}

RefPtr<CSSValue> CSSPropertyParsing::parseStyleProperty(CSSParserTokenRange& range, CSSPropertyID id, CSSPropertyID currentShorthand, const CSSParserContext& context)
{
    if (!isExposed(id, context.propertySettings) && !isInternal(id)) {
        // Allow internal properties as we use them to parse several internal-only-shorthands (e.g. background-repeat),
        // and to handle certain DOM-exposed values (e.g. -webkit-font-size-delta from execCommand('FontSizeDelta')).
        ASSERT_NOT_REACHED();
        return nullptr;
    }
    switch (id) {
    case CSSPropertyID::CSSPropertyColorScheme:
        return consumeColorScheme(range);
    case CSSPropertyID::CSSPropertyWritingMode:
        return consumeIdent(range, isKeywordValidForWritingMode, context);
    case CSSPropertyID::CSSPropertyWebkitRubyPosition:
        return consumeIdent(range, isKeywordValidForWebkitRubyPosition);
    case CSSPropertyID::CSSPropertyColor:
    case CSSPropertyID::CSSPropertyBackgroundColor:
        return consumeColor(range, context, context.mode == HTMLQuirksMode);
    case CSSPropertyID::CSSPropertyDirection:
        return consumeIdent(range, isKeywordValidForDirection);
    case CSSPropertyID::CSSPropertyDisplay:
        return consumeDisplay(range, context.mode);
    case CSSPropertyID::CSSPropertyFontFamily:
        return consumeFontFamily(range);
    case CSSPropertyID::CSSPropertyFontFeatureSettings:
        return consumeFontFeatureSettings(range);
    case CSSPropertyID::CSSPropertyFontKerning:
        return consumeIdent(range, isKeywordValidForFontKerning);
    case CSSPropertyID::CSSPropertyFontOpticalSizing:
        return consumeIdent(range, isKeywordValidForFontOpticalSizing);
    case CSSPropertyID::CSSPropertyFontPalette:
        return consumeFontPalette(range);
    case CSSPropertyID::CSSPropertyFontSize:
        return CSSPropertyParsing::consumeFontSize(range, context);
    case CSSPropertyID::CSSPropertyFontSizeAdjust:
        return consumeFontSizeAdjust(range);
    case CSSPropertyID::CSSPropertyFontStretch:
        return consumeFontStretch(range);
    case CSSPropertyID::CSSPropertyFontStyle:
        return consumeFontStyle(range, context.mode);
    case CSSPropertyID::CSSPropertyFontSynthesisSmallCaps:
        return consumeIdent(range, isKeywordValidForFontSynthesisSmallCaps);
    case CSSPropertyID::CSSPropertyFontSynthesisStyle:
        return consumeIdent(range, isKeywordValidForFontSynthesisStyle);
    case CSSPropertyID::CSSPropertyFontSynthesisWeight:
        return consumeIdent(range, isKeywordValidForFontSynthesisWeight);
    case CSSPropertyID::CSSPropertyFontVariantAlternates:
        return consumeFontVariantAlternates(range);
    case CSSPropertyID::CSSPropertyFontVariantCaps:
        return consumeIdent(range, isKeywordValidForFontVariantCaps);
    case CSSPropertyID::CSSPropertyFontVariantEastAsian:
        return consumeFontVariantEastAsian(range);
    case CSSPropertyID::CSSPropertyFontVariantEmoji:
        return consumeIdent(range, isKeywordValidForFontVariantEmoji);
    case CSSPropertyID::CSSPropertyFontVariantLigatures:
        return consumeFontVariantLigatures(range);
    case CSSPropertyID::CSSPropertyFontVariantNumeric:
        return consumeFontVariantNumeric(range);
    case CSSPropertyID::CSSPropertyFontVariantPosition:
        return consumeIdent(range, isKeywordValidForFontVariantPosition);
    case CSSPropertyID::CSSPropertyFontVariationSettings:
        return consumeFontVariationSettings(range);
    case CSSPropertyID::CSSPropertyFontWeight:
        return consumeFontWeight(range);
    case CSSPropertyID::CSSPropertyTextOrientation:
        return consumeIdent(range, isKeywordValidForTextOrientation);
    case CSSPropertyID::CSSPropertyTextRendering:
        return consumeIdent(range, isKeywordValidForTextRendering);
    case CSSPropertyID::CSSPropertyZoom:
        return consumeZoom(range);
    case CSSPropertyID::CSSPropertyWebkitFontSmoothing:
        return consumeIdent(range, isKeywordValidForWebkitFontSmoothing);
    case CSSPropertyID::CSSPropertyWebkitLocale:
        return consumeWebkitLocale(range);
    case CSSPropertyID::CSSPropertyWebkitTextZoom:
        return consumeIdent(range, isKeywordValidForWebkitTextZoom);
    case CSSPropertyID::CSSPropertyLetterSpacing:
        return consumeLetterSpacing(range, context);
    case CSSPropertyID::CSSPropertyTextAutospace:
        return consumeTextAutospace(range);
    case CSSPropertyID::CSSPropertyTextSpacingTrim:
        return consumeTextSpacingTrim(range);
    case CSSPropertyID::CSSPropertyAccentColor:
        return consumeAccentColor(range, context);
    case CSSPropertyID::CSSPropertyAlignContent:
        return consumeContentDistributionOverflowPosition(range, isContentPositionKeyword);
    case CSSPropertyID::CSSPropertyAlignItems:
        return consumeAlignItems(range);
    case CSSPropertyID::CSSPropertyAlignSelf:
        return consumeSelfPositionOverflowPosition(range, isSelfPositionKeyword);
    case CSSPropertyID::CSSPropertyAlignmentBaseline:
        return consumeIdent(range, isKeywordValidForAlignmentBaseline);
    case CSSPropertyID::CSSPropertyAnimationComposition:
        return consumeAnimationComposition(range);
    case CSSPropertyID::CSSPropertyAnimationDelay:
        return consumeAnimationDelay(range, context);
    case CSSPropertyID::CSSPropertyAnimationDirection:
        return consumeAnimationDirection(range);
    case CSSPropertyID::CSSPropertyAnimationDuration:
        return consumeAnimationDuration(range, context);
    case CSSPropertyID::CSSPropertyAnimationFillMode:
        return consumeAnimationFillMode(range);
    case CSSPropertyID::CSSPropertyAnimationIterationCount:
        return consumeAnimationIterationCount(range);
    case CSSPropertyID::CSSPropertyAnimationName:
        return consumeAnimationName(range, context);
    case CSSPropertyID::CSSPropertyAnimationPlayState:
        return consumeAnimationPlayState(range);
    case CSSPropertyID::CSSPropertyAnimationTimeline:
        return consumeAnimationTimeline(range, context);
    case CSSPropertyID::CSSPropertyAnimationTimingFunction:
        return consumeAnimationTimingFunction(range, context);
    case CSSPropertyID::CSSPropertyAppearance:
        return consumeIdent(range, isKeywordValidForAppearance, context);
    case CSSPropertyID::CSSPropertyAspectRatio:
        return consumeAspectRatio(range);
    case CSSPropertyID::CSSPropertyBackfaceVisibility:
        return consumeIdent(range, isKeywordValidForBackfaceVisibility);
    case CSSPropertyID::CSSPropertyBackgroundAttachment:
        return consumeBackgroundAttachment(range);
    case CSSPropertyID::CSSPropertyBackgroundBlendMode:
        return consumeBackgroundBlendMode(range);
    case CSSPropertyID::CSSPropertyBackgroundImage:
        return consumeBackgroundImage(range, context);
    case CSSPropertyID::CSSPropertyBackgroundPositionX:
        return consumeBackgroundPositionX(range, context);
    case CSSPropertyID::CSSPropertyBackgroundPositionY:
        return consumeBackgroundPositionY(range, context);
    case CSSPropertyID::CSSPropertyBackgroundRepeat:
        return consumeBackgroundRepeat(range, context);
    case CSSPropertyID::CSSPropertyBackgroundSize:
        return consumeBackgroundSize(range, context);
    case CSSPropertyID::CSSPropertyBaselineShift:
        return consumeBaselineShift(range, context);
    case CSSPropertyID::CSSPropertyBlockStepInsert:
        return consumeIdent(range, isKeywordValidForBlockStepInsert);
    case CSSPropertyID::CSSPropertyBlockStepSize:
        return consumeBlockStepSize(range, context);
    case CSSPropertyID::CSSPropertyBorderCollapse:
        return consumeIdent(range, isKeywordValidForBorderCollapse);
    case CSSPropertyID::CSSPropertyBorderImageOutset:
    case CSSPropertyID::CSSPropertyMaskBorderOutset:
        return consumeBorderImageOutset(range);
    case CSSPropertyID::CSSPropertyBorderImageRepeat:
    case CSSPropertyID::CSSPropertyMaskBorderRepeat:
        return consumeBorderImageRepeat(range);
    case CSSPropertyID::CSSPropertyBorderImageSlice:
    case CSSPropertyID::CSSPropertyMaskBorderSlice:
        return consumeBorderImageSlice(id, range);
    case CSSPropertyID::CSSPropertyBorderImageSource:
        return consumeBorderImageSource(range, context);
    case CSSPropertyID::CSSPropertyBorderImageWidth:
    case CSSPropertyID::CSSPropertyMaskBorderWidth:
        return consumeBorderImageWidth(id, range);
    case CSSPropertyID::CSSPropertyBoxSizing:
        return consumeIdent(range, isKeywordValidForBoxSizing);
    case CSSPropertyID::CSSPropertyBreakAfter:
        return consumeIdent(range, isKeywordValidForBreakAfter);
    case CSSPropertyID::CSSPropertyBreakBefore:
        return consumeIdent(range, isKeywordValidForBreakBefore);
    case CSSPropertyID::CSSPropertyBreakInside:
        return consumeIdent(range, isKeywordValidForBreakInside);
    case CSSPropertyID::CSSPropertyBufferedRendering:
        return consumeIdent(range, isKeywordValidForBufferedRendering);
    case CSSPropertyID::CSSPropertyCaptionSide:
        return consumeIdent(range, isKeywordValidForCaptionSide);
    case CSSPropertyID::CSSPropertyCaretColor:
        return consumeCaretColor(range, context);
    case CSSPropertyID::CSSPropertyClear:
        return consumeIdent(range, isKeywordValidForClear);
    case CSSPropertyID::CSSPropertyClip:
        return consumeClip(range, context.mode);
    case CSSPropertyID::CSSPropertyClipPath:
        return consumePathOperation(range, context, RejectRay);
    case CSSPropertyID::CSSPropertyClipRule:
        return consumeIdent(range, isKeywordValidForClipRule);
    case CSSPropertyID::CSSPropertyColorInterpolation:
        return consumeIdent(range, isKeywordValidForColorInterpolation);
    case CSSPropertyID::CSSPropertyColorInterpolationFilters:
        return consumeIdent(range, isKeywordValidForColorInterpolationFilters);
    case CSSPropertyID::CSSPropertyColumnCount:
        return CSSPropertyParsing::consumeColumnCount(range);
    case CSSPropertyID::CSSPropertyColumnFill:
        return consumeIdent(range, isKeywordValidForColumnFill);
    case CSSPropertyID::CSSPropertyColumnGap:
        return CSSPropertyParsing::consumeColumnGap(range, context);
    case CSSPropertyID::CSSPropertyColumnRuleColor:
    case CSSPropertyID::CSSPropertyFloodColor:
    case CSSPropertyID::CSSPropertyLightingColor:
    case CSSPropertyID::CSSPropertyStopColor:
    case CSSPropertyID::CSSPropertyStrokeColor:
    case CSSPropertyID::CSSPropertyTextDecorationColor:
    case CSSPropertyID::CSSPropertyTextEmphasisColor:
    case CSSPropertyID::CSSPropertyWebkitTapHighlightColor:
    case CSSPropertyID::CSSPropertyWebkitTextFillColor:
    case CSSPropertyID::CSSPropertyWebkitTextStrokeColor:
    case CSSPropertyID::CSSPropertyBorderBlockEndColor:
    case CSSPropertyID::CSSPropertyBorderBlockStartColor:
    case CSSPropertyID::CSSPropertyBorderInlineEndColor:
    case CSSPropertyID::CSSPropertyBorderInlineStartColor:
        return consumeColor(range, context);
    case CSSPropertyID::CSSPropertyColumnRuleStyle:
        return consumeIdent(range, isKeywordValidForColumnRuleStyle);
    case CSSPropertyID::CSSPropertyColumnRuleWidth:
        return consumeColumnRuleWidth(range, context);
    case CSSPropertyID::CSSPropertyColumnSpan:
        return consumeIdent(range, isKeywordValidForColumnSpan);
    case CSSPropertyID::CSSPropertyColumnWidth:
        return CSSPropertyParsing::consumeColumnWidth(range);
    case CSSPropertyID::CSSPropertyContain:
        return consumeContain(range);
    case CSSPropertyID::CSSPropertyContainerName:
        return consumeContainerName(range);
    case CSSPropertyID::CSSPropertyContainerType:
        return consumeIdent(range, isKeywordValidForContainerType);
    case CSSPropertyID::CSSPropertyContent:
        return consumeContent(range, context);
    case CSSPropertyID::CSSPropertyContentVisibility:
        return consumeIdent(range, isKeywordValidForContentVisibility);
    case CSSPropertyID::CSSPropertyCounterIncrement:
        return consumeCounterIncrement(range);
    case CSSPropertyID::CSSPropertyCounterReset:
        return consumeCounterReset(range);
    case CSSPropertyID::CSSPropertyCounterSet:
        return consumeCounterSet(range);
    case CSSPropertyID::CSSPropertyCursor:
        return consumeCursor(range, context, context.mode == HTMLQuirksMode);
    case CSSPropertyID::CSSPropertyCx:
    case CSSPropertyID::CSSPropertyCy:
    case CSSPropertyID::CSSPropertyOffsetDistance:
    case CSSPropertyID::CSSPropertyX:
    case CSSPropertyID::CSSPropertyY:
        return consumeLengthOrPercent(range, context.mode, ValueRange::All, UnitlessQuirk::Forbid);
    case CSSPropertyID::CSSPropertyDominantBaseline:
        return consumeIdent(range, isKeywordValidForDominantBaseline);
    case CSSPropertyID::CSSPropertyEmptyCells:
        return consumeIdent(range, isKeywordValidForEmptyCells);
    case CSSPropertyID::CSSPropertyFill:
    case CSSPropertyID::CSSPropertyStroke:
        return consumePaintStroke(range, context);
    case CSSPropertyID::CSSPropertyFillOpacity:
        return consumeFillOpacity(range);
    case CSSPropertyID::CSSPropertyFillRule:
        return consumeIdent(range, isKeywordValidForFillRule);
    case CSSPropertyID::CSSPropertyFilter:
    case CSSPropertyID::CSSPropertyBackdropFilter:
    case CSSPropertyID::CSSPropertyWebkitBackdropFilter:
        return consumeFilter(range, context, AllowedFilterFunctions::PixelFilters);
    case CSSPropertyID::CSSPropertyFlexBasis:
        return consumeFlexBasis(range, context);
    case CSSPropertyID::CSSPropertyFlexDirection:
        return consumeIdent(range, isKeywordValidForFlexDirection);
    case CSSPropertyID::CSSPropertyFlexGrow:
    case CSSPropertyID::CSSPropertyFlexShrink:
    case CSSPropertyID::CSSPropertyStrokeMiterlimit:
    case CSSPropertyID::CSSPropertyWebkitMarqueeRepetition:
        return consumeNumber(range, ValueRange::NonNegative);
    case CSSPropertyID::CSSPropertyFlexWrap:
        return consumeIdent(range, isKeywordValidForFlexWrap);
    case CSSPropertyID::CSSPropertyFloat:
        return consumeIdent(range, isKeywordValidForFloat);
    case CSSPropertyID::CSSPropertyFloodOpacity:
        return consumeFloodOpacity(range);
    case CSSPropertyID::CSSPropertyGlyphOrientationHorizontal:
        return consumeAngle(range, context.mode, UnitlessQuirk::Allow, UnitlessZeroQuirk::Allow);
    case CSSPropertyID::CSSPropertyGlyphOrientationVertical:
        return consumeGlyphOrientationVertical(range, context);
    case CSSPropertyID::CSSPropertyGridAutoColumns:
    case CSSPropertyID::CSSPropertyGridAutoRows:
        return consumeGridTrackList(range, context, GridAuto);
    case CSSPropertyID::CSSPropertyGridAutoFlow:
        return consumeGridAutoFlow(range);
    case CSSPropertyID::CSSPropertyGridColumnEnd:
    case CSSPropertyID::CSSPropertyGridColumnStart:
    case CSSPropertyID::CSSPropertyGridRowEnd:
    case CSSPropertyID::CSSPropertyGridRowStart:
        return consumeGridLine(range);
    case CSSPropertyID::CSSPropertyGridTemplateAreas:
        return consumeGridTemplateAreas(range);
    case CSSPropertyID::CSSPropertyGridTemplateColumns:
    case CSSPropertyID::CSSPropertyGridTemplateRows:
        return consumeGridTemplatesRowsOrColumns(range, context);
    case CSSPropertyID::CSSPropertyHangingPunctuation:
        return consumeHangingPunctuation(range);
    case CSSPropertyID::CSSPropertyHyphenateCharacter:
        return consumeHyphenateCharacter(range);
    case CSSPropertyID::CSSPropertyHyphens:
        return consumeIdent(range, isKeywordValidForHyphens);
    case CSSPropertyID::CSSPropertyImageOrientation:
        return consumeIdent(range, isKeywordValidForImageOrientation);
    case CSSPropertyID::CSSPropertyImageRendering:
        return consumeIdent(range, isKeywordValidForImageRendering);
    case CSSPropertyID::CSSPropertyInputSecurity:
        return consumeIdent(range, isKeywordValidForInputSecurity);
    case CSSPropertyID::CSSPropertyIsolation:
        return consumeIdent(range, isKeywordValidForIsolation);
    case CSSPropertyID::CSSPropertyJustifyContent:
        return consumeJustifyContent(range);
    case CSSPropertyID::CSSPropertyJustifyItems:
        return consumeJustifyItems(range);
    case CSSPropertyID::CSSPropertyJustifySelf:
        return consumeSelfPositionOverflowPosition(range, isSelfPositionOrLeftOrRightKeyword);
    case CSSPropertyID::CSSPropertyKerning:
        return consumeKerning(range, context);
    case CSSPropertyID::CSSPropertyLineBreak:
        return consumeIdent(range, isKeywordValidForLineBreak);
    case CSSPropertyID::CSSPropertyLineHeight:
        return CSSPropertyParsing::consumeLineHeight(range, context);
    case CSSPropertyID::CSSPropertyListStyleImage:
        return consumeListStyleImage(range, context);
    case CSSPropertyID::CSSPropertyListStylePosition:
        return consumeIdent(range, isKeywordValidForListStylePosition);
    case CSSPropertyID::CSSPropertyListStyleType:
        return consumeListStyleType(range, context);
    case CSSPropertyID::CSSPropertyMarginTrim:
        return consumeMarginTrim(range);
    case CSSPropertyID::CSSPropertyMarkerEnd:
        return consumeMarkerEnd(range);
    case CSSPropertyID::CSSPropertyMarkerMid:
        return consumeMarkerMid(range);
    case CSSPropertyID::CSSPropertyMarkerStart:
        return consumeMarkerStart(range);
    case CSSPropertyID::CSSPropertyMaskBorderSource:
        return consumeMaskBorderSource(range, context);
    case CSSPropertyID::CSSPropertyMaskImage:
        return consumeMaskImage(range, context);
    case CSSPropertyID::CSSPropertyMaskOrigin:
        return consumeMaskOrigin(range);
    case CSSPropertyID::CSSPropertyMaskRepeat:
        return consumeMaskRepeat(range, context);
    case CSSPropertyID::CSSPropertyMaskSize:
        return consumeMaskSize(range, context);
    case CSSPropertyID::CSSPropertyMaskType:
        return consumeIdent(range, isKeywordValidForMaskType);
    case CSSPropertyID::CSSPropertyMasonryAutoFlow:
        return consumeMasonryAutoFlow(range);
    case CSSPropertyID::CSSPropertyMathStyle:
        return consumeIdent(range, isKeywordValidForMathStyle);
    case CSSPropertyID::CSSPropertyMixBlendMode:
        return consumeIdent(range, isKeywordValidForMixBlendMode);
    case CSSPropertyID::CSSPropertyObjectFit:
        return consumeIdent(range, isKeywordValidForObjectFit);
    case CSSPropertyID::CSSPropertyObjectPosition:
        return consumePosition(range, context.mode, UnitlessQuirk::Forbid, PositionSyntax::Position);
    case CSSPropertyID::CSSPropertyOffsetAnchor:
        return consumeOffsetAnchor(range, context);
    case CSSPropertyID::CSSPropertyOffsetPath:
        return consumePathOperation(range, context, RejectFillRule);
    case CSSPropertyID::CSSPropertyOffsetPosition:
        return consumeOffsetPosition(range, context);
    case CSSPropertyID::CSSPropertyOffsetRotate:
        return consumeOffsetRotate(range, context.mode);
    case CSSPropertyID::CSSPropertyOpacity:
        return consumeOpacity(range);
    case CSSPropertyID::CSSPropertyOrder:
        return consumeInteger(range, IntegerValueRange::All);
    case CSSPropertyID::CSSPropertyOrphans:
    case CSSPropertyID::CSSPropertyWidows:
    case CSSPropertyID::CSSPropertyWebkitBoxOrdinalGroup:
        return consumeInteger(range, IntegerValueRange::Positive);
    case CSSPropertyID::CSSPropertyOutlineColor:
        return consumeOutlineColor(range, context);
    case CSSPropertyID::CSSPropertyOutlineOffset:
    case CSSPropertyID::CSSPropertyTransformOriginZ:
    case CSSPropertyID::CSSPropertyScrollMarginBlockEnd:
    case CSSPropertyID::CSSPropertyScrollMarginBlockStart:
    case CSSPropertyID::CSSPropertyScrollMarginBottom:
    case CSSPropertyID::CSSPropertyScrollMarginInlineEnd:
    case CSSPropertyID::CSSPropertyScrollMarginInlineStart:
    case CSSPropertyID::CSSPropertyScrollMarginLeft:
    case CSSPropertyID::CSSPropertyScrollMarginRight:
    case CSSPropertyID::CSSPropertyScrollMarginTop:
        return consumeLength(range, context.mode, ValueRange::All, UnitlessQuirk::Forbid);
    case CSSPropertyID::CSSPropertyOutlineStyle:
        return consumeIdent(range, isKeywordValidForOutlineStyle);
    case CSSPropertyID::CSSPropertyOutlineWidth:
        return consumeOutlineWidth(range, context);
    case CSSPropertyID::CSSPropertyOverflowAnchor:
        return consumeIdent(range, isKeywordValidForOverflowAnchor);
    case CSSPropertyID::CSSPropertyOverflowWrap:
        return consumeIdent(range, isKeywordValidForOverflowWrap);
    case CSSPropertyID::CSSPropertyOverflowX:
        return consumeIdent(range, isKeywordValidForOverflowX);
    case CSSPropertyID::CSSPropertyOverflowY:
        return consumeIdent(range, isKeywordValidForOverflowY);
    case CSSPropertyID::CSSPropertyPage:
        return consumePage(range);
    case CSSPropertyID::CSSPropertyPaintOrder:
        return consumePaintOrder(range);
    case CSSPropertyID::CSSPropertyPerspective:
        return CSSPropertyParsing::consumePerspective(range, context);
    case CSSPropertyID::CSSPropertyPerspectiveOriginX:
    case CSSPropertyID::CSSPropertyTransformOriginX:
        return consumePositionX(range, context);
    case CSSPropertyID::CSSPropertyPerspectiveOriginY:
    case CSSPropertyID::CSSPropertyTransformOriginY:
        return consumePositionY(range, context);
    case CSSPropertyID::CSSPropertyPointerEvents:
        return consumeIdent(range, isKeywordValidForPointerEvents);
    case CSSPropertyID::CSSPropertyPosition:
        return consumeIdent(range, isKeywordValidForPosition);
    case CSSPropertyID::CSSPropertyPrintColorAdjust:
        return consumeIdent(range, isKeywordValidForPrintColorAdjust);
    case CSSPropertyID::CSSPropertyQuotes:
        return consumeQuotes(range);
    case CSSPropertyID::CSSPropertyR:
    case CSSPropertyID::CSSPropertyShapeMargin:
    case CSSPropertyID::CSSPropertyPaddingBlockEnd:
    case CSSPropertyID::CSSPropertyPaddingBlockStart:
    case CSSPropertyID::CSSPropertyPaddingInlineEnd:
    case CSSPropertyID::CSSPropertyPaddingInlineStart:
        return consumeLengthOrPercent(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
    case CSSPropertyID::CSSPropertyResize:
        return consumeIdent(range, isKeywordValidForResize, context);
    case CSSPropertyID::CSSPropertyRotate:
        return consumeRotate(range, context.mode);
    case CSSPropertyID::CSSPropertyRowGap:
        return CSSPropertyParsing::consumeRowGap(range, context);
    case CSSPropertyID::CSSPropertyRx:
        return consumeRx(range, context);
    case CSSPropertyID::CSSPropertyRy:
        return consumeRy(range, context);
    case CSSPropertyID::CSSPropertyScale:
        return consumeScale(range, context.mode);
    case CSSPropertyID::CSSPropertyScrollBehavior:
        return consumeIdent(range, isKeywordValidForScrollBehavior);
    case CSSPropertyID::CSSPropertyScrollSnapAlign:
        return consumeScrollSnapAlign(range);
    case CSSPropertyID::CSSPropertyScrollSnapStop:
        return consumeIdent(range, isKeywordValidForScrollSnapStop);
    case CSSPropertyID::CSSPropertyScrollSnapType:
        return consumeScrollSnapType(range);
    case CSSPropertyID::CSSPropertyScrollTimelineAxis:
        return CSSPropertyParsing::consumeScrollTimelineAxis(range);
    case CSSPropertyID::CSSPropertyScrollTimelineName:
        return CSSPropertyParsing::consumeScrollTimelineName(range);
    case CSSPropertyID::CSSPropertyScrollbarColor:
        return consumeScrollbarColor(range, context);
    case CSSPropertyID::CSSPropertyScrollbarGutter:
        return consumeScrollbarGutter(range);
    case CSSPropertyID::CSSPropertyScrollbarWidth:
        return consumeIdent(range, isKeywordValidForScrollbarWidth);
    case CSSPropertyID::CSSPropertyShapeImageThreshold:
    case CSSPropertyID::CSSPropertyWebkitBoxFlex:
        return consumeNumber(range, ValueRange::All);
    case CSSPropertyID::CSSPropertyShapeOutside:
        return consumeShapeOutside(range, context);
    case CSSPropertyID::CSSPropertyShapeRendering:
        return consumeIdent(range, isKeywordValidForShapeRendering);
    case CSSPropertyID::CSSPropertySize:
        return consumeSize(range, context.mode);
    case CSSPropertyID::CSSPropertySpeakAs:
        return consumeSpeakAs(range);
    case CSSPropertyID::CSSPropertyStopOpacity:
        return consumeStopOpacity(range);
    case CSSPropertyID::CSSPropertyStrokeDasharray:
        return consumeStrokeDasharray(range);
    case CSSPropertyID::CSSPropertyStrokeDashoffset:
        return consumeStrokeDashoffset(range, context);
    case CSSPropertyID::CSSPropertyStrokeLinecap:
        return consumeIdent(range, isKeywordValidForStrokeLinecap);
    case CSSPropertyID::CSSPropertyStrokeLinejoin:
        return consumeIdent(range, isKeywordValidForStrokeLinejoin);
    case CSSPropertyID::CSSPropertyStrokeOpacity:
        return consumeStrokeOpacity(range);
    case CSSPropertyID::CSSPropertyStrokeWidth:
        return consumeStrokeWidth(range, context);
    case CSSPropertyID::CSSPropertyTabSize:
        return consumeTabSize(range, context);
    case CSSPropertyID::CSSPropertyTableLayout:
        return consumeIdent(range, isKeywordValidForTableLayout);
    case CSSPropertyID::CSSPropertyTextAlign:
        return consumeIdent(range, isKeywordValidForTextAlign, context);
    case CSSPropertyID::CSSPropertyTextAlignLast:
        return consumeIdent(range, isKeywordValidForTextAlignLast);
    case CSSPropertyID::CSSPropertyTextAnchor:
        return consumeIdent(range, isKeywordValidForTextAnchor);
    case CSSPropertyID::CSSPropertyTextBoxEdge:
        return consumeTextBoxEdge(range);
    case CSSPropertyID::CSSPropertyTextBoxTrim:
        return consumeIdent(range, isKeywordValidForTextBoxTrim);
    case CSSPropertyID::CSSPropertyTextDecorationLine:
    case CSSPropertyID::CSSPropertyWebkitTextDecorationsInEffect:
        return consumeTextDecorationLine(range);
    case CSSPropertyID::CSSPropertyTextDecorationSkipInk:
        return consumeIdent(range, isKeywordValidForTextDecorationSkipInk);
    case CSSPropertyID::CSSPropertyTextDecorationStyle:
        return consumeIdent(range, isKeywordValidForTextDecorationStyle);
    case CSSPropertyID::CSSPropertyTextDecorationThickness:
        return consumeTextDecorationThickness(range, context);
    case CSSPropertyID::CSSPropertyTextEmphasisPosition:
        return consumeTextEmphasisPosition(range);
    case CSSPropertyID::CSSPropertyTextEmphasisStyle:
        return consumeTextEmphasisStyle(range);
    case CSSPropertyID::CSSPropertyTextGroupAlign:
        return consumeIdent(range, isKeywordValidForTextGroupAlign);
    case CSSPropertyID::CSSPropertyTextIndent:
        return consumeTextIndent(range, context.mode);
    case CSSPropertyID::CSSPropertyTextJustify:
        return consumeIdent(range, isKeywordValidForTextJustify);
    case CSSPropertyID::CSSPropertyTextOverflow:
        return consumeIdent(range, isKeywordValidForTextOverflow);
    case CSSPropertyID::CSSPropertyTextShadow:
        return consumeTextShadow(range, context);
    case CSSPropertyID::CSSPropertyTextTransform:
        return consumeTextTransform(range);
    case CSSPropertyID::CSSPropertyTextUnderlineOffset:
        return consumeTextUnderlineOffset(range, context);
    case CSSPropertyID::CSSPropertyTextUnderlinePosition:
        return consumeIdent(range, isKeywordValidForTextUnderlinePosition, context);
    case CSSPropertyID::CSSPropertyTextWrapMode:
        return consumeIdent(range, isKeywordValidForTextWrapMode);
    case CSSPropertyID::CSSPropertyTextWrapStyle:
        return consumeIdent(range, isKeywordValidForTextWrapStyle, context);
    case CSSPropertyID::CSSPropertyTouchAction:
        return consumeTouchAction(range);
    case CSSPropertyID::CSSPropertyTransform:
        return consumeTransform(range, context.mode);
    case CSSPropertyID::CSSPropertyTransformBox:
        return consumeIdent(range, isKeywordValidForTransformBox);
    case CSSPropertyID::CSSPropertyTransformStyle:
        return consumeIdent(range, isKeywordValidForTransformStyle);
    case CSSPropertyID::CSSPropertyTransitionBehavior:
        return consumeTransitionBehavior(range);
    case CSSPropertyID::CSSPropertyTransitionDelay:
        return consumeTransitionDelay(range, context);
    case CSSPropertyID::CSSPropertyTransitionDuration:
        return consumeTransitionDuration(range, context);
    case CSSPropertyID::CSSPropertyTransitionProperty:
        return consumeTransitionProperty(range, context);
    case CSSPropertyID::CSSPropertyTransitionTimingFunction:
        return consumeTransitionTimingFunction(range, context);
    case CSSPropertyID::CSSPropertyTranslate:
        return consumeTranslate(range, context.mode);
    case CSSPropertyID::CSSPropertyUnicodeBidi:
        return consumeIdent(range, isKeywordValidForUnicodeBidi);
    case CSSPropertyID::CSSPropertyVectorEffect:
        return consumeIdent(range, isKeywordValidForVectorEffect);
    case CSSPropertyID::CSSPropertyVerticalAlign:
        return consumeVerticalAlign(range, context);
    case CSSPropertyID::CSSPropertyViewTimelineAxis:
        return CSSPropertyParsing::consumeViewTimelineAxis(range);
    case CSSPropertyID::CSSPropertyViewTimelineInset:
        return consumeViewTimelineInset(range, context);
    case CSSPropertyID::CSSPropertyViewTimelineName:
        return CSSPropertyParsing::consumeViewTimelineName(range);
    case CSSPropertyID::CSSPropertyViewTransitionName:
        return consumeViewTransitionName(range);
    case CSSPropertyID::CSSPropertyVisibility:
        return consumeIdent(range, isKeywordValidForVisibility);
    case CSSPropertyID::CSSPropertyWhiteSpaceCollapse:
        return consumeIdent(range, isKeywordValidForWhiteSpaceCollapse);
    case CSSPropertyID::CSSPropertyWillChange:
        return consumeWillChange(range, context);
    case CSSPropertyID::CSSPropertyWordBreak:
        return consumeIdent(range, isKeywordValidForWordBreak, context);
    case CSSPropertyID::CSSPropertyZIndex:
        return consumeZIndex(range);
    case CSSPropertyID::CSSPropertyAppleColorFilter:
        return consumeFilter(range, context, AllowedFilterFunctions::ColorFilters);
    case CSSPropertyID::CSSPropertyWebkitBorderHorizontalSpacing:
    case CSSPropertyID::CSSPropertyWebkitBorderVerticalSpacing:
        return consumeLength(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Forbid);
    case CSSPropertyID::CSSPropertyWebkitBoxAlign:
        return consumeIdent(range, isKeywordValidForWebkitBoxAlign);
    case CSSPropertyID::CSSPropertyWebkitBoxDecorationBreak:
        return consumeIdent(range, isKeywordValidForWebkitBoxDecorationBreak);
    case CSSPropertyID::CSSPropertyWebkitBoxDirection:
        return consumeIdent(range, isKeywordValidForWebkitBoxDirection);
    case CSSPropertyID::CSSPropertyWebkitBoxFlexGroup:
        return consumeInteger(range, IntegerValueRange::NonNegative);
    case CSSPropertyID::CSSPropertyWebkitBoxLines:
        return consumeIdent(range, isKeywordValidForWebkitBoxLines);
    case CSSPropertyID::CSSPropertyWebkitBoxOrient:
        return consumeIdent(range, isKeywordValidForWebkitBoxOrient);
    case CSSPropertyID::CSSPropertyWebkitBoxPack:
        return consumeIdent(range, isKeywordValidForWebkitBoxPack);
    case CSSPropertyID::CSSPropertyWebkitBoxReflect:
        return consumeReflect(range, context);
    case CSSPropertyID::CSSPropertyWebkitColumnAxis:
        return consumeIdent(range, isKeywordValidForWebkitColumnAxis);
    case CSSPropertyID::CSSPropertyWebkitColumnProgression:
        return consumeIdent(range, isKeywordValidForWebkitColumnProgression);
    case CSSPropertyID::CSSPropertyWebkitCursorVisibility:
        return consumeIdent(range, isKeywordValidForWebkitCursorVisibility);
    case CSSPropertyID::CSSPropertyWebkitFontSizeDelta:
        return consumeLength(range, context.mode, ValueRange::All, UnitlessQuirk::Allow);
    case CSSPropertyID::CSSPropertyWebkitHyphenateLimitAfter:
        return consumeWebkitHyphenateLimitAfter(range);
    case CSSPropertyID::CSSPropertyWebkitHyphenateLimitBefore:
        return consumeWebkitHyphenateLimitBefore(range);
    case CSSPropertyID::CSSPropertyWebkitHyphenateLimitLines:
        return consumeWebkitHyphenateLimitLines(range);
    case CSSPropertyID::CSSPropertyWebkitInitialLetter:
        return consumeWebkitInitialLetter(range);
    case CSSPropertyID::CSSPropertyWebkitLineAlign:
        return consumeIdent(range, isKeywordValidForWebkitLineAlign);
    case CSSPropertyID::CSSPropertyWebkitLineBoxContain:
        return consumeLineBoxContain(range);
    case CSSPropertyID::CSSPropertyWebkitLineClamp:
        return consumeWebkitLineClamp(range);
    case CSSPropertyID::CSSPropertyWebkitLineGrid:
        return consumeWebkitLineGrid(range);
    case CSSPropertyID::CSSPropertyWebkitLineSnap:
        return consumeIdent(range, isKeywordValidForWebkitLineSnap);
    case CSSPropertyID::CSSPropertyWebkitMarqueeDirection:
        return consumeIdent(range, isKeywordValidForWebkitMarqueeDirection);
    case CSSPropertyID::CSSPropertyWebkitMarqueeIncrement:
        return consumeLengthOrPercent(range, context.mode, ValueRange::All, UnitlessQuirk::Allow);
    case CSSPropertyID::CSSPropertyWebkitMarqueeSpeed:
        return consumeTime(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Allow);
    case CSSPropertyID::CSSPropertyWebkitMarqueeStyle:
        return consumeIdent(range, isKeywordValidForWebkitMarqueeStyle);
    case CSSPropertyID::CSSPropertyWebkitMaskPositionX:
        return consumeWebkitMaskPositionX(range, context);
    case CSSPropertyID::CSSPropertyWebkitMaskPositionY:
        return consumeWebkitMaskPositionY(range, context);
    case CSSPropertyID::CSSPropertyWebkitNbspMode:
        return consumeIdent(range, isKeywordValidForWebkitNbspMode);
    case CSSPropertyID::CSSPropertyWebkitRtlOrdering:
        return consumeIdent(range, isKeywordValidForWebkitRtlOrdering);
    case CSSPropertyID::CSSPropertyWebkitTextSecurity:
        return consumeIdent(range, isKeywordValidForWebkitTextSecurity);
    case CSSPropertyID::CSSPropertyWebkitTextStrokeWidth:
        return consumeWebkitTextStrokeWidth(range, context);
    case CSSPropertyID::CSSPropertyWebkitUserDrag:
        return consumeIdent(range, isKeywordValidForWebkitUserDrag);
    case CSSPropertyID::CSSPropertyWebkitUserModify:
        return consumeIdent(range, isKeywordValidForWebkitUserModify);
    case CSSPropertyID::CSSPropertyWebkitUserSelect:
        return consumeIdent(range, isKeywordValidForWebkitUserSelect);
    case CSSPropertyID::CSSPropertyWordSpacing:
        return consumeWordSpacing(range, context);
    case CSSPropertyID::CSSPropertyBackgroundClip:
        return consumeBackgroundClip(range);
    case CSSPropertyID::CSSPropertyBackgroundOrigin:
        return consumeBackgroundOrigin(range);
    case CSSPropertyID::CSSPropertyBlockSize:
        return consumeBlockSize(range, context);
    case CSSPropertyID::CSSPropertyBorderBlockEndStyle:
        return consumeIdent(range, isKeywordValidForBorderBlockEndStyle);
    case CSSPropertyID::CSSPropertyBorderBlockEndWidth:
        return consumeBorderBlockEndWidth(range, context);
    case CSSPropertyID::CSSPropertyBorderBlockStartStyle:
        return consumeIdent(range, isKeywordValidForBorderBlockStartStyle);
    case CSSPropertyID::CSSPropertyBorderBlockStartWidth:
        return consumeBorderBlockStartWidth(range, context);
    case CSSPropertyID::CSSPropertyBorderBottomColor:
    case CSSPropertyID::CSSPropertyBorderLeftColor:
    case CSSPropertyID::CSSPropertyBorderRightColor:
    case CSSPropertyID::CSSPropertyBorderTopColor:
        return consumeBorderColor(range, currentShorthand, context);
    case CSSPropertyID::CSSPropertyBorderBottomLeftRadius:
    case CSSPropertyID::CSSPropertyBorderBottomRightRadius:
    case CSSPropertyID::CSSPropertyBorderEndEndRadius:
    case CSSPropertyID::CSSPropertyBorderEndStartRadius:
    case CSSPropertyID::CSSPropertyBorderStartEndRadius:
    case CSSPropertyID::CSSPropertyBorderStartStartRadius:
    case CSSPropertyID::CSSPropertyBorderTopLeftRadius:
    case CSSPropertyID::CSSPropertyBorderTopRightRadius:
        return consumeBorderRadiusCorner(range, context.mode);
    case CSSPropertyID::CSSPropertyBorderBottomStyle:
        return consumeIdent(range, isKeywordValidForBorderBottomStyle);
    case CSSPropertyID::CSSPropertyBorderBottomWidth:
    case CSSPropertyID::CSSPropertyBorderLeftWidth:
    case CSSPropertyID::CSSPropertyBorderRightWidth:
    case CSSPropertyID::CSSPropertyBorderTopWidth:
        return consumeBorderWidth(range, currentShorthand, context);
    case CSSPropertyID::CSSPropertyBorderInlineEndStyle:
        return consumeIdent(range, isKeywordValidForBorderInlineEndStyle);
    case CSSPropertyID::CSSPropertyBorderInlineEndWidth:
        return consumeBorderInlineEndWidth(range, context);
    case CSSPropertyID::CSSPropertyBorderInlineStartStyle:
        return consumeIdent(range, isKeywordValidForBorderInlineStartStyle);
    case CSSPropertyID::CSSPropertyBorderInlineStartWidth:
        return consumeBorderInlineStartWidth(range, context);
    case CSSPropertyID::CSSPropertyBorderLeftStyle:
        return consumeIdent(range, isKeywordValidForBorderLeftStyle);
    case CSSPropertyID::CSSPropertyBorderRightStyle:
        return consumeIdent(range, isKeywordValidForBorderRightStyle);
    case CSSPropertyID::CSSPropertyBorderTopStyle:
        return consumeIdent(range, isKeywordValidForBorderTopStyle);
    case CSSPropertyID::CSSPropertyBottom:
    case CSSPropertyID::CSSPropertyLeft:
    case CSSPropertyID::CSSPropertyRight:
    case CSSPropertyID::CSSPropertyTop:
        return consumeSide(range, currentShorthand, context.mode);
    case CSSPropertyID::CSSPropertyBoxShadow:
        return consumeBoxShadow(range, context);
    case CSSPropertyID::CSSPropertyContainIntrinsicBlockSize:
    case CSSPropertyID::CSSPropertyContainIntrinsicHeight:
    case CSSPropertyID::CSSPropertyContainIntrinsicInlineSize:
    case CSSPropertyID::CSSPropertyContainIntrinsicWidth:
        return consumeContainIntrinsicSize(range);
    case CSSPropertyID::CSSPropertyHeight:
        return consumeHeight(range, context);
    case CSSPropertyID::CSSPropertyInlineSize:
        return consumeInlineSize(range, context);
    case CSSPropertyID::CSSPropertyInsetBlockEnd:
        return consumeInsetBlockEnd(range, context);
    case CSSPropertyID::CSSPropertyInsetBlockStart:
        return consumeInsetBlockStart(range, context);
    case CSSPropertyID::CSSPropertyInsetInlineEnd:
        return consumeInsetInlineEnd(range, context);
    case CSSPropertyID::CSSPropertyInsetInlineStart:
        return consumeInsetInlineStart(range, context);
    case CSSPropertyID::CSSPropertyMarginBlockEnd:
        return consumeMarginBlockEnd(range, context);
    case CSSPropertyID::CSSPropertyMarginBlockStart:
        return consumeMarginBlockStart(range, context);
    case CSSPropertyID::CSSPropertyMarginBottom:
    case CSSPropertyID::CSSPropertyMarginLeft:
    case CSSPropertyID::CSSPropertyMarginRight:
    case CSSPropertyID::CSSPropertyMarginTop:
        return consumeMarginSide(range, currentShorthand, context.mode);
    case CSSPropertyID::CSSPropertyMarginInlineEnd:
        return consumeMarginInlineEnd(range, context);
    case CSSPropertyID::CSSPropertyMarginInlineStart:
        return consumeMarginInlineStart(range, context);
    case CSSPropertyID::CSSPropertyMaskClip:
        return consumeMaskClip(range);
    case CSSPropertyID::CSSPropertyMaskComposite:
        return consumeMaskComposite(range);
    case CSSPropertyID::CSSPropertyMaskMode:
        return consumeMaskMode(range);
    case CSSPropertyID::CSSPropertyMaxBlockSize:
        return consumeMaxBlockSize(range, context);
    case CSSPropertyID::CSSPropertyMaxHeight:
        return consumeMaxHeight(range, context);
    case CSSPropertyID::CSSPropertyMaxInlineSize:
        return consumeMaxInlineSize(range, context);
    case CSSPropertyID::CSSPropertyMaxWidth:
        return consumeMaxWidth(range, context);
    case CSSPropertyID::CSSPropertyMinBlockSize:
        return consumeMinBlockSize(range, context);
    case CSSPropertyID::CSSPropertyMinHeight:
        return consumeMinHeight(range, context);
    case CSSPropertyID::CSSPropertyMinInlineSize:
        return consumeMinInlineSize(range, context);
    case CSSPropertyID::CSSPropertyMinWidth:
        return consumeMinWidth(range, context);
    case CSSPropertyID::CSSPropertyOverscrollBehaviorBlock:
        return consumeIdent(range, isKeywordValidForOverscrollBehaviorBlock);
    case CSSPropertyID::CSSPropertyOverscrollBehaviorInline:
        return consumeIdent(range, isKeywordValidForOverscrollBehaviorInline);
    case CSSPropertyID::CSSPropertyOverscrollBehaviorX:
        return consumeIdent(range, isKeywordValidForOverscrollBehaviorX);
    case CSSPropertyID::CSSPropertyOverscrollBehaviorY:
        return consumeIdent(range, isKeywordValidForOverscrollBehaviorY);
    case CSSPropertyID::CSSPropertyPaddingBottom:
    case CSSPropertyID::CSSPropertyPaddingLeft:
    case CSSPropertyID::CSSPropertyPaddingRight:
    case CSSPropertyID::CSSPropertyPaddingTop:
        return consumeLengthOrPercent(range, context.mode, ValueRange::NonNegative, UnitlessQuirk::Allow);
    case CSSPropertyID::CSSPropertyScrollPaddingBlockEnd:
        return consumeScrollPaddingBlockEnd(range, context);
    case CSSPropertyID::CSSPropertyScrollPaddingBlockStart:
        return consumeScrollPaddingBlockStart(range, context);
    case CSSPropertyID::CSSPropertyScrollPaddingBottom:
        return consumeScrollPaddingBottom(range, context);
    case CSSPropertyID::CSSPropertyScrollPaddingInlineEnd:
        return consumeScrollPaddingInlineEnd(range, context);
    case CSSPropertyID::CSSPropertyScrollPaddingInlineStart:
        return consumeScrollPaddingInlineStart(range, context);
    case CSSPropertyID::CSSPropertyScrollPaddingLeft:
        return consumeScrollPaddingLeft(range, context);
    case CSSPropertyID::CSSPropertyScrollPaddingRight:
        return consumeScrollPaddingRight(range, context);
    case CSSPropertyID::CSSPropertyScrollPaddingTop:
        return consumeScrollPaddingTop(range, context);
    case CSSPropertyID::CSSPropertyTextCombineUpright:
        return consumeIdent(range, isKeywordValidForTextCombineUpright);
    case CSSPropertyID::CSSPropertyWidth:
        return consumeWidth(range, context);
    case CSSPropertyID::CSSPropertyWebkitBackgroundClip:
        return consumeWebkitBackgroundClip(range);
    case CSSPropertyID::CSSPropertyWebkitBackgroundOrigin:
        return consumeWebkitBackgroundOrigin(range);
    case CSSPropertyID::CSSPropertyWebkitBoxShadow:
        return consumeWebkitBoxShadow(range, context);
    case CSSPropertyID::CSSPropertyWebkitMaskClip:
        return consumeWebkitMaskClip(range);
    case CSSPropertyID::CSSPropertyWebkitMaskComposite:
        return consumeWebkitMaskComposite(range);
    case CSSPropertyID::CSSPropertyWebkitMaskSourceType:
        return consumeWebkitMaskSourceType(range);
    case CSSPropertyID::CSSPropertyWebkitTextCombine:
        return consumeIdent(range, isKeywordValidForWebkitTextCombine);
    default:
        return nullptr;
    }
}

bool CSSPropertyParsing::isKeywordValidForStyleProperty(CSSPropertyID id, CSSValueID keyword, const CSSParserContext& context)
{
    switch (id) {
    case CSSPropertyID::CSSPropertyWritingMode:
        return isKeywordValidForWritingMode(keyword, context);
    case CSSPropertyID::CSSPropertyWebkitRubyPosition:
        return isKeywordValidForWebkitRubyPosition(keyword);
    case CSSPropertyID::CSSPropertyDirection:
        return isKeywordValidForDirection(keyword);
    case CSSPropertyID::CSSPropertyFontFeatureSettings:
        return isKeywordValidForFontFeatureSettings(keyword);
    case CSSPropertyID::CSSPropertyFontKerning:
        return isKeywordValidForFontKerning(keyword);
    case CSSPropertyID::CSSPropertyFontOpticalSizing:
        return isKeywordValidForFontOpticalSizing(keyword);
    case CSSPropertyID::CSSPropertyFontPalette:
        return isKeywordValidForFontPalette(keyword);
    case CSSPropertyID::CSSPropertyFontSize:
        return isKeywordValidForFontSize(keyword);
    case CSSPropertyID::CSSPropertyFontStretch:
        return isKeywordValidForFontStretch(keyword);
    case CSSPropertyID::CSSPropertyFontSynthesisSmallCaps:
        return isKeywordValidForFontSynthesisSmallCaps(keyword);
    case CSSPropertyID::CSSPropertyFontSynthesisStyle:
        return isKeywordValidForFontSynthesisStyle(keyword);
    case CSSPropertyID::CSSPropertyFontSynthesisWeight:
        return isKeywordValidForFontSynthesisWeight(keyword);
    case CSSPropertyID::CSSPropertyFontVariantCaps:
        return isKeywordValidForFontVariantCaps(keyword);
    case CSSPropertyID::CSSPropertyFontVariantEmoji:
        return isKeywordValidForFontVariantEmoji(keyword);
    case CSSPropertyID::CSSPropertyFontVariantPosition:
        return isKeywordValidForFontVariantPosition(keyword);
    case CSSPropertyID::CSSPropertyFontVariationSettings:
        return isKeywordValidForFontVariationSettings(keyword);
    case CSSPropertyID::CSSPropertyTextOrientation:
        return isKeywordValidForTextOrientation(keyword);
    case CSSPropertyID::CSSPropertyTextRendering:
        return isKeywordValidForTextRendering(keyword);
    case CSSPropertyID::CSSPropertyZoom:
        return isKeywordValidForZoom(keyword);
    case CSSPropertyID::CSSPropertyWebkitFontSmoothing:
        return isKeywordValidForWebkitFontSmoothing(keyword);
    case CSSPropertyID::CSSPropertyWebkitLocale:
        return isKeywordValidForWebkitLocale(keyword);
    case CSSPropertyID::CSSPropertyWebkitTextZoom:
        return isKeywordValidForWebkitTextZoom(keyword);
    case CSSPropertyID::CSSPropertyLetterSpacing:
        return isKeywordValidForLetterSpacing(keyword);
    case CSSPropertyID::CSSPropertyAccentColor:
        return isKeywordValidForAccentColor(keyword);
    case CSSPropertyID::CSSPropertyAlignmentBaseline:
        return isKeywordValidForAlignmentBaseline(keyword);
    case CSSPropertyID::CSSPropertyAppearance:
        return isKeywordValidForAppearance(keyword, context);
    case CSSPropertyID::CSSPropertyBackfaceVisibility:
        return isKeywordValidForBackfaceVisibility(keyword);
    case CSSPropertyID::CSSPropertyBaselineShift:
        return isKeywordValidForBaselineShift(keyword);
    case CSSPropertyID::CSSPropertyBlockStepInsert:
        return isKeywordValidForBlockStepInsert(keyword);
    case CSSPropertyID::CSSPropertyBlockStepSize:
        return isKeywordValidForBlockStepSize(keyword);
    case CSSPropertyID::CSSPropertyBorderCollapse:
        return isKeywordValidForBorderCollapse(keyword);
    case CSSPropertyID::CSSPropertyBorderImageSource:
        return isKeywordValidForBorderImageSource(keyword);
    case CSSPropertyID::CSSPropertyBoxSizing:
        return isKeywordValidForBoxSizing(keyword);
    case CSSPropertyID::CSSPropertyBreakAfter:
        return isKeywordValidForBreakAfter(keyword);
    case CSSPropertyID::CSSPropertyBreakBefore:
        return isKeywordValidForBreakBefore(keyword);
    case CSSPropertyID::CSSPropertyBreakInside:
        return isKeywordValidForBreakInside(keyword);
    case CSSPropertyID::CSSPropertyBufferedRendering:
        return isKeywordValidForBufferedRendering(keyword);
    case CSSPropertyID::CSSPropertyCaptionSide:
        return isKeywordValidForCaptionSide(keyword);
    case CSSPropertyID::CSSPropertyCaretColor:
        return isKeywordValidForCaretColor(keyword);
    case CSSPropertyID::CSSPropertyClear:
        return isKeywordValidForClear(keyword);
    case CSSPropertyID::CSSPropertyClipRule:
        return isKeywordValidForClipRule(keyword);
    case CSSPropertyID::CSSPropertyColorInterpolation:
        return isKeywordValidForColorInterpolation(keyword);
    case CSSPropertyID::CSSPropertyColorInterpolationFilters:
        return isKeywordValidForColorInterpolationFilters(keyword);
    case CSSPropertyID::CSSPropertyColumnCount:
        return isKeywordValidForColumnCount(keyword);
    case CSSPropertyID::CSSPropertyColumnFill:
        return isKeywordValidForColumnFill(keyword);
    case CSSPropertyID::CSSPropertyColumnGap:
        return isKeywordValidForColumnGap(keyword);
    case CSSPropertyID::CSSPropertyColumnRuleStyle:
        return isKeywordValidForColumnRuleStyle(keyword);
    case CSSPropertyID::CSSPropertyColumnRuleWidth:
        return isKeywordValidForColumnRuleWidth(keyword);
    case CSSPropertyID::CSSPropertyColumnSpan:
        return isKeywordValidForColumnSpan(keyword);
    case CSSPropertyID::CSSPropertyColumnWidth:
        return isKeywordValidForColumnWidth(keyword);
    case CSSPropertyID::CSSPropertyContainerType:
        return isKeywordValidForContainerType(keyword);
    case CSSPropertyID::CSSPropertyContentVisibility:
        return isKeywordValidForContentVisibility(keyword);
    case CSSPropertyID::CSSPropertyDominantBaseline:
        return isKeywordValidForDominantBaseline(keyword);
    case CSSPropertyID::CSSPropertyEmptyCells:
        return isKeywordValidForEmptyCells(keyword);
    case CSSPropertyID::CSSPropertyFillRule:
        return isKeywordValidForFillRule(keyword);
    case CSSPropertyID::CSSPropertyFlexBasis:
        return isKeywordValidForFlexBasis(keyword);
    case CSSPropertyID::CSSPropertyFlexDirection:
        return isKeywordValidForFlexDirection(keyword);
    case CSSPropertyID::CSSPropertyFlexWrap:
        return isKeywordValidForFlexWrap(keyword);
    case CSSPropertyID::CSSPropertyFloat:
        return isKeywordValidForFloat(keyword);
    case CSSPropertyID::CSSPropertyGlyphOrientationVertical:
        return isKeywordValidForGlyphOrientationVertical(keyword);
    case CSSPropertyID::CSSPropertyHyphenateCharacter:
        return isKeywordValidForHyphenateCharacter(keyword);
    case CSSPropertyID::CSSPropertyHyphens:
        return isKeywordValidForHyphens(keyword);
    case CSSPropertyID::CSSPropertyImageOrientation:
        return isKeywordValidForImageOrientation(keyword);
    case CSSPropertyID::CSSPropertyImageRendering:
        return isKeywordValidForImageRendering(keyword);
    case CSSPropertyID::CSSPropertyInputSecurity:
        return isKeywordValidForInputSecurity(keyword);
    case CSSPropertyID::CSSPropertyIsolation:
        return isKeywordValidForIsolation(keyword);
    case CSSPropertyID::CSSPropertyKerning:
        return isKeywordValidForKerning(keyword);
    case CSSPropertyID::CSSPropertyLineBreak:
        return isKeywordValidForLineBreak(keyword);
    case CSSPropertyID::CSSPropertyLineHeight:
        return isKeywordValidForLineHeight(keyword);
    case CSSPropertyID::CSSPropertyListStyleImage:
        return isKeywordValidForListStyleImage(keyword);
    case CSSPropertyID::CSSPropertyListStylePosition:
        return isKeywordValidForListStylePosition(keyword);
    case CSSPropertyID::CSSPropertyMarkerEnd:
        return isKeywordValidForMarkerEnd(keyword);
    case CSSPropertyID::CSSPropertyMarkerMid:
        return isKeywordValidForMarkerMid(keyword);
    case CSSPropertyID::CSSPropertyMarkerStart:
        return isKeywordValidForMarkerStart(keyword);
    case CSSPropertyID::CSSPropertyMaskBorderSource:
        return isKeywordValidForMaskBorderSource(keyword);
    case CSSPropertyID::CSSPropertyMaskType:
        return isKeywordValidForMaskType(keyword);
    case CSSPropertyID::CSSPropertyMathStyle:
        return isKeywordValidForMathStyle(keyword);
    case CSSPropertyID::CSSPropertyMixBlendMode:
        return isKeywordValidForMixBlendMode(keyword);
    case CSSPropertyID::CSSPropertyObjectFit:
        return isKeywordValidForObjectFit(keyword);
    case CSSPropertyID::CSSPropertyOffsetAnchor:
        return isKeywordValidForOffsetAnchor(keyword);
    case CSSPropertyID::CSSPropertyOffsetPosition:
        return isKeywordValidForOffsetPosition(keyword);
    case CSSPropertyID::CSSPropertyOutlineColor:
        return isKeywordValidForOutlineColor(keyword);
    case CSSPropertyID::CSSPropertyOutlineStyle:
        return isKeywordValidForOutlineStyle(keyword);
    case CSSPropertyID::CSSPropertyOutlineWidth:
        return isKeywordValidForOutlineWidth(keyword);
    case CSSPropertyID::CSSPropertyOverflowAnchor:
        return isKeywordValidForOverflowAnchor(keyword);
    case CSSPropertyID::CSSPropertyOverflowWrap:
        return isKeywordValidForOverflowWrap(keyword);
    case CSSPropertyID::CSSPropertyOverflowX:
        return isKeywordValidForOverflowX(keyword);
    case CSSPropertyID::CSSPropertyOverflowY:
        return isKeywordValidForOverflowY(keyword);
    case CSSPropertyID::CSSPropertyPage:
        return isKeywordValidForPage(keyword);
    case CSSPropertyID::CSSPropertyPerspective:
        return isKeywordValidForPerspective(keyword);
    case CSSPropertyID::CSSPropertyPointerEvents:
        return isKeywordValidForPointerEvents(keyword);
    case CSSPropertyID::CSSPropertyPosition:
        return isKeywordValidForPosition(keyword);
    case CSSPropertyID::CSSPropertyPrintColorAdjust:
        return isKeywordValidForPrintColorAdjust(keyword);
    case CSSPropertyID::CSSPropertyResize:
        return isKeywordValidForResize(keyword, context);
    case CSSPropertyID::CSSPropertyRowGap:
        return isKeywordValidForRowGap(keyword);
    case CSSPropertyID::CSSPropertyRx:
        return isKeywordValidForRx(keyword);
    case CSSPropertyID::CSSPropertyRy:
        return isKeywordValidForRy(keyword);
    case CSSPropertyID::CSSPropertyScrollBehavior:
        return isKeywordValidForScrollBehavior(keyword);
    case CSSPropertyID::CSSPropertyScrollSnapStop:
        return isKeywordValidForScrollSnapStop(keyword);
    case CSSPropertyID::CSSPropertyScrollbarWidth:
        return isKeywordValidForScrollbarWidth(keyword);
    case CSSPropertyID::CSSPropertyShapeRendering:
        return isKeywordValidForShapeRendering(keyword);
    case CSSPropertyID::CSSPropertyStrokeLinecap:
        return isKeywordValidForStrokeLinecap(keyword);
    case CSSPropertyID::CSSPropertyStrokeLinejoin:
        return isKeywordValidForStrokeLinejoin(keyword);
    case CSSPropertyID::CSSPropertyTableLayout:
        return isKeywordValidForTableLayout(keyword);
    case CSSPropertyID::CSSPropertyTextAlign:
        return isKeywordValidForTextAlign(keyword, context);
    case CSSPropertyID::CSSPropertyTextAlignLast:
        return isKeywordValidForTextAlignLast(keyword);
    case CSSPropertyID::CSSPropertyTextAnchor:
        return isKeywordValidForTextAnchor(keyword);
    case CSSPropertyID::CSSPropertyTextBoxTrim:
        return isKeywordValidForTextBoxTrim(keyword);
    case CSSPropertyID::CSSPropertyTextDecorationSkipInk:
        return isKeywordValidForTextDecorationSkipInk(keyword);
    case CSSPropertyID::CSSPropertyTextDecorationStyle:
        return isKeywordValidForTextDecorationStyle(keyword);
    case CSSPropertyID::CSSPropertyTextDecorationThickness:
        return isKeywordValidForTextDecorationThickness(keyword);
    case CSSPropertyID::CSSPropertyTextGroupAlign:
        return isKeywordValidForTextGroupAlign(keyword);
    case CSSPropertyID::CSSPropertyTextJustify:
        return isKeywordValidForTextJustify(keyword);
    case CSSPropertyID::CSSPropertyTextOverflow:
        return isKeywordValidForTextOverflow(keyword);
    case CSSPropertyID::CSSPropertyTextUnderlineOffset:
        return isKeywordValidForTextUnderlineOffset(keyword);
    case CSSPropertyID::CSSPropertyTextUnderlinePosition:
        return isKeywordValidForTextUnderlinePosition(keyword, context);
    case CSSPropertyID::CSSPropertyTextWrapMode:
        return isKeywordValidForTextWrapMode(keyword);
    case CSSPropertyID::CSSPropertyTextWrapStyle:
        return isKeywordValidForTextWrapStyle(keyword, context);
    case CSSPropertyID::CSSPropertyTransformBox:
        return isKeywordValidForTransformBox(keyword);
    case CSSPropertyID::CSSPropertyTransformStyle:
        return isKeywordValidForTransformStyle(keyword);
    case CSSPropertyID::CSSPropertyTransitionProperty:
        return isKeywordValidForTransitionProperty(keyword);
    case CSSPropertyID::CSSPropertyUnicodeBidi:
        return isKeywordValidForUnicodeBidi(keyword);
    case CSSPropertyID::CSSPropertyVectorEffect:
        return isKeywordValidForVectorEffect(keyword);
    case CSSPropertyID::CSSPropertyVerticalAlign:
        return isKeywordValidForVerticalAlign(keyword);
    case CSSPropertyID::CSSPropertyVisibility:
        return isKeywordValidForVisibility(keyword);
    case CSSPropertyID::CSSPropertyWhiteSpaceCollapse:
        return isKeywordValidForWhiteSpaceCollapse(keyword);
    case CSSPropertyID::CSSPropertyWordBreak:
        return isKeywordValidForWordBreak(keyword, context);
    case CSSPropertyID::CSSPropertyZIndex:
        return isKeywordValidForZIndex(keyword);
    case CSSPropertyID::CSSPropertyWebkitBoxAlign:
        return isKeywordValidForWebkitBoxAlign(keyword);
    case CSSPropertyID::CSSPropertyWebkitBoxDecorationBreak:
        return isKeywordValidForWebkitBoxDecorationBreak(keyword);
    case CSSPropertyID::CSSPropertyWebkitBoxDirection:
        return isKeywordValidForWebkitBoxDirection(keyword);
    case CSSPropertyID::CSSPropertyWebkitBoxLines:
        return isKeywordValidForWebkitBoxLines(keyword);
    case CSSPropertyID::CSSPropertyWebkitBoxOrient:
        return isKeywordValidForWebkitBoxOrient(keyword);
    case CSSPropertyID::CSSPropertyWebkitBoxPack:
        return isKeywordValidForWebkitBoxPack(keyword);
    case CSSPropertyID::CSSPropertyWebkitColumnAxis:
        return isKeywordValidForWebkitColumnAxis(keyword);
    case CSSPropertyID::CSSPropertyWebkitColumnProgression:
        return isKeywordValidForWebkitColumnProgression(keyword);
    case CSSPropertyID::CSSPropertyWebkitCursorVisibility:
        return isKeywordValidForWebkitCursorVisibility(keyword);
    case CSSPropertyID::CSSPropertyWebkitHyphenateLimitAfter:
        return isKeywordValidForWebkitHyphenateLimitAfter(keyword);
    case CSSPropertyID::CSSPropertyWebkitHyphenateLimitBefore:
        return isKeywordValidForWebkitHyphenateLimitBefore(keyword);
    case CSSPropertyID::CSSPropertyWebkitHyphenateLimitLines:
        return isKeywordValidForWebkitHyphenateLimitLines(keyword);
    case CSSPropertyID::CSSPropertyWebkitLineAlign:
        return isKeywordValidForWebkitLineAlign(keyword);
    case CSSPropertyID::CSSPropertyWebkitLineGrid:
        return isKeywordValidForWebkitLineGrid(keyword);
    case CSSPropertyID::CSSPropertyWebkitLineSnap:
        return isKeywordValidForWebkitLineSnap(keyword);
    case CSSPropertyID::CSSPropertyWebkitMarqueeDirection:
        return isKeywordValidForWebkitMarqueeDirection(keyword);
    case CSSPropertyID::CSSPropertyWebkitMarqueeStyle:
        return isKeywordValidForWebkitMarqueeStyle(keyword);
    case CSSPropertyID::CSSPropertyWebkitNbspMode:
        return isKeywordValidForWebkitNbspMode(keyword);
    case CSSPropertyID::CSSPropertyWebkitRtlOrdering:
        return isKeywordValidForWebkitRtlOrdering(keyword);
    case CSSPropertyID::CSSPropertyWebkitTextSecurity:
        return isKeywordValidForWebkitTextSecurity(keyword);
    case CSSPropertyID::CSSPropertyWebkitTextStrokeWidth:
        return isKeywordValidForWebkitTextStrokeWidth(keyword);
    case CSSPropertyID::CSSPropertyWebkitUserDrag:
        return isKeywordValidForWebkitUserDrag(keyword);
    case CSSPropertyID::CSSPropertyWebkitUserModify:
        return isKeywordValidForWebkitUserModify(keyword);
    case CSSPropertyID::CSSPropertyWebkitUserSelect:
        return isKeywordValidForWebkitUserSelect(keyword);
    case CSSPropertyID::CSSPropertyWordSpacing:
        return isKeywordValidForWordSpacing(keyword);
    case CSSPropertyID::CSSPropertyBlockSize:
        return isKeywordValidForBlockSize(keyword);
    case CSSPropertyID::CSSPropertyBorderBlockEndStyle:
        return isKeywordValidForBorderBlockEndStyle(keyword);
    case CSSPropertyID::CSSPropertyBorderBlockEndWidth:
        return isKeywordValidForBorderBlockEndWidth(keyword);
    case CSSPropertyID::CSSPropertyBorderBlockStartStyle:
        return isKeywordValidForBorderBlockStartStyle(keyword);
    case CSSPropertyID::CSSPropertyBorderBlockStartWidth:
        return isKeywordValidForBorderBlockStartWidth(keyword);
    case CSSPropertyID::CSSPropertyBorderBottomStyle:
        return isKeywordValidForBorderBottomStyle(keyword);
    case CSSPropertyID::CSSPropertyBorderInlineEndStyle:
        return isKeywordValidForBorderInlineEndStyle(keyword);
    case CSSPropertyID::CSSPropertyBorderInlineEndWidth:
        return isKeywordValidForBorderInlineEndWidth(keyword);
    case CSSPropertyID::CSSPropertyBorderInlineStartStyle:
        return isKeywordValidForBorderInlineStartStyle(keyword);
    case CSSPropertyID::CSSPropertyBorderInlineStartWidth:
        return isKeywordValidForBorderInlineStartWidth(keyword);
    case CSSPropertyID::CSSPropertyBorderLeftStyle:
        return isKeywordValidForBorderLeftStyle(keyword);
    case CSSPropertyID::CSSPropertyBorderRightStyle:
        return isKeywordValidForBorderRightStyle(keyword);
    case CSSPropertyID::CSSPropertyBorderTopStyle:
        return isKeywordValidForBorderTopStyle(keyword);
    case CSSPropertyID::CSSPropertyHeight:
        return isKeywordValidForHeight(keyword);
    case CSSPropertyID::CSSPropertyInlineSize:
        return isKeywordValidForInlineSize(keyword);
    case CSSPropertyID::CSSPropertyInsetBlockEnd:
        return isKeywordValidForInsetBlockEnd(keyword);
    case CSSPropertyID::CSSPropertyInsetBlockStart:
        return isKeywordValidForInsetBlockStart(keyword);
    case CSSPropertyID::CSSPropertyInsetInlineEnd:
        return isKeywordValidForInsetInlineEnd(keyword);
    case CSSPropertyID::CSSPropertyInsetInlineStart:
        return isKeywordValidForInsetInlineStart(keyword);
    case CSSPropertyID::CSSPropertyMarginBlockEnd:
        return isKeywordValidForMarginBlockEnd(keyword);
    case CSSPropertyID::CSSPropertyMarginBlockStart:
        return isKeywordValidForMarginBlockStart(keyword);
    case CSSPropertyID::CSSPropertyMarginInlineEnd:
        return isKeywordValidForMarginInlineEnd(keyword);
    case CSSPropertyID::CSSPropertyMarginInlineStart:
        return isKeywordValidForMarginInlineStart(keyword);
    case CSSPropertyID::CSSPropertyMaxBlockSize:
        return isKeywordValidForMaxBlockSize(keyword);
    case CSSPropertyID::CSSPropertyMaxHeight:
        return isKeywordValidForMaxHeight(keyword);
    case CSSPropertyID::CSSPropertyMaxInlineSize:
        return isKeywordValidForMaxInlineSize(keyword);
    case CSSPropertyID::CSSPropertyMaxWidth:
        return isKeywordValidForMaxWidth(keyword);
    case CSSPropertyID::CSSPropertyMinBlockSize:
        return isKeywordValidForMinBlockSize(keyword);
    case CSSPropertyID::CSSPropertyMinHeight:
        return isKeywordValidForMinHeight(keyword);
    case CSSPropertyID::CSSPropertyMinInlineSize:
        return isKeywordValidForMinInlineSize(keyword);
    case CSSPropertyID::CSSPropertyMinWidth:
        return isKeywordValidForMinWidth(keyword);
    case CSSPropertyID::CSSPropertyOverscrollBehaviorBlock:
        return isKeywordValidForOverscrollBehaviorBlock(keyword);
    case CSSPropertyID::CSSPropertyOverscrollBehaviorInline:
        return isKeywordValidForOverscrollBehaviorInline(keyword);
    case CSSPropertyID::CSSPropertyOverscrollBehaviorX:
        return isKeywordValidForOverscrollBehaviorX(keyword);
    case CSSPropertyID::CSSPropertyOverscrollBehaviorY:
        return isKeywordValidForOverscrollBehaviorY(keyword);
    case CSSPropertyID::CSSPropertyScrollPaddingBlockEnd:
        return isKeywordValidForScrollPaddingBlockEnd(keyword);
    case CSSPropertyID::CSSPropertyScrollPaddingBlockStart:
        return isKeywordValidForScrollPaddingBlockStart(keyword);
    case CSSPropertyID::CSSPropertyScrollPaddingBottom:
        return isKeywordValidForScrollPaddingBottom(keyword);
    case CSSPropertyID::CSSPropertyScrollPaddingInlineEnd:
        return isKeywordValidForScrollPaddingInlineEnd(keyword);
    case CSSPropertyID::CSSPropertyScrollPaddingInlineStart:
        return isKeywordValidForScrollPaddingInlineStart(keyword);
    case CSSPropertyID::CSSPropertyScrollPaddingLeft:
        return isKeywordValidForScrollPaddingLeft(keyword);
    case CSSPropertyID::CSSPropertyScrollPaddingRight:
        return isKeywordValidForScrollPaddingRight(keyword);
    case CSSPropertyID::CSSPropertyScrollPaddingTop:
        return isKeywordValidForScrollPaddingTop(keyword);
    case CSSPropertyID::CSSPropertyTextCombineUpright:
        return isKeywordValidForTextCombineUpright(keyword);
    case CSSPropertyID::CSSPropertyWidth:
        return isKeywordValidForWidth(keyword);
    case CSSPropertyID::CSSPropertyWebkitTextCombine:
        return isKeywordValidForWebkitTextCombine(keyword);
    default:
        return false;
    }
}

bool CSSPropertyParsing::isKeywordFastPathEligibleStyleProperty(CSSPropertyID id)
{
    switch (id) {
    case CSSPropertyID::CSSPropertyWritingMode:
    case CSSPropertyID::CSSPropertyWebkitRubyPosition:
    case CSSPropertyID::CSSPropertyDirection:
    case CSSPropertyID::CSSPropertyFontFeatureSettings:
    case CSSPropertyID::CSSPropertyFontKerning:
    case CSSPropertyID::CSSPropertyFontOpticalSizing:
    case CSSPropertyID::CSSPropertyFontPalette:
    case CSSPropertyID::CSSPropertyFontSize:
    case CSSPropertyID::CSSPropertyFontStretch:
    case CSSPropertyID::CSSPropertyFontSynthesisSmallCaps:
    case CSSPropertyID::CSSPropertyFontSynthesisStyle:
    case CSSPropertyID::CSSPropertyFontSynthesisWeight:
    case CSSPropertyID::CSSPropertyFontVariantCaps:
    case CSSPropertyID::CSSPropertyFontVariantEmoji:
    case CSSPropertyID::CSSPropertyFontVariantPosition:
    case CSSPropertyID::CSSPropertyFontVariationSettings:
    case CSSPropertyID::CSSPropertyTextOrientation:
    case CSSPropertyID::CSSPropertyTextRendering:
    case CSSPropertyID::CSSPropertyZoom:
    case CSSPropertyID::CSSPropertyWebkitFontSmoothing:
    case CSSPropertyID::CSSPropertyWebkitLocale:
    case CSSPropertyID::CSSPropertyWebkitTextZoom:
    case CSSPropertyID::CSSPropertyLetterSpacing:
    case CSSPropertyID::CSSPropertyAccentColor:
    case CSSPropertyID::CSSPropertyAlignmentBaseline:
    case CSSPropertyID::CSSPropertyAppearance:
    case CSSPropertyID::CSSPropertyBackfaceVisibility:
    case CSSPropertyID::CSSPropertyBaselineShift:
    case CSSPropertyID::CSSPropertyBlockStepInsert:
    case CSSPropertyID::CSSPropertyBlockStepSize:
    case CSSPropertyID::CSSPropertyBorderCollapse:
    case CSSPropertyID::CSSPropertyBorderImageSource:
    case CSSPropertyID::CSSPropertyBoxSizing:
    case CSSPropertyID::CSSPropertyBreakAfter:
    case CSSPropertyID::CSSPropertyBreakBefore:
    case CSSPropertyID::CSSPropertyBreakInside:
    case CSSPropertyID::CSSPropertyBufferedRendering:
    case CSSPropertyID::CSSPropertyCaptionSide:
    case CSSPropertyID::CSSPropertyCaretColor:
    case CSSPropertyID::CSSPropertyClear:
    case CSSPropertyID::CSSPropertyClipRule:
    case CSSPropertyID::CSSPropertyColorInterpolation:
    case CSSPropertyID::CSSPropertyColorInterpolationFilters:
    case CSSPropertyID::CSSPropertyColumnCount:
    case CSSPropertyID::CSSPropertyColumnFill:
    case CSSPropertyID::CSSPropertyColumnGap:
    case CSSPropertyID::CSSPropertyColumnRuleStyle:
    case CSSPropertyID::CSSPropertyColumnRuleWidth:
    case CSSPropertyID::CSSPropertyColumnSpan:
    case CSSPropertyID::CSSPropertyColumnWidth:
    case CSSPropertyID::CSSPropertyContainerType:
    case CSSPropertyID::CSSPropertyContentVisibility:
    case CSSPropertyID::CSSPropertyDominantBaseline:
    case CSSPropertyID::CSSPropertyEmptyCells:
    case CSSPropertyID::CSSPropertyFillRule:
    case CSSPropertyID::CSSPropertyFlexBasis:
    case CSSPropertyID::CSSPropertyFlexDirection:
    case CSSPropertyID::CSSPropertyFlexWrap:
    case CSSPropertyID::CSSPropertyFloat:
    case CSSPropertyID::CSSPropertyGlyphOrientationVertical:
    case CSSPropertyID::CSSPropertyHyphenateCharacter:
    case CSSPropertyID::CSSPropertyHyphens:
    case CSSPropertyID::CSSPropertyImageOrientation:
    case CSSPropertyID::CSSPropertyImageRendering:
    case CSSPropertyID::CSSPropertyInputSecurity:
    case CSSPropertyID::CSSPropertyIsolation:
    case CSSPropertyID::CSSPropertyKerning:
    case CSSPropertyID::CSSPropertyLineBreak:
    case CSSPropertyID::CSSPropertyLineHeight:
    case CSSPropertyID::CSSPropertyListStyleImage:
    case CSSPropertyID::CSSPropertyListStylePosition:
    case CSSPropertyID::CSSPropertyMarkerEnd:
    case CSSPropertyID::CSSPropertyMarkerMid:
    case CSSPropertyID::CSSPropertyMarkerStart:
    case CSSPropertyID::CSSPropertyMaskBorderSource:
    case CSSPropertyID::CSSPropertyMaskType:
    case CSSPropertyID::CSSPropertyMathStyle:
    case CSSPropertyID::CSSPropertyMixBlendMode:
    case CSSPropertyID::CSSPropertyObjectFit:
    case CSSPropertyID::CSSPropertyOffsetAnchor:
    case CSSPropertyID::CSSPropertyOffsetPosition:
    case CSSPropertyID::CSSPropertyOutlineColor:
    case CSSPropertyID::CSSPropertyOutlineStyle:
    case CSSPropertyID::CSSPropertyOutlineWidth:
    case CSSPropertyID::CSSPropertyOverflowAnchor:
    case CSSPropertyID::CSSPropertyOverflowWrap:
    case CSSPropertyID::CSSPropertyOverflowX:
    case CSSPropertyID::CSSPropertyOverflowY:
    case CSSPropertyID::CSSPropertyPage:
    case CSSPropertyID::CSSPropertyPerspective:
    case CSSPropertyID::CSSPropertyPointerEvents:
    case CSSPropertyID::CSSPropertyPosition:
    case CSSPropertyID::CSSPropertyPrintColorAdjust:
    case CSSPropertyID::CSSPropertyResize:
    case CSSPropertyID::CSSPropertyRowGap:
    case CSSPropertyID::CSSPropertyRx:
    case CSSPropertyID::CSSPropertyRy:
    case CSSPropertyID::CSSPropertyScrollBehavior:
    case CSSPropertyID::CSSPropertyScrollSnapStop:
    case CSSPropertyID::CSSPropertyScrollbarWidth:
    case CSSPropertyID::CSSPropertyShapeRendering:
    case CSSPropertyID::CSSPropertyStrokeLinecap:
    case CSSPropertyID::CSSPropertyStrokeLinejoin:
    case CSSPropertyID::CSSPropertyTableLayout:
    case CSSPropertyID::CSSPropertyTextAlign:
    case CSSPropertyID::CSSPropertyTextAlignLast:
    case CSSPropertyID::CSSPropertyTextAnchor:
    case CSSPropertyID::CSSPropertyTextBoxTrim:
    case CSSPropertyID::CSSPropertyTextDecorationSkipInk:
    case CSSPropertyID::CSSPropertyTextDecorationStyle:
    case CSSPropertyID::CSSPropertyTextDecorationThickness:
    case CSSPropertyID::CSSPropertyTextGroupAlign:
    case CSSPropertyID::CSSPropertyTextJustify:
    case CSSPropertyID::CSSPropertyTextOverflow:
    case CSSPropertyID::CSSPropertyTextUnderlineOffset:
    case CSSPropertyID::CSSPropertyTextUnderlinePosition:
    case CSSPropertyID::CSSPropertyTextWrapMode:
    case CSSPropertyID::CSSPropertyTextWrapStyle:
    case CSSPropertyID::CSSPropertyTransformBox:
    case CSSPropertyID::CSSPropertyTransformStyle:
    case CSSPropertyID::CSSPropertyTransitionProperty:
    case CSSPropertyID::CSSPropertyUnicodeBidi:
    case CSSPropertyID::CSSPropertyVectorEffect:
    case CSSPropertyID::CSSPropertyVerticalAlign:
    case CSSPropertyID::CSSPropertyVisibility:
    case CSSPropertyID::CSSPropertyWhiteSpaceCollapse:
    case CSSPropertyID::CSSPropertyWordBreak:
    case CSSPropertyID::CSSPropertyZIndex:
    case CSSPropertyID::CSSPropertyWebkitBoxAlign:
    case CSSPropertyID::CSSPropertyWebkitBoxDecorationBreak:
    case CSSPropertyID::CSSPropertyWebkitBoxDirection:
    case CSSPropertyID::CSSPropertyWebkitBoxLines:
    case CSSPropertyID::CSSPropertyWebkitBoxOrient:
    case CSSPropertyID::CSSPropertyWebkitBoxPack:
    case CSSPropertyID::CSSPropertyWebkitColumnAxis:
    case CSSPropertyID::CSSPropertyWebkitColumnProgression:
    case CSSPropertyID::CSSPropertyWebkitCursorVisibility:
    case CSSPropertyID::CSSPropertyWebkitHyphenateLimitAfter:
    case CSSPropertyID::CSSPropertyWebkitHyphenateLimitBefore:
    case CSSPropertyID::CSSPropertyWebkitHyphenateLimitLines:
    case CSSPropertyID::CSSPropertyWebkitLineAlign:
    case CSSPropertyID::CSSPropertyWebkitLineGrid:
    case CSSPropertyID::CSSPropertyWebkitLineSnap:
    case CSSPropertyID::CSSPropertyWebkitMarqueeDirection:
    case CSSPropertyID::CSSPropertyWebkitMarqueeStyle:
    case CSSPropertyID::CSSPropertyWebkitNbspMode:
    case CSSPropertyID::CSSPropertyWebkitRtlOrdering:
    case CSSPropertyID::CSSPropertyWebkitTextSecurity:
    case CSSPropertyID::CSSPropertyWebkitTextStrokeWidth:
    case CSSPropertyID::CSSPropertyWebkitUserDrag:
    case CSSPropertyID::CSSPropertyWebkitUserModify:
    case CSSPropertyID::CSSPropertyWebkitUserSelect:
    case CSSPropertyID::CSSPropertyWordSpacing:
    case CSSPropertyID::CSSPropertyBlockSize:
    case CSSPropertyID::CSSPropertyBorderBlockEndStyle:
    case CSSPropertyID::CSSPropertyBorderBlockEndWidth:
    case CSSPropertyID::CSSPropertyBorderBlockStartStyle:
    case CSSPropertyID::CSSPropertyBorderBlockStartWidth:
    case CSSPropertyID::CSSPropertyBorderBottomStyle:
    case CSSPropertyID::CSSPropertyBorderInlineEndStyle:
    case CSSPropertyID::CSSPropertyBorderInlineEndWidth:
    case CSSPropertyID::CSSPropertyBorderInlineStartStyle:
    case CSSPropertyID::CSSPropertyBorderInlineStartWidth:
    case CSSPropertyID::CSSPropertyBorderLeftStyle:
    case CSSPropertyID::CSSPropertyBorderRightStyle:
    case CSSPropertyID::CSSPropertyBorderTopStyle:
    case CSSPropertyID::CSSPropertyHeight:
    case CSSPropertyID::CSSPropertyInlineSize:
    case CSSPropertyID::CSSPropertyInsetBlockEnd:
    case CSSPropertyID::CSSPropertyInsetBlockStart:
    case CSSPropertyID::CSSPropertyInsetInlineEnd:
    case CSSPropertyID::CSSPropertyInsetInlineStart:
    case CSSPropertyID::CSSPropertyMarginBlockEnd:
    case CSSPropertyID::CSSPropertyMarginBlockStart:
    case CSSPropertyID::CSSPropertyMarginInlineEnd:
    case CSSPropertyID::CSSPropertyMarginInlineStart:
    case CSSPropertyID::CSSPropertyMaxBlockSize:
    case CSSPropertyID::CSSPropertyMaxHeight:
    case CSSPropertyID::CSSPropertyMaxInlineSize:
    case CSSPropertyID::CSSPropertyMaxWidth:
    case CSSPropertyID::CSSPropertyMinBlockSize:
    case CSSPropertyID::CSSPropertyMinHeight:
    case CSSPropertyID::CSSPropertyMinInlineSize:
    case CSSPropertyID::CSSPropertyMinWidth:
    case CSSPropertyID::CSSPropertyOverscrollBehaviorBlock:
    case CSSPropertyID::CSSPropertyOverscrollBehaviorInline:
    case CSSPropertyID::CSSPropertyOverscrollBehaviorX:
    case CSSPropertyID::CSSPropertyOverscrollBehaviorY:
    case CSSPropertyID::CSSPropertyScrollPaddingBlockEnd:
    case CSSPropertyID::CSSPropertyScrollPaddingBlockStart:
    case CSSPropertyID::CSSPropertyScrollPaddingBottom:
    case CSSPropertyID::CSSPropertyScrollPaddingInlineEnd:
    case CSSPropertyID::CSSPropertyScrollPaddingInlineStart:
    case CSSPropertyID::CSSPropertyScrollPaddingLeft:
    case CSSPropertyID::CSSPropertyScrollPaddingRight:
    case CSSPropertyID::CSSPropertyScrollPaddingTop:
    case CSSPropertyID::CSSPropertyTextCombineUpright:
    case CSSPropertyID::CSSPropertyWidth:
    case CSSPropertyID::CSSPropertyWebkitTextCombine:
        return true;
    default:
        return false;
    }
}

RefPtr<CSSValue> CSSPropertyParsing::parseCounterStyleDescriptor(CSSParserTokenRange& range, CSSPropertyID id, const CSSParserContext& context)
{
    if (!isExposed(id, context.propertySettings) && !isInternal(id)) {
        // Allow internal properties as we use them to parse several internal-only-shorthands (e.g. background-repeat),
        // and to handle certain DOM-exposed values (e.g. -webkit-font-size-delta from execCommand('FontSizeDelta')).
        ASSERT_NOT_REACHED();
        return nullptr;
    }
    switch (id) {
    case CSSPropertyID::CSSPropertyAdditiveSymbols:
        return consumeCounterStyleAdditiveSymbols(range, context);
    case CSSPropertyID::CSSPropertyFallback:
        return consumeCounterStyleName(range);
    case CSSPropertyID::CSSPropertyNegative:
        return consumeCounterStyleNegative(range, context);
    case CSSPropertyID::CSSPropertyPad:
        return consumeCounterStylePad(range, context);
    case CSSPropertyID::CSSPropertyPrefix:
    case CSSPropertyID::CSSPropertySuffix:
        return consumeCounterStyleSymbol(range, context);
    case CSSPropertyID::CSSPropertyRange:
        return consumeCounterStyleRange(range);
    case CSSPropertyID::CSSPropertySpeakAs:
        return consumeCounterStyleSpeakAs(range);
    case CSSPropertyID::CSSPropertySymbols:
        return consumeCounterStyleSymbols(range, context);
    case CSSPropertyID::CSSPropertySystem:
        return consumeCounterStyleSystem(range, context);
    default:
        return nullptr;
    }
}

bool CSSPropertyParsing::isKeywordValidForCounterStyleDescriptor(CSSPropertyID, CSSValueID, const CSSParserContext&)
{
    return false;
}

bool CSSPropertyParsing::isKeywordFastPathEligibleCounterStyleDescriptor(CSSPropertyID)
{
    return false;
}

RefPtr<CSSValue> CSSPropertyParsing::parseFontFaceDescriptor(CSSParserTokenRange& range, CSSPropertyID id, const CSSParserContext& context)
{
    if (!isExposed(id, context.propertySettings) && !isInternal(id)) {
        // Allow internal properties as we use them to parse several internal-only-shorthands (e.g. background-repeat),
        // and to handle certain DOM-exposed values (e.g. -webkit-font-size-delta from execCommand('FontSizeDelta')).
        ASSERT_NOT_REACHED();
        return nullptr;
    }
    switch (id) {
    case CSSPropertyID::CSSPropertyFontDisplay:
        return consumeIdent(range, isKeywordValidForFontFaceFontDisplay);
    case CSSPropertyID::CSSPropertyFontFamily:
        return consumeFontFaceFontFamily(range);
    case CSSPropertyID::CSSPropertyFontFeatureSettings:
        return consumeFontFaceFontFeatureSettings(range);
    case CSSPropertyID::CSSPropertyFontStretch:
        return consumeFontStretchRange(range);
    case CSSPropertyID::CSSPropertyFontStyle:
        return consumeFontStyleRange(range, context.mode);
    case CSSPropertyID::CSSPropertyFontVariantAlternates:
        return consumeFontVariantAlternates(range);
    case CSSPropertyID::CSSPropertyFontVariantCaps:
        return consumeIdent(range, isKeywordValidForFontFaceFontVariantCaps);
    case CSSPropertyID::CSSPropertyFontVariantEastAsian:
        return consumeFontVariantEastAsian(range);
    case CSSPropertyID::CSSPropertyFontVariantLigatures:
        return consumeFontVariantLigatures(range);
    case CSSPropertyID::CSSPropertyFontVariantNumeric:
        return consumeFontVariantNumeric(range);
    case CSSPropertyID::CSSPropertyFontVariantPosition:
        return consumeIdent(range, isKeywordValidForFontFaceFontVariantPosition);
    case CSSPropertyID::CSSPropertyFontWeight:
        return consumeFontWeightAbsoluteRange(range);
    case CSSPropertyID::CSSPropertySizeAdjust:
        return consumePercent(range, ValueRange::NonNegative);
    case CSSPropertyID::CSSPropertySrc:
        return consumeFontFaceSrc(range, context);
    case CSSPropertyID::CSSPropertyUnicodeRange:
        return consumeFontFaceUnicodeRange(range);
    default:
        return nullptr;
    }
}

bool CSSPropertyParsing::isKeywordValidForFontFaceDescriptor(CSSPropertyID id, CSSValueID keyword, const CSSParserContext&)
{
    switch (id) {
    case CSSPropertyID::CSSPropertyFontDisplay:
        return isKeywordValidForFontFaceFontDisplay(keyword);
    case CSSPropertyID::CSSPropertyFontFeatureSettings:
        return isKeywordValidForFontFaceFontFeatureSettings(keyword);
    case CSSPropertyID::CSSPropertyFontVariantCaps:
        return isKeywordValidForFontFaceFontVariantCaps(keyword);
    case CSSPropertyID::CSSPropertyFontVariantPosition:
        return isKeywordValidForFontFaceFontVariantPosition(keyword);
    default:
        return false;
    }
}

bool CSSPropertyParsing::isKeywordFastPathEligibleFontFaceDescriptor(CSSPropertyID id)
{
    switch (id) {
    case CSSPropertyID::CSSPropertyFontDisplay:
    case CSSPropertyID::CSSPropertyFontFeatureSettings:
    case CSSPropertyID::CSSPropertyFontVariantCaps:
    case CSSPropertyID::CSSPropertyFontVariantPosition:
        return true;
    default:
        return false;
    }
}

RefPtr<CSSValue> CSSPropertyParsing::parseFontPaletteValuesDescriptor(CSSParserTokenRange& range, CSSPropertyID id, const CSSParserContext& context)
{
    if (!isExposed(id, context.propertySettings) && !isInternal(id)) {
        // Allow internal properties as we use them to parse several internal-only-shorthands (e.g. background-repeat),
        // and to handle certain DOM-exposed values (e.g. -webkit-font-size-delta from execCommand('FontSizeDelta')).
        ASSERT_NOT_REACHED();
        return nullptr;
    }
    switch (id) {
    case CSSPropertyID::CSSPropertyBasePalette:
        return consumeFontPaletteValuesBasePalette(range);
    case CSSPropertyID::CSSPropertyFontFamily:
        return consumeFamilyNameList(range);
    case CSSPropertyID::CSSPropertyOverrideColors:
        return consumeFontPaletteValuesOverrideColors(range, context);
    default:
        return nullptr;
    }
}

bool CSSPropertyParsing::isKeywordValidForFontPaletteValuesDescriptor(CSSPropertyID id, CSSValueID keyword, const CSSParserContext&)
{
    switch (id) {
    case CSSPropertyID::CSSPropertyBasePalette:
        return isKeywordValidForFontPaletteValuesBasePalette(keyword);
    default:
        return false;
    }
}

bool CSSPropertyParsing::isKeywordFastPathEligibleFontPaletteValuesDescriptor(CSSPropertyID id)
{
    switch (id) {
    case CSSPropertyID::CSSPropertyBasePalette:
        return true;
    default:
        return false;
    }
}

RefPtr<CSSValue> CSSPropertyParsing::parsePropertyDescriptor(CSSParserTokenRange& range, CSSPropertyID id, const CSSParserContext& context)
{
    if (!isExposed(id, context.propertySettings) && !isInternal(id)) {
        // Allow internal properties as we use them to parse several internal-only-shorthands (e.g. background-repeat),
        // and to handle certain DOM-exposed values (e.g. -webkit-font-size-delta from execCommand('FontSizeDelta')).
        ASSERT_NOT_REACHED();
        return nullptr;
    }
    switch (id) {
    case CSSPropertyID::CSSPropertyInherits:
        return consumeIdent(range, isKeywordValidForPropertyInherits);
    case CSSPropertyID::CSSPropertyInitialValue:
        return consumeDeclarationValue(range, context);
    case CSSPropertyID::CSSPropertySyntax:
        return consumeString(range);
    default:
        return nullptr;
    }
}

bool CSSPropertyParsing::isKeywordValidForPropertyDescriptor(CSSPropertyID id, CSSValueID keyword, const CSSParserContext&)
{
    switch (id) {
    case CSSPropertyID::CSSPropertyInherits:
        return isKeywordValidForPropertyInherits(keyword);
    default:
        return false;
    }
}

bool CSSPropertyParsing::isKeywordFastPathEligiblePropertyDescriptor(CSSPropertyID id)
{
    switch (id) {
    case CSSPropertyID::CSSPropertyInherits:
        return true;
    default:
        return false;
    }
}

} // namespace WebCore

