/*
 * Copyright (C) 2016-2017 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NO EDIT! - This file was generated by /build/webkitgtk-6.0/src/webkitgtk-2.44.2/Source/JavaScriptCore/wasm/generateWasmB3IRGeneratorInlinesHeader.py

#pragma once

#if ENABLE(WEBASSEMBLY)

namespace JSC { namespace Wasm {


auto B3IRGenerator::addI32Add(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Add, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(Add) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Add));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI32Sub(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Sub, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(Sub) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Sub));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI32Mul(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Mul, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(Mul) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Mul));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI32And(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::BitAnd, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(BitAnd) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::BitAnd));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI32Or(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::BitOr, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(BitOr) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::BitOr));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI32Xor(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::BitXor, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(BitXor) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::BitXor));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI32Shl(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Shl, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(Shl) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Shl));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI32ShrU(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::ZShr, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(ZShr) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::ZShr));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI32ShrS(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::SShr, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(SShr) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::SShr));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI32Rotr(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::RotR, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(RotR) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::RotR));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI32Rotl(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::RotL, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(RotL) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::RotL));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI32Eq(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Equal, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(Equal) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Equal));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI32Ne(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::NotEqual, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(NotEqual) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::NotEqual));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI32LtS(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::LessThan, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(LessThan) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::LessThan));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI32LeS(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::LessEqual, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(LessEqual) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::LessEqual));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI32LtU(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Below, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(Below) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Below));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI32LeU(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::BelowEqual, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(BelowEqual) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::BelowEqual));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI32GtS(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::GreaterThan, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(GreaterThan) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::GreaterThan));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI32GeS(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::GreaterEqual, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(GreaterEqual) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::GreaterEqual));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI32GtU(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Above, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(Above) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Above));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI32GeU(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::AboveEqual, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(AboveEqual) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::AboveEqual));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI32Clz(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Clz, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(Clz) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Clz));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI32Eqz(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp4 = constant(Int32, 0);
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Equal, origin(), temp4, get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(Equal) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Equal));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI64Add(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Add, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(Add) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Add));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI64Sub(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Sub, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(Sub) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Sub));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI64Mul(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Mul, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(Mul) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Mul));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI64And(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::BitAnd, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(BitAnd) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::BitAnd));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI64Or(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::BitOr, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(BitOr) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::BitOr));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI64Xor(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::BitXor, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(BitXor) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::BitXor));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI64Shl(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp3 = m_currentBlock->appendNew<Value>(m_proc, B3::Trunc, origin(), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(Trunc) && temp3->type().isFloat())
        temp3->setKindUnsafely(sensitiveToNaN(B3::Trunc));
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Shl, origin(), get(arg0), temp3);
    if (B3::Kind::hasIsSensitiveToNaN(Shl) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Shl));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI64ShrU(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp3 = m_currentBlock->appendNew<Value>(m_proc, B3::Trunc, origin(), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(Trunc) && temp3->type().isFloat())
        temp3->setKindUnsafely(sensitiveToNaN(B3::Trunc));
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::ZShr, origin(), get(arg0), temp3);
    if (B3::Kind::hasIsSensitiveToNaN(ZShr) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::ZShr));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI64ShrS(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp3 = m_currentBlock->appendNew<Value>(m_proc, B3::Trunc, origin(), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(Trunc) && temp3->type().isFloat())
        temp3->setKindUnsafely(sensitiveToNaN(B3::Trunc));
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::SShr, origin(), get(arg0), temp3);
    if (B3::Kind::hasIsSensitiveToNaN(SShr) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::SShr));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI64Rotr(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp3 = m_currentBlock->appendNew<Value>(m_proc, B3::Trunc, origin(), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(Trunc) && temp3->type().isFloat())
        temp3->setKindUnsafely(sensitiveToNaN(B3::Trunc));
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::RotR, origin(), get(arg0), temp3);
    if (B3::Kind::hasIsSensitiveToNaN(RotR) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::RotR));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI64Rotl(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp3 = m_currentBlock->appendNew<Value>(m_proc, B3::Trunc, origin(), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(Trunc) && temp3->type().isFloat())
        temp3->setKindUnsafely(sensitiveToNaN(B3::Trunc));
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::RotL, origin(), get(arg0), temp3);
    if (B3::Kind::hasIsSensitiveToNaN(RotL) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::RotL));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI64Eq(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Equal, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(Equal) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Equal));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI64Ne(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::NotEqual, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(NotEqual) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::NotEqual));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI64LtS(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::LessThan, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(LessThan) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::LessThan));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI64LeS(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::LessEqual, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(LessEqual) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::LessEqual));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI64LtU(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Below, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(Below) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Below));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI64LeU(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::BelowEqual, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(BelowEqual) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::BelowEqual));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI64GtS(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::GreaterThan, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(GreaterThan) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::GreaterThan));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI64GeS(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::GreaterEqual, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(GreaterEqual) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::GreaterEqual));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI64GtU(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Above, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(Above) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Above));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI64GeU(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::AboveEqual, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(AboveEqual) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::AboveEqual));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI64Clz(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Clz, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(Clz) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Clz));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI64Eqz(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp4 = constant(Int64, 0);
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Equal, origin(), temp4, get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(Equal) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Equal));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF32Add(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Add, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(Add) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Add));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF32Sub(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Sub, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(Sub) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Sub));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF32Mul(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Mul, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(Mul) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Mul));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF32Div(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Div, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(Div) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Div));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF32Min(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::FMin, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(FMin) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::FMin));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF32Max(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::FMax, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(FMax) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::FMax));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF32Abs(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Abs, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(Abs) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Abs));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF32Neg(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Neg, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(Neg) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Neg));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF32Copysign(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp6 = m_currentBlock->appendNew<Value>(m_proc, B3::BitwiseCast, origin(), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(BitwiseCast) && temp6->type().isFloat())
        temp6->setKindUnsafely(sensitiveToNaN(B3::BitwiseCast));
    Value* temp12 = constant(Int32, 0x80000000);
    Value* temp4 = m_currentBlock->appendNew<Value>(m_proc, B3::BitAnd, origin(), temp6, temp12);
    if (B3::Kind::hasIsSensitiveToNaN(BitAnd) && temp4->type().isFloat())
        temp4->setKindUnsafely(sensitiveToNaN(B3::BitAnd));
    Value* temp17 = m_currentBlock->appendNew<Value>(m_proc, B3::BitwiseCast, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(BitwiseCast) && temp17->type().isFloat())
        temp17->setKindUnsafely(sensitiveToNaN(B3::BitwiseCast));
    Value* temp23 = constant(Int32, 0x7fffffff);
    Value* temp15 = m_currentBlock->appendNew<Value>(m_proc, B3::BitAnd, origin(), temp17, temp23);
    if (B3::Kind::hasIsSensitiveToNaN(BitAnd) && temp15->type().isFloat())
        temp15->setKindUnsafely(sensitiveToNaN(B3::BitAnd));
    Value* temp2 = m_currentBlock->appendNew<Value>(m_proc, B3::BitOr, origin(), temp4, temp15);
    if (B3::Kind::hasIsSensitiveToNaN(BitOr) && temp2->type().isFloat())
        temp2->setKindUnsafely(sensitiveToNaN(B3::BitOr));
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::BitwiseCast, origin(), temp2);
    if (B3::Kind::hasIsSensitiveToNaN(BitwiseCast) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::BitwiseCast));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF32Ceil(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Ceil, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(Ceil) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Ceil));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF32Floor(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Floor, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(Floor) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Floor));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF32Sqrt(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Sqrt, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(Sqrt) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Sqrt));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF32Eq(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Equal, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(Equal) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Equal));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF32Ne(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::NotEqual, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(NotEqual) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::NotEqual));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF32Lt(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::LessThan, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(LessThan) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::LessThan));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF32Le(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::LessEqual, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(LessEqual) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::LessEqual));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF32Gt(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::GreaterThan, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(GreaterThan) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::GreaterThan));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF32Ge(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::GreaterEqual, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(GreaterEqual) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::GreaterEqual));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF64Add(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Add, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(Add) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Add));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF64Sub(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Sub, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(Sub) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Sub));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF64Mul(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Mul, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(Mul) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Mul));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF64Div(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Div, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(Div) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Div));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF64Min(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::FMin, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(FMin) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::FMin));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF64Max(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::FMax, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(FMax) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::FMax));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF64Abs(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Abs, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(Abs) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Abs));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF64Neg(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Neg, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(Neg) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Neg));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF64Copysign(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp6 = m_currentBlock->appendNew<Value>(m_proc, B3::BitwiseCast, origin(), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(BitwiseCast) && temp6->type().isFloat())
        temp6->setKindUnsafely(sensitiveToNaN(B3::BitwiseCast));
    Value* temp12 = constant(Int64, 0x8000000000000000);
    Value* temp4 = m_currentBlock->appendNew<Value>(m_proc, B3::BitAnd, origin(), temp6, temp12);
    if (B3::Kind::hasIsSensitiveToNaN(BitAnd) && temp4->type().isFloat())
        temp4->setKindUnsafely(sensitiveToNaN(B3::BitAnd));
    Value* temp17 = m_currentBlock->appendNew<Value>(m_proc, B3::BitwiseCast, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(BitwiseCast) && temp17->type().isFloat())
        temp17->setKindUnsafely(sensitiveToNaN(B3::BitwiseCast));
    Value* temp23 = constant(Int64, 0x7fffffffffffffff);
    Value* temp15 = m_currentBlock->appendNew<Value>(m_proc, B3::BitAnd, origin(), temp17, temp23);
    if (B3::Kind::hasIsSensitiveToNaN(BitAnd) && temp15->type().isFloat())
        temp15->setKindUnsafely(sensitiveToNaN(B3::BitAnd));
    Value* temp2 = m_currentBlock->appendNew<Value>(m_proc, B3::BitOr, origin(), temp4, temp15);
    if (B3::Kind::hasIsSensitiveToNaN(BitOr) && temp2->type().isFloat())
        temp2->setKindUnsafely(sensitiveToNaN(B3::BitOr));
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::BitwiseCast, origin(), temp2);
    if (B3::Kind::hasIsSensitiveToNaN(BitwiseCast) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::BitwiseCast));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF64Ceil(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Ceil, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(Ceil) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Ceil));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF64Floor(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Floor, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(Floor) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Floor));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF64Sqrt(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Sqrt, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(Sqrt) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Sqrt));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF64Eq(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Equal, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(Equal) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Equal));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF64Ne(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::NotEqual, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(NotEqual) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::NotEqual));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF64Lt(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::LessThan, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(LessThan) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::LessThan));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF64Le(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::LessEqual, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(LessEqual) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::LessEqual));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF64Gt(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::GreaterThan, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(GreaterThan) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::GreaterThan));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF64Ge(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::GreaterEqual, origin(), get(arg0), get(arg1));
    if (B3::Kind::hasIsSensitiveToNaN(GreaterEqual) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::GreaterEqual));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI32WrapI64(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Trunc, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(Trunc) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::Trunc));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI64ExtendSI32(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::SExt32, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(SExt32) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::SExt32));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI64ExtendUI32(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::ZExt32, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(ZExt32) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::ZExt32));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF32ConvertSI32(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::IToF, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(IToF) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::IToF));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF32ConvertUI32(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp2 = m_currentBlock->appendNew<Value>(m_proc, B3::ZExt32, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(ZExt32) && temp2->type().isFloat())
        temp2->setKindUnsafely(sensitiveToNaN(B3::ZExt32));
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::IToF, origin(), temp2);
    if (B3::Kind::hasIsSensitiveToNaN(IToF) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::IToF));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF32ConvertSI64(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::IToF, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(IToF) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::IToF));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF32DemoteF64(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::DoubleToFloat, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(DoubleToFloat) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::DoubleToFloat));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF32ReinterpretI32(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::BitwiseCast, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(BitwiseCast) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::BitwiseCast));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF64ConvertSI32(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::IToD, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(IToD) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::IToD));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF64ConvertUI32(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp2 = m_currentBlock->appendNew<Value>(m_proc, B3::ZExt32, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(ZExt32) && temp2->type().isFloat())
        temp2->setKindUnsafely(sensitiveToNaN(B3::ZExt32));
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::IToD, origin(), temp2);
    if (B3::Kind::hasIsSensitiveToNaN(IToD) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::IToD));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF64ConvertSI64(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::IToD, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(IToD) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::IToD));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF64PromoteF32(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::FloatToDouble, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(FloatToDouble) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::FloatToDouble));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addF64ReinterpretI64(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::BitwiseCast, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(BitwiseCast) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::BitwiseCast));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI32ReinterpretF32(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::BitwiseCast, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(BitwiseCast) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::BitwiseCast));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI64ReinterpretF64(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::BitwiseCast, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(BitwiseCast) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::BitwiseCast));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI32Extend8S(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::SExt8, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(SExt8) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::SExt8));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI32Extend16S(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::SExt16, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(SExt16) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::SExt16));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI64Extend8S(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp4 = m_currentBlock->appendNew<Value>(m_proc, B3::Trunc, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(Trunc) && temp4->type().isFloat())
        temp4->setKindUnsafely(sensitiveToNaN(B3::Trunc));
    Value* temp2 = m_currentBlock->appendNew<Value>(m_proc, B3::SExt8, origin(), temp4);
    if (B3::Kind::hasIsSensitiveToNaN(SExt8) && temp2->type().isFloat())
        temp2->setKindUnsafely(sensitiveToNaN(B3::SExt8));
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::SExt32, origin(), temp2);
    if (B3::Kind::hasIsSensitiveToNaN(SExt32) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::SExt32));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI64Extend16S(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp4 = m_currentBlock->appendNew<Value>(m_proc, B3::Trunc, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(Trunc) && temp4->type().isFloat())
        temp4->setKindUnsafely(sensitiveToNaN(B3::Trunc));
    Value* temp2 = m_currentBlock->appendNew<Value>(m_proc, B3::SExt16, origin(), temp4);
    if (B3::Kind::hasIsSensitiveToNaN(SExt16) && temp2->type().isFloat())
        temp2->setKindUnsafely(sensitiveToNaN(B3::SExt16));
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::SExt32, origin(), temp2);
    if (B3::Kind::hasIsSensitiveToNaN(SExt32) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::SExt32));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto B3IRGenerator::addI64Extend32S(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp2 = m_currentBlock->appendNew<Value>(m_proc, B3::Trunc, origin(), get(arg0));
    if (B3::Kind::hasIsSensitiveToNaN(Trunc) && temp2->type().isFloat())
        temp2->setKindUnsafely(sensitiveToNaN(B3::Trunc));
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::SExt32, origin(), temp2);
    if (B3::Kind::hasIsSensitiveToNaN(SExt32) && temp0->type().isFloat())
        temp0->setKindUnsafely(sensitiveToNaN(B3::SExt32));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}


} } // namespace JSC::Wasm

#endif // ENABLE(WEBASSEMBLY)

