/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 * Copyright (C) 2013-2016 Apple Inc. All rights reserved.
 * Copyright (C) 2014 University of Washington. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from Automation.json by the script: Source/JavaScriptCore/inspector/scripts/generate-inspector-protocol-bindings.py

#pragma once

#include "AutomationProtocolObjects.h"
#include <JavaScriptCore/InspectorBackendDispatcher.h>
#include <tuple>
#include <wtf/Expected.h>
#include <wtf/text/WTFString.h>

namespace Inspector {



class AutomationBackendDispatcherHandler {
public:
    class GetBrowsingContextsCallback : public BackendDispatcher::CallbackBase {
    public:
        GetBrowsingContextsCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(Ref<JSON::ArrayOf<Protocol::Automation::BrowsingContext>>&& contexts);
    };
    virtual void getBrowsingContexts(Ref<GetBrowsingContextsCallback>&&) = 0;
    class GetBrowsingContextCallback : public BackendDispatcher::CallbackBase {
    public:
        GetBrowsingContextCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(Ref<Protocol::Automation::BrowsingContext>&& context);
    };
    virtual void getBrowsingContext(const String& handle, Ref<GetBrowsingContextCallback>&&) = 0;
    class CreateBrowsingContextCallback : public BackendDispatcher::CallbackBase {
    public:
        CreateBrowsingContextCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(const String& handle, Protocol::Automation::BrowsingContextPresentation presentation);
    };
    virtual void createBrowsingContext(std::optional<Protocol::Automation::BrowsingContextPresentation>&& opt_presentationHint, Ref<CreateBrowsingContextCallback>&&) = 0;
    virtual Protocol::ErrorStringOr<void> closeBrowsingContext(const String& handle) = 0;
    class SwitchToBrowsingContextCallback : public BackendDispatcher::CallbackBase {
    public:
        SwitchToBrowsingContextCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess();
    };
    virtual void switchToBrowsingContext(const String& browsingContextHandle, const String& opt_frameHandle, Ref<SwitchToBrowsingContextCallback>&&) = 0;
    class SetWindowFrameOfBrowsingContextCallback : public BackendDispatcher::CallbackBase {
    public:
        SetWindowFrameOfBrowsingContextCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess();
    };
    virtual void setWindowFrameOfBrowsingContext(const String& handle, RefPtr<JSON::Object>&& opt_origin, RefPtr<JSON::Object>&& opt_size, Ref<SetWindowFrameOfBrowsingContextCallback>&&) = 0;
    class MaximizeWindowOfBrowsingContextCallback : public BackendDispatcher::CallbackBase {
    public:
        MaximizeWindowOfBrowsingContextCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess();
    };
    virtual void maximizeWindowOfBrowsingContext(const String& handle, Ref<MaximizeWindowOfBrowsingContextCallback>&&) = 0;
    class HideWindowOfBrowsingContextCallback : public BackendDispatcher::CallbackBase {
    public:
        HideWindowOfBrowsingContextCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess();
    };
    virtual void hideWindowOfBrowsingContext(const String& handle, Ref<HideWindowOfBrowsingContextCallback>&&) = 0;
    class NavigateBrowsingContextCallback : public BackendDispatcher::CallbackBase {
    public:
        NavigateBrowsingContextCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess();
    };
    virtual void navigateBrowsingContext(const String& handle, const String& url, std::optional<Protocol::Automation::PageLoadStrategy>&& opt_pageLoadStrategy, std::optional<double>&& opt_pageLoadTimeout, Ref<NavigateBrowsingContextCallback>&&) = 0;
    class GoBackInBrowsingContextCallback : public BackendDispatcher::CallbackBase {
    public:
        GoBackInBrowsingContextCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess();
    };
    virtual void goBackInBrowsingContext(const String& handle, std::optional<Protocol::Automation::PageLoadStrategy>&& opt_pageLoadStrategy, std::optional<double>&& opt_pageLoadTimeout, Ref<GoBackInBrowsingContextCallback>&&) = 0;
    class GoForwardInBrowsingContextCallback : public BackendDispatcher::CallbackBase {
    public:
        GoForwardInBrowsingContextCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess();
    };
    virtual void goForwardInBrowsingContext(const String& handle, std::optional<Protocol::Automation::PageLoadStrategy>&& opt_pageLoadStrategy, std::optional<double>&& opt_pageLoadTimeout, Ref<GoForwardInBrowsingContextCallback>&&) = 0;
    class ReloadBrowsingContextCallback : public BackendDispatcher::CallbackBase {
    public:
        ReloadBrowsingContextCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess();
    };
    virtual void reloadBrowsingContext(const String& handle, std::optional<Protocol::Automation::PageLoadStrategy>&& opt_pageLoadStrategy, std::optional<double>&& opt_pageLoadTimeout, Ref<ReloadBrowsingContextCallback>&&) = 0;
    class WaitForNavigationToCompleteCallback : public BackendDispatcher::CallbackBase {
    public:
        WaitForNavigationToCompleteCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess();
    };
    virtual void waitForNavigationToComplete(const String& browsingContextHandle, const String& opt_frameHandle, std::optional<Protocol::Automation::PageLoadStrategy>&& opt_pageLoadStrategy, std::optional<double>&& opt_pageLoadTimeout, Ref<WaitForNavigationToCompleteCallback>&&) = 0;
#if defined(WTF_PLATFORM_MAC) && WTF_PLATFORM_MAC
    class InspectBrowsingContextCallback : public BackendDispatcher::CallbackBase {
    public:
        InspectBrowsingContextCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess();
    };
    virtual void inspectBrowsingContext(const String& handle, std::optional<bool>&& opt_enableAutoCapturing, Ref<InspectBrowsingContextCallback>&&) = 0;
#endif // defined(WTF_PLATFORM_MAC) && WTF_PLATFORM_MAC
    class EvaluateJavaScriptFunctionCallback : public BackendDispatcher::CallbackBase {
    public:
        EvaluateJavaScriptFunctionCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(const String& result);
    };
    virtual void evaluateJavaScriptFunction(const String& browsingContextHandle, const String& opt_frameHandle, const String& function, Ref<JSON::Array>&& arguments, std::optional<bool>&& opt_expectsImplicitCallbackArgument, std::optional<double>&& opt_callbackTimeout, Ref<EvaluateJavaScriptFunctionCallback>&&) = 0;
    class PerformMouseInteractionCallback : public BackendDispatcher::CallbackBase {
    public:
        PerformMouseInteractionCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(Ref<Protocol::Automation::Point>&& position);
    };
    virtual void performMouseInteraction(const String& handle, Ref<JSON::Object>&& position, Protocol::Automation::MouseButton button, Protocol::Automation::MouseInteraction interaction, Ref<JSON::Array>&& modifiers, Ref<PerformMouseInteractionCallback>&&) = 0;
    class PerformKeyboardInteractionsCallback : public BackendDispatcher::CallbackBase {
    public:
        PerformKeyboardInteractionsCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess();
    };
    virtual void performKeyboardInteractions(const String& handle, Ref<JSON::Array>&& interactions, Ref<PerformKeyboardInteractionsCallback>&&) = 0;
    class PerformInteractionSequenceCallback : public BackendDispatcher::CallbackBase {
    public:
        PerformInteractionSequenceCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess();
    };
    virtual void performInteractionSequence(const String& handle, const String& opt_frameHandle, Ref<JSON::Array>&& inputSources, Ref<JSON::Array>&& steps, Ref<PerformInteractionSequenceCallback>&&) = 0;
    class CancelInteractionSequenceCallback : public BackendDispatcher::CallbackBase {
    public:
        CancelInteractionSequenceCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess();
    };
    virtual void cancelInteractionSequence(const String& handle, const String& opt_frameHandle, Ref<CancelInteractionSequenceCallback>&&) = 0;
    class TakeScreenshotCallback : public BackendDispatcher::CallbackBase {
    public:
        TakeScreenshotCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(const String& data);
    };
    virtual void takeScreenshot(const String& handle, const String& opt_frameHandle, const String& opt_nodeHandle, std::optional<bool>&& opt_scrollIntoViewIfNeeded, std::optional<bool>&& opt_clipToViewport, Ref<TakeScreenshotCallback>&&) = 0;
    class ResolveChildFrameHandleCallback : public BackendDispatcher::CallbackBase {
    public:
        ResolveChildFrameHandleCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(const String& result);
    };
    virtual void resolveChildFrameHandle(const String& browsingContextHandle, const String& opt_frameHandle, std::optional<int>&& opt_ordinal, const String& opt_name, const String& opt_nodeHandle, Ref<ResolveChildFrameHandleCallback>&&) = 0;
    class ResolveParentFrameHandleCallback : public BackendDispatcher::CallbackBase {
    public:
        ResolveParentFrameHandleCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(const String& result);
    };
    virtual void resolveParentFrameHandle(const String& browsingContextHandle, const String& frameHandle, Ref<ResolveParentFrameHandleCallback>&&) = 0;
    class ComputeElementLayoutCallback : public BackendDispatcher::CallbackBase {
    public:
        ComputeElementLayoutCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(Ref<Protocol::Automation::Rect>&& rect, RefPtr<Protocol::Automation::Point>&& opt_inViewCenterPoint, bool isObscured);
    };
    virtual void computeElementLayout(const String& browsingContextHandle, const String& frameHandle, const String& nodeHandle, std::optional<bool>&& opt_scrollIntoViewIfNeeded, Protocol::Automation::CoordinateSystem coordinateSystem, Ref<ComputeElementLayoutCallback>&&) = 0;
    class GetComputedRoleCallback : public BackendDispatcher::CallbackBase {
    public:
        GetComputedRoleCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(const String& role);
    };
    virtual void getComputedRole(const String& browsingContextHandle, const String& frameHandle, const String& nodeHandle, Ref<GetComputedRoleCallback>&&) = 0;
    class GetComputedLabelCallback : public BackendDispatcher::CallbackBase {
    public:
        GetComputedLabelCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(const String& label);
    };
    virtual void getComputedLabel(const String& browsingContextHandle, const String& frameHandle, const String& nodeHandle, Ref<GetComputedLabelCallback>&&) = 0;
    class SelectOptionElementCallback : public BackendDispatcher::CallbackBase {
    public:
        SelectOptionElementCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess();
    };
    virtual void selectOptionElement(const String& browsingContextHandle, const String& frameHandle, const String& nodeHandle, Ref<SelectOptionElementCallback>&&) = 0;
    virtual Protocol::ErrorStringOr<bool /* result */> isShowingJavaScriptDialog(const String& browsingContextHandle) = 0;
    virtual Protocol::ErrorStringOr<void> dismissCurrentJavaScriptDialog(const String& browsingContextHandle) = 0;
    virtual Protocol::ErrorStringOr<void> acceptCurrentJavaScriptDialog(const String& browsingContextHandle) = 0;
    virtual Protocol::ErrorStringOr<String /* message */> messageOfCurrentJavaScriptDialog(const String& browsingContextHandle) = 0;
    virtual Protocol::ErrorStringOr<void> setUserInputForCurrentJavaScriptPrompt(const String& browsingContextHandle, const String& userInput) = 0;
    virtual Protocol::ErrorStringOr<void> setFilesToSelectForFileUpload(const String& browsingContextHandle, Ref<JSON::Array>&& filenames, RefPtr<JSON::Array>&& opt_fileContents) = 0;
    class SetFilesForInputFileUploadCallback : public BackendDispatcher::CallbackBase {
    public:
        SetFilesForInputFileUploadCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess();
    };
    virtual void setFilesForInputFileUpload(const String& browsingContextHandle, const String& frameHandle, const String& nodeHandle, Ref<JSON::Array>&& filenames, Ref<SetFilesForInputFileUploadCallback>&&) = 0;
    class GetAllCookiesCallback : public BackendDispatcher::CallbackBase {
    public:
        GetAllCookiesCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(Ref<JSON::ArrayOf<Protocol::Automation::Cookie>>&& cookies);
    };
    virtual void getAllCookies(const String& browsingContextHandle, Ref<GetAllCookiesCallback>&&) = 0;
    class DeleteSingleCookieCallback : public BackendDispatcher::CallbackBase {
    public:
        DeleteSingleCookieCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess();
    };
    virtual void deleteSingleCookie(const String& browsingContextHandle, const String& cookieName, Ref<DeleteSingleCookieCallback>&&) = 0;
    class AddSingleCookieCallback : public BackendDispatcher::CallbackBase {
    public:
        AddSingleCookieCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess();
    };
    virtual void addSingleCookie(const String& browsingContextHandle, Ref<JSON::Object>&& cookie, Ref<AddSingleCookieCallback>&&) = 0;
    virtual Protocol::ErrorStringOr<void> deleteAllCookies(const String& browsingContextHandle) = 0;
    virtual Protocol::ErrorStringOr<Ref<JSON::ArrayOf<Protocol::Automation::SessionPermissionData>> /* permissions */> getSessionPermissions() = 0;
    virtual Protocol::ErrorStringOr<void> setSessionPermissions(Ref<JSON::Array>&& permissions) = 0;
    virtual Protocol::ErrorStringOr<String /* authenticatorId */> addVirtualAuthenticator(const String& browsingContextHandle, Ref<JSON::Object>&& authenticator) = 0;
    virtual Protocol::ErrorStringOr<void> removeVirtualAuthenticator(const String& browsingContextHandle, const String& authenticatorId) = 0;
    virtual Protocol::ErrorStringOr<void> addVirtualAuthenticatorCredential(const String& browsingContextHandle, const String& authenticatorId, Ref<JSON::Object>&& credential) = 0;
    virtual Protocol::ErrorStringOr<Ref<JSON::ArrayOf<Protocol::Automation::VirtualAuthenticatorCredential>> /* credentials */> getVirtualAuthenticatorCredentials(const String& browsingContextHandle, const String& authenticatorId) = 0;
    virtual Protocol::ErrorStringOr<void> removeVirtualAuthenticatorCredential(const String& browsingContextHandle, const String& authenticatorId, const String& credentialId) = 0;
    virtual Protocol::ErrorStringOr<void> removeAllVirtualAuthenticatorCredentials(const String& browsingContextHandle, const String& authenticatorId) = 0;
    virtual Protocol::ErrorStringOr<void> setVirtualAuthenticatorUserVerified(const String& browsingContextHandle, const String& authenticatorId, bool isUserVerified) = 0;
    virtual Protocol::ErrorStringOr<void> generateTestReport(const String& browsingContextHandle, const String& message, const String& group) = 0;
protected:
    virtual ~AutomationBackendDispatcherHandler();
};

class AutomationBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<AutomationBackendDispatcher> create(BackendDispatcher&, AutomationBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void getBrowsingContexts(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void createBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void closeBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void switchToBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setWindowFrameOfBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void maximizeWindowOfBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void hideWindowOfBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void navigateBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void goBackInBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void goForwardInBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void reloadBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void waitForNavigationToComplete(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if defined(WTF_PLATFORM_MAC) && WTF_PLATFORM_MAC
    void inspectBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // defined(WTF_PLATFORM_MAC) && WTF_PLATFORM_MAC
    void evaluateJavaScriptFunction(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void performMouseInteraction(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void performKeyboardInteractions(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void performInteractionSequence(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void cancelInteractionSequence(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void takeScreenshot(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void resolveChildFrameHandle(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void resolveParentFrameHandle(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void computeElementLayout(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getComputedRole(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getComputedLabel(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void selectOptionElement(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void isShowingJavaScriptDialog(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void dismissCurrentJavaScriptDialog(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void acceptCurrentJavaScriptDialog(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void messageOfCurrentJavaScriptDialog(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setUserInputForCurrentJavaScriptPrompt(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setFilesToSelectForFileUpload(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setFilesForInputFileUpload(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getAllCookies(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void deleteSingleCookie(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void addSingleCookie(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void deleteAllCookies(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getSessionPermissions(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setSessionPermissions(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void addVirtualAuthenticator(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void removeVirtualAuthenticator(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void addVirtualAuthenticatorCredential(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getVirtualAuthenticatorCredentials(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void removeVirtualAuthenticatorCredential(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void removeAllVirtualAuthenticatorCredentials(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setVirtualAuthenticatorUserVerified(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void generateTestReport(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
private:
    AutomationBackendDispatcher(BackendDispatcher&, AutomationBackendDispatcherHandler*);
    AutomationBackendDispatcherHandler* m_agent { nullptr };
};

} // namespace Inspector
