/*
 * Copyright (c) 2016, 2020 Apple Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#pragma once

#include <JavaScriptCore/BuiltinUtils.h>
#include <JavaScriptCore/Identifier.h>
#include <JavaScriptCore/JSFunction.h>
#include <JavaScriptCore/UnlinkedFunctionExecutable.h>

namespace JSC {
class FunctionExecutable;
}

namespace WebCore {

/* WritableStreamDefaultWriter */
extern const char* const s_writableStreamDefaultWriterInitializeWritableStreamDefaultWriterCode;
extern const int s_writableStreamDefaultWriterInitializeWritableStreamDefaultWriterCodeLength;
extern const JSC::ConstructAbility s_writableStreamDefaultWriterInitializeWritableStreamDefaultWriterCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamDefaultWriterInitializeWritableStreamDefaultWriterCodeConstructorKind;
extern const JSC::ImplementationVisibility s_writableStreamDefaultWriterInitializeWritableStreamDefaultWriterCodeImplementationVisibility;
extern const JSC::InlineAttribute s_writableStreamDefaultWriterInitializeWritableStreamDefaultWriterCodeInlineAttribute;
extern const char* const s_writableStreamDefaultWriterClosedCode;
extern const int s_writableStreamDefaultWriterClosedCodeLength;
extern const JSC::ConstructAbility s_writableStreamDefaultWriterClosedCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamDefaultWriterClosedCodeConstructorKind;
extern const JSC::ImplementationVisibility s_writableStreamDefaultWriterClosedCodeImplementationVisibility;
extern const JSC::InlineAttribute s_writableStreamDefaultWriterClosedCodeInlineAttribute;
extern const char* const s_writableStreamDefaultWriterDesiredSizeCode;
extern const int s_writableStreamDefaultWriterDesiredSizeCodeLength;
extern const JSC::ConstructAbility s_writableStreamDefaultWriterDesiredSizeCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamDefaultWriterDesiredSizeCodeConstructorKind;
extern const JSC::ImplementationVisibility s_writableStreamDefaultWriterDesiredSizeCodeImplementationVisibility;
extern const JSC::InlineAttribute s_writableStreamDefaultWriterDesiredSizeCodeInlineAttribute;
extern const char* const s_writableStreamDefaultWriterReadyCode;
extern const int s_writableStreamDefaultWriterReadyCodeLength;
extern const JSC::ConstructAbility s_writableStreamDefaultWriterReadyCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamDefaultWriterReadyCodeConstructorKind;
extern const JSC::ImplementationVisibility s_writableStreamDefaultWriterReadyCodeImplementationVisibility;
extern const JSC::InlineAttribute s_writableStreamDefaultWriterReadyCodeInlineAttribute;
extern const char* const s_writableStreamDefaultWriterAbortCode;
extern const int s_writableStreamDefaultWriterAbortCodeLength;
extern const JSC::ConstructAbility s_writableStreamDefaultWriterAbortCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamDefaultWriterAbortCodeConstructorKind;
extern const JSC::ImplementationVisibility s_writableStreamDefaultWriterAbortCodeImplementationVisibility;
extern const JSC::InlineAttribute s_writableStreamDefaultWriterAbortCodeInlineAttribute;
extern const char* const s_writableStreamDefaultWriterCloseCode;
extern const int s_writableStreamDefaultWriterCloseCodeLength;
extern const JSC::ConstructAbility s_writableStreamDefaultWriterCloseCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamDefaultWriterCloseCodeConstructorKind;
extern const JSC::ImplementationVisibility s_writableStreamDefaultWriterCloseCodeImplementationVisibility;
extern const JSC::InlineAttribute s_writableStreamDefaultWriterCloseCodeInlineAttribute;
extern const char* const s_writableStreamDefaultWriterReleaseLockCode;
extern const int s_writableStreamDefaultWriterReleaseLockCodeLength;
extern const JSC::ConstructAbility s_writableStreamDefaultWriterReleaseLockCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamDefaultWriterReleaseLockCodeConstructorKind;
extern const JSC::ImplementationVisibility s_writableStreamDefaultWriterReleaseLockCodeImplementationVisibility;
extern const JSC::InlineAttribute s_writableStreamDefaultWriterReleaseLockCodeInlineAttribute;
extern const char* const s_writableStreamDefaultWriterWriteCode;
extern const int s_writableStreamDefaultWriterWriteCodeLength;
extern const JSC::ConstructAbility s_writableStreamDefaultWriterWriteCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamDefaultWriterWriteCodeConstructorKind;
extern const JSC::ImplementationVisibility s_writableStreamDefaultWriterWriteCodeImplementationVisibility;
extern const JSC::InlineAttribute s_writableStreamDefaultWriterWriteCodeInlineAttribute;

#define WEBCORE_FOREACH_WRITABLESTREAMDEFAULTWRITER_BUILTIN_DATA(macro) \
    macro(initializeWritableStreamDefaultWriter, writableStreamDefaultWriterInitializeWritableStreamDefaultWriter, 1) \
    macro(closed, writableStreamDefaultWriterClosed, 0) \
    macro(desiredSize, writableStreamDefaultWriterDesiredSize, 0) \
    macro(ready, writableStreamDefaultWriterReady, 0) \
    macro(abort, writableStreamDefaultWriterAbort, 0) \
    macro(close, writableStreamDefaultWriterClose, 0) \
    macro(releaseLock, writableStreamDefaultWriterReleaseLock, 0) \
    macro(write, writableStreamDefaultWriterWrite, 0) \

#define WEBCORE_BUILTIN_WRITABLESTREAMDEFAULTWRITER_INITIALIZEWRITABLESTREAMDEFAULTWRITER 1
#define WEBCORE_BUILTIN_WRITABLESTREAMDEFAULTWRITER_CLOSED 1
#define WEBCORE_BUILTIN_WRITABLESTREAMDEFAULTWRITER_DESIREDSIZE 1
#define WEBCORE_BUILTIN_WRITABLESTREAMDEFAULTWRITER_READY 1
#define WEBCORE_BUILTIN_WRITABLESTREAMDEFAULTWRITER_ABORT 1
#define WEBCORE_BUILTIN_WRITABLESTREAMDEFAULTWRITER_CLOSE 1
#define WEBCORE_BUILTIN_WRITABLESTREAMDEFAULTWRITER_RELEASELOCK 1
#define WEBCORE_BUILTIN_WRITABLESTREAMDEFAULTWRITER_WRITE 1

#define WEBCORE_FOREACH_WRITABLESTREAMDEFAULTWRITER_BUILTIN_CODE(macro) \
    macro(writableStreamDefaultWriterInitializeWritableStreamDefaultWriterCode, initializeWritableStreamDefaultWriter, ASCIILiteral(), s_writableStreamDefaultWriterInitializeWritableStreamDefaultWriterCodeLength) \
    macro(writableStreamDefaultWriterClosedCode, closed, "get closed"_s, s_writableStreamDefaultWriterClosedCodeLength) \
    macro(writableStreamDefaultWriterDesiredSizeCode, desiredSize, "get desiredSize"_s, s_writableStreamDefaultWriterDesiredSizeCodeLength) \
    macro(writableStreamDefaultWriterReadyCode, ready, "get ready"_s, s_writableStreamDefaultWriterReadyCodeLength) \
    macro(writableStreamDefaultWriterAbortCode, abort, ASCIILiteral(), s_writableStreamDefaultWriterAbortCodeLength) \
    macro(writableStreamDefaultWriterCloseCode, close, ASCIILiteral(), s_writableStreamDefaultWriterCloseCodeLength) \
    macro(writableStreamDefaultWriterReleaseLockCode, releaseLock, ASCIILiteral(), s_writableStreamDefaultWriterReleaseLockCodeLength) \
    macro(writableStreamDefaultWriterWriteCode, write, ASCIILiteral(), s_writableStreamDefaultWriterWriteCodeLength) \

#define WEBCORE_FOREACH_WRITABLESTREAMDEFAULTWRITER_BUILTIN_FUNCTION_NAME(macro) \
    macro(abort) \
    macro(close) \
    macro(closed) \
    macro(desiredSize) \
    macro(initializeWritableStreamDefaultWriter) \
    macro(ready) \
    macro(releaseLock) \
    macro(write) \

#define DECLARE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
    JSC::FunctionExecutable* codeName##Generator(JSC::VM&);

WEBCORE_FOREACH_WRITABLESTREAMDEFAULTWRITER_BUILTIN_CODE(DECLARE_BUILTIN_GENERATOR)
#undef DECLARE_BUILTIN_GENERATOR

class WritableStreamDefaultWriterBuiltinsWrapper : private JSC::WeakHandleOwner {
public:
    explicit WritableStreamDefaultWriterBuiltinsWrapper(JSC::VM& vm)
        : m_vm(vm)
        WEBCORE_FOREACH_WRITABLESTREAMDEFAULTWRITER_BUILTIN_FUNCTION_NAME(INITIALIZE_BUILTIN_NAMES)
#define INITIALIZE_BUILTIN_SOURCE_MEMBERS(name, functionName, overriddenName, length) , m_##name##Source(JSC::makeSource(StringImpl::createWithoutCopying(s_##name, length), { }, JSC::SourceTaintedOrigin::Untainted))
        WEBCORE_FOREACH_WRITABLESTREAMDEFAULTWRITER_BUILTIN_CODE(INITIALIZE_BUILTIN_SOURCE_MEMBERS)
#undef INITIALIZE_BUILTIN_SOURCE_MEMBERS
    {
    }

#define EXPOSE_BUILTIN_EXECUTABLES(name, functionName, overriddenName, length) \
    JSC::UnlinkedFunctionExecutable* name##Executable(); \
    const JSC::SourceCode& name##Source() const { return m_##name##Source; }
    WEBCORE_FOREACH_WRITABLESTREAMDEFAULTWRITER_BUILTIN_CODE(EXPOSE_BUILTIN_EXECUTABLES)
#undef EXPOSE_BUILTIN_EXECUTABLES

    WEBCORE_FOREACH_WRITABLESTREAMDEFAULTWRITER_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_IDENTIFIER_ACCESSOR)

    void exportNames();

private:
    JSC::VM& m_vm;

    WEBCORE_FOREACH_WRITABLESTREAMDEFAULTWRITER_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_NAMES)

#define DECLARE_BUILTIN_SOURCE_MEMBERS(name, functionName, overriddenName, length) \
    JSC::SourceCode m_##name##Source;\
    JSC::Weak<JSC::UnlinkedFunctionExecutable> m_##name##Executable;
    WEBCORE_FOREACH_WRITABLESTREAMDEFAULTWRITER_BUILTIN_CODE(DECLARE_BUILTIN_SOURCE_MEMBERS)
#undef DECLARE_BUILTIN_SOURCE_MEMBERS

};

#define DEFINE_BUILTIN_EXECUTABLES(name, functionName, overriddenName, length) \
inline JSC::UnlinkedFunctionExecutable* WritableStreamDefaultWriterBuiltinsWrapper::name##Executable() \
{\
    if (!m_##name##Executable) {\
        JSC::Identifier executableName = functionName##PublicName();\
        if (overriddenName)\
            executableName = JSC::Identifier::fromString(m_vm, overriddenName);\
        m_##name##Executable = JSC::Weak<JSC::UnlinkedFunctionExecutable>(JSC::createBuiltinExecutable(m_vm, m_##name##Source, executableName, s_##name##ImplementationVisibility, s_##name##ConstructorKind, s_##name##ConstructAbility, s_##name##InlineAttribute), this, &m_##name##Executable);\
    }\
    return m_##name##Executable.get();\
}
WEBCORE_FOREACH_WRITABLESTREAMDEFAULTWRITER_BUILTIN_CODE(DEFINE_BUILTIN_EXECUTABLES)
#undef DEFINE_BUILTIN_EXECUTABLES

inline void WritableStreamDefaultWriterBuiltinsWrapper::exportNames()
{
#define EXPORT_FUNCTION_NAME(name) m_vm.propertyNames->appendExternalName(name##PublicName(), name##PrivateName());
    WEBCORE_FOREACH_WRITABLESTREAMDEFAULTWRITER_BUILTIN_FUNCTION_NAME(EXPORT_FUNCTION_NAME)
#undef EXPORT_FUNCTION_NAME
}

} // namespace WebCore
