// This file is automatically generated from CSSProperties.json by the process-css-properties.py script. Do not edit it.

#include "config.h"
#include "StyleBuilderGenerated.h"

#include "CSSPrimitiveValueMappings.h"
#include "CSSProperty.h"
#include "RenderStyleSetters.h"
#include "StyleBuilderConverter.h"
#include "StyleBuilderCustom.h"
#include "StyleBuilderState.h"
#include "StylePropertyShorthand.h"

namespace WebCore {
namespace Style {

class BuilderFunctions {
public:
    static void applyInitialColorScheme(BuilderState& builderState)
    {
        builderState.style().setColorScheme(RenderStyle::initialColorScheme());
    }
    static void applyInheritColorScheme(BuilderState& builderState)
    {
        builderState.style().setColorScheme(forwardInheritedValue(builderState.parentStyle().colorScheme()));
    }
    static void applyInitialWritingMode(BuilderState& builderState)
    {
        builderState.style().setWritingMode(RenderStyle::initialWritingMode());
    }
    static void applyInheritWritingMode(BuilderState& builderState)
    {
        builderState.style().setWritingMode(forwardInheritedValue(builderState.parentStyle().writingMode()));
    }
    static void applyInitialWebkitRubyPosition(BuilderState& builderState)
    {
        builderState.style().setRubyPosition(RenderStyle::initialRubyPosition());
    }
    static void applyInheritWebkitRubyPosition(BuilderState& builderState)
    {
        builderState.style().setRubyPosition(forwardInheritedValue(builderState.parentStyle().rubyPosition()));
    }
    static void applyValueWebkitRubyPosition(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setRubyPosition(fromCSSValueDeducingType(value));
    }
    static void applyInitialDirection(BuilderState& builderState)
    {
        builderState.style().setDirection(RenderStyle::initialDirection());
    }
    static void applyInheritDirection(BuilderState& builderState)
    {
        builderState.style().setDirection(forwardInheritedValue(builderState.parentStyle().direction()));
    }
    static void applyInitialDisplay(BuilderState& builderState)
    {
        builderState.style().setDisplay(RenderStyle::initialDisplay());
    }
    static void applyInheritDisplay(BuilderState& builderState)
    {
        builderState.style().setDisplay(forwardInheritedValue(builderState.parentStyle().display()));
    }
    static void applyValueDisplay(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setDisplay(fromCSSValueDeducingType(value));
    }
    static void applyValueFontFeatureSettings(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFeatureSettings(BuilderConverter::convertFontFeatureSettings(builderState, value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialFontKerning(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setKerning(FontCascadeDescription::initialKerning());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritFontKerning(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setKerning(builderState.parentFontDescription().kerning());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontKerning(BuilderState& builderState, CSSValue& value)
    {
        if (CSSPropertyParserHelpers::isSystemFontShorthand(value.valueID())) {
            applyInitialFontKerning(builderState);
            return;
        }
        auto fontDescription = builderState.fontDescription();
        fontDescription.setKerning(fromCSSValueDeducingType(value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialFontOpticalSizing(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setOpticalSizing(FontCascadeDescription::initialOpticalSizing());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritFontOpticalSizing(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setOpticalSizing(builderState.parentFontDescription().opticalSizing());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontOpticalSizing(BuilderState& builderState, CSSValue& value)
    {
        if (CSSPropertyParserHelpers::isSystemFontShorthand(value.valueID())) {
            applyInitialFontOpticalSizing(builderState);
            return;
        }
        auto fontDescription = builderState.fontDescription();
        fontDescription.setOpticalSizing(fromCSSValueDeducingType(value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialFontPalette(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontPalette(FontCascadeDescription::initialFontPalette());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritFontPalette(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontPalette(builderState.parentFontDescription().fontPalette());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontPalette(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontPalette(BuilderConverter::convertFontPalette(builderState, value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialFontSizeAdjust(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSizeAdjust(FontCascadeDescription::initialFontSizeAdjust());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritFontSizeAdjust(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSizeAdjust(builderState.parentFontDescription().fontSizeAdjust());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialFontStretch(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setStretch(FontCascadeDescription::initialStretch());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritFontStretch(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setStretch(builderState.parentFontDescription().stretch());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontStretch(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setStretch(BuilderConverter::convertFontStretch(builderState, value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialFontSynthesisSmallCaps(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSynthesisSmallCaps(FontCascadeDescription::initialFontSynthesisSmallCaps());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritFontSynthesisSmallCaps(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSynthesisSmallCaps(builderState.parentFontDescription().fontSynthesisSmallCaps());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontSynthesisSmallCaps(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSynthesisSmallCaps(fromCSSValueDeducingType(value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialFontSynthesisStyle(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSynthesisStyle(FontCascadeDescription::initialFontSynthesisStyle());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritFontSynthesisStyle(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSynthesisStyle(builderState.parentFontDescription().fontSynthesisStyle());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontSynthesisStyle(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSynthesisStyle(fromCSSValueDeducingType(value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialFontSynthesisWeight(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSynthesisWeight(FontCascadeDescription::initialFontSynthesisWeight());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritFontSynthesisWeight(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSynthesisWeight(builderState.parentFontDescription().fontSynthesisWeight());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontSynthesisWeight(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSynthesisWeight(fromCSSValueDeducingType(value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialFontVariantCaps(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setVariantCaps(FontCascadeDescription::initialVariantCaps());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritFontVariantCaps(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setVariantCaps(builderState.parentFontDescription().variantCaps());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontVariantCaps(BuilderState& builderState, CSSValue& value)
    {
        if (CSSPropertyParserHelpers::isSystemFontShorthand(value.valueID())) {
            applyInitialFontVariantCaps(builderState);
            return;
        }
        auto fontDescription = builderState.fontDescription();
        fontDescription.setVariantCaps(fromCSSValueDeducingType(value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialFontVariantEmoji(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setVariantEmoji(FontCascadeDescription::initialVariantEmoji());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritFontVariantEmoji(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setVariantEmoji(builderState.parentFontDescription().variantEmoji());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontVariantEmoji(BuilderState& builderState, CSSValue& value)
    {
        if (CSSPropertyParserHelpers::isSystemFontShorthand(value.valueID())) {
            applyInitialFontVariantEmoji(builderState);
            return;
        }
        auto fontDescription = builderState.fontDescription();
        fontDescription.setVariantEmoji(fromCSSValueDeducingType(value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialFontVariantPosition(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setVariantPosition(FontCascadeDescription::initialVariantPosition());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritFontVariantPosition(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setVariantPosition(builderState.parentFontDescription().variantPosition());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontVariantPosition(BuilderState& builderState, CSSValue& value)
    {
        if (CSSPropertyParserHelpers::isSystemFontShorthand(value.valueID())) {
            applyInitialFontVariantPosition(builderState);
            return;
        }
        auto fontDescription = builderState.fontDescription();
        fontDescription.setVariantPosition(fromCSSValueDeducingType(value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontVariationSettings(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setVariationSettings(BuilderConverter::convertFontVariationSettings(builderState, value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialFontWeight(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setWeight(FontCascadeDescription::initialWeight());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritFontWeight(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setWeight(builderState.parentFontDescription().weight());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueFontWeight(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setWeight(BuilderConverter::convertFontWeight(builderState, value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialTextOrientation(BuilderState& builderState)
    {
        builderState.style().setTextOrientation(RenderStyle::initialTextOrientation());
    }
    static void applyInheritTextOrientation(BuilderState& builderState)
    {
        builderState.style().setTextOrientation(forwardInheritedValue(builderState.parentStyle().textOrientation()));
    }
    static void applyInitialTextRendering(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setTextRenderingMode(FontCascadeDescription::initialTextRenderingMode());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritTextRendering(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setTextRenderingMode(builderState.parentFontDescription().textRenderingMode());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueTextRendering(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setTextRenderingMode(fromCSSValueDeducingType(value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialWebkitFontSmoothing(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSmoothing(FontCascadeDescription::initialFontSmoothing());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritWebkitFontSmoothing(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSmoothing(builderState.parentFontDescription().fontSmoothing());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueWebkitFontSmoothing(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setFontSmoothing(fromCSSValueDeducingType(value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialWebkitLocale(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setSpecifiedLocale(FontCascadeDescription::initialSpecifiedLocale());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritWebkitLocale(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setSpecifiedLocale(builderState.parentFontDescription().specifiedLocale());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialWebkitTextZoom(BuilderState& builderState)
    {
        builderState.style().setTextZoom(RenderStyle::initialTextZoom());
    }
    static void applyInheritWebkitTextZoom(BuilderState& builderState)
    {
        builderState.style().setTextZoom(forwardInheritedValue(builderState.parentStyle().textZoom()));
    }
    static void applyInitialTextAutospace(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setTextAutospace(FontCascadeDescription::initialTextAutospace());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritTextAutospace(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setTextAutospace(builderState.parentFontDescription().textAutospace());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueTextAutospace(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setTextAutospace(BuilderConverter::convertTextAutospace(builderState, value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialTextSpacingTrim(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setTextSpacingTrim(FontCascadeDescription::initialTextSpacingTrim());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInheritTextSpacingTrim(BuilderState& builderState)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setTextSpacingTrim(builderState.parentFontDescription().textSpacingTrim());
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyValueTextSpacingTrim(BuilderState& builderState, CSSValue& value)
    {
        auto fontDescription = builderState.fontDescription();
        fontDescription.setTextSpacingTrim(BuilderConverter::convertTextSpacingTrim(builderState, value));
        builderState.setFontDescription(WTFMove(fontDescription));
    }
    static void applyInitialAccentColor(BuilderState& builderState)
    {
        builderState.style().setHasAutoAccentColor();
    }
    static void applyInheritAccentColor(BuilderState& builderState)
    {
        if (builderState.parentStyle().hasAutoAccentColor()) {
            builderState.style().setHasAutoAccentColor();
            return;
        }
        builderState.style().setAccentColor(forwardInheritedValue(builderState.parentStyle().accentColor()));
    }
    static void applyValueAccentColor(BuilderState& builderState, CSSValue& value)
    {
        if (value.valueID() == CSSValueAuto) {
            builderState.style().setHasAutoAccentColor();
            return;
        }
        builderState.style().setAccentColor(builderState.colorFromPrimitiveValue(downcast<CSSPrimitiveValue>(value), ForVisitedLink::No));
    }
    static void applyInitialAlignContent(BuilderState& builderState)
    {
        builderState.style().setAlignContent(RenderStyle::initialContentAlignment());
    }
    static void applyInheritAlignContent(BuilderState& builderState)
    {
        builderState.style().setAlignContent(forwardInheritedValue(builderState.parentStyle().alignContent()));
    }
    static void applyValueAlignContent(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setAlignContent(BuilderConverter::convertContentAlignmentData(builderState, value));
    }
    static void applyInitialAlignItems(BuilderState& builderState)
    {
        builderState.style().setAlignItems(RenderStyle::initialDefaultAlignment());
    }
    static void applyInheritAlignItems(BuilderState& builderState)
    {
        builderState.style().setAlignItems(forwardInheritedValue(builderState.parentStyle().alignItems()));
    }
    static void applyValueAlignItems(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setAlignItems(BuilderConverter::convertSelfOrDefaultAlignmentData(builderState, value));
    }
    static void applyInitialAlignSelf(BuilderState& builderState)
    {
        builderState.style().setAlignSelf(RenderStyle::initialSelfAlignment());
    }
    static void applyInheritAlignSelf(BuilderState& builderState)
    {
        builderState.style().setAlignSelf(forwardInheritedValue(builderState.parentStyle().alignSelf()));
    }
    static void applyValueAlignSelf(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setAlignSelf(BuilderConverter::convertSelfOrDefaultAlignmentData(builderState, value));
    }
    static void applyInitialAlignmentBaseline(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setAlignmentBaseline(SVGRenderStyle::initialAlignmentBaseline());
    }
    static void applyInheritAlignmentBaseline(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setAlignmentBaseline(forwardInheritedValue(builderState.parentStyle().svgStyle().alignmentBaseline()));
    }
    static void applyValueAlignmentBaseline(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setAlignmentBaseline(fromCSSValueDeducingType(value));
    }
    static void applyInitialAnimationComposition(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setCompositeOperation(Animation::initialCompositeOperation());
        for (auto& animation : list)
            animation->clearCompositeOperation();
    }
    static void applyInheritAnimationComposition(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        auto* parentList = builderState.parentStyle().animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isCompositeOperationSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setCompositeOperation(parentList->animation(i).compositeOperation());
        }
        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearCompositeOperation();
    }
    static void applyValueAnimationComposition(BuilderState& builderState, CSSValue& value)
    {
        auto& list = builderState.style().ensureAnimations();
        size_t childIndex = 0;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into an animation, creating new animations as needed.
            for (auto& currentValue : *valueList) {
                if (childIndex >= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationCompositeOperation(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationCompositeOperation(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            // Reset all remaining animations to not have the property set.
            list.animation(childIndex).clearCompositeOperation();
        }
    }
    static void applyInitialAnimationDelay(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setDelay(Animation::initialDelay());
        for (auto& animation : list)
            animation->clearDelay();
    }
    static void applyInheritAnimationDelay(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        auto* parentList = builderState.parentStyle().animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isDelaySet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setDelay(parentList->animation(i).delay());
        }
        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearDelay();
    }
    static void applyValueAnimationDelay(BuilderState& builderState, CSSValue& value)
    {
        auto& list = builderState.style().ensureAnimations();
        size_t childIndex = 0;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into an animation, creating new animations as needed.
            for (auto& currentValue : *valueList) {
                if (childIndex >= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationDelay(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationDelay(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            // Reset all remaining animations to not have the property set.
            list.animation(childIndex).clearDelay();
        }
    }
    static void applyInitialAnimationDirection(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setDirection(Animation::initialDirection());
        for (auto& animation : list)
            animation->clearDirection();
    }
    static void applyInheritAnimationDirection(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        auto* parentList = builderState.parentStyle().animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isDirectionSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setDirection(parentList->animation(i).direction());
        }
        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearDirection();
    }
    static void applyValueAnimationDirection(BuilderState& builderState, CSSValue& value)
    {
        auto& list = builderState.style().ensureAnimations();
        size_t childIndex = 0;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into an animation, creating new animations as needed.
            for (auto& currentValue : *valueList) {
                if (childIndex >= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationDirection(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationDirection(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            // Reset all remaining animations to not have the property set.
            list.animation(childIndex).clearDirection();
        }
    }
    static void applyInitialAnimationDuration(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setDuration(Animation::initialDuration());
        for (auto& animation : list)
            animation->clearDuration();
    }
    static void applyInheritAnimationDuration(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        auto* parentList = builderState.parentStyle().animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isDurationSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setDuration(parentList->animation(i).duration());
        }
        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearDuration();
    }
    static void applyValueAnimationDuration(BuilderState& builderState, CSSValue& value)
    {
        auto& list = builderState.style().ensureAnimations();
        size_t childIndex = 0;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into an animation, creating new animations as needed.
            for (auto& currentValue : *valueList) {
                if (childIndex >= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationDuration(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationDuration(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            // Reset all remaining animations to not have the property set.
            list.animation(childIndex).clearDuration();
        }
    }
    static void applyInitialAnimationFillMode(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setFillMode(Animation::initialFillMode());
        for (auto& animation : list)
            animation->clearFillMode();
    }
    static void applyInheritAnimationFillMode(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        auto* parentList = builderState.parentStyle().animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isFillModeSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setFillMode(parentList->animation(i).fillMode());
        }
        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearFillMode();
    }
    static void applyValueAnimationFillMode(BuilderState& builderState, CSSValue& value)
    {
        auto& list = builderState.style().ensureAnimations();
        size_t childIndex = 0;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into an animation, creating new animations as needed.
            for (auto& currentValue : *valueList) {
                if (childIndex >= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationFillMode(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationFillMode(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            // Reset all remaining animations to not have the property set.
            list.animation(childIndex).clearFillMode();
        }
    }
    static void applyInitialAnimationIterationCount(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setIterationCount(Animation::initialIterationCount());
        for (auto& animation : list)
            animation->clearIterationCount();
    }
    static void applyInheritAnimationIterationCount(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        auto* parentList = builderState.parentStyle().animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isIterationCountSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setIterationCount(parentList->animation(i).iterationCount());
        }
        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearIterationCount();
    }
    static void applyValueAnimationIterationCount(BuilderState& builderState, CSSValue& value)
    {
        auto& list = builderState.style().ensureAnimations();
        size_t childIndex = 0;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into an animation, creating new animations as needed.
            for (auto& currentValue : *valueList) {
                if (childIndex >= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationIterationCount(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationIterationCount(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            // Reset all remaining animations to not have the property set.
            list.animation(childIndex).clearIterationCount();
        }
    }
    static void applyInitialAnimationName(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setName(Animation::initialName());
        for (auto& animation : list)
            animation->clearName();
    }
    static void applyInheritAnimationName(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        auto* parentList = builderState.parentStyle().animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isNameSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setName(parentList->animation(i).name());
        }
        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearName();
    }
    static void applyValueAnimationName(BuilderState& builderState, CSSValue& value)
    {
        auto& list = builderState.style().ensureAnimations();
        size_t childIndex = 0;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into an animation, creating new animations as needed.
            for (auto& currentValue : *valueList) {
                if (childIndex >= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationName(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationName(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            // Reset all remaining animations to not have the property set.
            list.animation(childIndex).clearName();
        }
    }
    static void applyInitialAnimationPlayState(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setPlayState(Animation::initialPlayState());
        for (auto& animation : list)
            animation->clearPlayState();
    }
    static void applyInheritAnimationPlayState(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        auto* parentList = builderState.parentStyle().animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isPlayStateSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setPlayState(parentList->animation(i).playState());
        }
        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearPlayState();
    }
    static void applyValueAnimationPlayState(BuilderState& builderState, CSSValue& value)
    {
        auto& list = builderState.style().ensureAnimations();
        size_t childIndex = 0;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into an animation, creating new animations as needed.
            for (auto& currentValue : *valueList) {
                if (childIndex >= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationPlayState(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationPlayState(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            // Reset all remaining animations to not have the property set.
            list.animation(childIndex).clearPlayState();
        }
    }
    static void applyInitialAnimationTimeline(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setTimeline(Animation::initialTimeline());
        for (auto& animation : list)
            animation->clearTimeline();
    }
    static void applyInheritAnimationTimeline(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        auto* parentList = builderState.parentStyle().animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isTimelineSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setTimeline(parentList->animation(i).timeline());
        }
        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearTimeline();
    }
    static void applyValueAnimationTimeline(BuilderState& builderState, CSSValue& value)
    {
        auto& list = builderState.style().ensureAnimations();
        size_t childIndex = 0;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into an animation, creating new animations as needed.
            for (auto& currentValue : *valueList) {
                if (childIndex >= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationTimeline(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationTimeline(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            // Reset all remaining animations to not have the property set.
            list.animation(childIndex).clearTimeline();
        }
    }
    static void applyInitialAnimationTimingFunction(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setTimingFunction(Animation::initialTimingFunction());
        for (auto& animation : list)
            animation->clearTimingFunction();
    }
    static void applyInheritAnimationTimingFunction(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureAnimations();
        auto* parentList = builderState.parentStyle().animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isTimingFunctionSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setTimingFunction(parentList->animation(i).timingFunction());
        }
        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearTimingFunction();
    }
    static void applyValueAnimationTimingFunction(BuilderState& builderState, CSSValue& value)
    {
        auto& list = builderState.style().ensureAnimations();
        size_t childIndex = 0;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into an animation, creating new animations as needed.
            for (auto& currentValue : *valueList) {
                if (childIndex >= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationTimingFunction(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationTimingFunction(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            // Reset all remaining animations to not have the property set.
            list.animation(childIndex).clearTimingFunction();
        }
    }
    static void applyInitialAppearance(BuilderState& builderState)
    {
        builderState.style().setAppearance(RenderStyle::initialAppearance());
    }
    static void applyInheritAppearance(BuilderState& builderState)
    {
        builderState.style().setAppearance(forwardInheritedValue(builderState.parentStyle().appearance()));
    }
    static void applyValueAppearance(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setAppearance(fromCSSValueDeducingType(value));
    }
    static void applyInitialBackfaceVisibility(BuilderState& builderState)
    {
        builderState.style().setBackfaceVisibility(RenderStyle::initialBackfaceVisibility());
    }
    static void applyInheritBackfaceVisibility(BuilderState& builderState)
    {
        builderState.style().setBackfaceVisibility(forwardInheritedValue(builderState.parentStyle().backfaceVisibility()));
    }
    static void applyValueBackfaceVisibility(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBackfaceVisibility(fromCSSValueDeducingType(value));
    }
    static void applyInitialBackgroundAttachment(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isAttachmentSet() || layers.attachment() == FillLayer::initialFillAttachment(FillLayerType::Background)))
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setAttachment(FillLayer::initialFillAttachment(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearAttachment();
    }
    static void applyInheritBackgroundAttachment(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isAttachmentSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setAttachment(parent->attachment());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearAttachment();
    }
    static void applyValueBackgroundAttachment(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillAttachment(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillAttachment(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearAttachment();
    }
    static void applyInitialBackgroundBlendMode(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isBlendModeSet() || layers.blendMode() == FillLayer::initialFillBlendMode(FillLayerType::Background)))
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setBlendMode(FillLayer::initialFillBlendMode(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearBlendMode();
    }
    static void applyInheritBackgroundBlendMode(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isBlendModeSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setBlendMode(parent->blendMode());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearBlendMode();
    }
    static void applyValueBackgroundBlendMode(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillBlendMode(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillBlendMode(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearBlendMode();
    }
    static void applyInitialBackgroundColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBackgroundColor(RenderStyle::initialBackgroundColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBackgroundColor(RenderStyle::initialBackgroundColor());
    }
    static void applyInheritBackgroundColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBackgroundColor(builderState.parentStyle().backgroundColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBackgroundColor(builderState.parentStyle().backgroundColor());
    }
    static void applyValueBackgroundColor(BuilderState& builderState, CSSValue& value)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBackgroundColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::No));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBackgroundColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::Yes));
    }
    static void applyInitialBackgroundImage(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isImageSet() || layers.image() == FillLayer::initialFillImage(FillLayerType::Background)))
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setImage(FillLayer::initialFillImage(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearImage();
    }
    static void applyInheritBackgroundImage(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isImageSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setImage(parent->image());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearImage();
    }
    static void applyValueBackgroundImage(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillImage(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillImage(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearImage();
    }
    static void applyInitialBackgroundPositionX(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isXPositionSet() || layers.xPosition() == FillLayer::initialFillXPosition(FillLayerType::Background)))
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setXPosition(FillLayer::initialFillXPosition(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearXPosition();
    }
    static void applyInheritBackgroundPositionX(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isXPositionSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setXPosition(parent->xPosition());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearXPosition();
    }
    static void applyValueBackgroundPositionX(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillXPosition(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillXPosition(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearXPosition();
    }
    static void applyInitialBackgroundPositionY(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isYPositionSet() || layers.yPosition() == FillLayer::initialFillYPosition(FillLayerType::Background)))
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setYPosition(FillLayer::initialFillYPosition(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearYPosition();
    }
    static void applyInheritBackgroundPositionY(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isYPositionSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setYPosition(parent->yPosition());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearYPosition();
    }
    static void applyValueBackgroundPositionY(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillYPosition(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillYPosition(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearYPosition();
    }
    static void applyInitialBackgroundRepeat(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isRepeatSet() || layers.repeat() == FillLayer::initialFillRepeat(FillLayerType::Background)))
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setRepeat(FillLayer::initialFillRepeat(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearRepeat();
    }
    static void applyInheritBackgroundRepeat(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isRepeatSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setRepeat(parent->repeat());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearRepeat();
    }
    static void applyValueBackgroundRepeat(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillRepeat(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillRepeat(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearRepeat();
    }
    static void applyInitialBackgroundSize(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isSizeSet() || layers.size() == FillLayer::initialFillSize(FillLayerType::Background)))
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setSize(FillLayer::initialFillSize(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearSize();
    }
    static void applyInheritBackgroundSize(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isSizeSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setSize(parent->size());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearSize();
    }
    static void applyValueBackgroundSize(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillSize(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillSize(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearSize();
    }
    static void applyInitialBaselineShift(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setBaselineShift(SVGRenderStyle::initialBaselineShift());
    }
    static void applyInitialBlockStepInsert(BuilderState& builderState)
    {
        builderState.style().setBlockStepInsert(RenderStyle::initialBlockStepInsert());
    }
    static void applyInheritBlockStepInsert(BuilderState& builderState)
    {
        builderState.style().setBlockStepInsert(forwardInheritedValue(builderState.parentStyle().blockStepInsert()));
    }
    static void applyValueBlockStepInsert(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBlockStepInsert(fromCSSValueDeducingType(value));
    }
    static void applyInitialBlockStepSize(BuilderState& builderState)
    {
        builderState.style().setBlockStepSize(RenderStyle::initialBlockStepSize());
    }
    static void applyInheritBlockStepSize(BuilderState& builderState)
    {
        builderState.style().setBlockStepSize(forwardInheritedValue(builderState.parentStyle().blockStepSize()));
    }
    static void applyValueBlockStepSize(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBlockStepSize(BuilderConverter::convertBlockStepSize(builderState, value));
    }
    static void applyInitialBorderCollapse(BuilderState& builderState)
    {
        builderState.style().setBorderCollapse(RenderStyle::initialBorderCollapse());
    }
    static void applyInheritBorderCollapse(BuilderState& builderState)
    {
        builderState.style().setBorderCollapse(forwardInheritedValue(builderState.parentStyle().borderCollapse()));
    }
    static void applyValueBorderCollapse(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderCollapse(fromCSSValueDeducingType(value));
    }
    static void applyInitialBorderImageSource(BuilderState& builderState)
    {
        builderState.style().setBorderImageSource(RenderStyle::initialBorderImageSource());
    }
    static void applyInheritBorderImageSource(BuilderState& builderState)
    {
        builderState.style().setBorderImageSource(forwardInheritedValue(builderState.parentStyle().borderImageSource()));
    }
    static void applyValueBorderImageSource(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderImageSource(BuilderConverter::convertStyleImage<CSSPropertyBorderImageSource>(builderState, value));
    }
    static void applyInitialBoxSizing(BuilderState& builderState)
    {
        builderState.style().setBoxSizing(RenderStyle::initialBoxSizing());
    }
    static void applyInheritBoxSizing(BuilderState& builderState)
    {
        builderState.style().setBoxSizing(forwardInheritedValue(builderState.parentStyle().boxSizing()));
    }
    static void applyValueBoxSizing(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxSizing(fromCSSValueDeducingType(value));
    }
    static void applyInitialBreakAfter(BuilderState& builderState)
    {
        builderState.style().setBreakAfter(RenderStyle::initialBreakBetween());
    }
    static void applyInheritBreakAfter(BuilderState& builderState)
    {
        builderState.style().setBreakAfter(forwardInheritedValue(builderState.parentStyle().breakAfter()));
    }
    static void applyValueBreakAfter(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBreakAfter(fromCSSValueDeducingType(value));
    }
    static void applyInitialBreakBefore(BuilderState& builderState)
    {
        builderState.style().setBreakBefore(RenderStyle::initialBreakBetween());
    }
    static void applyInheritBreakBefore(BuilderState& builderState)
    {
        builderState.style().setBreakBefore(forwardInheritedValue(builderState.parentStyle().breakBefore()));
    }
    static void applyValueBreakBefore(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBreakBefore(fromCSSValueDeducingType(value));
    }
    static void applyInitialBreakInside(BuilderState& builderState)
    {
        builderState.style().setBreakInside(RenderStyle::initialBreakInside());
    }
    static void applyInheritBreakInside(BuilderState& builderState)
    {
        builderState.style().setBreakInside(forwardInheritedValue(builderState.parentStyle().breakInside()));
    }
    static void applyValueBreakInside(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBreakInside(fromCSSValueDeducingType(value));
    }
    static void applyInitialBufferedRendering(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setBufferedRendering(SVGRenderStyle::initialBufferedRendering());
    }
    static void applyInheritBufferedRendering(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setBufferedRendering(forwardInheritedValue(builderState.parentStyle().svgStyle().bufferedRendering()));
    }
    static void applyValueBufferedRendering(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setBufferedRendering(fromCSSValueDeducingType(value));
    }
    static void applyInitialCaptionSide(BuilderState& builderState)
    {
        builderState.style().setCaptionSide(RenderStyle::initialCaptionSide());
    }
    static void applyInheritCaptionSide(BuilderState& builderState)
    {
        builderState.style().setCaptionSide(forwardInheritedValue(builderState.parentStyle().captionSide()));
    }
    static void applyValueCaptionSide(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setCaptionSide(fromCSSValueDeducingType(value));
    }
    static void applyInitialClear(BuilderState& builderState)
    {
        builderState.style().setClear(RenderStyle::initialClear());
    }
    static void applyInheritClear(BuilderState& builderState)
    {
        builderState.style().setClear(forwardInheritedValue(builderState.parentStyle().clear()));
    }
    static void applyValueClear(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setClear(fromCSSValueDeducingType(value));
    }
    static void applyInitialClipPath(BuilderState& builderState)
    {
        builderState.style().setClipPath(RenderStyle::initialClipPath());
    }
    static void applyInheritClipPath(BuilderState& builderState)
    {
        builderState.style().setClipPath(forwardInheritedValue(builderState.parentStyle().clipPath()));
    }
    static void applyValueClipPath(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setClipPath(BuilderConverter::convertPathOperation(builderState, value));
    }
    static void applyInitialClipRule(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setClipRule(SVGRenderStyle::initialClipRule());
    }
    static void applyInheritClipRule(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setClipRule(forwardInheritedValue(builderState.parentStyle().svgStyle().clipRule()));
    }
    static void applyValueClipRule(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setClipRule(fromCSSValueDeducingType(value));
    }
    static void applyInitialColorInterpolation(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setColorInterpolation(SVGRenderStyle::initialColorInterpolation());
    }
    static void applyInheritColorInterpolation(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setColorInterpolation(forwardInheritedValue(builderState.parentStyle().svgStyle().colorInterpolation()));
    }
    static void applyValueColorInterpolation(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setColorInterpolation(fromCSSValueDeducingType(value));
    }
    static void applyInitialColorInterpolationFilters(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setColorInterpolationFilters(SVGRenderStyle::initialColorInterpolationFilters());
    }
    static void applyInheritColorInterpolationFilters(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setColorInterpolationFilters(forwardInheritedValue(builderState.parentStyle().svgStyle().colorInterpolationFilters()));
    }
    static void applyValueColorInterpolationFilters(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setColorInterpolationFilters(fromCSSValueDeducingType(value));
    }
    static void applyInitialColumnCount(BuilderState& builderState)
    {
        builderState.style().setHasAutoColumnCount();
    }
    static void applyInheritColumnCount(BuilderState& builderState)
    {
        if (builderState.parentStyle().hasAutoColumnCount()) {
            builderState.style().setHasAutoColumnCount();
            return;
        }
        builderState.style().setColumnCount(forwardInheritedValue(builderState.parentStyle().columnCount()));
    }
    static void applyValueColumnCount(BuilderState& builderState, CSSValue& value)
    {
        if (value.valueID() == CSSValueAuto) {
            builderState.style().setHasAutoColumnCount();
            return;
        }
        builderState.style().setColumnCount(fromCSSValueDeducingType(value));
    }
    static void applyInitialColumnFill(BuilderState& builderState)
    {
        builderState.style().setColumnFill(RenderStyle::initialColumnFill());
    }
    static void applyInheritColumnFill(BuilderState& builderState)
    {
        builderState.style().setColumnFill(forwardInheritedValue(builderState.parentStyle().columnFill()));
    }
    static void applyValueColumnFill(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setColumnFill(fromCSSValueDeducingType(value));
    }
    static void applyInitialColumnGap(BuilderState& builderState)
    {
        builderState.style().setColumnGap(RenderStyle::initialColumnGap());
    }
    static void applyInheritColumnGap(BuilderState& builderState)
    {
        builderState.style().setColumnGap(forwardInheritedValue(builderState.parentStyle().columnGap()));
    }
    static void applyValueColumnGap(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setColumnGap(BuilderConverter::convertGapLength(builderState, value));
    }
    static void applyInitialColumnRuleColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setColumnRuleColor(StyleColor::currentColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkColumnRuleColor(StyleColor::currentColor());
    }
    static void applyInheritColumnRuleColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setColumnRuleColor(builderState.parentStyle().columnRuleColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkColumnRuleColor(builderState.parentStyle().columnRuleColor());
    }
    static void applyValueColumnRuleColor(BuilderState& builderState, CSSValue& value)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setColumnRuleColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::No));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkColumnRuleColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::Yes));
    }
    static void applyInitialColumnRuleStyle(BuilderState& builderState)
    {
        builderState.style().setColumnRuleStyle(RenderStyle::initialBorderStyle());
    }
    static void applyInheritColumnRuleStyle(BuilderState& builderState)
    {
        builderState.style().setColumnRuleStyle(forwardInheritedValue(builderState.parentStyle().columnRuleStyle()));
    }
    static void applyValueColumnRuleStyle(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setColumnRuleStyle(fromCSSValueDeducingType(value));
    }
    static void applyInitialColumnRuleWidth(BuilderState& builderState)
    {
        builderState.style().setColumnRuleWidth(RenderStyle::initialColumnRuleWidth());
    }
    static void applyInheritColumnRuleWidth(BuilderState& builderState)
    {
        builderState.style().setColumnRuleWidth(forwardInheritedValue(builderState.parentStyle().columnRuleWidth()));
    }
    static void applyValueColumnRuleWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setColumnRuleWidth(BuilderConverter::convertLineWidth<unsigned short>(builderState, value));
    }
    static void applyInitialColumnSpan(BuilderState& builderState)
    {
        builderState.style().setColumnSpan(RenderStyle::initialColumnSpan());
    }
    static void applyInheritColumnSpan(BuilderState& builderState)
    {
        builderState.style().setColumnSpan(forwardInheritedValue(builderState.parentStyle().columnSpan()));
    }
    static void applyValueColumnSpan(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setColumnSpan(fromCSSValueDeducingType(value));
    }
    static void applyInitialColumnWidth(BuilderState& builderState)
    {
        builderState.style().setHasAutoColumnWidth();
    }
    static void applyInheritColumnWidth(BuilderState& builderState)
    {
        if (builderState.parentStyle().hasAutoColumnWidth()) {
            builderState.style().setHasAutoColumnWidth();
            return;
        }
        builderState.style().setColumnWidth(forwardInheritedValue(builderState.parentStyle().columnWidth()));
    }
    static void applyValueColumnWidth(BuilderState& builderState, CSSValue& value)
    {
        if (value.valueID() == CSSValueAuto) {
            builderState.style().setHasAutoColumnWidth();
            return;
        }
        builderState.style().setColumnWidth(BuilderConverter::convertComputedLength<float>(builderState, value));
    }
    static void applyInitialContain(BuilderState& builderState)
    {
        builderState.style().setContain(RenderStyle::initialContainment());
    }
    static void applyInheritContain(BuilderState& builderState)
    {
        builderState.style().setContain(forwardInheritedValue(builderState.parentStyle().contain()));
    }
    static void applyValueContain(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setContain(BuilderConverter::convertContain(builderState, value));
    }
    static void applyInitialContainerName(BuilderState& builderState)
    {
        builderState.style().setContainerNames(RenderStyle::initialContainerNames());
    }
    static void applyInheritContainerName(BuilderState& builderState)
    {
        builderState.style().setContainerNames(forwardInheritedValue(builderState.parentStyle().containerNames()));
    }
    static void applyValueContainerName(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setContainerNames(BuilderConverter::convertContainerName(builderState, value));
    }
    static void applyInitialContainerType(BuilderState& builderState)
    {
        builderState.style().setContainerType(RenderStyle::initialContainerType());
    }
    static void applyInheritContainerType(BuilderState& builderState)
    {
        builderState.style().setContainerType(forwardInheritedValue(builderState.parentStyle().containerType()));
    }
    static void applyValueContainerType(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setContainerType(fromCSSValueDeducingType(value));
    }
    static void applyInitialContentVisibility(BuilderState& builderState)
    {
        builderState.style().setContentVisibility(RenderStyle::initialContentVisibility());
    }
    static void applyInheritContentVisibility(BuilderState& builderState)
    {
        builderState.style().setContentVisibility(forwardInheritedValue(builderState.parentStyle().contentVisibility()));
    }
    static void applyValueContentVisibility(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setContentVisibility(fromCSSValueDeducingType(value));
    }
    static void applyInitialCx(BuilderState& builderState)
    {
        builderState.style().setCx(RenderStyle::zeroLength());
    }
    static void applyInheritCx(BuilderState& builderState)
    {
        builderState.style().setCx(forwardInheritedValue(builderState.parentStyle().cx()));
    }
    static void applyValueCx(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setCx(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialCy(BuilderState& builderState)
    {
        builderState.style().setCy(RenderStyle::zeroLength());
    }
    static void applyInheritCy(BuilderState& builderState)
    {
        builderState.style().setCy(forwardInheritedValue(builderState.parentStyle().cy()));
    }
    static void applyValueCy(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setCy(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialDominantBaseline(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setDominantBaseline(SVGRenderStyle::initialDominantBaseline());
    }
    static void applyInheritDominantBaseline(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setDominantBaseline(forwardInheritedValue(builderState.parentStyle().svgStyle().dominantBaseline()));
    }
    static void applyValueDominantBaseline(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setDominantBaseline(fromCSSValueDeducingType(value));
    }
    static void applyInitialEmptyCells(BuilderState& builderState)
    {
        builderState.style().setEmptyCells(RenderStyle::initialEmptyCells());
    }
    static void applyInheritEmptyCells(BuilderState& builderState)
    {
        builderState.style().setEmptyCells(forwardInheritedValue(builderState.parentStyle().emptyCells()));
    }
    static void applyValueEmptyCells(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setEmptyCells(fromCSSValueDeducingType(value));
    }
    static void applyInitialFillOpacity(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setFillOpacity(SVGRenderStyle::initialFillOpacity());
    }
    static void applyInheritFillOpacity(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setFillOpacity(forwardInheritedValue(builderState.parentStyle().svgStyle().fillOpacity()));
    }
    static void applyValueFillOpacity(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setFillOpacity(BuilderConverter::convertOpacity(builderState, value));
    }
    static void applyInitialFillRule(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setFillRule(SVGRenderStyle::initialFillRule());
    }
    static void applyInheritFillRule(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setFillRule(forwardInheritedValue(builderState.parentStyle().svgStyle().fillRule()));
    }
    static void applyValueFillRule(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setFillRule(fromCSSValueDeducingType(value));
    }
    static void applyInitialFilter(BuilderState& builderState)
    {
        builderState.style().setFilter(RenderStyle::initialFilter());
    }
    static void applyInheritFilter(BuilderState& builderState)
    {
        builderState.style().setFilter(forwardInheritedValue(builderState.parentStyle().filter()));
    }
    static void applyValueFilter(BuilderState& builderState, CSSValue& value)
    {
        auto convertedValue = BuilderConverter::convertFilterOperations(builderState, value);
        if (convertedValue)
            builderState.style().setFilter(WTFMove(convertedValue.value()));
    }
    static void applyInitialFlexBasis(BuilderState& builderState)
    {
        builderState.style().setFlexBasis(RenderStyle::initialFlexBasis());
    }
    static void applyInheritFlexBasis(BuilderState& builderState)
    {
        builderState.style().setFlexBasis(forwardInheritedValue(builderState.parentStyle().flexBasis()));
    }
    static void applyValueFlexBasis(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setFlexBasis(BuilderConverter::convertLengthSizing(builderState, value));
    }
    static void applyInitialFlexDirection(BuilderState& builderState)
    {
        builderState.style().setFlexDirection(RenderStyle::initialFlexDirection());
    }
    static void applyInheritFlexDirection(BuilderState& builderState)
    {
        builderState.style().setFlexDirection(forwardInheritedValue(builderState.parentStyle().flexDirection()));
    }
    static void applyValueFlexDirection(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setFlexDirection(fromCSSValueDeducingType(value));
    }
    static void applyInitialFlexGrow(BuilderState& builderState)
    {
        builderState.style().setFlexGrow(RenderStyle::initialFlexGrow());
    }
    static void applyInheritFlexGrow(BuilderState& builderState)
    {
        builderState.style().setFlexGrow(forwardInheritedValue(builderState.parentStyle().flexGrow()));
    }
    static void applyValueFlexGrow(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setFlexGrow(fromCSSValueDeducingType(value));
    }
    static void applyInitialFlexShrink(BuilderState& builderState)
    {
        builderState.style().setFlexShrink(RenderStyle::initialFlexShrink());
    }
    static void applyInheritFlexShrink(BuilderState& builderState)
    {
        builderState.style().setFlexShrink(forwardInheritedValue(builderState.parentStyle().flexShrink()));
    }
    static void applyValueFlexShrink(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setFlexShrink(fromCSSValueDeducingType(value));
    }
    static void applyInitialFlexWrap(BuilderState& builderState)
    {
        builderState.style().setFlexWrap(RenderStyle::initialFlexWrap());
    }
    static void applyInheritFlexWrap(BuilderState& builderState)
    {
        builderState.style().setFlexWrap(forwardInheritedValue(builderState.parentStyle().flexWrap()));
    }
    static void applyValueFlexWrap(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setFlexWrap(fromCSSValueDeducingType(value));
    }
    static void applyInitialFloat(BuilderState& builderState)
    {
        builderState.style().setFloating(RenderStyle::initialFloating());
    }
    static void applyInheritFloat(BuilderState& builderState)
    {
        builderState.style().setFloating(forwardInheritedValue(builderState.parentStyle().floating()));
    }
    static void applyValueFloat(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setFloating(fromCSSValueDeducingType(value));
    }
    static void applyInitialFloodColor(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setFloodColor(SVGRenderStyle::initialFloodColor());
    }
    static void applyInheritFloodColor(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setFloodColor(forwardInheritedValue(builderState.parentStyle().svgStyle().floodColor()));
    }
    static void applyValueFloodColor(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setFloodColor(builderState.colorFromPrimitiveValue(downcast<CSSPrimitiveValue>(value), ForVisitedLink::No));
    }
    static void applyInitialFloodOpacity(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setFloodOpacity(SVGRenderStyle::initialFloodOpacity());
    }
    static void applyInheritFloodOpacity(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setFloodOpacity(forwardInheritedValue(builderState.parentStyle().svgStyle().floodOpacity()));
    }
    static void applyValueFloodOpacity(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setFloodOpacity(BuilderConverter::convertOpacity(builderState, value));
    }
    static void applyInitialGlyphOrientationHorizontal(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setGlyphOrientationHorizontal(SVGRenderStyle::initialGlyphOrientationHorizontal());
    }
    static void applyInheritGlyphOrientationHorizontal(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setGlyphOrientationHorizontal(forwardInheritedValue(builderState.parentStyle().svgStyle().glyphOrientationHorizontal()));
    }
    static void applyValueGlyphOrientationHorizontal(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setGlyphOrientationHorizontal(BuilderConverter::convertGlyphOrientation(builderState, value));
    }
    static void applyInitialGlyphOrientationVertical(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setGlyphOrientationVertical(SVGRenderStyle::initialGlyphOrientationVertical());
    }
    static void applyInheritGlyphOrientationVertical(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setGlyphOrientationVertical(forwardInheritedValue(builderState.parentStyle().svgStyle().glyphOrientationVertical()));
    }
    static void applyValueGlyphOrientationVertical(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setGlyphOrientationVertical(BuilderConverter::convertGlyphOrientationOrAuto(builderState, value));
    }
    static void applyInitialGridAutoColumns(BuilderState& builderState)
    {
        builderState.style().setGridAutoColumns(RenderStyle::initialGridAutoColumns());
    }
    static void applyInheritGridAutoColumns(BuilderState& builderState)
    {
        builderState.style().setGridAutoColumns(forwardInheritedValue(builderState.parentStyle().gridAutoColumns()));
    }
    static void applyValueGridAutoColumns(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setGridAutoColumns(BuilderConverter::convertGridTrackSizeList(builderState, value));
    }
    static void applyInitialGridAutoFlow(BuilderState& builderState)
    {
        builderState.style().setGridAutoFlow(RenderStyle::initialGridAutoFlow());
    }
    static void applyInheritGridAutoFlow(BuilderState& builderState)
    {
        builderState.style().setGridAutoFlow(forwardInheritedValue(builderState.parentStyle().gridAutoFlow()));
    }
    static void applyValueGridAutoFlow(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setGridAutoFlow(BuilderConverter::convertGridAutoFlow(builderState, value));
    }
    static void applyInitialGridAutoRows(BuilderState& builderState)
    {
        builderState.style().setGridAutoRows(RenderStyle::initialGridAutoRows());
    }
    static void applyInheritGridAutoRows(BuilderState& builderState)
    {
        builderState.style().setGridAutoRows(forwardInheritedValue(builderState.parentStyle().gridAutoRows()));
    }
    static void applyValueGridAutoRows(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setGridAutoRows(BuilderConverter::convertGridTrackSizeList(builderState, value));
    }
    static void applyInitialGridColumnEnd(BuilderState& builderState)
    {
        builderState.style().setGridItemColumnEnd(RenderStyle::initialGridItemColumnEnd());
    }
    static void applyInheritGridColumnEnd(BuilderState& builderState)
    {
        builderState.style().setGridItemColumnEnd(forwardInheritedValue(builderState.parentStyle().gridItemColumnEnd()));
    }
    static void applyValueGridColumnEnd(BuilderState& builderState, CSSValue& value)
    {
        auto convertedValue = BuilderConverter::convertGridPosition(builderState, value);
        if (convertedValue)
            builderState.style().setGridItemColumnEnd(WTFMove(convertedValue.value()));
    }
    static void applyInitialGridColumnStart(BuilderState& builderState)
    {
        builderState.style().setGridItemColumnStart(RenderStyle::initialGridItemColumnStart());
    }
    static void applyInheritGridColumnStart(BuilderState& builderState)
    {
        builderState.style().setGridItemColumnStart(forwardInheritedValue(builderState.parentStyle().gridItemColumnStart()));
    }
    static void applyValueGridColumnStart(BuilderState& builderState, CSSValue& value)
    {
        auto convertedValue = BuilderConverter::convertGridPosition(builderState, value);
        if (convertedValue)
            builderState.style().setGridItemColumnStart(WTFMove(convertedValue.value()));
    }
    static void applyInitialGridRowEnd(BuilderState& builderState)
    {
        builderState.style().setGridItemRowEnd(RenderStyle::initialGridItemRowEnd());
    }
    static void applyInheritGridRowEnd(BuilderState& builderState)
    {
        builderState.style().setGridItemRowEnd(forwardInheritedValue(builderState.parentStyle().gridItemRowEnd()));
    }
    static void applyValueGridRowEnd(BuilderState& builderState, CSSValue& value)
    {
        auto convertedValue = BuilderConverter::convertGridPosition(builderState, value);
        if (convertedValue)
            builderState.style().setGridItemRowEnd(WTFMove(convertedValue.value()));
    }
    static void applyInitialGridRowStart(BuilderState& builderState)
    {
        builderState.style().setGridItemRowStart(RenderStyle::initialGridItemRowStart());
    }
    static void applyInheritGridRowStart(BuilderState& builderState)
    {
        builderState.style().setGridItemRowStart(forwardInheritedValue(builderState.parentStyle().gridItemRowStart()));
    }
    static void applyValueGridRowStart(BuilderState& builderState, CSSValue& value)
    {
        auto convertedValue = BuilderConverter::convertGridPosition(builderState, value);
        if (convertedValue)
            builderState.style().setGridItemRowStart(WTFMove(convertedValue.value()));
    }
    static void applyInitialHangingPunctuation(BuilderState& builderState)
    {
        builderState.style().setHangingPunctuation(RenderStyle::initialHangingPunctuation());
    }
    static void applyInheritHangingPunctuation(BuilderState& builderState)
    {
        builderState.style().setHangingPunctuation(forwardInheritedValue(builderState.parentStyle().hangingPunctuation()));
    }
    static void applyValueHangingPunctuation(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setHangingPunctuation(BuilderConverter::convertHangingPunctuation(builderState, value));
    }
    static void applyInitialHyphenateCharacter(BuilderState& builderState)
    {
        builderState.style().setHyphenationString(RenderStyle::initialHyphenationString());
    }
    static void applyInheritHyphenateCharacter(BuilderState& builderState)
    {
        builderState.style().setHyphenationString(forwardInheritedValue(builderState.parentStyle().hyphenationString()));
    }
    static void applyValueHyphenateCharacter(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setHyphenationString(BuilderConverter::convertStringOrAutoAtom(builderState, value));
    }
    static void applyInitialHyphens(BuilderState& builderState)
    {
        builderState.style().setHyphens(RenderStyle::initialHyphens());
    }
    static void applyInheritHyphens(BuilderState& builderState)
    {
        builderState.style().setHyphens(forwardInheritedValue(builderState.parentStyle().hyphens()));
    }
    static void applyValueHyphens(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setHyphens(fromCSSValueDeducingType(value));
    }
    static void applyInitialImageOrientation(BuilderState& builderState)
    {
        builderState.style().setImageOrientation(RenderStyle::initialImageOrientation());
    }
    static void applyInheritImageOrientation(BuilderState& builderState)
    {
        builderState.style().setImageOrientation(forwardInheritedValue(builderState.parentStyle().imageOrientation()));
    }
    static void applyValueImageOrientation(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setImageOrientation(BuilderConverter::convertImageOrientation(builderState, value));
    }
    static void applyInitialImageRendering(BuilderState& builderState)
    {
        builderState.style().setImageRendering(RenderStyle::initialImageRendering());
    }
    static void applyInheritImageRendering(BuilderState& builderState)
    {
        builderState.style().setImageRendering(forwardInheritedValue(builderState.parentStyle().imageRendering()));
    }
    static void applyValueImageRendering(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setImageRendering(fromCSSValueDeducingType(value));
    }
    static void applyInitialInputSecurity(BuilderState& builderState)
    {
        builderState.style().setInputSecurity(RenderStyle::initialInputSecurity());
    }
    static void applyInheritInputSecurity(BuilderState& builderState)
    {
        builderState.style().setInputSecurity(forwardInheritedValue(builderState.parentStyle().inputSecurity()));
    }
    static void applyValueInputSecurity(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setInputSecurity(fromCSSValueDeducingType(value));
    }
    static void applyInitialIsolation(BuilderState& builderState)
    {
        builderState.style().setIsolation(RenderStyle::initialIsolation());
    }
    static void applyInheritIsolation(BuilderState& builderState)
    {
        builderState.style().setIsolation(forwardInheritedValue(builderState.parentStyle().isolation()));
    }
    static void applyValueIsolation(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setIsolation(fromCSSValueDeducingType(value));
    }
    static void applyInitialJustifyContent(BuilderState& builderState)
    {
        builderState.style().setJustifyContent(RenderStyle::initialContentAlignment());
    }
    static void applyInheritJustifyContent(BuilderState& builderState)
    {
        builderState.style().setJustifyContent(forwardInheritedValue(builderState.parentStyle().justifyContent()));
    }
    static void applyValueJustifyContent(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setJustifyContent(BuilderConverter::convertContentAlignmentData(builderState, value));
    }
    static void applyInitialJustifyItems(BuilderState& builderState)
    {
        builderState.style().setJustifyItems(RenderStyle::initialJustifyItems());
    }
    static void applyInheritJustifyItems(BuilderState& builderState)
    {
        builderState.style().setJustifyItems(forwardInheritedValue(builderState.parentStyle().justifyItems()));
    }
    static void applyValueJustifyItems(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setJustifyItems(BuilderConverter::convertSelfOrDefaultAlignmentData(builderState, value));
    }
    static void applyInitialJustifySelf(BuilderState& builderState)
    {
        builderState.style().setJustifySelf(RenderStyle::initialSelfAlignment());
    }
    static void applyInheritJustifySelf(BuilderState& builderState)
    {
        builderState.style().setJustifySelf(forwardInheritedValue(builderState.parentStyle().justifySelf()));
    }
    static void applyValueJustifySelf(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setJustifySelf(BuilderConverter::convertSelfOrDefaultAlignmentData(builderState, value));
    }
    static void applyInitialKerning(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setKerning(SVGRenderStyle::initialKerning());
    }
    static void applyInheritKerning(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setKerning(forwardInheritedValue(builderState.parentStyle().svgStyle().kerning()));
    }
    static void applyValueKerning(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setKerning(BuilderConverter::convertSVGLengthValue(builderState, value));
    }
    static void applyInitialLightingColor(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setLightingColor(SVGRenderStyle::initialLightingColor());
    }
    static void applyInheritLightingColor(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setLightingColor(forwardInheritedValue(builderState.parentStyle().svgStyle().lightingColor()));
    }
    static void applyValueLightingColor(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setLightingColor(builderState.colorFromPrimitiveValue(downcast<CSSPrimitiveValue>(value), ForVisitedLink::No));
    }
    static void applyInitialLineBreak(BuilderState& builderState)
    {
        builderState.style().setLineBreak(RenderStyle::initialLineBreak());
    }
    static void applyInheritLineBreak(BuilderState& builderState)
    {
        builderState.style().setLineBreak(forwardInheritedValue(builderState.parentStyle().lineBreak()));
    }
    static void applyValueLineBreak(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setLineBreak(fromCSSValueDeducingType(value));
    }
    static void applyInitialLineHeight(BuilderState& builderState)
    {
        builderState.style().setLineHeight(RenderStyle::initialLineHeight());
    }
    static void applyInheritLineHeight(BuilderState& builderState)
    {
        builderState.style().setLineHeight(forwardInheritedValue(builderState.parentStyle().specifiedLineHeight()));
    }
    static void applyValueLineHeight(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setLineHeight(BuilderConverter::convertLineHeight(builderState, value));
    }
    static void applyInitialListStyleImage(BuilderState& builderState)
    {
        builderState.style().setListStyleImage(RenderStyle::initialListStyleImage());
    }
    static void applyInheritListStyleImage(BuilderState& builderState)
    {
        builderState.style().setListStyleImage(forwardInheritedValue(builderState.parentStyle().listStyleImage()));
    }
    static void applyValueListStyleImage(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setListStyleImage(BuilderConverter::convertStyleImage<CSSPropertyListStyleImage>(builderState, value));
    }
    static void applyInitialListStylePosition(BuilderState& builderState)
    {
        builderState.style().setListStylePosition(RenderStyle::initialListStylePosition());
    }
    static void applyInheritListStylePosition(BuilderState& builderState)
    {
        builderState.style().setListStylePosition(forwardInheritedValue(builderState.parentStyle().listStylePosition()));
    }
    static void applyValueListStylePosition(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setListStylePosition(fromCSSValueDeducingType(value));
    }
    static void applyInitialListStyleType(BuilderState& builderState)
    {
        builderState.style().setListStyleType(RenderStyle::initialListStyleType());
    }
    static void applyInheritListStyleType(BuilderState& builderState)
    {
        builderState.style().setListStyleType(forwardInheritedValue(builderState.parentStyle().listStyleType()));
    }
    static void applyValueListStyleType(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setListStyleType(BuilderConverter::convertListStyleType(builderState, value));
    }
    static void applyInitialMarginTrim(BuilderState& builderState)
    {
        builderState.style().setMarginTrim(RenderStyle::initialMarginTrim());
    }
    static void applyInheritMarginTrim(BuilderState& builderState)
    {
        builderState.style().setMarginTrim(forwardInheritedValue(builderState.parentStyle().marginTrim()));
    }
    static void applyValueMarginTrim(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMarginTrim(BuilderConverter::convertMarginTrim(builderState, value));
    }
    static void applyInitialMarkerEnd(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setMarkerEndResource(SVGRenderStyle::initialMarkerEndResource());
    }
    static void applyInheritMarkerEnd(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setMarkerEndResource(forwardInheritedValue(builderState.parentStyle().svgStyle().markerEndResource()));
    }
    static void applyValueMarkerEnd(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setMarkerEndResource(BuilderConverter::convertSVGURIReference(builderState, value));
    }
    static void applyInitialMarkerMid(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setMarkerMidResource(SVGRenderStyle::initialMarkerMidResource());
    }
    static void applyInheritMarkerMid(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setMarkerMidResource(forwardInheritedValue(builderState.parentStyle().svgStyle().markerMidResource()));
    }
    static void applyValueMarkerMid(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setMarkerMidResource(BuilderConverter::convertSVGURIReference(builderState, value));
    }
    static void applyInitialMarkerStart(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setMarkerStartResource(SVGRenderStyle::initialMarkerStartResource());
    }
    static void applyInheritMarkerStart(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setMarkerStartResource(forwardInheritedValue(builderState.parentStyle().svgStyle().markerStartResource()));
    }
    static void applyValueMarkerStart(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setMarkerStartResource(BuilderConverter::convertSVGURIReference(builderState, value));
    }
    static void applyInitialMaskBorderSource(BuilderState& builderState)
    {
        builderState.style().setMaskBorderSource(RenderStyle::initialMaskBorderSource());
    }
    static void applyInheritMaskBorderSource(BuilderState& builderState)
    {
        builderState.style().setMaskBorderSource(forwardInheritedValue(builderState.parentStyle().maskBorderSource()));
    }
    static void applyValueMaskBorderSource(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMaskBorderSource(BuilderConverter::convertStyleImage<CSSPropertyMaskBorderSource>(builderState, value));
    }
    static void applyInitialMaskImage(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().maskLayers();
        if (!layers.next() && (!layers.isImageSet() || layers.image() == FillLayer::initialFillImage(FillLayerType::Mask)))
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        child->setImage(FillLayer::initialFillImage(FillLayerType::Mask));
        for (child = child->next(); child; child = child->next())
            child->clearImage();
    }
    static void applyInheritMaskImage(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().maskLayers() == builderState.style().maskLayers())
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().maskLayers(); parent && parent->isImageSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                child = previousChild->next();
            }
            child->setImage(parent->image());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearImage();
    }
    static void applyValueMaskImage(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillImage(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillImage(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearImage();
    }
    static void applyInitialMaskOrigin(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().maskLayers();
        if (!layers.next() && (!layers.isOriginSet() || layers.origin() == FillLayer::initialFillOrigin(FillLayerType::Mask)))
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        child->setOrigin(FillLayer::initialFillOrigin(FillLayerType::Mask));
        for (child = child->next(); child; child = child->next())
            child->clearOrigin();
    }
    static void applyInheritMaskOrigin(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().maskLayers() == builderState.style().maskLayers())
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().maskLayers(); parent && parent->isOriginSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                child = previousChild->next();
            }
            child->setOrigin(parent->origin());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearOrigin();
    }
    static void applyValueMaskOrigin(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillOrigin(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillOrigin(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearOrigin();
    }
    static void applyInitialMaskRepeat(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().maskLayers();
        if (!layers.next() && (!layers.isRepeatSet() || layers.repeat() == FillLayer::initialFillRepeat(FillLayerType::Mask)))
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        child->setRepeat(FillLayer::initialFillRepeat(FillLayerType::Mask));
        for (child = child->next(); child; child = child->next())
            child->clearRepeat();
    }
    static void applyInheritMaskRepeat(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().maskLayers() == builderState.style().maskLayers())
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().maskLayers(); parent && parent->isRepeatSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                child = previousChild->next();
            }
            child->setRepeat(parent->repeat());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearRepeat();
    }
    static void applyValueMaskRepeat(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillRepeat(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillRepeat(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearRepeat();
    }
    static void applyInitialMaskSize(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().maskLayers();
        if (!layers.next() && (!layers.isSizeSet() || layers.size() == FillLayer::initialFillSize(FillLayerType::Mask)))
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        child->setSize(FillLayer::initialFillSize(FillLayerType::Mask));
        for (child = child->next(); child; child = child->next())
            child->clearSize();
    }
    static void applyInheritMaskSize(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().maskLayers() == builderState.style().maskLayers())
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().maskLayers(); parent && parent->isSizeSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                child = previousChild->next();
            }
            child->setSize(parent->size());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearSize();
    }
    static void applyValueMaskSize(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillSize(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillSize(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearSize();
    }
    static void applyInitialMaskType(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setMaskType(SVGRenderStyle::initialMaskType());
    }
    static void applyInheritMaskType(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setMaskType(forwardInheritedValue(builderState.parentStyle().svgStyle().maskType()));
    }
    static void applyValueMaskType(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setMaskType(fromCSSValueDeducingType(value));
    }
    static void applyInitialMasonryAutoFlow(BuilderState& builderState)
    {
        builderState.style().setMasonryAutoFlow(RenderStyle::initialMasonryAutoFlow());
    }
    static void applyInheritMasonryAutoFlow(BuilderState& builderState)
    {
        builderState.style().setMasonryAutoFlow(forwardInheritedValue(builderState.parentStyle().masonryAutoFlow()));
    }
    static void applyValueMasonryAutoFlow(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMasonryAutoFlow(BuilderConverter::convertMasonryAutoFlow(builderState, value));
    }
    static void applyInitialMathStyle(BuilderState& builderState)
    {
        builderState.style().setMathStyle(RenderStyle::initialMathStyle());
    }
    static void applyInheritMathStyle(BuilderState& builderState)
    {
        builderState.style().setMathStyle(forwardInheritedValue(builderState.parentStyle().mathStyle()));
    }
    static void applyValueMathStyle(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMathStyle(fromCSSValueDeducingType(value));
    }
    static void applyInitialMixBlendMode(BuilderState& builderState)
    {
        builderState.style().setBlendMode(RenderStyle::initialBlendMode());
    }
    static void applyInheritMixBlendMode(BuilderState& builderState)
    {
        builderState.style().setBlendMode(forwardInheritedValue(builderState.parentStyle().blendMode()));
    }
    static void applyValueMixBlendMode(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBlendMode(fromCSSValueDeducingType(value));
    }
    static void applyInitialObjectFit(BuilderState& builderState)
    {
        builderState.style().setObjectFit(RenderStyle::initialObjectFit());
    }
    static void applyInheritObjectFit(BuilderState& builderState)
    {
        builderState.style().setObjectFit(forwardInheritedValue(builderState.parentStyle().objectFit()));
    }
    static void applyValueObjectFit(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setObjectFit(fromCSSValueDeducingType(value));
    }
    static void applyInitialObjectPosition(BuilderState& builderState)
    {
        builderState.style().setObjectPosition(RenderStyle::initialObjectPosition());
    }
    static void applyInheritObjectPosition(BuilderState& builderState)
    {
        builderState.style().setObjectPosition(forwardInheritedValue(builderState.parentStyle().objectPosition()));
    }
    static void applyValueObjectPosition(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setObjectPosition(BuilderConverter::convertPosition(builderState, value));
    }
    static void applyInitialOffsetAnchor(BuilderState& builderState)
    {
        builderState.style().setOffsetAnchor(RenderStyle::initialOffsetAnchor());
    }
    static void applyInheritOffsetAnchor(BuilderState& builderState)
    {
        builderState.style().setOffsetAnchor(forwardInheritedValue(builderState.parentStyle().offsetAnchor()));
    }
    static void applyValueOffsetAnchor(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOffsetAnchor(BuilderConverter::convertPositionOrAuto(builderState, value));
    }
    static void applyInitialOffsetDistance(BuilderState& builderState)
    {
        builderState.style().setOffsetDistance(RenderStyle::initialOffsetDistance());
    }
    static void applyInheritOffsetDistance(BuilderState& builderState)
    {
        builderState.style().setOffsetDistance(forwardInheritedValue(builderState.parentStyle().offsetDistance()));
    }
    static void applyValueOffsetDistance(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOffsetDistance(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialOffsetPath(BuilderState& builderState)
    {
        builderState.style().setOffsetPath(RenderStyle::initialOffsetPath());
    }
    static void applyInheritOffsetPath(BuilderState& builderState)
    {
        builderState.style().setOffsetPath(forwardInheritedValue(builderState.parentStyle().offsetPath()));
    }
    static void applyValueOffsetPath(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOffsetPath(BuilderConverter::convertPathOperation(builderState, value));
    }
    static void applyInitialOffsetPosition(BuilderState& builderState)
    {
        builderState.style().setOffsetPosition(RenderStyle::initialOffsetPosition());
    }
    static void applyInheritOffsetPosition(BuilderState& builderState)
    {
        builderState.style().setOffsetPosition(forwardInheritedValue(builderState.parentStyle().offsetPosition()));
    }
    static void applyValueOffsetPosition(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOffsetPosition(BuilderConverter::convertPositionOrAutoOrNormal(builderState, value));
    }
    static void applyInitialOffsetRotate(BuilderState& builderState)
    {
        builderState.style().setOffsetRotate(RenderStyle::initialOffsetRotate());
    }
    static void applyInheritOffsetRotate(BuilderState& builderState)
    {
        builderState.style().setOffsetRotate(forwardInheritedValue(builderState.parentStyle().offsetRotate()));
    }
    static void applyValueOffsetRotate(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOffsetRotate(BuilderConverter::convertOffsetRotate(builderState, value));
    }
    static void applyInitialOpacity(BuilderState& builderState)
    {
        builderState.style().setOpacity(RenderStyle::initialOpacity());
    }
    static void applyInheritOpacity(BuilderState& builderState)
    {
        builderState.style().setOpacity(forwardInheritedValue(builderState.parentStyle().opacity()));
    }
    static void applyValueOpacity(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOpacity(BuilderConverter::convertOpacity(builderState, value));
    }
    static void applyInitialOrder(BuilderState& builderState)
    {
        builderState.style().setOrder(RenderStyle::initialOrder());
    }
    static void applyInheritOrder(BuilderState& builderState)
    {
        builderState.style().setOrder(forwardInheritedValue(builderState.parentStyle().order()));
    }
    static void applyValueOrder(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOrder(fromCSSValueDeducingType(value));
    }
    static void applyInitialOrphans(BuilderState& builderState)
    {
        builderState.style().setHasAutoOrphans();
    }
    static void applyInheritOrphans(BuilderState& builderState)
    {
        if (builderState.parentStyle().hasAutoOrphans()) {
            builderState.style().setHasAutoOrphans();
            return;
        }
        builderState.style().setOrphans(forwardInheritedValue(builderState.parentStyle().orphans()));
    }
    static void applyValueOrphans(BuilderState& builderState, CSSValue& value)
    {
        if (value.valueID() == CSSValueAuto) {
            builderState.style().setHasAutoOrphans();
            return;
        }
        builderState.style().setOrphans(fromCSSValueDeducingType(value));
    }
    static void applyInitialOutlineColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setOutlineColor(StyleColor::currentColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkOutlineColor(StyleColor::currentColor());
    }
    static void applyInheritOutlineColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setOutlineColor(builderState.parentStyle().outlineColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkOutlineColor(builderState.parentStyle().outlineColor());
    }
    static void applyValueOutlineColor(BuilderState& builderState, CSSValue& value)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setOutlineColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::No));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkOutlineColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::Yes));
    }
    static void applyInitialOutlineOffset(BuilderState& builderState)
    {
        builderState.style().setOutlineOffset(RenderStyle::initialOutlineOffset());
    }
    static void applyInheritOutlineOffset(BuilderState& builderState)
    {
        builderState.style().setOutlineOffset(forwardInheritedValue(builderState.parentStyle().outlineOffset()));
    }
    static void applyValueOutlineOffset(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOutlineOffset(BuilderConverter::convertComputedLength<float>(builderState, value));
    }
    static void applyInitialOutlineWidth(BuilderState& builderState)
    {
        builderState.style().setOutlineWidth(RenderStyle::initialOutlineWidth());
    }
    static void applyInheritOutlineWidth(BuilderState& builderState)
    {
        builderState.style().setOutlineWidth(forwardInheritedValue(builderState.parentStyle().outlineWidth()));
    }
    static void applyValueOutlineWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOutlineWidth(BuilderConverter::convertLineWidth<float>(builderState, value));
    }
    static void applyInitialOverflowAnchor(BuilderState& builderState)
    {
        builderState.style().setOverflowAnchor(RenderStyle::initialOverflowAnchor());
    }
    static void applyInheritOverflowAnchor(BuilderState& builderState)
    {
        builderState.style().setOverflowAnchor(forwardInheritedValue(builderState.parentStyle().overflowAnchor()));
    }
    static void applyValueOverflowAnchor(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOverflowAnchor(fromCSSValueDeducingType(value));
    }
    static void applyInitialOverflowWrap(BuilderState& builderState)
    {
        builderState.style().setOverflowWrap(RenderStyle::initialOverflowWrap());
    }
    static void applyInheritOverflowWrap(BuilderState& builderState)
    {
        builderState.style().setOverflowWrap(forwardInheritedValue(builderState.parentStyle().overflowWrap()));
    }
    static void applyValueOverflowWrap(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOverflowWrap(fromCSSValueDeducingType(value));
    }
    static void applyInitialOverflowX(BuilderState& builderState)
    {
        builderState.style().setOverflowX(RenderStyle::initialOverflowX());
    }
    static void applyInheritOverflowX(BuilderState& builderState)
    {
        builderState.style().setOverflowX(forwardInheritedValue(builderState.parentStyle().overflowX()));
    }
    static void applyValueOverflowX(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOverflowX(fromCSSValueDeducingType(value));
    }
    static void applyInitialOverflowY(BuilderState& builderState)
    {
        builderState.style().setOverflowY(RenderStyle::initialOverflowY());
    }
    static void applyInheritOverflowY(BuilderState& builderState)
    {
        builderState.style().setOverflowY(forwardInheritedValue(builderState.parentStyle().overflowY()));
    }
    static void applyValueOverflowY(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOverflowY(fromCSSValueDeducingType(value));
    }
    static void applyInitialPaintOrder(BuilderState& builderState)
    {
        builderState.style().setPaintOrder(RenderStyle::initialPaintOrder());
    }
    static void applyInheritPaintOrder(BuilderState& builderState)
    {
        builderState.style().setPaintOrder(forwardInheritedValue(builderState.parentStyle().paintOrder()));
    }
    static void applyValuePaintOrder(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setPaintOrder(BuilderConverter::convertPaintOrder(builderState, value));
    }
    static void applyInitialPerspective(BuilderState& builderState)
    {
        builderState.style().setPerspective(RenderStyle::initialPerspective());
    }
    static void applyInheritPerspective(BuilderState& builderState)
    {
        builderState.style().setPerspective(forwardInheritedValue(builderState.parentStyle().perspective()));
    }
    static void applyValuePerspective(BuilderState& builderState, CSSValue& value)
    {
        auto convertedValue = BuilderConverter::convertPerspective(builderState, value);
        if (convertedValue)
            builderState.style().setPerspective(WTFMove(convertedValue.value()));
    }
    static void applyInitialPerspectiveOriginX(BuilderState& builderState)
    {
        builderState.style().setPerspectiveOriginX(RenderStyle::initialPerspectiveOriginX());
    }
    static void applyInheritPerspectiveOriginX(BuilderState& builderState)
    {
        builderState.style().setPerspectiveOriginX(forwardInheritedValue(builderState.parentStyle().perspectiveOriginX()));
    }
    static void applyValuePerspectiveOriginX(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setPerspectiveOriginX(BuilderConverter::convertPositionComponentX(builderState, value));
    }
    static void applyInitialPerspectiveOriginY(BuilderState& builderState)
    {
        builderState.style().setPerspectiveOriginY(RenderStyle::initialPerspectiveOriginY());
    }
    static void applyInheritPerspectiveOriginY(BuilderState& builderState)
    {
        builderState.style().setPerspectiveOriginY(forwardInheritedValue(builderState.parentStyle().perspectiveOriginY()));
    }
    static void applyValuePerspectiveOriginY(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setPerspectiveOriginY(BuilderConverter::convertPositionComponentY(builderState, value));
    }
    static void applyInitialPointerEvents(BuilderState& builderState)
    {
        builderState.style().setPointerEvents(RenderStyle::initialPointerEvents());
    }
    static void applyInheritPointerEvents(BuilderState& builderState)
    {
        builderState.style().setPointerEvents(forwardInheritedValue(builderState.parentStyle().pointerEvents()));
    }
    static void applyValuePointerEvents(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setPointerEvents(fromCSSValueDeducingType(value));
    }
    static void applyInitialPosition(BuilderState& builderState)
    {
        builderState.style().setPosition(RenderStyle::initialPosition());
    }
    static void applyInheritPosition(BuilderState& builderState)
    {
        builderState.style().setPosition(forwardInheritedValue(builderState.parentStyle().position()));
    }
    static void applyValuePosition(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setPosition(fromCSSValueDeducingType(value));
    }
    static void applyInitialPrintColorAdjust(BuilderState& builderState)
    {
        builderState.style().setPrintColorAdjust(RenderStyle::initialPrintColorAdjust());
    }
    static void applyInheritPrintColorAdjust(BuilderState& builderState)
    {
        builderState.style().setPrintColorAdjust(forwardInheritedValue(builderState.parentStyle().printColorAdjust()));
    }
    static void applyValuePrintColorAdjust(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setPrintColorAdjust(fromCSSValueDeducingType(value));
    }
    static void applyInitialQuotes(BuilderState& builderState)
    {
        builderState.style().setQuotes(RenderStyle::initialQuotes());
    }
    static void applyInheritQuotes(BuilderState& builderState)
    {
        builderState.style().setQuotes(forwardInheritedValue(builderState.parentStyle().quotes()));
    }
    static void applyValueQuotes(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setQuotes(BuilderConverter::convertQuotes(builderState, value));
    }
    static void applyInitialR(BuilderState& builderState)
    {
        builderState.style().setR(RenderStyle::zeroLength());
    }
    static void applyInheritR(BuilderState& builderState)
    {
        builderState.style().setR(forwardInheritedValue(builderState.parentStyle().r()));
    }
    static void applyValueR(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setR(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialResize(BuilderState& builderState)
    {
        builderState.style().setResize(RenderStyle::initialResize());
    }
    static void applyInheritResize(BuilderState& builderState)
    {
        builderState.style().setResize(forwardInheritedValue(builderState.parentStyle().resize()));
    }
    static void applyValueResize(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setResize(BuilderConverter::convertResize(builderState, value));
    }
    static void applyInitialRotate(BuilderState& builderState)
    {
        builderState.style().setRotate(RenderStyle::initialRotate());
    }
    static void applyInheritRotate(BuilderState& builderState)
    {
        builderState.style().setRotate(forwardInheritedValue(builderState.parentStyle().rotate()));
    }
    static void applyValueRotate(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setRotate(BuilderConverter::convertRotate(builderState, value));
    }
    static void applyInitialRowGap(BuilderState& builderState)
    {
        builderState.style().setRowGap(RenderStyle::initialRowGap());
    }
    static void applyInheritRowGap(BuilderState& builderState)
    {
        builderState.style().setRowGap(forwardInheritedValue(builderState.parentStyle().rowGap()));
    }
    static void applyValueRowGap(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setRowGap(BuilderConverter::convertGapLength(builderState, value));
    }
    static void applyInitialRx(BuilderState& builderState)
    {
        builderState.style().setRx(RenderStyle::initialRadius());
    }
    static void applyInheritRx(BuilderState& builderState)
    {
        builderState.style().setRx(forwardInheritedValue(builderState.parentStyle().rx()));
    }
    static void applyValueRx(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setRx(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialRy(BuilderState& builderState)
    {
        builderState.style().setRy(RenderStyle::initialRadius());
    }
    static void applyInheritRy(BuilderState& builderState)
    {
        builderState.style().setRy(forwardInheritedValue(builderState.parentStyle().ry()));
    }
    static void applyValueRy(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setRy(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialScale(BuilderState& builderState)
    {
        builderState.style().setScale(RenderStyle::initialScale());
    }
    static void applyInheritScale(BuilderState& builderState)
    {
        builderState.style().setScale(forwardInheritedValue(builderState.parentStyle().scale()));
    }
    static void applyValueScale(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScale(BuilderConverter::convertScale(builderState, value));
    }
    static void applyInitialScrollBehavior(BuilderState& builderState)
    {
        builderState.style().setUseSmoothScrolling(RenderStyle::initialUseSmoothScrolling());
    }
    static void applyInheritScrollBehavior(BuilderState& builderState)
    {
        builderState.style().setUseSmoothScrolling(forwardInheritedValue(builderState.parentStyle().useSmoothScrolling()));
    }
    static void applyValueScrollBehavior(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setUseSmoothScrolling(BuilderConverter::convertSmoothScrolling(builderState, value));
    }
    static void applyInitialScrollSnapAlign(BuilderState& builderState)
    {
        builderState.style().setScrollSnapAlign(RenderStyle::initialScrollSnapAlign());
    }
    static void applyInheritScrollSnapAlign(BuilderState& builderState)
    {
        builderState.style().setScrollSnapAlign(forwardInheritedValue(builderState.parentStyle().scrollSnapAlign()));
    }
    static void applyValueScrollSnapAlign(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollSnapAlign(BuilderConverter::convertScrollSnapAlign(builderState, value));
    }
    static void applyInitialScrollSnapStop(BuilderState& builderState)
    {
        builderState.style().setScrollSnapStop(RenderStyle::initialScrollSnapStop());
    }
    static void applyInheritScrollSnapStop(BuilderState& builderState)
    {
        builderState.style().setScrollSnapStop(forwardInheritedValue(builderState.parentStyle().scrollSnapStop()));
    }
    static void applyValueScrollSnapStop(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollSnapStop(BuilderConverter::convertScrollSnapStop(builderState, value));
    }
    static void applyInitialScrollSnapType(BuilderState& builderState)
    {
        builderState.style().setScrollSnapType(RenderStyle::initialScrollSnapType());
    }
    static void applyInheritScrollSnapType(BuilderState& builderState)
    {
        builderState.style().setScrollSnapType(forwardInheritedValue(builderState.parentStyle().scrollSnapType()));
    }
    static void applyValueScrollSnapType(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollSnapType(BuilderConverter::convertScrollSnapType(builderState, value));
    }
    static void applyInitialScrollTimelineAxis(BuilderState& builderState)
    {
        builderState.style().setScrollTimelineAxes(RenderStyle::initialScrollTimelineAxes());
    }
    static void applyInheritScrollTimelineAxis(BuilderState& builderState)
    {
        builderState.style().setScrollTimelineAxes(forwardInheritedValue(builderState.parentStyle().scrollTimelineAxes()));
    }
    static void applyValueScrollTimelineAxis(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollTimelineAxes(BuilderConverter::convertScrollTimelineAxis(builderState, value));
    }
    static void applyInitialScrollTimelineName(BuilderState& builderState)
    {
        builderState.style().setScrollTimelineNames(RenderStyle::initialScrollTimelineNames());
    }
    static void applyInheritScrollTimelineName(BuilderState& builderState)
    {
        builderState.style().setScrollTimelineNames(forwardInheritedValue(builderState.parentStyle().scrollTimelineNames()));
    }
    static void applyValueScrollTimelineName(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollTimelineNames(BuilderConverter::convertScrollTimelineName(builderState, value));
    }
    static void applyInitialScrollbarColor(BuilderState& builderState)
    {
        builderState.style().setScrollbarColor(RenderStyle::initialScrollbarColor());
    }
    static void applyInheritScrollbarColor(BuilderState& builderState)
    {
        builderState.style().setScrollbarColor(forwardInheritedValue(builderState.parentStyle().scrollbarColor()));
    }
    static void applyValueScrollbarColor(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollbarColor(BuilderConverter::convertScrollbarColor(builderState, value));
    }
    static void applyInitialScrollbarGutter(BuilderState& builderState)
    {
        builderState.style().setScrollbarGutter(RenderStyle::initialScrollbarGutter());
    }
    static void applyInheritScrollbarGutter(BuilderState& builderState)
    {
        builderState.style().setScrollbarGutter(forwardInheritedValue(builderState.parentStyle().scrollbarGutter()));
    }
    static void applyValueScrollbarGutter(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollbarGutter(BuilderConverter::convertScrollbarGutter(builderState, value));
    }
    static void applyInitialScrollbarWidth(BuilderState& builderState)
    {
        builderState.style().setScrollbarWidth(RenderStyle::initialScrollbarWidth());
    }
    static void applyInheritScrollbarWidth(BuilderState& builderState)
    {
        builderState.style().setScrollbarWidth(forwardInheritedValue(builderState.parentStyle().scrollbarWidth()));
    }
    static void applyValueScrollbarWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollbarWidth(fromCSSValueDeducingType(value));
    }
    static void applyInitialShapeImageThreshold(BuilderState& builderState)
    {
        builderState.style().setShapeImageThreshold(RenderStyle::initialShapeImageThreshold());
    }
    static void applyInheritShapeImageThreshold(BuilderState& builderState)
    {
        builderState.style().setShapeImageThreshold(forwardInheritedValue(builderState.parentStyle().shapeImageThreshold()));
    }
    static void applyValueShapeImageThreshold(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setShapeImageThreshold(BuilderConverter::convertNumberOrAuto<float>(builderState, value));
    }
    static void applyInitialShapeMargin(BuilderState& builderState)
    {
        builderState.style().setShapeMargin(RenderStyle::initialShapeMargin());
    }
    static void applyInheritShapeMargin(BuilderState& builderState)
    {
        builderState.style().setShapeMargin(forwardInheritedValue(builderState.parentStyle().shapeMargin()));
    }
    static void applyValueShapeMargin(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setShapeMargin(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialShapeOutside(BuilderState& builderState)
    {
        builderState.style().setShapeOutside(RenderStyle::initialShapeOutside());
    }
    static void applyInheritShapeOutside(BuilderState& builderState)
    {
        builderState.style().setShapeOutside(forwardInheritedValue(builderState.parentStyle().shapeOutside()));
    }
    static void applyValueShapeOutside(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setShapeOutside(BuilderConverter::convertShapeValue(builderState, value));
    }
    static void applyInitialShapeRendering(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setShapeRendering(SVGRenderStyle::initialShapeRendering());
    }
    static void applyInheritShapeRendering(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setShapeRendering(forwardInheritedValue(builderState.parentStyle().svgStyle().shapeRendering()));
    }
    static void applyValueShapeRendering(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setShapeRendering(fromCSSValueDeducingType(value));
    }
    static void applyInitialSpeakAs(BuilderState& builderState)
    {
        builderState.style().setSpeakAs(RenderStyle::initialSpeakAs());
    }
    static void applyInheritSpeakAs(BuilderState& builderState)
    {
        builderState.style().setSpeakAs(forwardInheritedValue(builderState.parentStyle().speakAs()));
    }
    static void applyValueSpeakAs(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setSpeakAs(BuilderConverter::convertSpeakAs(builderState, value));
    }
    static void applyInitialStopColor(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setStopColor(SVGRenderStyle::initialStopColor());
    }
    static void applyInheritStopColor(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setStopColor(forwardInheritedValue(builderState.parentStyle().svgStyle().stopColor()));
    }
    static void applyValueStopColor(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setStopColor(builderState.colorFromPrimitiveValue(downcast<CSSPrimitiveValue>(value), ForVisitedLink::No));
    }
    static void applyInitialStopOpacity(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setStopOpacity(SVGRenderStyle::initialStopOpacity());
    }
    static void applyInheritStopOpacity(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setStopOpacity(forwardInheritedValue(builderState.parentStyle().svgStyle().stopOpacity()));
    }
    static void applyValueStopOpacity(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setStopOpacity(BuilderConverter::convertOpacity(builderState, value));
    }
    static void applyInitialStrokeColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setStrokeColor(RenderStyle::initialStrokeColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkStrokeColor(RenderStyle::initialStrokeColor());
    }
    static void applyInheritStrokeColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setStrokeColor(builderState.parentStyle().strokeColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkStrokeColor(builderState.parentStyle().strokeColor());
    }
    static void applyInitialStrokeDasharray(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setStrokeDashArray(SVGRenderStyle::initialStrokeDashArray());
    }
    static void applyInheritStrokeDasharray(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setStrokeDashArray(forwardInheritedValue(builderState.parentStyle().svgStyle().strokeDashArray()));
    }
    static void applyValueStrokeDasharray(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setStrokeDashArray(BuilderConverter::convertStrokeDashArray(builderState, value));
    }
    static void applyInitialStrokeDashoffset(BuilderState& builderState)
    {
        builderState.style().setStrokeDashOffset(RenderStyle::zeroLength());
    }
    static void applyInheritStrokeDashoffset(BuilderState& builderState)
    {
        builderState.style().setStrokeDashOffset(forwardInheritedValue(builderState.parentStyle().strokeDashOffset()));
    }
    static void applyValueStrokeDashoffset(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setStrokeDashOffset(BuilderConverter::convertLengthAllowingNumber(builderState, value));
    }
    static void applyInitialStrokeLinecap(BuilderState& builderState)
    {
        builderState.style().setCapStyle(RenderStyle::initialCapStyle());
    }
    static void applyInheritStrokeLinecap(BuilderState& builderState)
    {
        builderState.style().setCapStyle(forwardInheritedValue(builderState.parentStyle().capStyle()));
    }
    static void applyValueStrokeLinecap(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setCapStyle(fromCSSValueDeducingType(value));
    }
    static void applyInitialStrokeLinejoin(BuilderState& builderState)
    {
        builderState.style().setJoinStyle(RenderStyle::initialJoinStyle());
    }
    static void applyInheritStrokeLinejoin(BuilderState& builderState)
    {
        builderState.style().setJoinStyle(forwardInheritedValue(builderState.parentStyle().joinStyle()));
    }
    static void applyValueStrokeLinejoin(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setJoinStyle(fromCSSValueDeducingType(value));
    }
    static void applyInitialStrokeMiterlimit(BuilderState& builderState)
    {
        builderState.style().setStrokeMiterLimit(RenderStyle::initialStrokeMiterLimit());
    }
    static void applyInheritStrokeMiterlimit(BuilderState& builderState)
    {
        builderState.style().setStrokeMiterLimit(forwardInheritedValue(builderState.parentStyle().strokeMiterLimit()));
    }
    static void applyValueStrokeMiterlimit(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setStrokeMiterLimit(BuilderConverter::convertNumber<float>(builderState, value));
    }
    static void applyInitialStrokeOpacity(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setStrokeOpacity(SVGRenderStyle::initialStrokeOpacity());
    }
    static void applyInheritStrokeOpacity(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setStrokeOpacity(forwardInheritedValue(builderState.parentStyle().svgStyle().strokeOpacity()));
    }
    static void applyValueStrokeOpacity(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setStrokeOpacity(BuilderConverter::convertOpacity(builderState, value));
    }
    static void applyInitialStrokeWidth(BuilderState& builderState)
    {
        builderState.style().setStrokeWidth(RenderStyle::oneLength());
    }
    static void applyInheritStrokeWidth(BuilderState& builderState)
    {
        builderState.style().setStrokeWidth(forwardInheritedValue(builderState.parentStyle().strokeWidth()));
    }
    static void applyInitialTabSize(BuilderState& builderState)
    {
        builderState.style().setTabSize(RenderStyle::initialTabSize());
    }
    static void applyInheritTabSize(BuilderState& builderState)
    {
        builderState.style().setTabSize(forwardInheritedValue(builderState.parentStyle().tabSize()));
    }
    static void applyValueTabSize(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTabSize(BuilderConverter::convertTabSize(builderState, value));
    }
    static void applyInitialTableLayout(BuilderState& builderState)
    {
        builderState.style().setTableLayout(RenderStyle::initialTableLayout());
    }
    static void applyInheritTableLayout(BuilderState& builderState)
    {
        builderState.style().setTableLayout(forwardInheritedValue(builderState.parentStyle().tableLayout()));
    }
    static void applyValueTableLayout(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTableLayout(fromCSSValueDeducingType(value));
    }
    static void applyInitialTextAlign(BuilderState& builderState)
    {
        builderState.style().setTextAlign(RenderStyle::initialTextAlign());
    }
    static void applyInheritTextAlign(BuilderState& builderState)
    {
        builderState.style().setTextAlign(forwardInheritedValue(builderState.parentStyle().textAlign()));
    }
    static void applyValueTextAlign(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextAlign(BuilderConverter::convertTextAlign(builderState, value));
    }
    static void applyInitialTextAlignLast(BuilderState& builderState)
    {
        builderState.style().setTextAlignLast(RenderStyle::initialTextAlignLast());
    }
    static void applyInheritTextAlignLast(BuilderState& builderState)
    {
        builderState.style().setTextAlignLast(forwardInheritedValue(builderState.parentStyle().textAlignLast()));
    }
    static void applyValueTextAlignLast(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextAlignLast(BuilderConverter::convertTextAlignLast(builderState, value));
    }
    static void applyInitialTextAnchor(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setTextAnchor(SVGRenderStyle::initialTextAnchor());
    }
    static void applyInheritTextAnchor(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setTextAnchor(forwardInheritedValue(builderState.parentStyle().svgStyle().textAnchor()));
    }
    static void applyValueTextAnchor(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setTextAnchor(fromCSSValueDeducingType(value));
    }
    static void applyInitialTextBoxEdge(BuilderState& builderState)
    {
        builderState.style().setTextBoxEdge(RenderStyle::initialTextBoxEdge());
    }
    static void applyInheritTextBoxEdge(BuilderState& builderState)
    {
        builderState.style().setTextBoxEdge(forwardInheritedValue(builderState.parentStyle().textBoxEdge()));
    }
    static void applyValueTextBoxEdge(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextBoxEdge(BuilderConverter::convertTextBoxEdge(builderState, value));
    }
    static void applyInitialTextBoxTrim(BuilderState& builderState)
    {
        builderState.style().setTextBoxTrim(RenderStyle::initialTextBoxTrim());
    }
    static void applyInheritTextBoxTrim(BuilderState& builderState)
    {
        builderState.style().setTextBoxTrim(forwardInheritedValue(builderState.parentStyle().textBoxTrim()));
    }
    static void applyValueTextBoxTrim(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextBoxTrim(fromCSSValueDeducingType(value));
    }
    static void applyInitialTextDecorationColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextDecorationColor(StyleColor::currentColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextDecorationColor(StyleColor::currentColor());
    }
    static void applyInheritTextDecorationColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextDecorationColor(builderState.parentStyle().textDecorationColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextDecorationColor(builderState.parentStyle().textDecorationColor());
    }
    static void applyValueTextDecorationColor(BuilderState& builderState, CSSValue& value)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextDecorationColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::No));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextDecorationColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::Yes));
    }
    static void applyInitialTextDecorationLine(BuilderState& builderState)
    {
        builderState.style().setTextDecorationLine(RenderStyle::initialTextDecorationLine());
    }
    static void applyInheritTextDecorationLine(BuilderState& builderState)
    {
        builderState.style().setTextDecorationLine(forwardInheritedValue(builderState.parentStyle().textDecorationLine()));
    }
    static void applyValueTextDecorationLine(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextDecorationLine(BuilderConverter::convertTextDecorationLine(builderState, value));
    }
    static void applyInitialTextDecorationSkipInk(BuilderState& builderState)
    {
        builderState.style().setTextDecorationSkipInk(RenderStyle::initialTextDecorationSkipInk());
    }
    static void applyInheritTextDecorationSkipInk(BuilderState& builderState)
    {
        builderState.style().setTextDecorationSkipInk(forwardInheritedValue(builderState.parentStyle().textDecorationSkipInk()));
    }
    static void applyValueTextDecorationSkipInk(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextDecorationSkipInk(fromCSSValueDeducingType(value));
    }
    static void applyInitialTextDecorationStyle(BuilderState& builderState)
    {
        builderState.style().setTextDecorationStyle(RenderStyle::initialTextDecorationStyle());
    }
    static void applyInheritTextDecorationStyle(BuilderState& builderState)
    {
        builderState.style().setTextDecorationStyle(forwardInheritedValue(builderState.parentStyle().textDecorationStyle()));
    }
    static void applyValueTextDecorationStyle(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextDecorationStyle(fromCSSValueDeducingType(value));
    }
    static void applyInitialTextDecorationThickness(BuilderState& builderState)
    {
        builderState.style().setTextDecorationThickness(RenderStyle::initialTextDecorationThickness());
    }
    static void applyInheritTextDecorationThickness(BuilderState& builderState)
    {
        builderState.style().setTextDecorationThickness(forwardInheritedValue(builderState.parentStyle().textDecorationThickness()));
    }
    static void applyValueTextDecorationThickness(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextDecorationThickness(BuilderConverter::convertTextDecorationThickness(builderState, value));
    }
    static void applyInitialTextEmphasisColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextEmphasisColor(StyleColor::currentColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextEmphasisColor(StyleColor::currentColor());
    }
    static void applyInheritTextEmphasisColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextEmphasisColor(builderState.parentStyle().textEmphasisColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextEmphasisColor(builderState.parentStyle().textEmphasisColor());
    }
    static void applyValueTextEmphasisColor(BuilderState& builderState, CSSValue& value)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextEmphasisColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::No));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextEmphasisColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::Yes));
    }
    static void applyInitialTextEmphasisPosition(BuilderState& builderState)
    {
        builderState.style().setTextEmphasisPosition(RenderStyle::initialTextEmphasisPosition());
    }
    static void applyInheritTextEmphasisPosition(BuilderState& builderState)
    {
        builderState.style().setTextEmphasisPosition(forwardInheritedValue(builderState.parentStyle().textEmphasisPosition()));
    }
    static void applyValueTextEmphasisPosition(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextEmphasisPosition(BuilderConverter::convertTextEmphasisPosition(builderState, value));
    }
    static void applyInitialTextGroupAlign(BuilderState& builderState)
    {
        builderState.style().setTextGroupAlign(RenderStyle::initialTextGroupAlign());
    }
    static void applyInheritTextGroupAlign(BuilderState& builderState)
    {
        builderState.style().setTextGroupAlign(forwardInheritedValue(builderState.parentStyle().textGroupAlign()));
    }
    static void applyValueTextGroupAlign(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextGroupAlign(fromCSSValueDeducingType(value));
    }
    static void applyInitialTextJustify(BuilderState& builderState)
    {
        builderState.style().setTextJustify(RenderStyle::initialTextJustify());
    }
    static void applyInheritTextJustify(BuilderState& builderState)
    {
        builderState.style().setTextJustify(forwardInheritedValue(builderState.parentStyle().textJustify()));
    }
    static void applyValueTextJustify(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextJustify(fromCSSValueDeducingType(value));
    }
    static void applyInitialTextOverflow(BuilderState& builderState)
    {
        builderState.style().setTextOverflow(RenderStyle::initialTextOverflow());
    }
    static void applyInheritTextOverflow(BuilderState& builderState)
    {
        builderState.style().setTextOverflow(forwardInheritedValue(builderState.parentStyle().textOverflow()));
    }
    static void applyValueTextOverflow(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextOverflow(fromCSSValueDeducingType(value));
    }
    static void applyInitialTextTransform(BuilderState& builderState)
    {
        builderState.style().setTextTransform(RenderStyle::initialTextTransform());
    }
    static void applyInheritTextTransform(BuilderState& builderState)
    {
        builderState.style().setTextTransform(forwardInheritedValue(builderState.parentStyle().textTransform()));
    }
    static void applyValueTextTransform(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextTransform(BuilderConverter::convertTextTransform(builderState, value));
    }
    static void applyInitialTextUnderlineOffset(BuilderState& builderState)
    {
        builderState.style().setTextUnderlineOffset(RenderStyle::initialTextUnderlineOffset());
    }
    static void applyInheritTextUnderlineOffset(BuilderState& builderState)
    {
        builderState.style().setTextUnderlineOffset(forwardInheritedValue(builderState.parentStyle().textUnderlineOffset()));
    }
    static void applyValueTextUnderlineOffset(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextUnderlineOffset(BuilderConverter::convertTextUnderlineOffset(builderState, value));
    }
    static void applyInitialTextUnderlinePosition(BuilderState& builderState)
    {
        builderState.style().setTextUnderlinePosition(RenderStyle::initialTextUnderlinePosition());
    }
    static void applyInheritTextUnderlinePosition(BuilderState& builderState)
    {
        builderState.style().setTextUnderlinePosition(forwardInheritedValue(builderState.parentStyle().textUnderlinePosition()));
    }
    static void applyValueTextUnderlinePosition(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextUnderlinePosition(fromCSSValueDeducingType(value));
    }
    static void applyInitialTextWrapMode(BuilderState& builderState)
    {
        builderState.style().setTextWrapMode(RenderStyle::initialTextWrapMode());
    }
    static void applyInheritTextWrapMode(BuilderState& builderState)
    {
        builderState.style().setTextWrapMode(forwardInheritedValue(builderState.parentStyle().textWrapMode()));
    }
    static void applyValueTextWrapMode(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextWrapMode(fromCSSValueDeducingType(value));
    }
    static void applyInitialTextWrapStyle(BuilderState& builderState)
    {
        builderState.style().setTextWrapStyle(RenderStyle::initialTextWrapStyle());
    }
    static void applyInheritTextWrapStyle(BuilderState& builderState)
    {
        builderState.style().setTextWrapStyle(forwardInheritedValue(builderState.parentStyle().textWrapStyle()));
    }
    static void applyValueTextWrapStyle(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextWrapStyle(fromCSSValueDeducingType(value));
    }
    static void applyInitialTouchAction(BuilderState& builderState)
    {
        builderState.style().setTouchActions(RenderStyle::initialTouchActions());
    }
    static void applyInheritTouchAction(BuilderState& builderState)
    {
        builderState.style().setTouchActions(forwardInheritedValue(builderState.parentStyle().touchActions()));
    }
    static void applyValueTouchAction(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTouchActions(BuilderConverter::convertTouchAction(builderState, value));
    }
    static void applyInitialTransform(BuilderState& builderState)
    {
        builderState.style().setTransform(RenderStyle::initialTransform());
    }
    static void applyInheritTransform(BuilderState& builderState)
    {
        builderState.style().setTransform(forwardInheritedValue(builderState.parentStyle().transform()));
    }
    static void applyValueTransform(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTransform(BuilderConverter::convertTransform(builderState, value));
    }
    static void applyInitialTransformBox(BuilderState& builderState)
    {
        builderState.style().setTransformBox(RenderStyle::initialTransformBox());
    }
    static void applyInheritTransformBox(BuilderState& builderState)
    {
        builderState.style().setTransformBox(forwardInheritedValue(builderState.parentStyle().transformBox()));
    }
    static void applyValueTransformBox(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTransformBox(fromCSSValueDeducingType(value));
    }
    static void applyInitialTransformOriginX(BuilderState& builderState)
    {
        builderState.style().setTransformOriginX(RenderStyle::initialTransformOriginX());
    }
    static void applyInheritTransformOriginX(BuilderState& builderState)
    {
        builderState.style().setTransformOriginX(forwardInheritedValue(builderState.parentStyle().transformOriginX()));
    }
    static void applyValueTransformOriginX(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTransformOriginX(BuilderConverter::convertPositionComponentX(builderState, value));
    }
    static void applyInitialTransformOriginY(BuilderState& builderState)
    {
        builderState.style().setTransformOriginY(RenderStyle::initialTransformOriginY());
    }
    static void applyInheritTransformOriginY(BuilderState& builderState)
    {
        builderState.style().setTransformOriginY(forwardInheritedValue(builderState.parentStyle().transformOriginY()));
    }
    static void applyValueTransformOriginY(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTransformOriginY(BuilderConverter::convertPositionComponentY(builderState, value));
    }
    static void applyInitialTransformOriginZ(BuilderState& builderState)
    {
        builderState.style().setTransformOriginZ(RenderStyle::initialTransformOriginZ());
    }
    static void applyInheritTransformOriginZ(BuilderState& builderState)
    {
        builderState.style().setTransformOriginZ(forwardInheritedValue(builderState.parentStyle().transformOriginZ()));
    }
    static void applyValueTransformOriginZ(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTransformOriginZ(BuilderConverter::convertComputedLength<float>(builderState, value));
    }
    static void applyInitialTransformStyle(BuilderState& builderState)
    {
        builderState.style().setTransformStyle3D(RenderStyle::initialTransformStyle3D());
    }
    static void applyInheritTransformStyle(BuilderState& builderState)
    {
        builderState.style().setTransformStyle3D(forwardInheritedValue(builderState.parentStyle().transformStyle3D()));
    }
    static void applyValueTransformStyle(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTransformStyle3D(fromCSSValueDeducingType(value));
    }
    static void applyInitialTransitionBehavior(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureTransitions();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setAllowsDiscreteTransitions(Animation::initialAllowsDiscreteTransitions());
        for (auto& animation : list)
            animation->clearAllowsDiscreteTransitions();
    }
    static void applyInheritTransitionBehavior(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureTransitions();
        auto* parentList = builderState.parentStyle().transitions();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isAllowsDiscreteTransitionsSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setAllowsDiscreteTransitions(parentList->animation(i).allowsDiscreteTransitions());
        }
        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearAllowsDiscreteTransitions();
    }
    static void applyValueTransitionBehavior(BuilderState& builderState, CSSValue& value)
    {
        auto& list = builderState.style().ensureTransitions();
        size_t childIndex = 0;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into an animation, creating new animations as needed.
            for (auto& currentValue : *valueList) {
                if (childIndex >= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationAllowsDiscreteTransitions(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationAllowsDiscreteTransitions(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            // Reset all remaining animations to not have the property set.
            list.animation(childIndex).clearAllowsDiscreteTransitions();
        }
    }
    static void applyInitialTransitionDelay(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureTransitions();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setDelay(Animation::initialDelay());
        for (auto& animation : list)
            animation->clearDelay();
    }
    static void applyInheritTransitionDelay(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureTransitions();
        auto* parentList = builderState.parentStyle().transitions();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isDelaySet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setDelay(parentList->animation(i).delay());
        }
        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearDelay();
    }
    static void applyValueTransitionDelay(BuilderState& builderState, CSSValue& value)
    {
        auto& list = builderState.style().ensureTransitions();
        size_t childIndex = 0;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into an animation, creating new animations as needed.
            for (auto& currentValue : *valueList) {
                if (childIndex >= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationDelay(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationDelay(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            // Reset all remaining animations to not have the property set.
            list.animation(childIndex).clearDelay();
        }
    }
    static void applyInitialTransitionDuration(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureTransitions();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setDuration(Animation::initialDuration());
        for (auto& animation : list)
            animation->clearDuration();
    }
    static void applyInheritTransitionDuration(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureTransitions();
        auto* parentList = builderState.parentStyle().transitions();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isDurationSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setDuration(parentList->animation(i).duration());
        }
        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearDuration();
    }
    static void applyValueTransitionDuration(BuilderState& builderState, CSSValue& value)
    {
        auto& list = builderState.style().ensureTransitions();
        size_t childIndex = 0;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into an animation, creating new animations as needed.
            for (auto& currentValue : *valueList) {
                if (childIndex >= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationDuration(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationDuration(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            // Reset all remaining animations to not have the property set.
            list.animation(childIndex).clearDuration();
        }
    }
    static void applyInitialTransitionProperty(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureTransitions();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setProperty(Animation::initialProperty());
        for (auto& animation : list)
            animation->clearProperty();
    }
    static void applyInheritTransitionProperty(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureTransitions();
        auto* parentList = builderState.parentStyle().transitions();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isPropertySet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setProperty(parentList->animation(i).property());
        }
        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearProperty();
    }
    static void applyValueTransitionProperty(BuilderState& builderState, CSSValue& value)
    {
        auto& list = builderState.style().ensureTransitions();
        size_t childIndex = 0;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into an animation, creating new animations as needed.
            for (auto& currentValue : *valueList) {
                if (childIndex >= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationProperty(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationProperty(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            // Reset all remaining animations to not have the property set.
            list.animation(childIndex).clearProperty();
        }
    }
    static void applyInitialTransitionTimingFunction(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureTransitions();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setTimingFunction(Animation::initialTimingFunction());
        for (auto& animation : list)
            animation->clearTimingFunction();
    }
    static void applyInheritTransitionTimingFunction(BuilderState& builderState)
    {
        auto& list = builderState.style().ensureTransitions();
        auto* parentList = builderState.parentStyle().transitions();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isTimingFunctionSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setTimingFunction(parentList->animation(i).timingFunction());
        }
        // Reset any remaining animations to not have the property set.
        for ( ; i < list.size(); ++i)
            list.animation(i).clearTimingFunction();
    }
    static void applyValueTransitionTimingFunction(BuilderState& builderState, CSSValue& value)
    {
        auto& list = builderState.style().ensureTransitions();
        size_t childIndex = 0;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into an animation, creating new animations as needed.
            for (auto& currentValue : *valueList) {
                if (childIndex >= list.size())
                    list.append(Animation::create());
                builderState.styleMap().mapAnimationTimingFunction(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            builderState.styleMap().mapAnimationTimingFunction(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            // Reset all remaining animations to not have the property set.
            list.animation(childIndex).clearTimingFunction();
        }
    }
    static void applyInitialTranslate(BuilderState& builderState)
    {
        builderState.style().setTranslate(RenderStyle::initialTranslate());
    }
    static void applyInheritTranslate(BuilderState& builderState)
    {
        builderState.style().setTranslate(forwardInheritedValue(builderState.parentStyle().translate()));
    }
    static void applyValueTranslate(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTranslate(BuilderConverter::convertTranslate(builderState, value));
    }
    static void applyInitialUnicodeBidi(BuilderState& builderState)
    {
        builderState.style().setUnicodeBidi(RenderStyle::initialUnicodeBidi());
    }
    static void applyInheritUnicodeBidi(BuilderState& builderState)
    {
        builderState.style().setUnicodeBidi(forwardInheritedValue(builderState.parentStyle().unicodeBidi()));
    }
    static void applyValueUnicodeBidi(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setUnicodeBidi(fromCSSValueDeducingType(value));
    }
    static void applyInitialVectorEffect(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setVectorEffect(SVGRenderStyle::initialVectorEffect());
    }
    static void applyInheritVectorEffect(BuilderState& builderState)
    {
        builderState.style().accessSVGStyle().setVectorEffect(forwardInheritedValue(builderState.parentStyle().svgStyle().vectorEffect()));
    }
    static void applyValueVectorEffect(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().accessSVGStyle().setVectorEffect(fromCSSValueDeducingType(value));
    }
    static void applyInitialVerticalAlign(BuilderState& builderState)
    {
        builderState.style().setVerticalAlign(RenderStyle::initialVerticalAlign());
    }
    static void applyInitialViewTimelineAxis(BuilderState& builderState)
    {
        builderState.style().setViewTimelineAxes(RenderStyle::initialViewTimelineAxes());
    }
    static void applyInheritViewTimelineAxis(BuilderState& builderState)
    {
        builderState.style().setViewTimelineAxes(forwardInheritedValue(builderState.parentStyle().viewTimelineAxes()));
    }
    static void applyValueViewTimelineAxis(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setViewTimelineAxes(BuilderConverter::convertScrollTimelineAxis(builderState, value));
    }
    static void applyInitialViewTimelineInset(BuilderState& builderState)
    {
        builderState.style().setViewTimelineInsets(RenderStyle::initialViewTimelineInsets());
    }
    static void applyInheritViewTimelineInset(BuilderState& builderState)
    {
        builderState.style().setViewTimelineInsets(forwardInheritedValue(builderState.parentStyle().viewTimelineInsets()));
    }
    static void applyValueViewTimelineInset(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setViewTimelineInsets(BuilderConverter::convertViewTimelineInset(builderState, value));
    }
    static void applyInitialViewTimelineName(BuilderState& builderState)
    {
        builderState.style().setViewTimelineNames(RenderStyle::initialViewTimelineNames());
    }
    static void applyInheritViewTimelineName(BuilderState& builderState)
    {
        builderState.style().setViewTimelineNames(forwardInheritedValue(builderState.parentStyle().viewTimelineNames()));
    }
    static void applyValueViewTimelineName(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setViewTimelineNames(BuilderConverter::convertScrollTimelineName(builderState, value));
    }
    static void applyInitialViewTransitionName(BuilderState& builderState)
    {
        builderState.style().setViewTransitionName(RenderStyle::initialViewTransitionName());
    }
    static void applyInheritViewTransitionName(BuilderState& builderState)
    {
        builderState.style().setViewTransitionName(forwardInheritedValue(builderState.parentStyle().viewTransitionName()));
    }
    static void applyValueViewTransitionName(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setViewTransitionName(BuilderConverter::convertViewTransitionName(builderState, value));
    }
    static void applyInitialVisibility(BuilderState& builderState)
    {
        builderState.style().setVisibility(RenderStyle::initialVisibility());
        builderState.style().setDisallowsFastPathInheritance();
    }
    static void applyInheritVisibility(BuilderState& builderState)
    {
        builderState.style().setVisibility(forwardInheritedValue(builderState.parentStyle().visibility()));
        builderState.style().setDisallowsFastPathInheritance();
    }
    static void applyValueVisibility(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setVisibility(fromCSSValueDeducingType(value));
        builderState.style().setDisallowsFastPathInheritance();
    }
    static void applyInitialWhiteSpaceCollapse(BuilderState& builderState)
    {
        builderState.style().setWhiteSpaceCollapse(RenderStyle::initialWhiteSpaceCollapse());
    }
    static void applyInheritWhiteSpaceCollapse(BuilderState& builderState)
    {
        builderState.style().setWhiteSpaceCollapse(forwardInheritedValue(builderState.parentStyle().whiteSpaceCollapse()));
    }
    static void applyValueWhiteSpaceCollapse(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setWhiteSpaceCollapse(fromCSSValueDeducingType(value));
    }
    static void applyInitialWidows(BuilderState& builderState)
    {
        builderState.style().setHasAutoWidows();
    }
    static void applyInheritWidows(BuilderState& builderState)
    {
        if (builderState.parentStyle().hasAutoWidows()) {
            builderState.style().setHasAutoWidows();
            return;
        }
        builderState.style().setWidows(forwardInheritedValue(builderState.parentStyle().widows()));
    }
    static void applyValueWidows(BuilderState& builderState, CSSValue& value)
    {
        if (value.valueID() == CSSValueAuto) {
            builderState.style().setHasAutoWidows();
            return;
        }
        builderState.style().setWidows(fromCSSValueDeducingType(value));
    }
    static void applyInitialWillChange(BuilderState& builderState)
    {
        builderState.style().setWillChange(RenderStyle::initialWillChange());
    }
    static void applyInheritWillChange(BuilderState& builderState)
    {
        builderState.style().setWillChange(forwardInheritedValue(builderState.parentStyle().willChange()));
    }
    static void applyValueWillChange(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setWillChange(BuilderConverter::convertWillChange(builderState, value));
    }
    static void applyInitialWordBreak(BuilderState& builderState)
    {
        builderState.style().setWordBreak(RenderStyle::initialWordBreak());
    }
    static void applyInheritWordBreak(BuilderState& builderState)
    {
        builderState.style().setWordBreak(forwardInheritedValue(builderState.parentStyle().wordBreak()));
    }
    static void applyValueWordBreak(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setWordBreak(fromCSSValueDeducingType(value));
    }
    static void applyInitialX(BuilderState& builderState)
    {
        builderState.style().setX(RenderStyle::zeroLength());
    }
    static void applyInheritX(BuilderState& builderState)
    {
        builderState.style().setX(forwardInheritedValue(builderState.parentStyle().x()));
    }
    static void applyValueX(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setX(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialY(BuilderState& builderState)
    {
        builderState.style().setY(RenderStyle::zeroLength());
    }
    static void applyInheritY(BuilderState& builderState)
    {
        builderState.style().setY(forwardInheritedValue(builderState.parentStyle().y()));
    }
    static void applyValueY(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setY(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialZIndex(BuilderState& builderState)
    {
        builderState.style().setHasAutoSpecifiedZIndex();
    }
    static void applyInheritZIndex(BuilderState& builderState)
    {
        if (builderState.parentStyle().hasAutoSpecifiedZIndex()) {
            builderState.style().setHasAutoSpecifiedZIndex();
            return;
        }
        builderState.style().setSpecifiedZIndex(forwardInheritedValue(builderState.parentStyle().specifiedZIndex()));
    }
    static void applyValueZIndex(BuilderState& builderState, CSSValue& value)
    {
        if (value.valueID() == CSSValueAuto) {
            builderState.style().setHasAutoSpecifiedZIndex();
            return;
        }
        builderState.style().setSpecifiedZIndex(fromCSSValueDeducingType(value));
    }
    static void applyInitialAppleColorFilter(BuilderState& builderState)
    {
        builderState.style().setAppleColorFilter(RenderStyle::initialAppleColorFilter());
    }
    static void applyInheritAppleColorFilter(BuilderState& builderState)
    {
        builderState.style().setAppleColorFilter(forwardInheritedValue(builderState.parentStyle().appleColorFilter()));
    }
    static void applyValueAppleColorFilter(BuilderState& builderState, CSSValue& value)
    {
        auto convertedValue = BuilderConverter::convertFilterOperations(builderState, value);
        if (convertedValue)
            builderState.style().setAppleColorFilter(WTFMove(convertedValue.value()));
    }
    static void applyInitialWebkitBorderHorizontalSpacing(BuilderState& builderState)
    {
        builderState.style().setHorizontalBorderSpacing(RenderStyle::initialHorizontalBorderSpacing());
    }
    static void applyInheritWebkitBorderHorizontalSpacing(BuilderState& builderState)
    {
        builderState.style().setHorizontalBorderSpacing(forwardInheritedValue(builderState.parentStyle().horizontalBorderSpacing()));
    }
    static void applyValueWebkitBorderHorizontalSpacing(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setHorizontalBorderSpacing(BuilderConverter::convertComputedLength<float>(builderState, value));
    }
    static void applyInitialWebkitBorderVerticalSpacing(BuilderState& builderState)
    {
        builderState.style().setVerticalBorderSpacing(RenderStyle::initialVerticalBorderSpacing());
    }
    static void applyInheritWebkitBorderVerticalSpacing(BuilderState& builderState)
    {
        builderState.style().setVerticalBorderSpacing(forwardInheritedValue(builderState.parentStyle().verticalBorderSpacing()));
    }
    static void applyValueWebkitBorderVerticalSpacing(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setVerticalBorderSpacing(BuilderConverter::convertComputedLength<float>(builderState, value));
    }
    static void applyInitialWebkitBoxAlign(BuilderState& builderState)
    {
        builderState.style().setBoxAlign(RenderStyle::initialBoxAlign());
    }
    static void applyInheritWebkitBoxAlign(BuilderState& builderState)
    {
        builderState.style().setBoxAlign(forwardInheritedValue(builderState.parentStyle().boxAlign()));
    }
    static void applyValueWebkitBoxAlign(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxAlign(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitBoxDecorationBreak(BuilderState& builderState)
    {
        builderState.style().setBoxDecorationBreak(RenderStyle::initialBoxDecorationBreak());
    }
    static void applyInheritWebkitBoxDecorationBreak(BuilderState& builderState)
    {
        builderState.style().setBoxDecorationBreak(forwardInheritedValue(builderState.parentStyle().boxDecorationBreak()));
    }
    static void applyValueWebkitBoxDecorationBreak(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxDecorationBreak(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitBoxDirection(BuilderState& builderState)
    {
        builderState.style().setBoxDirection(RenderStyle::initialBoxDirection());
    }
    static void applyInheritWebkitBoxDirection(BuilderState& builderState)
    {
        builderState.style().setBoxDirection(forwardInheritedValue(builderState.parentStyle().boxDirection()));
    }
    static void applyValueWebkitBoxDirection(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxDirection(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitBoxFlex(BuilderState& builderState)
    {
        builderState.style().setBoxFlex(RenderStyle::initialBoxFlex());
    }
    static void applyInheritWebkitBoxFlex(BuilderState& builderState)
    {
        builderState.style().setBoxFlex(forwardInheritedValue(builderState.parentStyle().boxFlex()));
    }
    static void applyValueWebkitBoxFlex(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxFlex(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitBoxFlexGroup(BuilderState& builderState)
    {
        builderState.style().setBoxFlexGroup(RenderStyle::initialBoxFlexGroup());
    }
    static void applyInheritWebkitBoxFlexGroup(BuilderState& builderState)
    {
        builderState.style().setBoxFlexGroup(forwardInheritedValue(builderState.parentStyle().boxFlexGroup()));
    }
    static void applyValueWebkitBoxFlexGroup(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxFlexGroup(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitBoxLines(BuilderState& builderState)
    {
        builderState.style().setBoxLines(RenderStyle::initialBoxLines());
    }
    static void applyInheritWebkitBoxLines(BuilderState& builderState)
    {
        builderState.style().setBoxLines(forwardInheritedValue(builderState.parentStyle().boxLines()));
    }
    static void applyValueWebkitBoxLines(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxLines(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitBoxOrdinalGroup(BuilderState& builderState)
    {
        builderState.style().setBoxOrdinalGroup(RenderStyle::initialBoxOrdinalGroup());
    }
    static void applyInheritWebkitBoxOrdinalGroup(BuilderState& builderState)
    {
        builderState.style().setBoxOrdinalGroup(forwardInheritedValue(builderState.parentStyle().boxOrdinalGroup()));
    }
    static void applyValueWebkitBoxOrdinalGroup(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxOrdinalGroup(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitBoxOrient(BuilderState& builderState)
    {
        builderState.style().setBoxOrient(RenderStyle::initialBoxOrient());
    }
    static void applyInheritWebkitBoxOrient(BuilderState& builderState)
    {
        builderState.style().setBoxOrient(forwardInheritedValue(builderState.parentStyle().boxOrient()));
    }
    static void applyValueWebkitBoxOrient(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxOrient(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitBoxPack(BuilderState& builderState)
    {
        builderState.style().setBoxPack(RenderStyle::initialBoxPack());
    }
    static void applyInheritWebkitBoxPack(BuilderState& builderState)
    {
        builderState.style().setBoxPack(forwardInheritedValue(builderState.parentStyle().boxPack()));
    }
    static void applyValueWebkitBoxPack(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxPack(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitBoxReflect(BuilderState& builderState)
    {
        builderState.style().setBoxReflect(RenderStyle::initialBoxReflect());
    }
    static void applyInheritWebkitBoxReflect(BuilderState& builderState)
    {
        builderState.style().setBoxReflect(forwardInheritedValue(builderState.parentStyle().boxReflect()));
    }
    static void applyValueWebkitBoxReflect(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBoxReflect(BuilderConverter::convertReflection(builderState, value));
    }
    static void applyInitialWebkitColumnAxis(BuilderState& builderState)
    {
        builderState.style().setColumnAxis(RenderStyle::initialColumnAxis());
    }
    static void applyInheritWebkitColumnAxis(BuilderState& builderState)
    {
        builderState.style().setColumnAxis(forwardInheritedValue(builderState.parentStyle().columnAxis()));
    }
    static void applyValueWebkitColumnAxis(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setColumnAxis(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitColumnProgression(BuilderState& builderState)
    {
        builderState.style().setColumnProgression(RenderStyle::initialColumnProgression());
    }
    static void applyInheritWebkitColumnProgression(BuilderState& builderState)
    {
        builderState.style().setColumnProgression(forwardInheritedValue(builderState.parentStyle().columnProgression()));
    }
    static void applyValueWebkitColumnProgression(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setColumnProgression(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitCursorVisibility(BuilderState& builderState)
    {
        builderState.style().setCursorVisibility(RenderStyle::initialCursorVisibility());
    }
    static void applyInheritWebkitCursorVisibility(BuilderState& builderState)
    {
        builderState.style().setCursorVisibility(forwardInheritedValue(builderState.parentStyle().cursorVisibility()));
    }
    static void applyValueWebkitCursorVisibility(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setCursorVisibility(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitHyphenateLimitAfter(BuilderState& builderState)
    {
        builderState.style().setHyphenationLimitAfter(RenderStyle::initialHyphenationLimitAfter());
    }
    static void applyInheritWebkitHyphenateLimitAfter(BuilderState& builderState)
    {
        builderState.style().setHyphenationLimitAfter(forwardInheritedValue(builderState.parentStyle().hyphenationLimitAfter()));
    }
    static void applyValueWebkitHyphenateLimitAfter(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setHyphenationLimitAfter(BuilderConverter::convertNumberOrAuto<short>(builderState, value));
    }
    static void applyInitialWebkitHyphenateLimitBefore(BuilderState& builderState)
    {
        builderState.style().setHyphenationLimitBefore(RenderStyle::initialHyphenationLimitBefore());
    }
    static void applyInheritWebkitHyphenateLimitBefore(BuilderState& builderState)
    {
        builderState.style().setHyphenationLimitBefore(forwardInheritedValue(builderState.parentStyle().hyphenationLimitBefore()));
    }
    static void applyValueWebkitHyphenateLimitBefore(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setHyphenationLimitBefore(BuilderConverter::convertNumberOrAuto<short>(builderState, value));
    }
    static void applyInitialWebkitHyphenateLimitLines(BuilderState& builderState)
    {
        builderState.style().setHyphenationLimitLines(RenderStyle::initialHyphenationLimitLines());
    }
    static void applyInheritWebkitHyphenateLimitLines(BuilderState& builderState)
    {
        builderState.style().setHyphenationLimitLines(forwardInheritedValue(builderState.parentStyle().hyphenationLimitLines()));
    }
    static void applyValueWebkitHyphenateLimitLines(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setHyphenationLimitLines(BuilderConverter::convertWebkitHyphenateLimitLines(builderState, value));
    }
    static void applyInitialWebkitInitialLetter(BuilderState& builderState)
    {
        builderState.style().setInitialLetter(RenderStyle::initialInitialLetter());
    }
    static void applyInheritWebkitInitialLetter(BuilderState& builderState)
    {
        builderState.style().setInitialLetter(forwardInheritedValue(builderState.parentStyle().initialLetter()));
    }
    static void applyValueWebkitInitialLetter(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setInitialLetter(BuilderConverter::convertInitialLetter(builderState, value));
    }
    static void applyInitialWebkitLineAlign(BuilderState& builderState)
    {
        builderState.style().setLineAlign(RenderStyle::initialLineAlign());
    }
    static void applyInheritWebkitLineAlign(BuilderState& builderState)
    {
        builderState.style().setLineAlign(forwardInheritedValue(builderState.parentStyle().lineAlign()));
    }
    static void applyValueWebkitLineAlign(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setLineAlign(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitLineBoxContain(BuilderState& builderState)
    {
        builderState.style().setLineBoxContain(RenderStyle::initialLineBoxContain());
    }
    static void applyInheritWebkitLineBoxContain(BuilderState& builderState)
    {
        builderState.style().setLineBoxContain(forwardInheritedValue(builderState.parentStyle().lineBoxContain()));
    }
    static void applyValueWebkitLineBoxContain(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setLineBoxContain(BuilderConverter::convertLineBoxContain(builderState, value));
    }
    static void applyInitialWebkitLineClamp(BuilderState& builderState)
    {
        builderState.style().setLineClamp(RenderStyle::initialLineClamp());
    }
    static void applyInheritWebkitLineClamp(BuilderState& builderState)
    {
        builderState.style().setLineClamp(forwardInheritedValue(builderState.parentStyle().lineClamp()));
    }
    static void applyValueWebkitLineClamp(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setLineClamp(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitLineGrid(BuilderState& builderState)
    {
        builderState.style().setLineGrid(RenderStyle::initialLineGrid());
    }
    static void applyInheritWebkitLineGrid(BuilderState& builderState)
    {
        builderState.style().setLineGrid(forwardInheritedValue(builderState.parentStyle().lineGrid()));
    }
    static void applyValueWebkitLineGrid(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setLineGrid(BuilderConverter::convertStringOrNoneAtom(builderState, value));
    }
    static void applyInitialWebkitLineSnap(BuilderState& builderState)
    {
        builderState.style().setLineSnap(RenderStyle::initialLineSnap());
    }
    static void applyInheritWebkitLineSnap(BuilderState& builderState)
    {
        builderState.style().setLineSnap(forwardInheritedValue(builderState.parentStyle().lineSnap()));
    }
    static void applyValueWebkitLineSnap(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setLineSnap(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitMarqueeDirection(BuilderState& builderState)
    {
        builderState.style().setMarqueeDirection(RenderStyle::initialMarqueeDirection());
    }
    static void applyInheritWebkitMarqueeDirection(BuilderState& builderState)
    {
        builderState.style().setMarqueeDirection(forwardInheritedValue(builderState.parentStyle().marqueeDirection()));
    }
    static void applyValueWebkitMarqueeDirection(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMarqueeDirection(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitMarqueeIncrement(BuilderState& builderState)
    {
        builderState.style().setMarqueeIncrement(RenderStyle::initialMarqueeIncrement());
    }
    static void applyInheritWebkitMarqueeIncrement(BuilderState& builderState)
    {
        builderState.style().setMarqueeIncrement(forwardInheritedValue(builderState.parentStyle().marqueeIncrement()));
    }
    static void applyValueWebkitMarqueeIncrement(BuilderState& builderState, CSSValue& value)
    {
        auto convertedValue = BuilderConverter::convertMarqueeIncrement(builderState, value);
        if (convertedValue)
            builderState.style().setMarqueeIncrement(WTFMove(convertedValue.value()));
    }
    static void applyInitialWebkitMarqueeRepetition(BuilderState& builderState)
    {
        builderState.style().setMarqueeLoopCount(RenderStyle::initialMarqueeLoopCount());
    }
    static void applyInheritWebkitMarqueeRepetition(BuilderState& builderState)
    {
        builderState.style().setMarqueeLoopCount(forwardInheritedValue(builderState.parentStyle().marqueeLoopCount()));
    }
    static void applyValueWebkitMarqueeRepetition(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMarqueeLoopCount(BuilderConverter::convertMarqueeRepetition(builderState, value));
    }
    static void applyInitialWebkitMarqueeSpeed(BuilderState& builderState)
    {
        builderState.style().setMarqueeSpeed(RenderStyle::initialMarqueeSpeed());
    }
    static void applyInheritWebkitMarqueeSpeed(BuilderState& builderState)
    {
        builderState.style().setMarqueeSpeed(forwardInheritedValue(builderState.parentStyle().marqueeSpeed()));
    }
    static void applyValueWebkitMarqueeSpeed(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMarqueeSpeed(BuilderConverter::convertMarqueeSpeed(builderState, value));
    }
    static void applyInitialWebkitMarqueeStyle(BuilderState& builderState)
    {
        builderState.style().setMarqueeBehavior(RenderStyle::initialMarqueeBehavior());
    }
    static void applyInheritWebkitMarqueeStyle(BuilderState& builderState)
    {
        builderState.style().setMarqueeBehavior(forwardInheritedValue(builderState.parentStyle().marqueeBehavior()));
    }
    static void applyValueWebkitMarqueeStyle(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMarqueeBehavior(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitMaskPositionX(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().maskLayers();
        if (!layers.next() && (!layers.isXPositionSet() || layers.xPosition() == FillLayer::initialFillXPosition(FillLayerType::Mask)))
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        child->setXPosition(FillLayer::initialFillXPosition(FillLayerType::Mask));
        for (child = child->next(); child; child = child->next())
            child->clearXPosition();
    }
    static void applyInheritWebkitMaskPositionX(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().maskLayers() == builderState.style().maskLayers())
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().maskLayers(); parent && parent->isXPositionSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                child = previousChild->next();
            }
            child->setXPosition(parent->xPosition());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearXPosition();
    }
    static void applyValueWebkitMaskPositionX(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillXPosition(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillXPosition(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearXPosition();
    }
    static void applyInitialWebkitMaskPositionY(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().maskLayers();
        if (!layers.next() && (!layers.isYPositionSet() || layers.yPosition() == FillLayer::initialFillYPosition(FillLayerType::Mask)))
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        child->setYPosition(FillLayer::initialFillYPosition(FillLayerType::Mask));
        for (child = child->next(); child; child = child->next())
            child->clearYPosition();
    }
    static void applyInheritWebkitMaskPositionY(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().maskLayers() == builderState.style().maskLayers())
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().maskLayers(); parent && parent->isYPositionSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                child = previousChild->next();
            }
            child->setYPosition(parent->yPosition());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearYPosition();
    }
    static void applyValueWebkitMaskPositionY(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillYPosition(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillYPosition(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearYPosition();
    }
    static void applyInitialWebkitNbspMode(BuilderState& builderState)
    {
        builderState.style().setNBSPMode(RenderStyle::initialNBSPMode());
    }
    static void applyInheritWebkitNbspMode(BuilderState& builderState)
    {
        builderState.style().setNBSPMode(forwardInheritedValue(builderState.parentStyle().nbspMode()));
    }
    static void applyValueWebkitNbspMode(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setNBSPMode(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitRtlOrdering(BuilderState& builderState)
    {
        builderState.style().setRTLOrdering(RenderStyle::initialRTLOrdering());
    }
    static void applyInheritWebkitRtlOrdering(BuilderState& builderState)
    {
        builderState.style().setRTLOrdering(forwardInheritedValue(builderState.parentStyle().rtlOrdering()));
    }
    static void applyValueWebkitRtlOrdering(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setRTLOrdering(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitTapHighlightColor(BuilderState& builderState)
    {
        builderState.style().setTapHighlightColor(RenderStyle::initialTapHighlightColor());
    }
    static void applyInheritWebkitTapHighlightColor(BuilderState& builderState)
    {
        builderState.style().setTapHighlightColor(forwardInheritedValue(builderState.parentStyle().tapHighlightColor()));
    }
    static void applyValueWebkitTapHighlightColor(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTapHighlightColor(BuilderConverter::convertTapHighlightColor(builderState, value));
    }
    static void applyInitialWebkitTextFillColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextFillColor(StyleColor::currentColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextFillColor(StyleColor::currentColor());
    }
    static void applyInheritWebkitTextFillColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextFillColor(builderState.parentStyle().textFillColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextFillColor(builderState.parentStyle().textFillColor());
    }
    static void applyValueWebkitTextFillColor(BuilderState& builderState, CSSValue& value)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextFillColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::No));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextFillColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::Yes));
    }
    static void applyInitialWebkitTextSecurity(BuilderState& builderState)
    {
        builderState.style().setTextSecurity(RenderStyle::initialTextSecurity());
    }
    static void applyInheritWebkitTextSecurity(BuilderState& builderState)
    {
        builderState.style().setTextSecurity(forwardInheritedValue(builderState.parentStyle().textSecurity()));
    }
    static void applyValueWebkitTextSecurity(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextSecurity(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitTextStrokeColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextStrokeColor(StyleColor::currentColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextStrokeColor(StyleColor::currentColor());
    }
    static void applyInheritWebkitTextStrokeColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextStrokeColor(builderState.parentStyle().textStrokeColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextStrokeColor(builderState.parentStyle().textStrokeColor());
    }
    static void applyValueWebkitTextStrokeColor(BuilderState& builderState, CSSValue& value)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setTextStrokeColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::No));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkTextStrokeColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::Yes));
    }
    static void applyInitialWebkitTextStrokeWidth(BuilderState& builderState)
    {
        builderState.style().setTextStrokeWidth(RenderStyle::initialTextStrokeWidth());
    }
    static void applyInheritWebkitTextStrokeWidth(BuilderState& builderState)
    {
        builderState.style().setTextStrokeWidth(forwardInheritedValue(builderState.parentStyle().textStrokeWidth()));
    }
    static void applyValueWebkitTextStrokeWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextStrokeWidth(BuilderConverter::convertTextStrokeWidth(builderState, value));
    }
    static void applyInitialWebkitUserDrag(BuilderState& builderState)
    {
        builderState.style().setUserDrag(RenderStyle::initialUserDrag());
    }
    static void applyInheritWebkitUserDrag(BuilderState& builderState)
    {
        builderState.style().setUserDrag(forwardInheritedValue(builderState.parentStyle().userDrag()));
    }
    static void applyValueWebkitUserDrag(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setUserDrag(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitUserModify(BuilderState& builderState)
    {
        builderState.style().setUserModify(RenderStyle::initialUserModify());
    }
    static void applyInheritWebkitUserModify(BuilderState& builderState)
    {
        builderState.style().setUserModify(forwardInheritedValue(builderState.parentStyle().userModify()));
    }
    static void applyValueWebkitUserModify(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setUserModify(fromCSSValueDeducingType(value));
    }
    static void applyInitialWebkitUserSelect(BuilderState& builderState)
    {
        builderState.style().setUserSelect(RenderStyle::initialUserSelect());
    }
    static void applyInheritWebkitUserSelect(BuilderState& builderState)
    {
        builderState.style().setUserSelect(forwardInheritedValue(builderState.parentStyle().userSelect()));
    }
    static void applyValueWebkitUserSelect(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setUserSelect(fromCSSValueDeducingType(value));
    }
    static void applyInitialWordSpacing(BuilderState& builderState)
    {
        builderState.style().setWordSpacing(RenderStyle::initialWordSpacing());
    }
    static void applyValueWordSpacing(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setWordSpacing(BuilderConverter::convertTextLengthOrNormal(builderState, value));
    }
    static void applyInitialBackdropFilter(BuilderState& builderState)
    {
        builderState.style().setBackdropFilter(RenderStyle::initialBackdropFilter());
    }
    static void applyInheritBackdropFilter(BuilderState& builderState)
    {
        builderState.style().setBackdropFilter(forwardInheritedValue(builderState.parentStyle().backdropFilter()));
    }
    static void applyValueBackdropFilter(BuilderState& builderState, CSSValue& value)
    {
        auto convertedValue = BuilderConverter::convertFilterOperations(builderState, value);
        if (convertedValue)
            builderState.style().setBackdropFilter(WTFMove(convertedValue.value()));
    }
    static void applyInitialBackgroundClip(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isClipSet() || layers.clip() == FillLayer::initialFillClip(FillLayerType::Background)))
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setClip(FillLayer::initialFillClip(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearClip();
    }
    static void applyInheritBackgroundClip(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isClipSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setClip(parent->clip());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearClip();
    }
    static void applyValueBackgroundClip(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillClip(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillClip(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearClip();
    }
    static void applyInitialBackgroundOrigin(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isOriginSet() || layers.origin() == FillLayer::initialFillOrigin(FillLayerType::Background)))
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setOrigin(FillLayer::initialFillOrigin(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearOrigin();
    }
    static void applyInheritBackgroundOrigin(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isOriginSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setOrigin(parent->origin());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearOrigin();
    }
    static void applyValueBackgroundOrigin(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillOrigin(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillOrigin(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearOrigin();
    }
    static void applyInitialBorderBottomColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderBottomColor(StyleColor::currentColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderBottomColor(StyleColor::currentColor());
    }
    static void applyInheritBorderBottomColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderBottomColor(builderState.parentStyle().borderBottomColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderBottomColor(builderState.parentStyle().borderBottomColor());
    }
    static void applyValueBorderBottomColor(BuilderState& builderState, CSSValue& value)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderBottomColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::No));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderBottomColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::Yes));
    }
    static void applyInitialBorderBottomStyle(BuilderState& builderState)
    {
        builderState.style().setBorderBottomStyle(RenderStyle::initialBorderStyle());
    }
    static void applyInheritBorderBottomStyle(BuilderState& builderState)
    {
        builderState.style().setBorderBottomStyle(forwardInheritedValue(builderState.parentStyle().borderBottomStyle()));
    }
    static void applyValueBorderBottomStyle(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderBottomStyle(fromCSSValueDeducingType(value));
    }
    static void applyInitialBorderBottomWidth(BuilderState& builderState)
    {
        builderState.style().setBorderBottomWidth(RenderStyle::initialBorderWidth());
    }
    static void applyInheritBorderBottomWidth(BuilderState& builderState)
    {
        builderState.style().setBorderBottomWidth(forwardInheritedValue(builderState.parentStyle().borderBottomWidth()));
    }
    static void applyValueBorderBottomWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderBottomWidth(BuilderConverter::convertLineWidth<float>(builderState, value));
    }
    static void applyInitialBorderLeftColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderLeftColor(StyleColor::currentColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderLeftColor(StyleColor::currentColor());
    }
    static void applyInheritBorderLeftColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderLeftColor(builderState.parentStyle().borderLeftColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderLeftColor(builderState.parentStyle().borderLeftColor());
    }
    static void applyValueBorderLeftColor(BuilderState& builderState, CSSValue& value)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderLeftColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::No));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderLeftColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::Yes));
    }
    static void applyInitialBorderLeftStyle(BuilderState& builderState)
    {
        builderState.style().setBorderLeftStyle(RenderStyle::initialBorderStyle());
    }
    static void applyInheritBorderLeftStyle(BuilderState& builderState)
    {
        builderState.style().setBorderLeftStyle(forwardInheritedValue(builderState.parentStyle().borderLeftStyle()));
    }
    static void applyValueBorderLeftStyle(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderLeftStyle(fromCSSValueDeducingType(value));
    }
    static void applyInitialBorderLeftWidth(BuilderState& builderState)
    {
        builderState.style().setBorderLeftWidth(RenderStyle::initialBorderWidth());
    }
    static void applyInheritBorderLeftWidth(BuilderState& builderState)
    {
        builderState.style().setBorderLeftWidth(forwardInheritedValue(builderState.parentStyle().borderLeftWidth()));
    }
    static void applyValueBorderLeftWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderLeftWidth(BuilderConverter::convertLineWidth<float>(builderState, value));
    }
    static void applyInitialBorderRightColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderRightColor(StyleColor::currentColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderRightColor(StyleColor::currentColor());
    }
    static void applyInheritBorderRightColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderRightColor(builderState.parentStyle().borderRightColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderRightColor(builderState.parentStyle().borderRightColor());
    }
    static void applyValueBorderRightColor(BuilderState& builderState, CSSValue& value)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderRightColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::No));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderRightColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::Yes));
    }
    static void applyInitialBorderRightStyle(BuilderState& builderState)
    {
        builderState.style().setBorderRightStyle(RenderStyle::initialBorderStyle());
    }
    static void applyInheritBorderRightStyle(BuilderState& builderState)
    {
        builderState.style().setBorderRightStyle(forwardInheritedValue(builderState.parentStyle().borderRightStyle()));
    }
    static void applyValueBorderRightStyle(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderRightStyle(fromCSSValueDeducingType(value));
    }
    static void applyInitialBorderRightWidth(BuilderState& builderState)
    {
        builderState.style().setBorderRightWidth(RenderStyle::initialBorderWidth());
    }
    static void applyInheritBorderRightWidth(BuilderState& builderState)
    {
        builderState.style().setBorderRightWidth(forwardInheritedValue(builderState.parentStyle().borderRightWidth()));
    }
    static void applyValueBorderRightWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderRightWidth(BuilderConverter::convertLineWidth<float>(builderState, value));
    }
    static void applyInitialBorderTopColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderTopColor(StyleColor::currentColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderTopColor(StyleColor::currentColor());
    }
    static void applyInheritBorderTopColor(BuilderState& builderState)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderTopColor(builderState.parentStyle().borderTopColor());
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderTopColor(builderState.parentStyle().borderTopColor());
    }
    static void applyValueBorderTopColor(BuilderState& builderState, CSSValue& value)
    {
        if (builderState.applyPropertyToRegularStyle())
            builderState.style().setBorderTopColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::No));
        if (builderState.applyPropertyToVisitedLinkStyle())
            builderState.style().setVisitedLinkBorderTopColor(builderState.colorFromPrimitiveValue(fromCSSValueDeducingType(value), ForVisitedLink::Yes));
    }
    static void applyInitialBorderTopStyle(BuilderState& builderState)
    {
        builderState.style().setBorderTopStyle(RenderStyle::initialBorderStyle());
    }
    static void applyInheritBorderTopStyle(BuilderState& builderState)
    {
        builderState.style().setBorderTopStyle(forwardInheritedValue(builderState.parentStyle().borderTopStyle()));
    }
    static void applyValueBorderTopStyle(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderTopStyle(fromCSSValueDeducingType(value));
    }
    static void applyInitialBorderTopWidth(BuilderState& builderState)
    {
        builderState.style().setBorderTopWidth(RenderStyle::initialBorderWidth());
    }
    static void applyInheritBorderTopWidth(BuilderState& builderState)
    {
        builderState.style().setBorderTopWidth(forwardInheritedValue(builderState.parentStyle().borderTopWidth()));
    }
    static void applyValueBorderTopWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBorderTopWidth(BuilderConverter::convertLineWidth<float>(builderState, value));
    }
    static void applyInitialBottom(BuilderState& builderState)
    {
        builderState.style().setBottom(RenderStyle::initialOffset());
    }
    static void applyInheritBottom(BuilderState& builderState)
    {
        builderState.style().setBottom(forwardInheritedValue(builderState.parentStyle().bottom()));
    }
    static void applyValueBottom(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setBottom(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialHeight(BuilderState& builderState)
    {
        builderState.style().setHeight(RenderStyle::initialSize());
    }
    static void applyInheritHeight(BuilderState& builderState)
    {
        builderState.style().setHeight(forwardInheritedValue(builderState.parentStyle().height()));
    }
    static void applyValueHeight(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setHeight(BuilderConverter::convertLengthSizing(builderState, value));
    }
    static void applyInitialLeft(BuilderState& builderState)
    {
        builderState.style().setLeft(RenderStyle::initialOffset());
    }
    static void applyInheritLeft(BuilderState& builderState)
    {
        builderState.style().setLeft(forwardInheritedValue(builderState.parentStyle().left()));
    }
    static void applyValueLeft(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setLeft(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialMarginBottom(BuilderState& builderState)
    {
        builderState.style().setMarginBottom(RenderStyle::initialMargin());
    }
    static void applyInheritMarginBottom(BuilderState& builderState)
    {
        builderState.style().setMarginBottom(forwardInheritedValue(builderState.parentStyle().marginBottom()));
    }
    static void applyValueMarginBottom(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMarginBottom(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialMarginLeft(BuilderState& builderState)
    {
        builderState.style().setMarginLeft(RenderStyle::initialMargin());
    }
    static void applyInheritMarginLeft(BuilderState& builderState)
    {
        builderState.style().setMarginLeft(forwardInheritedValue(builderState.parentStyle().marginLeft()));
    }
    static void applyValueMarginLeft(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMarginLeft(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialMarginRight(BuilderState& builderState)
    {
        builderState.style().setMarginRight(RenderStyle::initialMargin());
    }
    static void applyInheritMarginRight(BuilderState& builderState)
    {
        builderState.style().setMarginRight(forwardInheritedValue(builderState.parentStyle().marginRight()));
    }
    static void applyValueMarginRight(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMarginRight(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialMarginTop(BuilderState& builderState)
    {
        builderState.style().setMarginTop(RenderStyle::initialMargin());
    }
    static void applyInheritMarginTop(BuilderState& builderState)
    {
        builderState.style().setMarginTop(forwardInheritedValue(builderState.parentStyle().marginTop()));
    }
    static void applyValueMarginTop(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMarginTop(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialMaskClip(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().maskLayers();
        if (!layers.next() && (!layers.isClipSet() || layers.clip() == FillLayer::initialFillClip(FillLayerType::Mask)))
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        child->setClip(FillLayer::initialFillClip(FillLayerType::Mask));
        for (child = child->next(); child; child = child->next())
            child->clearClip();
    }
    static void applyInheritMaskClip(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().maskLayers() == builderState.style().maskLayers())
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().maskLayers(); parent && parent->isClipSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                child = previousChild->next();
            }
            child->setClip(parent->clip());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearClip();
    }
    static void applyValueMaskClip(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillClip(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillClip(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearClip();
    }
    static void applyInitialMaskComposite(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().maskLayers();
        if (!layers.next() && (!layers.isCompositeSet() || layers.composite() == FillLayer::initialFillComposite(FillLayerType::Mask)))
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        child->setComposite(FillLayer::initialFillComposite(FillLayerType::Mask));
        for (child = child->next(); child; child = child->next())
            child->clearComposite();
    }
    static void applyInheritMaskComposite(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().maskLayers() == builderState.style().maskLayers())
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().maskLayers(); parent && parent->isCompositeSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                child = previousChild->next();
            }
            child->setComposite(parent->composite());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearComposite();
    }
    static void applyValueMaskComposite(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillComposite(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillComposite(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearComposite();
    }
    static void applyInitialMaskMode(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().maskLayers();
        if (!layers.next() && (!layers.isMaskModeSet() || layers.maskMode() == FillLayer::initialFillMaskMode(FillLayerType::Mask)))
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        child->setMaskMode(FillLayer::initialFillMaskMode(FillLayerType::Mask));
        for (child = child->next(); child; child = child->next())
            child->clearMaskMode();
    }
    static void applyInheritMaskMode(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().maskLayers() == builderState.style().maskLayers())
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().maskLayers(); parent && parent->isMaskModeSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                child = previousChild->next();
            }
            child->setMaskMode(parent->maskMode());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearMaskMode();
    }
    static void applyValueMaskMode(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillMaskMode(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillMaskMode(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearMaskMode();
    }
    static void applyInitialMaxHeight(BuilderState& builderState)
    {
        builderState.style().setMaxHeight(RenderStyle::initialMaxSize());
    }
    static void applyInheritMaxHeight(BuilderState& builderState)
    {
        builderState.style().setMaxHeight(forwardInheritedValue(builderState.parentStyle().maxHeight()));
    }
    static void applyValueMaxHeight(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMaxHeight(BuilderConverter::convertLengthMaxSizing(builderState, value));
    }
    static void applyInitialMaxWidth(BuilderState& builderState)
    {
        builderState.style().setMaxWidth(RenderStyle::initialMaxSize());
    }
    static void applyInheritMaxWidth(BuilderState& builderState)
    {
        builderState.style().setMaxWidth(forwardInheritedValue(builderState.parentStyle().maxWidth()));
    }
    static void applyValueMaxWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMaxWidth(BuilderConverter::convertLengthMaxSizing(builderState, value));
    }
    static void applyInitialMinHeight(BuilderState& builderState)
    {
        builderState.style().setMinHeight(RenderStyle::initialMinSize());
    }
    static void applyInheritMinHeight(BuilderState& builderState)
    {
        builderState.style().setMinHeight(forwardInheritedValue(builderState.parentStyle().minHeight()));
    }
    static void applyValueMinHeight(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMinHeight(BuilderConverter::convertLengthSizing(builderState, value));
    }
    static void applyInitialMinWidth(BuilderState& builderState)
    {
        builderState.style().setMinWidth(RenderStyle::initialMinSize());
    }
    static void applyInheritMinWidth(BuilderState& builderState)
    {
        builderState.style().setMinWidth(forwardInheritedValue(builderState.parentStyle().minWidth()));
    }
    static void applyValueMinWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setMinWidth(BuilderConverter::convertLengthSizing(builderState, value));
    }
    static void applyInitialOverscrollBehaviorX(BuilderState& builderState)
    {
        builderState.style().setOverscrollBehaviorX(RenderStyle::initialOverscrollBehaviorX());
    }
    static void applyInheritOverscrollBehaviorX(BuilderState& builderState)
    {
        builderState.style().setOverscrollBehaviorX(forwardInheritedValue(builderState.parentStyle().overscrollBehaviorX()));
    }
    static void applyValueOverscrollBehaviorX(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOverscrollBehaviorX(fromCSSValueDeducingType(value));
    }
    static void applyInitialOverscrollBehaviorY(BuilderState& builderState)
    {
        builderState.style().setOverscrollBehaviorY(RenderStyle::initialOverscrollBehaviorY());
    }
    static void applyInheritOverscrollBehaviorY(BuilderState& builderState)
    {
        builderState.style().setOverscrollBehaviorY(forwardInheritedValue(builderState.parentStyle().overscrollBehaviorY()));
    }
    static void applyValueOverscrollBehaviorY(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setOverscrollBehaviorY(fromCSSValueDeducingType(value));
    }
    static void applyInitialPaddingBottom(BuilderState& builderState)
    {
        builderState.style().setPaddingBottom(RenderStyle::initialPadding());
    }
    static void applyInheritPaddingBottom(BuilderState& builderState)
    {
        builderState.style().setPaddingBottom(forwardInheritedValue(builderState.parentStyle().paddingBottom()));
    }
    static void applyValuePaddingBottom(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setPaddingBottom(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialPaddingLeft(BuilderState& builderState)
    {
        builderState.style().setPaddingLeft(RenderStyle::initialPadding());
    }
    static void applyInheritPaddingLeft(BuilderState& builderState)
    {
        builderState.style().setPaddingLeft(forwardInheritedValue(builderState.parentStyle().paddingLeft()));
    }
    static void applyValuePaddingLeft(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setPaddingLeft(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialPaddingRight(BuilderState& builderState)
    {
        builderState.style().setPaddingRight(RenderStyle::initialPadding());
    }
    static void applyInheritPaddingRight(BuilderState& builderState)
    {
        builderState.style().setPaddingRight(forwardInheritedValue(builderState.parentStyle().paddingRight()));
    }
    static void applyValuePaddingRight(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setPaddingRight(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialPaddingTop(BuilderState& builderState)
    {
        builderState.style().setPaddingTop(RenderStyle::initialPadding());
    }
    static void applyInheritPaddingTop(BuilderState& builderState)
    {
        builderState.style().setPaddingTop(forwardInheritedValue(builderState.parentStyle().paddingTop()));
    }
    static void applyValuePaddingTop(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setPaddingTop(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialRight(BuilderState& builderState)
    {
        builderState.style().setRight(RenderStyle::initialOffset());
    }
    static void applyInheritRight(BuilderState& builderState)
    {
        builderState.style().setRight(forwardInheritedValue(builderState.parentStyle().right()));
    }
    static void applyValueRight(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setRight(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialScrollMarginBottom(BuilderState& builderState)
    {
        builderState.style().setScrollMarginBottom(RenderStyle::initialScrollMargin());
    }
    static void applyInheritScrollMarginBottom(BuilderState& builderState)
    {
        builderState.style().setScrollMarginBottom(forwardInheritedValue(builderState.parentStyle().scrollMarginBottom()));
    }
    static void applyValueScrollMarginBottom(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollMarginBottom(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialScrollMarginLeft(BuilderState& builderState)
    {
        builderState.style().setScrollMarginLeft(RenderStyle::initialScrollMargin());
    }
    static void applyInheritScrollMarginLeft(BuilderState& builderState)
    {
        builderState.style().setScrollMarginLeft(forwardInheritedValue(builderState.parentStyle().scrollMarginLeft()));
    }
    static void applyValueScrollMarginLeft(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollMarginLeft(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialScrollMarginRight(BuilderState& builderState)
    {
        builderState.style().setScrollMarginRight(RenderStyle::initialScrollMargin());
    }
    static void applyInheritScrollMarginRight(BuilderState& builderState)
    {
        builderState.style().setScrollMarginRight(forwardInheritedValue(builderState.parentStyle().scrollMarginRight()));
    }
    static void applyValueScrollMarginRight(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollMarginRight(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialScrollMarginTop(BuilderState& builderState)
    {
        builderState.style().setScrollMarginTop(RenderStyle::initialScrollMargin());
    }
    static void applyInheritScrollMarginTop(BuilderState& builderState)
    {
        builderState.style().setScrollMarginTop(forwardInheritedValue(builderState.parentStyle().scrollMarginTop()));
    }
    static void applyValueScrollMarginTop(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollMarginTop(BuilderConverter::convertLength(builderState, value));
    }
    static void applyInitialScrollPaddingBottom(BuilderState& builderState)
    {
        builderState.style().setScrollPaddingBottom(RenderStyle::initialScrollPadding());
    }
    static void applyInheritScrollPaddingBottom(BuilderState& builderState)
    {
        builderState.style().setScrollPaddingBottom(forwardInheritedValue(builderState.parentStyle().scrollPaddingBottom()));
    }
    static void applyValueScrollPaddingBottom(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollPaddingBottom(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialScrollPaddingLeft(BuilderState& builderState)
    {
        builderState.style().setScrollPaddingLeft(RenderStyle::initialScrollPadding());
    }
    static void applyInheritScrollPaddingLeft(BuilderState& builderState)
    {
        builderState.style().setScrollPaddingLeft(forwardInheritedValue(builderState.parentStyle().scrollPaddingLeft()));
    }
    static void applyValueScrollPaddingLeft(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollPaddingLeft(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialScrollPaddingRight(BuilderState& builderState)
    {
        builderState.style().setScrollPaddingRight(RenderStyle::initialScrollPadding());
    }
    static void applyInheritScrollPaddingRight(BuilderState& builderState)
    {
        builderState.style().setScrollPaddingRight(forwardInheritedValue(builderState.parentStyle().scrollPaddingRight()));
    }
    static void applyValueScrollPaddingRight(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollPaddingRight(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialScrollPaddingTop(BuilderState& builderState)
    {
        builderState.style().setScrollPaddingTop(RenderStyle::initialScrollPadding());
    }
    static void applyInheritScrollPaddingTop(BuilderState& builderState)
    {
        builderState.style().setScrollPaddingTop(forwardInheritedValue(builderState.parentStyle().scrollPaddingTop()));
    }
    static void applyValueScrollPaddingTop(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setScrollPaddingTop(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialTextCombineUpright(BuilderState& builderState)
    {
        builderState.style().setTextCombine(RenderStyle::initialTextCombine());
    }
    static void applyInheritTextCombineUpright(BuilderState& builderState)
    {
        builderState.style().setTextCombine(forwardInheritedValue(builderState.parentStyle().textCombine()));
    }
    static void applyValueTextCombineUpright(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextCombine(fromCSSValueDeducingType(value));
    }
    static void applyInitialTop(BuilderState& builderState)
    {
        builderState.style().setTop(RenderStyle::initialOffset());
    }
    static void applyInheritTop(BuilderState& builderState)
    {
        builderState.style().setTop(forwardInheritedValue(builderState.parentStyle().top()));
    }
    static void applyValueTop(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTop(BuilderConverter::convertLengthOrAuto(builderState, value));
    }
    static void applyInitialWidth(BuilderState& builderState)
    {
        builderState.style().setWidth(RenderStyle::initialSize());
    }
    static void applyInheritWidth(BuilderState& builderState)
    {
        builderState.style().setWidth(forwardInheritedValue(builderState.parentStyle().width()));
    }
    static void applyValueWidth(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setWidth(BuilderConverter::convertLengthSizing(builderState, value));
    }
    static void applyInitialWebkitBackdropFilter(BuilderState& builderState)
    {
        builderState.style().setBackdropFilter(RenderStyle::initialBackdropFilter());
    }
    static void applyInheritWebkitBackdropFilter(BuilderState& builderState)
    {
        builderState.style().setBackdropFilter(forwardInheritedValue(builderState.parentStyle().backdropFilter()));
    }
    static void applyValueWebkitBackdropFilter(BuilderState& builderState, CSSValue& value)
    {
        auto convertedValue = BuilderConverter::convertFilterOperations(builderState, value);
        if (convertedValue)
            builderState.style().setBackdropFilter(WTFMove(convertedValue.value()));
    }
    static void applyInitialWebkitBackgroundClip(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isClipSet() || layers.clip() == FillLayer::initialFillClip(FillLayerType::Background)))
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setClip(FillLayer::initialFillClip(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearClip();
    }
    static void applyInheritWebkitBackgroundClip(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isClipSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setClip(parent->clip());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearClip();
    }
    static void applyValueWebkitBackgroundClip(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillClip(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillClip(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearClip();
    }
    static void applyInitialWebkitBackgroundOrigin(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().backgroundLayers();
        if (!layers.next() && (!layers.isOriginSet() || layers.origin() == FillLayer::initialFillOrigin(FillLayerType::Background)))
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        child->setOrigin(FillLayer::initialFillOrigin(FillLayerType::Background));
        for (child = child->next(); child; child = child->next())
            child->clearOrigin();
    }
    static void applyInheritWebkitBackgroundOrigin(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().backgroundLayers() == builderState.style().backgroundLayers())
            return;
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().backgroundLayers(); parent && parent->isOriginSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Background));
                child = previousChild->next();
            }
            child->setOrigin(parent->origin());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearOrigin();
    }
    static void applyValueWebkitBackgroundOrigin(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Background));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillOrigin(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillOrigin(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearOrigin();
    }
    static void applyInitialWebkitMaskClip(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().maskLayers();
        if (!layers.next() && (!layers.isClipSet() || layers.clip() == FillLayer::initialFillClip(FillLayerType::Mask)))
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        child->setClip(FillLayer::initialFillClip(FillLayerType::Mask));
        for (child = child->next(); child; child = child->next())
            child->clearClip();
    }
    static void applyInheritWebkitMaskClip(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().maskLayers() == builderState.style().maskLayers())
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().maskLayers(); parent && parent->isClipSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                child = previousChild->next();
            }
            child->setClip(parent->clip());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearClip();
    }
    static void applyValueWebkitMaskClip(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillClip(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillClip(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearClip();
    }
    static void applyInitialWebkitMaskComposite(BuilderState& builderState)
    {
        // Check for (single-layer) no-op before clearing anything.
        auto& layers = builderState.style().maskLayers();
        if (!layers.next() && (!layers.isCompositeSet() || layers.composite() == FillLayer::initialFillComposite(FillLayerType::Mask)))
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        child->setComposite(FillLayer::initialFillComposite(FillLayerType::Mask));
        for (child = child->next(); child; child = child->next())
            child->clearComposite();
    }
    static void applyInheritWebkitMaskComposite(BuilderState& builderState)
    {
        // Check for no-op before copying anything.
        if (builderState.parentStyle().maskLayers() == builderState.style().maskLayers())
            return;
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = &builderState.parentStyle().maskLayers(); parent && parent->isCompositeSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                child = previousChild->next();
            }
            child->setComposite(parent->composite());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearComposite();
    }
    static void applyValueWebkitMaskComposite(CSSPropertyID id, BuilderState& builderState, CSSValue& value)
    {
        auto* child = &builderState.style().ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (auto* valueList = dynamicDowncast<CSSValueList>(value)) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : *valueList) {
                if (!child) {
                    previousChild->setNext(FillLayer::create(FillLayerType::Mask));
                    child = previousChild->next();
                }
                builderState.styleMap().mapFillComposite(id, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            builderState.styleMap().mapFillComposite(id, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearComposite();
    }
    static void applyInitialWebkitTextCombine(BuilderState& builderState)
    {
        builderState.style().setTextCombine(RenderStyle::initialTextCombine());
    }
    static void applyInheritWebkitTextCombine(BuilderState& builderState)
    {
        builderState.style().setTextCombine(forwardInheritedValue(builderState.parentStyle().textCombine()));
    }
    static void applyValueWebkitTextCombine(BuilderState& builderState, CSSValue& value)
    {
        builderState.style().setTextCombine(fromCSSValueDeducingType(value));
    }
};

void BuilderGenerated::applyProperty(CSSPropertyID id, BuilderState& builderState, CSSValue& value, bool isInitial, bool isInherit, const CSSRegisteredCustomProperty* registered)
{
    switch (id) {
    case CSSPropertyID::CSSPropertyInvalid:
        break;
    case CSSPropertyID::CSSPropertyCustom:
        if (isInitial)
            BuilderCustom::applyInitialCustomProperty(builderState, registered, downcast<CSSCustomPropertyValue>(value).name());
        else if (isInherit)
            BuilderCustom::applyInheritCustomProperty(builderState, registered, downcast<CSSCustomPropertyValue>(value).name());
        else
            BuilderCustom::applyValueCustomProperty(builderState, registered, downcast<CSSCustomPropertyValue>(value));
        break;
    case CSSPropertyID::CSSPropertyColorScheme:
        if (isInitial)
            BuilderFunctions::applyInitialColorScheme(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritColorScheme(builderState);
        else
            BuilderCustom::applyValueColorScheme(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWritingMode:
        if (isInitial)
            BuilderFunctions::applyInitialWritingMode(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWritingMode(builderState);
        else
            BuilderCustom::applyValueWritingMode(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitRubyPosition:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitRubyPosition(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitRubyPosition(builderState);
        else
            BuilderFunctions::applyValueWebkitRubyPosition(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyColor:
        if (isInitial)
            BuilderCustom::applyInitialColor(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritColor(builderState);
        else
            BuilderCustom::applyValueColor(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyDirection:
        if (isInitial)
            BuilderFunctions::applyInitialDirection(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritDirection(builderState);
        else
            BuilderCustom::applyValueDirection(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyDisplay:
        if (isInitial)
            BuilderFunctions::applyInitialDisplay(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritDisplay(builderState);
        else
            BuilderFunctions::applyValueDisplay(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFontFamily:
        if (isInitial)
            BuilderCustom::applyInitialFontFamily(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritFontFamily(builderState);
        else
            BuilderCustom::applyValueFontFamily(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFontFeatureSettings:
        if (isInitial)
            BuilderCustom::applyInitialFontFeatureSettings(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritFontFeatureSettings(builderState);
        else
            BuilderFunctions::applyValueFontFeatureSettings(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFontKerning:
        if (isInitial)
            BuilderFunctions::applyInitialFontKerning(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFontKerning(builderState);
        else
            BuilderFunctions::applyValueFontKerning(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFontOpticalSizing:
        if (isInitial)
            BuilderFunctions::applyInitialFontOpticalSizing(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFontOpticalSizing(builderState);
        else
            BuilderFunctions::applyValueFontOpticalSizing(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFontPalette:
        if (isInitial)
            BuilderFunctions::applyInitialFontPalette(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFontPalette(builderState);
        else
            BuilderFunctions::applyValueFontPalette(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFontSize:
        if (isInitial)
            BuilderCustom::applyInitialFontSize(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritFontSize(builderState);
        else
            BuilderCustom::applyValueFontSize(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFontSizeAdjust:
        if (isInitial)
            BuilderFunctions::applyInitialFontSizeAdjust(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFontSizeAdjust(builderState);
        else
            BuilderCustom::applyValueFontSizeAdjust(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFontStretch:
        if (isInitial)
            BuilderFunctions::applyInitialFontStretch(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFontStretch(builderState);
        else
            BuilderFunctions::applyValueFontStretch(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFontStyle:
        if (isInitial)
            BuilderCustom::applyInitialFontStyle(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritFontStyle(builderState);
        else
            BuilderCustom::applyValueFontStyle(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFontSynthesisSmallCaps:
        if (isInitial)
            BuilderFunctions::applyInitialFontSynthesisSmallCaps(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFontSynthesisSmallCaps(builderState);
        else
            BuilderFunctions::applyValueFontSynthesisSmallCaps(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFontSynthesisStyle:
        if (isInitial)
            BuilderFunctions::applyInitialFontSynthesisStyle(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFontSynthesisStyle(builderState);
        else
            BuilderFunctions::applyValueFontSynthesisStyle(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFontSynthesisWeight:
        if (isInitial)
            BuilderFunctions::applyInitialFontSynthesisWeight(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFontSynthesisWeight(builderState);
        else
            BuilderFunctions::applyValueFontSynthesisWeight(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFontVariantAlternates:
        if (isInitial)
            BuilderCustom::applyInitialFontVariantAlternates(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritFontVariantAlternates(builderState);
        else
            BuilderCustom::applyValueFontVariantAlternates(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFontVariantCaps:
        if (isInitial)
            BuilderFunctions::applyInitialFontVariantCaps(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFontVariantCaps(builderState);
        else
            BuilderFunctions::applyValueFontVariantCaps(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFontVariantEastAsian:
        if (isInitial)
            BuilderCustom::applyInitialFontVariantEastAsian(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritFontVariantEastAsian(builderState);
        else
            BuilderCustom::applyValueFontVariantEastAsian(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFontVariantEmoji:
        if (isInitial)
            BuilderFunctions::applyInitialFontVariantEmoji(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFontVariantEmoji(builderState);
        else
            BuilderFunctions::applyValueFontVariantEmoji(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFontVariantLigatures:
        if (isInitial)
            BuilderCustom::applyInitialFontVariantLigatures(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritFontVariantLigatures(builderState);
        else
            BuilderCustom::applyValueFontVariantLigatures(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFontVariantNumeric:
        if (isInitial)
            BuilderCustom::applyInitialFontVariantNumeric(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritFontVariantNumeric(builderState);
        else
            BuilderCustom::applyValueFontVariantNumeric(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFontVariantPosition:
        if (isInitial)
            BuilderFunctions::applyInitialFontVariantPosition(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFontVariantPosition(builderState);
        else
            BuilderFunctions::applyValueFontVariantPosition(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFontVariationSettings:
        if (isInitial)
            BuilderCustom::applyInitialFontVariationSettings(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritFontVariationSettings(builderState);
        else
            BuilderFunctions::applyValueFontVariationSettings(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFontWeight:
        if (isInitial)
            BuilderFunctions::applyInitialFontWeight(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFontWeight(builderState);
        else
            BuilderFunctions::applyValueFontWeight(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTextOrientation:
        if (isInitial)
            BuilderFunctions::applyInitialTextOrientation(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextOrientation(builderState);
        else
            BuilderCustom::applyValueTextOrientation(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTextRendering:
        if (isInitial)
            BuilderFunctions::applyInitialTextRendering(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextRendering(builderState);
        else
            BuilderFunctions::applyValueTextRendering(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyZoom:
        if (isInitial)
            BuilderCustom::applyInitialZoom(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritZoom(builderState);
        else
            BuilderCustom::applyValueZoom(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitFontSmoothing:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitFontSmoothing(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitFontSmoothing(builderState);
        else
            BuilderFunctions::applyValueWebkitFontSmoothing(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitLocale:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitLocale(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitLocale(builderState);
        else
            BuilderCustom::applyValueWebkitLocale(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitTextZoom:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitTextZoom(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitTextZoom(builderState);
        else
            BuilderCustom::applyValueWebkitTextZoom(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyLetterSpacing:
        if (isInitial)
            BuilderCustom::applyInitialLetterSpacing(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritLetterSpacing(builderState);
        else
            BuilderCustom::applyValueLetterSpacing(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTextAutospace:
        if (isInitial)
            BuilderFunctions::applyInitialTextAutospace(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextAutospace(builderState);
        else
            BuilderFunctions::applyValueTextAutospace(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTextSpacingTrim:
        if (isInitial)
            BuilderFunctions::applyInitialTextSpacingTrim(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextSpacingTrim(builderState);
        else
            BuilderFunctions::applyValueTextSpacingTrim(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyAccentColor:
        if (isInitial)
            BuilderFunctions::applyInitialAccentColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritAccentColor(builderState);
        else
            BuilderFunctions::applyValueAccentColor(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyAdditiveSymbols:
        break;
    case CSSPropertyID::CSSPropertyAlignContent:
        if (isInitial)
            BuilderFunctions::applyInitialAlignContent(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritAlignContent(builderState);
        else
            BuilderFunctions::applyValueAlignContent(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyAlignItems:
        if (isInitial)
            BuilderFunctions::applyInitialAlignItems(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritAlignItems(builderState);
        else
            BuilderFunctions::applyValueAlignItems(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyAlignSelf:
        if (isInitial)
            BuilderFunctions::applyInitialAlignSelf(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritAlignSelf(builderState);
        else
            BuilderFunctions::applyValueAlignSelf(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyAlignmentBaseline:
        if (isInitial)
            BuilderFunctions::applyInitialAlignmentBaseline(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritAlignmentBaseline(builderState);
        else
            BuilderFunctions::applyValueAlignmentBaseline(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyAnimationComposition:
        if (isInitial)
            BuilderFunctions::applyInitialAnimationComposition(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritAnimationComposition(builderState);
        else
            BuilderFunctions::applyValueAnimationComposition(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyAnimationDelay:
        if (isInitial)
            BuilderFunctions::applyInitialAnimationDelay(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritAnimationDelay(builderState);
        else
            BuilderFunctions::applyValueAnimationDelay(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyAnimationDirection:
        if (isInitial)
            BuilderFunctions::applyInitialAnimationDirection(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritAnimationDirection(builderState);
        else
            BuilderFunctions::applyValueAnimationDirection(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyAnimationDuration:
        if (isInitial)
            BuilderFunctions::applyInitialAnimationDuration(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritAnimationDuration(builderState);
        else
            BuilderFunctions::applyValueAnimationDuration(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyAnimationFillMode:
        if (isInitial)
            BuilderFunctions::applyInitialAnimationFillMode(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritAnimationFillMode(builderState);
        else
            BuilderFunctions::applyValueAnimationFillMode(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyAnimationIterationCount:
        if (isInitial)
            BuilderFunctions::applyInitialAnimationIterationCount(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritAnimationIterationCount(builderState);
        else
            BuilderFunctions::applyValueAnimationIterationCount(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyAnimationName:
        if (isInitial)
            BuilderFunctions::applyInitialAnimationName(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritAnimationName(builderState);
        else
            BuilderFunctions::applyValueAnimationName(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyAnimationPlayState:
        if (isInitial)
            BuilderFunctions::applyInitialAnimationPlayState(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritAnimationPlayState(builderState);
        else
            BuilderFunctions::applyValueAnimationPlayState(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyAnimationTimeline:
        if (isInitial)
            BuilderFunctions::applyInitialAnimationTimeline(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritAnimationTimeline(builderState);
        else
            BuilderFunctions::applyValueAnimationTimeline(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyAnimationTimingFunction:
        if (isInitial)
            BuilderFunctions::applyInitialAnimationTimingFunction(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritAnimationTimingFunction(builderState);
        else
            BuilderFunctions::applyValueAnimationTimingFunction(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyAppearance:
        if (isInitial)
            BuilderFunctions::applyInitialAppearance(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritAppearance(builderState);
        else
            BuilderFunctions::applyValueAppearance(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyAspectRatio:
        if (isInitial)
            BuilderCustom::applyInitialAspectRatio(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritAspectRatio(builderState);
        else
            BuilderCustom::applyValueAspectRatio(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBackfaceVisibility:
        if (isInitial)
            BuilderFunctions::applyInitialBackfaceVisibility(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBackfaceVisibility(builderState);
        else
            BuilderFunctions::applyValueBackfaceVisibility(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBackgroundAttachment:
        if (isInitial)
            BuilderFunctions::applyInitialBackgroundAttachment(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBackgroundAttachment(builderState);
        else
            BuilderFunctions::applyValueBackgroundAttachment(id, builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBackgroundBlendMode:
        if (isInitial)
            BuilderFunctions::applyInitialBackgroundBlendMode(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBackgroundBlendMode(builderState);
        else
            BuilderFunctions::applyValueBackgroundBlendMode(id, builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBackgroundColor:
        if (isInitial)
            BuilderFunctions::applyInitialBackgroundColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBackgroundColor(builderState);
        else
            BuilderFunctions::applyValueBackgroundColor(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBackgroundImage:
        if (isInitial)
            BuilderFunctions::applyInitialBackgroundImage(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBackgroundImage(builderState);
        else
            BuilderFunctions::applyValueBackgroundImage(id, builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBackgroundPositionX:
        if (isInitial)
            BuilderFunctions::applyInitialBackgroundPositionX(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBackgroundPositionX(builderState);
        else
            BuilderFunctions::applyValueBackgroundPositionX(id, builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBackgroundPositionY:
        if (isInitial)
            BuilderFunctions::applyInitialBackgroundPositionY(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBackgroundPositionY(builderState);
        else
            BuilderFunctions::applyValueBackgroundPositionY(id, builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBackgroundRepeat:
        if (isInitial)
            BuilderFunctions::applyInitialBackgroundRepeat(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBackgroundRepeat(builderState);
        else
            BuilderFunctions::applyValueBackgroundRepeat(id, builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBackgroundSize:
        if (isInitial)
            BuilderFunctions::applyInitialBackgroundSize(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBackgroundSize(builderState);
        else
            BuilderFunctions::applyValueBackgroundSize(id, builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBasePalette:
        break;
    case CSSPropertyID::CSSPropertyBaselineShift:
        if (isInitial)
            BuilderFunctions::applyInitialBaselineShift(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritBaselineShift(builderState);
        else
            BuilderCustom::applyValueBaselineShift(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBlockStepInsert:
        if (isInitial)
            BuilderFunctions::applyInitialBlockStepInsert(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBlockStepInsert(builderState);
        else
            BuilderFunctions::applyValueBlockStepInsert(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBlockStepSize:
        if (isInitial)
            BuilderFunctions::applyInitialBlockStepSize(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBlockStepSize(builderState);
        else
            BuilderFunctions::applyValueBlockStepSize(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBorderCollapse:
        if (isInitial)
            BuilderFunctions::applyInitialBorderCollapse(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderCollapse(builderState);
        else
            BuilderFunctions::applyValueBorderCollapse(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBorderImageOutset:
        if (isInitial)
            BuilderCustom::applyInitialBorderImageOutset(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritBorderImageOutset(builderState);
        else
            BuilderCustom::applyValueBorderImageOutset(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBorderImageRepeat:
        if (isInitial)
            BuilderCustom::applyInitialBorderImageRepeat(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritBorderImageRepeat(builderState);
        else
            BuilderCustom::applyValueBorderImageRepeat(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBorderImageSlice:
        if (isInitial)
            BuilderCustom::applyInitialBorderImageSlice(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritBorderImageSlice(builderState);
        else
            BuilderCustom::applyValueBorderImageSlice(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBorderImageSource:
        if (isInitial)
            BuilderFunctions::applyInitialBorderImageSource(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderImageSource(builderState);
        else
            BuilderFunctions::applyValueBorderImageSource(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBorderImageWidth:
        if (isInitial)
            BuilderCustom::applyInitialBorderImageWidth(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritBorderImageWidth(builderState);
        else
            BuilderCustom::applyValueBorderImageWidth(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBoxSizing:
        if (isInitial)
            BuilderFunctions::applyInitialBoxSizing(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBoxSizing(builderState);
        else
            BuilderFunctions::applyValueBoxSizing(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBreakAfter:
        if (isInitial)
            BuilderFunctions::applyInitialBreakAfter(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBreakAfter(builderState);
        else
            BuilderFunctions::applyValueBreakAfter(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBreakBefore:
        if (isInitial)
            BuilderFunctions::applyInitialBreakBefore(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBreakBefore(builderState);
        else
            BuilderFunctions::applyValueBreakBefore(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBreakInside:
        if (isInitial)
            BuilderFunctions::applyInitialBreakInside(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBreakInside(builderState);
        else
            BuilderFunctions::applyValueBreakInside(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBufferedRendering:
        if (isInitial)
            BuilderFunctions::applyInitialBufferedRendering(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBufferedRendering(builderState);
        else
            BuilderFunctions::applyValueBufferedRendering(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyCaptionSide:
        if (isInitial)
            BuilderFunctions::applyInitialCaptionSide(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritCaptionSide(builderState);
        else
            BuilderFunctions::applyValueCaptionSide(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyCaretColor:
        if (isInitial)
            BuilderCustom::applyInitialCaretColor(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritCaretColor(builderState);
        else
            BuilderCustom::applyValueCaretColor(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyClear:
        if (isInitial)
            BuilderFunctions::applyInitialClear(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritClear(builderState);
        else
            BuilderFunctions::applyValueClear(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyClip:
        if (isInitial)
            BuilderCustom::applyInitialClip(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritClip(builderState);
        else
            BuilderCustom::applyValueClip(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyClipPath:
        if (isInitial)
            BuilderFunctions::applyInitialClipPath(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritClipPath(builderState);
        else
            BuilderFunctions::applyValueClipPath(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyClipRule:
        if (isInitial)
            BuilderFunctions::applyInitialClipRule(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritClipRule(builderState);
        else
            BuilderFunctions::applyValueClipRule(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyColorInterpolation:
        if (isInitial)
            BuilderFunctions::applyInitialColorInterpolation(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritColorInterpolation(builderState);
        else
            BuilderFunctions::applyValueColorInterpolation(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyColorInterpolationFilters:
        if (isInitial)
            BuilderFunctions::applyInitialColorInterpolationFilters(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritColorInterpolationFilters(builderState);
        else
            BuilderFunctions::applyValueColorInterpolationFilters(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyColumnCount:
        if (isInitial)
            BuilderFunctions::applyInitialColumnCount(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritColumnCount(builderState);
        else
            BuilderFunctions::applyValueColumnCount(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyColumnFill:
        if (isInitial)
            BuilderFunctions::applyInitialColumnFill(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritColumnFill(builderState);
        else
            BuilderFunctions::applyValueColumnFill(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyColumnGap:
        if (isInitial)
            BuilderFunctions::applyInitialColumnGap(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritColumnGap(builderState);
        else
            BuilderFunctions::applyValueColumnGap(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyColumnRuleColor:
        if (isInitial)
            BuilderFunctions::applyInitialColumnRuleColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritColumnRuleColor(builderState);
        else
            BuilderFunctions::applyValueColumnRuleColor(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyColumnRuleStyle:
        if (isInitial)
            BuilderFunctions::applyInitialColumnRuleStyle(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritColumnRuleStyle(builderState);
        else
            BuilderFunctions::applyValueColumnRuleStyle(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyColumnRuleWidth:
        if (isInitial)
            BuilderFunctions::applyInitialColumnRuleWidth(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritColumnRuleWidth(builderState);
        else
            BuilderFunctions::applyValueColumnRuleWidth(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyColumnSpan:
        if (isInitial)
            BuilderFunctions::applyInitialColumnSpan(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritColumnSpan(builderState);
        else
            BuilderFunctions::applyValueColumnSpan(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyColumnWidth:
        if (isInitial)
            BuilderFunctions::applyInitialColumnWidth(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritColumnWidth(builderState);
        else
            BuilderFunctions::applyValueColumnWidth(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyContain:
        if (isInitial)
            BuilderFunctions::applyInitialContain(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritContain(builderState);
        else
            BuilderFunctions::applyValueContain(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyContainerName:
        if (isInitial)
            BuilderFunctions::applyInitialContainerName(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritContainerName(builderState);
        else
            BuilderFunctions::applyValueContainerName(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyContainerType:
        if (isInitial)
            BuilderFunctions::applyInitialContainerType(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritContainerType(builderState);
        else
            BuilderFunctions::applyValueContainerType(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyContent:
        if (isInitial)
            BuilderCustom::applyInitialContent(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritContent(builderState);
        else
            BuilderCustom::applyValueContent(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyContentVisibility:
        if (isInitial)
            BuilderFunctions::applyInitialContentVisibility(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritContentVisibility(builderState);
        else
            BuilderFunctions::applyValueContentVisibility(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyCounterIncrement:
        if (isInitial)
            BuilderCustom::applyInitialCounterIncrement(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritCounterIncrement(builderState);
        else
            BuilderCustom::applyValueCounterIncrement(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyCounterReset:
        if (isInitial)
            BuilderCustom::applyInitialCounterReset(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritCounterReset(builderState);
        else
            BuilderCustom::applyValueCounterReset(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyCounterSet:
        if (isInitial)
            BuilderCustom::applyInitialCounterSet(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritCounterSet(builderState);
        else
            BuilderCustom::applyValueCounterSet(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyCursor:
        if (isInitial)
            BuilderCustom::applyInitialCursor(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritCursor(builderState);
        else
            BuilderCustom::applyValueCursor(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyCx:
        if (isInitial)
            BuilderFunctions::applyInitialCx(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritCx(builderState);
        else
            BuilderFunctions::applyValueCx(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyCy:
        if (isInitial)
            BuilderFunctions::applyInitialCy(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritCy(builderState);
        else
            BuilderFunctions::applyValueCy(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyDominantBaseline:
        if (isInitial)
            BuilderFunctions::applyInitialDominantBaseline(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritDominantBaseline(builderState);
        else
            BuilderFunctions::applyValueDominantBaseline(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyEmptyCells:
        if (isInitial)
            BuilderFunctions::applyInitialEmptyCells(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritEmptyCells(builderState);
        else
            BuilderFunctions::applyValueEmptyCells(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFallback:
        break;
    case CSSPropertyID::CSSPropertyFill:
        if (isInitial)
            BuilderCustom::applyInitialFill(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritFill(builderState);
        else
            BuilderCustom::applyValueFill(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFillOpacity:
        if (isInitial)
            BuilderFunctions::applyInitialFillOpacity(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFillOpacity(builderState);
        else
            BuilderFunctions::applyValueFillOpacity(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFillRule:
        if (isInitial)
            BuilderFunctions::applyInitialFillRule(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFillRule(builderState);
        else
            BuilderFunctions::applyValueFillRule(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFilter:
        if (isInitial)
            BuilderFunctions::applyInitialFilter(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFilter(builderState);
        else
            BuilderFunctions::applyValueFilter(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFlexBasis:
        if (isInitial)
            BuilderFunctions::applyInitialFlexBasis(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFlexBasis(builderState);
        else
            BuilderFunctions::applyValueFlexBasis(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFlexDirection:
        if (isInitial)
            BuilderFunctions::applyInitialFlexDirection(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFlexDirection(builderState);
        else
            BuilderFunctions::applyValueFlexDirection(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFlexGrow:
        if (isInitial)
            BuilderFunctions::applyInitialFlexGrow(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFlexGrow(builderState);
        else
            BuilderFunctions::applyValueFlexGrow(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFlexShrink:
        if (isInitial)
            BuilderFunctions::applyInitialFlexShrink(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFlexShrink(builderState);
        else
            BuilderFunctions::applyValueFlexShrink(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFlexWrap:
        if (isInitial)
            BuilderFunctions::applyInitialFlexWrap(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFlexWrap(builderState);
        else
            BuilderFunctions::applyValueFlexWrap(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFloat:
        if (isInitial)
            BuilderFunctions::applyInitialFloat(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFloat(builderState);
        else
            BuilderFunctions::applyValueFloat(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFloodColor:
        if (isInitial)
            BuilderFunctions::applyInitialFloodColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFloodColor(builderState);
        else
            BuilderFunctions::applyValueFloodColor(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFloodOpacity:
        if (isInitial)
            BuilderFunctions::applyInitialFloodOpacity(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritFloodOpacity(builderState);
        else
            BuilderFunctions::applyValueFloodOpacity(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyFontDisplay:
        break;
    case CSSPropertyID::CSSPropertyGlyphOrientationHorizontal:
        if (isInitial)
            BuilderFunctions::applyInitialGlyphOrientationHorizontal(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritGlyphOrientationHorizontal(builderState);
        else
            BuilderFunctions::applyValueGlyphOrientationHorizontal(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyGlyphOrientationVertical:
        if (isInitial)
            BuilderFunctions::applyInitialGlyphOrientationVertical(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritGlyphOrientationVertical(builderState);
        else
            BuilderFunctions::applyValueGlyphOrientationVertical(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyGridAutoColumns:
        if (isInitial)
            BuilderFunctions::applyInitialGridAutoColumns(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritGridAutoColumns(builderState);
        else
            BuilderFunctions::applyValueGridAutoColumns(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyGridAutoFlow:
        if (isInitial)
            BuilderFunctions::applyInitialGridAutoFlow(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritGridAutoFlow(builderState);
        else
            BuilderFunctions::applyValueGridAutoFlow(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyGridAutoRows:
        if (isInitial)
            BuilderFunctions::applyInitialGridAutoRows(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritGridAutoRows(builderState);
        else
            BuilderFunctions::applyValueGridAutoRows(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyGridColumnEnd:
        if (isInitial)
            BuilderFunctions::applyInitialGridColumnEnd(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritGridColumnEnd(builderState);
        else
            BuilderFunctions::applyValueGridColumnEnd(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyGridColumnStart:
        if (isInitial)
            BuilderFunctions::applyInitialGridColumnStart(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritGridColumnStart(builderState);
        else
            BuilderFunctions::applyValueGridColumnStart(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyGridRowEnd:
        if (isInitial)
            BuilderFunctions::applyInitialGridRowEnd(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritGridRowEnd(builderState);
        else
            BuilderFunctions::applyValueGridRowEnd(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyGridRowStart:
        if (isInitial)
            BuilderFunctions::applyInitialGridRowStart(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritGridRowStart(builderState);
        else
            BuilderFunctions::applyValueGridRowStart(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyGridTemplateAreas:
        if (isInitial)
            BuilderCustom::applyInitialGridTemplateAreas(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritGridTemplateAreas(builderState);
        else
            BuilderCustom::applyValueGridTemplateAreas(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyGridTemplateColumns:
        if (isInitial)
            BuilderCustom::applyInitialGridTemplateColumns(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritGridTemplateColumns(builderState);
        else
            BuilderCustom::applyValueGridTemplateColumns(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyGridTemplateRows:
        if (isInitial)
            BuilderCustom::applyInitialGridTemplateRows(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritGridTemplateRows(builderState);
        else
            BuilderCustom::applyValueGridTemplateRows(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyHangingPunctuation:
        if (isInitial)
            BuilderFunctions::applyInitialHangingPunctuation(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritHangingPunctuation(builderState);
        else
            BuilderFunctions::applyValueHangingPunctuation(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyHyphenateCharacter:
        if (isInitial)
            BuilderFunctions::applyInitialHyphenateCharacter(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritHyphenateCharacter(builderState);
        else
            BuilderFunctions::applyValueHyphenateCharacter(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyHyphens:
        if (isInitial)
            BuilderFunctions::applyInitialHyphens(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritHyphens(builderState);
        else
            BuilderFunctions::applyValueHyphens(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyImageOrientation:
        if (isInitial)
            BuilderFunctions::applyInitialImageOrientation(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritImageOrientation(builderState);
        else
            BuilderFunctions::applyValueImageOrientation(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyImageRendering:
        if (isInitial)
            BuilderFunctions::applyInitialImageRendering(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritImageRendering(builderState);
        else
            BuilderFunctions::applyValueImageRendering(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyInherits:
        break;
    case CSSPropertyID::CSSPropertyInitialValue:
        break;
    case CSSPropertyID::CSSPropertyInputSecurity:
        if (isInitial)
            BuilderFunctions::applyInitialInputSecurity(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritInputSecurity(builderState);
        else
            BuilderFunctions::applyValueInputSecurity(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyIsolation:
        if (isInitial)
            BuilderFunctions::applyInitialIsolation(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritIsolation(builderState);
        else
            BuilderFunctions::applyValueIsolation(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyJustifyContent:
        if (isInitial)
            BuilderFunctions::applyInitialJustifyContent(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritJustifyContent(builderState);
        else
            BuilderFunctions::applyValueJustifyContent(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyJustifyItems:
        if (isInitial)
            BuilderFunctions::applyInitialJustifyItems(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritJustifyItems(builderState);
        else
            BuilderFunctions::applyValueJustifyItems(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyJustifySelf:
        if (isInitial)
            BuilderFunctions::applyInitialJustifySelf(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritJustifySelf(builderState);
        else
            BuilderFunctions::applyValueJustifySelf(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyKerning:
        if (isInitial)
            BuilderFunctions::applyInitialKerning(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritKerning(builderState);
        else
            BuilderFunctions::applyValueKerning(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyLightingColor:
        if (isInitial)
            BuilderFunctions::applyInitialLightingColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritLightingColor(builderState);
        else
            BuilderFunctions::applyValueLightingColor(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyLineBreak:
        if (isInitial)
            BuilderFunctions::applyInitialLineBreak(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritLineBreak(builderState);
        else
            BuilderFunctions::applyValueLineBreak(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyLineHeight:
        if (isInitial)
            BuilderFunctions::applyInitialLineHeight(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritLineHeight(builderState);
        else
            BuilderFunctions::applyValueLineHeight(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyListStyleImage:
        if (isInitial)
            BuilderFunctions::applyInitialListStyleImage(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritListStyleImage(builderState);
        else
            BuilderFunctions::applyValueListStyleImage(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyListStylePosition:
        if (isInitial)
            BuilderFunctions::applyInitialListStylePosition(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritListStylePosition(builderState);
        else
            BuilderFunctions::applyValueListStylePosition(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyListStyleType:
        if (isInitial)
            BuilderFunctions::applyInitialListStyleType(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritListStyleType(builderState);
        else
            BuilderFunctions::applyValueListStyleType(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyMarginTrim:
        if (isInitial)
            BuilderFunctions::applyInitialMarginTrim(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMarginTrim(builderState);
        else
            BuilderFunctions::applyValueMarginTrim(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyMarkerEnd:
        if (isInitial)
            BuilderFunctions::applyInitialMarkerEnd(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMarkerEnd(builderState);
        else
            BuilderFunctions::applyValueMarkerEnd(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyMarkerMid:
        if (isInitial)
            BuilderFunctions::applyInitialMarkerMid(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMarkerMid(builderState);
        else
            BuilderFunctions::applyValueMarkerMid(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyMarkerStart:
        if (isInitial)
            BuilderFunctions::applyInitialMarkerStart(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMarkerStart(builderState);
        else
            BuilderFunctions::applyValueMarkerStart(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyMaskBorderOutset:
        if (isInitial)
            BuilderCustom::applyInitialMaskBorderOutset(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritMaskBorderOutset(builderState);
        else
            BuilderCustom::applyValueMaskBorderOutset(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyMaskBorderRepeat:
        if (isInitial)
            BuilderCustom::applyInitialMaskBorderRepeat(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritMaskBorderRepeat(builderState);
        else
            BuilderCustom::applyValueMaskBorderRepeat(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyMaskBorderSlice:
        if (isInitial)
            BuilderCustom::applyInitialMaskBorderSlice(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritMaskBorderSlice(builderState);
        else
            BuilderCustom::applyValueMaskBorderSlice(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyMaskBorderSource:
        if (isInitial)
            BuilderFunctions::applyInitialMaskBorderSource(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMaskBorderSource(builderState);
        else
            BuilderFunctions::applyValueMaskBorderSource(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyMaskBorderWidth:
        if (isInitial)
            BuilderCustom::applyInitialMaskBorderWidth(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritMaskBorderWidth(builderState);
        else
            BuilderCustom::applyValueMaskBorderWidth(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyMaskImage:
        if (isInitial)
            BuilderFunctions::applyInitialMaskImage(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMaskImage(builderState);
        else
            BuilderFunctions::applyValueMaskImage(id, builderState, value);
        break;
    case CSSPropertyID::CSSPropertyMaskOrigin:
        if (isInitial)
            BuilderFunctions::applyInitialMaskOrigin(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMaskOrigin(builderState);
        else
            BuilderFunctions::applyValueMaskOrigin(id, builderState, value);
        break;
    case CSSPropertyID::CSSPropertyMaskRepeat:
        if (isInitial)
            BuilderFunctions::applyInitialMaskRepeat(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMaskRepeat(builderState);
        else
            BuilderFunctions::applyValueMaskRepeat(id, builderState, value);
        break;
    case CSSPropertyID::CSSPropertyMaskSize:
        if (isInitial)
            BuilderFunctions::applyInitialMaskSize(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMaskSize(builderState);
        else
            BuilderFunctions::applyValueMaskSize(id, builderState, value);
        break;
    case CSSPropertyID::CSSPropertyMaskType:
        if (isInitial)
            BuilderFunctions::applyInitialMaskType(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMaskType(builderState);
        else
            BuilderFunctions::applyValueMaskType(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyMasonryAutoFlow:
        if (isInitial)
            BuilderFunctions::applyInitialMasonryAutoFlow(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMasonryAutoFlow(builderState);
        else
            BuilderFunctions::applyValueMasonryAutoFlow(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyMathStyle:
        if (isInitial)
            BuilderFunctions::applyInitialMathStyle(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMathStyle(builderState);
        else
            BuilderFunctions::applyValueMathStyle(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyMixBlendMode:
        if (isInitial)
            BuilderFunctions::applyInitialMixBlendMode(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMixBlendMode(builderState);
        else
            BuilderFunctions::applyValueMixBlendMode(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyNegative:
        break;
    case CSSPropertyID::CSSPropertyObjectFit:
        if (isInitial)
            BuilderFunctions::applyInitialObjectFit(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritObjectFit(builderState);
        else
            BuilderFunctions::applyValueObjectFit(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyObjectPosition:
        if (isInitial)
            BuilderFunctions::applyInitialObjectPosition(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritObjectPosition(builderState);
        else
            BuilderFunctions::applyValueObjectPosition(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyOffsetAnchor:
        if (isInitial)
            BuilderFunctions::applyInitialOffsetAnchor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritOffsetAnchor(builderState);
        else
            BuilderFunctions::applyValueOffsetAnchor(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyOffsetDistance:
        if (isInitial)
            BuilderFunctions::applyInitialOffsetDistance(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritOffsetDistance(builderState);
        else
            BuilderFunctions::applyValueOffsetDistance(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyOffsetPath:
        if (isInitial)
            BuilderFunctions::applyInitialOffsetPath(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritOffsetPath(builderState);
        else
            BuilderFunctions::applyValueOffsetPath(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyOffsetPosition:
        if (isInitial)
            BuilderFunctions::applyInitialOffsetPosition(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritOffsetPosition(builderState);
        else
            BuilderFunctions::applyValueOffsetPosition(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyOffsetRotate:
        if (isInitial)
            BuilderFunctions::applyInitialOffsetRotate(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritOffsetRotate(builderState);
        else
            BuilderFunctions::applyValueOffsetRotate(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyOpacity:
        if (isInitial)
            BuilderFunctions::applyInitialOpacity(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritOpacity(builderState);
        else
            BuilderFunctions::applyValueOpacity(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyOrder:
        if (isInitial)
            BuilderFunctions::applyInitialOrder(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritOrder(builderState);
        else
            BuilderFunctions::applyValueOrder(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyOrphans:
        if (isInitial)
            BuilderFunctions::applyInitialOrphans(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritOrphans(builderState);
        else
            BuilderFunctions::applyValueOrphans(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyOutlineColor:
        if (isInitial)
            BuilderFunctions::applyInitialOutlineColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritOutlineColor(builderState);
        else
            BuilderFunctions::applyValueOutlineColor(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyOutlineOffset:
        if (isInitial)
            BuilderFunctions::applyInitialOutlineOffset(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritOutlineOffset(builderState);
        else
            BuilderFunctions::applyValueOutlineOffset(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyOutlineStyle:
        if (isInitial)
            BuilderCustom::applyInitialOutlineStyle(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritOutlineStyle(builderState);
        else
            BuilderCustom::applyValueOutlineStyle(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyOutlineWidth:
        if (isInitial)
            BuilderFunctions::applyInitialOutlineWidth(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritOutlineWidth(builderState);
        else
            BuilderFunctions::applyValueOutlineWidth(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyOverflowAnchor:
        if (isInitial)
            BuilderFunctions::applyInitialOverflowAnchor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritOverflowAnchor(builderState);
        else
            BuilderFunctions::applyValueOverflowAnchor(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyOverflowWrap:
        if (isInitial)
            BuilderFunctions::applyInitialOverflowWrap(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritOverflowWrap(builderState);
        else
            BuilderFunctions::applyValueOverflowWrap(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyOverflowX:
        if (isInitial)
            BuilderFunctions::applyInitialOverflowX(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritOverflowX(builderState);
        else
            BuilderFunctions::applyValueOverflowX(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyOverflowY:
        if (isInitial)
            BuilderFunctions::applyInitialOverflowY(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritOverflowY(builderState);
        else
            BuilderFunctions::applyValueOverflowY(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyOverrideColors:
        break;
    case CSSPropertyID::CSSPropertyPad:
        break;
    case CSSPropertyID::CSSPropertyPage:
        break;
    case CSSPropertyID::CSSPropertyPaintOrder:
        if (isInitial)
            BuilderFunctions::applyInitialPaintOrder(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritPaintOrder(builderState);
        else
            BuilderFunctions::applyValuePaintOrder(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyPerspective:
        if (isInitial)
            BuilderFunctions::applyInitialPerspective(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritPerspective(builderState);
        else
            BuilderFunctions::applyValuePerspective(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyPerspectiveOriginX:
        if (isInitial)
            BuilderFunctions::applyInitialPerspectiveOriginX(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritPerspectiveOriginX(builderState);
        else
            BuilderFunctions::applyValuePerspectiveOriginX(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyPerspectiveOriginY:
        if (isInitial)
            BuilderFunctions::applyInitialPerspectiveOriginY(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritPerspectiveOriginY(builderState);
        else
            BuilderFunctions::applyValuePerspectiveOriginY(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyPointerEvents:
        if (isInitial)
            BuilderFunctions::applyInitialPointerEvents(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritPointerEvents(builderState);
        else
            BuilderFunctions::applyValuePointerEvents(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyPosition:
        if (isInitial)
            BuilderFunctions::applyInitialPosition(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritPosition(builderState);
        else
            BuilderFunctions::applyValuePosition(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyPrefix:
        break;
    case CSSPropertyID::CSSPropertyPrintColorAdjust:
        if (isInitial)
            BuilderFunctions::applyInitialPrintColorAdjust(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritPrintColorAdjust(builderState);
        else
            BuilderFunctions::applyValuePrintColorAdjust(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyQuotes:
        if (isInitial)
            BuilderFunctions::applyInitialQuotes(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritQuotes(builderState);
        else
            BuilderFunctions::applyValueQuotes(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyR:
        if (isInitial)
            BuilderFunctions::applyInitialR(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritR(builderState);
        else
            BuilderFunctions::applyValueR(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyRange:
        break;
    case CSSPropertyID::CSSPropertyResize:
        if (isInitial)
            BuilderFunctions::applyInitialResize(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritResize(builderState);
        else
            BuilderFunctions::applyValueResize(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyRotate:
        if (isInitial)
            BuilderFunctions::applyInitialRotate(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritRotate(builderState);
        else
            BuilderFunctions::applyValueRotate(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyRowGap:
        if (isInitial)
            BuilderFunctions::applyInitialRowGap(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritRowGap(builderState);
        else
            BuilderFunctions::applyValueRowGap(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyRx:
        if (isInitial)
            BuilderFunctions::applyInitialRx(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritRx(builderState);
        else
            BuilderFunctions::applyValueRx(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyRy:
        if (isInitial)
            BuilderFunctions::applyInitialRy(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritRy(builderState);
        else
            BuilderFunctions::applyValueRy(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyScale:
        if (isInitial)
            BuilderFunctions::applyInitialScale(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritScale(builderState);
        else
            BuilderFunctions::applyValueScale(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyScrollBehavior:
        if (isInitial)
            BuilderFunctions::applyInitialScrollBehavior(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritScrollBehavior(builderState);
        else
            BuilderFunctions::applyValueScrollBehavior(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyScrollSnapAlign:
        if (isInitial)
            BuilderFunctions::applyInitialScrollSnapAlign(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritScrollSnapAlign(builderState);
        else
            BuilderFunctions::applyValueScrollSnapAlign(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyScrollSnapStop:
        if (isInitial)
            BuilderFunctions::applyInitialScrollSnapStop(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritScrollSnapStop(builderState);
        else
            BuilderFunctions::applyValueScrollSnapStop(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyScrollSnapType:
        if (isInitial)
            BuilderFunctions::applyInitialScrollSnapType(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritScrollSnapType(builderState);
        else
            BuilderFunctions::applyValueScrollSnapType(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyScrollTimelineAxis:
        if (isInitial)
            BuilderFunctions::applyInitialScrollTimelineAxis(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritScrollTimelineAxis(builderState);
        else
            BuilderFunctions::applyValueScrollTimelineAxis(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyScrollTimelineName:
        if (isInitial)
            BuilderFunctions::applyInitialScrollTimelineName(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritScrollTimelineName(builderState);
        else
            BuilderFunctions::applyValueScrollTimelineName(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyScrollbarColor:
        if (isInitial)
            BuilderFunctions::applyInitialScrollbarColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritScrollbarColor(builderState);
        else
            BuilderFunctions::applyValueScrollbarColor(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyScrollbarGutter:
        if (isInitial)
            BuilderFunctions::applyInitialScrollbarGutter(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritScrollbarGutter(builderState);
        else
            BuilderFunctions::applyValueScrollbarGutter(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyScrollbarWidth:
        if (isInitial)
            BuilderFunctions::applyInitialScrollbarWidth(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritScrollbarWidth(builderState);
        else
            BuilderFunctions::applyValueScrollbarWidth(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyShapeImageThreshold:
        if (isInitial)
            BuilderFunctions::applyInitialShapeImageThreshold(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritShapeImageThreshold(builderState);
        else
            BuilderFunctions::applyValueShapeImageThreshold(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyShapeMargin:
        if (isInitial)
            BuilderFunctions::applyInitialShapeMargin(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritShapeMargin(builderState);
        else
            BuilderFunctions::applyValueShapeMargin(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyShapeOutside:
        if (isInitial)
            BuilderFunctions::applyInitialShapeOutside(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritShapeOutside(builderState);
        else
            BuilderFunctions::applyValueShapeOutside(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyShapeRendering:
        if (isInitial)
            BuilderFunctions::applyInitialShapeRendering(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritShapeRendering(builderState);
        else
            BuilderFunctions::applyValueShapeRendering(builderState, value);
        break;
    case CSSPropertyID::CSSPropertySize:
        if (isInitial)
            BuilderCustom::applyInitialSize(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritSize(builderState);
        else
            BuilderCustom::applyValueSize(builderState, value);
        break;
    case CSSPropertyID::CSSPropertySizeAdjust:
        break;
    case CSSPropertyID::CSSPropertySpeakAs:
        if (isInitial)
            BuilderFunctions::applyInitialSpeakAs(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritSpeakAs(builderState);
        else
            BuilderFunctions::applyValueSpeakAs(builderState, value);
        break;
    case CSSPropertyID::CSSPropertySrc:
        break;
    case CSSPropertyID::CSSPropertyStopColor:
        if (isInitial)
            BuilderFunctions::applyInitialStopColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritStopColor(builderState);
        else
            BuilderFunctions::applyValueStopColor(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyStopOpacity:
        if (isInitial)
            BuilderFunctions::applyInitialStopOpacity(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritStopOpacity(builderState);
        else
            BuilderFunctions::applyValueStopOpacity(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyStroke:
        if (isInitial)
            BuilderCustom::applyInitialStroke(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritStroke(builderState);
        else
            BuilderCustom::applyValueStroke(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyStrokeColor:
        if (isInitial)
            BuilderFunctions::applyInitialStrokeColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritStrokeColor(builderState);
        else
            BuilderCustom::applyValueStrokeColor(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyStrokeDasharray:
        if (isInitial)
            BuilderFunctions::applyInitialStrokeDasharray(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritStrokeDasharray(builderState);
        else
            BuilderFunctions::applyValueStrokeDasharray(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyStrokeDashoffset:
        if (isInitial)
            BuilderFunctions::applyInitialStrokeDashoffset(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritStrokeDashoffset(builderState);
        else
            BuilderFunctions::applyValueStrokeDashoffset(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyStrokeLinecap:
        if (isInitial)
            BuilderFunctions::applyInitialStrokeLinecap(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritStrokeLinecap(builderState);
        else
            BuilderFunctions::applyValueStrokeLinecap(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyStrokeLinejoin:
        if (isInitial)
            BuilderFunctions::applyInitialStrokeLinejoin(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritStrokeLinejoin(builderState);
        else
            BuilderFunctions::applyValueStrokeLinejoin(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyStrokeMiterlimit:
        if (isInitial)
            BuilderFunctions::applyInitialStrokeMiterlimit(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritStrokeMiterlimit(builderState);
        else
            BuilderFunctions::applyValueStrokeMiterlimit(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyStrokeOpacity:
        if (isInitial)
            BuilderFunctions::applyInitialStrokeOpacity(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritStrokeOpacity(builderState);
        else
            BuilderFunctions::applyValueStrokeOpacity(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyStrokeWidth:
        if (isInitial)
            BuilderFunctions::applyInitialStrokeWidth(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritStrokeWidth(builderState);
        else
            BuilderCustom::applyValueStrokeWidth(builderState, value);
        break;
    case CSSPropertyID::CSSPropertySuffix:
        break;
    case CSSPropertyID::CSSPropertySymbols:
        break;
    case CSSPropertyID::CSSPropertySyntax:
        break;
    case CSSPropertyID::CSSPropertySystem:
        break;
    case CSSPropertyID::CSSPropertyTabSize:
        if (isInitial)
            BuilderFunctions::applyInitialTabSize(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTabSize(builderState);
        else
            BuilderFunctions::applyValueTabSize(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTableLayout:
        if (isInitial)
            BuilderFunctions::applyInitialTableLayout(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTableLayout(builderState);
        else
            BuilderFunctions::applyValueTableLayout(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTextAlign:
        if (isInitial)
            BuilderFunctions::applyInitialTextAlign(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextAlign(builderState);
        else
            BuilderFunctions::applyValueTextAlign(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTextAlignLast:
        if (isInitial)
            BuilderFunctions::applyInitialTextAlignLast(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextAlignLast(builderState);
        else
            BuilderFunctions::applyValueTextAlignLast(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTextAnchor:
        if (isInitial)
            BuilderFunctions::applyInitialTextAnchor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextAnchor(builderState);
        else
            BuilderFunctions::applyValueTextAnchor(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTextBoxEdge:
        if (isInitial)
            BuilderFunctions::applyInitialTextBoxEdge(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextBoxEdge(builderState);
        else
            BuilderFunctions::applyValueTextBoxEdge(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTextBoxTrim:
        if (isInitial)
            BuilderFunctions::applyInitialTextBoxTrim(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextBoxTrim(builderState);
        else
            BuilderFunctions::applyValueTextBoxTrim(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTextDecorationColor:
        if (isInitial)
            BuilderFunctions::applyInitialTextDecorationColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextDecorationColor(builderState);
        else
            BuilderFunctions::applyValueTextDecorationColor(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTextDecorationLine:
        if (isInitial)
            BuilderFunctions::applyInitialTextDecorationLine(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextDecorationLine(builderState);
        else
            BuilderFunctions::applyValueTextDecorationLine(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTextDecorationSkipInk:
        if (isInitial)
            BuilderFunctions::applyInitialTextDecorationSkipInk(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextDecorationSkipInk(builderState);
        else
            BuilderFunctions::applyValueTextDecorationSkipInk(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTextDecorationStyle:
        if (isInitial)
            BuilderFunctions::applyInitialTextDecorationStyle(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextDecorationStyle(builderState);
        else
            BuilderFunctions::applyValueTextDecorationStyle(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTextDecorationThickness:
        if (isInitial)
            BuilderFunctions::applyInitialTextDecorationThickness(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextDecorationThickness(builderState);
        else
            BuilderFunctions::applyValueTextDecorationThickness(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTextEmphasisColor:
        if (isInitial)
            BuilderFunctions::applyInitialTextEmphasisColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextEmphasisColor(builderState);
        else
            BuilderFunctions::applyValueTextEmphasisColor(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTextEmphasisPosition:
        if (isInitial)
            BuilderFunctions::applyInitialTextEmphasisPosition(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextEmphasisPosition(builderState);
        else
            BuilderFunctions::applyValueTextEmphasisPosition(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTextEmphasisStyle:
        if (isInitial)
            BuilderCustom::applyInitialTextEmphasisStyle(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritTextEmphasisStyle(builderState);
        else
            BuilderCustom::applyValueTextEmphasisStyle(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTextGroupAlign:
        if (isInitial)
            BuilderFunctions::applyInitialTextGroupAlign(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextGroupAlign(builderState);
        else
            BuilderFunctions::applyValueTextGroupAlign(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTextIndent:
        if (isInitial)
            BuilderCustom::applyInitialTextIndent(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritTextIndent(builderState);
        else
            BuilderCustom::applyValueTextIndent(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTextJustify:
        if (isInitial)
            BuilderFunctions::applyInitialTextJustify(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextJustify(builderState);
        else
            BuilderFunctions::applyValueTextJustify(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTextOverflow:
        if (isInitial)
            BuilderFunctions::applyInitialTextOverflow(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextOverflow(builderState);
        else
            BuilderFunctions::applyValueTextOverflow(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTextShadow:
        if (isInitial)
            BuilderCustom::applyInitialTextShadow(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritTextShadow(builderState);
        else
            BuilderCustom::applyValueTextShadow(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTextTransform:
        if (isInitial)
            BuilderFunctions::applyInitialTextTransform(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextTransform(builderState);
        else
            BuilderFunctions::applyValueTextTransform(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTextUnderlineOffset:
        if (isInitial)
            BuilderFunctions::applyInitialTextUnderlineOffset(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextUnderlineOffset(builderState);
        else
            BuilderFunctions::applyValueTextUnderlineOffset(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTextUnderlinePosition:
        if (isInitial)
            BuilderFunctions::applyInitialTextUnderlinePosition(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextUnderlinePosition(builderState);
        else
            BuilderFunctions::applyValueTextUnderlinePosition(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTextWrapMode:
        if (isInitial)
            BuilderFunctions::applyInitialTextWrapMode(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextWrapMode(builderState);
        else
            BuilderFunctions::applyValueTextWrapMode(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTextWrapStyle:
        if (isInitial)
            BuilderFunctions::applyInitialTextWrapStyle(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextWrapStyle(builderState);
        else
            BuilderFunctions::applyValueTextWrapStyle(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTouchAction:
        if (isInitial)
            BuilderFunctions::applyInitialTouchAction(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTouchAction(builderState);
        else
            BuilderFunctions::applyValueTouchAction(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTransform:
        if (isInitial)
            BuilderFunctions::applyInitialTransform(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTransform(builderState);
        else
            BuilderFunctions::applyValueTransform(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTransformBox:
        if (isInitial)
            BuilderFunctions::applyInitialTransformBox(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTransformBox(builderState);
        else
            BuilderFunctions::applyValueTransformBox(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTransformOriginX:
        if (isInitial)
            BuilderFunctions::applyInitialTransformOriginX(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTransformOriginX(builderState);
        else
            BuilderFunctions::applyValueTransformOriginX(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTransformOriginY:
        if (isInitial)
            BuilderFunctions::applyInitialTransformOriginY(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTransformOriginY(builderState);
        else
            BuilderFunctions::applyValueTransformOriginY(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTransformOriginZ:
        if (isInitial)
            BuilderFunctions::applyInitialTransformOriginZ(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTransformOriginZ(builderState);
        else
            BuilderFunctions::applyValueTransformOriginZ(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTransformStyle:
        if (isInitial)
            BuilderFunctions::applyInitialTransformStyle(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTransformStyle(builderState);
        else
            BuilderFunctions::applyValueTransformStyle(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTransitionBehavior:
        if (isInitial)
            BuilderFunctions::applyInitialTransitionBehavior(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTransitionBehavior(builderState);
        else
            BuilderFunctions::applyValueTransitionBehavior(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTransitionDelay:
        if (isInitial)
            BuilderFunctions::applyInitialTransitionDelay(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTransitionDelay(builderState);
        else
            BuilderFunctions::applyValueTransitionDelay(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTransitionDuration:
        if (isInitial)
            BuilderFunctions::applyInitialTransitionDuration(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTransitionDuration(builderState);
        else
            BuilderFunctions::applyValueTransitionDuration(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTransitionProperty:
        if (isInitial)
            BuilderFunctions::applyInitialTransitionProperty(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTransitionProperty(builderState);
        else
            BuilderFunctions::applyValueTransitionProperty(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTransitionTimingFunction:
        if (isInitial)
            BuilderFunctions::applyInitialTransitionTimingFunction(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTransitionTimingFunction(builderState);
        else
            BuilderFunctions::applyValueTransitionTimingFunction(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTranslate:
        if (isInitial)
            BuilderFunctions::applyInitialTranslate(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTranslate(builderState);
        else
            BuilderFunctions::applyValueTranslate(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyUnicodeBidi:
        if (isInitial)
            BuilderFunctions::applyInitialUnicodeBidi(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritUnicodeBidi(builderState);
        else
            BuilderFunctions::applyValueUnicodeBidi(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyUnicodeRange:
        break;
    case CSSPropertyID::CSSPropertyVectorEffect:
        if (isInitial)
            BuilderFunctions::applyInitialVectorEffect(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritVectorEffect(builderState);
        else
            BuilderFunctions::applyValueVectorEffect(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyVerticalAlign:
        if (isInitial)
            BuilderFunctions::applyInitialVerticalAlign(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritVerticalAlign(builderState);
        else
            BuilderCustom::applyValueVerticalAlign(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyViewTimelineAxis:
        if (isInitial)
            BuilderFunctions::applyInitialViewTimelineAxis(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritViewTimelineAxis(builderState);
        else
            BuilderFunctions::applyValueViewTimelineAxis(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyViewTimelineInset:
        if (isInitial)
            BuilderFunctions::applyInitialViewTimelineInset(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritViewTimelineInset(builderState);
        else
            BuilderFunctions::applyValueViewTimelineInset(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyViewTimelineName:
        if (isInitial)
            BuilderFunctions::applyInitialViewTimelineName(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritViewTimelineName(builderState);
        else
            BuilderFunctions::applyValueViewTimelineName(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyViewTransitionName:
        if (isInitial)
            BuilderFunctions::applyInitialViewTransitionName(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritViewTransitionName(builderState);
        else
            BuilderFunctions::applyValueViewTransitionName(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyVisibility:
        if (isInitial)
            BuilderFunctions::applyInitialVisibility(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritVisibility(builderState);
        else
            BuilderFunctions::applyValueVisibility(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWhiteSpaceCollapse:
        if (isInitial)
            BuilderFunctions::applyInitialWhiteSpaceCollapse(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWhiteSpaceCollapse(builderState);
        else
            BuilderFunctions::applyValueWhiteSpaceCollapse(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWidows:
        if (isInitial)
            BuilderFunctions::applyInitialWidows(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWidows(builderState);
        else
            BuilderFunctions::applyValueWidows(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWillChange:
        if (isInitial)
            BuilderFunctions::applyInitialWillChange(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWillChange(builderState);
        else
            BuilderFunctions::applyValueWillChange(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWordBreak:
        if (isInitial)
            BuilderFunctions::applyInitialWordBreak(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWordBreak(builderState);
        else
            BuilderFunctions::applyValueWordBreak(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyX:
        if (isInitial)
            BuilderFunctions::applyInitialX(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritX(builderState);
        else
            BuilderFunctions::applyValueX(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyY:
        if (isInitial)
            BuilderFunctions::applyInitialY(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritY(builderState);
        else
            BuilderFunctions::applyValueY(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyZIndex:
        if (isInitial)
            BuilderFunctions::applyInitialZIndex(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritZIndex(builderState);
        else
            BuilderFunctions::applyValueZIndex(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyAppleColorFilter:
        if (isInitial)
            BuilderFunctions::applyInitialAppleColorFilter(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritAppleColorFilter(builderState);
        else
            BuilderFunctions::applyValueAppleColorFilter(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitBorderHorizontalSpacing:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBorderHorizontalSpacing(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBorderHorizontalSpacing(builderState);
        else
            BuilderFunctions::applyValueWebkitBorderHorizontalSpacing(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitBorderVerticalSpacing:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBorderVerticalSpacing(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBorderVerticalSpacing(builderState);
        else
            BuilderFunctions::applyValueWebkitBorderVerticalSpacing(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitBoxAlign:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBoxAlign(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBoxAlign(builderState);
        else
            BuilderFunctions::applyValueWebkitBoxAlign(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitBoxDecorationBreak:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBoxDecorationBreak(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBoxDecorationBreak(builderState);
        else
            BuilderFunctions::applyValueWebkitBoxDecorationBreak(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitBoxDirection:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBoxDirection(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBoxDirection(builderState);
        else
            BuilderFunctions::applyValueWebkitBoxDirection(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitBoxFlex:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBoxFlex(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBoxFlex(builderState);
        else
            BuilderFunctions::applyValueWebkitBoxFlex(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitBoxFlexGroup:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBoxFlexGroup(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBoxFlexGroup(builderState);
        else
            BuilderFunctions::applyValueWebkitBoxFlexGroup(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitBoxLines:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBoxLines(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBoxLines(builderState);
        else
            BuilderFunctions::applyValueWebkitBoxLines(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitBoxOrdinalGroup:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBoxOrdinalGroup(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBoxOrdinalGroup(builderState);
        else
            BuilderFunctions::applyValueWebkitBoxOrdinalGroup(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitBoxOrient:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBoxOrient(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBoxOrient(builderState);
        else
            BuilderFunctions::applyValueWebkitBoxOrient(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitBoxPack:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBoxPack(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBoxPack(builderState);
        else
            BuilderFunctions::applyValueWebkitBoxPack(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitBoxReflect:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBoxReflect(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBoxReflect(builderState);
        else
            BuilderFunctions::applyValueWebkitBoxReflect(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitColumnAxis:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitColumnAxis(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitColumnAxis(builderState);
        else
            BuilderFunctions::applyValueWebkitColumnAxis(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitColumnProgression:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitColumnProgression(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitColumnProgression(builderState);
        else
            BuilderFunctions::applyValueWebkitColumnProgression(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitCursorVisibility:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitCursorVisibility(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitCursorVisibility(builderState);
        else
            BuilderFunctions::applyValueWebkitCursorVisibility(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitFontSizeDelta:
        break;
    case CSSPropertyID::CSSPropertyWebkitHyphenateLimitAfter:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitHyphenateLimitAfter(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitHyphenateLimitAfter(builderState);
        else
            BuilderFunctions::applyValueWebkitHyphenateLimitAfter(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitHyphenateLimitBefore:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitHyphenateLimitBefore(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitHyphenateLimitBefore(builderState);
        else
            BuilderFunctions::applyValueWebkitHyphenateLimitBefore(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitHyphenateLimitLines:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitHyphenateLimitLines(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitHyphenateLimitLines(builderState);
        else
            BuilderFunctions::applyValueWebkitHyphenateLimitLines(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitInitialLetter:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitInitialLetter(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitInitialLetter(builderState);
        else
            BuilderFunctions::applyValueWebkitInitialLetter(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitLineAlign:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitLineAlign(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitLineAlign(builderState);
        else
            BuilderFunctions::applyValueWebkitLineAlign(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitLineBoxContain:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitLineBoxContain(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitLineBoxContain(builderState);
        else
            BuilderFunctions::applyValueWebkitLineBoxContain(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitLineClamp:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitLineClamp(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitLineClamp(builderState);
        else
            BuilderFunctions::applyValueWebkitLineClamp(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitLineGrid:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitLineGrid(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitLineGrid(builderState);
        else
            BuilderFunctions::applyValueWebkitLineGrid(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitLineSnap:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitLineSnap(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitLineSnap(builderState);
        else
            BuilderFunctions::applyValueWebkitLineSnap(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitMarqueeDirection:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitMarqueeDirection(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitMarqueeDirection(builderState);
        else
            BuilderFunctions::applyValueWebkitMarqueeDirection(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitMarqueeIncrement:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitMarqueeIncrement(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitMarqueeIncrement(builderState);
        else
            BuilderFunctions::applyValueWebkitMarqueeIncrement(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitMarqueeRepetition:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitMarqueeRepetition(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitMarqueeRepetition(builderState);
        else
            BuilderFunctions::applyValueWebkitMarqueeRepetition(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitMarqueeSpeed:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitMarqueeSpeed(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitMarqueeSpeed(builderState);
        else
            BuilderFunctions::applyValueWebkitMarqueeSpeed(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitMarqueeStyle:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitMarqueeStyle(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitMarqueeStyle(builderState);
        else
            BuilderFunctions::applyValueWebkitMarqueeStyle(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitMaskPositionX:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitMaskPositionX(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitMaskPositionX(builderState);
        else
            BuilderFunctions::applyValueWebkitMaskPositionX(id, builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitMaskPositionY:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitMaskPositionY(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitMaskPositionY(builderState);
        else
            BuilderFunctions::applyValueWebkitMaskPositionY(id, builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitNbspMode:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitNbspMode(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitNbspMode(builderState);
        else
            BuilderFunctions::applyValueWebkitNbspMode(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitRtlOrdering:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitRtlOrdering(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitRtlOrdering(builderState);
        else
            BuilderFunctions::applyValueWebkitRtlOrdering(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitTapHighlightColor:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitTapHighlightColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitTapHighlightColor(builderState);
        else
            BuilderFunctions::applyValueWebkitTapHighlightColor(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitTextDecorationsInEffect:
        break;
    case CSSPropertyID::CSSPropertyWebkitTextFillColor:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitTextFillColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitTextFillColor(builderState);
        else
            BuilderFunctions::applyValueWebkitTextFillColor(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitTextSecurity:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitTextSecurity(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitTextSecurity(builderState);
        else
            BuilderFunctions::applyValueWebkitTextSecurity(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitTextStrokeColor:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitTextStrokeColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitTextStrokeColor(builderState);
        else
            BuilderFunctions::applyValueWebkitTextStrokeColor(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitTextStrokeWidth:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitTextStrokeWidth(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitTextStrokeWidth(builderState);
        else
            BuilderFunctions::applyValueWebkitTextStrokeWidth(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitUserDrag:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitUserDrag(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitUserDrag(builderState);
        else
            BuilderFunctions::applyValueWebkitUserDrag(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitUserModify:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitUserModify(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitUserModify(builderState);
        else
            BuilderFunctions::applyValueWebkitUserModify(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitUserSelect:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitUserSelect(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitUserSelect(builderState);
        else
            BuilderFunctions::applyValueWebkitUserSelect(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWordSpacing:
        if (isInitial)
            BuilderFunctions::applyInitialWordSpacing(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritWordSpacing(builderState);
        else
            BuilderFunctions::applyValueWordSpacing(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBackdropFilter:
        if (isInitial)
            BuilderFunctions::applyInitialBackdropFilter(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBackdropFilter(builderState);
        else
            BuilderFunctions::applyValueBackdropFilter(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBackgroundClip:
        if (isInitial)
            BuilderFunctions::applyInitialBackgroundClip(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBackgroundClip(builderState);
        else
            BuilderFunctions::applyValueBackgroundClip(id, builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBackgroundOrigin:
        if (isInitial)
            BuilderFunctions::applyInitialBackgroundOrigin(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBackgroundOrigin(builderState);
        else
            BuilderFunctions::applyValueBackgroundOrigin(id, builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBlockSize:
        break;
    case CSSPropertyID::CSSPropertyBorderBlockEndColor:
        break;
    case CSSPropertyID::CSSPropertyBorderBlockEndStyle:
        break;
    case CSSPropertyID::CSSPropertyBorderBlockEndWidth:
        break;
    case CSSPropertyID::CSSPropertyBorderBlockStartColor:
        break;
    case CSSPropertyID::CSSPropertyBorderBlockStartStyle:
        break;
    case CSSPropertyID::CSSPropertyBorderBlockStartWidth:
        break;
    case CSSPropertyID::CSSPropertyBorderBottomColor:
        if (isInitial)
            BuilderFunctions::applyInitialBorderBottomColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderBottomColor(builderState);
        else
            BuilderFunctions::applyValueBorderBottomColor(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBorderBottomLeftRadius:
        if (isInitial)
            BuilderCustom::applyInitialBorderBottomLeftRadius(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritBorderBottomLeftRadius(builderState);
        else
            BuilderCustom::applyValueBorderBottomLeftRadius(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBorderBottomRightRadius:
        if (isInitial)
            BuilderCustom::applyInitialBorderBottomRightRadius(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritBorderBottomRightRadius(builderState);
        else
            BuilderCustom::applyValueBorderBottomRightRadius(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBorderBottomStyle:
        if (isInitial)
            BuilderFunctions::applyInitialBorderBottomStyle(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderBottomStyle(builderState);
        else
            BuilderFunctions::applyValueBorderBottomStyle(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBorderBottomWidth:
        if (isInitial)
            BuilderFunctions::applyInitialBorderBottomWidth(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderBottomWidth(builderState);
        else
            BuilderFunctions::applyValueBorderBottomWidth(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBorderEndEndRadius:
        break;
    case CSSPropertyID::CSSPropertyBorderEndStartRadius:
        break;
    case CSSPropertyID::CSSPropertyBorderInlineEndColor:
        break;
    case CSSPropertyID::CSSPropertyBorderInlineEndStyle:
        break;
    case CSSPropertyID::CSSPropertyBorderInlineEndWidth:
        break;
    case CSSPropertyID::CSSPropertyBorderInlineStartColor:
        break;
    case CSSPropertyID::CSSPropertyBorderInlineStartStyle:
        break;
    case CSSPropertyID::CSSPropertyBorderInlineStartWidth:
        break;
    case CSSPropertyID::CSSPropertyBorderLeftColor:
        if (isInitial)
            BuilderFunctions::applyInitialBorderLeftColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderLeftColor(builderState);
        else
            BuilderFunctions::applyValueBorderLeftColor(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBorderLeftStyle:
        if (isInitial)
            BuilderFunctions::applyInitialBorderLeftStyle(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderLeftStyle(builderState);
        else
            BuilderFunctions::applyValueBorderLeftStyle(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBorderLeftWidth:
        if (isInitial)
            BuilderFunctions::applyInitialBorderLeftWidth(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderLeftWidth(builderState);
        else
            BuilderFunctions::applyValueBorderLeftWidth(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBorderRightColor:
        if (isInitial)
            BuilderFunctions::applyInitialBorderRightColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderRightColor(builderState);
        else
            BuilderFunctions::applyValueBorderRightColor(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBorderRightStyle:
        if (isInitial)
            BuilderFunctions::applyInitialBorderRightStyle(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderRightStyle(builderState);
        else
            BuilderFunctions::applyValueBorderRightStyle(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBorderRightWidth:
        if (isInitial)
            BuilderFunctions::applyInitialBorderRightWidth(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderRightWidth(builderState);
        else
            BuilderFunctions::applyValueBorderRightWidth(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBorderStartEndRadius:
        break;
    case CSSPropertyID::CSSPropertyBorderStartStartRadius:
        break;
    case CSSPropertyID::CSSPropertyBorderTopColor:
        if (isInitial)
            BuilderFunctions::applyInitialBorderTopColor(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderTopColor(builderState);
        else
            BuilderFunctions::applyValueBorderTopColor(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBorderTopLeftRadius:
        if (isInitial)
            BuilderCustom::applyInitialBorderTopLeftRadius(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritBorderTopLeftRadius(builderState);
        else
            BuilderCustom::applyValueBorderTopLeftRadius(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBorderTopRightRadius:
        if (isInitial)
            BuilderCustom::applyInitialBorderTopRightRadius(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritBorderTopRightRadius(builderState);
        else
            BuilderCustom::applyValueBorderTopRightRadius(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBorderTopStyle:
        if (isInitial)
            BuilderFunctions::applyInitialBorderTopStyle(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderTopStyle(builderState);
        else
            BuilderFunctions::applyValueBorderTopStyle(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBorderTopWidth:
        if (isInitial)
            BuilderFunctions::applyInitialBorderTopWidth(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBorderTopWidth(builderState);
        else
            BuilderFunctions::applyValueBorderTopWidth(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBottom:
        if (isInitial)
            BuilderFunctions::applyInitialBottom(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritBottom(builderState);
        else
            BuilderFunctions::applyValueBottom(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyBoxShadow:
        if (isInitial)
            BuilderCustom::applyInitialBoxShadow(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritBoxShadow(builderState);
        else
            BuilderCustom::applyValueBoxShadow(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyContainIntrinsicBlockSize:
        break;
    case CSSPropertyID::CSSPropertyContainIntrinsicHeight:
        if (isInitial)
            BuilderCustom::applyInitialContainIntrinsicHeight(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritContainIntrinsicHeight(builderState);
        else
            BuilderCustom::applyValueContainIntrinsicHeight(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyContainIntrinsicInlineSize:
        break;
    case CSSPropertyID::CSSPropertyContainIntrinsicWidth:
        if (isInitial)
            BuilderCustom::applyInitialContainIntrinsicWidth(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritContainIntrinsicWidth(builderState);
        else
            BuilderCustom::applyValueContainIntrinsicWidth(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyHeight:
        if (isInitial)
            BuilderFunctions::applyInitialHeight(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritHeight(builderState);
        else
            BuilderFunctions::applyValueHeight(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyInlineSize:
        break;
    case CSSPropertyID::CSSPropertyInsetBlockEnd:
        break;
    case CSSPropertyID::CSSPropertyInsetBlockStart:
        break;
    case CSSPropertyID::CSSPropertyInsetInlineEnd:
        break;
    case CSSPropertyID::CSSPropertyInsetInlineStart:
        break;
    case CSSPropertyID::CSSPropertyLeft:
        if (isInitial)
            BuilderFunctions::applyInitialLeft(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritLeft(builderState);
        else
            BuilderFunctions::applyValueLeft(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyMarginBlockEnd:
        break;
    case CSSPropertyID::CSSPropertyMarginBlockStart:
        break;
    case CSSPropertyID::CSSPropertyMarginBottom:
        if (isInitial)
            BuilderFunctions::applyInitialMarginBottom(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMarginBottom(builderState);
        else
            BuilderFunctions::applyValueMarginBottom(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyMarginInlineEnd:
        break;
    case CSSPropertyID::CSSPropertyMarginInlineStart:
        break;
    case CSSPropertyID::CSSPropertyMarginLeft:
        if (isInitial)
            BuilderFunctions::applyInitialMarginLeft(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMarginLeft(builderState);
        else
            BuilderFunctions::applyValueMarginLeft(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyMarginRight:
        if (isInitial)
            BuilderFunctions::applyInitialMarginRight(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMarginRight(builderState);
        else
            BuilderFunctions::applyValueMarginRight(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyMarginTop:
        if (isInitial)
            BuilderFunctions::applyInitialMarginTop(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMarginTop(builderState);
        else
            BuilderFunctions::applyValueMarginTop(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyMaskClip:
        if (isInitial)
            BuilderFunctions::applyInitialMaskClip(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMaskClip(builderState);
        else
            BuilderFunctions::applyValueMaskClip(id, builderState, value);
        break;
    case CSSPropertyID::CSSPropertyMaskComposite:
        if (isInitial)
            BuilderFunctions::applyInitialMaskComposite(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMaskComposite(builderState);
        else
            BuilderFunctions::applyValueMaskComposite(id, builderState, value);
        break;
    case CSSPropertyID::CSSPropertyMaskMode:
    case CSSPropertyID::CSSPropertyWebkitMaskSourceType:
        if (isInitial)
            BuilderFunctions::applyInitialMaskMode(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMaskMode(builderState);
        else
            BuilderFunctions::applyValueMaskMode(id, builderState, value);
        break;
    case CSSPropertyID::CSSPropertyMaxBlockSize:
        break;
    case CSSPropertyID::CSSPropertyMaxHeight:
        if (isInitial)
            BuilderFunctions::applyInitialMaxHeight(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMaxHeight(builderState);
        else
            BuilderFunctions::applyValueMaxHeight(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyMaxInlineSize:
        break;
    case CSSPropertyID::CSSPropertyMaxWidth:
        if (isInitial)
            BuilderFunctions::applyInitialMaxWidth(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMaxWidth(builderState);
        else
            BuilderFunctions::applyValueMaxWidth(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyMinBlockSize:
        break;
    case CSSPropertyID::CSSPropertyMinHeight:
        if (isInitial)
            BuilderFunctions::applyInitialMinHeight(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMinHeight(builderState);
        else
            BuilderFunctions::applyValueMinHeight(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyMinInlineSize:
        break;
    case CSSPropertyID::CSSPropertyMinWidth:
        if (isInitial)
            BuilderFunctions::applyInitialMinWidth(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritMinWidth(builderState);
        else
            BuilderFunctions::applyValueMinWidth(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyOverscrollBehaviorBlock:
        break;
    case CSSPropertyID::CSSPropertyOverscrollBehaviorInline:
        break;
    case CSSPropertyID::CSSPropertyOverscrollBehaviorX:
        if (isInitial)
            BuilderFunctions::applyInitialOverscrollBehaviorX(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritOverscrollBehaviorX(builderState);
        else
            BuilderFunctions::applyValueOverscrollBehaviorX(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyOverscrollBehaviorY:
        if (isInitial)
            BuilderFunctions::applyInitialOverscrollBehaviorY(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritOverscrollBehaviorY(builderState);
        else
            BuilderFunctions::applyValueOverscrollBehaviorY(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyPaddingBlockEnd:
        break;
    case CSSPropertyID::CSSPropertyPaddingBlockStart:
        break;
    case CSSPropertyID::CSSPropertyPaddingBottom:
        if (isInitial)
            BuilderFunctions::applyInitialPaddingBottom(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritPaddingBottom(builderState);
        else
            BuilderFunctions::applyValuePaddingBottom(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyPaddingInlineEnd:
        break;
    case CSSPropertyID::CSSPropertyPaddingInlineStart:
        break;
    case CSSPropertyID::CSSPropertyPaddingLeft:
        if (isInitial)
            BuilderFunctions::applyInitialPaddingLeft(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritPaddingLeft(builderState);
        else
            BuilderFunctions::applyValuePaddingLeft(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyPaddingRight:
        if (isInitial)
            BuilderFunctions::applyInitialPaddingRight(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritPaddingRight(builderState);
        else
            BuilderFunctions::applyValuePaddingRight(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyPaddingTop:
        if (isInitial)
            BuilderFunctions::applyInitialPaddingTop(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritPaddingTop(builderState);
        else
            BuilderFunctions::applyValuePaddingTop(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyRight:
        if (isInitial)
            BuilderFunctions::applyInitialRight(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritRight(builderState);
        else
            BuilderFunctions::applyValueRight(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyScrollMarginBlockEnd:
        break;
    case CSSPropertyID::CSSPropertyScrollMarginBlockStart:
        break;
    case CSSPropertyID::CSSPropertyScrollMarginBottom:
        if (isInitial)
            BuilderFunctions::applyInitialScrollMarginBottom(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritScrollMarginBottom(builderState);
        else
            BuilderFunctions::applyValueScrollMarginBottom(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyScrollMarginInlineEnd:
        break;
    case CSSPropertyID::CSSPropertyScrollMarginInlineStart:
        break;
    case CSSPropertyID::CSSPropertyScrollMarginLeft:
        if (isInitial)
            BuilderFunctions::applyInitialScrollMarginLeft(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritScrollMarginLeft(builderState);
        else
            BuilderFunctions::applyValueScrollMarginLeft(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyScrollMarginRight:
        if (isInitial)
            BuilderFunctions::applyInitialScrollMarginRight(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritScrollMarginRight(builderState);
        else
            BuilderFunctions::applyValueScrollMarginRight(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyScrollMarginTop:
        if (isInitial)
            BuilderFunctions::applyInitialScrollMarginTop(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritScrollMarginTop(builderState);
        else
            BuilderFunctions::applyValueScrollMarginTop(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyScrollPaddingBlockEnd:
        break;
    case CSSPropertyID::CSSPropertyScrollPaddingBlockStart:
        break;
    case CSSPropertyID::CSSPropertyScrollPaddingBottom:
        if (isInitial)
            BuilderFunctions::applyInitialScrollPaddingBottom(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritScrollPaddingBottom(builderState);
        else
            BuilderFunctions::applyValueScrollPaddingBottom(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyScrollPaddingInlineEnd:
        break;
    case CSSPropertyID::CSSPropertyScrollPaddingInlineStart:
        break;
    case CSSPropertyID::CSSPropertyScrollPaddingLeft:
        if (isInitial)
            BuilderFunctions::applyInitialScrollPaddingLeft(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritScrollPaddingLeft(builderState);
        else
            BuilderFunctions::applyValueScrollPaddingLeft(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyScrollPaddingRight:
        if (isInitial)
            BuilderFunctions::applyInitialScrollPaddingRight(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritScrollPaddingRight(builderState);
        else
            BuilderFunctions::applyValueScrollPaddingRight(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyScrollPaddingTop:
        if (isInitial)
            BuilderFunctions::applyInitialScrollPaddingTop(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritScrollPaddingTop(builderState);
        else
            BuilderFunctions::applyValueScrollPaddingTop(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTextCombineUpright:
        if (isInitial)
            BuilderFunctions::applyInitialTextCombineUpright(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTextCombineUpright(builderState);
        else
            BuilderFunctions::applyValueTextCombineUpright(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyTop:
        if (isInitial)
            BuilderFunctions::applyInitialTop(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritTop(builderState);
        else
            BuilderFunctions::applyValueTop(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWidth:
        if (isInitial)
            BuilderFunctions::applyInitialWidth(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWidth(builderState);
        else
            BuilderFunctions::applyValueWidth(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitBackdropFilter:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBackdropFilter(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBackdropFilter(builderState);
        else
            BuilderFunctions::applyValueWebkitBackdropFilter(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitBackgroundClip:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBackgroundClip(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBackgroundClip(builderState);
        else
            BuilderFunctions::applyValueWebkitBackgroundClip(id, builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitBackgroundOrigin:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitBackgroundOrigin(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitBackgroundOrigin(builderState);
        else
            BuilderFunctions::applyValueWebkitBackgroundOrigin(id, builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitBoxShadow:
        if (isInitial)
            BuilderCustom::applyInitialWebkitBoxShadow(builderState);
        else if (isInherit)
            BuilderCustom::applyInheritWebkitBoxShadow(builderState);
        else
            BuilderCustom::applyValueWebkitBoxShadow(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitMaskClip:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitMaskClip(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitMaskClip(builderState);
        else
            BuilderFunctions::applyValueWebkitMaskClip(id, builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitMaskComposite:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitMaskComposite(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitMaskComposite(builderState);
        else
            BuilderFunctions::applyValueWebkitMaskComposite(id, builderState, value);
        break;
    case CSSPropertyID::CSSPropertyWebkitTextCombine:
        if (isInitial)
            BuilderFunctions::applyInitialWebkitTextCombine(builderState);
        else if (isInherit)
            BuilderFunctions::applyInheritWebkitTextCombine(builderState);
        else
            BuilderFunctions::applyValueWebkitTextCombine(builderState, value);
        break;
    case CSSPropertyID::CSSPropertyAll:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyAnimation:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBackground:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBackgroundPosition:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorder:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderBlock:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderBlockColor:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderBlockEnd:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderBlockStart:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderBlockStyle:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderBlockWidth:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderBottom:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderColor:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderImage:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderInline:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderInlineColor:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderInlineEnd:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderInlineStart:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderInlineStyle:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderInlineWidth:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderLeft:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderRadius:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderRight:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderSpacing:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderStyle:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderTop:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyBorderWidth:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyColumnRule:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyColumns:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyContainIntrinsicSize:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyContainer:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyFlex:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyFlexFlow:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyFont:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyFontSynthesis:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyFontVariant:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyGap:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyGrid:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyGridArea:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyGridColumn:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyGridRow:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyGridTemplate:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyInset:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyInsetBlock:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyInsetInline:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyListStyle:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyMargin:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyMarginBlock:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyMarginInline:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyMarker:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyMask:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyMaskBorder:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyMaskPosition:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyOffset:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyOutline:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyOverflow:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyOverscrollBehavior:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyPadding:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyPaddingBlock:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyPaddingInline:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyPageBreakAfter:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyPageBreakBefore:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyPageBreakInside:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyPerspectiveOrigin:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyPlaceContent:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyPlaceItems:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyPlaceSelf:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyScrollMargin:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyScrollMarginBlock:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyScrollMarginInline:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyScrollPadding:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyScrollPaddingBlock:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyScrollPaddingInline:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyScrollTimeline:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyTextDecoration:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyTextDecorationSkip:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyTextEmphasis:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyTextWrap:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyTransformOrigin:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyTransition:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyViewTimeline:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyWhiteSpace:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyWebkitBackgroundSize:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyWebkitBorderImage:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyWebkitBorderRadius:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyWebkitColumnBreakAfter:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyWebkitColumnBreakBefore:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyWebkitColumnBreakInside:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyWebkitMask:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyWebkitMaskBoxImage:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyWebkitMaskPosition:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyWebkitPerspective:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyWebkitTextDecoration:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyWebkitTextOrientation:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyWebkitTextStroke:
        ASSERT(isShorthand(id));
        ASSERT_NOT_REACHED();
        break;
    }
}

} // namespace WebCore
} // namespace Style

