/*
 * Copyright (c) 2016 Apple Inc. All rights reserved.
 * Copyright (c) 2016 Canon Inc.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#pragma once

#include <JavaScriptCore/BuiltinUtils.h>
#include <JavaScriptCore/Identifier.h>
#include <JavaScriptCore/JSFunction.h>
#include <JavaScriptCore/UnlinkedFunctionExecutable.h>

namespace JSC {
class FunctionExecutable;
}

namespace WebCore {

/* ReadableByteStreamController */
extern const char* const s_readableByteStreamControllerInitializeReadableByteStreamControllerCode;
extern const int s_readableByteStreamControllerInitializeReadableByteStreamControllerCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamControllerInitializeReadableByteStreamControllerCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamControllerInitializeReadableByteStreamControllerCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableByteStreamControllerInitializeReadableByteStreamControllerCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableByteStreamControllerInitializeReadableByteStreamControllerCodeInlineAttribute;
extern const char* const s_readableByteStreamControllerEnqueueCode;
extern const int s_readableByteStreamControllerEnqueueCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamControllerEnqueueCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamControllerEnqueueCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableByteStreamControllerEnqueueCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableByteStreamControllerEnqueueCodeInlineAttribute;
extern const char* const s_readableByteStreamControllerErrorCode;
extern const int s_readableByteStreamControllerErrorCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamControllerErrorCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamControllerErrorCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableByteStreamControllerErrorCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableByteStreamControllerErrorCodeInlineAttribute;
extern const char* const s_readableByteStreamControllerCloseCode;
extern const int s_readableByteStreamControllerCloseCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamControllerCloseCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamControllerCloseCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableByteStreamControllerCloseCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableByteStreamControllerCloseCodeInlineAttribute;
extern const char* const s_readableByteStreamControllerByobRequestCode;
extern const int s_readableByteStreamControllerByobRequestCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamControllerByobRequestCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamControllerByobRequestCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableByteStreamControllerByobRequestCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableByteStreamControllerByobRequestCodeInlineAttribute;
extern const char* const s_readableByteStreamControllerDesiredSizeCode;
extern const int s_readableByteStreamControllerDesiredSizeCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamControllerDesiredSizeCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamControllerDesiredSizeCodeConstructorKind;
extern const JSC::ImplementationVisibility s_readableByteStreamControllerDesiredSizeCodeImplementationVisibility;
extern const JSC::InlineAttribute s_readableByteStreamControllerDesiredSizeCodeInlineAttribute;

#define WEBCORE_FOREACH_READABLEBYTESTREAMCONTROLLER_BUILTIN_DATA(macro) \
    macro(initializeReadableByteStreamController, readableByteStreamControllerInitializeReadableByteStreamController, 3) \
    macro(enqueue, readableByteStreamControllerEnqueue, 1) \
    macro(error, readableByteStreamControllerError, 1) \
    macro(close, readableByteStreamControllerClose, 0) \
    macro(byobRequest, readableByteStreamControllerByobRequest, 0) \
    macro(desiredSize, readableByteStreamControllerDesiredSize, 0) \

#define WEBCORE_BUILTIN_READABLEBYTESTREAMCONTROLLER_INITIALIZEREADABLEBYTESTREAMCONTROLLER 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMCONTROLLER_ENQUEUE 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMCONTROLLER_ERROR 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMCONTROLLER_CLOSE 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMCONTROLLER_BYOBREQUEST 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMCONTROLLER_DESIREDSIZE 1

#define WEBCORE_FOREACH_READABLEBYTESTREAMCONTROLLER_BUILTIN_CODE(macro) \
    macro(readableByteStreamControllerInitializeReadableByteStreamControllerCode, initializeReadableByteStreamController, ASCIILiteral(), s_readableByteStreamControllerInitializeReadableByteStreamControllerCodeLength) \
    macro(readableByteStreamControllerEnqueueCode, enqueue, ASCIILiteral(), s_readableByteStreamControllerEnqueueCodeLength) \
    macro(readableByteStreamControllerErrorCode, error, ASCIILiteral(), s_readableByteStreamControllerErrorCodeLength) \
    macro(readableByteStreamControllerCloseCode, close, ASCIILiteral(), s_readableByteStreamControllerCloseCodeLength) \
    macro(readableByteStreamControllerByobRequestCode, byobRequest, "get byobRequest"_s, s_readableByteStreamControllerByobRequestCodeLength) \
    macro(readableByteStreamControllerDesiredSizeCode, desiredSize, "get desiredSize"_s, s_readableByteStreamControllerDesiredSizeCodeLength) \

#define WEBCORE_FOREACH_READABLEBYTESTREAMCONTROLLER_BUILTIN_FUNCTION_NAME(macro) \
    macro(byobRequest) \
    macro(close) \
    macro(desiredSize) \
    macro(enqueue) \
    macro(error) \
    macro(initializeReadableByteStreamController) \

#define DECLARE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
    JSC::FunctionExecutable* codeName##Generator(JSC::VM&);

WEBCORE_FOREACH_READABLEBYTESTREAMCONTROLLER_BUILTIN_CODE(DECLARE_BUILTIN_GENERATOR)
#undef DECLARE_BUILTIN_GENERATOR

class ReadableByteStreamControllerBuiltinsWrapper : private JSC::WeakHandleOwner {
public:
    explicit ReadableByteStreamControllerBuiltinsWrapper(JSC::VM& vm)
        : m_vm(vm)
        WEBCORE_FOREACH_READABLEBYTESTREAMCONTROLLER_BUILTIN_FUNCTION_NAME(INITIALIZE_BUILTIN_NAMES)
#define INITIALIZE_BUILTIN_SOURCE_MEMBERS(name, functionName, overriddenName, length) , m_##name##Source(JSC::makeSource(StringImpl::createWithoutCopying(s_##name, length), { }, JSC::SourceTaintedOrigin::Untainted))
        WEBCORE_FOREACH_READABLEBYTESTREAMCONTROLLER_BUILTIN_CODE(INITIALIZE_BUILTIN_SOURCE_MEMBERS)
#undef INITIALIZE_BUILTIN_SOURCE_MEMBERS
    {
    }

#define EXPOSE_BUILTIN_EXECUTABLES(name, functionName, overriddenName, length) \
    JSC::UnlinkedFunctionExecutable* name##Executable(); \
    const JSC::SourceCode& name##Source() const { return m_##name##Source; }
    WEBCORE_FOREACH_READABLEBYTESTREAMCONTROLLER_BUILTIN_CODE(EXPOSE_BUILTIN_EXECUTABLES)
#undef EXPOSE_BUILTIN_EXECUTABLES

    WEBCORE_FOREACH_READABLEBYTESTREAMCONTROLLER_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_IDENTIFIER_ACCESSOR)

    void exportNames();

private:
    JSC::VM& m_vm;

    WEBCORE_FOREACH_READABLEBYTESTREAMCONTROLLER_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_NAMES)

#define DECLARE_BUILTIN_SOURCE_MEMBERS(name, functionName, overriddenName, length) \
    JSC::SourceCode m_##name##Source;\
    JSC::Weak<JSC::UnlinkedFunctionExecutable> m_##name##Executable;
    WEBCORE_FOREACH_READABLEBYTESTREAMCONTROLLER_BUILTIN_CODE(DECLARE_BUILTIN_SOURCE_MEMBERS)
#undef DECLARE_BUILTIN_SOURCE_MEMBERS

};

#define DEFINE_BUILTIN_EXECUTABLES(name, functionName, overriddenName, length) \
inline JSC::UnlinkedFunctionExecutable* ReadableByteStreamControllerBuiltinsWrapper::name##Executable() \
{\
    if (!m_##name##Executable) {\
        JSC::Identifier executableName = functionName##PublicName();\
        if (overriddenName)\
            executableName = JSC::Identifier::fromString(m_vm, overriddenName);\
        m_##name##Executable = JSC::Weak<JSC::UnlinkedFunctionExecutable>(JSC::createBuiltinExecutable(m_vm, m_##name##Source, executableName, s_##name##ImplementationVisibility, s_##name##ConstructorKind, s_##name##ConstructAbility, s_##name##InlineAttribute), this, &m_##name##Executable);\
    }\
    return m_##name##Executable.get();\
}
WEBCORE_FOREACH_READABLEBYTESTREAMCONTROLLER_BUILTIN_CODE(DEFINE_BUILTIN_EXECUTABLES)
#undef DEFINE_BUILTIN_EXECUTABLES

inline void ReadableByteStreamControllerBuiltinsWrapper::exportNames()
{
#define EXPORT_FUNCTION_NAME(name) m_vm.propertyNames->appendExternalName(name##PublicName(), name##PrivateName());
    WEBCORE_FOREACH_READABLEBYTESTREAMCONTROLLER_BUILTIN_FUNCTION_NAME(EXPORT_FUNCTION_NAME)
#undef EXPORT_FUNCTION_NAME
}

} // namespace WebCore
