/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSXMLHttpRequestEventTarget.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsXMLHttpRequestEventTargetConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsXMLHttpRequestEventTarget_onloadstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSXMLHttpRequestEventTarget_onloadstart);
static JSC_DECLARE_CUSTOM_GETTER(jsXMLHttpRequestEventTarget_onprogress);
static JSC_DECLARE_CUSTOM_SETTER(setJSXMLHttpRequestEventTarget_onprogress);
static JSC_DECLARE_CUSTOM_GETTER(jsXMLHttpRequestEventTarget_onabort);
static JSC_DECLARE_CUSTOM_SETTER(setJSXMLHttpRequestEventTarget_onabort);
static JSC_DECLARE_CUSTOM_GETTER(jsXMLHttpRequestEventTarget_onerror);
static JSC_DECLARE_CUSTOM_SETTER(setJSXMLHttpRequestEventTarget_onerror);
static JSC_DECLARE_CUSTOM_GETTER(jsXMLHttpRequestEventTarget_onload);
static JSC_DECLARE_CUSTOM_SETTER(setJSXMLHttpRequestEventTarget_onload);
static JSC_DECLARE_CUSTOM_GETTER(jsXMLHttpRequestEventTarget_ontimeout);
static JSC_DECLARE_CUSTOM_SETTER(setJSXMLHttpRequestEventTarget_ontimeout);
static JSC_DECLARE_CUSTOM_GETTER(jsXMLHttpRequestEventTarget_onloadend);
static JSC_DECLARE_CUSTOM_SETTER(setJSXMLHttpRequestEventTarget_onloadend);

class JSXMLHttpRequestEventTargetPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSXMLHttpRequestEventTargetPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSXMLHttpRequestEventTargetPrototype* ptr = new (NotNull, JSC::allocateCell<JSXMLHttpRequestEventTargetPrototype>(vm)) JSXMLHttpRequestEventTargetPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSXMLHttpRequestEventTargetPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSXMLHttpRequestEventTargetPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSXMLHttpRequestEventTargetPrototype, JSXMLHttpRequestEventTargetPrototype::Base);

using JSXMLHttpRequestEventTargetDOMConstructor = JSDOMConstructorNotConstructable<JSXMLHttpRequestEventTarget>;

template<> const ClassInfo JSXMLHttpRequestEventTargetDOMConstructor::s_info = { "XMLHttpRequestEventTarget"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXMLHttpRequestEventTargetDOMConstructor) };

template<> JSValue JSXMLHttpRequestEventTargetDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSXMLHttpRequestEventTargetDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "XMLHttpRequestEventTarget"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSXMLHttpRequestEventTarget::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSXMLHttpRequestEventTargetPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsXMLHttpRequestEventTargetConstructor, 0 } },
    { "onloadstart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsXMLHttpRequestEventTarget_onloadstart, setJSXMLHttpRequestEventTarget_onloadstart } },
    { "onprogress"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsXMLHttpRequestEventTarget_onprogress, setJSXMLHttpRequestEventTarget_onprogress } },
    { "onabort"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsXMLHttpRequestEventTarget_onabort, setJSXMLHttpRequestEventTarget_onabort } },
    { "onerror"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsXMLHttpRequestEventTarget_onerror, setJSXMLHttpRequestEventTarget_onerror } },
    { "onload"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsXMLHttpRequestEventTarget_onload, setJSXMLHttpRequestEventTarget_onload } },
    { "ontimeout"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsXMLHttpRequestEventTarget_ontimeout, setJSXMLHttpRequestEventTarget_ontimeout } },
    { "onloadend"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsXMLHttpRequestEventTarget_onloadend, setJSXMLHttpRequestEventTarget_onloadend } },
};

const ClassInfo JSXMLHttpRequestEventTargetPrototype::s_info = { "XMLHttpRequestEventTarget"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXMLHttpRequestEventTargetPrototype) };

void JSXMLHttpRequestEventTargetPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSXMLHttpRequestEventTarget::info(), JSXMLHttpRequestEventTargetPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSXMLHttpRequestEventTarget::s_info = { "XMLHttpRequestEventTarget"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXMLHttpRequestEventTarget) };

JSXMLHttpRequestEventTarget::JSXMLHttpRequestEventTarget(Structure* structure, JSDOMGlobalObject& globalObject, Ref<XMLHttpRequestEventTarget>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

Ref<XMLHttpRequestEventTarget> JSXMLHttpRequestEventTarget::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, XMLHttpRequestEventTarget>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSXMLHttpRequestEventTarget::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSXMLHttpRequestEventTargetPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSXMLHttpRequestEventTargetPrototype::create(vm, &globalObject, structure);
}

JSObject* JSXMLHttpRequestEventTarget::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSXMLHttpRequestEventTarget>(vm, globalObject);
}

JSValue JSXMLHttpRequestEventTarget::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSXMLHttpRequestEventTargetDOMConstructor, DOMConstructorID::XMLHttpRequestEventTarget>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsXMLHttpRequestEventTargetConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSXMLHttpRequestEventTargetPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSXMLHttpRequestEventTarget::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsXMLHttpRequestEventTarget_onloadstartGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequestEventTarget& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().loadstartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsXMLHttpRequestEventTarget_onloadstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequestEventTarget>::get<jsXMLHttpRequestEventTarget_onloadstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSXMLHttpRequestEventTarget_onloadstartSetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequestEventTarget& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().loadstartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSXMLHttpRequestEventTarget_onloadstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequestEventTarget>::set<setJSXMLHttpRequestEventTarget_onloadstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsXMLHttpRequestEventTarget_onprogressGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequestEventTarget& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().progressEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsXMLHttpRequestEventTarget_onprogress, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequestEventTarget>::get<jsXMLHttpRequestEventTarget_onprogressGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSXMLHttpRequestEventTarget_onprogressSetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequestEventTarget& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().progressEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSXMLHttpRequestEventTarget_onprogress, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequestEventTarget>::set<setJSXMLHttpRequestEventTarget_onprogressSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsXMLHttpRequestEventTarget_onabortGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequestEventTarget& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().abortEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsXMLHttpRequestEventTarget_onabort, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequestEventTarget>::get<jsXMLHttpRequestEventTarget_onabortGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSXMLHttpRequestEventTarget_onabortSetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequestEventTarget& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().abortEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSXMLHttpRequestEventTarget_onabort, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequestEventTarget>::set<setJSXMLHttpRequestEventTarget_onabortSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsXMLHttpRequestEventTarget_onerrorGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequestEventTarget& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().errorEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsXMLHttpRequestEventTarget_onerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequestEventTarget>::get<jsXMLHttpRequestEventTarget_onerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSXMLHttpRequestEventTarget_onerrorSetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequestEventTarget& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().errorEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSXMLHttpRequestEventTarget_onerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequestEventTarget>::set<setJSXMLHttpRequestEventTarget_onerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsXMLHttpRequestEventTarget_onloadGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequestEventTarget& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().loadEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsXMLHttpRequestEventTarget_onload, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequestEventTarget>::get<jsXMLHttpRequestEventTarget_onloadGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSXMLHttpRequestEventTarget_onloadSetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequestEventTarget& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().loadEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSXMLHttpRequestEventTarget_onload, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequestEventTarget>::set<setJSXMLHttpRequestEventTarget_onloadSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsXMLHttpRequestEventTarget_ontimeoutGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequestEventTarget& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().timeoutEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsXMLHttpRequestEventTarget_ontimeout, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequestEventTarget>::get<jsXMLHttpRequestEventTarget_ontimeoutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSXMLHttpRequestEventTarget_ontimeoutSetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequestEventTarget& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().timeoutEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSXMLHttpRequestEventTarget_ontimeout, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequestEventTarget>::set<setJSXMLHttpRequestEventTarget_ontimeoutSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsXMLHttpRequestEventTarget_onloadendGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequestEventTarget& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().loadendEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsXMLHttpRequestEventTarget_onloadend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequestEventTarget>::get<jsXMLHttpRequestEventTarget_onloadendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSXMLHttpRequestEventTarget_onloadendSetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequestEventTarget& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().loadendEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSXMLHttpRequestEventTarget_onloadend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequestEventTarget>::set<setJSXMLHttpRequestEventTarget_onloadendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSXMLHttpRequestEventTarget::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSXMLHttpRequestEventTarget, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForXMLHttpRequestEventTarget.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForXMLHttpRequestEventTarget = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForXMLHttpRequestEventTarget.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForXMLHttpRequestEventTarget = std::forward<decltype(space)>(space); }
    );
}

void JSXMLHttpRequestEventTarget::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSXMLHttpRequestEventTarget*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

XMLHttpRequestEventTarget* JSXMLHttpRequestEventTarget::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSXMLHttpRequestEventTarget*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
