/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWorkerNavigator.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSGPU.h"
#include "JSMediaCapabilities.h"
#include "JSPermissions.h"
#include "JSServiceWorkerContainer.h"
#include "JSStorageManager.h"
#include "JSWebLockManager.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include "WorkerNavigatorMediaCapabilities.h"
#include "WorkerNavigatorPermissions.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsWorkerNavigatorPrototypeFunction_setAppBadge);
static JSC_DECLARE_HOST_FUNCTION(jsWorkerNavigatorPrototypeFunction_clearAppBadge);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWorkerNavigatorConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerNavigator_hardwareConcurrency);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerNavigator_gpu);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerNavigator_mediaCapabilities);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerNavigator_permissions);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerNavigator_locks);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerNavigator_appCodeName);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerNavigator_appName);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerNavigator_appVersion);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerNavigator_platform);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerNavigator_product);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerNavigator_userAgent);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerNavigator_language);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerNavigator_languages);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerNavigator_onLine);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerNavigator_serviceWorker);
static JSC_DECLARE_CUSTOM_GETTER(jsWorkerNavigator_storage);

class JSWorkerNavigatorPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWorkerNavigatorPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWorkerNavigatorPrototype* ptr = new (NotNull, JSC::allocateCell<JSWorkerNavigatorPrototype>(vm)) JSWorkerNavigatorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWorkerNavigatorPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWorkerNavigatorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWorkerNavigatorPrototype, JSWorkerNavigatorPrototype::Base);

using JSWorkerNavigatorDOMConstructor = JSDOMConstructorNotConstructable<JSWorkerNavigator>;

template<> const ClassInfo JSWorkerNavigatorDOMConstructor::s_info = { "WorkerNavigator"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWorkerNavigatorDOMConstructor) };

template<> JSValue JSWorkerNavigatorDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWorkerNavigatorDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "WorkerNavigator"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWorkerNavigator::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSWorkerNavigatorPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerNavigatorConstructor, 0 } },
    { "hardwareConcurrency"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerNavigator_hardwareConcurrency, 0 } },
    { "gpu"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerNavigator_gpu, 0 } },
    { "mediaCapabilities"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerNavigator_mediaCapabilities, 0 } },
    { "permissions"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerNavigator_permissions, 0 } },
    { "locks"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerNavigator_locks, 0 } },
    { "appCodeName"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerNavigator_appCodeName, 0 } },
    { "appName"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerNavigator_appName, 0 } },
    { "appVersion"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerNavigator_appVersion, 0 } },
    { "platform"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerNavigator_platform, 0 } },
    { "product"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerNavigator_product, 0 } },
    { "userAgent"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerNavigator_userAgent, 0 } },
    { "language"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerNavigator_language, 0 } },
    { "languages"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerNavigator_languages, 0 } },
    { "onLine"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerNavigator_onLine, 0 } },
    { "serviceWorker"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerNavigator_serviceWorker, 0 } },
    { "storage"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWorkerNavigator_storage, 0 } },
    { "setAppBadge"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWorkerNavigatorPrototypeFunction_setAppBadge, 0 } },
    { "clearAppBadge"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWorkerNavigatorPrototypeFunction_clearAppBadge, 0 } },
};

const ClassInfo JSWorkerNavigatorPrototype::s_info = { "WorkerNavigator"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWorkerNavigatorPrototype) };

void JSWorkerNavigatorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWorkerNavigator::info(), JSWorkerNavigatorPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().appBadgeEnabled)) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "setAppBadge"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().appBadgeEnabled)) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "clearAppBadge"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled)) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "gpu"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().mediaCapabilitiesEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "mediaCapabilities"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().permissionsAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "permissions"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webLocksAPIEnabled)) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "locks"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().serviceWorkersEnabled)) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "serviceWorker"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().storageAPIEnabled)) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "storage"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWorkerNavigator::s_info = { "WorkerNavigator"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWorkerNavigator) };

JSWorkerNavigator::JSWorkerNavigator(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WorkerNavigator>&& impl)
    : JSDOMWrapper<WorkerNavigator>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WorkerNavigator>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWorkerNavigator::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWorkerNavigatorPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWorkerNavigatorPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWorkerNavigator::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWorkerNavigator>(vm, globalObject);
}

JSValue JSWorkerNavigator::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWorkerNavigatorDOMConstructor, DOMConstructorID::WorkerNavigator>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWorkerNavigator::destroy(JSC::JSCell* cell)
{
    JSWorkerNavigator* thisObject = static_cast<JSWorkerNavigator*>(cell);
    thisObject->JSWorkerNavigator::~JSWorkerNavigator();
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerNavigatorConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWorkerNavigatorPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWorkerNavigator::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsWorkerNavigator_hardwareConcurrencyGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerNavigator& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.hardwareConcurrency())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerNavigator_hardwareConcurrency, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerNavigator>::get<jsWorkerNavigator_hardwareConcurrencyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerNavigator_gpuGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerNavigator& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<GPU>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.gpu())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerNavigator_gpu, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerNavigator>::get<jsWorkerNavigator_gpuGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerNavigator_mediaCapabilitiesGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerNavigator& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<MediaCapabilities>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, WebCore::WorkerNavigatorMediaCapabilities::mediaCapabilities(impl))));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerNavigator_mediaCapabilities, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerNavigator>::get<jsWorkerNavigator_mediaCapabilitiesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerNavigator_permissionsGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerNavigator& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<Permissions>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, WebCore::WorkerNavigatorPermissions::permissions(impl))));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerNavigator_permissions, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerNavigator>::get<jsWorkerNavigator_permissionsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerNavigator_locksGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerNavigator& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<WebLockManager>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.locks())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerNavigator_locks, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerNavigator>::get<jsWorkerNavigator_locksGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerNavigator_appCodeNameGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerNavigator& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.appCodeName())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerNavigator_appCodeName, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerNavigator>::get<jsWorkerNavigator_appCodeNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerNavigator_appNameGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerNavigator& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.appName())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerNavigator_appName, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerNavigator>::get<jsWorkerNavigator_appNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerNavigator_appVersionGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerNavigator& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.appVersion())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerNavigator_appVersion, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerNavigator>::get<jsWorkerNavigator_appVersionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerNavigator_platformGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerNavigator& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.platform())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerNavigator_platform, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerNavigator>::get<jsWorkerNavigator_platformGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerNavigator_productGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerNavigator& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.product())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerNavigator_product, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerNavigator>::get<jsWorkerNavigator_productGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerNavigator_userAgentGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerNavigator& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.userAgent())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerNavigator_userAgent, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerNavigator>::get<jsWorkerNavigator_userAgentGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerNavigator_languageGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerNavigator& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.language())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerNavigator_language, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerNavigator>::get<jsWorkerNavigator_languageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerNavigator_languagesGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerNavigator& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFrozenArray<IDLDOMString>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.languages())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerNavigator_languages, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerNavigator>::get<jsWorkerNavigator_languagesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerNavigator_onLineGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerNavigator& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.onLine())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerNavigator_onLine, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerNavigator>::get<jsWorkerNavigator_onLineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerNavigator_serviceWorkerGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerNavigator& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* context = jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<ServiceWorkerContainer>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.serviceWorker(*context))));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerNavigator_serviceWorker, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerNavigator>::get<jsWorkerNavigator_serviceWorkerGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWorkerNavigator_storageGetter(JSGlobalObject& lexicalGlobalObject, JSWorkerNavigator& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<StorageManager>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.storage())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWorkerNavigator_storage, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWorkerNavigator>::get<jsWorkerNavigator_storageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsWorkerNavigatorPrototypeFunction_setAppBadgeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSWorkerNavigator>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto contents = argument0.value().isUndefined() ? std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>::ReturnType>() : std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>::ReturnType>(convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(*lexicalGlobalObject, argument0.value()));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.setAppBadge(WTFMove(contents), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWorkerNavigatorPrototypeFunction_setAppBadge, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSWorkerNavigator>::call<jsWorkerNavigatorPrototypeFunction_setAppBadgeBody>(*lexicalGlobalObject, *callFrame, "setAppBadge");
}

static inline JSC::EncodedJSValue jsWorkerNavigatorPrototypeFunction_clearAppBadgeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSWorkerNavigator>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.clearAppBadge(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWorkerNavigatorPrototypeFunction_clearAppBadge, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSWorkerNavigator>::call<jsWorkerNavigatorPrototypeFunction_clearAppBadgeBody>(*lexicalGlobalObject, *callFrame, "clearAppBadge");
}

JSC::GCClient::IsoSubspace* JSWorkerNavigator::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWorkerNavigator, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWorkerNavigator.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWorkerNavigator = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWorkerNavigator.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWorkerNavigator = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSWorkerNavigator::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSWorkerNavigator*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSWorkerNavigator);

template<typename Visitor>
void JSWorkerNavigator::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSWorkerNavigator*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSWorkerNavigator::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSWorkerNavigator::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSWorkerNavigator::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWorkerNavigator*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWorkerNavigatorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsWorkerNavigator = jsCast<JSWorkerNavigator*>(handle.slot()->asCell());
    WorkerNavigator* owner = &jsWorkerNavigator->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from WorkerNavigator";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSWorkerNavigatorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWorkerNavigator = static_cast<JSWorkerNavigator*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWorkerNavigator->wrapped(), jsWorkerNavigator);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WorkerNavigator@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore15WorkerNavigatorE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WorkerNavigator>&& impl)
{

    if constexpr (std::is_polymorphic_v<WorkerNavigator>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WorkerNavigator@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore15WorkerNavigatorE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WorkerNavigator has subclasses. If WorkerNavigator has subclasses that get passed
        // to toJS() we currently require WorkerNavigator you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<WorkerNavigator>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WorkerNavigator& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WorkerNavigator* JSWorkerNavigator::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWorkerNavigator*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
