/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebTransportReceiveStream.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSWebTransportReceiveStreamStats.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsWebTransportReceiveStreamPrototypeFunction_getStats);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWebTransportReceiveStreamConstructor);

class JSWebTransportReceiveStreamPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebTransportReceiveStreamPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebTransportReceiveStreamPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebTransportReceiveStreamPrototype>(vm)) JSWebTransportReceiveStreamPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebTransportReceiveStreamPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebTransportReceiveStreamPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebTransportReceiveStreamPrototype, JSWebTransportReceiveStreamPrototype::Base);

using JSWebTransportReceiveStreamDOMConstructor = JSDOMConstructorNotConstructable<JSWebTransportReceiveStream>;

template<> const ClassInfo JSWebTransportReceiveStreamDOMConstructor::s_info = { "WebTransportReceiveStream"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebTransportReceiveStreamDOMConstructor) };

template<> JSValue JSWebTransportReceiveStreamDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSReadableStream::getConstructor(vm, &globalObject);
}

template<> void JSWebTransportReceiveStreamDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "WebTransportReceiveStream"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWebTransportReceiveStream::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSWebTransportReceiveStreamPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWebTransportReceiveStreamConstructor, 0 } },
    { "getStats"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebTransportReceiveStreamPrototypeFunction_getStats, 0 } },
};

const ClassInfo JSWebTransportReceiveStreamPrototype::s_info = { "WebTransportReceiveStream"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebTransportReceiveStreamPrototype) };

void JSWebTransportReceiveStreamPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebTransportReceiveStream::info(), JSWebTransportReceiveStreamPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebTransportReceiveStream::s_info = { "WebTransportReceiveStream"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebTransportReceiveStream) };

JSWebTransportReceiveStream::JSWebTransportReceiveStream(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebTransportReceiveStream>&& impl)
    : JSReadableStream(structure, globalObject, WTFMove(impl))
{
}

Ref<WebTransportReceiveStream> JSWebTransportReceiveStream::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, WebTransportReceiveStream>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebTransportReceiveStream::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebTransportReceiveStreamPrototype::createStructure(vm, &globalObject, JSReadableStream::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSWebTransportReceiveStreamPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebTransportReceiveStream::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebTransportReceiveStream>(vm, globalObject);
}

JSValue JSWebTransportReceiveStream::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebTransportReceiveStreamDOMConstructor, DOMConstructorID::WebTransportReceiveStream>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebTransportReceiveStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebTransportReceiveStreamPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebTransportReceiveStream::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsWebTransportReceiveStreamPrototypeFunction_getStatsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSWebTransportReceiveStream>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLDictionary<WebTransportReceiveStreamStats>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.getStats(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebTransportReceiveStreamPrototypeFunction_getStats, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSWebTransportReceiveStream>::call<jsWebTransportReceiveStreamPrototypeFunction_getStatsBody>(*lexicalGlobalObject, *callFrame, "getStats");
}

JSC::GCClient::IsoSubspace* JSWebTransportReceiveStream::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebTransportReceiveStream, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebTransportReceiveStream.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebTransportReceiveStream = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebTransportReceiveStream.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebTransportReceiveStream = std::forward<decltype(space)>(space); }
    );
}

void JSWebTransportReceiveStream::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebTransportReceiveStream*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
