/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebTransportBidirectionalStream.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSWebTransportReceiveStream.h"
#include "JSWebTransportSendStream.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWebTransportBidirectionalStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWebTransportBidirectionalStream_readable);
static JSC_DECLARE_CUSTOM_GETTER(jsWebTransportBidirectionalStream_writable);

class JSWebTransportBidirectionalStreamPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebTransportBidirectionalStreamPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebTransportBidirectionalStreamPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebTransportBidirectionalStreamPrototype>(vm)) JSWebTransportBidirectionalStreamPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebTransportBidirectionalStreamPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebTransportBidirectionalStreamPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebTransportBidirectionalStreamPrototype, JSWebTransportBidirectionalStreamPrototype::Base);

using JSWebTransportBidirectionalStreamDOMConstructor = JSDOMConstructorNotConstructable<JSWebTransportBidirectionalStream>;

template<> const ClassInfo JSWebTransportBidirectionalStreamDOMConstructor::s_info = { "WebTransportBidirectionalStream"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebTransportBidirectionalStreamDOMConstructor) };

template<> JSValue JSWebTransportBidirectionalStreamDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebTransportBidirectionalStreamDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "WebTransportBidirectionalStream"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWebTransportBidirectionalStream::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSWebTransportBidirectionalStreamPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWebTransportBidirectionalStreamConstructor, 0 } },
    { "readable"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebTransportBidirectionalStream_readable, 0 } },
    { "writable"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebTransportBidirectionalStream_writable, 0 } },
};

const ClassInfo JSWebTransportBidirectionalStreamPrototype::s_info = { "WebTransportBidirectionalStream"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebTransportBidirectionalStreamPrototype) };

void JSWebTransportBidirectionalStreamPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebTransportBidirectionalStream::info(), JSWebTransportBidirectionalStreamPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebTransportBidirectionalStream::s_info = { "WebTransportBidirectionalStream"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebTransportBidirectionalStream) };

JSWebTransportBidirectionalStream::JSWebTransportBidirectionalStream(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebTransportBidirectionalStream>&& impl)
    : JSDOMWrapper<WebTransportBidirectionalStream>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebTransportBidirectionalStream>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebTransportBidirectionalStream::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebTransportBidirectionalStreamPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebTransportBidirectionalStreamPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebTransportBidirectionalStream::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebTransportBidirectionalStream>(vm, globalObject);
}

JSValue JSWebTransportBidirectionalStream::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebTransportBidirectionalStreamDOMConstructor, DOMConstructorID::WebTransportBidirectionalStream>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebTransportBidirectionalStream::destroy(JSC::JSCell* cell)
{
    JSWebTransportBidirectionalStream* thisObject = static_cast<JSWebTransportBidirectionalStream*>(cell);
    thisObject->JSWebTransportBidirectionalStream::~JSWebTransportBidirectionalStream();
}

JSC_DEFINE_CUSTOM_GETTER(jsWebTransportBidirectionalStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebTransportBidirectionalStreamPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebTransportBidirectionalStream::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsWebTransportBidirectionalStream_readableGetter(JSGlobalObject& lexicalGlobalObject, JSWebTransportBidirectionalStream& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<WebTransportReceiveStream>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.readable())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebTransportBidirectionalStream_readable, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebTransportBidirectionalStream>::get<jsWebTransportBidirectionalStream_readableGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebTransportBidirectionalStream_writableGetter(JSGlobalObject& lexicalGlobalObject, JSWebTransportBidirectionalStream& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<WebTransportSendStream>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.writable())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebTransportBidirectionalStream_writable, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebTransportBidirectionalStream>::get<jsWebTransportBidirectionalStream_writableGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSWebTransportBidirectionalStream::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebTransportBidirectionalStream, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebTransportBidirectionalStream.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebTransportBidirectionalStream = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebTransportBidirectionalStream.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebTransportBidirectionalStream = std::forward<decltype(space)>(space); }
    );
}

void JSWebTransportBidirectionalStream::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebTransportBidirectionalStream*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebTransportBidirectionalStreamOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebTransportBidirectionalStreamOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebTransportBidirectionalStream = static_cast<JSWebTransportBidirectionalStream*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebTransportBidirectionalStream->wrapped(), jsWebTransportBidirectionalStream);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebTransportBidirectionalStream@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore31WebTransportBidirectionalStreamE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebTransportBidirectionalStream>&& impl)
{

    if constexpr (std::is_polymorphic_v<WebTransportBidirectionalStream>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebTransportBidirectionalStream@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore31WebTransportBidirectionalStreamE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebTransportBidirectionalStream has subclasses. If WebTransportBidirectionalStream has subclasses that get passed
        // to toJS() we currently require WebTransportBidirectionalStream you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<WebTransportBidirectionalStream>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebTransportBidirectionalStream& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebTransportBidirectionalStream* JSWebTransportBidirectionalStream::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebTransportBidirectionalStream*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
