/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebTransport.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSReadableStream.h"
#include "JSWebTransportBidirectionalStream.h"
#include "JSWebTransportCloseInfo.h"
#include "JSWebTransportCongestionControl.h"
#include "JSWebTransportDatagramDuplexStream.h"
#include "JSWebTransportOptions.h"
#include "JSWebTransportReliabilityMode.h"
#include "JSWebTransportSendStream.h"
#include "JSWebTransportSendStreamOptions.h"
#include "JSWebTransportStats.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsWebTransportPrototypeFunction_getStats);
static JSC_DECLARE_HOST_FUNCTION(jsWebTransportPrototypeFunction_close);
static JSC_DECLARE_HOST_FUNCTION(jsWebTransportPrototypeFunction_createBidirectionalStream);
static JSC_DECLARE_HOST_FUNCTION(jsWebTransportPrototypeFunction_createUnidirectionalStream);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWebTransportConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWebTransport_ready);
static JSC_DECLARE_CUSTOM_GETTER(jsWebTransport_reliability);
static JSC_DECLARE_CUSTOM_GETTER(jsWebTransport_congestionControl);
static JSC_DECLARE_CUSTOM_GETTER(jsWebTransport_closed);
static JSC_DECLARE_CUSTOM_GETTER(jsWebTransport_draining);
static JSC_DECLARE_CUSTOM_GETTER(jsWebTransport_datagrams);
static JSC_DECLARE_CUSTOM_GETTER(jsWebTransport_incomingBidirectionalStreams);
static JSC_DECLARE_CUSTOM_GETTER(jsWebTransport_incomingUnidirectionalStreams);

class JSWebTransportPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebTransportPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebTransportPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebTransportPrototype>(vm)) JSWebTransportPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebTransportPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebTransportPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebTransportPrototype, JSWebTransportPrototype::Base);

using JSWebTransportDOMConstructor = JSDOMConstructor<JSWebTransport>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSWebTransportDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSWebTransportDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "WebTransport");
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto url = convert<IDLUSVString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto options = convert<IDLDictionary<WebTransportOptions>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = WebTransport::create(*context, WTFMove(url), WTFMove(options));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<WebTransport>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<WebTransport>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSWebTransportDOMConstructorConstruct, JSWebTransportDOMConstructor::construct);

template<> const ClassInfo JSWebTransportDOMConstructor::s_info = { "WebTransport"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebTransportDOMConstructor) };

template<> JSValue JSWebTransportDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebTransportDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "WebTransport"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWebTransport::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSWebTransportPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWebTransportConstructor, 0 } },
    { "ready"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebTransport_ready, 0 } },
    { "reliability"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebTransport_reliability, 0 } },
    { "congestionControl"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebTransport_congestionControl, 0 } },
    { "closed"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebTransport_closed, 0 } },
    { "draining"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebTransport_draining, 0 } },
    { "datagrams"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebTransport_datagrams, 0 } },
    { "incomingBidirectionalStreams"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebTransport_incomingBidirectionalStreams, 0 } },
    { "incomingUnidirectionalStreams"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebTransport_incomingUnidirectionalStreams, 0 } },
    { "getStats"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebTransportPrototypeFunction_getStats, 0 } },
    { "close"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebTransportPrototypeFunction_close, 0 } },
    { "createBidirectionalStream"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebTransportPrototypeFunction_createBidirectionalStream, 0 } },
    { "createUnidirectionalStream"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebTransportPrototypeFunction_createUnidirectionalStream, 0 } },
};

const ClassInfo JSWebTransportPrototype::s_info = { "WebTransport"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebTransportPrototype) };

void JSWebTransportPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebTransport::info(), JSWebTransportPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebTransport::s_info = { "WebTransport"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebTransport) };

JSWebTransport::JSWebTransport(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebTransport>&& impl)
    : JSDOMWrapper<WebTransport>(structure, globalObject, WTFMove(impl))
{
}

static_assert(std::is_base_of<ActiveDOMObject, WebTransport>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSWebTransport::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebTransportPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebTransportPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebTransport::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebTransport>(vm, globalObject);
}

JSValue JSWebTransport::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebTransportDOMConstructor, DOMConstructorID::WebTransport>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebTransport::destroy(JSC::JSCell* cell)
{
    JSWebTransport* thisObject = static_cast<JSWebTransport*>(cell);
    thisObject->JSWebTransport::~JSWebTransport();
}

JSC_DEFINE_CUSTOM_GETTER(jsWebTransportConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebTransportPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebTransport::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsWebTransport_readyGetter(JSGlobalObject& lexicalGlobalObject, JSWebTransport& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLPromise<IDLUndefined>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, [&]() -> decltype(auto) { return impl.ready(); })));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebTransport_ready, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebTransport>::get<jsWebTransport_readyGetter, CastedThisErrorBehavior::RejectPromise>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebTransport_reliabilityGetter(JSGlobalObject& lexicalGlobalObject, JSWebTransport& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<WebTransportReliabilityMode>>(lexicalGlobalObject, throwScope, impl.reliability())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebTransport_reliability, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebTransport>::get<jsWebTransport_reliabilityGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebTransport_congestionControlGetter(JSGlobalObject& lexicalGlobalObject, JSWebTransport& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<WebTransportCongestionControl>>(lexicalGlobalObject, throwScope, impl.congestionControl())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebTransport_congestionControl, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebTransport>::get<jsWebTransport_congestionControlGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebTransport_closedGetter(JSGlobalObject& lexicalGlobalObject, JSWebTransport& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLPromise<IDLDictionary<WebTransportCloseInfo>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, [&]() -> decltype(auto) { return impl.closed(); })));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebTransport_closed, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebTransport>::get<jsWebTransport_closedGetter, CastedThisErrorBehavior::RejectPromise>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebTransport_drainingGetter(JSGlobalObject& lexicalGlobalObject, JSWebTransport& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLPromise<IDLUndefined>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, [&]() -> decltype(auto) { return impl.draining(); })));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebTransport_draining, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebTransport>::get<jsWebTransport_drainingGetter, CastedThisErrorBehavior::RejectPromise>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebTransport_datagramsGetter(JSGlobalObject& lexicalGlobalObject, JSWebTransport& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<WebTransportDatagramDuplexStream>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.datagrams())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebTransport_datagrams, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebTransport>::get<jsWebTransport_datagramsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebTransport_incomingBidirectionalStreamsGetter(JSGlobalObject& lexicalGlobalObject, JSWebTransport& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<ReadableStream>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.incomingBidirectionalStreams())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebTransport_incomingBidirectionalStreams, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebTransport>::get<jsWebTransport_incomingBidirectionalStreamsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebTransport_incomingUnidirectionalStreamsGetter(JSGlobalObject& lexicalGlobalObject, JSWebTransport& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<ReadableStream>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.incomingUnidirectionalStreams())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebTransport_incomingUnidirectionalStreams, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebTransport>::get<jsWebTransport_incomingUnidirectionalStreamsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsWebTransportPrototypeFunction_getStatsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSWebTransport>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLDictionary<WebTransportStats>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.getStats(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebTransportPrototypeFunction_getStats, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSWebTransport>::call<jsWebTransportPrototypeFunction_getStatsBody>(*lexicalGlobalObject, *callFrame, "getStats");
}

static inline JSC::EncodedJSValue jsWebTransportPrototypeFunction_closeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebTransport>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto closeInfo = convert<IDLDictionary<WebTransportCloseInfo>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.close(WTFMove(closeInfo)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebTransportPrototypeFunction_close, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebTransport>::call<jsWebTransportPrototypeFunction_closeBody>(*lexicalGlobalObject, *callFrame, "close");
}

static inline JSC::EncodedJSValue jsWebTransportPrototypeFunction_createBidirectionalStreamBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSWebTransport>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto options = convert<IDLDictionary<WebTransportSendStreamOptions>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLInterface<WebTransportBidirectionalStream>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.createBidirectionalStream(*context, WTFMove(options), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebTransportPrototypeFunction_createBidirectionalStream, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSWebTransport>::call<jsWebTransportPrototypeFunction_createBidirectionalStreamBody>(*lexicalGlobalObject, *callFrame, "createBidirectionalStream");
}

static inline JSC::EncodedJSValue jsWebTransportPrototypeFunction_createUnidirectionalStreamBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSWebTransport>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto options = convert<IDLDictionary<WebTransportSendStreamOptions>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLInterface<WebTransportSendStream>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.createUnidirectionalStream(*context, WTFMove(options), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebTransportPrototypeFunction_createUnidirectionalStream, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSWebTransport>::call<jsWebTransportPrototypeFunction_createUnidirectionalStreamBody>(*lexicalGlobalObject, *callFrame, "createUnidirectionalStream");
}

JSC::GCClient::IsoSubspace* JSWebTransport::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebTransport, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebTransport.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebTransport = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebTransport.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebTransport = std::forward<decltype(space)>(space); }
    );
}

void JSWebTransport::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebTransport*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebTransportOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsWebTransport = jsCast<JSWebTransport*>(handle.slot()->asCell());
    auto& wrapped = jsWebTransport->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebTransportOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebTransport = static_cast<JSWebTransport*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebTransport->wrapped(), jsWebTransport);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebTransport@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12WebTransportE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebTransport>&& impl)
{

    if constexpr (std::is_polymorphic_v<WebTransport>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebTransport@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore12WebTransportE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebTransport has subclasses. If WebTransport has subclasses that get passed
        // to toJS() we currently require WebTransport you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<WebTransport>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebTransport& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebTransport* JSWebTransport::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebTransport*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
