/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebLockGrantedCallback.h"

#include "ContextDestructionObserverInlines.h"
#include "DOMPromiseProxy.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSWebLock.h"
#include "ScriptExecutionContext.h"


namespace WebCore {
using namespace JSC;

JSWebLockGrantedCallback::JSWebLockGrantedCallback(JSObject* callback, JSDOMGlobalObject* globalObject)
    : WebLockGrantedCallback(globalObject->scriptExecutionContext())
    , m_data(new JSCallbackDataStrong(callback, globalObject, this))
{
}

JSWebLockGrantedCallback::~JSWebLockGrantedCallback()
{
    ScriptExecutionContext* context = scriptExecutionContext();
    // When the context is destroyed, all tasks with a reference to a callback
    // should be deleted. So if the context is 0, we are on the context thread.
    if (!context || context->isContextThread())
        delete m_data;
    else
        context->postTask(DeleteCallbackDataTask(m_data));
#ifndef NDEBUG
    m_data = nullptr;
#endif
}

CallbackResult<typename IDLPromise<IDLAny>::ImplementationType> JSWebLockGrantedCallback::handleEvent(typename IDLNullable<IDLInterface<WebLock>>::ParameterType webLock)
{
    if (!canInvokeCallback())
        return CallbackResultType::UnableToExecute;

    Ref<JSWebLockGrantedCallback> protectedThis(*this);

    auto& globalObject = *m_data->globalObject();
    auto& vm = globalObject.vm();

    JSLockHolder lock(vm);
    auto& lexicalGlobalObject = globalObject;
    JSValue thisValue = jsUndefined();
    MarkedArgumentBuffer args;
    args.append(toJS<IDLNullable<IDLInterface<WebLock>>>(lexicalGlobalObject, globalObject, webLock));
    ASSERT(!args.hasOverflowed());

    NakedPtr<JSC::Exception> returnedException;
    auto jsResult = m_data->invokeCallback(thisValue, args, JSCallbackData::CallbackType::Function, Identifier(), returnedException);
    if (returnedException) {
        auto throwScope = DECLARE_THROW_SCOPE(vm);
        throwException(&lexicalGlobalObject, throwScope, returnedException);
        return CallbackResultType::ExceptionThrown;
     }

    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto returnValue = convert<IDLPromise<IDLAny>>(lexicalGlobalObject, jsResult);
    RETURN_IF_EXCEPTION(throwScope, CallbackResultType::ExceptionThrown);
    return { WTFMove(returnValue) };
}

JSC::JSValue toJS(WebLockGrantedCallback& impl)
{
    if (!static_cast<JSWebLockGrantedCallback&>(impl).callbackData())
        return jsNull();

    return static_cast<JSWebLockGrantedCallback&>(impl).callbackData()->callback();
}

} // namespace WebCore
