/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_CODECS)

#include "JSWebCodecsVideoFrame.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSCSSStyleImageValue.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMRectInit.h"
#include "JSDOMRectReadOnly.h"
#include "JSDOMWrapperCache.h"
#include "JSHTMLCanvasElement.h"
#include "JSHTMLImageElement.h"
#include "JSHTMLVideoElement.h"
#include "JSImageBitmap.h"
#include "JSPlaneLayout.h"
#include "JSSVGImageElement.h"
#include "JSVideoColorSpace.h"
#include "JSVideoColorSpaceInit.h"
#include "JSVideoPixelFormat.h"
#include "JSWebCodecsAlphaOption.h"
#include "JSWebCodecsVideoFrame.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_CODECS)

template<> WebCodecsVideoFrame::Init convertDictionary<WebCodecsVideoFrame::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    WebCodecsVideoFrame::Init result;
    JSValue alphaValue;
    if (isNullOrUndefined)
        alphaValue = jsUndefined();
    else {
        alphaValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "alpha"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!alphaValue.isUndefined()) {
        result.alpha = convert<IDLEnumeration<WebCodecsAlphaOption>>(lexicalGlobalObject, alphaValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue displayHeightValue;
    if (isNullOrUndefined)
        displayHeightValue = jsUndefined();
    else {
        displayHeightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "displayHeight"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!displayHeightValue.isUndefined()) {
        result.displayHeight = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, displayHeightValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue displayWidthValue;
    if (isNullOrUndefined)
        displayWidthValue = jsUndefined();
    else {
        displayWidthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "displayWidth"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!displayWidthValue.isUndefined()) {
        result.displayWidth = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, displayWidthValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue durationValue;
    if (isNullOrUndefined)
        durationValue = jsUndefined();
    else {
        durationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "duration"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!durationValue.isUndefined()) {
        result.duration = convert<IDLUnsignedLongLong>(lexicalGlobalObject, durationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue timestampValue;
    if (isNullOrUndefined)
        timestampValue = jsUndefined();
    else {
        timestampValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "timestamp"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!timestampValue.isUndefined()) {
        result.timestamp = convert<IDLLongLong>(lexicalGlobalObject, timestampValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue visibleRectValue;
    if (isNullOrUndefined)
        visibleRectValue = jsUndefined();
    else {
        visibleRectValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "visibleRect"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!visibleRectValue.isUndefined()) {
        result.visibleRect = convert<IDLDictionary<DOMRectInit>>(lexicalGlobalObject, visibleRectValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

#endif

#if ENABLE(WEB_CODECS)

template<> WebCodecsVideoFrame::BufferInit convertDictionary<WebCodecsVideoFrame::BufferInit>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    WebCodecsVideoFrame::BufferInit result;
    JSValue codedHeightValue;
    if (isNullOrUndefined)
        codedHeightValue = jsUndefined();
    else {
        codedHeightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "codedHeight"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!codedHeightValue.isUndefined()) {
        result.codedHeight = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, codedHeightValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "codedHeight", "VideoFrameBufferInit", "unsigned long");
        return { };
    }
    JSValue codedWidthValue;
    if (isNullOrUndefined)
        codedWidthValue = jsUndefined();
    else {
        codedWidthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "codedWidth"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!codedWidthValue.isUndefined()) {
        result.codedWidth = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, codedWidthValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "codedWidth", "VideoFrameBufferInit", "unsigned long");
        return { };
    }
    JSValue colorSpaceValue;
    if (isNullOrUndefined)
        colorSpaceValue = jsUndefined();
    else {
        colorSpaceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "colorSpace"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!colorSpaceValue.isUndefined()) {
        result.colorSpace = convert<IDLDictionary<VideoColorSpaceInit>>(lexicalGlobalObject, colorSpaceValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue displayHeightValue;
    if (isNullOrUndefined)
        displayHeightValue = jsUndefined();
    else {
        displayHeightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "displayHeight"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!displayHeightValue.isUndefined()) {
        result.displayHeight = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, displayHeightValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue displayWidthValue;
    if (isNullOrUndefined)
        displayWidthValue = jsUndefined();
    else {
        displayWidthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "displayWidth"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!displayWidthValue.isUndefined()) {
        result.displayWidth = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, displayWidthValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue durationValue;
    if (isNullOrUndefined)
        durationValue = jsUndefined();
    else {
        durationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "duration"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!durationValue.isUndefined()) {
        result.duration = convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, durationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue formatValue;
    if (isNullOrUndefined)
        formatValue = jsUndefined();
    else {
        formatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "format"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!formatValue.isUndefined()) {
        result.format = convert<IDLEnumeration<VideoPixelFormat>>(lexicalGlobalObject, formatValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "format", "VideoFrameBufferInit", "VideoPixelFormat");
        return { };
    }
    JSValue layoutValue;
    if (isNullOrUndefined)
        layoutValue = jsUndefined();
    else {
        layoutValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "layout"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!layoutValue.isUndefined()) {
        result.layout = convert<IDLSequence<IDLDictionary<PlaneLayout>>>(lexicalGlobalObject, layoutValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue timestampValue;
    if (isNullOrUndefined)
        timestampValue = jsUndefined();
    else {
        timestampValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "timestamp"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!timestampValue.isUndefined()) {
        result.timestamp = convert<IDLEnforceRangeAdaptor<IDLLongLong>>(lexicalGlobalObject, timestampValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "timestamp", "VideoFrameBufferInit", "long long");
        return { };
    }
    JSValue visibleRectValue;
    if (isNullOrUndefined)
        visibleRectValue = jsUndefined();
    else {
        visibleRectValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "visibleRect"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!visibleRectValue.isUndefined()) {
        result.visibleRect = convert<IDLDictionary<DOMRectInit>>(lexicalGlobalObject, visibleRectValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

#endif

#if ENABLE(WEB_CODECS)

template<> WebCodecsVideoFrame::CopyToOptions convertDictionary<WebCodecsVideoFrame::CopyToOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    WebCodecsVideoFrame::CopyToOptions result;
    JSValue layoutValue;
    if (isNullOrUndefined)
        layoutValue = jsUndefined();
    else {
        layoutValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "layout"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!layoutValue.isUndefined()) {
        result.layout = convert<IDLSequence<IDLDictionary<PlaneLayout>>>(lexicalGlobalObject, layoutValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue rectValue;
    if (isNullOrUndefined)
        rectValue = jsUndefined();
    else {
        rectValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "rect"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!rectValue.isUndefined()) {
        result.rect = convert<IDLDictionary<DOMRectInit>>(lexicalGlobalObject, rectValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

#endif

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsWebCodecsVideoFramePrototypeFunction_allocationSize);
static JSC_DECLARE_HOST_FUNCTION(jsWebCodecsVideoFramePrototypeFunction_copyTo);
static JSC_DECLARE_HOST_FUNCTION(jsWebCodecsVideoFramePrototypeFunction_clone);
static JSC_DECLARE_HOST_FUNCTION(jsWebCodecsVideoFramePrototypeFunction_close);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsVideoFrameConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsVideoFrame_format);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsVideoFrame_codedWidth);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsVideoFrame_codedHeight);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsVideoFrame_codedRect);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsVideoFrame_visibleRect);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsVideoFrame_displayWidth);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsVideoFrame_displayHeight);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsVideoFrame_duration);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsVideoFrame_timestamp);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsVideoFrame_colorSpace);

class JSWebCodecsVideoFramePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebCodecsVideoFramePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebCodecsVideoFramePrototype* ptr = new (NotNull, JSC::allocateCell<JSWebCodecsVideoFramePrototype>(vm)) JSWebCodecsVideoFramePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebCodecsVideoFramePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebCodecsVideoFramePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebCodecsVideoFramePrototype, JSWebCodecsVideoFramePrototype::Base);

using JSWebCodecsVideoFrameDOMConstructor = JSDOMConstructor<JSWebCodecsVideoFrame>;

static inline EncodedJSValue constructJSWebCodecsVideoFrame1(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSWebCodecsVideoFrameDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "VideoFrame");
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto image = convert<IDLUnion<IDLInterface<HTMLImageElement>, IDLInterface<SVGImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<ImageBitmap>, IDLInterface<CSSStyleImageValue>, IDLInterface<HTMLVideoElement>>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto init = convert<IDLDictionary<WebCodecsVideoFrame::Init>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = WebCodecsVideoFrame::create(*context, WTFMove(image), WTFMove(init));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<WebCodecsVideoFrame>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<WebCodecsVideoFrame>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}

static inline EncodedJSValue constructJSWebCodecsVideoFrame2(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSWebCodecsVideoFrameDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "VideoFrame");
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto image = convert<IDLInterface<WebCodecsVideoFrame>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "image", "VideoFrame", nullptr, "WebCodecsVideoFrame"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto init = convert<IDLDictionary<WebCodecsVideoFrame::Init>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = WebCodecsVideoFrame::create(*context, *image, WTFMove(init));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<WebCodecsVideoFrame>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<WebCodecsVideoFrame>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}

static inline EncodedJSValue constructJSWebCodecsVideoFrame3(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSWebCodecsVideoFrameDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "VideoFrame");
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto data = convert<IDLAllowSharedAdaptor<IDLUnion<IDLArrayBufferView, IDLArrayBuffer>>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto init = convert<IDLDictionary<WebCodecsVideoFrame::BufferInit>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = WebCodecsVideoFrame::create(*context, WTFMove(data), WTFMove(init));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<WebCodecsVideoFrame>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<WebCodecsVideoFrame>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSWebCodecsVideoFrameDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSHTMLImageElement>())
            RELEASE_AND_RETURN(throwScope, (constructJSWebCodecsVideoFrame1(lexicalGlobalObject, callFrame)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSSVGImageElement>())
            RELEASE_AND_RETURN(throwScope, (constructJSWebCodecsVideoFrame1(lexicalGlobalObject, callFrame)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSHTMLCanvasElement>())
            RELEASE_AND_RETURN(throwScope, (constructJSWebCodecsVideoFrame1(lexicalGlobalObject, callFrame)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSImageBitmap>())
            RELEASE_AND_RETURN(throwScope, (constructJSWebCodecsVideoFrame1(lexicalGlobalObject, callFrame)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSCSSStyleImageValue>())
            RELEASE_AND_RETURN(throwScope, (constructJSWebCodecsVideoFrame1(lexicalGlobalObject, callFrame)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSHTMLVideoElement>())
            RELEASE_AND_RETURN(throwScope, (constructJSWebCodecsVideoFrame1(lexicalGlobalObject, callFrame)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSWebCodecsVideoFrame>())
            RELEASE_AND_RETURN(throwScope, (constructJSWebCodecsVideoFrame2(lexicalGlobalObject, callFrame)));
    }
    if (argsCount == 2) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSHTMLImageElement>())
            RELEASE_AND_RETURN(throwScope, (constructJSWebCodecsVideoFrame1(lexicalGlobalObject, callFrame)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSSVGImageElement>())
            RELEASE_AND_RETURN(throwScope, (constructJSWebCodecsVideoFrame1(lexicalGlobalObject, callFrame)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSHTMLCanvasElement>())
            RELEASE_AND_RETURN(throwScope, (constructJSWebCodecsVideoFrame1(lexicalGlobalObject, callFrame)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSImageBitmap>())
            RELEASE_AND_RETURN(throwScope, (constructJSWebCodecsVideoFrame1(lexicalGlobalObject, callFrame)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSCSSStyleImageValue>())
            RELEASE_AND_RETURN(throwScope, (constructJSWebCodecsVideoFrame1(lexicalGlobalObject, callFrame)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSHTMLVideoElement>())
            RELEASE_AND_RETURN(throwScope, (constructJSWebCodecsVideoFrame1(lexicalGlobalObject, callFrame)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSWebCodecsVideoFrame>())
            RELEASE_AND_RETURN(throwScope, (constructJSWebCodecsVideoFrame2(lexicalGlobalObject, callFrame)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSArrayBufferView>())
            RELEASE_AND_RETURN(throwScope, (constructJSWebCodecsVideoFrame3(lexicalGlobalObject, callFrame)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSArrayBuffer>())
            RELEASE_AND_RETURN(throwScope, (constructJSWebCodecsVideoFrame3(lexicalGlobalObject, callFrame)));
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}
JSC_ANNOTATE_HOST_FUNCTION(JSWebCodecsVideoFrameConstructorConstruct, JSWebCodecsVideoFrameDOMConstructor::construct);

template<> const ClassInfo JSWebCodecsVideoFrameDOMConstructor::s_info = { "VideoFrame"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebCodecsVideoFrameDOMConstructor) };

template<> JSValue JSWebCodecsVideoFrameDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebCodecsVideoFrameDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "VideoFrame"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWebCodecsVideoFrame::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSWebCodecsVideoFramePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsVideoFrameConstructor, 0 } },
    { "format"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsVideoFrame_format, 0 } },
    { "codedWidth"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsVideoFrame_codedWidth, 0 } },
    { "codedHeight"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsVideoFrame_codedHeight, 0 } },
    { "codedRect"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsVideoFrame_codedRect, 0 } },
    { "visibleRect"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsVideoFrame_visibleRect, 0 } },
    { "displayWidth"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsVideoFrame_displayWidth, 0 } },
    { "displayHeight"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsVideoFrame_displayHeight, 0 } },
    { "duration"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsVideoFrame_duration, 0 } },
    { "timestamp"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsVideoFrame_timestamp, 0 } },
    { "colorSpace"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsVideoFrame_colorSpace, 0 } },
    { "allocationSize"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebCodecsVideoFramePrototypeFunction_allocationSize, 0 } },
    { "copyTo"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebCodecsVideoFramePrototypeFunction_copyTo, 1 } },
    { "clone"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebCodecsVideoFramePrototypeFunction_clone, 0 } },
    { "close"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebCodecsVideoFramePrototypeFunction_close, 0 } },
};

const ClassInfo JSWebCodecsVideoFramePrototype::s_info = { "VideoFrame"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebCodecsVideoFramePrototype) };

void JSWebCodecsVideoFramePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebCodecsVideoFrame::info(), JSWebCodecsVideoFramePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebCodecsVideoFrame::s_info = { "VideoFrame"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebCodecsVideoFrame) };

JSWebCodecsVideoFrame::JSWebCodecsVideoFrame(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebCodecsVideoFrame>&& impl)
    : JSDOMWrapper<WebCodecsVideoFrame>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebCodecsVideoFrame>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

void JSWebCodecsVideoFrame::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(info()));

    vm.heap.reportExtraMemoryAllocated(this, wrapped().memoryCost());
}

JSObject* JSWebCodecsVideoFrame::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebCodecsVideoFramePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebCodecsVideoFramePrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebCodecsVideoFrame::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebCodecsVideoFrame>(vm, globalObject);
}

JSValue JSWebCodecsVideoFrame::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebCodecsVideoFrameDOMConstructor, DOMConstructorID::WebCodecsVideoFrame>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebCodecsVideoFrame::destroy(JSC::JSCell* cell)
{
    JSWebCodecsVideoFrame* thisObject = static_cast<JSWebCodecsVideoFrame*>(cell);
    thisObject->JSWebCodecsVideoFrame::~JSWebCodecsVideoFrame();
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsVideoFrameConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebCodecsVideoFramePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebCodecsVideoFrame::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsWebCodecsVideoFrame_formatGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsVideoFrame& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLEnumeration<VideoPixelFormat>>>(lexicalGlobalObject, throwScope, impl.format())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsVideoFrame_format, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsVideoFrame>::get<jsWebCodecsVideoFrame_formatGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebCodecsVideoFrame_codedWidthGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsVideoFrame& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.codedWidth())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsVideoFrame_codedWidth, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsVideoFrame>::get<jsWebCodecsVideoFrame_codedWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebCodecsVideoFrame_codedHeightGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsVideoFrame& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.codedHeight())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsVideoFrame_codedHeight, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsVideoFrame>::get<jsWebCodecsVideoFrame_codedHeightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebCodecsVideoFrame_codedRectGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsVideoFrame& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<DOMRectReadOnly>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.codedRect())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsVideoFrame_codedRect, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsVideoFrame>::get<jsWebCodecsVideoFrame_codedRectGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebCodecsVideoFrame_visibleRectGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsVideoFrame& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<DOMRectReadOnly>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.visibleRect())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsVideoFrame_visibleRect, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsVideoFrame>::get<jsWebCodecsVideoFrame_visibleRectGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebCodecsVideoFrame_displayWidthGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsVideoFrame& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.displayWidth())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsVideoFrame_displayWidth, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsVideoFrame>::get<jsWebCodecsVideoFrame_displayWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebCodecsVideoFrame_displayHeightGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsVideoFrame& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.displayHeight())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsVideoFrame_displayHeight, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsVideoFrame>::get<jsWebCodecsVideoFrame_displayHeightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebCodecsVideoFrame_durationGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsVideoFrame& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUnsignedLongLong>>(lexicalGlobalObject, throwScope, impl.duration())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsVideoFrame_duration, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsVideoFrame>::get<jsWebCodecsVideoFrame_durationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebCodecsVideoFrame_timestampGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsVideoFrame& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLongLong>(lexicalGlobalObject, throwScope, impl.timestamp())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsVideoFrame_timestamp, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsVideoFrame>::get<jsWebCodecsVideoFrame_timestampGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebCodecsVideoFrame_colorSpaceGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsVideoFrame& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<VideoColorSpace>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.colorSpace())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsVideoFrame_colorSpace, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsVideoFrame>::get<jsWebCodecsVideoFrame_colorSpaceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsWebCodecsVideoFramePrototypeFunction_allocationSizeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebCodecsVideoFrame>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto options = convert<IDLDictionary<WebCodecsVideoFrame::CopyToOptions>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUnsignedLong>(*lexicalGlobalObject, throwScope, impl.allocationSize(WTFMove(options)))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebCodecsVideoFramePrototypeFunction_allocationSize, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebCodecsVideoFrame>::call<jsWebCodecsVideoFramePrototypeFunction_allocationSizeBody>(*lexicalGlobalObject, *callFrame, "allocationSize");
}

static inline JSC::EncodedJSValue jsWebCodecsVideoFramePrototypeFunction_copyToBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSWebCodecsVideoFrame>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto destination = convert<IDLAllowSharedAdaptor<IDLUnion<IDLArrayBufferView, IDLArrayBuffer>>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto options = convert<IDLDictionary<WebCodecsVideoFrame::CopyToOptions>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLSequence<IDLDictionary<PlaneLayout>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.copyTo(WTFMove(destination), WTFMove(options), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebCodecsVideoFramePrototypeFunction_copyTo, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSWebCodecsVideoFrame>::call<jsWebCodecsVideoFramePrototypeFunction_copyToBody>(*lexicalGlobalObject, *callFrame, "copyTo");
}

static inline JSC::EncodedJSValue jsWebCodecsVideoFramePrototypeFunction_cloneBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebCodecsVideoFrame>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<WebCodecsVideoFrame>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.clone(*context))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebCodecsVideoFramePrototypeFunction_clone, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebCodecsVideoFrame>::call<jsWebCodecsVideoFramePrototypeFunction_cloneBody>(*lexicalGlobalObject, *callFrame, "clone");
}

static inline JSC::EncodedJSValue jsWebCodecsVideoFramePrototypeFunction_closeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebCodecsVideoFrame>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.close(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebCodecsVideoFramePrototypeFunction_close, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebCodecsVideoFrame>::call<jsWebCodecsVideoFramePrototypeFunction_closeBody>(*lexicalGlobalObject, *callFrame, "close");
}

JSC::GCClient::IsoSubspace* JSWebCodecsVideoFrame::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebCodecsVideoFrame, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebCodecsVideoFrame.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebCodecsVideoFrame = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebCodecsVideoFrame.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebCodecsVideoFrame = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSWebCodecsVideoFrame::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSWebCodecsVideoFrame*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    visitor.reportExtraMemoryVisited(thisObject->wrapped().memoryCost());
}

DEFINE_VISIT_CHILDREN(JSWebCodecsVideoFrame);

size_t JSWebCodecsVideoFrame::estimatedSize(JSCell* cell, VM& vm)
{
    auto* thisObject = jsCast<JSWebCodecsVideoFrame*>(cell);
    return Base::estimatedSize(thisObject, vm) + thisObject->wrapped().memoryCost();
}

void JSWebCodecsVideoFrame::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebCodecsVideoFrame*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebCodecsVideoFrameOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebCodecsVideoFrameOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebCodecsVideoFrame = static_cast<JSWebCodecsVideoFrame*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebCodecsVideoFrame->wrapped(), jsWebCodecsVideoFrame);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebCodecsVideoFrame@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore19WebCodecsVideoFrameE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebCodecsVideoFrame>&& impl)
{

    if constexpr (std::is_polymorphic_v<WebCodecsVideoFrame>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebCodecsVideoFrame@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore19WebCodecsVideoFrameE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebCodecsVideoFrame has subclasses. If WebCodecsVideoFrame has subclasses that get passed
        // to toJS() we currently require WebCodecsVideoFrame you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<WebCodecsVideoFrame>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebCodecsVideoFrame& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebCodecsVideoFrame* JSWebCodecsVideoFrame::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebCodecsVideoFrame*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_CODECS)
