/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_CODECS)

#include "JSWebCodecsAudioDecoderConfig.h"

#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <variant>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_CODECS)

template<> WebCodecsAudioDecoderConfig convertDictionary<WebCodecsAudioDecoderConfig>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    WebCodecsAudioDecoderConfig result;
    JSValue codecValue;
    if (isNullOrUndefined)
        codecValue = jsUndefined();
    else {
        codecValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "codec"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!codecValue.isUndefined()) {
        result.codec = convert<IDLDOMString>(lexicalGlobalObject, codecValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "codec", "WebCodecsAudioDecoderConfig", "DOMString");
        return { };
    }
    JSValue descriptionValue;
    if (isNullOrUndefined)
        descriptionValue = jsUndefined();
    else {
        descriptionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "description"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!descriptionValue.isUndefined()) {
        result.description = convert<IDLUnion<IDLArrayBufferView, IDLArrayBuffer>>(lexicalGlobalObject, descriptionValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue numberOfChannelsValue;
    if (isNullOrUndefined)
        numberOfChannelsValue = jsUndefined();
    else {
        numberOfChannelsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "numberOfChannels"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!numberOfChannelsValue.isUndefined()) {
        result.numberOfChannels = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, numberOfChannelsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "numberOfChannels", "WebCodecsAudioDecoderConfig", "unsigned long");
        return { };
    }
    JSValue sampleRateValue;
    if (isNullOrUndefined)
        sampleRateValue = jsUndefined();
    else {
        sampleRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sampleRate"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sampleRateValue.isUndefined()) {
        result.sampleRate = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, sampleRateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "sampleRate", "WebCodecsAudioDecoderConfig", "unsigned long");
        return { };
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const WebCodecsAudioDecoderConfig& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto codecValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, dictionary.codec);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "codec"_s), codecValue);
    if (!IDLUnion<IDLArrayBufferView, IDLArrayBuffer>::isNullValue(dictionary.description)) {
        auto descriptionValue = toJS<IDLUnion<IDLArrayBufferView, IDLArrayBuffer>>(lexicalGlobalObject, globalObject, throwScope, IDLUnion<IDLArrayBufferView, IDLArrayBuffer>::extractValueFromNullable(dictionary.description));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "description"_s), descriptionValue);
    }
    auto numberOfChannelsValue = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, throwScope, dictionary.numberOfChannels);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "numberOfChannels"_s), numberOfChannelsValue);
    auto sampleRateValue = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, throwScope, dictionary.sampleRate);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "sampleRate"_s), sampleRateValue);
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_CODECS)
