/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_CODECS)

#include "JSWebCodecsAudioData.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSAudioSampleFormat.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSWebCodecsAudioData.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_CODECS)

template<> WebCodecsAudioData::Init convertDictionary<WebCodecsAudioData::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    WebCodecsAudioData::Init result;
    JSValue dataValue;
    if (isNullOrUndefined)
        dataValue = jsUndefined();
    else {
        dataValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "data"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!dataValue.isUndefined()) {
        result.data = convert<IDLUnion<IDLArrayBufferView, IDLArrayBuffer>>(lexicalGlobalObject, dataValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "data", "AudioDataInit", "(ArrayBufferView or ArrayBuffer)");
        return { };
    }
    JSValue formatValue;
    if (isNullOrUndefined)
        formatValue = jsUndefined();
    else {
        formatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "format"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!formatValue.isUndefined()) {
        result.format = convert<IDLEnumeration<AudioSampleFormat>>(lexicalGlobalObject, formatValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "format", "AudioDataInit", "AudioSampleFormat");
        return { };
    }
    JSValue numberOfChannelsValue;
    if (isNullOrUndefined)
        numberOfChannelsValue = jsUndefined();
    else {
        numberOfChannelsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "numberOfChannels"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!numberOfChannelsValue.isUndefined()) {
        result.numberOfChannels = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, numberOfChannelsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "numberOfChannels", "AudioDataInit", "unsigned long");
        return { };
    }
    JSValue numberOfFramesValue;
    if (isNullOrUndefined)
        numberOfFramesValue = jsUndefined();
    else {
        numberOfFramesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "numberOfFrames"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!numberOfFramesValue.isUndefined()) {
        result.numberOfFrames = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, numberOfFramesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "numberOfFrames", "AudioDataInit", "unsigned long");
        return { };
    }
    JSValue sampleRateValue;
    if (isNullOrUndefined)
        sampleRateValue = jsUndefined();
    else {
        sampleRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sampleRate"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sampleRateValue.isUndefined()) {
        result.sampleRate = convert<IDLFloat>(lexicalGlobalObject, sampleRateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "sampleRate", "AudioDataInit", "float");
        return { };
    }
    JSValue timestampValue;
    if (isNullOrUndefined)
        timestampValue = jsUndefined();
    else {
        timestampValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "timestamp"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!timestampValue.isUndefined()) {
        result.timestamp = convert<IDLEnforceRangeAdaptor<IDLLongLong>>(lexicalGlobalObject, timestampValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "timestamp", "AudioDataInit", "long long");
        return { };
    }
    return result;
}

#endif

#if ENABLE(WEB_CODECS)

template<> WebCodecsAudioData::CopyToOptions convertDictionary<WebCodecsAudioData::CopyToOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    WebCodecsAudioData::CopyToOptions result;
    JSValue formatValue;
    if (isNullOrUndefined)
        formatValue = jsUndefined();
    else {
        formatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "format"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!formatValue.isUndefined()) {
        result.format = convert<IDLEnumeration<AudioSampleFormat>>(lexicalGlobalObject, formatValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue frameCountValue;
    if (isNullOrUndefined)
        frameCountValue = jsUndefined();
    else {
        frameCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "frameCount"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!frameCountValue.isUndefined()) {
        result.frameCount = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, frameCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue frameOffsetValue;
    if (isNullOrUndefined)
        frameOffsetValue = jsUndefined();
    else {
        frameOffsetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "frameOffset"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!frameOffsetValue.isUndefined()) {
        result.frameOffset = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, frameOffsetValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue planeIndexValue;
    if (isNullOrUndefined)
        planeIndexValue = jsUndefined();
    else {
        planeIndexValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "planeIndex"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!planeIndexValue.isUndefined()) {
        result.planeIndex = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, planeIndexValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

#endif

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsWebCodecsAudioDataPrototypeFunction_allocationSize);
static JSC_DECLARE_HOST_FUNCTION(jsWebCodecsAudioDataPrototypeFunction_copyTo);
static JSC_DECLARE_HOST_FUNCTION(jsWebCodecsAudioDataPrototypeFunction_clone);
static JSC_DECLARE_HOST_FUNCTION(jsWebCodecsAudioDataPrototypeFunction_close);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsAudioDataConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsAudioData_format);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsAudioData_sampleRate);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsAudioData_numberOfFrames);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsAudioData_numberOfChannels);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsAudioData_duration);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsAudioData_timestamp);

class JSWebCodecsAudioDataPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebCodecsAudioDataPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebCodecsAudioDataPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebCodecsAudioDataPrototype>(vm)) JSWebCodecsAudioDataPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebCodecsAudioDataPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebCodecsAudioDataPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebCodecsAudioDataPrototype, JSWebCodecsAudioDataPrototype::Base);

using JSWebCodecsAudioDataDOMConstructor = JSDOMConstructor<JSWebCodecsAudioData>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSWebCodecsAudioDataDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSWebCodecsAudioDataDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "AudioData");
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto init = convert<IDLDictionary<WebCodecsAudioData::Init>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = WebCodecsAudioData::create(*context, WTFMove(init));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<WebCodecsAudioData>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<WebCodecsAudioData>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSWebCodecsAudioDataDOMConstructorConstruct, JSWebCodecsAudioDataDOMConstructor::construct);

template<> const ClassInfo JSWebCodecsAudioDataDOMConstructor::s_info = { "AudioData"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebCodecsAudioDataDOMConstructor) };

template<> JSValue JSWebCodecsAudioDataDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebCodecsAudioDataDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "AudioData"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWebCodecsAudioData::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSWebCodecsAudioDataPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsAudioDataConstructor, 0 } },
    { "format"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsAudioData_format, 0 } },
    { "sampleRate"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsAudioData_sampleRate, 0 } },
    { "numberOfFrames"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsAudioData_numberOfFrames, 0 } },
    { "numberOfChannels"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsAudioData_numberOfChannels, 0 } },
    { "duration"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsAudioData_duration, 0 } },
    { "timestamp"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsAudioData_timestamp, 0 } },
    { "allocationSize"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebCodecsAudioDataPrototypeFunction_allocationSize, 0 } },
    { "copyTo"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebCodecsAudioDataPrototypeFunction_copyTo, 2 } },
    { "clone"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebCodecsAudioDataPrototypeFunction_clone, 0 } },
    { "close"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebCodecsAudioDataPrototypeFunction_close, 0 } },
};

const ClassInfo JSWebCodecsAudioDataPrototype::s_info = { "AudioData"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebCodecsAudioDataPrototype) };

void JSWebCodecsAudioDataPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebCodecsAudioData::info(), JSWebCodecsAudioDataPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebCodecsAudioData::s_info = { "AudioData"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebCodecsAudioData) };

JSWebCodecsAudioData::JSWebCodecsAudioData(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebCodecsAudioData>&& impl)
    : JSDOMWrapper<WebCodecsAudioData>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebCodecsAudioData>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

void JSWebCodecsAudioData::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(info()));

    vm.heap.reportExtraMemoryAllocated(this, wrapped().memoryCost());
}

JSObject* JSWebCodecsAudioData::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebCodecsAudioDataPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebCodecsAudioDataPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebCodecsAudioData::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebCodecsAudioData>(vm, globalObject);
}

JSValue JSWebCodecsAudioData::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebCodecsAudioDataDOMConstructor, DOMConstructorID::WebCodecsAudioData>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebCodecsAudioData::destroy(JSC::JSCell* cell)
{
    JSWebCodecsAudioData* thisObject = static_cast<JSWebCodecsAudioData*>(cell);
    thisObject->JSWebCodecsAudioData::~JSWebCodecsAudioData();
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsAudioDataConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebCodecsAudioDataPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebCodecsAudioData::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsWebCodecsAudioData_formatGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsAudioData& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLEnumeration<AudioSampleFormat>>>(lexicalGlobalObject, throwScope, impl.format())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsAudioData_format, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsAudioData>::get<jsWebCodecsAudioData_formatGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebCodecsAudioData_sampleRateGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsAudioData& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFloat>(lexicalGlobalObject, throwScope, impl.sampleRate())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsAudioData_sampleRate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsAudioData>::get<jsWebCodecsAudioData_sampleRateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebCodecsAudioData_numberOfFramesGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsAudioData& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.numberOfFrames())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsAudioData_numberOfFrames, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsAudioData>::get<jsWebCodecsAudioData_numberOfFramesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebCodecsAudioData_numberOfChannelsGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsAudioData& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.numberOfChannels())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsAudioData_numberOfChannels, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsAudioData>::get<jsWebCodecsAudioData_numberOfChannelsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebCodecsAudioData_durationGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsAudioData& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUnsignedLongLong>>(lexicalGlobalObject, throwScope, impl.duration())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsAudioData_duration, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsAudioData>::get<jsWebCodecsAudioData_durationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebCodecsAudioData_timestampGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsAudioData& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLongLong>(lexicalGlobalObject, throwScope, impl.timestamp())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsAudioData_timestamp, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsAudioData>::get<jsWebCodecsAudioData_timestampGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsWebCodecsAudioDataPrototypeFunction_allocationSizeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebCodecsAudioData>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto options = convert<IDLDictionary<WebCodecsAudioData::CopyToOptions>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUnsignedLong>(*lexicalGlobalObject, throwScope, impl.allocationSize(WTFMove(options)))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebCodecsAudioDataPrototypeFunction_allocationSize, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebCodecsAudioData>::call<jsWebCodecsAudioDataPrototypeFunction_allocationSizeBody>(*lexicalGlobalObject, *callFrame, "allocationSize");
}

static inline JSC::EncodedJSValue jsWebCodecsAudioDataPrototypeFunction_copyToBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebCodecsAudioData>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto destination = convert<IDLAllowSharedAdaptor<IDLUnion<IDLArrayBufferView, IDLArrayBuffer>>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto options = convert<IDLDictionary<WebCodecsAudioData::CopyToOptions>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.copyTo(WTFMove(destination), WTFMove(options)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebCodecsAudioDataPrototypeFunction_copyTo, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebCodecsAudioData>::call<jsWebCodecsAudioDataPrototypeFunction_copyToBody>(*lexicalGlobalObject, *callFrame, "copyTo");
}

static inline JSC::EncodedJSValue jsWebCodecsAudioDataPrototypeFunction_cloneBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebCodecsAudioData>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<WebCodecsAudioData>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.clone(*context))));
}

JSC_DEFINE_HOST_FUNCTION(jsWebCodecsAudioDataPrototypeFunction_clone, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebCodecsAudioData>::call<jsWebCodecsAudioDataPrototypeFunction_cloneBody>(*lexicalGlobalObject, *callFrame, "clone");
}

static inline JSC::EncodedJSValue jsWebCodecsAudioDataPrototypeFunction_closeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebCodecsAudioData>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.close(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebCodecsAudioDataPrototypeFunction_close, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebCodecsAudioData>::call<jsWebCodecsAudioDataPrototypeFunction_closeBody>(*lexicalGlobalObject, *callFrame, "close");
}

JSC::GCClient::IsoSubspace* JSWebCodecsAudioData::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebCodecsAudioData, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebCodecsAudioData.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebCodecsAudioData = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebCodecsAudioData.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebCodecsAudioData = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSWebCodecsAudioData::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSWebCodecsAudioData*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    visitor.reportExtraMemoryVisited(thisObject->wrapped().memoryCost());
}

DEFINE_VISIT_CHILDREN(JSWebCodecsAudioData);

size_t JSWebCodecsAudioData::estimatedSize(JSCell* cell, VM& vm)
{
    auto* thisObject = jsCast<JSWebCodecsAudioData*>(cell);
    return Base::estimatedSize(thisObject, vm) + thisObject->wrapped().memoryCost();
}

void JSWebCodecsAudioData::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebCodecsAudioData*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebCodecsAudioDataOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebCodecsAudioDataOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebCodecsAudioData = static_cast<JSWebCodecsAudioData*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebCodecsAudioData->wrapped(), jsWebCodecsAudioData);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebCodecsAudioData@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore18WebCodecsAudioDataE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebCodecsAudioData>&& impl)
{

    if constexpr (std::is_polymorphic_v<WebCodecsAudioData>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebCodecsAudioData@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore18WebCodecsAudioDataE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebCodecsAudioData has subclasses. If WebCodecsAudioData has subclasses that get passed
        // to toJS() we currently require WebCodecsAudioData you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<WebCodecsAudioData>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebCodecsAudioData& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebCodecsAudioData* JSWebCodecsAudioData::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebCodecsAudioData*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_CODECS)
