/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSViewTimelineOptions.h"

#include "JSCSSKeywordValue.h"
#include "JSCSSNumericValue.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSElement.h"
#include "JSScrollAxis.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <variant>


namespace WebCore {
using namespace JSC;

template<> ViewTimelineOptions convertDictionary<ViewTimelineOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    ViewTimelineOptions result;
    JSValue axisValue;
    if (isNullOrUndefined)
        axisValue = jsUndefined();
    else {
        axisValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "axis"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!axisValue.isUndefined()) {
        result.axis = convert<IDLEnumeration<ScrollAxis>>(lexicalGlobalObject, axisValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.axis = ScrollAxis::Block;
    JSValue insetValue;
    if (isNullOrUndefined)
        insetValue = jsUndefined();
    else {
        insetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "inset"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!insetValue.isUndefined()) {
        result.inset = convert<IDLUnion<IDLDOMString, IDLSequence<IDLUnion<IDLInterface<CSSNumericValue>, IDLInterface<CSSKeywordValue>>>>>(lexicalGlobalObject, insetValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.inset = "auto"_s;
    JSValue subjectValue;
    if (isNullOrUndefined)
        subjectValue = jsUndefined();
    else {
        subjectValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "subject"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!subjectValue.isUndefined()) {
        result.subject = convert<IDLInterface<Element>>(lexicalGlobalObject, subjectValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

} // namespace WebCore
